/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.dbaccess.Const;
import dm.jdbc.dbaccess.DBError;
import dm.jdbc.driver.DmdbColumn;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.driver.DmdbInfo;
import dm.jdbc.driver.DmdbResultSet;
import dm.jdbc.driver.DmdbStatement;
import dm.jdbc.util.StringUtil;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;

public class DmdbDatabaseMetaData
implements DatabaseMetaData {
    private DmdbConnection _$1222;
    private final String _$9987;
    int procedureResultUnknown = 0;
    int procedureNoResult = 1;
    int procedureReturnsResult = 2;
    int procedureColumnUnknown = 0;
    int procedureColumnIn = 1;
    int procedureColumnInOut = 2;
    int procedureColumnOut = 4;
    int procedureColumnReturn = 5;
    int procedureColumnResult = 3;
    int procedureNoNulls = 0;
    int procedureNullable = 1;
    int procedureNullableUnknown = 2;
    int columnNoNulls = 0;
    int columnNullable = 1;
    int columnNullableUnknown = 2;
    int bestRowTemporary = 0;
    int bestRowTransaction = 1;
    int bestRowSession = 2;
    int bestRowUnknown = 0;
    int bestRowNotPseudo = 1;
    int bestRowPseudo = 2;
    int versionColumnUnknown = 0;
    int versionColumnNotPseudo = 1;
    int versionColumnPseudo = 2;
    int importedKeyCascade = 0;
    int importedKeyRestrict = 1;
    int importedKeySetNull = 2;
    int importedKeyNoAction = 3;
    int importedKeySetDefault = 4;
    int importedKeyInitiallyDeferred = 5;
    int importedKeyInitiallyImmediate = 6;
    int importedKeyNotDeferrable = 7;
    int typeNoNulls = 0;
    int typeNullable = 1;
    int typeNullableUnknown = 2;
    int typePredNone = 0;
    int typePredChar = 1;
    int typePredBasic = 2;
    int typeSearchable = 3;
    short tableIndexStatistic = 0;
    short tableIndexClustered = 1;
    short tableIndexHashed = (short)2;
    short tableIndexOther = (short)3;
    short attributeNoNulls = 0;
    short attributeNullable = 1;
    short attributeNullableUnknown = (short)2;
    int XOpen = 1;
    int sqlStateSQL99 = 2;

    public DmdbDatabaseMetaData(DmdbConnection conn) {
        this._$1222 = conn;
        this._$9987 = new String("!");
    }

    public boolean allProceduresAreCallable() throws SQLException {
        return true;
    }

    public boolean allTablesAreSelectable() throws SQLException {
        return true;
    }

    public String getURL() throws SQLException {
        return this._$1222.getURL();
    }

    public String getUserName() throws SQLException {
        return this._$1222.getUserName();
    }

    public boolean isReadOnly() throws SQLException {
        return this._$1222.isReadOnly();
    }

    public boolean nullsAreSortedHigh() throws SQLException {
        return false;
    }

    public boolean nullsAreSortedLow() throws SQLException {
        return true;
    }

    public boolean nullsAreSortedAtStart() throws SQLException {
        return false;
    }

    public boolean nullsAreSortedAtEnd() throws SQLException {
        return false;
    }

    public String getDatabaseProductName() throws SQLException {
        return "DM DBMS";
    }

    public String getDatabaseProductVersion() throws SQLException {
        return this._$1222.getDmServerVersion();
    }

    public String getDriverName() throws SQLException {
        return "dm.jdbc.driver.DmDriver";
    }

    public String getDriverVersion() throws SQLException {
        String s = "3.0";
        s = s + ".6.0.2.62 (Build 2010.04.09)";
        return s;
    }

    public int getDriverMajorVersion() {
        return 3;
    }

    public int getDriverMinorVersion() {
        return 0;
    }

    public boolean usesLocalFiles() throws SQLException {
        return false;
    }

    public boolean usesLocalFilePerTable() throws SQLException {
        return false;
    }

    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesUpperCaseIdentifiers() throws SQLException {
        return true;
    }

    public boolean storesLowerCaseIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        return true;
    }

    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        return true;
    }

    public String getIdentifierQuoteString() throws SQLException {
        return "\"";
    }

    public String getSQLKeywords() throws SQLException {
        StringBuffer sql = new StringBuffer("");
        sql.append("BREAK,BROWSE,BULK,BOOLEAN,CHECKPOINT,CLUSTERED,COMMITTED,COMPUTE,");
        sql.append(" CONFIRM,CONTROLROW,DATABASE,DBCC,DISK,DISTRIBUTED,DUMMY,");
        sql.append(" DUMP,ERRLVL,ERROREXIT,EXIT,FILE,FILLFACTOR,FLOPPY,HOLDLOCK,");
        sql.append(" IDENTITY_INSERT,IDENTITYCOL,IF,KILL,LINENO,LOAD,MIRROREXIT,");
        sql.append("NONCLUSTERED,OFF,OFFSETS,ONCE,OVER,PERCENT,PERM,PERMANENT,PLAN, PRINT,");
        sql.append("AFTER,ASSIGN,AUDIT,BEFORE,BITMAP,BOOLEAN,CACHE,CALL,CHAIN,CLUSTER,CYCLE,");
        sql.append(" DATABASE, DATAFILE, DEBUG, #DECODE, #DELETING, DISABLE,");
        sql.append(" EACH,ELSEIF,END,EXCLUSIVE, EXIT,FILLFACTOR, FUNCTION,");
        sql.append(" HEXTORAW,IDENTIFIED,IF, IFNULL,INCREASE, INDEX, ");
        sql.append(" INITIAL,INTENTION,ISNULL,ISOPEN,MAXVALUE,");
        sql.append(" MINVALUE,MODIFY,NATURAL,NEW, NEXT, NOAUDIT, NOCACHE,NOCYCLE,");
        sql.append(" NOTFOUND,  NVL, OFF, OLD, OUT,PENDANT, PERCENT, PRINT, PRIOR,");
        sql.append("RAISE,RAWTOHEX,READ,RENAME,RETURN,REVERSE,ROLE,ROWCOUNT,ROWNUM,SAVEPOINT,SERIALIZABLE,");
        sql.append(" SEQUENCE, SHARE, STATEMENT,TIES, TIMESTAMPADD, TIMESTAMPDIFF,");
        sql.append("TOP,TRIGGER,TRIGGERS,TRUNCATE,TYPECAST,UNCOMMITED,UNTIL,VSIZE,WHILE,LOGIN,");
        sql.append("EXTERNALLY,SESSION_PER_USER,CONNECT_IDLE_TIME,FAILED_LOGIN_ATTEMPS,");
        sql.append("PASSWORD_LIFE_TIME,PASSWORD_REUSE_TIME,PASSWORD_REUSE_MAX,");
        sql.append("PASSWORD_LOCK_TIME,PASSWORD_GRACE_TIME,POLICY,CATEGORY,UNLIMITED");
        return sql.toString();
    }

    public String getNumericFunctions() throws SQLException {
        return "ABS,ACOS,ASIN,ATAN,ATAN2,CEILING,COS,COT,DEGREES,EXP,FLOOR,LOG,LOG10,MOD,PI,POWER,RADIANS,RAND,ROUND,SIGN,SIN,SQRT,TAN,TRUNCATE,CEIL,COSH,LN,SINH,TANH";
    }

    public String getStringFunctions() throws SQLException {
        return "ASCII,CHAR,CONCAT,DIFFERENCE,INSERT,LCASE,LEFT,LENGTH,LOCATE,LTRIM,REPEAT,REPLACE,RIGHT,RTRIM,SOUNDEX,SPACE,UCASE,BIT_LENGTH,CHAR_LENGTH,CHARACTER_LENGTH,CHR,INITCAP,INSSTR,INSTR,INSTRB,LEFTSTR,LENGTHB,OCTET_LENGTH,LOWER,LPAD,POSITION,REPEATSTR,REVERSE,RIGHTSTR,RPAD,SUBSTR,SUBSTRB,TO_CHAR,TRANSLATE,TRIM,UPPER";
    }

    public String getSystemFunctions() throws SQLException {
        return "DATABASE,IFNULL,USERCUR_DATABASE,DBID,EXTENT,PAGE,SESSID,UID,TABLEDEF,VSIZE,SET_TABLE_OPTION,SET_INDEX_OPTION,CFALGORITHMSENCRYPT,CFALGORITHMSDECRYPT,BFALGORITHMSENCRYPT,BFALGORITHMSDECRYPT,LABEL_TO_CHAR,LABEL_FROM_CHAR,LABEL_CMP,LABEL_STR_CMP";
    }

    public String getTimeDateFunctions() throws SQLException {
        return "CURDATE,CURTIME,DAYNAME,DAYOFMONTH,DAYOFWEEK,DAYOFYEAR,HOUR,MINUTE,MONTH,MONTHNAME,NOW,QUARTER,SECOND,TIMESTAMPADD,TIMESTAMPDIFF,WEEK,YEAR,ADD_DAYS,ADD_MONTHS,ADD_WEEKS,CURRENT_DATE,CURRENT_TIME,CURRENT_TIMESTAMP,DATEADD,DATEDIFF,DATEPART,DAYS_BETWEEN,EXTRACT,GETDATE,LAST_DAY,MONTHS_BETWEEN,NEXT_DAY,ROUND,SYSDATE,TO_DATE,TRUNC,WEEKDAY,YEARS_BETWEEN";
    }

    public String getSearchStringEscape() throws SQLException {
        return this._$9987;
    }

    public String getExtraNameCharacters() throws SQLException {
        return "";
    }

    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        return true;
    }

    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        return true;
    }

    public boolean supportsColumnAliasing() throws SQLException {
        return true;
    }

    public boolean nullPlusNonNullIsNull() throws SQLException {
        return true;
    }

    public boolean supportsConvert() throws SQLException {
        return true;
    }

    public boolean supportsConvert(int fromType, int toType) throws SQLException {
        boolean supportsconvert = false;
        if (toType == 91) {
            switch (fromType) {
                case -1: 
                case 1: 
                case 12: 
                case 91: 
                case 2005: {
                    supportsconvert = true;
                    break;
                }
            }
        }
        if (toType == 3 || toType == 2 || toType == -6 || toType == 4 || toType == 6 || toType == 8 || toType == 7 || toType == 5 || toType == -5 || toType == 1 || toType == 12 || toType == -7 || toType == 16 || toType == -1) {
            switch (fromType) {
                case -7: 
                case -6: 
                case -5: 
                case -1: 
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 12: 
                case 16: {
                    supportsconvert = true;
                    break;
                }
            }
            return supportsconvert;
        }
        if (toType == 91) {
            switch (fromType) {
                case -1: 
                case 0: 
                case 1: 
                case 12: 
                case 91: 
                case 93: 
                case 2005: {
                    supportsconvert = true;
                    break;
                }
            }
            return supportsconvert;
        }
        if (toType == 92) {
            switch (fromType) {
                case -1: 
                case 0: 
                case 1: 
                case 12: 
                case 92: 
                case 93: 
                case 2005: {
                    supportsconvert = true;
                    break;
                }
            }
            return supportsconvert;
        }
        if (toType == 93) {
            switch (fromType) {
                case -1: 
                case 0: 
                case 1: 
                case 12: 
                case 91: 
                case 92: 
                case 93: 
                case 2005: {
                    supportsconvert = true;
                    break;
                }
            }
            return supportsconvert;
        }
        if (toType == 2004) {
            switch (fromType) {
                case -4: 
                case 2004: {
                    supportsconvert = true;
                    break;
                }
            }
            return supportsconvert;
        }
        if (toType == 2005) {
            switch (fromType) {
                case -1: 
                case 2005: {
                    supportsconvert = true;
                    break;
                }
            }
            return supportsconvert;
        }
        return supportsconvert;
    }

    public boolean supportsTableCorrelationNames() throws SQLException {
        return true;
    }

    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        return true;
    }

    public boolean supportsExpressionsInOrderBy() throws SQLException {
        return true;
    }

    public boolean supportsOrderByUnrelated() throws SQLException {
        return true;
    }

    public boolean supportsGroupBy() throws SQLException {
        return true;
    }

    public boolean supportsGroupByUnrelated() throws SQLException {
        return true;
    }

    public boolean supportsGroupByBeyondSelect() throws SQLException {
        return true;
    }

    public boolean supportsLikeEscapeClause() throws SQLException {
        return true;
    }

    public boolean supportsMultipleResultSets() throws SQLException {
        return false;
    }

    public boolean supportsMultipleTransactions() throws SQLException {
        return true;
    }

    public boolean supportsNonNullableColumns() throws SQLException {
        return true;
    }

    public boolean supportsMinimumSQLGrammar() throws SQLException {
        return true;
    }

    public boolean supportsCoreSQLGrammar() throws SQLException {
        return true;
    }

    public boolean supportsExtendedSQLGrammar() throws SQLException {
        return true;
    }

    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        return true;
    }

    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        return true;
    }

    public boolean supportsANSI92FullSQL() throws SQLException {
        return false;
    }

    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        return true;
    }

    public boolean supportsOuterJoins() throws SQLException {
        return true;
    }

    public boolean supportsFullOuterJoins() throws SQLException {
        return true;
    }

    public boolean supportsLimitedOuterJoins() throws SQLException {
        return true;
    }

    public String getSchemaTerm() throws SQLException {
        return "SCHEMA";
    }

    public String getProcedureTerm() throws SQLException {
        return "PROCEDURE";
    }

    public String getCatalogTerm() throws SQLException {
        return "CATALOG";
    }

    public boolean isCatalogAtStart() throws SQLException {
        return true;
    }

    public String getCatalogSeparator() throws SQLException {
        return ".";
    }

    public boolean supportsSchemasInDataManipulation() throws SQLException {
        return true;
    }

    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        return true;
    }

    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        return true;
    }

    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        return true;
    }

    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        return true;
    }

    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        return true;
    }

    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        return true;
    }

    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        return true;
    }

    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        return true;
    }

    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        return true;
    }

    public boolean supportsPositionedDelete() throws SQLException {
        return true;
    }

    public boolean supportsPositionedUpdate() throws SQLException {
        return true;
    }

    public boolean supportsSelectForUpdate() throws SQLException {
        return true;
    }

    public boolean supportsStoredProcedures() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInComparisons() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInExists() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInIns() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        return true;
    }

    public boolean supportsCorrelatedSubqueries() throws SQLException {
        return true;
    }

    public boolean supportsUnion() throws SQLException {
        return true;
    }

    public boolean supportsUnionAll() throws SQLException {
        return true;
    }

    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        return true;
    }

    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        return true;
    }

    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        return true;
    }

    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        return true;
    }

    public int getMaxBinaryLiteralLength() throws SQLException {
        return Integer.MAX_VALUE;
    }

    public int getMaxCharLiteralLength() throws SQLException {
        return this._$1222.maxRowSize;
    }

    public int getMaxColumnNameLength() throws SQLException {
        return 128;
    }

    public int getMaxColumnsInGroupBy() throws SQLException {
        return 64;
    }

    public int getMaxColumnsInIndex() throws SQLException {
        return 16;
    }

    public int getMaxColumnsInOrderBy() throws SQLException {
        return 64;
    }

    public int getMaxColumnsInSelect() throws SQLException {
        return 1024;
    }

    public int getMaxColumnsInTable() throws SQLException {
        return 1024;
    }

    public int getMaxConnections() throws SQLException {
        return 256;
    }

    public int getMaxCursorNameLength() throws SQLException {
        return 128;
    }

    public int getMaxIndexLength() throws SQLException {
        return 1020;
    }

    public int getMaxSchemaNameLength() throws SQLException {
        return 128;
    }

    public int getMaxProcedureNameLength() throws SQLException {
        return 128;
    }

    public int getMaxCatalogNameLength() throws SQLException {
        return 128;
    }

    public int getMaxRowSize() throws SQLException {
        return 0;
    }

    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        return false;
    }

    public int getMaxStatementLength() throws SQLException {
        return 8000;
    }

    public int getMaxStatements() throws SQLException {
        return 128;
    }

    public int getMaxTableNameLength() throws SQLException {
        return 128;
    }

    public int getMaxTablesInSelect() throws SQLException {
        return 50;
    }

    public int getMaxUserNameLength() throws SQLException {
        return 128;
    }

    public int getDefaultTransactionIsolation() throws SQLException {
        return 2;
    }

    public boolean supportsTransactions() throws SQLException {
        return true;
    }

    public boolean supportsTransactionIsolationLevel(int level) throws SQLException {
        return level == 2 || level == 1 || level == 4 || level == 8;
    }

    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        return !this._$1222.getDDL_Autocommit();
    }

    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        return this._$1222.getDDL_Autocommit();
    }

    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        return this._$1222.getDDL_Autocommit();
    }

    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        return !this._$1222.getDDL_Autocommit();
    }

    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        if (catalog != null && catalog.equals("")) {
            throw new SQLException("There is not a procedure without a catalog!");
        }
        if (schemaPattern != null && schemaPattern.equals("")) {
            throw new SQLException("There is not a procedure without a schema!");
        }
        if (procedureNamePattern != null && procedureNamePattern.equals("")) {
            return null;
        }
        String catalog2 = catalog == null ? this._$1222.getCatalog() : catalog.trim();
        String schemaname = schemaPattern == null ? "%" : schemaPattern;
        String procname = procedureNamePattern == null ? "%" : procedureNamePattern;
        String db = "\"" + StringUtil.getEscObjName(catalog2) + "\"";
        String db2 = StringUtil.getEscStringName(catalog2);
        String sch2 = StringUtil.getEscStringName(schemaname);
        String proc2 = StringUtil.getEscStringName(procname);
        String proc_clause = null;
        proc_clause = this._$10007(procname) ? " like '" + proc2 + "' escape " + "'" + this._$9987 + "' " : " = '" + proc2 + "' ";
        StringBuffer sql = new StringBuffer("");
        if (this._$10007(schemaname)) {
            sql.append("SELECT DISTINCT '");
            sql.append(db2);
            sql.append("' AS PROCEDURE_CAT,USERS.NAME AS PROCEDURE_SCHEM,PROCS.SQLNAME AS PROCEDURE_NAME,'RESERVED1' AS RESERVED1,'RESERVED2' AS RESERVED2,'RESERVED3' AS RESERVED3,NULL AS REMARKS,CASE PROCS.TYPE WHEN 'I' THEN 1 WHEN 'O' THEN 2 ELSE 0 END AS PROCEDURE_TYPE");
            sql.append(" FROM ");
            sql.append(db);
            sql.append(".SYSDBA.SYSSCHEMAS USERS,");
            sql.append(db);
            sql.append(".SYSDBA.SYSPROCS PROCS WHERE USERS.NAME LIKE '");
            sql.append(sch2);
            sql.append("' escape ");
            sql.append("'");
            sql.append(this._$9987);
            sql.append("' ");
            sql.append("AND PROCS.NAME ");
            sql.append(proc_clause);
            sql.append(" AND USERS.SCHID = PROCS.SCHID");
            sql.append(" ORDER BY PROCEDURE_SCHEM ASC,PROCEDURE_NAME ASC;");
        } else {
            sql.append("SELECT DISTINCT '");
            sql.append(db2);
            sql.append("' AS PROCEDURE_CAT,'");
            sql.append(sch2);
            sql.append("' AS PROCEDURE_SCHEM,PROCS.SQLNAME AS PROCEDURE_NAME,'RESERVED1' AS RESERVED1,'RESERVED2' AS RESERVED2,'RESERVED3' AS RESERVED3,NULL AS REMARKS,CASE PROCS.TYPE WHEN 'I' THEN 1 WHEN 'O' THEN 2 ELSE 0 END AS PROCEDURE_TYPE");
            sql.append(" FROM ");
            sql.append(db);
            sql.append(".SYSDBA.SYSPROCS PROCS WHERE PROCS.NAME ");
            sql.append(proc_clause);
            sql.append(" AND PROCS.SCHID = (SELECT SCHID FROM ");
            sql.append(db);
            sql.append(".SYSDBA.SYSSCHEMAS WHERE NAME = '");
            sql.append(sch2);
            sql.append("')");
            sql.append(" ORDER BY PROCEDURE_SCHEM ASC,PROCEDURE_NAME ASC;");
        }
        DmdbStatement stmt = null;
        DmdbResultSet rs = null;
        stmt = (DmdbStatement)this._$1222.createStatement(1003, 1007, 1);
        rs = (DmdbResultSet)stmt.executeQuery(sql.toString(), 1);
        stmt.close();
        return rs;
    }

    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        if (catalog != null && catalog.equals("")) {
            throw new SQLException("There is not a procedure without a catalog!");
        }
        if (schemaPattern != null && schemaPattern.equals("")) {
            throw new SQLException("There is not a procedure without a schema!");
        }
        if (procedureNamePattern != null && procedureNamePattern.equals("") || columnNamePattern != null && columnNamePattern.equals("")) {
            return null;
        }
        String catalog2 = catalog == null ? this._$1222.getCatalog() : catalog.trim();
        String schemaname = schemaPattern == null ? "%" : schemaPattern;
        String procname = procedureNamePattern == null ? "%" : procedureNamePattern;
        String colname = columnNamePattern == null ? "%" : columnNamePattern;
        String db = "\"" + StringUtil.getEscObjName(catalog2) + "\"";
        String db2 = StringUtil.getEscStringName(catalog2);
        String sch2 = StringUtil.getEscStringName(schemaname);
        String proc2 = StringUtil.getEscStringName(procname);
        String col2 = StringUtil.getEscStringName(colname);
        String column_clause = null;
        column_clause = this._$10007(colname) ? " like '" + col2 + "' escape " + "'" + this._$9987 + "' " : " = '" + col2 + "' ";
        String sql = new String("");
        if (this._$10007(schemaname)) {
            sql = sql + "SELECT DISTINCT '" + db2 + "' AS PROCEDURE_CAT,USERS.NAME AS PROCEDURE_SCHEM,PROCS.NAME AS PROCEDURE_NAME,ARG.NAME AS COLUMN_NAME,CASE ARG.TYPE WHEN 'O ' THEN 4 WHEN 'I ' THEN 1 WHEN 'IO' THEN 2 WHEN 'R ' THEN 5 END AS COLUMN_TYPE,GET_DATA_TYPE(ARG.DTYPE, CAST (ARG.SCALE AS INT), 3) AS DATA_TYPE,ARG.DTYPE AS TYPE_NAME,CASE GET_COLUMN_SIZE(ARG.DTYPE, CAST (ARG.LENGTH AS INT), CAST (ARG.SCALE AS INT)) WHEN -2 THEN NULL ELSE GET_COLUMN_SIZE(ARG.TYPE, CAST (ARG.LENGTH AS INT), CAST (ARG.SCALE AS INT)) END AS \"PRECISION\",CASE GET_BUFFER_LEN(ARG.DTYPE, CAST (ARG.LENGTH AS INT), CAST (ARG.SCALE AS INT)) WHEN -2 THEN NULL ELSE GET_BUFFER_LEN(ARG.DTYPE, CAST (ARG.LENGTH AS INT), CAST (ARG.SCALE AS INT)) END AS LENGTH,CASE GET_DECIMAL_DIGITS(ARG.DTYPE, CAST (ARG.SCALE AS INT)) WHEN -2 THEN NULL ELSE GET_DECIMAL_DIGITS(ARG.DTYPE, CAST (ARG.SCALE AS INT)) END AS SCALE,10 AS RADIX,1 AS NULLABLE,NULL AS REMARKS";
            sql = sql + " FROM " + db + ".SYSDBA.SYSSCHEMAS USERS," + db + ".SYSDBA.SYSPROCS PROCS," + db + ".SYSDBA.SYSARGS ARG";
            sql = sql + " WHERE USERS.NAME LIKE '" + sch2 + "' escape " + "'" + this._$9987 + "' " + "AND PROCS.NAME LIKE '" + proc2 + "' escape " + "'" + this._$9987 + "' " + " AND ARG.NAME " + column_clause + " AND USERS.SCHID = PROCS.SCHID AND PROCS.ID = ARG.PFID";
        } else {
            sql = sql + "SELECT DISTINCT '" + db2 + "' AS PROCEDURE_CAT,'" + sch2 + "' AS PROCEDURE_SCHEM,PROCS.NAME AS PROCEDURE_NAME,ARG.NAME AS COLUMN_NAME,CASE ARG.TYPE WHEN 'O ' THEN 4 WHEN 'I ' THEN 1 WHEN 'IO' THEN 2 WHEN 'R ' THEN 5 END AS COLUMN_TYPE,GET_DATA_TYPE(ARG.DTYPE, CAST (ARG.SCALE AS INT), 3) AS DATA_TYPE,ARG.DTYPE AS TYPE_NAME,CASE GET_COLUMN_SIZE(ARG.DTYPE, CAST (ARG.LENGTH AS INT), CAST (ARG.SCALE AS INT)) WHEN -2 THEN NULL ELSE GET_COLUMN_SIZE(ARG.TYPE, CAST (ARG.LENGTH AS INT), CAST (ARG.SCALE AS INT)) END AS \"PRECISION\",CASE GET_BUFFER_LEN(ARG.DTYPE, CAST (ARG.LENGTH AS INT), CAST (ARG.SCALE AS INT)) WHEN -2 THEN NULL ELSE GET_BUFFER_LEN(ARG.DTYPE, CAST (ARG.LENGTH AS INT), CAST (ARG.SCALE AS INT)) END AS LENGTH,CASE GET_DECIMAL_DIGITS(ARG.DTYPE, CAST (ARG.SCALE AS INT)) WHEN -2 THEN NULL ELSE GET_DECIMAL_DIGITS(ARG.DTYPE, CAST (ARG.SCALE AS INT)) END AS SCALE,10 AS RADIX,1 AS NULLABLE,NULL AS REMARKS";
            sql = sql + " FROM " + db + ".SYSDBA.SYSPROCS PROCS," + db + ".SYSDBA.SYSARGS ARG";
            sql = sql + " WHERE PROCS.NAME = '" + proc2 + "' AND ARG.NAME " + column_clause + " AND PROCS.SCHID = (SELECT SCHID FROM " + db + ".SYSDBA.SYSSCHEMAS WHERE NAME = '" + sch2 + "') AND PROCS.ID = ARG.PFID";
        }
        if (colname == "") {
            sql = sql + " AND ARG.NAME = 'RVAL'";
        }
        sql = sql + " ORDER BY PROCEDURE_SCHEM ASC,PROCEDURE_NAME ASC;";
        DmdbStatement stmt = null;
        DmdbResultSet rs = null;
        stmt = (DmdbStatement)this._$1222.createStatement(1003, 1007, 1);
        rs = (DmdbResultSet)stmt.executeQuery(sql, 1);
        stmt.close();
        return rs;
    }

    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        if (catalog != null && catalog.equals("")) {
            throw new SQLException("There is not a table without a catalog!");
        }
        if (schemaPattern != null && schemaPattern.equals("")) {
            throw new SQLException("There is not a table without a schema!");
        }
        if (tableNamePattern != null && tableNamePattern.equals("")) {
            return null;
        }
        String catalog2 = catalog == null ? this._$1222.getCatalog() : catalog.trim();
        String schemaname = schemaPattern == null ? "%" : schemaPattern;
        String procname = tableNamePattern == null ? "%" : tableNamePattern;
        String db = "\"" + StringUtil.getEscObjName(catalog2) + "\"";
        String db2 = StringUtil.getEscStringName(catalog2);
        String sch2 = StringUtil.getEscStringName(schemaname);
        String proc2 = StringUtil.getEscStringName(procname);
        String selNotSysT = " AND (TAB.TYPE = 'U' OR TAB.TYPE = 'R' OR TAB.TYPE = 'H' OR (TAB.TYPE = 'V' AND TAB.NAME NOT LIKE '%DMBLOB'))";
        String selNotSysV = " AND VIEWS.TYPE = 'U'";
        int typeLen = 0;
        if (types != null) {
            typeLen = types.length;
        }
        String table_clause = null;
        table_clause = this._$10007(procname) ? " like '" + proc2 + "' escape " + "'" + this._$9987 + "' " : " = '" + proc2 + "' ";
        String sql = new String("");
        if (typeLen == 0 || typeLen == 2) {
            if (this._$10007(schemaname)) {
                sql = sql + "SELECT DISTINCT '" + db2 + "' AS TABLE_CAT,USERS.NAME AS TABLE_SCHEM,TAB.NAME AS TABLE_NAME,TAB.TYPE AS TABLE_TYPE,NULL AS REMARKS,NULL AS TYPE_CAT,NULL AS TYPE_SCHEM,NULL AS TYPE_NAME,NULL AS SELF_REFERENCING_COL_NAME,NULL AS REF_GENERATION";
                sql = sql + " FROM " + db + ".SYSDBA.SYSSCHEMAS USERS," + db + ".SYSDBA.SYSTABLES TAB WHERE USERS.NAME LIKE '" + sch2 + "' escape " + "'" + this._$9987 + "' " + "AND TAB.NAME " + table_clause + " AND USERS.SCHID = TAB.SCHID" + selNotSysT;
                sql = sql + " UNION SELECT DISTINCT '" + db2 + "' AS TABLE_CATA,USERS.NAME AS TABLE_SCHEM,VIEWS.NAME AS TABLE_NAME,VIEWS.TYPE AS TABLE_TYPE,NULL AS REMARKS,NULL AS TYPE_CAT,NULL AS TYPE_SCHEM,NULL AS TYPE_NAME,NULL AS SELF_REFERENCING_COL_NAME,NULL AS REF_GENERATION";
                sql = sql + " FROM " + db + ".SYSDBA.SYSSCHEMAS USERS," + db + ".SYSDBA.SYSVIEWS VIEWS WHERE USERS.NAME LIKE '" + sch2 + "' escape " + "'" + this._$9987 + "' " + "AND VIEWS.NAME " + table_clause + " AND USERS.SCHID = VIEWS.SCHID" + selNotSysV;
                sql = sql + " ORDER BY TABLE_TYPE ASC,TABLE_SCHEM ASC,TABLE_NAME ASC;";
            } else {
                sql = sql + "SELECT DISTINCT '" + db2 + "' AS TABLE_CAT,'" + sch2 + "' AS TABLE_SCHEM,TAB.NAME AS TABLE_NAME,TAB.TYPE AS TABLE_TYPE,NULL AS REMARKS,NULL AS TYPE_CAT,NULL AS TYPE_SCHEM,NULL AS TYPE_NAME,NULL AS SELF_REFERENCING_COL_NAME,NULL AS REF_GENERATION";
                sql = sql + " FROM " + db + ".SYSDBA.SYSTABLES TAB WHERE TAB.NAME " + table_clause + " AND TAB.SCHID = (SELECT SCHID FROM " + db + ".SYSDBA.SYSSCHEMAS WHERE NAME = '" + sch2 + "') " + selNotSysT;
                sql = sql + " UNION SELECT DISTINCT '" + db2 + "' AS TABLE_CATA,'" + sch2 + "' AS TABLE_SCHEM,VIEWS.NAME AS TABLE_NAME,VIEWS.TYPE AS TABLE_TYPE,NULL AS REMARKS,NULL AS TYPE_CAT,NULL AS TYPE_SCHEM,NULL AS TYPE_NAME,NULL AS SELF_REFERENCING_COL_NAME,NULL AS REF_GENERATION";
                sql = sql + " FROM " + db + ".SYSDBA.SYSVIEWS VIEWS WHERE VIEWS.NAME " + table_clause + " AND VIEWS.SCHID = (SELECT SCHID FROM " + db + ".SYSDBA.SYSSCHEMAS WHERE NAME = '" + sch2 + "') " + selNotSysV;
                sql = sql + " ORDER BY TABLE_TYPE ASC,TABLE_SCHEM ASC,TABLE_NAME ASC;";
            }
        } else if (types[0].equalsIgnoreCase("TABLE")) {
            if (this._$10007(schemaname)) {
                sql = sql + "SELECT DISTINCT '" + catalog2 + "' AS TABLE_CAT,USERS.NAME AS TABLE_SCHEM,TAB.NAME AS TABLE_NAME,TAB.TYPE AS TABLE_TYPE,NULL AS REMARKS,NULL AS TYPE_CAT,NULL AS TYPE_SCHEM,NULL AS TYPE_NAME,NULL AS SELF_REFERENCING_COL_NAME,NULL AS REF_GENERATION";
                sql = sql + " FROM " + db + ".SYSDBA.SYSSCHEMAS USERS," + db + ".SYSDBA.SYSTABLES TAB WHERE USERS.NAME LIKE '" + sch2 + "' escape " + "'" + this._$9987 + "' " + "AND TAB.NAME " + table_clause + " AND USERS.SCHID = TAB.SCHID" + selNotSysT;
                sql = sql + " ORDER BY TABLE_TYPE ASC,TABLE_SCHEM ASC,TABLE_NAME ASC;";
            } else {
                sql = sql + "SELECT DISTINCT '" + db2 + "' AS TABLE_CAT,'" + sch2 + "' AS TABLE_SCHEM,TAB.NAME AS TABLE_NAME,TAB.TYPE AS TABLE_TYPE,NULL AS REMARKS,NULL AS TYPE_CAT,NULL AS TYPE_SCHEM,NULL AS TYPE_NAME,NULL AS SELF_REFERENCING_COL_NAME,NULL AS REF_GENERATION";
                sql = sql + " FROM " + db + ".SYSDBA.SYSTABLES TAB WHERE TAB.NAME " + table_clause + " AND TAB.SCHID = (SELECT SCHID FROM " + db + ".SYSDBA.SYSSCHEMAS WHERE NAME = '" + sch2 + "') " + selNotSysT;
                sql = sql + " ORDER BY TABLE_TYPE ASC,TABLE_SCHEM ASC,TABLE_NAME ASC;";
            }
        } else if (types[0].equalsIgnoreCase("VIEW")) {
            if (this._$10007(schemaname)) {
                sql = sql + "SELECT DISTINCT '" + db2 + "' AS TABLE_CAT,USERS.NAME AS TABLE_SCHEM,VIEWS.NAME AS TABLE_NAME,VIEWS.TYPE AS TABLE_TYPE,NULL AS REMARKS,NULL AS TYPE_CAT,NULL AS TYPE_SCHEM,NULL AS TYPE_NAME,NULL AS SELF_REFERENCING_COL_NAME,NULL AS REF_GENERATION";
                sql = sql + " FROM " + db + ".SYSDBA.SYSSCHEMAS USERS," + db + ".SYSDBA.SYSVIEWS VIEWS WHERE USERS.NAME LIKE '" + sch2 + "' escape " + "'" + this._$9987 + "' " + "AND VIEWS.NAME " + table_clause + " AND USERS.SCHID = VIEWS.SCHID" + selNotSysV;
                sql = sql + " ORDER BY TABLE_TYPE ASC,TABLE_SCHEM ASC,TABLE_NAME ASC;";
            } else {
                sql = sql + "SELECT DISTINCT '" + db2 + "' AS TABLE_CAT,'" + sch2 + "' AS TABLE_SCHEM,VIEWS.NAME AS TABLE_NAME,VIEWS.TYPE AS TABLE_TYPE,NULL AS REMARKS,NULL AS TYPE_CAT,NULL AS TYPE_SCHEM,NULL AS TYPE_NAME,NULL AS SELF_REFERENCING_COL_NAME,NULL AS REF_GENERATION";
                sql = sql + " FROM " + db + ".SYSDBA.SYSVIEWS VIEWS WHERE VIEWS.NAME " + table_clause + " AND VIEWS.SCHID = (SELECT SCHID FROM " + db + ".SYSDBA.SYSSCHEMAS WHERE NAME = '" + sch2 + "') " + selNotSysV;
                sql = sql + " ORDER BY TABLE_TYPE ASC,TABLE_SCHEM ASC,TABLE_NAME ASC;";
            }
        } else {
            DBError.throwSQLException(Const.res.getString("error.getTable.type"));
        }
        DmdbStatement stmt = null;
        DmdbResultSet rs = null;
        stmt = (DmdbStatement)this._$1222.createStatement(1003, 1007, 1);
        rs = (DmdbResultSet)stmt.executeQuery(sql, 1);
        stmt.close();
        return rs;
    }

    public ResultSet getSchemas() throws SQLException {
        String cata = this._$1222.getCatalog();
        String db = "\"" + StringUtil.getEscObjName(cata) + "\"";
        String db2 = StringUtil.getEscStringName(cata);
        String sql = new String("SELECT DISTINCT USERS.NAME AS TABLE_SCHEM, '" + db2 + "' AS TABLE_CATALOG");
        sql = sql + " FROM " + db + ".SYSDBA.SYSSCHEMAS USERS";
        sql = sql + " ORDER BY TABLE_SCHEM ASC;";
        DmdbStatement stmt = null;
        DmdbResultSet rs = null;
        stmt = (DmdbStatement)this._$1222.createStatement(1003, 1007, 1);
        rs = (DmdbResultSet)stmt.executeQuery(sql, 1);
        stmt.close();
        return rs;
    }

    public ResultSet getCatalogs() throws SQLException {
        String sql = "SELECT DISTINCT NAME AS TABLE_CAT FROM SYSTEM.SYSDBA.SYSDATABASES ORDER BY TABLE_CAT ASC;";
        DmdbStatement stmt = null;
        DmdbResultSet rs = null;
        stmt = (DmdbStatement)this._$1222.createStatement(1003, 1007, 1);
        rs = (DmdbResultSet)stmt.executeQuery(sql, 1);
        stmt.close();
        return rs;
    }

    public ResultSet getTableTypes() throws SQLException {
        String sql = "(SELECT 'SYSTEM TABLE' AS TABLE_TYPE FROM SYSTEM.SYSDBA.SYSDUAL UNION SELECT 'TABLE' AS TABLE_TYPE FROM SYSTEM.SYSDBA.SYSDUAL) UNION SELECT 'VIEW' AS TABLE_TYPE FROM SYSTEM.SYSDBA.SYSDUAL ";
        DmdbStatement stmt = null;
        DmdbResultSet rs = null;
        stmt = (DmdbStatement)this._$1222.createStatement();
        rs = (DmdbResultSet)stmt.executeQuery(sql, 1);
        stmt.close();
        return rs;
    }

    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        if (catalog != null && catalog.equals("")) {
            throw new SQLException("There is not a table without a catalog!");
        }
        if (schemaPattern != null && schemaPattern.equals("")) {
            throw new SQLException("There is not a table without a schema!");
        }
        if (tableNamePattern != null && tableNamePattern.equals("") || columnNamePattern != null && columnNamePattern.equals("")) {
            return null;
        }
        String catalog2 = catalog == null ? this._$1222.getCatalog() : catalog.trim();
        String schemaname = schemaPattern == null ? "%" : schemaPattern;
        String tablename = tableNamePattern == null ? "%" : tableNamePattern;
        String columnname = columnNamePattern == null ? "%" : columnNamePattern;
        String db = "\"" + StringUtil.getEscObjName(catalog2) + "\"";
        String db2 = StringUtil.getEscStringName(catalog2);
        String sch2 = StringUtil.getEscStringName(schemaname);
        String tab2 = StringUtil.getEscStringName(tablename);
        String col2 = StringUtil.getEscStringName(columnname);
        String column_clause = null;
        String table_clause = null;
        table_clause = this._$10007(tablename) ? " like '" + tab2 + "' escape " + "'" + this._$9987 + "' " : " = '" + tab2 + "' ";
        column_clause = this._$10007(columnname) ? " like '" + col2 + "' escape " + "'" + this._$9987 + "' " : " = '" + col2 + "' ";
        String sql = new String("");
        if (this._$10007(schemaname)) {
            sql = sql + "SELECT DISTINCT '" + db2 + "' AS TABLE_CAT,USERS.NAME AS TABLE_SCHEM,TAB.NAME AS TABLE_NAME,COLS.NAME AS COLUMN_NAME,CASE COLS.TYPE WHEN 'CLOB' THEN 2005 WHEN 'BLOB' THEN 2004 ELSE GET_DATA_TYPE(COLS.TYPE, CAST(COLS.SCALE AS INT), 3) END AS DATA_TYPE,COLS.TYPE AS TYPE_NAME,CASE GET_COLUMN_SIZE(COLS.TYPE, CAST (COLS.LENGTH AS INT), CAST (COLS.SCALE AS INT)) WHEN -2 THEN NULL ELSE GET_COLUMN_SIZE(COLS.TYPE, CAST (COLS.LENGTH AS INT), CAST (COLS.SCALE AS INT)) END AS COLUMN_SIZE,CASE GET_BUFFER_LEN(COLS.TYPE, CAST (COLS.LENGTH AS INT), CAST (COLS.SCALE AS INT)) WHEN -2 THEN NULL ELSE GET_BUFFER_LEN(COLS.TYPE, CAST (COLS.LENGTH AS INT), CAST (COLS.SCALE AS INT)) END AS BUFFER_LENGTH,CASE GET_DECIMAL_DIGITS(COLS.TYPE, CAST (COLS.SCALE AS INT)) WHEN -2 THEN NULL ELSE GET_DECIMAL_DIGITS(COLS.TYPE, CAST (COLS.SCALE AS INT)) END AS DECIMAL_DIGITS,10 AS NUM_PREC_RADIX,CASE COLS.NULLABLE WHEN 'Y' THEN 1 ELSE 0 END AS NULLABLE,NULL AS REMARKS,COLS.DEFVAL AS COLUMN_DEF,0 AS SQL_DATA_TYPE,0 AS SQL_DATETIME_SUB,";
            sql = sql + "CASE GET_OCT_LENGTH(COLS.TYPE, CAST (COLS.LENGTH AS INT)) WHEN -2 THEN NULL ELSE GET_OCT_LENGTH(COLS.TYPE, CAST (COLS.LENGTH AS INT)) END AS CHAR_OCTET_LENGTH,COLS.COLID + 1 AS ORDINAL_POSITION,CASE COLS.NULLABLE WHEN 'Y' THEN 'YES' ELSE 'NO' END AS IS_NULLABLE,NULL AS SCOPE_CATLOG,NULL AS SCOPE_SCHEMA,NULL AS SCOPE_TABLE,0 AS SOURCE_DATA_TYPE FROM " + db + ".SYSDBA.SYSSCHEMAS USERS JOIN " + db + ".SYSDBA.SYSTABLES TAB ON USERS.NAME LIKE '" + sch2 + "' escape " + "'" + this._$9987 + "' " + "AND TAB.NAME " + table_clause + " AND TAB.SCHID = USERS.SCHID JOIN " + db + ".SYSDBA.SYSCOLUMNS COLS ON COLS.NAME " + column_clause + " AND COLS.ID = TAB.ID UNION ";
            sql = sql + "SELECT DISTINCT '" + db2 + "' AS TABLE_CAT,USERS.NAME AS TABLE_SCHEM,VIEWS.NAME AS TABLE_NAME,COLS.NAME AS COLUMN_NAME,CASE COLS.TYPE WHEN 'CLOB' THEN 2005 WHEN 'BLOB' THEN 2004 ELSE GET_DATA_TYPE(COLS.TYPE, CAST(COLS.SCALE AS INT), 3) END AS DATA_TYPE,COLS.TYPE AS TYPE_NAME,CASE GET_COLUMN_SIZE(COLS.TYPE, CAST (COLS.LENGTH AS INT), CAST (COLS.SCALE AS INT)) WHEN -2 THEN NULL ELSE GET_COLUMN_SIZE(COLS.TYPE, CAST (COLS.LENGTH AS INT), CAST (COLS.SCALE AS INT)) END AS COLUMN_SIZE,CASE GET_BUFFER_LEN(COLS.TYPE, CAST (COLS.LENGTH AS INT), CAST (COLS.SCALE AS INT)) WHEN -2 THEN NULL ELSE GET_BUFFER_LEN(COLS.TYPE, CAST (COLS.LENGTH AS INT), CAST (COLS.SCALE AS INT)) END AS BUFFER_LENGTH,CASE GET_DECIMAL_DIGITS(COLS.TYPE, CAST (COLS.SCALE AS INT)) WHEN -2 THEN NULL ELSE GET_DECIMAL_DIGITS(COLS.TYPE, CAST (COLS.SCALE AS INT)) END AS DECIMAL_DIGITS,10 AS NUM_PREC_RADIX,CASE COLS.NULLABLE WHEN 'Y' THEN 1 ELSE 0 END AS NULLABLE,NULL AS REMARKS,COLS.DEFVAL AS COLUMN_DEF,0 AS SQL_DATA_TYPE,0 AS SQL_DATETIME_SUB,";
            sql = sql + "CASE GET_OCT_LENGTH(COLS.TYPE, CAST (COLS.LENGTH AS INT)) WHEN -2 THEN NULL ELSE GET_OCT_LENGTH(COLS.TYPE, CAST (COLS.LENGTH AS INT)) END AS CHAR_OCTET_LENGTH,COLS.COLID + 1 AS ORDINAL_POSITION,CASE COLS.NULLABLE WHEN 'Y' THEN 'YES' ELSE 'NO' END AS IS_NULLABLE,NULL AS SCOPE_CATLOG,NULL AS SCOPE_SCHEMA,NULL AS SCOPE_TABLE,0 AS SOURCE_DATA_TYPE FROM " + db + ".SYSDBA.SYSSCHEMAS USERS JOIN " + db + ".SYSDBA.SYSVIEWS VIEWS ON USERS.NAME LIKE '" + sch2 + "' escape " + "'" + this._$9987 + "' " + "AND VIEWS.NAME " + table_clause + " AND VIEWS.SCHID = USERS.SCHID JOIN " + db + ".SYSDBA.SYSCOLUMNS COLS ON COLS.NAME " + column_clause + " AND COLS.ID = VIEWS.ID";
            sql = sql + " ORDER BY TABLE_SCHEM ASC,TABLE_NAME ASC,ORDINAL_POSITION ASC;";
        } else {
            sql = sql + "SELECT DISTINCT '" + db2 + "' AS TABLE_CAT,'" + sch2 + "' AS TABLE_SCHEM,TAB.NAME AS TABLE_NAME,COLS.NAME AS COLUMN_NAME,CASE COLS.TYPE WHEN 'CLOB' THEN 2005 WHEN 'BLOB' THEN 2004 ELSE GET_DATA_TYPE(COLS.TYPE, CAST(COLS.SCALE AS INT), 3) END AS DATA_TYPE,COLS.TYPE AS TYPE_NAME,CASE GET_COLUMN_SIZE(COLS.TYPE, CAST (COLS.LENGTH AS INT), CAST (COLS.SCALE AS INT)) WHEN -2 THEN NULL ELSE GET_COLUMN_SIZE(COLS.TYPE, CAST (COLS.LENGTH AS INT), CAST (COLS.SCALE AS INT)) END AS COLUMN_SIZE,CASE GET_BUFFER_LEN(COLS.TYPE, CAST (COLS.LENGTH AS INT), CAST (COLS.SCALE AS INT)) WHEN -2 THEN NULL ELSE GET_BUFFER_LEN(COLS.TYPE, CAST (COLS.LENGTH AS INT), CAST (COLS.SCALE AS INT)) END AS BUFFER_LENGTH,CASE GET_DECIMAL_DIGITS(COLS.TYPE, CAST (COLS.SCALE AS INT)) WHEN -2 THEN NULL ELSE GET_DECIMAL_DIGITS(COLS.TYPE, CAST (COLS.SCALE AS INT)) END AS DECIMAL_DIGITS,10 AS NUM_PREC_RADIX,CASE COLS.NULLABLE WHEN 'Y' THEN 1 ELSE 0 END AS NULLABLE,NULL AS REMARKS,COLS.DEFVAL AS COLUMN_DEF,0 AS SQL_DATA_TYPE,0 AS SQL_DATETIME_SUB,";
            sql = sql + "CASE GET_OCT_LENGTH(COLS.TYPE, CAST (COLS.LENGTH AS INT)) WHEN -2 THEN NULL ELSE GET_OCT_LENGTH(COLS.TYPE, CAST (COLS.LENGTH AS INT)) END AS CHAR_OCTET_LENGTH,COLS.COLID + 1 AS ORDINAL_POSITION,CASE COLS.NULLABLE WHEN 'Y' THEN 'YES' ELSE 'NO' END AS IS_NULLABLE,NULL AS SCOPE_CATLOG,NULL AS SCOPE_SCHEMA,NULL AS SCOPE_TABLE,0 AS SOURCE_DATA_TYPE FROM " + db + ".SYSDBA.SYSCOLUMNS COLS," + db + ".SYSDBA.SYSTABLES TAB WHERE TAB.SCHID = (SELECT SCHID FROM " + db + ".SYSDBA.SYSSCHEMAS WHERE NAME = '" + sch2 + "') AND TAB.NAME " + table_clause + " AND COLS.NAME " + column_clause + " AND COLS.ID = TAB.ID UNION ";
            sql = sql + "SELECT DISTINCT '" + db2 + "' AS TABLE_CAT,'" + sch2 + "' AS TABLE_SCHEM,VIEWS.NAME AS TABLE_NAME,COLS.NAME AS COLUMN_NAME,CASE COLS.TYPE WHEN 'CLOB' THEN 2005 WHEN 'BLOB' THEN 2004 ELSE GET_DATA_TYPE(COLS.TYPE, CAST(COLS.SCALE AS INT), 3) END AS DATA_TYPE,COLS.TYPE AS TYPE_NAME,CASE GET_COLUMN_SIZE(COLS.TYPE, CAST (COLS.LENGTH AS INT), CAST (COLS.SCALE AS INT)) WHEN -2 THEN NULL ELSE GET_COLUMN_SIZE(COLS.TYPE, CAST (COLS.LENGTH AS INT), CAST (COLS.SCALE AS INT)) END AS COLUMN_SIZE,CASE GET_BUFFER_LEN(COLS.TYPE, CAST (COLS.LENGTH AS INT), CAST (COLS.SCALE AS INT)) WHEN -2 THEN NULL ELSE GET_BUFFER_LEN(COLS.TYPE, CAST (COLS.LENGTH AS INT), CAST (COLS.SCALE AS INT)) END AS BUFFER_LENGTH,CASE GET_DECIMAL_DIGITS(COLS.TYPE, CAST (COLS.SCALE AS INT)) WHEN -2 THEN NULL ELSE GET_DECIMAL_DIGITS(COLS.TYPE, CAST (COLS.SCALE AS INT)) END AS DECIMAL_DIGITS,10 AS NUM_PREC_RADIX,CASE COLS.NULLABLE WHEN 'Y' THEN 1 ELSE 0 END AS NULLABLE,NULL AS REMARKS,COLS.DEFVAL AS COLUMN_DEF,0 AS SQL_DATA_TYPE,0 AS SQL_DATETIME_SUB,";
            sql = sql + "CASE GET_OCT_LENGTH(COLS.TYPE, CAST (COLS.LENGTH AS INT)) WHEN -2 THEN NULL ELSE GET_OCT_LENGTH(COLS.TYPE, CAST (COLS.LENGTH AS INT)) END AS CHAR_OCTET_LENGTH,COLS.COLID + 1 AS ORDINAL_POSITION,CASE COLS.NULLABLE WHEN 'Y' THEN 'YES' ELSE 'NO' END AS IS_NULLABLE,NULL AS SCOPE_CATLOG,NULL AS SCOPE_SCHEMA,NULL AS SCOPE_TABLE,0 AS SOURCE_DATA_TYPE FROM " + db + ".SYSDBA.SYSCOLUMNS COLS," + db + ".SYSDBA.SYSVIEWS VIEWS WHERE VIEWS.SCHID = (SELECT SCHID FROM " + db + ".SYSDBA.SYSSCHEMAS WHERE NAME = '" + sch2 + "') AND VIEWS.NAME " + table_clause + " AND COLS.NAME " + column_clause + " AND COLS.ID = VIEWS.ID";
            sql = sql + " ORDER BY TABLE_SCHEM ASC,TABLE_NAME ASC,ORDINAL_POSITION ASC;";
        }
        DmdbStatement stmt = null;
        ResultSet rs = null;
        stmt = (DmdbStatement)this._$1222.createStatement(1003, 1007, 1);
        rs = stmt.executeQuery(sql, 1);
        stmt.close();
        return rs;
    }

    private boolean _$10007(String str) {
        boolean flag = false;
        int len = str.length();
        if (len == 1) {
            return str.charAt(0) == '%' || str.charAt(0) == '_';
        }
        for (int i = len - 1; i >= 0; --i) {
            if (str.charAt(i) != '%' && str.charAt(i) != '_') continue;
            flag = true;
        }
        return flag;
    }

    public ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        if (table == null) {
            throw new SQLException("NULL TABLE NAME");
        }
        if (catalog != null && catalog.equals("")) {
            throw new SQLException("There is not a table without a catalog!");
        }
        if (schema != null && schema.equals("")) {
            throw new SQLException("There is not a table without a schema!");
        }
        if (table != null && table.equals("") || columnNamePattern != null && columnNamePattern.equals("")) {
            return null;
        }
        String catalog2 = catalog == null ? this._$1222.getCatalog() : catalog.trim();
        String schemaname = schema == null ? this._$1222.getUserName() : schema;
        String tablename = table;
        String columnname = columnNamePattern == null ? "%" : columnNamePattern;
        String db = "\"" + StringUtil.getEscObjName(catalog2) + "\"";
        String db2 = StringUtil.getEscStringName(catalog2);
        String sch2 = StringUtil.getEscStringName(schemaname);
        String tab2 = StringUtil.getEscStringName(tablename);
        String col2 = StringUtil.getEscStringName(columnname);
        String column_clause = null;
        column_clause = this._$10007(columnname) ? " like '" + col2 + "' escape " + "'" + this._$9987 + "' " : " = '" + col2 + "' ";
        String sql = new String("");
        if (this._$10007(tablename)) {
            sql = sql + "SELECT DISTINCT '" + db2 + "' AS TABLE_CAT,'";
            sql = sql + sch2 + "' AS TABLE_SCHEM,TAB.NAME AS TABLE_NAME,";
            sql = sql + "COL.NAME AS COLUMN_NAME,GRANTOR.USERNAME AS GRANTOR,";
            sql = sql + "GRANTEE.URNAME AS GRANTEE,";
            sql = sql + "GET_SYS_PRIV(CAST (COLGRANT.PRIV AS INT)) AS PRIVILEGE,";
            sql = sql + "CASE COLGRANT.GRANTABLE WHEN 'Y' THEN 'YES' WHEN 'N' THEN 'NO' END AS IS_GRANTABLE";
            sql = sql + " FROM " + db + ".SYSDBA.SYSCOLGRANTS COLGRANT,";
            sql = sql + db + ".SYSDBA.SYSCOLUMNS COL, ";
            sql = sql + db + ".SYSDBA.SYSUSERS GRANTOR, ";
            sql = sql + "(SELECT USERID, USERNAME FROM ";
            sql = sql + db;
            sql = sql + ".SYSDBA.SYSUSERS UNION ALL SELECT ROLEID, ROLENAME FROM ";
            sql = sql + db;
            sql = sql + ".SYSDBA.SYSROLES) GRANTEE (URID, URNAME), ";
            sql = sql + "(SELECT NAME, ID, SCHID FROM " + db + ".SYSDBA.SYSTABLES union all " + " SELECT NAME, ID, SCHID FROM " + db + ".SYSDBA.SYSVIEWS) TAB(NAME, ID, SCHID) " + "WHERE TAB.SCHID = (SELECT SCHID FROM " + db + ".SYSDBA.SYSSCHEMAS WHERE NAME = '" + sch2 + "') AND TAB.NAME LIKE '" + tab2 + "' escape " + "'" + this._$9987 + "' " + "AND COLGRANT.TVID = TAB.ID AND COL.NAME " + column_clause + " AND COLGRANT.GRANTOR = GRANTOR.USERID AND COLGRANT.URID = GRANTEE.URID AND " + "COLGRANT.COLID = COL.COLID AND COLGRANT.TVID = COL.ID";
            sql = sql + " ORDER BY COLUMN_NAME ASC,PRIVILEGE ASC;";
        } else {
            sql = sql + "SELECT DISTINCT '" + db2 + "' AS TABLE_CAT,'" + sch2 + "' AS TABLE_SCHEM,'" + tab2 + "' AS TABLE_NAME,COL.NAME AS COLUMN_NAME, " + "GRANTOR.USERNAME AS GRANTOR, GRANTEE.URNAME AS GRANTEE, " + "GET_SYS_PRIV(CAST (COLGRANT.PRIV AS INT)) AS PRIVILEGE, " + "CASE COLGRANT.GRANTABLE WHEN 'Y' THEN 'YES' WHEN 'N' THEN 'NO' END AS IS_GRANTABLE";
            sql = sql + " FROM " + db + ".SYSDBA.SYSCOLGRANTS COLGRANT," + db + ".SYSDBA.SYSCOLUMNS COL, " + db + ".SYSDBA.SYSUSERS GRANTOR, " + "(SELECT USERNAME, USERID FROM " + db + ".SYSDBA.SYSUSERS union all " + " SELECT ROLENAME, ROLEID FROM " + db + ".SYSDBA.SYSROLES) GRANTEE (URNAME, URID) " + "WHERE COLGRANT.TVID = (SELECT tab.ID FROM " + "(SELECT NAME, ID, SCHID FROM " + db + ".SYSDBA.SYSTABLES union all " + " SELECT NAME, ID, SCHID FROM " + db + ".SYSDBA.SYSVIEWS) TAB(NAME, ID, SCHID) " + " WHERE tab.NAME = '" + tab2 + "' AND TAB.SCHID = (SELECT SCHID FROM " + db + ".SYSDBA.SYSSCHEMAS WHERE NAME = '" + sch2 + "')) AND COL.NAME " + column_clause + " AND COLGRANT.GRANTOR = GRANTOR.USERID " + "AND COLGRANT.URID = GRANTEE.URID AND COLGRANT.COLID = COL.COLID AND " + "COLGRANT.TVID = COL.ID";
            sql = sql + " ORDER BY COLUMN_NAME ASC,PRIVILEGE ASC;";
        }
        DmdbStatement stmt = null;
        DmdbResultSet rs = null;
        stmt = (DmdbStatement)this._$1222.createStatement(1003, 1007, 1);
        rs = (DmdbResultSet)stmt.executeQuery(sql, 1);
        stmt.close();
        return rs;
    }

    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        if (catalog != null && catalog.equals("")) {
            throw new SQLException("There is not a table without a catalog!");
        }
        if (schemaPattern != null && schemaPattern.equals("")) {
            throw new SQLException("There is not a table without a schema!");
        }
        if (tableNamePattern != null && tableNamePattern.equals("")) {
            return null;
        }
        String catalog2 = catalog == null ? this._$1222.getCatalog() : catalog.trim();
        String schemaname = schemaPattern == null ? "%" : schemaPattern;
        String tablename = tableNamePattern == null ? "%" : tableNamePattern;
        String db = "\"" + StringUtil.getEscObjName(catalog2) + "\"";
        String db2 = StringUtil.getEscStringName(catalog2);
        String sch2 = StringUtil.getEscStringName(schemaname);
        String tab2 = StringUtil.getEscStringName(tablename);
        String table_clause = null;
        table_clause = this._$10007(tablename) ? " like '" + tab2 + "' escape " + "'" + this._$9987 + "' " : " = '" + tab2 + "' ";
        String sql = new String("");
        if (this._$10007(schemaname)) {
            sql = sql + "SELECT DISTINCT '";
            sql = sql + db2;
            sql = sql + "' AS TABLE_CAT,";
            sql = sql + "USERS.NAME AS TABLE_SCHEM, ";
            sql = sql + "TAB.NAME AS TABLE_NAME,";
            sql = sql + "GRANTORS.USERNAME AS GRANTOR,";
            sql = sql + "GRANTEES.URNAME AS GRANTEE,";
            sql = sql + "GET_SYS_PRIV(CAST (TVGRANTS.PRIV AS INT)) AS PRIVILEGE,";
            sql = sql + "CASE TVGRANTS.GRANTABLE WHEN 'Y' THEN 'YES' WHEN 'N' THEN 'NO' END AS IS_GRANTABLE";
            sql = sql + " FROM ";
            sql = sql + db;
            sql = sql + ".SYSDBA.SYSTVGRANTS TVGRANTS,";
            sql = sql + db;
            sql = sql + ".SYSDBA.SYSSCHEMAS USERS ,";
            sql = sql + "(SELECT ID, NAME, SCHID FROM ";
            sql = sql + db;
            sql = sql + ".SYSDBA.SYSTABLES UNION ALL SELECT ID, NAME, SCHID FROM ";
            sql = sql + db;
            sql = sql + ".SYSDBA.SYSVIEWS) TAB(ID, NAME, SCHID),";
            sql = sql + db;
            sql = sql + ".SYSDBA.SYSUSERS GRANTORS, (SELECT USERID, USERNAME FROM ";
            sql = sql + db;
            sql = sql + ".SYSDBA.SYSUSERS UNION ALL SELECT ROLEID, ROLENAME FROM ";
            sql = sql + db;
            sql = sql + ".sysdba.SYSROLES) GRANTEES (URID, URNAME) WHERE ";
            sql = sql + "USERS.NAME LIKE '";
            sql = sql + sch2;
            sql = sql + "' escape '" + this._$9987 + "' AND TAB.NAME ";
            sql = sql + table_clause;
            sql = sql + " AND USERS.SCHID = TAB.SCHID ";
            sql = sql + " AND TVGRANTS.TVID = TAB.ID AND TVGRANTS.URID = GRANTEES.URID AND ";
            sql = sql + "TVGRANTS.GRANTOR = GRANTORS.USERID ";
            sql = sql + " UNION ALL ";
            sql = sql + "SELECT DISTINCT '";
            sql = sql + db2;
            sql = sql + "' AS TABLE_CAT, ";
            sql = sql + "USERS.NAME AS TABLE_SCHEM, TAB.NAME AS TABLE_NAME, '_SYSTEM' AS GRANTOR, ";
            sql = sql + "GRANTEES.USERNAME AS GRANTEE, PRIVS.NAME AS PRIVILEGE, ";
            sql = sql + "'YES' AS IS_GRANTABLE FROM ";
            sql = sql + "SYSTEM.SYSDBA.SYSPRIVILEGES PRIVS,";
            sql = sql + db;
            sql = sql + ".SYSDBA.SYSSCHEMAS USERS, ";
            sql = sql + db;
            sql = sql + ".SYSDBA.SYSTABLES TAB, ";
            sql = sql + db;
            sql = sql + ".SYSDBA.SYSUSERS GRANTEES ";
            sql = sql + "WHERE GRANTEES.USERID = (SELECT UID FROM ";
            sql = sql + db;
            sql = sql + ".SYSDBA.SYSSCHEMAS WHERE SCHID = TAB.SCHID) AND ";
            sql = sql + "USERS.SCHID = TAB.SCHID AND TAB.NAME ";
            sql = sql + table_clause;
            sql = sql + " AND  TAB.ID >= 1000 AND TAB.NAME NOT LIKE '%DMBLOB' AND ";
            sql = sql + "(PRIVS.ID >= 8192 AND PRIVS.ID <= 8196) ";
            sql = sql + " UNION all ";
            sql = sql + "SELECT DISTINCT '";
            sql = sql + db2;
            sql = sql + "' AS TABLE_CAT, ";
            sql = sql + "USERS.NAME AS TABLE_SCHEM, TAB.NAME AS TABLE_NAME, '_SYSTEM' AS GRANTOR, ";
            sql = sql + "GRANTEES.USERNAME AS GRANTEE, PRIVS.NAME AS PRIVILEGE, 'YES' AS IS_GRANTABLE ";
            sql = sql + "FROM SYSTEM.SYSDBA.SYSPRIVILEGES PRIVS, ";
            sql = sql + db;
            sql = sql + ".SYSDBA.SYSSCHEMAS USERS ,";
            sql = sql + "(SELECT ID, NAME, TYPE, SCHID FROM ";
            sql = sql + db;
            sql = sql + ".SYSDBA.SYSVIEWS) TAB(ID, NAME, TYPE, SCHID),";
            sql = sql + db;
            sql = sql + ".SYSDBA.SYSUSERS GRANTEES ";
            sql = sql + "WHERE GRANTEES.USERID = (SELECT UID FROM ";
            sql = sql + db;
            sql = sql + ".SYSDBA.SYSSCHEMAS WHERE SCHID = TAB.SCHID) AND ";
            sql = sql + "USERS.SCHID = TAB.SCHID AND TAB.NAME ";
            sql = sql + table_clause;
            sql = sql + " AND TAB.TYPE = 'U' AND (PRIVS.ID >= 8192 AND PRIVS.ID <= 8195) ";
            sql = sql + "ORDER BY  TABLE_SCHEM ASC, TABLE_NAME ASC,  PRIVILEGE ASC";
        } else {
            sql = sql + "SELECT DISTINCT '";
            sql = sql + db2;
            sql = sql + "' AS TABLE_CAT,'";
            sql = sql + sch2;
            sql = sql + "' AS TABLE_SCHEM,";
            sql = sql + "TAB.NAME AS TABLE_NAME,";
            sql = sql + "GRANTORS.USERNAME AS GRANTOR,";
            sql = sql + "GRANTEES.URNAME AS GRANTEE,";
            sql = sql + "GET_SYS_PRIV(CAST (TVGRANTS.PRIV AS INT)) AS PRIVILEGE,";
            sql = sql + "CASE TVGRANTS.GRANTABLE WHEN 'Y' THEN 'YES' WHEN 'N' THEN 'NO' END AS IS_GRANTABLE";
            sql = sql + " FROM ";
            sql = sql + db;
            sql = sql + ".SYSDBA.SYSTVGRANTS TVGRANTS,";
            sql = sql + "(SELECT ID, NAME, SCHID FROM ";
            sql = sql + db;
            sql = sql + ".SYSDBA.SYSTABLES UNION ALL SELECT ID, NAME, SCHID FROM ";
            sql = sql + db;
            sql = sql + ".SYSDBA.SYSVIEWS) TAB(ID, NAME, SCHID),";
            sql = sql + db;
            sql = sql + ".SYSDBA.SYSUSERS GRANTORS, (SELECT USERID, USERNAME FROM ";
            sql = sql + db;
            sql = sql + ".SYSDBA.SYSUSERS UNION ALL SELECT ROLEID, ROLENAME FROM ";
            sql = sql + db;
            sql = sql + ".SYSDBA.SYSROLES) GRANTEES (URID, URNAME) WHERE ";
            sql = sql + "TAB.SCHID = (SELECT SCHID FROM ";
            sql = sql + db;
            sql = sql + ".SYSDBA.SYSSCHEMAS WHERE NAME = '";
            sql = sql + sch2;
            sql = sql + "') AND TAB.NAME ";
            sql = sql + table_clause;
            sql = sql + " AND TVGRANTS.TVID = TAB.ID AND TVGRANTS.URID = GRANTEES.URID AND ";
            sql = sql + "TVGRANTS.GRANTOR = GRANTORS.USERID ";
            sql = sql + " UNION ALL ";
            sql = sql + "SELECT DISTINCT '";
            sql = sql + db2;
            sql = sql + "' AS TABLE_CAT, '";
            sql = sql + sch2;
            sql = sql + "' AS TABLE_SCHEM, TAB.NAME AS TABLE_NAME, '_SYSTEM' AS GRANTOR, ";
            sql = sql + "GRANTEES.USERNAME AS GRANTEE, PRIVS.NAME AS PRIVILEGE, ";
            sql = sql + "'YES' AS IS_GRANTABLE FROM ";
            sql = sql + "SYSTEM.SYSDBA.SYSPRIVILEGES PRIVS,";
            sql = sql + db;
            sql = sql + ".SYSDBA.SYSTABLES TAB, ";
            sql = sql + db;
            sql = sql + ".SYSDBA.SYSUSERS GRANTEES ";
            sql = sql + "WHERE GRANTEES.USERID = (SELECT UID FROM ";
            sql = sql + db;
            sql = sql + ".SYSDBA.SYSSCHEMAS WHERE SCHID = TAB.SCHID AND NAME = '";
            sql = sql + sch2;
            sql = sql + "') AND TAB.NAME ";
            sql = sql + table_clause;
            sql = sql + " AND  TAB.ID >= 1000 AND TAB.NAME NOT LIKE '%DMBLOB' AND ";
            sql = sql + "(PRIVS.ID >= 8192 AND PRIVS.ID <= 8196) ";
            sql = sql + " UNION all ";
            sql = sql + "SELECT DISTINCT '";
            sql = sql + db2;
            sql = sql + "' AS TABLE_CAT,'";
            sql = sql + sch2;
            sql = sql + "' AS TABLE_SCHEM, TAB.NAME AS TABLE_NAME, '_SYSTEM' AS GRANTOR, ";
            sql = sql + "GRANTEES.USERNAME AS GRANTEE, PRIVS.NAME AS PRIVILEGE, 'YES' AS IS_GRANTABLE ";
            sql = sql + "FROM SYSTEM.SYSDBA.SYSPRIVILEGES PRIVS, ";
            sql = sql + "(SELECT ID, NAME, TYPE, SCHID FROM ";
            sql = sql + db;
            sql = sql + ".SYSDBA.SYSVIEWS) TAB(ID, NAME, TYPE, SCHID),";
            sql = sql + db;
            sql = sql + ".SYSDBA.SYSUSERS GRANTEES ";
            sql = sql + "WHERE GRANTEES.USERID = (SELECT UID FROM ";
            sql = sql + db;
            sql = sql + ".SYSDBA.SYSSCHEMAS WHERE SCHID = TAB.SCHID AND NAME = '";
            sql = sql + sch2;
            sql = sql + "') AND TAB.NAME ";
            sql = sql + table_clause;
            sql = sql + " AND TAB.TYPE = 'U' AND (PRIVS.ID >= 8192 AND PRIVS.ID >= 8195) ";
            sql = sql + "ORDER BY  TABLE_SCHEM ASC, TABLE_NAME ASC,  PRIVILEGE ASC";
        }
        DmdbStatement stmt = null;
        DmdbResultSet rs = null;
        stmt = (DmdbStatement)this._$1222.createStatement(1003, 1007, 1);
        rs = (DmdbResultSet)stmt.executeQuery(sql, 1);
        stmt.close();
        return rs;
    }

    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        if (catalog != null && catalog.equals("")) {
            throw new SQLException("There is not a table without a catalog!");
        }
        if (schema != null && schema.equals("")) {
            throw new SQLException("There is not a table without a schema!");
        }
        if (table != null && table.equals("")) {
            return null;
        }
        String catalog2 = catalog == null ? this._$1222.getCatalog() : catalog.trim();
        String sch = schema == null ? "%" : schema;
        String tab = table == null ? "%" : table;
        String db = "\"" + StringUtil.getEscObjName(catalog2) + "\"";
        String sch2 = StringUtil.getEscStringName(sch);
        String tab2 = StringUtil.getEscStringName(tab);
        DmdbStatement stmt = null;
        DmdbResultSet rs = null;
        String sql = "";
        ResultSet pk = this.getPrimaryKeys(catalog, schema, table);
        if (pk.next()) {
            sql = sql + "SELECT '" + scope + "' as \"SCOPE\",COLS.NAME AS COLUMN_NAME,GET_DATA_TYPE(COLS.TYPE, CAST (COLS.SCALE AS INT), 3) AS DATA_TYPE,COLS.TYPE AS TYPE_NAME,CASE GET_COLUMN_SIZE(COLS.TYPE, CAST (COLS.LENGTH AS INT), CAST (COLS.SCALE AS INT)) WHEN -2 THEN NULL ELSE GET_COLUMN_SIZE(COLS.TYPE, CAST (COLS.LENGTH AS INT), CAST (COLS.SCALE AS INT)) END AS COLUMN_SIZE,CASE GET_BUFFER_LEN(COLS.TYPE, CAST (COLS.LENGTH AS INT), CAST (COLS.SCALE AS INT)) WHEN -2 THEN NULL ELSE GET_BUFFER_LEN(COLS.TYPE, CAST (COLS.LENGTH AS INT), CAST (COLS.SCALE AS INT)) END AS BUFFER_LENGTH,CASE GET_DECIMAL_DIGITS(COLS.TYPE, CAST (COLS.SCALE AS INT)) WHEN -2 THEN NULL ELSE GET_DECIMAL_DIGITS(COLS.TYPE, CAST (COLS.SCALE AS INT)) END AS DECIMAL_DIGITS,0 AS PSEUDO_COLUMN";
            sql = sql + " FROM " + db + ".SYSDBA.SYSCOLUMNS COLS WHERE COLS.NAME IN (SELECT COLS.NAME FROM " + db + ".SYSDBA.SYSINDEXES SYSIND," + db + ".SYSDBA.SYSINDEXKEYS INDKEY," + db + ".SYSDBA.SYSCOLUMNS COLS," + db + ".SYSDBA.SYSCONSTRAINTS AS CONS WHERE CONS.TABLEID = (SELECT ID FROM " + db + ".SYSDBA.SYSTABLES WHERE NAME = '" + tab2 + "' AND SCHID = (SELECT SCHID FROM " + db + ".SYSDBA.SYSSCHEMAS WHERE NAME = '" + sch2 + "')) AND COLS.ID = CONS.TABLEID AND SYSIND.TABLEID = CONS.TABLEID AND INDKEY.ID = SYSIND.ID AND INDKEY.COLID = COLS.COLID AND CONS.TYPE = 'P')" + "AND COLS.ID = (SELECT ID FROM " + db + ".SYSDBA.SYSTABLES WHERE NAME = '" + tab2 + "' AND SCHID = (SELECT SCHID FROM " + db + ".SYSDBA.SYSSCHEMAS WHERE NAME = '" + sch2 + "'))";
            if (!nullable) {
                sql = sql + " AND COLS.NULLABLE = 'N'";
            }
        } else {
            sql = sql + "select '" + scope + "' as \"SCOPE\",'ROWID' as COLUMN_NAME,-2 as DATA_TYPE,'BINARY' as TYPE_NAME,5 as COLUMN_SIZE,5 as BUFFER_LENGTH,0 as DECIMAL_DIGITS,0 as PSEUDO_COLUMN";
        }
        stmt = (DmdbStatement)this._$1222.createStatement(1003, 1007, 1);
        rs = (DmdbResultSet)stmt.executeQuery(sql, 1);
        stmt.close();
        return rs;
    }

    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        DmdbStatement stmt = null;
        DmdbResultSet rs = null;
        if (catalog != null && catalog.equals("")) {
            throw new SQLException("There is not a table without a catalog!");
        }
        if (schema != null && schema.equals("")) {
            throw new SQLException("There is not a table without a schema!");
        }
        if (table != null && table.equals("")) {
            return null;
        }
        String catalog2 = catalog == null ? this._$1222.getCatalog() : catalog.trim();
        String db = "\"" + StringUtil.getEscObjName(catalog2) + "\"";
        String sql = "";
        sql = sql + "SELECT DISTINCT NULL AS \"SCOPE\",COLS.NAME AS COLUMN_NAME, ";
        sql = sql + "GET_DATA_TYPE(COLS.TYPE, CAST (COLS.SCALE AS INT), 3) AS DATA_TYPE, ";
        sql = sql + "COLS.TYPE AS TYPE_NAME,CASE GET_COLUMN_SIZE(COLS.TYPE, CAST (COLS.LENGTH AS INT), CAST (COLS.SCALE AS INT)) WHEN -2 THEN NULL ELSE GET_COLUMN_SIZE(COLS.TYPE, CAST (COLS.LENGTH AS INT), CAST (COLS.SCALE AS INT)) END AS COLUMN_SIZE,CASE GET_BUFFER_LEN(COLS.TYPE, CAST (COLS.LENGTH AS INT), CAST (COLS.SCALE AS INT)) WHEN -2 THEN NULL ELSE GET_BUFFER_LEN(COLS.TYPE, CAST (COLS.LENGTH AS INT), CAST (COLS.SCALE AS INT)) END AS BUFFER_LENGTH,CASE GET_DECIMAL_DIGITS(COLS.TYPE, CAST (COLS.SCALE AS INT)) WHEN -2 THEN NULL ELSE GET_DECIMAL_DIGITS(COLS.TYPE, CAST (COLS.SCALE AS INT)) END AS DECIMAL_DIGITS,0 AS PSEUDO_COLUMN";
        sql = sql + " FROM " + db + ".SYSDBA.SYSCOLUMNS COLS WHERE 1 = 2;";
        stmt = (DmdbStatement)this._$1222.createStatement(1003, 1007, 1);
        rs = (DmdbResultSet)stmt.executeQuery(sql, 1);
        stmt.close();
        return rs;
    }

    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        if (table == null) {
            throw new SQLException("NULL TABLE NAME");
        }
        if (catalog != null && catalog.equals("")) {
            throw new SQLException("There is not a table without a catalog!");
        }
        if (schema != null && schema.equals("")) {
            throw new SQLException("There is not a table without a schema!");
        }
        if (table != null && table.equals("")) {
            return null;
        }
        String catalog2 = catalog == null ? this._$1222.getCatalog() : catalog.trim();
        String schemaname = schema == null ? this._$1222.getUserName() : schema;
        String tablename = table;
        String db = "\"" + StringUtil.getEscObjName(catalog2) + "\"";
        String db2 = StringUtil.getEscStringName(catalog2);
        String sch2 = StringUtil.getEscStringName(schemaname);
        String tab2 = StringUtil.getEscStringName(tablename);
        String sql = new String("");
        if (this._$10007(tablename)) {
            sql = sql + "SELECT '" + db2 + "' AS TABLE_CAT,'" + sch2 + "' AS TABLE_SCHEM,TAB.NAME AS TABLE_NAME,COLS.NAME AS COLUMN_NAME,INDKEY.KEYNO + 1 AS KEY_SEQ,CONS.NAME AS PK_NAME";
            sql = sql + " FROM " + db + ".SYSDBA.SYSINDEXES SYSIND," + db + ".SYSDBA.SYSINDEXKEYS INDKEY," + db + ".SYSDBA.SYSCOLUMNS COLS," + db + ".SYSDBA.SYSTABLES TAB," + db + ".SYSDBA.SYSCONSTRAINTS AS CONS WHERE TAB.NAME LIKE '" + tab2 + "' escape " + "'" + this._$9987 + "' " + "AND TAB.SCHID = (SELECT SCHID FROM " + db + ".SYSDBA.SYSSCHEMAS WHERE NAME = '" + sch2 + "') AND SYSIND.TABLEID = TAB.ID AND COLS.ID = TAB.ID AND INDKEY.ID = SYSIND.ID AND INDKEY.COLID = COLS.COLID AND CONS.TYPE = 'P' AND CONS.TABLEID = TAB.ID AND SYSIND.NAME = CONS.NAME";
            sql = sql + " ORDER BY COLUMN_NAME ASC;";
        } else {
            sql = sql + "SELECT '" + db2 + "' AS TABLE_CAT,'" + sch2 + "' AS TABLE_SCHEM,'" + tab2 + "' AS TABLE_NAME,COLS.NAME AS COLUMN_NAME,INDKEY.KEYNO + 1 AS KEY_SEQ,CONS.NAME AS PK_NAME";
            sql = sql + " FROM " + db + ".SYSDBA.SYSINDEXES SYSIND," + db + ".SYSDBA.SYSINDEXKEYS INDKEY," + db + ".SYSDBA.SYSCOLUMNS COLS," + db + ".SYSDBA.SYSCONSTRAINTS AS CONS WHERE CONS.TABLEID = (SELECT ID FROM " + db + ".SYSDBA.SYSTABLES WHERE NAME = '" + tab2 + "' AND SCHID = (SELECT SCHID FROM " + db + ".SYSDBA.SYSSCHEMAS WHERE NAME = '" + sch2 + "')) AND SYSIND.TABLEID = CONS.TABLEID AND COLS.ID = CONS.TABLEID AND INDKEY.ID = SYSIND.ID AND INDKEY.COLID = COLS.COLID AND CONS.TYPE = 'P' AND SYSIND.NAME = CONS.NAME";
            sql = sql + " ORDER BY COLUMN_NAME ASC;";
        }
        DmdbStatement stmt = null;
        DmdbResultSet rs = null;
        stmt = (DmdbStatement)this._$1222.createStatement(1003, 1007, 1);
        rs = (DmdbResultSet)stmt.executeQuery(sql, 1);
        stmt.close();
        return rs;
    }

    public ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        String schemaname;
        if (table == null) {
            throw new SQLException("NULL TABLE NAME");
        }
        String catalog2 = catalog == null ? this._$1222.getCatalog() : catalog.trim();
        String string = schemaname = schema == null ? this._$1222.getUserName() : schema;
        if (table != null && table.equals("")) {
            return null;
        }
        String tablename = table;
        String db = "\"" + StringUtil.getEscObjName(catalog2) + "\"";
        String db2 = StringUtil.getEscStringName(catalog2);
        String sch2 = StringUtil.getEscStringName(schemaname);
        String tab2 = StringUtil.getEscStringName(tablename);
        StringBuffer strBuf = new StringBuffer();
        strBuf.append("SELECT '");
        strBuf.append(db2);
        strBuf.append("' AS PKTABLE_CAT, T_REFED.SCHNAME AS PKTABLE_SCHEM, ");
        strBuf.append("T_REFED.NAME AS PKTABLE_NAME, ");
        strBuf.append("T_REFED.REFED_COL_NAME AS PKCOLUMN_NAME, '");
        strBuf.append(db2);
        strBuf.append("' AS FKTABLE_CAT, '");
        strBuf.append(sch2);
        strBuf.append("' AS FKTABLE_SCHEM, '");
        strBuf.append(tab2);
        strBuf.append("' AS FKTABLE_NAME, T_REF.REF_COL_NAME AS FKCOLUMN_NAME, ");
        strBuf.append("T_REF.REF_KEYNO + 1 AS KEY_SEQ, CASE (T_CONS.RESVD1 & 0xffff0000) WHEN 393216 THEN 4 WHEN 327680 THEN 2 WHEN 262144 THEN 0 ELSE 3 END AS UPDATE_RULE, CASE (T_CONS.RESVD1 & 0x0000ff00) WHEN 768 THEN 4 WHEN 512 THEN 2 WHEN 256 THEN 0 ELSE 3 END AS DELETE_RULE, ");
        strBuf.append("T_REF.REF_CONS_NAME AS FK_NAME, T_REFED.REFED_CONS_NAME AS PK_NAME, ");
        strBuf.append("0 AS DEFERRABILITY ");
        strBuf.append("FROM ");
        strBuf.append("(SELECT T_REF_CONS.ID AS REFED_ID, T_REF_IND.NAME AS REF_CONS_NAME, ");
        strBuf.append("T_REF_INDKEY.KEYNO AS REF_KEYNO, T_REF_COL.NAME AS REF_COL_NAME ");
        strBuf.append("FROM ");
        strBuf.append(db);
        strBuf.append(".SYSDBA.SYSREFCONSTRAINTS AS T_REF_CONS, ");
        strBuf.append("(SELECT COLID AS COLID, NAME AS NAME FROM ");
        strBuf.append(db);
        strBuf.append(".SYSDBA.SYSCOLUMNS WHERE ID = (SELECT ID FROM ");
        strBuf.append(db);
        strBuf.append(".SYSDBA.SYSTABLES WHERE NAME = '");
        strBuf.append(tab2);
        strBuf.append("' AND SCHID = (SELECT SCHID FROM ");
        strBuf.append(db);
        strBuf.append(".SYSDBA.SYSSCHEMAS WHERE NAME = '");
        strBuf.append(sch2);
        strBuf.append("'))) AS T_REF_COL, ");
        strBuf.append(db);
        strBuf.append(".SYSDBA.SYSINDEXES AS T_REF_IND, ");
        strBuf.append(db);
        strBuf.append(".SYSDBA.SYSINDEXKEYS AS T_REF_INDKEY WHERE T_REF_IND.TABLEID = (SELECT ");
        strBuf.append("ID FROM ");
        strBuf.append(db);
        strBuf.append(".SYSDBA.SYSTABLES WHERE NAME = '");
        strBuf.append(tab2);
        strBuf.append("' AND SCHID = (SELECT SCHID FROM ");
        strBuf.append(db);
        strBuf.append(".SYSDBA.SYSSCHEMAS WHERE NAME = '");
        strBuf.append(sch2);
        strBuf.append("')) AND T_REF_CONS.FID = T_REF_IND.ID AND T_REF_IND.ID = T_REF_INDKEY.ID AND ");
        strBuf.append("T_REF_INDKEY.COLID = T_REF_COL.COLID) AS T_REF, ");
        strBuf.append("(SELECT RESVD1 AS RESVD1 ");
        strBuf.append("FROM ");
        strBuf.append(db);
        strBuf.append(".SYSDBA.SYSCONSTRAINTS WHERE TYPE = 'F' AND TABLEID = (SELECT ");
        strBuf.append("ID FROM ");
        strBuf.append(db);
        strBuf.append(".SYSDBA.SYSTABLES WHERE NAME = '");
        strBuf.append(tab2);
        strBuf.append("' AND SCHID = (SELECT SCHID FROM ");
        strBuf.append(db);
        strBuf.append(".SYSDBA.SYSSCHEMAS WHERE NAME = '");
        strBuf.append(sch2);
        strBuf.append("'))) AS T_CONS,");
        strBuf.append("(SELECT T_REF_CONS.ID AS REFED_ID, T_REFED_SCH.NAME AS SCHNAME, ");
        strBuf.append("T_REFED_TAB.NAME AS NAME, T_REFED_IND.ID AS REFED_IND_ID, ");
        strBuf.append("T_REFED_IND.NAME AS REFED_CONS_NAME, T_REFED_INDKEY.KEYNO AS REFED_KEYNO, ");
        strBuf.append("T_REFED_COL.NAME AS REFED_COL_NAME FROM ");
        strBuf.append(db);
        strBuf.append(".SYSDBA.SYSREFCONSTRAINTS AS T_REF_CONS, (SELECT NAME AS NAME, ");
        strBuf.append("ID AS ID, SCHID AS SCHID FROM ");
        strBuf.append(db);
        strBuf.append(".SYSDBA.SYSTABLES WHERE ID IN (SELECT TABLEID FROM ");
        strBuf.append(db);
        strBuf.append(".SYSDBA.SYSINDEXES WHERE ID IN (SELECT RID FROM ");
        strBuf.append(db);
        strBuf.append(".SYSDBA.SYSREFCONSTRAINTS WHERE FID IN (SELECT ID FROM ");
        strBuf.append(db);
        strBuf.append(".SYSDBA.SYSINDEXES WHERE TABLEID = (SELECT ID FROM ");
        strBuf.append(db);
        strBuf.append(".SYSDBA.SYSTABLES WHERE NAME = '");
        strBuf.append(tab2);
        strBuf.append("' AND SCHID = (SELECT SCHID FROM ");
        strBuf.append(db);
        strBuf.append(".SYSDBA.SYSSCHEMAS WHERE NAME = '");
        strBuf.append(sch2);
        strBuf.append("')))))) AS T_REFED_TAB, ");
        strBuf.append(db);
        strBuf.append(".SYSDBA.SYSSCHEMAS AS T_REFED_SCH, ");
        strBuf.append(db);
        strBuf.append(".SYSDBA.SYSINDEXES AS T_REFED_IND, ");
        strBuf.append(db);
        strBuf.append(".SYSDBA.SYSINDEXKEYS AS T_REFED_INDKEY, ");
        strBuf.append(db);
        strBuf.append(".SYSDBA.SYSCOLUMNS AS T_REFED_COL WHERE ");
        strBuf.append("T_REFED_SCH.SCHID = T_REFED_TAB.SCHID AND T_REFED_TAB.ID = T_REFED_COL.ID AND ");
        strBuf.append("T_REFED_IND.ID = T_REFED_INDKEY.ID AND T_REFED_INDKEY.COLID = T_REFED_COL.COLID AND ");
        strBuf.append("T_REFED_IND.ISUNIQUE = 'Y' AND T_REFED_IND.TABLEID = T_REFED_TAB.ID AND T_REF_CONS.RID = T_REFED_IND.ID) AS T_REFED ");
        strBuf.append("WHERE T_REF.REFED_ID = T_REFED.REFED_ID AND T_REF.REF_KEYNO = T_REFED.REFED_KEYNO ");
        strBuf.append("ORDER BY FKTABLE_CAT ASC, FKTABLE_SCHEM ASC, FKTABLE_NAME ASC, KEY_SEQ ASC");
        String sql = strBuf.toString();
        DmdbStatement stmt = null;
        DmdbResultSet rs = null;
        stmt = (DmdbStatement)this._$1222.createStatement(1003, 1007, 1);
        rs = (DmdbResultSet)stmt.executeQuery(sql, 1);
        stmt.close();
        return rs;
    }

    public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        String schemaname;
        if (table == null) {
            throw new SQLException("NULL TABLE NAME");
        }
        String catalog2 = catalog == null ? this._$1222.getCatalog() : catalog.trim();
        String string = schemaname = schema == null ? this._$1222.getUserName() : schema;
        if (table != null && table.equals("")) {
            return null;
        }
        String tablename = table;
        String db = "\"" + StringUtil.getEscObjName(catalog2) + "\"";
        String db2 = StringUtil.getEscStringName(catalog2);
        String sch2 = StringUtil.getEscStringName(schemaname);
        String tab2 = StringUtil.getEscStringName(tablename);
        StringBuffer strBuf = new StringBuffer();
        strBuf.append("SELECT '");
        strBuf.append(db2);
        strBuf.append("' AS PKTABLE_CAT, '");
        strBuf.append(sch2);
        strBuf.append("' AS PKTABLE_SCHEM, '");
        strBuf.append(tab2);
        strBuf.append("' AS PKTABLE_NAME, T_REFED.REFED_COL_NAME AS PKCOLUMN_NAME, '");
        strBuf.append(db2);
        strBuf.append("' AS FKTABLE_CAT, T_REF.REF_SCH_NAME AS FKTABLE_SCHEM, ");
        strBuf.append("T_REF.REF_TAB_NAME AS FKTABLE_NAME, T_REF.REF_COL_NAME AS FKCOLUMN_NAME, ");
        strBuf.append("T_REF.REF_KEYNO + 1 AS KEY_SEQ, 0 AS UPDATE_RULE, 4 AS DELETE_RULE, ");
        strBuf.append("T_REF.REF_CONS_NAME AS FK_NAME, T_REFED.REFED_CONS_NAME AS PK_NAME, ");
        strBuf.append("0 AS DEFERRABILITY FROM ");
        strBuf.append("(SELECT T_REF_SCH.NAME AS REF_SCH_NAME, T_REF_TAB.NAME AS REF_TAB_NAME, ");
        strBuf.append("T_REF_IND.NAME AS REF_CONS_NAME, T_REF_INDKEY.KEYNO AS REF_KEYNO, ");
        strBuf.append("T_REF_COL.NAME AS REF_COL_NAME, T_REF_CONS.ID AS REFED_ID FROM ");
        strBuf.append("(SELECT NAME AS NAME, ID AS ID, SCHID AS SCHID FROM ");
        strBuf.append(db);
        strBuf.append(".SYSDBA.SYSTABLES WHERE ID IN (SELECT TABLEID FROM ");
        strBuf.append(db);
        strBuf.append(".SYSDBA.SYSINDEXES WHERE ID IN (SELECT FID FROM ");
        strBuf.append(db);
        strBuf.append(".SYSDBA.SYSREFCONSTRAINTS WHERE RID IN ");
        strBuf.append("(SELECT ID FROM ");
        strBuf.append(db);
        strBuf.append(".SYSDBA.SYSINDEXES WHERE TABLEID = (SELECT ID FROM ");
        strBuf.append(db);
        strBuf.append(".SYSDBA.SYSTABLES WHERE NAME = '");
        strBuf.append(tab2);
        strBuf.append("' AND SCHID = (SELECT SCHID FROM ");
        strBuf.append(db);
        strBuf.append(".SYSDBA.SYSSCHEMAS WHERE NAME = '");
        strBuf.append(sch2);
        strBuf.append("')))))) AS T_REF_TAB, ");
        strBuf.append(db);
        strBuf.append(".SYSDBA.SYSSCHEMAS AS T_REF_SCH, ");
        strBuf.append(db);
        strBuf.append(".SYSDBA.SYSREFCONSTRAINTS AS T_REF_CONS, ");
        strBuf.append(db);
        strBuf.append(".SYSDBA.SYSCOLUMNS AS T_REF_COL, ");
        strBuf.append(db);
        strBuf.append(".SYSDBA.SYSINDEXES AS T_REF_IND, ");
        strBuf.append(db);
        strBuf.append(".SYSDBA.SYSINDEXKEYS AS T_REF_INDKEY WHERE ");
        strBuf.append("T_REF_CONS.FID = T_REF_IND.ID AND T_REF_IND.TABLEID = T_REF_TAB.ID AND ");
        strBuf.append("T_REF_TAB.ID = T_REF_COL.ID AND T_REF_IND.ID = T_REF_INDKEY.ID AND ");
        strBuf.append("T_REF_INDKEY.COLID = T_REF_COL.COLID AND T_REF_SCH.SCHID = T_REF_TAB.SCHID) AS T_REF, ");
        strBuf.append("(SELECT T_REFED_IND.NAME AS REFED_CONS_NAME, T_REFED_INDKEY.KEYNO AS REFED_KEYNO, ");
        strBuf.append("T_REFED_COL.NAME AS REFED_COL_NAME, T_REFED_CONS.ID AS REFED_ID FROM ");
        strBuf.append(db);
        strBuf.append(".SYSDBA.SYSINDEXES AS T_REFED_IND, ");
        strBuf.append(db);
        strBuf.append(".SYSDBA.SYSINDEXKEYS AS T_REFED_INDKEY, ");
        strBuf.append(db);
        strBuf.append(".SYSDBA.SYSREFCONSTRAINTS AS T_REFED_CONS, ");
        strBuf.append("(SELECT COLID AS COLID, NAME AS NAME FROM ");
        strBuf.append(db);
        strBuf.append(".SYSDBA.SYSCOLUMNS WHERE ID = (SELECT ID FROM ");
        strBuf.append(db);
        strBuf.append(".SYSDBA.SYSTABLES WHERE NAME = '");
        strBuf.append(tab2);
        strBuf.append("' AND SCHID = (SELECT SCHID FROM ");
        strBuf.append(db);
        strBuf.append(".SYSDBA.SYSSCHEMAS WHERE NAME = '");
        strBuf.append(sch2);
        strBuf.append("'))) AS T_REFED_COL WHERE T_REFED_IND.TABLEID = (SELECT ID FROM ");
        strBuf.append(db);
        strBuf.append(".SYSDBA.SYSTABLES WHERE NAME = '");
        strBuf.append(tab2);
        strBuf.append("' AND SCHID = (SELECT SCHID FROM ");
        strBuf.append(db);
        strBuf.append(".SYSDBA.SYSSCHEMAS WHERE NAME = '");
        strBuf.append(sch2);
        strBuf.append("')) AND T_REFED_IND.ID = T_REFED_CONS.RID AND ");
        strBuf.append("T_REFED_IND.ID = T_REFED_INDKEY.ID AND T_REFED_INDKEY.COLID = T_REFED_COL.COLID ");
        strBuf.append(") AS T_REFED WHERE T_REF.REFED_ID = T_REFED.REFED_ID AND ");
        strBuf.append("T_REF.REF_KEYNO = T_REFED.REFED_KEYNO ORDER BY FKTABLE_CAT ASC, ");
        strBuf.append("FKTABLE_SCHEM ASC, FKTABLE_NAME ASC, KEY_SEQ ASC");
        String sql = strBuf.toString();
        DmdbStatement stmt = null;
        DmdbResultSet rs = null;
        stmt = (DmdbStatement)this._$1222.createStatement(1003, 1007, 1);
        rs = (DmdbResultSet)stmt.executeQuery(sql, 1);
        stmt.close();
        return rs;
    }

    public ResultSet getCrossReference(String primaryCatalog, String primarySchema, String primaryTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        if (primaryTable == null || foreignTable == null) {
            throw new SQLException("NULL TABLE NAME");
        }
        if (primaryCatalog != null && primaryCatalog.equals("") || foreignCatalog != null && foreignCatalog.equals("")) {
            throw new SQLException("There is not a table without a catalog!");
        }
        if (primarySchema != null && primarySchema.equals("") || foreignSchema != null && foreignSchema.equals("")) {
            throw new SQLException("There is not a table without a schema!");
        }
        if (primaryTable != null && primaryTable.equals("") || foreignTable != null && foreignTable.equals("")) {
            return null;
        }
        String pcata = primaryCatalog == null ? this._$1222.getCatalog() : primaryCatalog.trim();
        String pschemaname = primarySchema == null ? this._$1222.getUserName() : primarySchema;
        String ptablename = primaryTable;
        String fcata = foreignCatalog == null ? this._$1222.getCatalog() : foreignCatalog.trim();
        String fschemaname = foreignSchema == null ? this._$1222.getUserName() : foreignSchema;
        String ftablename = foreignTable;
        String pdb = "\"" + StringUtil.getEscObjName(pcata) + "\"";
        String pdb2 = StringUtil.getEscStringName(pcata);
        String psch2 = StringUtil.getEscStringName(pschemaname);
        String ptab2 = StringUtil.getEscStringName(ptablename);
        String fdb = "\"" + StringUtil.getEscObjName(fcata) + "\"";
        String fdb2 = StringUtil.getEscStringName(fcata);
        String fsch2 = StringUtil.getEscStringName(fschemaname);
        String ftab2 = StringUtil.getEscStringName(ftablename);
        if (!pdb.equalsIgnoreCase(fdb)) {
            throw new SQLException("DIFFERENT CATALOG");
        }
        String sql = "SELECT '" + pdb2 + "' AS PKTABLE_CAT,'" + psch2 + "' AS PKTABLE_SCHEM,'" + ptab2 + "' AS PKTABLE_NAME,T_REFED.REFED_COL_NAME AS PKCOLUMN_NAME,'" + fdb2 + "' AS FKTABLE_CAT,'" + fsch2 + "' AS FKTABLE_SCHEM,'" + ftab2 + "' AS FKTABLE_NAME,T_REF.REF_COL_NAME AS FKCOLUMN_NAME,T_REF.REF_KEYNO + 1 AS KEY_SEQ,0 AS UPDATE_RULE,4 AS DELETE_RULE,T_REF.REF_CONS_NAME AS FK_NAME,T_REFED.REFED_CONS_NAME AS PK_NAME,0 AS DEFERRABILITY";
        sql = sql + " FROM (SELECT T_REF_CONS.RID AS REFED_IND_ID,T_REF_IND.NAME AS REF_CONS_NAME,T_REF_INDKEY.KEYNO AS REF_KEYNO,T_REF_COL.NAME AS REF_COL_NAME FROM " + fdb + ".SYSDBA.SYSREFCONSTRAINTS AS T_REF_CONS,(SELECT COLID AS COLID, NAME AS NAME FROM " + fdb + ".SYSDBA.SYSCOLUMNS WHERE ID = (SELECT ID FROM " + fdb + ".SYSDBA.SYSTABLES WHERE NAME = '" + ftab2 + "' AND SCHID = (SELECT SCHID FROM " + pdb + ".SYSDBA.SYSSCHEMAS WHERE NAME = '" + fsch2 + "'))) AS T_REF_COL," + fdb + ".SYSDBA.SYSINDEXES AS T_REF_IND," + fdb + ".SYSDBA.SYSINDEXKEYS AS T_REF_INDKEY WHERE T_REF_IND.TABLEID = (SELECT ID FROM " + fdb + ".SYSDBA.SYSTABLES WHERE NAME = '" + ftab2 + "' AND SCHID = (SELECT SCHID FROM " + pdb + ".SYSDBA.SYSSCHEMAS WHERE NAME = '" + fsch2 + "')) AND T_REF_CONS.FID = T_REF_IND.ID AND T_REF_IND.ID = T_REF_INDKEY.ID AND T_REF_INDKEY.COLID = T_REF_COL.COLID) AS T_REF,";
        sql = sql + "(SELECT T_REFED_IND.ID AS REFED_IND_ID,T_REFED_IND.NAME AS REFED_CONS_NAME,T_REFED_INDKEY.KEYNO AS REFED_KEYNO,T_REFED_COL.NAME AS REFED_COL_NAME FROM " + pdb + ".SYSDBA.SYSINDEXES AS T_REFED_IND," + pdb + ".SYSDBA.SYSINDEXKEYS AS T_REFED_INDKEY,(SELECT COLID AS COLID, NAME AS NAME FROM " + pdb + ".SYSDBA.SYSCOLUMNS WHERE ID = (SELECT ID FROM " + pdb + ".SYSDBA.SYSTABLES WHERE NAME = '" + ptab2 + "' AND SCHID = (SELECT SCHID FROM " + pdb + ".SYSDBA.SYSSCHEMAS WHERE NAME = '" + psch2 + "'))) AS T_REFED_COL";
        sql = sql + " WHERE T_REFED_IND.TABLEID = (SELECT ID FROM " + pdb + ".SYSDBA.SYSTABLES WHERE NAME = '" + ptab2 + "' AND SCHID = (SELECT SCHID FROM " + pdb + ".SYSDBA.SYSSCHEMAS WHERE NAME = '" + psch2 + "')) AND T_REFED_IND.ID = T_REFED_INDKEY.ID AND T_REFED_INDKEY.COLID = T_REFED_COL.COLID AND T_REFED_IND.ISUNIQUE = 'Y') AS T_REFED";
        sql = sql + " WHERE T_REF.REFED_IND_ID = T_REFED.REFED_IND_ID AND T_REF.REF_KEYNO = T_REFED.REFED_KEYNO ORDER BY FKTABLE_CAT ASC,FKTABLE_SCHEM ASC,FKTABLE_NAME ASC,KEY_SEQ ASC";
        DmdbStatement stmt = null;
        DmdbResultSet rs = null;
        stmt = (DmdbStatement)this._$1222.createStatement(1003, 1007, 1);
        rs = (DmdbResultSet)stmt.executeQuery(sql, 1);
        stmt.close();
        return rs;
    }

    public ResultSet getTypeInfo() throws SQLException {
        String sql = "SELECT DISTINCT TYPE_NAME AS TYPE_NAME,";
        sql = sql + " CASE DATA_TYPE WHEN 101 THEN 2000 WHEN 102 THEN 2000 WHEN 103 THEN 2000 WHEN 104 THEN 2000 WHEN 105 THEN 2000 WHEN 106 THEN 2000 WHEN 107 THEN 2000 WHEN 108 THEN 2000 WHEN 109 THEN 2000 WHEN 110 THEN 2000 WHEN 111 THEN 2000 WHEN 112 THEN 2000 WHEN 113 THEN 2000 ELSE DATA_TYPE END AS DATA_TYPE,";
        sql = sql + " COLUMN_SIZE AS \"PRECISION\",LITERAL_PREFIX AS LITERAL_PREFIX,LITERAL_SUFFIX AS LITERAL_SUFFIX,CREATE_PARAMS AS CREATE_PARAMS,NULLABLE AS NULLABLE,CASE_SENSITIVE AS CASE_SENSITIVE,SEARCHABLE AS SEARCHABLE,UNSIGNED_ATTRIBUTE AS UNSIGNED_ATTRIBUTE,FIXED_PREC_SCALE AS FIXED_PREC_SCALE,AUTO_UNIQUE_VALUE AS AUTO_INCREMENT,LOCAL_TYPE_NAME AS LOCAL_TYPE_NAME,MINIMUM_SCALE AS MINIMUM_SCALE,MAXIMUM_SCALE AS MAXIMUM_SCALE,NULL AS SQL_DATA_TYPE,NULL AS SQL_DATETIME_SUB,NUM_PREC_RADIX AS NUM_PREC_RADIX";
        sql = sql + " FROM SYSTEM.SYSDBA.SYSTYPEINFOS WHERE (TYPE_VERSION = 'O3' OR TYPE_VERSION = 'J3') AND TYPE_NAME <> 'double precision' AND TYPE_NAME <> 'image' AND TYPE_NAME <> 'text' AND TYPE_NAME <> 'money'";
        sql = sql + " ORDER BY DATA_TYPE;";
        DmdbStatement stmt = null;
        DmdbResultSet rs = null;
        stmt = (DmdbStatement)this._$1222.createStatement(1003, 1007, 1);
        rs = (DmdbResultSet)stmt.executeQuery(sql, 1);
        stmt.close();
        return rs;
    }

    public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        if (catalog != null && catalog.equals("")) {
            throw new SQLException("There is not a table without a catalog!");
        }
        if (schema != null && schema.equals("")) {
            throw new SQLException("There is not a table without a schema!");
        }
        if (table != null && table.equals("")) {
            return null;
        }
        String catalog2 = catalog == null ? this._$1222.getCatalog() : catalog.trim();
        String schemaname = schema == null ? "%" : schema;
        String tablename = table == null ? "%" : table;
        String db = "\"" + StringUtil.getEscObjName(catalog2) + "\"";
        String db2 = StringUtil.getEscStringName(catalog2);
        String sch2 = StringUtil.getEscStringName(schemaname);
        String tab2 = StringUtil.getEscStringName(tablename);
        String table_clause = null;
        table_clause = this._$10007(tablename) ? " LIKE '" + tab2 + "' escape " + "'" + this._$9987 + "' " : " = '" + tab2 + "' ";
        String sql = new String("");
        if (this._$10007(schemaname)) {
            sql = sql + "SELECT DISTINCT '" + db2;
            sql = sql + "' AS TABLE_CAT,USERS.NAME AS TABLE_SCHEM,TAB.NAME AS TABLE_NAME, ";
            sql = sql + "CASE SYSIND.ISUNIQUE WHEN 'Y' THEN 0 ELSE 1 END AS NON_UNIQUE, NULL AS INDEX_QUALIFIER, ";
            sql = sql + "SYSIND.NAME AS INDEX_NAME,CASE SYSIND.ISDATA WHEN 'Y' THEN 1 ELSE 2 END AS \"TYPE\", ";
            sql = sql + "INDKEY.KEYNO + 1 AS ORDINAL_POSITION,COLS.NAME AS COLUMN_NAME,INDKEY.ADFLAG AS ASC_OR_DESC, ";
            sql = sql + "0 AS CARDINALITY, SYSIND.ROOTPAGE AS PAGES, NULL AS FILTER_CONDITION ";
            sql = sql + " FROM " + db + ".SYSDBA.SYSSCHEMAS USERS," + db + ".SYSDBA.SYSTABLES TAB," + db + ".SYSDBA.SYSINDEXES SYSIND," + db + ".SYSDBA.SYSINDEXKEYS INDKEY," + db + ".SYSDBA.SYSCOLUMNS COLS WHERE USERS.NAME LIKE '" + sch2 + "' ESCAPE " + "'" + this._$9987 + "' " + " AND TAB.NAME " + table_clause + " AND USERS.SCHID = TAB.SCHID AND " + "SYSIND.TABLEID = TAB.ID AND INDKEY.ID = SYSIND.ID AND COLS.ID = TAB.ID AND " + "INDKEY.COLID = COLS.COLID";
        } else {
            sql = sql + "SELECT DISTINCT '" + db2 + "' AS TABLE_CAT,'" + sch2 + "' AS TABLE_SCHEM,TAB.NAME AS TABLE_NAME, ";
            sql = sql + "CASE SYSIND.ISUNIQUE WHEN 'Y' THEN 0 ELSE 1 END AS NON_UNIQUE, NULL AS INDEX_QUALIFIER, ";
            sql = sql + "SYSIND.NAME AS INDEX_NAME,CASE SYSIND.ISDATA WHEN 'Y' THEN 1 ELSE 2 END AS \"TYPE\", ";
            sql = sql + "INDKEY.KEYNO + 1 AS ORDINAL_POSITION,COLS.NAME AS COLUMN_NAME,INDKEY.ADFLAG AS ASC_OR_DESC, ";
            sql = sql + "0 AS CARDINALITY,SYSIND.ROOTPAGE AS PAGES,NULL AS FILTER_CONDITION";
            sql = sql + " FROM (SELECT NAME,ID FROM " + db + ".SYSDBA.SYSTABLES WHERE NAME " + table_clause + " AND SCHID = (SELECT SCHID FROM " + db + ".SYSDBA.SYSSCHEMAS WHERE NAME = '" + sch2 + "')) AS TAB," + db + ".SYSDBA.SYSINDEXES SYSIND," + db + ".SYSDBA.SYSINDEXKEYS INDKEY," + db + ".SYSDBA.SYSCOLUMNS COLS WHERE " + "SYSIND.TABLEID = TAB.ID AND COLS.ID = TAB.ID AND INDKEY.ID = SYSIND.ID AND " + "INDKEY.COLID = COLS.COLID";
        }
        sql = unique ? sql + " AND SYSIND.ISUNIQUE = 'Y' ORDER BY NON_UNIQUE ASC,TYPE ASC,INDEX_NAME ASC,ORDINAL_POSITION ASC;" : sql + " ORDER BY NON_UNIQUE ASC,TYPE ASC,INDEX_NAME ASC,ORDINAL_POSITION ASC;";
        DmdbStatement stmt = null;
        DmdbResultSet rs = null;
        stmt = (DmdbStatement)this._$1222.createStatement(1003, 1007, 1);
        rs = (DmdbResultSet)stmt.executeQuery(sql, 1);
        stmt.close();
        return rs;
    }

    public boolean supportsResultSetType(int type) throws SQLException {
        return type == 1003 || type == 1004;
    }

    public boolean supportsResultSetConcurrency(int type, int concurrency) throws SQLException {
        return true;
    }

    public boolean ownUpdatesAreVisible(int type) throws SQLException {
        return false;
    }

    public boolean ownDeletesAreVisible(int type) throws SQLException {
        return false;
    }

    public boolean ownInsertsAreVisible(int type) throws SQLException {
        return false;
    }

    public boolean othersUpdatesAreVisible(int type) throws SQLException {
        return false;
    }

    public boolean othersDeletesAreVisible(int type) throws SQLException {
        return false;
    }

    public boolean othersInsertsAreVisible(int type) throws SQLException {
        return false;
    }

    public boolean updatesAreDetected(int type) throws SQLException {
        return false;
    }

    public boolean deletesAreDetected(int type) throws SQLException {
        return false;
    }

    public boolean insertsAreDetected(int type) throws SQLException {
        return false;
    }

    public boolean supportsBatchUpdates() throws SQLException {
        return true;
    }

    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        DmdbColumn[] fields = new DmdbColumn[7];
        fields[0] = new DmdbColumn(this._$1222);
        fields[0].setName("TYPE_CAT");
        fields[0].setJdbcSqlType(12);
        fields[0].setPrecision(128);
        fields[0].setScale(0);
        fields[0].setNullable(true);
        fields[1] = new DmdbColumn(this._$1222);
        fields[1].setName("TYPE_SCHEM");
        fields[1].setJdbcSqlType(12);
        fields[1].setPrecision(128);
        fields[1].setScale(0);
        fields[1].setNullable(true);
        fields[2] = new DmdbColumn(this._$1222);
        fields[2].setName("TYPE_NAME");
        fields[2].setJdbcSqlType(12);
        fields[2].setPrecision(128);
        fields[2].setScale(0);
        fields[2].setNullable(false);
        fields[3] = new DmdbColumn(this._$1222);
        fields[3].setName("CLASS_NAME");
        fields[3].setJdbcSqlType(12);
        fields[3].setPrecision(128);
        fields[3].setScale(0);
        fields[3].setNullable(false);
        fields[4] = new DmdbColumn(this._$1222);
        fields[4].setName("DATA_TYPE");
        fields[4].setJdbcSqlType(4);
        fields[4].setPrecision(4);
        fields[4].setScale(0);
        fields[4].setNullable(false);
        fields[5] = new DmdbColumn(this._$1222);
        fields[5].setName("REMARKS");
        fields[5].setJdbcSqlType(12);
        fields[5].setPrecision(1024);
        fields[5].setScale(0);
        fields[5].setNullable(false);
        fields[6] = new DmdbColumn(this._$1222);
        fields[6].setName("BASE_TYPE");
        fields[6].setJdbcSqlType(5);
        fields[6].setPrecision(2);
        fields[6].setScale(0);
        fields[6].setNullable(false);
        DmdbInfo dmInfo = new DmdbInfo();
        dmInfo.setColumnsInfo(fields);
        String s1 = catalog;
        String s2 = schemaPattern;
        String s3 = typeNamePattern;
        if (s1 == null) {
            s1 = this._$1222.getCatalog();
        }
        if (s2 == null) {
            s2 = "%";
        }
        if (s3 == null) {
            s3 = "%";
        }
        dmInfo.setRowCount(0L);
        DmdbResultSet rs = new DmdbResultSet(dmInfo);
        return rs;
    }

    public Connection getConnection() throws SQLException {
        return this._$1222;
    }

    public boolean supportsSavepoints() throws SQLException {
        return true;
    }

    public boolean supportsNamedParameters() throws SQLException {
        return true;
    }

    public boolean supportsMultipleOpenResults() throws SQLException {
        return false;
    }

    public boolean supportsGetGeneratedKeys() throws SQLException {
        return true;
    }

    public ResultSet getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        DmdbColumn[] field = new DmdbColumn[6];
        field[0] = new DmdbColumn(this._$1222);
        field[0].setName("TYPE_CAT");
        field[0].setJdbcSqlType(12);
        field[0].setPrecision(128);
        field[0].setScale(0);
        field[0].setNullable(true);
        field[1] = new DmdbColumn(this._$1222);
        field[1].setName("TYPE_SCHEM");
        field[1].setJdbcSqlType(12);
        field[1].setPrecision(128);
        field[1].setScale(0);
        field[1].setNullable(true);
        field[2] = new DmdbColumn(this._$1222);
        field[2].setName("TYPE_NAME");
        field[2].setJdbcSqlType(12);
        field[2].setPrecision(128);
        field[2].setScale(0);
        field[2].setNullable(false);
        field[3] = new DmdbColumn(this._$1222);
        field[3].setName("SUPERTYPE_CAT");
        field[3].setJdbcSqlType(12);
        field[3].setPrecision(128);
        field[3].setScale(0);
        field[3].setNullable(true);
        field[4] = new DmdbColumn(this._$1222);
        field[4].setName("SUPERTYPE_SCHEM");
        field[4].setJdbcSqlType(12);
        field[4].setPrecision(128);
        field[4].setScale(0);
        field[4].setNullable(true);
        field[5] = new DmdbColumn(this._$1222);
        field[5].setName("SUPERTYPE_NAME");
        field[5].setJdbcSqlType(12);
        field[5].setPrecision(128);
        field[5].setScale(0);
        field[5].setNullable(false);
        DmdbInfo dmInfo = new DmdbInfo();
        dmInfo.setColumnsInfo(field);
        String s1 = catalog;
        String s2 = schemaPattern;
        String s3 = typeNamePattern;
        if (s1 == null) {
            s1 = this._$1222.getCatalog();
        }
        if (s2 == null) {
            s2 = "%";
        }
        if (s3 == null) {
            s3 = "%";
        }
        dmInfo.setRowCount(0L);
        DmdbResultSet rs = new DmdbResultSet(dmInfo);
        return rs;
    }

    public ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        DmdbColumn[] field = new DmdbColumn[4];
        field[0] = new DmdbColumn(this._$1222);
        field[0].setName("TABLE_CAT");
        field[0].setJdbcSqlType(12);
        field[0].setPrecision(128);
        field[0].setScale(0);
        field[0].setNullable(true);
        field[1] = new DmdbColumn(this._$1222);
        field[1].setName("TABLE_SCHEM");
        field[1].setJdbcSqlType(12);
        field[1].setPrecision(128);
        field[1].setScale(0);
        field[1].setNullable(true);
        field[2] = new DmdbColumn(this._$1222);
        field[2].setName("TABLE_NAME");
        field[2].setJdbcSqlType(12);
        field[2].setPrecision(128);
        field[2].setScale(0);
        field[2].setNullable(false);
        field[3] = new DmdbColumn(this._$1222);
        field[3].setName("SUPERTABLE_NAME");
        field[3].setJdbcSqlType(12);
        field[3].setPrecision(128);
        field[3].setScale(0);
        field[3].setNullable(false);
        DmdbInfo dmInfo = new DmdbInfo();
        dmInfo.setColumnsInfo(field);
        String s1 = catalog;
        String s2 = schemaPattern;
        String s3 = tableNamePattern;
        if (s1 == null) {
            s1 = this._$1222.getCatalog();
        }
        if (s2 == null) {
            s2 = "%";
        }
        if (s3 == null) {
            s3 = "%";
        }
        dmInfo.setRowCount(0L);
        DmdbResultSet rs = new DmdbResultSet(dmInfo);
        return rs;
    }

    public ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        DmdbColumn[] field = new DmdbColumn[21];
        field[0] = new DmdbColumn(this._$1222);
        field[0].setName("TYPE_CAT");
        field[0].setJdbcSqlType(12);
        field[0].setPrecision(128);
        field[0].setScale(0);
        field[0].setNullable(true);
        field[1] = new DmdbColumn(this._$1222);
        field[1].setName("TYPE_SCHEM");
        field[1].setJdbcSqlType(12);
        field[1].setPrecision(128);
        field[1].setScale(0);
        field[1].setNullable(true);
        field[2] = new DmdbColumn(this._$1222);
        field[2].setName("TYPE_NAME");
        field[2].setJdbcSqlType(12);
        field[2].setPrecision(128);
        field[2].setScale(0);
        field[2].setNullable(false);
        field[3] = new DmdbColumn(this._$1222);
        field[3].setName("ATTR_NAME");
        field[3].setJdbcSqlType(12);
        field[3].setPrecision(128);
        field[3].setScale(0);
        field[3].setNullable(false);
        field[4] = new DmdbColumn(this._$1222);
        field[4].setName("DATA_TYPE");
        field[4].setJdbcSqlType(4);
        field[4].setPrecision(4);
        field[4].setScale(0);
        field[4].setNullable(false);
        field[5] = new DmdbColumn(this._$1222);
        field[5].setName("ATTR_TYPE_NAME");
        field[5].setJdbcSqlType(12);
        field[5].setPrecision(128);
        field[5].setScale(0);
        field[5].setNullable(false);
        field[6] = new DmdbColumn(this._$1222);
        field[6].setName("ATTR_SIZE");
        field[6].setJdbcSqlType(4);
        field[6].setPrecision(4);
        field[6].setScale(0);
        field[6].setNullable(false);
        field[7] = new DmdbColumn(this._$1222);
        field[7].setName("DECIMAL_DIGITS");
        field[7].setJdbcSqlType(4);
        field[7].setPrecision(4);
        field[7].setScale(0);
        field[7].setNullable(false);
        field[8] = new DmdbColumn(this._$1222);
        field[8].setName("NUM_PREC_RADIX");
        field[8].setJdbcSqlType(4);
        field[8].setPrecision(4);
        field[8].setScale(0);
        field[8].setNullable(false);
        field[9] = new DmdbColumn(this._$1222);
        field[9].setName("NULLABLE");
        field[9].setJdbcSqlType(4);
        field[9].setPrecision(4);
        field[9].setScale(0);
        field[9].setNullable(false);
        field[10] = new DmdbColumn(this._$1222);
        field[10].setName("REMARKS");
        field[10].setJdbcSqlType(12);
        field[10].setPrecision(128);
        field[10].setScale(0);
        field[10].setNullable(false);
        field[11] = new DmdbColumn(this._$1222);
        field[11].setName("ATTR_DEF");
        field[11].setJdbcSqlType(12);
        field[11].setPrecision(128);
        field[11].setScale(0);
        field[11].setNullable(true);
        field[12] = new DmdbColumn(this._$1222);
        field[12].setName("SQL_DATA_TYPE");
        field[12].setJdbcSqlType(4);
        field[12].setPrecision(4);
        field[12].setScale(0);
        field[12].setNullable(false);
        field[13] = new DmdbColumn(this._$1222);
        field[13].setName("SQL_DATETIME_SUB");
        field[13].setJdbcSqlType(12);
        field[13].setPrecision(4);
        field[13].setScale(0);
        field[13].setNullable(false);
        field[14] = new DmdbColumn(this._$1222);
        field[14].setName("CHAR_OCTET_LENGTH");
        field[14].setJdbcSqlType(4);
        field[14].setPrecision(4);
        field[14].setScale(0);
        field[14].setNullable(false);
        field[15] = new DmdbColumn(this._$1222);
        field[15].setName("ORDINAL_POSITION");
        field[15].setJdbcSqlType(4);
        field[15].setPrecision(4);
        field[15].setScale(0);
        field[15].setNullable(false);
        field[16] = new DmdbColumn(this._$1222);
        field[16].setName("IS_NULLABLE");
        field[16].setJdbcSqlType(12);
        field[16].setPrecision(128);
        field[16].setScale(0);
        field[16].setNullable(false);
        field[17] = new DmdbColumn(this._$1222);
        field[17].setName("SCOPE_CATALOG");
        field[17].setJdbcSqlType(12);
        field[17].setPrecision(128);
        field[17].setScale(0);
        field[17].setNullable(false);
        field[18] = new DmdbColumn(this._$1222);
        field[18].setName("SCOPE_SCHEMA");
        field[18].setJdbcSqlType(12);
        field[18].setPrecision(128);
        field[18].setScale(0);
        field[18].setNullable(false);
        field[19] = new DmdbColumn(this._$1222);
        field[19].setName("SCOPE_TABLE");
        field[19].setJdbcSqlType(12);
        field[19].setPrecision(128);
        field[19].setScale(0);
        field[19].setNullable(false);
        field[20] = new DmdbColumn(this._$1222);
        field[20].setName("SOURCE_DATA_TYPE");
        field[20].setJdbcSqlType(5);
        field[20].setPrecision(2);
        field[20].setScale(0);
        field[20].setNullable(false);
        DmdbInfo dmInfo = new DmdbInfo();
        dmInfo.setColumnsInfo(field);
        dmInfo.setRowCount(0L);
        DmdbResultSet rs = new DmdbResultSet(dmInfo);
        return rs;
    }

    public boolean supportsResultSetHoldability(int holdability) throws SQLException {
        return holdability == 2 || holdability == 1;
    }

    public int getResultSetHoldability() throws SQLException {
        return 1;
    }

    public int getDatabaseMajorVersion() throws SQLException {
        return Integer.parseInt(this._$1222.getDmServerVersion().substring(0, 1));
    }

    public int getDatabaseMinorVersion() throws SQLException {
        return Integer.parseInt(this._$1222.getDmServerVersion().substring(2, 3));
    }

    public int getJDBCMajorVersion() throws SQLException {
        return 3;
    }

    public int getJDBCMinorVersion() throws SQLException {
        return 0;
    }

    public int getSQLStateType() throws SQLException {
        return this.XOpen;
    }

    public boolean locatorsUpdateCopy() throws SQLException {
        return false;
    }

    public boolean supportsStatementPooling() throws SQLException {
        return true;
    }
}

