/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.dbaccess.Const;
import dm.jdbc.dbaccess.DBError;
import dm.jdbc.driver.DmDriver;
import dm.jdbc.driver.DmdbCSI;
import dm.jdbc.driver.DmdbCallableStatement;
import dm.jdbc.driver.DmdbDatabaseMetaData;
import dm.jdbc.driver.DmdbPreparedStatement;
import dm.jdbc.driver.DmdbResultSet;
import dm.jdbc.driver.DmdbSavepoint;
import dm.jdbc.driver.DmdbStatement;
import dm.jdbc.driver.DmdbSynchronizeTrx;
import dm.jdbc.pool.DmdbPooledConnection;
import dm.jdbc.util.EscapeProcessor;
import dm.jdbc.util.StringUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.Socket;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;

public class DmdbConnection
implements Connection {
    public static final int SQL_TYPE_UNKNOWN = -1;
    public static final int SQL_TYPE_SELECT = 0;
    public static final int SQL_TYPE_INSERT = 1;
    public static final int SQL_TYPE_DELETE = 2;
    public static final int SQL_TYPE_UPDATE = 3;
    public static final int SQL_TYPE_CALL = 4;
    public static final int SQL_TYPE_CONNECT = 5;
    public static final int SQL_TYPE_DDL = 6;
    public static final int SQL_TYPE_PRIV = 7;
    public static final int SQL_TYPE_OTHER = 8;
    public static final int SQL_TYPE_CUR = 9;
    private String _$6848;
    private String _$1069;
    private String _$1119;
    private String _$7028;
    private ArrayList _$7029 = new ArrayList(2);
    private String _$6802;
    private String _$1177;
    private boolean _$7030 = true;
    private boolean _$7031;
    private int _$7032;
    private int _$7033;
    private int _$7034;
    private int _$7035;
    private int _$7036;
    private boolean _$7037;
    private int _$6588;
    private int _$7038;
    private boolean _$7039;
    private String _$1158;
    private String _$1160;
    private int _$7040;
    private int _$7041;
    private int _$7042;
    private int _$7043;
    private String _$7044;
    private int _$7045;
    Hashtable statement_table;
    protected boolean closed;
    private int _$7047;
    public int trans_level;
    DmdbDatabaseMetaData m_dbMetaData;
    private boolean _$6825;
    private DmdbConnection _$7049;
    private DmdbPooledConnection _$7050;
    static final int DEFAULT_ROW_PREFETCH = 10;
    private int _$7052;
    private SQLWarning _$7053;
    private boolean _$7054;
    private boolean _$7055;
    private static final String _$7056 = "DMDB_SVPT_";
    private Properties _$7057;
    private DmdbCSI _$1694;
    private short _$7058;
    private Statement _$7059;
    public static int maxCachedResultSet;
    private final ResourceBundle _$306 = Const.res;
    private String _$1780 = null;
    public static int PG_SQL_ASCII;
    public static int PG_UTF8;
    public static int PG_GBK;
    public static int PG_BIG5;
    public static int PG_ISO_8859_9;
    public static int PG_EUC_JP;
    public static int PG_EUC_KR;
    public static int PG_KOI8R;
    public short maxRowSize;
    private int _$7068;
    public int ddl_auto_commit;
    public int identifier_case;
    private boolean _$7069 = true;
    Vector stmtPool = null;
    private ConcurrentHashMap _$7071 = null;
    private LinkedList _$7072 = null;
    private ConcurrentHashMap _$7073 = null;
    private LinkedList _$7074 = null;
    private int _$1121 = 0;
    static final int LANGUAGE_CN = 0;
    static final int LANGUAGE_EN = 1;
    public static int lob_mode;
    private byte _$7077 = 0;
    private byte _$7078 = 0;
    private byte _$7079 = 0;
    private int _$7080 = 0;
    private boolean _$7081 = false;
    private boolean _$7082 = false;
    private boolean _$7083 = false;
    public static int infoLevel;
    private boolean _$7084 = true;
    private int _$7085 = 1;
    public static int execSqlNum;
    public static int rsCachedNum;
    protected static HashMap sqlMap;
    static final int TRANSACTION_NONE = 0;
    static final int TRANSACTION_READ_UNCOMMITTED = 1;
    static final int TRANSACTION_READ_COMMITTED = 2;
    static final int TRANSACTION_REPEATABLE_READ = 4;
    static final int TRANSACTION_SERIALIZABLE = 8;

    public DmdbConnection(String s, String s1, String s2, String s3, String s4, String s5, Properties properties) throws SQLException {
        this._$7090(s, s1, s2, s3, s4, s5, properties);
        this._$6825 = false;
        this._$7057 = (Properties)((Hashtable)properties).clone();
        ((Hashtable)this._$7057).remove("password");
        this._$1177 = this._$1177 != null ? this._$1177.trim() : "";
        try {
            this._$1694 = new DmdbCSI(this, this._$1069, this._$1119, this._$1177);
        }
        catch (IOException ioex) {
            DBError.throwSQLException(6001);
        }
        if (this._$7077 != 120) {
            this._$7091(this._$7030);
        }
    }

    public DmdbConnection(DmdbPooledConnection pooledconnection, DmdbConnection connection) throws SQLException {
        short old = this._$7058;
        this._$7090(connection._$6848, connection._$7028, connection._$6802, connection._$1069, connection._$1119, connection._$1177, connection._$7057);
        this._$7058 = old;
        this._$6825 = true;
        this._$7050 = pooledconnection;
        this._$7049 = connection;
        this._$1694 = connection.getCSI();
        this._$7052 = 1;
        if (this._$7077 != 120) {
            this._$7091(this._$7030);
        }
    }

    private void _$7090(String s, String s1, String s2, String s3, String s4, String s5, Properties props) {
        this._$6848 = s;
        this._$7029 = this._$7093(s1);
        this._$7028 = (String)this._$7029.get(0);
        this._$6802 = s2;
        this._$1069 = s3;
        this._$1119 = s4;
        this._$1177 = s5;
        if (null != props) {
            this._$7031 = Boolean.valueOf(props.getProperty("autoReconnect", "false"));
            this._$7032 = Integer.parseInt(props.getProperty("maxReconnect", "3"));
            this._$7033 = Integer.parseInt(props.getProperty("initialTimeout", "2"));
            this._$7034 = Integer.parseInt(props.getProperty("socketTimeout", "0"));
            this._$7035 = Integer.parseInt(props.getProperty("connectTimeout", "0"));
            this._$7036 = Integer.parseInt(props.getProperty("secondsBeforeRetryMaster", "30"));
            this._$7037 = Boolean.valueOf(props.getProperty("continueBatchOnError", "false"));
            this._$7055 = Boolean.valueOf(props.getProperty("escapeProcess", "true"));
            this._$6588 = Integer.parseInt(props.getProperty("maxRows", "0"));
            this._$7047 = Integer.parseInt(props.getProperty("rowPrefetch", "10"));
            this._$7030 = Boolean.valueOf(props.getProperty("autoCommit", "true"));
            maxCachedResultSet = Integer.parseInt(props.getProperty("maxCachedResultSet", "0"));
            lob_mode = Integer.parseInt(props.getProperty("LobMode", "1"));
            this._$7080 = Integer.parseInt(props.getProperty("StmtPoolSize", "0"));
            this._$7081 = Boolean.valueOf(props.getProperty("ignoreCase", "false"));
            this._$7082 = Boolean.valueOf(props.getProperty("comOra", "false"));
            this._$7083 = Boolean.valueOf(props.getProperty("canConnStandby", "false"));
            infoLevel = Integer.parseInt(props.getProperty("infoLevel", "1"));
            this._$7084 = Boolean.valueOf(props.getProperty("alwayseAllowCommit", "true"));
            this._$7085 = Integer.parseInt(props.getProperty("batchType", "1"));
        } else {
            this._$7031 = false;
            this._$7032 = 3;
            this._$7033 = 2;
            this._$7034 = 0;
            this._$7035 = 0;
            this._$7036 = 30;
            this._$7037 = true;
            this._$6588 = 0;
            maxCachedResultSet = 0;
            this._$7054 = false;
            this._$7055 = true;
            this._$7047 = 10;
            this._$7030 = true;
            this._$7081 = false;
            this._$7082 = false;
            this._$7083 = false;
        }
        if (maxCachedResultSet > 0 && maxCachedResultSet < 30) {
            maxCachedResultSet = 30;
        }
        if (maxCachedResultSet > 0) {
            lob_mode = 2;
        }
        this._$7052 = 1;
        this.m_dbMetaData = null;
        this._$7050 = null;
        this._$7049 = null;
        this._$7053 = null;
        this._$7057 = null;
        this.statement_table = new Hashtable(10);
        this.closed = false;
        this.trans_level = -1;
        this._$1694 = null;
        this._$7058 = 0;
        this._$7059 = null;
        this.stmtPool = new Vector(this._$7080);
        this._$7071 = new ConcurrentHashMap(this._$7080);
        this._$7072 = new LinkedList();
        this._$7073 = new ConcurrentHashMap(this._$7080);
        this._$7074 = new LinkedList();
        sqlMap = new HashMap(10);
        try {
            InputStream is = this.getClass().getResourceAsStream("/conf.txt");
            if (is != null) {
                BufferedReader br = new BufferedReader(new InputStreamReader(is));
                String line = null;
                while (null != (line = br.readLine())) {
                    line = line.trim();
                    sqlMap.put(line, line);
                }
                is.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public Properties getProperties() {
        return this._$7057;
    }

    public boolean isLogicalConnection() {
        return this._$6825;
    }

    public synchronized Statement createStatement() throws SQLException {
        this.clearWarnings();
        this._$6602();
        DmdbStatement dmStatement = null;
        if (this.stmtPool.size() > 0) {
            dmStatement = this.getFromStmtPool();
            dmStatement.initializeReuseStmt(this);
        } else {
            dmStatement = new DmdbStatement(this, 1003, 1007, this._$7052);
        }
        return dmStatement;
    }

    public synchronized PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.prepareStatement(sql, 1003, 1007, this._$7052);
    }

    public synchronized CallableStatement prepareCall(String sql) throws SQLException {
        return this.prepareCall(sql, 1003, 1007, this._$7052);
    }

    public String nativeSQL(String sql) throws SQLException {
        return EscapeProcessor.escapeSQL(this, sql);
    }

    public synchronized void setAutoCommit(boolean autoCommit) throws SQLException {
        this._$6602();
        if (this._$7030 == autoCommit) {
            return;
        }
        if (this._$7077 != 120) {
            DmdbStatement stmt = (DmdbStatement)this.createStatement(1003, 1007, 1);
            if (autoCommit) {
                stmt.executeQuery("SELECT DM_SET_SESSION_DML_AUTOCMT(1)");
            } else {
                stmt.executeQuery("SELECT DM_SET_SESSION_DML_AUTOCMT(0)");
            }
            stmt.close();
        }
        this._$7030 = autoCommit;
    }

    public boolean getAutoCommit() throws SQLException {
        return this._$7030;
    }

    public synchronized void commit() throws SQLException {
        this._$6602();
        if (this.getAutoCommit()) {
            if (this._$7084) {
                return;
            }
            DBError.throwSQLException(6042);
        }
        this._$1694.commitWork(this._$7052);
    }

    public synchronized void rollback() throws SQLException {
        this._$6602();
        if (this.getAutoCommit()) {
            if (this._$7084) {
                return;
            }
            DBError.throwSQLException(6042);
        }
        this._$1694.rollbackWork(this._$7052);
    }

    private void _$6602() throws SQLException {
        if (this._$1694 == null || this._$1694.isClosed() || this.isClosed()) {
            DBError.throwSQLException(6060);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws SQLException {
        if (this.closed) {
            return;
        }
        try {
            try {
                this.close_statements();
                if (this._$7059 != null) {
                    this._$7059.close();
                    this._$7059 = null;
                }
            }
            catch (Exception anyEx) {
                // empty catch block
            }
            try {
                if (this._$6825) {
                    this.logicalClose();
                    return;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this._$1694 != null) {
                this._$1694.close();
            }
        }
        finally {
            if (!this._$6825) {
                this._$7104();
                this.closed = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void closeForAgent() throws SQLException {
        if (this.closed) {
            return;
        }
        try {
            if (this._$1694 != null) {
                this._$1694.close();
            }
        }
        finally {
            this._$7104();
            this.closed = true;
        }
    }

    protected void finalize() {
        try {
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void logicalClose() throws SQLException {
        if (this._$7050 != null) {
            this._$7050.logicalClose();
        }
    }

    private void _$7104() {
        this._$1694 = null;
        if (this.statement_table != null) {
            this.statement_table.clear();
        }
        this.statement_table = null;
        this._$7050 = null;
        this.m_dbMetaData = null;
        if (this._$7057 != null) {
            ((Hashtable)this._$7057).clear();
        }
        this._$7057 = null;
    }

    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    public synchronized DatabaseMetaData getMetaData() throws SQLException {
        this._$6602();
        if (this.m_dbMetaData == null) {
            this.m_dbMetaData = new DmdbDatabaseMetaData(this);
        }
        return this.m_dbMetaData;
    }

    public void setReadOnly(boolean readOnly) throws SQLException {
        this._$6602();
        if (this._$7054 == readOnly) {
            return;
        }
        Statement stmt = this.createStatement();
        if (!this._$7030) {
            this.commit();
        }
        if (readOnly) {
            stmt.execute("select set_session_readonly(1)");
        } else {
            stmt.execute("select set_session_readonly(0)");
        }
        if (!this._$7030) {
            this.commit();
        }
        if (stmt != null) {
            stmt.close();
            stmt = null;
        }
        this._$7054 = readOnly;
    }

    public boolean isReadOnly() throws SQLException {
        return this._$7054;
    }

    public void setCatalog(String catalog) throws SQLException {
        if (catalog == null) {
            DBError.throwSQLException(6011);
        }
        String dbName = StringUtil.getEscObjName(catalog);
        Statement stmt = this.createStatement();
        stmt.executeUpdate("set current database \"" + dbName + "\"");
        stmt.close();
    }

    public String getCatalog() throws SQLException {
        DmdbStatement stmt = (DmdbStatement)this.createStatement(1003, 1007, 1);
        ResultSet rs = stmt.executeQuery("select cur_database()", 1);
        stmt.close();
        rs.next();
        String s = rs.getString(1);
        rs.close();
        return s.trim();
    }

    public final String getUserName() throws SQLException {
        DmdbStatement stmt = (DmdbStatement)this.createStatement(1003, 1007, 1);
        ResultSet rs = stmt.executeQuery("select user()", 1);
        stmt.close();
        rs.next();
        String s = rs.getString(1);
        rs.close();
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void setTransactionIsolation(int level) throws SQLException {
        this._$6602();
        if (this._$7059 == null) {
            this._$7059 = this.createStatement(1003, 1007, 1);
        }
        try {
            switch (level) {
                case 0: {
                    this.trans_level = level;
                    return;
                }
                case 2: {
                    this._$7059.execute("set transaction isolation level read COMMITTED");
                    this.trans_level = 2;
                    return;
                }
                case 8: {
                    this._$7059.execute("set transaction isolation level SERIALIZABLE");
                    this.trans_level = 8;
                    return;
                }
                case 1: {
                    this._$7059.execute("set transaction isolation level read UNCOMMITTED");
                    this.trans_level = 1;
                    return;
                }
                case 4: {
                    this._$7059.execute("set transaction isolation level REPEATABLE READ");
                    this.trans_level = 4;
                    return;
                }
                default: {
                    DBError.throwSQLException(6038);
                    return;
                }
            }
        }
        finally {
            if (this._$6825) {
                this._$7049.trans_level = this.trans_level;
            }
        }
    }

    public int getTransactionIsolation() throws SQLException {
        return this.trans_level;
    }

    public SQLWarning getWarnings() throws SQLException {
        return this._$7053;
    }

    public void clearWarnings() throws SQLException {
        this._$7053 = null;
    }

    public void addWarnings(SQLWarning warn) throws SQLException {
        if (this._$7053 == null) {
            this._$7053 = warn;
        } else {
            this._$7053.setNextWarning(warn);
        }
    }

    void add_statement(long handle, Statement statement) {
        this.statement_table.put(new Long(handle), statement);
    }

    void remove_statement(long handle) {
        this.statement_table.remove(new Long(handle));
    }

    void close_all_resultSet() throws SQLException {
        Enumeration e = this.statement_table.elements();
        while (e.hasMoreElements()) {
            DmdbStatement stmt = (DmdbStatement)e.nextElement();
            if (stmt.currentRs == null) continue;
            stmt.currentRs.close();
        }
    }

    protected long getCurpos(long handle) throws SQLException {
        long curPos = 0L;
        if (this.statement_table.containsKey(new Long(handle))) {
            DmdbStatement stmt = (DmdbStatement)this.statement_table.get(new Long(handle));
            if (stmt == null) {
                return curPos;
            }
            DmdbResultSet rs = (DmdbResultSet)stmt.getResultSet();
            if (rs == null) {
                return curPos;
            }
            curPos = rs.getCurrentRowNum();
        }
        return curPos;
    }

    public synchronized void close_statements() throws SQLException {
        Enumeration enumeration = this.statement_table.elements();
        while (enumeration.hasMoreElements()) {
            DmdbStatement stmt = (DmdbStatement)enumeration.nextElement();
            if (stmt == null) continue;
            try {
                stmt.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.remove_statement(stmt.handle);
            Object var2_2 = null;
        }
    }

    public synchronized Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        DmdbStatement dmStatement = null;
        this.clearWarnings();
        this._$6602();
        if (resultSetType == 1005) {
            this.addWarnings(new SQLWarning(this._$306.getString("warn.notSupportedResultType")));
            resultSetType = 1004;
        }
        if (this.stmtPool.size() > 0) {
            dmStatement = this.getFromStmtPool();
            dmStatement.initializeReuseStmt(this);
            dmStatement.resultSetType = resultSetType;
            dmStatement.resultSetConcurrency = resultSetConcurrency;
            dmStatement.resultSetHoldability = this._$7052;
        } else {
            dmStatement = new DmdbStatement(this, resultSetType, resultSetConcurrency, this._$7052);
        }
        return dmStatement;
    }

    public synchronized PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.prepareStatement(sql, resultSetType, resultSetConcurrency, this._$7052);
    }

    public synchronized CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.prepareCall(sql, resultSetType, resultSetConcurrency, this._$7052);
    }

    public Map getTypeMap() throws SQLException {
        return null;
    }

    public synchronized void setTypeMap(Map map) throws SQLException {
        DBError.throwUnsupportedSQLException();
    }

    public synchronized void setHoldability(int holdability) throws SQLException {
        if (holdability == 1 || holdability == 2) {
            this._$7052 = holdability;
        } else {
            DBError.throwSQLException(6055);
        }
    }

    public int getHoldability() throws SQLException {
        return this._$7052;
    }

    public synchronized Savepoint setSavepoint() throws SQLException {
        this._$6602();
        if (this._$7030) {
            DBError.throwSQLException(6039);
        }
        DmdbSavepoint savepoint = new DmdbSavepoint();
        String s = "SAVEPOINT DMDB_SVPT_" + savepoint.getSavepointId();
        if (this._$7059 == null) {
            this._$7059 = this.createStatement(1003, 1007, 1);
        }
        this._$7059.executeUpdate(s);
        return savepoint;
    }

    public synchronized Savepoint setSavepoint(String name) throws SQLException {
        this._$6602();
        if (this._$7030) {
            DBError.throwSQLException(6039);
        }
        if (name == null || name.trim().length() == 0) {
            DBError.throwSQLException(6051);
        }
        DmdbSavepoint savepoint = new DmdbSavepoint(name);
        String s = "SAVEPOINT \"" + StringUtil.getEscObjName(name) + "\"";
        if (this._$7059 == null) {
            this._$7059 = this.createStatement(1003, 1007, 1);
        }
        this._$7059.executeUpdate(s);
        return savepoint;
    }

    public synchronized void rollback(Savepoint savepoint) throws SQLException {
        this._$6602();
        if (this._$7030) {
            if (this._$7084) {
                return;
            }
            DBError.throwSQLException(6042);
        }
        if (((DmdbSavepoint)savepoint).getReleasedFlag()) {
            DBError.throwSQLException(6053);
        }
        String s = "ROLLBACK TO SAVEPOINT \"";
        try {
            s = s + StringUtil.getEscObjName(savepoint.getSavepointName());
            s = s + "\"";
        }
        catch (SQLException sqlexception) {
            s = s + _$7056 + savepoint.getSavepointId();
            s = s + "\"";
        }
        if (this._$7059 == null) {
            this._$7059 = this.createStatement(1003, 1007, 1);
        }
        this._$7059.executeUpdate(s);
    }

    public synchronized void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this._$6602();
        if (this._$7030) {
            DBError.throwSQLException(6041);
        }
        ((DmdbSavepoint)savepoint).setReleasedFlagTrue();
    }

    public synchronized Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        DmdbStatement dmStatement = null;
        this.clearWarnings();
        this._$6602();
        if (!this._$7117(resultSetType, resultSetConcurrency, resultSetHoldability)) {
            DBError.throwSQLException(6055);
        }
        if (resultSetType == 1005) {
            this.addWarnings(new SQLWarning(this._$306.getString("warn.notSupportedResultType")));
            resultSetType = 1004;
        }
        if (this.stmtPool.size() > 0) {
            dmStatement = this.getFromStmtPool();
            dmStatement.initializeReuseStmt(this);
            dmStatement.resultSetType = resultSetType;
            dmStatement.resultSetConcurrency = resultSetConcurrency;
            dmStatement.resultSetHoldability = resultSetHoldability;
        } else {
            dmStatement = new DmdbStatement(this, resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        return dmStatement;
    }

    public synchronized PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        DmdbPreparedStatement pstmt = null;
        if (sql == null || sql.length() == 0) {
            DBError.throwSQLException(6003);
        }
        if (!this._$7117(resultSetType, resultSetConcurrency, resultSetHoldability)) {
            DBError.throwSQLException(6055);
        }
        if (resultSetType == 1005) {
            this.addWarnings(new SQLWarning(this._$306.getString("warn.notSupportedResultType")));
            resultSetType = 1004;
        }
        this._$6602();
        pstmt = this.getFromPreparedStmtPool(sql);
        if (pstmt != null) {
            pstmt.initializeReusePreparedStmt(this, sql);
            pstmt.resultSetType = resultSetType;
            pstmt.resultSetConcurrency = resultSetConcurrency;
            pstmt.resultSetHoldability = resultSetHoldability;
        } else {
            pstmt = new DmdbPreparedStatement(this, sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        return pstmt;
    }

    public synchronized CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        DmdbCallableStatement cstmt = null;
        if (sql == null || sql.length() == 0) {
            DBError.throwSQLException(6003);
        }
        if (!this._$7117(resultSetType, resultSetConcurrency, resultSetHoldability)) {
            DBError.throwSQLException(6055);
        }
        if (resultSetType == 1005) {
            this.addWarnings(new SQLWarning(this._$306.getString("warn.notSupportedResultType")));
            resultSetType = 1004;
        }
        if ((cstmt = this.getFromCallableStmtPool(sql)) != null) {
            cstmt.initializeReuseCallableStmt(this, sql);
            cstmt.resultSetType = resultSetType;
            cstmt.resultSetConcurrency = resultSetConcurrency;
            cstmt.resultSetHoldability = resultSetHoldability;
        } else {
            cstmt = new DmdbCallableStatement(this, sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        return cstmt;
    }

    public synchronized PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        DmdbPreparedStatement pstmt = null;
        if (sql == null || sql.length() == 0) {
            DBError.throwSQLException(6003);
        }
        this._$6602();
        pstmt = this.getFromPreparedStmtPool(sql);
        if (pstmt != null) {
            pstmt.initializeReusePreparedStmt(this, sql);
            pstmt.resultSetType = 1003;
            pstmt.resultSetConcurrency = 1007;
            pstmt.resultSetHoldability = this._$7052;
        } else {
            pstmt = new DmdbPreparedStatement(this, sql, 1003, 1007, this._$7052, autoGeneratedKeys);
        }
        return pstmt;
    }

    public synchronized PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        DmdbPreparedStatement pstmt = null;
        if (sql == null || sql.length() == 0) {
            DBError.throwSQLException(6003);
        }
        this._$6602();
        pstmt = this.getFromPreparedStmtPool(sql);
        if (pstmt != null) {
            pstmt.initializeReusePreparedStmt(this, sql);
            pstmt.resultSetType = 1003;
            pstmt.resultSetConcurrency = 1007;
            pstmt.resultSetHoldability = this._$7052;
        } else {
            pstmt = new DmdbPreparedStatement(this, sql, 1003, 1007, this._$7052, columnIndexes);
        }
        return pstmt;
    }

    public synchronized PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        DmdbPreparedStatement pstmt = null;
        if (sql == null || sql.length() == 0) {
            DBError.throwSQLException(6003);
        }
        this._$6602();
        pstmt = this.getFromPreparedStmtPool(sql);
        if (pstmt != null) {
            pstmt.initializeReusePreparedStmt(this, sql);
            pstmt.resultSetType = 1003;
            pstmt.resultSetConcurrency = 1007;
            pstmt.resultSetHoldability = this._$7052;
        } else {
            pstmt = new DmdbPreparedStatement(this, sql, 1003, 1007, this._$7052, columnNames);
        }
        return pstmt;
    }

    public final void setAutoReconnect(boolean flag) {
        this._$7031 = flag;
    }

    public final boolean getAutoReconnect() {
        return this._$7031;
    }

    public final void setMaxReconnects(int maxValue) {
        this._$7032 = maxValue;
    }

    public final int getMaxReconnects() {
        return this._$7032;
    }

    public final void setInitialTimeout(int initValue) {
        this._$7033 = initValue;
    }

    public final int getInitialTimeout() {
        return this._$7033;
    }

    public final void setSocketTimeout(int initValue) {
        this._$7034 = initValue;
    }

    public final int getSocketTimeout() {
        return this._$7034;
    }

    public final void setConnectTimeout(int initValue) {
        this._$7035 = initValue;
    }

    public final int getConnectTimeout() {
        return this._$7035;
    }

    public final void setDefaultRowPrefetch(int i) throws SQLException {
        if (i <= 0) {
            DBError.throwSQLException(6036);
        }
        this._$7047 = i;
    }

    public final int getDefaultRowPrefetch() {
        return this._$7047;
    }

    public final void setSecondsBeforeRetryMaster(int initValue) {
        this._$7036 = initValue;
    }

    public final int getSecondsBeforeRetryMaster() {
        return this._$7036;
    }

    public final void setMaxRows(int maxValue) {
        this._$6588 = maxValue;
    }

    public final int getMaxRows() {
        return this._$6588;
    }

    public final void setContinueBatchOnError(boolean flag) {
        this._$7037 = flag;
    }

    public final boolean getContinueBatchOnError() {
        return this._$7037;
    }

    public final void setCSI(DmdbCSI csi) {
        this._$1694 = csi;
    }

    public final DmdbCSI getCSI() {
        return this._$1694;
    }

    public final String getURL() {
        return this._$6848;
    }

    public final String getHostName() {
        return this._$7028;
    }

    public final ArrayList getHosts() {
        return this._$7029;
    }

    public final String getLoginName() {
        return this._$1069;
    }

    public final void setDBName(String dbName) {
        this._$1177 = dbName;
    }

    public final String getDBName() {
        return this._$1177;
    }

    public final String getPortNumber() {
        return this._$6802;
    }

    public final String getDmServerVersion() {
        return this._$1694.getDmServerVersion();
    }

    public final void setEscapesProcessing(boolean flag) {
        this._$7055 = flag;
    }

    public final boolean getEscapesProcessing() {
        return this._$7055;
    }

    public String getExplainInfo(String str) throws SQLException {
        return this._$1694.getExplainInfo(str);
    }

    public final boolean getDDL_Autocommit() throws SQLException {
        return this.ddl_auto_commit == 1;
    }

    public final void setDDL_Autocommit(boolean autoCommit) throws SQLException {
        DmdbStatement stmt = (DmdbStatement)this.createStatement(1003, 1007, 1);
        if (autoCommit) {
            stmt.executeQuery("SELECT DM_SET_SESSION_AUTOCMT(1)");
            this.ddl_auto_commit = 1;
        } else {
            stmt.executeQuery("SELECT DM_SET_SESSION_AUTOCMT(0)");
            this.ddl_auto_commit = 0;
        }
        stmt.close();
    }

    public final void getBackSlashEccape() {
        try {
            DmdbStatement stmt = (DmdbStatement)this.createStatement(1003, 1007, 1);
            DmdbResultSet rs = (DmdbResultSet)stmt.executeQuery("select get_para_value('BACKSLASH_ESCAPE')");
            rs.next();
            this._$7068 = rs.getInt(1);
            rs.close();
            stmt.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public final void alarmRecvRequest() throws Exception {
        this._$1694.alarmRecvRequest();
    }

    public final int receiveAlarm() throws Exception {
        return this._$1694.receiveAlarm();
    }

    public final void addAlarm(int[] alarms) throws Exception {
        this._$1694.addAlarm(alarms);
    }

    public final void deleteAlarm(int alarm) throws Exception {
        this._$1694.deleteAlarm(alarm);
    }

    public final void setServerEncoding(String server_encoding) {
        this._$1780 = server_encoding;
    }

    public final String getServerEncoding() {
        return this._$1780;
    }

    public long parse_it(Reader r) {
        DmDriver.parser.parser_deinit();
        return DmDriver.parser.parse_it(r, this._$7068);
    }

    public int getSqlNum() {
        return DmDriver.parser.getSqlNum();
    }

    public int getSqlType(int nth) {
        return DmDriver.parser.getSqlType(nth);
    }

    public String getSql(int nth) {
        return DmDriver.parser.getSql(nth);
    }

    public String[] getSqlWordList(int nth) {
        return DmDriver.parser.getSqlWordList(nth);
    }

    public int[] getSqlWordPos(int nth) {
        return DmDriver.parser.getSqlWordPos(nth);
    }

    public int getParseErrNum() {
        return DmDriver.parser.getParseErrNum();
    }

    public String getParseErrInfo(int nth) {
        return DmDriver.parser.getParseErrInfo(nth);
    }

    public boolean isServerActive() {
        return this._$1694.isServerActive();
    }

    public int getStmtPoolSize() {
        return this.stmtPool.size();
    }

    public void addToStmtPool(DmdbStatement stmt) {
        this.stmtPool.add(stmt);
    }

    public DmdbStatement getFromStmtPool() {
        DmdbStatement stmt = (DmdbStatement)this.stmtPool.firstElement();
        this.stmtPool.remove(0);
        return stmt;
    }

    public void addToPreparedStmtPool(DmdbPreparedStatement pstmt) {
        if (this._$7072.size() >= this.getStmtPoolMaxSize()) {
            DmdbPreparedStatement pstmt2 = (DmdbPreparedStatement)this._$7072.remove(0);
            this._$7071.remove(pstmt2.originalSql);
            try {
                pstmt2.innerClose();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        this._$7071.put(pstmt.originalSql, pstmt);
        this._$7072.add(pstmt);
    }

    public DmdbPreparedStatement getFromPreparedStmtPool(String sql) {
        DmdbPreparedStatement pstmt = (DmdbPreparedStatement)this._$7071.get(sql);
        if (pstmt != null) {
            this._$7071.remove(sql);
            this._$7072.remove(pstmt);
        }
        return pstmt;
    }

    public void addToCallableStmtPool(DmdbCallableStatement cstmt) {
        if (this._$7073.size() >= this.getStmtPoolMaxSize()) {
            DmdbCallableStatement cstmt2 = (DmdbCallableStatement)this._$7074.remove(0);
            this._$7073.remove(cstmt2.originalSql);
            try {
                cstmt2.innerClose();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        this._$7073.put(cstmt.originalSql, cstmt);
        this._$7074.add(cstmt);
    }

    public DmdbCallableStatement getFromCallableStmtPool(String sql) {
        DmdbCallableStatement cstmt = (DmdbCallableStatement)this._$7073.get(sql);
        if (cstmt != null) {
            this._$7073.remove(sql);
            this._$7074.remove(cstmt);
        }
        return cstmt;
    }

    public boolean getCaseSensitive() {
        return this._$7069;
    }

    public int getNetworkPacketSize() {
        return this._$7038;
    }

    public boolean getNetworkEncypted() {
        return this._$7039;
    }

    public void setNetworkPacketSize(int packetSize) {
        this._$7038 = packetSize;
    }

    public void setNetworkEncypted(boolean encrypted) {
        this._$7039 = encrypted;
    }

    public String getLastLoginIP() {
        return this._$1158;
    }

    public String getLastLoginTime() {
        return this._$1160;
    }

    public int getLoginWarningID() {
        return this._$7040;
    }

    public int getGraceTimeRemainder() {
        return this._$7041;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this._$7069 = caseSensitive;
    }

    public void setLastLoginIP(String lastLoginIP) {
        this._$1158 = lastLoginIP;
    }

    public void setLastLoginTime(String lastLoginTime) {
        this._$1160 = lastLoginTime;
    }

    public void setLoginWarningID(int loginWarningID) {
        this._$7040 = loginWarningID;
    }

    public void setGraceTimeRemainder(int gracetimeRemainder) {
        this._$7041 = gracetimeRemainder;
    }

    public int getServerCPUNumber() {
        return this._$7042;
    }

    public int getServerTotalMemory() {
        return this._$7043;
    }

    public String getServerPlatform() {
        return this._$7044;
    }

    public void setServerCPUNumber(int cpuNumber) {
        this._$7042 = cpuNumber;
    }

    public void setServerTotalMemory(int physicalMemorySize) {
        this._$7043 = physicalMemorySize;
    }

    public void setServerPlatform(String platformInfo) {
        this._$7044 = platformInfo;
    }

    public int getFailedAttempt() {
        return this._$7045;
    }

    public void setFailedAttempt(int failedAttempt) {
        this._$7045 = failedAttempt;
    }

    public final void setLanguage(int language) {
        this._$1121 = language;
    }

    public final int getLanguage() {
        return this._$1121;
    }

    public boolean isTrxActive() throws SQLException {
        return this._$1694.isTrxActive();
    }

    public int getGlobalServerSeries() {
        return this._$1694.getGlobalServerSeries();
    }

    public Socket getSocket() {
        return this._$1694.getDbAccess().getSocket();
    }

    private boolean _$7117(int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        boolean checked = true;
        switch (resultSetType) {
            case 1003: 
            case 1004: 
            case 1005: {
                break;
            }
            default: {
                return !checked;
            }
        }
        switch (resultSetConcurrency) {
            case 1007: 
            case 1008: {
                break;
            }
            default: {
                return !checked;
            }
        }
        switch (resultSetHoldability) {
            case 1: 
            case 2: {
                break;
            }
            default: {
                checked = false;
            }
        }
        return checked;
    }

    public DmdbSynchronizeTrx[] getSyncTrx() throws SQLException {
        return this._$1694.getSyncTrx();
    }

    public void heurCommitSyncTrx(int dbMagic, int trxid) throws SQLException {
        this._$1694.heurCommitSyncTrx(dbMagic, trxid);
    }

    public void heurRollbackSyncTrx(int dbMagic, int trxid) throws SQLException {
        this._$1694.heurRollbackSyncTrx(dbMagic, trxid);
    }

    public void setBackslashEsc(int backslashEsc) {
        this._$7068 = backslashEsc;
    }

    public int getBackslashEsc() {
        return this._$7068;
    }

    private synchronized void _$7091(boolean autoCommit) throws SQLException {
        DmdbStatement stmt = (DmdbStatement)this.createStatement(1003, 1007, 1);
        if (autoCommit) {
            stmt.executeQuery("SELECT DM_SET_SESSION_DML_AUTOCMT(1)");
        } else {
            stmt.executeQuery("SELECT DM_SET_SESSION_DML_AUTOCMT(0)");
        }
        stmt.close();
    }

    public void setCmdAutoCommitFlag(byte flag) {
        this._$7077 = flag;
    }

    public byte getCmdAutoCommitFlag() {
        return this._$7077;
    }

    public void setVarLenFlag(byte flag) {
        this._$7078 = flag;
    }

    public byte getVarLenFlag() {
        return this._$7078;
    }

    public void resetPooledConnection(String database, int transLevel, int language, boolean autoCommit) throws SQLException {
        this._$1694.resetPooledConnection(transLevel, database, language, autoCommit);
    }

    public int getStmtPoolMaxSize() {
        return this._$7080;
    }

    public byte getNewStructFlag() {
        return this._$7079;
    }

    public void setNewStructFlag(byte flag) {
        this._$7079 = flag;
    }

    public boolean getIgnoreCase() {
        return this._$7081;
    }

    public boolean getComOra() {
        return this._$7082;
    }

    public boolean getCanConnStandby() {
        return this._$7083;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ArrayList _$7093(String server) {
        boolean found = false;
        String fileName = null;
        String osname = System.getProperty("os.name");
        if (osname.startsWith("Win")) {
            String vmVersion = System.getProperty("java.vm.version");
            String mainVersion = vmVersion.indexOf("1.6.") != -1 ? "1.6" : (vmVersion.indexOf("1.5.") != -1 ? "1.5" : "1.4");
            double version = Double.valueOf(mainVersion);
            if (!(version > 1.4)) {
                this._$7029.add(server);
                return this._$7029;
            }
            fileName = System.getenv("SystemRoot") + "\\system32\\dm_svc.conf";
        } else {
            fileName = "etc/dm_svc.conf";
        }
        try {
            File file = new File(fileName);
            FileInputStream is = new FileInputStream(file);
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            String line = null;
            while (null != (line = br.readLine())) {
                int ind;
                String host = (line = line.trim()).substring(0, ind = line.indexOf(61));
                if (!host.equalsIgnoreCase(server)) continue;
                found = true;
                break;
            }
            ((InputStream)is).close();
            if (!found) {
                this._$7029.add(server);
                return this._$7029;
            }
            int ind1 = line.indexOf(40);
            int ind2 = line.indexOf(41);
            String sub = line.substring(ind1 + 1, ind2);
            String[] ips = sub.split(",");
            int i = 0;
            while (i < ips.length) {
                this._$7029.add(ips[i].trim());
                ++i;
            }
            return this._$7029;
        }
        catch (Exception e) {
            this._$7029.add(server);
        }
        return this._$7029;
    }

    protected int getBatchType() {
        return this._$7085;
    }

    static {
        PG_SQL_ASCII = 0;
        PG_UTF8 = 1;
        PG_GBK = 2;
        PG_BIG5 = 3;
        PG_ISO_8859_9 = 4;
        PG_EUC_JP = 5;
        PG_EUC_KR = 6;
        PG_KOI8R = 7;
        lob_mode = 1;
        infoLevel = 1;
        execSqlNum = 0;
        rsCachedNum = 0;
        sqlMap = null;
    }
}

