/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.dbaccess.DBError;
import dm.jdbc.driver.DmdbCallableStatement;
import dm.jdbc.driver.DmdbClobWriter;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.driver.DmdbInputStream;
import dm.jdbc.driver.DmdbLob;
import dm.jdbc.driver.DmdbOutputStream;
import dm.jdbc.driver.DmdbReader;
import dm.jdbc.driver.DmdbStatement;
import dm.jdbc.util.Convertion;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;

public class DmdbClob
extends DmdbLob
implements Clob {
    String serverEncoding = null;
    int byteOffset = 1;
    int charOffset = 1;

    public DmdbClob(DmdbStatement statement, int colIndex, long curPos) throws SQLException {
        super(statement, colIndex, curPos);
        this.serverEncoding = statement.connection.getServerEncoding();
    }

    protected DmdbClob(DmdbCallableStatement cstmt, int colIndex, byte[] value) throws SQLException {
        super(cstmt, colIndex, value);
        this.serverEncoding = this.statement.connection.getServerEncoding();
    }

    protected DmdbClob(byte[] bs, String serverEncoding) throws SQLException {
        super(bs);
        this.serverEncoding = serverEncoding;
    }

    public long length() throws SQLException {
        long len = 0L;
        if (this.statement != null) {
            if (this.statement.lob_mode == 2) {
                String str = Convertion.getString(this.value, 5, this.value.length - 5, this.serverEncoding);
                return str.length();
            }
        } else if (DmdbConnection.lob_mode == 2) {
            String str = Convertion.getString(this.value, 5, this.value.length - 5, this.serverEncoding);
            return str.length();
        }
        if (this.isValueInRow() && (this.fromRowSetFlag || !this.statement.dbInfo.getUpdatable() || this.statement.dbInfo.getUpdatable() && !this.isUpdated)) {
            byte[] buf = this.getValueInRow();
            String str = Convertion.getString(buf, 0, buf.length, this.serverEncoding);
            return str.length();
        }
        len = !this.statement.dbInfo.getUpdatable() ? (long)this.statement.m_csi.lob_get_len(this.statement.handle, -1L, this.dbid, this.tabid, this.rowid_high, this.rowid_low, this.colid, 53) : (long)this.statement.m_csi.lob_get_len(this.statement.handle, this.curPos, this.dbid, this.tabid, this.rowid_high, this.rowid_low, this.colid, 53);
        if (len < 0L) {
            DBError.throwSQLException(6057);
        }
        return len;
    }

    public String getSubString(long pos, int length) throws SQLException {
        if (pos <= 0L || length < 0) {
            DBError.throwSQLException(6057);
        }
        String tmpBuf = null;
        String str = "";
        int maxTextLen = 8000;
        int byte_pos = 0;
        byte[] byteOff = new byte[4];
        if (this.statement != null) {
            if (this.statement.lob_mode == 2) {
                str = Convertion.getString(this.value, 5, this.value.length - 5, this.serverEncoding);
                if (pos > (long)str.length()) {
                    return "";
                }
                if ((long)str.length() < pos - 1L + (long)length) {
                    return str.substring((int)pos - 1);
                }
                return str.substring((int)pos - 1, (int)(pos - 1L + (long)length));
            }
        } else if (DmdbConnection.lob_mode == 2) {
            str = Convertion.getString(this.value, 5, this.value.length - 5, this.serverEncoding);
            if (pos > (long)str.length()) {
                return "";
            }
            if ((long)str.length() < pos - 1L + (long)length) {
                return str.substring((int)pos - 1);
            }
            return str.substring((int)pos - 1, (int)(pos - 1L + (long)length));
        }
        if (this.isValueInRow() && (this.fromRowSetFlag || !this.statement.dbInfo.getUpdatable() || this.statement.dbInfo.getUpdatable() && !this.isUpdated)) {
            byte[] buf = this.getValueInRow();
            str = Convertion.getString(buf, 0, buf.length, this.serverEncoding);
            if (pos > (long)str.length()) {
                return "";
            }
            if ((long)str.length() < pos - 1L + (long)length) {
                return str.substring((int)pos - 1);
            }
            return str.substring((int)pos - 1, (int)(pos - 1L + (long)length));
        }
        if (this.fromRowSetFlag) {
            return null;
        }
        int len = length > maxTextLen ? maxTextLen : length;
        int position = (int)pos;
        int charsGet = 0;
        while (true) {
            if (position == this.charOffset) {
                byte_pos = this.byteOffset;
            }
            if ((tmpBuf = !this.statement.dbInfo.getUpdatable() ? this.statement.m_csi.text_get_subString(this.statement.handle, -1L, this.dbid, this.tabid, this.rowid_high, this.rowid_low, this.colid, position, byte_pos, len, byteOff) : this.statement.m_csi.text_get_subString(this.statement.handle, this.curPos, this.dbid, this.tabid, this.rowid_high, this.rowid_low, this.colid, position, byte_pos, len, byteOff)) == null) break;
            byte_pos = Convertion.fourByteToInt(byteOff);
            if (byte_pos > 0) {
                this.charOffset += tmpBuf.length();
                this.byteOffset = byte_pos;
            } else {
                this.charOffset = 1;
                this.byteOffset = 1;
            }
            str = str + tmpBuf;
            position += tmpBuf.length();
            len = length - (charsGet += tmpBuf.length());
            if (len <= 0) break;
            if (len <= maxTextLen) continue;
            len = maxTextLen;
        }
        return str;
    }

    public Reader getCharacterStream() throws SQLException {
        return new DmdbReader(this);
    }

    public InputStream getAsciiStream() throws SQLException {
        return new DmdbInputStream(this, this.fromRowSetFlag, this.serverEncoding);
    }

    public long position(String searchstr, long start) throws SQLException {
        if (this.fromRowSetFlag || start < 1L) {
            DBError.throwSQLException(6057);
        }
        long length = this.length();
        if ((long)searchstr.length() > length - start + 1L) {
            return -1L;
        }
        String valStr = this.getSubString(start, (int)(length - start + 1L));
        if ((long)valStr.length() < length - start + 1L) {
            return -1L;
        }
        long indexOf = valStr.indexOf(searchstr);
        if (indexOf >= 0L) {
            ++indexOf;
        }
        return indexOf;
    }

    public long position(Clob searchstr, long start) throws SQLException {
        if (this.fromRowSetFlag || start < 1L) {
            DBError.throwSQLException(6057);
        }
        String toSearch = searchstr.getSubString(1L, (int)searchstr.length());
        return this.position(toSearch, start);
    }

    public int setString(long pos, String str) throws SQLException {
        return this.setString(pos, str, 0, str.length());
    }

    public int setString(long pos, String str, int offset, int len) throws SQLException {
        if (pos <= 0L || offset < 0 || len < 0) {
            DBError.throwSQLException(6057);
        }
        if (!this.fromRowSetFlag && !this.statement.dbInfo.getUpdatable()) {
            DBError.throwSQLException(6029);
        }
        if (this.statement != null) {
            if (this.statement.lob_mode == 2) {
                byte[] buf = Convertion.getBytes(str, offset, len, this.serverEncoding);
                len = buf.length;
                System.arraycopy(buf, 0, this.value, (int)pos - 1 + 5, len);
                this.isUpdated = true;
                return len;
            }
        } else if (DmdbConnection.lob_mode == 2) {
            byte[] buf = Convertion.getBytes(str, offset, len, this.serverEncoding);
            len = buf.length;
            System.arraycopy(buf, 0, this.value, (int)pos - 1 + 5, len);
            this.isUpdated = true;
            return len;
        }
        if (this.fromRowSetFlag) {
            if ((long)len + pos - 1L > 1024L) {
                DBError.throwSQLException(6057);
            }
            byte[] tmpbuf = Convertion.getBytes(str, offset, len, this.serverEncoding);
            byte[] bs = new byte[(int)pos + tmpbuf.length - 1 + 5];
            bs[0] = 1;
            byte[] length = Convertion.IntToByteArray((long)tmpbuf.length + pos - 1L);
            System.arraycopy(length, 0, bs, 1, 4);
            System.arraycopy(tmpbuf, 0, bs, 5 + (int)pos - 1, len);
            this.value = bs;
            this.statement = null;
            return len;
        }
        int ret = 0;
        byte[] byteLen = new byte[4];
        byte[] flag = new byte[4];
        int maxTextLen = 8000;
        byte[] buf = Convertion.getBytes(str, offset, len, this.serverEncoding);
        int position = (int)pos;
        int off = 0;
        len = buf.length;
        int length = len > maxTextLen ? maxTextLen : len;
        int count = len / maxTextLen + 1;
        ret = 0;
        for (int i = 0; i < count; ++i) {
            int tmp = this.statement.m_csi.text_set_string(this.statement.handle, this.curPos, this.dbid, this.tabid, this.rowid_high, this.rowid_low, this.colid, position, buf, off, length, byteLen, flag);
            if (tmp <= 0) {
                return ret;
            }
            ret += tmp;
            position += tmp;
            off += length;
            length = i == count - 2 ? len - (off -= Convertion.fourByteToInt(flag)) : maxTextLen;
        }
        this.isUpdated = true;
        return ret;
    }

    public OutputStream setAsciiStream(long pos) throws SQLException {
        if (this.statement != null && this.statement.connection.getComOra() && pos == 0L) {
            pos = 1L;
        }
        if (pos <= 0L) {
            DBError.throwSQLException(6057);
        }
        return new DmdbOutputStream(this, pos);
    }

    public Writer setCharacterStream(long pos) throws SQLException {
        if (this.statement != null && this.statement.connection.getComOra() && pos == 0L) {
            pos = 1L;
        }
        if (pos <= 0L) {
            DBError.throwSQLException(6057);
        }
        return new DmdbClobWriter(this, pos);
    }

    public void truncate(long len) throws SQLException {
        if (len < 0L) {
            DBError.throwSQLException(6057);
        }
        if (this.statement != null) {
            if (this.statement.lob_mode == 2) {
                byte[] tmp = new byte[(int)len + 5];
                System.arraycopy(this.value, 0, tmp, 0, (int)len + 5);
                this.value = tmp;
                this.isUpdated = true;
                return;
            }
        } else if (DmdbConnection.lob_mode == 2) {
            byte[] tmp = new byte[(int)len + 5];
            System.arraycopy(this.value, 0, tmp, 0, (int)len + 5);
            this.value = tmp;
            this.isUpdated = true;
            return;
        }
        if (this.fromRowSetFlag || !this.statement.dbInfo.getUpdatable()) {
            DBError.throwSQLException(6029);
        }
        this.statement.m_csi.blob_text_truncate(this.statement.handle, this.curPos, this.dbid, this.tabid, this.rowid_high, this.rowid_low, this.colid, (int)len, 57);
        this.isUpdated = true;
    }

    public byte[] getBytes(long pos, int length) throws SQLException {
        if (pos <= 0L || length < 0) {
            DBError.throwSQLException(6057);
        }
        byte[] tmpBuf = null;
        byte[] buf = new byte[length];
        if (this.statement != null) {
            if (this.statement.lob_mode == 2) {
                if (pos > (long)(this.value.length - 5)) {
                    return null;
                }
                if ((long)(this.value.length - 5) - pos + 1L < (long)length) {
                    buf = new byte[(int)((long)(this.value.length - 5) - pos + 1L)];
                }
                System.arraycopy(this.value, (int)pos - 1 + 5, buf, 0, buf.length);
                return buf;
            }
        } else if (DmdbConnection.lob_mode == 2) {
            if (pos > (long)(this.value.length - 5)) {
                return null;
            }
            if ((long)(this.value.length - 5) - pos + 1L < (long)length) {
                buf = new byte[(int)((long)(this.value.length - 5) - pos + 1L)];
            }
            System.arraycopy(this.value, (int)pos - 1 + 5, buf, 0, buf.length);
            return buf;
        }
        if (this.isValueInRow() && (this.fromRowSetFlag || !this.statement.dbInfo.getUpdatable() || this.statement.dbInfo.getUpdatable() && !this.isUpdated)) {
            byte[] val = this.getValueInRow();
            if (pos > this.length()) {
                return null;
            }
            if ((long)val.length - pos + 1L <= (long)length) {
                buf = new byte[(int)((long)val.length - pos + 1L)];
            }
            System.arraycopy(val, (int)(pos - 1L), buf, 0, buf.length);
            return buf;
        }
        int count = length / 16000 + 1;
        int len = length > 16000 ? 16000 : length;
        int position = (int)pos;
        int offset = 0;
        for (int i = 0; i < count && (tmpBuf = !this.statement.dbInfo.getUpdatable() ? this.statement.m_csi.blob_get_bytes(this.statement.handle, -1L, this.dbid, this.tabid, this.rowid_high, this.rowid_low, this.colid, position, len) : this.statement.m_csi.blob_get_bytes(this.statement.handle, this.curPos, this.dbid, this.tabid, this.rowid_high, this.rowid_low, this.colid, position, len)) != null; ++i) {
            System.arraycopy(tmpBuf, 0, buf, offset, tmpBuf.length);
            position += tmpBuf.length;
            len = length - (offset += tmpBuf.length);
            if (len <= 0) break;
            if (len <= 16000) continue;
            len = 16000;
        }
        if (offset == length) {
            return buf;
        }
        byte[] tmpVal = new byte[offset];
        System.arraycopy(buf, 0, tmpVal, 0, offset);
        return tmpVal;
    }
}

