/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.dbaccess.Const;
import dm.jdbc.dbaccess.DBError;
import dm.jdbc.driver.DmdbBlob;
import dm.jdbc.driver.DmdbClob;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.driver.DmdbPreparedStatement;
import dm.jdbc.util.Convertion;
import dm.sql.DmdbDateTime;
import dm.sql.DmdbIntervalDT;
import dm.sql.DmdbIntervalYM;
import dm.sql.DmdbTime;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;

public class DmdbCallableStatement
extends DmdbPreparedStatement
implements CallableStatement {
    DmdbConnection conn;
    boolean wasNullFlag;

    void initializeReuseCallableStmt(DmdbConnection conn, String sql) throws SQLException {
        super.initializeReusePreparedStmt(conn, sql);
        this.conn = conn;
        this.type = 2;
    }

    DmdbCallableStatement(DmdbConnection conn, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        super(conn, sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        this.conn = conn;
        this.type = 2;
    }

    public synchronized void registerOutParameter(int parameterIndex, int sqlType) throws SQLException {
        int pCount = this.dbInfo.getParameterCount();
        if (parameterIndex < 0 || parameterIndex > pCount) {
            DBError.throwSQLException(Const.res.getString("error.InvalidParamIndex"));
        }
        this.params[parameterIndex - 1].setRegisterParamType(sqlType);
    }

    public synchronized void registerOutParameter(int parameterIndex, int sqlType, int scale) throws SQLException {
        this.registerOutParameter(parameterIndex, sqlType);
        if (scale < 0) {
            DBError.throwSQLException(6049);
        }
        this.params[parameterIndex - 1].setRegisterParamType(sqlType);
        this.params[parameterIndex - 1].setRegisterParamScale(scale);
    }

    public boolean wasNull() throws SQLException {
        return this.wasNullFlag;
    }

    public String getString(int parameterIndex) throws SQLException {
        this.checkIndex(parameterIndex);
        byte[] bs = null;
        if (this.params[parameterIndex - 1].getInOutType() == 0) {
            this.wasNullFlag = this.params[parameterIndex - 1].getIsInDataNull();
            bs = this.params[parameterIndex - 1].getInValue();
        } else {
            this.wasNullFlag = this.params[parameterIndex - 1].getIsOutDataNull();
            bs = this.params[parameterIndex - 1].getOutValue();
        }
        if (this.wasNullFlag) {
            return null;
        }
        String returnStr = null;
        int jdbcsqltype = this.params[parameterIndex - 1].getJdbcSqlType();
        switch (jdbcsqltype) {
            case -7: {
                returnStr = String.valueOf(this.getByte(parameterIndex));
                break;
            }
            case 16: {
                returnStr = String.valueOf(this.getBoolean(parameterIndex));
                break;
            }
            case -6: {
                returnStr = String.valueOf(this.getByte(parameterIndex));
                break;
            }
            case 5: {
                returnStr = String.valueOf(this.getShort(parameterIndex));
                break;
            }
            case 4: {
                returnStr = String.valueOf(this.getInt(parameterIndex));
                break;
            }
            case -5: {
                returnStr = String.valueOf(this.getLong(parameterIndex));
                break;
            }
            case 7: {
                returnStr = String.valueOf(this.getFloat(parameterIndex));
                break;
            }
            case 6: {
                returnStr = String.valueOf(this.getDouble(parameterIndex));
                break;
            }
            case 8: {
                returnStr = String.valueOf(this.getDouble(parameterIndex));
                break;
            }
            case 2: {
                returnStr = String.valueOf(this.getBigDecimal(parameterIndex));
                break;
            }
            case 3: {
                returnStr = String.valueOf(this.getBigDecimal(parameterIndex));
                break;
            }
            case 91: {
                returnStr = String.valueOf(this.getDate(parameterIndex));
                break;
            }
            case 92: {
                DmdbDateTime dt = new DmdbDateTime(bs);
                returnStr = dt.getTimeInString();
                break;
            }
            case 93: {
                returnStr = String.valueOf(this.getTimestamp(parameterIndex));
                break;
            }
            case -2: {
                bs = this.getBytes(parameterIndex);
                returnStr = Convertion.bytesToHexString(bs);
                break;
            }
            case -3: {
                bs = this.getBytes(parameterIndex);
                returnStr = Convertion.bytesToHexString(bs);
                break;
            }
            case -4: 
            case 2004: {
                bs = this.getBytes(parameterIndex);
                returnStr = Convertion.bytesToHexString(bs);
                break;
            }
            case -1: 
            case 2005: {
                bs = this.getBytes(parameterIndex);
                returnStr = Convertion.getString(bs, 0, bs.length, this.conn.getServerEncoding());
                break;
            }
            default: {
                returnStr = Convertion.getString(bs, 0, bs.length, this.conn.getServerEncoding());
            }
        }
        return returnStr;
    }

    public boolean getBoolean(int parameterIndex) throws SQLException {
        this.checkIndex(parameterIndex);
        this.wasNullFlag = this.params[parameterIndex - 1].getInOutType() == 0 ? this.params[parameterIndex - 1].getIsInDataNull() : this.params[parameterIndex - 1].getIsOutDataNull();
        if (this.wasNullFlag) {
            return false;
        }
        int type = this.params[parameterIndex - 1].getJdbcSqlType();
        boolean ret = false;
        switch (type) {
            case -7: 
            case -6: 
            case 16: {
                ret = this.getByte(parameterIndex) > 0;
                break;
            }
            case 5: {
                ret = this.getShort(parameterIndex) > 0;
                break;
            }
            case 4: {
                ret = this.getInt(parameterIndex) > 0;
                break;
            }
            case -5: {
                ret = this.getLong(parameterIndex) > 0L;
                break;
            }
            case 7: {
                ret = this.getFloat(parameterIndex) > 0.0f;
                break;
            }
            case 6: 
            case 8: {
                ret = this.getDouble(parameterIndex) > 0.0;
                break;
            }
            case 2: 
            case 3: {
                ret = this.getBigDecimal(parameterIndex).byteValue() > 0;
                break;
            }
            default: {
                String str = this.getString(parameterIndex);
                ret = str == null ? false : str.startsWith("T") || str.startsWith("t") || str.trim().startsWith("1");
            }
        }
        return ret;
    }

    public byte getByte(int parameterIndex) throws SQLException {
        this.checkIndex(parameterIndex);
        byte[] bs = null;
        if (this.params[parameterIndex - 1].getInOutType() == 0) {
            this.wasNullFlag = this.params[parameterIndex - 1].getIsInDataNull();
            bs = this.params[parameterIndex - 1].getInValue();
        } else {
            this.wasNullFlag = this.params[parameterIndex - 1].getIsOutDataNull();
            bs = this.params[parameterIndex - 1].getOutValue();
        }
        if (this.wasNullFlag) {
            return 0;
        }
        int type = this.params[parameterIndex - 1].getJdbcSqlType();
        byte ret = 0;
        switch (type) {
            case -7: 
            case -6: 
            case 16: {
                ret = bs[0];
                break;
            }
            case 5: {
                short tmp = this.getShort(parameterIndex);
                if (tmp < -128 || tmp > 127) {
                    throw new SQLException(Const.res.getString("error.overflow"));
                }
                ret = (byte)tmp;
                break;
            }
            case 4: {
                int tmp = this.getInt(parameterIndex);
                if (tmp < -128 || tmp > 127) {
                    throw new SQLException(Const.res.getString("error.overflow"));
                }
                ret = (byte)tmp;
                break;
            }
            case -5: {
                long tmp = this.getLong(parameterIndex);
                if (tmp < -128L || tmp > 127L) {
                    throw new SQLException(Const.res.getString("error.overflow"));
                }
                ret = (byte)tmp;
                break;
            }
            case 7: {
                float tmp = this.getFloat(parameterIndex);
                if (tmp < -128.0f || tmp > 127.0f) {
                    throw new SQLException(Const.res.getString("error.overflow"));
                }
                ret = (byte)tmp;
                break;
            }
            case 6: 
            case 8: {
                double tmp = this.getDouble(parameterIndex);
                if (tmp < -128.0 || tmp > 127.0) {
                    throw new SQLException(Const.res.getString("error.overflow"));
                }
                ret = (byte)tmp;
                break;
            }
            case 2: 
            case 3: {
                ret = this.getBigDecimal(parameterIndex).byteValue();
                break;
            }
            default: {
                String str = this.getString(parameterIndex);
                try {
                    ret = Double.valueOf(str).byteValue();
                    break;
                }
                catch (NumberFormatException e) {
                    DBError.throwSQLException(6012);
                }
            }
        }
        return ret;
    }

    public short getShort(int parameterIndex) throws SQLException {
        this.checkIndex(parameterIndex);
        byte[] bs = null;
        if (this.params[parameterIndex - 1].getInOutType() == 0) {
            this.wasNullFlag = this.params[parameterIndex - 1].getIsInDataNull();
            bs = this.params[parameterIndex - 1].getInValue();
        } else {
            this.wasNullFlag = this.params[parameterIndex - 1].getIsOutDataNull();
            bs = this.params[parameterIndex - 1].getOutValue();
        }
        if (this.wasNullFlag) {
            return 0;
        }
        int type = this.params[parameterIndex - 1].getJdbcSqlType();
        short ret = 0;
        switch (type) {
            case -7: 
            case -6: 
            case 16: {
                ret = this.getByte(parameterIndex);
                break;
            }
            case 5: {
                ret = Convertion.twoByteToShort(bs);
                break;
            }
            case 4: {
                int tmp = this.getInt(parameterIndex);
                if (tmp < Short.MIN_VALUE || tmp > Short.MAX_VALUE) {
                    throw new SQLException(Const.res.getString("error.overflow"));
                }
                ret = (short)tmp;
                break;
            }
            case -5: {
                long tmp = this.getLong(parameterIndex);
                if (tmp < -32768L || tmp > 32767L) {
                    throw new SQLException(Const.res.getString("error.overflow"));
                }
                ret = (short)tmp;
                break;
            }
            case 7: {
                float tmp = this.getFloat(parameterIndex);
                if (tmp < -32768.0f || tmp > 32767.0f) {
                    throw new SQLException(Const.res.getString("error.overflow"));
                }
                ret = (short)tmp;
                break;
            }
            case 6: 
            case 8: {
                double tmp = this.getDouble(parameterIndex);
                if (tmp < -32768.0 || tmp > 32767.0) {
                    throw new SQLException(Const.res.getString("error.overflow"));
                }
                ret = (short)tmp;
                break;
            }
            case 2: 
            case 3: {
                ret = this.getBigDecimal(parameterIndex).shortValue();
                break;
            }
            default: {
                String str = this.getString(parameterIndex);
                try {
                    ret = Double.valueOf(str).shortValue();
                    break;
                }
                catch (NumberFormatException e) {
                    DBError.throwSQLException(6012);
                }
            }
        }
        return ret;
    }

    public int getInt(int parameterIndex) throws SQLException {
        this.checkIndex(parameterIndex);
        byte[] bs = null;
        if (this.params[parameterIndex - 1].getInOutType() == 0) {
            this.wasNullFlag = this.params[parameterIndex - 1].getIsInDataNull();
            bs = this.params[parameterIndex - 1].getInValue();
        } else {
            this.wasNullFlag = this.params[parameterIndex - 1].getIsOutDataNull();
            bs = this.params[parameterIndex - 1].getOutValue();
        }
        if (this.wasNullFlag) {
            return 0;
        }
        int type = this.params[parameterIndex - 1].getJdbcSqlType();
        int ret = 0;
        switch (type) {
            case -7: 
            case -6: 
            case 16: {
                ret = this.getByte(parameterIndex);
                break;
            }
            case 5: {
                ret = this.getShort(parameterIndex);
                break;
            }
            case 4: {
                ret = Convertion.fourByteToInt(bs);
                break;
            }
            case -5: {
                long tmp = this.getLong(parameterIndex);
                if (tmp < Integer.MIN_VALUE || tmp > Integer.MAX_VALUE) {
                    throw new SQLException(Const.res.getString("error.overflow"));
                }
                ret = (int)tmp;
                break;
            }
            case 7: {
                float tmp = this.getFloat(parameterIndex);
                if (tmp < -2.1474836E9f || tmp > 2.1474836E9f) {
                    throw new SQLException(Const.res.getString("error.overflow"));
                }
                ret = (int)tmp;
                break;
            }
            case 6: 
            case 8: {
                double tmp = this.getDouble(parameterIndex);
                if (tmp < -2.147483648E9 || tmp > 2.147483647E9) {
                    throw new SQLException(Const.res.getString("error.overflow"));
                }
                ret = (int)tmp;
                break;
            }
            case 2: 
            case 3: {
                ret = this.getBigDecimal(parameterIndex).intValue();
                break;
            }
            default: {
                String str = this.getString(parameterIndex);
                try {
                    ret = Double.valueOf(str).intValue();
                    break;
                }
                catch (NumberFormatException e) {
                    DBError.throwSQLException(6012);
                }
            }
        }
        return ret;
    }

    public long getLong(int parameterIndex) throws SQLException {
        this.checkIndex(parameterIndex);
        byte[] bs = null;
        if (this.params[parameterIndex - 1].getInOutType() == 0) {
            this.wasNullFlag = this.params[parameterIndex - 1].getIsInDataNull();
            bs = this.params[parameterIndex - 1].getInValue();
        } else {
            this.wasNullFlag = this.params[parameterIndex - 1].getIsOutDataNull();
            bs = this.params[parameterIndex - 1].getOutValue();
        }
        if (this.wasNullFlag) {
            return 0L;
        }
        int type = this.params[parameterIndex - 1].getJdbcSqlType();
        long ret = 0L;
        switch (type) {
            case -7: 
            case -6: 
            case 16: {
                ret = this.getByte(parameterIndex);
                break;
            }
            case 5: {
                ret = this.getShort(parameterIndex);
                break;
            }
            case 4: {
                ret = this.getInt(parameterIndex);
                break;
            }
            case -5: {
                ret = Convertion.eightByteToLong(bs);
                break;
            }
            case 7: {
                ret = (long)this.getFloat(parameterIndex);
                break;
            }
            case 6: 
            case 8: {
                ret = (long)this.getDouble(parameterIndex);
                break;
            }
            case 2: 
            case 3: {
                ret = this.getBigDecimal(parameterIndex).longValue();
                break;
            }
            default: {
                String str = this.getString(parameterIndex);
                try {
                    ret = Double.valueOf(str).intValue();
                    break;
                }
                catch (NumberFormatException e) {
                    DBError.throwSQLException(6012);
                }
            }
        }
        return ret;
    }

    public float getFloat(int parameterIndex) throws SQLException {
        this.checkIndex(parameterIndex);
        byte[] bs = null;
        if (this.params[parameterIndex - 1].getInOutType() == 0) {
            this.wasNullFlag = this.params[parameterIndex - 1].getIsInDataNull();
            bs = this.params[parameterIndex - 1].getInValue();
        } else {
            this.wasNullFlag = this.params[parameterIndex - 1].getIsOutDataNull();
            bs = this.params[parameterIndex - 1].getOutValue();
        }
        if (this.wasNullFlag) {
            return 0.0f;
        }
        int type = this.params[parameterIndex - 1].getJdbcSqlType();
        float ret = 0.0f;
        switch (type) {
            case -7: 
            case -6: 
            case 16: {
                ret = this.getByte(parameterIndex);
                break;
            }
            case 5: {
                ret = this.getShort(parameterIndex);
                break;
            }
            case 4: {
                ret = this.getInt(parameterIndex);
                break;
            }
            case -5: {
                ret = this.getLong(parameterIndex);
                break;
            }
            case 7: {
                ret = Float.intBitsToFloat(Convertion.fourByteToInt(bs));
                break;
            }
            case 6: {
                if (bs.length == 8) {
                    double d = Double.longBitsToDouble(Convertion.eightByteToLong(bs));
                    ret = (float)d;
                    break;
                }
                if (bs.length == 4) {
                    ret = Float.intBitsToFloat(Convertion.fourByteToInt(bs));
                    break;
                }
                DBError.throwSQLException(6012);
                break;
            }
            case 8: {
                ret = (float)this.getDouble(parameterIndex);
                break;
            }
            case 2: 
            case 3: {
                ret = this.getBigDecimal(parameterIndex).floatValue();
                break;
            }
            default: {
                String str = this.getString(parameterIndex);
                try {
                    ret = Double.valueOf(str).intValue();
                    break;
                }
                catch (NumberFormatException e) {
                    DBError.throwSQLException(6012);
                }
            }
        }
        return ret;
    }

    public double getDouble(int parameterIndex) throws SQLException {
        this.checkIndex(parameterIndex);
        byte[] bs = null;
        if (this.params[parameterIndex - 1].getInOutType() == 0) {
            this.wasNullFlag = this.params[parameterIndex - 1].getIsInDataNull();
            bs = this.params[parameterIndex - 1].getInValue();
        } else {
            this.wasNullFlag = this.params[parameterIndex - 1].getIsOutDataNull();
            bs = this.params[parameterIndex - 1].getOutValue();
        }
        if (this.wasNullFlag) {
            return 0.0;
        }
        int type = this.params[parameterIndex - 1].getJdbcSqlType();
        double ret = 0.0;
        switch (type) {
            case -7: 
            case -6: 
            case 16: {
                ret = this.getByte(parameterIndex);
                break;
            }
            case 5: {
                ret = this.getShort(parameterIndex);
                break;
            }
            case 4: {
                ret = this.getInt(parameterIndex);
                break;
            }
            case -5: {
                ret = this.getLong(parameterIndex);
                break;
            }
            case 7: {
                ret = this.getFloat(parameterIndex);
                break;
            }
            case 6: 
            case 8: {
                ret = Double.longBitsToDouble(Convertion.eightByteToLong(bs));
                break;
            }
            case 2: 
            case 3: {
                ret = this.getBigDecimal(parameterIndex).doubleValue();
                break;
            }
            default: {
                String str = this.getString(parameterIndex);
                try {
                    ret = Double.valueOf(str).intValue();
                    break;
                }
                catch (NumberFormatException e) {
                    DBError.throwSQLException(6012);
                }
            }
        }
        return ret;
    }

    public BigDecimal getBigDecimal(int parameterIndex, int scale) throws SQLException {
        this.checkIndex(parameterIndex);
        BigDecimal bd = this._$10135(parameterIndex);
        if (this.wasNullFlag) {
            return null;
        }
        return bd.setScale(scale, 4);
    }

    public byte[] getBytes(int parameterIndex) throws SQLException {
        byte[] buf;
        this.checkIndex(parameterIndex);
        byte[] data = null;
        if (this.params[parameterIndex - 1].getInOutType() == 0) {
            this.wasNullFlag = this.params[parameterIndex - 1].getIsInDataNull();
            data = this.params[parameterIndex - 1].getInValue();
        } else {
            this.wasNullFlag = this.params[parameterIndex - 1].getIsOutDataNull();
            data = this.params[parameterIndex - 1].getOutValue();
        }
        if (this.wasNullFlag) {
            return null;
        }
        int len = data.length;
        int type = this.params[parameterIndex - 1].getJdbcSqlType();
        switch (type) {
            case -3: 
            case -2: {
                break;
            }
            case -4: 
            case -1: 
            case 2004: 
            case 2005: {
                if (data.length < 5) {
                    DBError.throwSQLException(Const.res.getString("error.Lob.length"));
                }
                boolean realData = false;
                if ((data[0] & 1) == 1) {
                    realData = true;
                } else if ((data[0] & 2) == 2) {
                    realData = false;
                }
                if (realData) {
                    byte[] s1 = new byte[4];
                    System.arraycopy(data, 1, s1, 0, 4);
                    len = Math.min(data.length - 5, Convertion.fourByteToInt(s1));
                    buf = new byte[len];
                    System.arraycopy(data, 5, buf, 0, len);
                    data = buf;
                    break;
                }
                byte[] s2 = Convertion.getMetaDataPointer(data);
                byte[] s3 = new byte[4];
                System.arraycopy(data, 1, s3, 0, 4);
                int chunkSize = Convertion.fourByteToInt(s3);
                byte[] value = null;
                value = this.m_csi.getBlobData(this.handle, true, s2, 1, chunkSize);
                data = value;
            }
        }
        int maxFieldSize = this.getMaxFieldSize();
        if (maxFieldSize > 0 && len < maxFieldSize) {
            len = maxFieldSize;
            buf = new byte[len];
            System.arraycopy(data, 0, buf, 0, len);
            return buf;
        }
        return data;
    }

    public Date getDate(int parameterIndex) throws SQLException {
        this.checkIndex(parameterIndex);
        byte[] bs = null;
        if (this.params[parameterIndex - 1].getInOutType() == 0) {
            this.wasNullFlag = this.params[parameterIndex - 1].getIsInDataNull();
            bs = this.params[parameterIndex - 1].getInValue();
        } else {
            this.wasNullFlag = this.params[parameterIndex - 1].getIsOutDataNull();
            bs = this.params[parameterIndex - 1].getOutValue();
        }
        if (this.wasNullFlag) {
            return null;
        }
        int type = this.params[parameterIndex - 1].getJdbcSqlType();
        DmdbDateTime dt = new DmdbDateTime(bs);
        switch (type) {
            case 91: {
                return dt.getDate();
            }
            case 93: {
                return new Date(dt.getTimestamp().getTime());
            }
        }
        try {
            return DmdbDateTime.getDateByString(this.getString(parameterIndex));
        }
        catch (Exception ex) {
            DBError.throwSQLException(6013);
            return Date.valueOf("1900-01-01");
        }
    }

    public Time getTime(int parameterIndex) throws SQLException {
        this.checkIndex(parameterIndex);
        byte[] bs = null;
        if (this.params[parameterIndex - 1].getInOutType() == 0) {
            this.wasNullFlag = this.params[parameterIndex - 1].getIsInDataNull();
            bs = this.params[parameterIndex - 1].getInValue();
        } else {
            this.wasNullFlag = this.params[parameterIndex - 1].getIsOutDataNull();
            bs = this.params[parameterIndex - 1].getOutValue();
        }
        if (this.wasNullFlag) {
            return null;
        }
        if (this.wasNullFlag) {
            return null;
        }
        int type = this.params[parameterIndex - 1].getJdbcSqlType();
        DmdbDateTime dt = new DmdbDateTime(bs);
        switch (type) {
            case 92: {
                return dt.getTime();
            }
            case 93: {
                return new Time(dt.getTimestamp().getTime());
            }
        }
        try {
            return Time.valueOf(this.getString(parameterIndex));
        }
        catch (Exception ex) {
            DBError.throwSQLException(6014);
            return Time.valueOf("00:00:00");
        }
    }

    public Timestamp getTimestamp(int parameterIndex) throws SQLException {
        this.checkIndex(parameterIndex);
        byte[] bs = null;
        if (this.params[parameterIndex - 1].getInOutType() == 0) {
            this.wasNullFlag = this.params[parameterIndex - 1].getIsInDataNull();
            bs = this.params[parameterIndex - 1].getInValue();
        } else {
            this.wasNullFlag = this.params[parameterIndex - 1].getIsOutDataNull();
            bs = this.params[parameterIndex - 1].getOutValue();
        }
        if (this.wasNullFlag) {
            return null;
        }
        int type = this.params[parameterIndex - 1].getJdbcSqlType();
        DmdbDateTime dt = new DmdbDateTime(bs);
        switch (type) {
            case 91: {
                return new Timestamp(dt.getDate().getTime());
            }
            case 92: {
                return new Timestamp(dt.getTime().getTime());
            }
            case 93: {
                return dt.getTimestamp();
            }
        }
        try {
            return DmdbDateTime.getTimestampByString(this.getString(parameterIndex));
        }
        catch (Exception ex) {
            DBError.throwSQLException(6015);
            return Timestamp.valueOf("1900-01-01 00:00:00");
        }
    }

    public Object getObject(int parameterIndex) throws SQLException {
        this.checkIndex(parameterIndex);
        this.wasNullFlag = this.params[parameterIndex - 1].getInOutType() == 0 ? this.params[parameterIndex - 1].getIsInDataNull() : this.params[parameterIndex - 1].getIsOutDataNull();
        if (this.wasNullFlag) {
            return null;
        }
        if (!this.params[parameterIndex - 1].hasRegisterType()) {
            DBError.throwSQLException(6048);
        }
        int registedJdbcSqlType = this.params[parameterIndex - 1].getRegisterParamType();
        switch (registedJdbcSqlType) {
            case -7: 
            case 16: {
                boolean b = this.getBoolean(parameterIndex);
                return new Boolean(b);
            }
            case -6: 
            case 4: 
            case 5: {
                int i = this.getInt(parameterIndex);
                return new Integer(i);
            }
            case -5: {
                long l = this.getLong(parameterIndex);
                return new Long(l);
            }
            case 2: 
            case 3: {
                return this.getBigDecimal(parameterIndex);
            }
            case 7: {
                float f = this.getFloat(parameterIndex);
                return new Float(f);
            }
            case 6: {
                double d = this.getDouble(parameterIndex);
                return new Float(d);
            }
            case 8: {
                double d = this.getDouble(parameterIndex);
                return new Double(d);
            }
            case -1: 
            case 1: 
            case 12: {
                return this.getString(parameterIndex);
            }
            case 91: {
                return this.getDate(parameterIndex);
            }
            case 92: {
                return this.getTime(parameterIndex);
            }
            case 93: {
                return this.getTimestamp(parameterIndex);
            }
            case -4: 
            case -3: 
            case -2: {
                return this.getBytes(parameterIndex);
            }
            case 2004: {
                return this.getBlob(parameterIndex);
            }
            case 2005: {
                return this.getClob(parameterIndex);
            }
            case 2000: {
                int dataType = this.params[parameterIndex - 1].getCType();
                if (dataType == 21) {
                    return this.getINTERVALDT(parameterIndex);
                }
                if (dataType != 20) break;
                return this.getINTERVALYM(parameterIndex);
            }
        }
        return this.getBytes(parameterIndex);
    }

    public BigDecimal getBigDecimal(int parameterIndex) throws SQLException {
        this.checkIndex(parameterIndex);
        BigDecimal bd = this._$10135(parameterIndex);
        if (this.wasNullFlag) {
            return null;
        }
        if (this.params[parameterIndex - 1].hasRegisterType() && this.params[parameterIndex - 1].hasRegisterScale()) {
            int scale = this.params[parameterIndex - 1].getRegisterParamScale();
            return bd.setScale(scale, 4);
        }
        return bd;
    }

    private BigDecimal _$10135(int parameterIndex) throws SQLException {
        byte[] bs = null;
        if (this.params[parameterIndex - 1].getInOutType() == 0) {
            this.wasNullFlag = this.params[parameterIndex - 1].getIsInDataNull();
            bs = this.params[parameterIndex - 1].getInValue();
        } else {
            this.wasNullFlag = this.params[parameterIndex - 1].getIsOutDataNull();
            bs = this.params[parameterIndex - 1].getOutValue();
        }
        if (this.wasNullFlag) {
            return null;
        }
        int type = this.params[parameterIndex - 1].getJdbcSqlType();
        BigDecimal ret = null;
        switch (type) {
            case -7: 
            case -6: 
            case 16: {
                ret = new BigDecimal(this.getByte(parameterIndex));
                break;
            }
            case 5: {
                ret = new BigDecimal(this.getShort(parameterIndex));
                break;
            }
            case 4: {
                ret = new BigDecimal(this.getInt(parameterIndex));
                break;
            }
            case -5: {
                ret = new BigDecimal(this.getLong(parameterIndex));
                break;
            }
            case 7: {
                ret = new BigDecimal(this.getFloat(parameterIndex));
                break;
            }
            case 6: 
            case 8: {
                ret = new BigDecimal(this.getDouble(parameterIndex));
                break;
            }
            case 2: 
            case 3: {
                int CType = this.params[parameterIndex - 1].getCType();
                int prec = this.params[parameterIndex - 1].getPrecision();
                int scale = this.params[parameterIndex - 1].hasRegisterScale() ? this.params[parameterIndex - 1].getRegisterParamScale() : this.params[parameterIndex - 1].getScale();
                if (CType == 9) {
                    String s = null;
                    try {
                        int ind;
                        int dotIndex;
                        StringBuffer sb = new StringBuffer(10);
                        block23: for (int j = 0; j < bs.length; ++j) {
                            int tmp = 0xF & bs[j];
                            switch (tmp) {
                                case 10: {
                                    sb.append('.');
                                    break;
                                }
                                case 11: {
                                    sb.append('+');
                                    break;
                                }
                                case 12: {
                                    sb.append('-');
                                    break;
                                }
                                default: {
                                    sb.append(tmp);
                                }
                            }
                            tmp = bs[j] >>> 4 & 0xF;
                            switch (tmp) {
                                case 10: {
                                    sb.append('.');
                                    continue block23;
                                }
                                case 11: {
                                    sb.append('+');
                                    continue block23;
                                }
                                case 12: {
                                    sb.append('-');
                                    continue block23;
                                }
                                default: {
                                    sb.append(tmp);
                                }
                            }
                        }
                        s = sb.toString();
                        if (s.charAt(0) == '0') {
                            s = s.substring(1);
                        }
                        if (s.indexOf("-", 1) != -1) {
                            s = s.substring(0, s.indexOf("-", 1));
                        }
                        if (s.indexOf("+", 1) != -1) {
                            s = s.substring(0, s.indexOf("+", 1));
                        }
                        if (s.indexOf(".", (dotIndex = s.indexOf(".")) + 1) != -1) {
                            s = s.substring(0, s.indexOf(".", dotIndex + 1));
                        }
                        if (prec % 2 != 0 && (ind = s.indexOf(46)) > -1 && s.length() - ind - 1 > scale) {
                            s = s.substring(0, ind) + s.substring(ind, ind + scale);
                        }
                        ret = new BigDecimal(s);
                        ret = ret.setScale(scale, 4);
                    }
                    catch (NumberFormatException e) {
                        DBError.throwSQLException(6018);
                    }
                    break;
                }
                long tmp = Convertion.eightByteToLong(bs);
                String s = "" + tmp;
                int len = s.length();
                if (len > scale) {
                    String subStr1 = s.substring(0, len - scale);
                    String subStr2 = s.substring(len - scale);
                    s = subStr1 + "." + subStr2;
                } else {
                    for (int k = 0; k < scale - len; ++k) {
                        s = "0" + s;
                    }
                    s = "0." + s;
                }
                ret = new BigDecimal(s);
                ret = ret.setScale(scale, 4);
                break;
            }
            default: {
                String str = this.getString(parameterIndex);
                try {
                    ret = new BigDecimal(str);
                    break;
                }
                catch (NumberFormatException e) {
                    DBError.throwSQLException(6018);
                }
            }
        }
        return ret;
    }

    public Object getObject(int i, Map map) throws SQLException {
        DBError.throwUnsupportedSQLException();
        return null;
    }

    public Ref getRef(int i) throws SQLException {
        DBError.throwUnsupportedSQLException();
        return null;
    }

    public Blob getBlob(int i) throws SQLException {
        this.checkIndex(i);
        byte[] bs = null;
        if (this.params[i - 1].getInOutType() == 0) {
            this.wasNullFlag = this.params[i - 1].getIsInDataNull();
            bs = this.params[i - 1].getInValue();
        } else {
            this.wasNullFlag = this.params[i - 1].getIsOutDataNull();
            bs = this.params[i - 1].getOutValue();
        }
        if (this.wasNullFlag) {
            return null;
        }
        return new DmdbBlob(this, i, bs);
    }

    public Clob getClob(int i) throws SQLException {
        this.checkIndex(i);
        byte[] bs = null;
        if (this.params[i - 1].getInOutType() == 0) {
            this.wasNullFlag = this.params[i - 1].getIsInDataNull();
            bs = this.params[i - 1].getInValue();
        } else {
            this.wasNullFlag = this.params[i - 1].getIsOutDataNull();
            bs = this.params[i - 1].getOutValue();
        }
        if (this.wasNullFlag) {
            return null;
        }
        return new DmdbClob(this, i, bs);
    }

    public Array getArray(int i) throws SQLException {
        DBError.throwUnsupportedSQLException();
        return null;
    }

    public Date getDate(int parameterIndex, Calendar cal) throws SQLException {
        this.checkIndex(parameterIndex);
        Date d = this.getDate(parameterIndex);
        if (this.wasNullFlag) {
            return null;
        }
        cal.clear();
        cal.setTimeInMillis(d.getTime());
        return new Date(cal.getTime().getTime());
    }

    public Time getTime(int parameterIndex, Calendar cal) throws SQLException {
        this.checkIndex(parameterIndex);
        Time time = this.getTime(parameterIndex);
        if (this.wasNullFlag) {
            return null;
        }
        cal.clear();
        cal.setTimeInMillis(time.getTime());
        return new Time(cal.getTime().getTime());
    }

    public Timestamp getTimestamp(int parameterIndex, Calendar cal) throws SQLException {
        this.checkIndex(parameterIndex);
        Timestamp timestamp = this.getTimestamp(parameterIndex);
        if (this.wasNullFlag) {
            return null;
        }
        cal.clear();
        cal.setTimeInMillis(timestamp.getTime());
        timestamp = new Timestamp(cal.getTime().getTime());
        return timestamp;
    }

    public synchronized void registerOutParameter(int paramIndex, int sqlType, String typeName) throws SQLException {
        DBError.throwUnsupportedSQLException();
    }

    public synchronized void registerOutParameter(String parameterName, int sqlType) throws SQLException {
        int parameterIndex = this._$10146(parameterName);
        this.registerOutParameter(parameterIndex, sqlType);
    }

    public synchronized void registerOutParameter(String parameterName, int sqlType, int scale) throws SQLException {
        int parameterIndex = this._$10146(parameterName);
        this.registerOutParameter(parameterIndex, sqlType, scale);
    }

    public synchronized void registerOutParameter(String parameterName, int sqlType, String typeName) throws SQLException {
        int parameterIndex = this._$10146(parameterName);
        this.registerOutParameter(parameterIndex, sqlType, typeName);
    }

    public URL getURL(int parameterIndex) throws SQLException {
        DBError.throwUnsupportedSQLException();
        return null;
    }

    public void setURL(String parameterName, URL val) throws SQLException {
        DBError.throwUnsupportedSQLException();
    }

    public void setNull(String parameterName, int sqlType) throws SQLException {
        int parameterIndex = this._$10146(parameterName);
        this.setNull(parameterIndex, sqlType);
    }

    public void setBoolean(String parameterName, boolean x) throws SQLException {
        int parameterIndex = this._$10146(parameterName);
        this.setBoolean(parameterIndex, x);
    }

    public void setByte(String parameterName, byte x) throws SQLException {
        int parameterIndex = this._$10146(parameterName);
        this.setByte(parameterIndex, x);
    }

    public void setShort(String parameterName, short x) throws SQLException {
        int parameterIndex = this._$10146(parameterName);
        this.setShort(parameterIndex, x);
    }

    public void setInt(String parameterName, int x) throws SQLException {
        int parameterIndex = this._$10146(parameterName);
        this.setInt(parameterIndex, x);
    }

    public void setLong(String parameterName, long x) throws SQLException {
        int parameterIndex = this._$10146(parameterName);
        this.setLong(parameterIndex, x);
    }

    public void setFloat(String parameterName, float x) throws SQLException {
        int parameterIndex = this._$10146(parameterName);
        this.setFloat(parameterIndex, x);
    }

    public void setDouble(String parameterName, double x) throws SQLException {
        int parameterIndex = this._$10146(parameterName);
        this.setDouble(parameterIndex, x);
    }

    public void setBigDecimal(String parameterName, BigDecimal x) throws SQLException {
        int parameterIndex = this._$10146(parameterName);
        this.setBigDecimal(parameterIndex, x);
    }

    public void setString(String parameterName, String x) throws SQLException {
        int parameterIndex = this._$10146(parameterName);
        this.setString(parameterIndex, x);
    }

    public void setBytes(String parameterName, byte[] x) throws SQLException {
        int parameterIndex = this._$10146(parameterName);
        this.setBytes(parameterIndex, x);
    }

    public void setDate(String parameterName, Date x) throws SQLException {
        int parameterIndex = this._$10146(parameterName);
        this.setDate(parameterIndex, x);
    }

    public void setTime(String parameterName, Time x) throws SQLException {
        int parameterIndex = this._$10146(parameterName);
        this.setTime(parameterIndex, x);
    }

    public void setTimestamp(String parameterName, Timestamp x) throws SQLException {
        int parameterIndex = this._$10146(parameterName);
        this.setTimestamp(parameterIndex, x);
    }

    public void setAsciiStream(String parameterName, InputStream x, int length) throws SQLException {
        int parameterIndex = this._$10146(parameterName);
        this.setAsciiStream(parameterIndex, x, length);
    }

    public void setBinaryStream(String parameterName, InputStream x, int length) throws SQLException {
        int parameterIndex = this._$10146(parameterName);
        this.setBinaryStream(parameterIndex, x, length);
    }

    public void setObject(String parameterName, Object x, int targetSqlType, int scale) throws SQLException {
        int parameterIndex = this._$10146(parameterName);
        this.setObject(parameterIndex, x, targetSqlType, scale);
    }

    public void setObject(String parameterName, Object x, int targetSqlType) throws SQLException {
        int parameterIndex = this._$10146(parameterName);
        this.setObject(parameterIndex, x, targetSqlType);
    }

    public void setObject(String parameterName, Object x) throws SQLException {
        int parameterIndex = this._$10146(parameterName);
        this.setObject(parameterIndex, x);
    }

    public void setCharacterStream(String parameterName, Reader reader, int length) throws SQLException {
        int parameterIndex = this._$10146(parameterName);
        this.setCharacterStream(parameterIndex, reader, length);
    }

    public void setDate(String parameterName, Date x, Calendar cal) throws SQLException {
        int parameterIndex = this._$10146(parameterName);
        this.setDate(parameterIndex, x, cal);
    }

    public void setTime(String parameterName, Time x, Calendar cal) throws SQLException {
        int parameterIndex = this._$10146(parameterName);
        this.setTime(parameterIndex, x, cal);
    }

    public void setTimestamp(String parameterName, Timestamp x, Calendar cal) throws SQLException {
        int parameterIndex = this._$10146(parameterName);
        this.setTimestamp(parameterIndex, x, cal);
    }

    public void setNull(String parameterName, int sqlType, String typeName) throws SQLException {
        int parameterIndex = this._$10146(parameterName);
        this.setNull(parameterIndex, sqlType, typeName);
    }

    public String getString(String parameterName) throws SQLException {
        int parameterIndex = this._$10146(parameterName);
        return this.getString(parameterIndex);
    }

    public boolean getBoolean(String parameterName) throws SQLException {
        int parameterIndex = this._$10146(parameterName);
        return this.getBoolean(parameterIndex);
    }

    public byte getByte(String parameterName) throws SQLException {
        int parameterIndex = this._$10146(parameterName);
        return this.getByte(parameterIndex);
    }

    public short getShort(String parameterName) throws SQLException {
        int parameterIndex = this._$10146(parameterName);
        return this.getShort(parameterIndex);
    }

    public int getInt(String parameterName) throws SQLException {
        int parameterIndex = this._$10146(parameterName);
        return this.getInt(parameterIndex);
    }

    public long getLong(String parameterName) throws SQLException {
        int parameterIndex = this._$10146(parameterName);
        return this.getLong(parameterIndex);
    }

    public float getFloat(String parameterName) throws SQLException {
        int parameterIndex = this._$10146(parameterName);
        return this.getFloat(parameterIndex);
    }

    public double getDouble(String parameterName) throws SQLException {
        int parameterIndex = this._$10146(parameterName);
        return this.getDouble(parameterIndex);
    }

    public byte[] getBytes(String parameterName) throws SQLException {
        int parameterIndex = this._$10146(parameterName);
        return this.getBytes(parameterIndex);
    }

    public Date getDate(String parameterName) throws SQLException {
        int parameterIndex = this._$10146(parameterName);
        return this.getDate(parameterIndex);
    }

    public Time getTime(String parameterName) throws SQLException {
        int parameterIndex = this._$10146(parameterName);
        return this.getTime(parameterIndex);
    }

    public Timestamp getTimestamp(String parameterName) throws SQLException {
        int parameterIndex = this._$10146(parameterName);
        return this.getTimestamp(parameterIndex);
    }

    public Object getObject(String parameterName) throws SQLException {
        int parameterIndex = this._$10146(parameterName);
        return this.getObject(parameterIndex);
    }

    public BigDecimal getBigDecimal(String parameterName) throws SQLException {
        int parameterIndex = this._$10146(parameterName);
        return this.getBigDecimal(parameterIndex);
    }

    public Object getObject(String parameterName, Map map) throws SQLException {
        int parameterIndex = this._$10146(parameterName);
        return this.getObject(parameterIndex, map);
    }

    public Ref getRef(String parameterName) throws SQLException {
        DBError.throwUnsupportedSQLException();
        return null;
    }

    public Blob getBlob(String parameterName) throws SQLException {
        int parameterIndex = this._$10146(parameterName);
        return this.getBlob(parameterIndex);
    }

    public Clob getClob(String parameterName) throws SQLException {
        int parameterIndex = this._$10146(parameterName);
        return this.getClob(parameterIndex);
    }

    public Array getArray(String parameterName) throws SQLException {
        DBError.throwUnsupportedSQLException();
        return null;
    }

    public Date getDate(String parameterName, Calendar cal) throws SQLException {
        int parameterIndex = this._$10146(parameterName);
        return this.getDate(parameterIndex, cal);
    }

    public Time getTime(String parameterName, Calendar cal) throws SQLException {
        int parameterIndex = this._$10146(parameterName);
        return this.getTime(parameterIndex, cal);
    }

    public Timestamp getTimestamp(String parameterName, Calendar cal) throws SQLException {
        int parameterIndex = this._$10146(parameterName);
        return this.getTimestamp(parameterIndex, cal);
    }

    public URL getURL(String parameterName) throws SQLException {
        int parameterIndex = this._$10146(parameterName);
        return this.getURL(parameterIndex);
    }

    public DmdbIntervalYM getINTERVALYM(int i) throws SQLException {
        this.checkIndex(i);
        byte[] bs = null;
        if (this.params[i - 1].getInOutType() == 0) {
            this.wasNullFlag = this.params[i - 1].getIsInDataNull();
            bs = this.params[i - 1].getInValue();
        } else {
            this.wasNullFlag = this.params[i - 1].getIsOutDataNull();
            bs = this.params[i - 1].getOutValue();
        }
        if (this.wasNullFlag) {
            return null;
        }
        int type = this.params[i - 1].getCType();
        switch (type) {
            case 20: {
                DmdbIntervalYM ym = new DmdbIntervalYM(bs, this.params[i - 1].getPrecision());
                return ym;
            }
        }
        String str = this.getString(i);
        return new DmdbIntervalYM(str, this.params[i - 1].getPrecision());
    }

    public DmdbIntervalYM getINTERVALYM(String s) throws SQLException {
        return this.getINTERVALYM(this._$10146(s));
    }

    public DmdbIntervalDT getINTERVALDT(int i) throws SQLException {
        this.checkIndex(i);
        byte[] bs = null;
        if (this.params[i - 1].getInOutType() == 0) {
            this.wasNullFlag = this.params[i - 1].getIsInDataNull();
            bs = this.params[i - 1].getInValue();
        } else {
            this.wasNullFlag = this.params[i - 1].getIsOutDataNull();
            bs = this.params[i - 1].getOutValue();
        }
        if (this.wasNullFlag) {
            return null;
        }
        int type = this.params[i - 1].getCType();
        switch (type) {
            case 21: {
                return new DmdbIntervalDT(bs, this.params[i - 1].getPrecision(), this.params[i - 1].getScale());
            }
        }
        String str = this.getString(i);
        return new DmdbIntervalDT(str, this.params[i - 1].getPrecision(), this.params[i - 1].getScale());
    }

    public DmdbIntervalDT getINTERVALDT(String s) throws SQLException {
        return this.getINTERVALDT(this._$10146(s));
    }

    public DmdbTime getTIME(int i) throws SQLException {
        this.checkIndex(i);
        byte[] bs = null;
        if (this.params[i - 1].getInOutType() == 0) {
            this.wasNullFlag = this.params[i - 1].getIsInDataNull();
            bs = this.params[i - 1].getInValue();
        } else {
            this.wasNullFlag = this.params[i - 1].getIsOutDataNull();
            bs = this.params[i - 1].getOutValue();
        }
        if (this.wasNullFlag) {
            return null;
        }
        int type = this.params[i - 1].getCType();
        switch (type) {
            case 15: {
                return new DmdbTime(bs);
            }
            case 16: {
                Timestamp ts = this.getTimestamp(i);
                String str = String.valueOf(new Time(ts.getTime())) + "." + ts.getNanos();
                return new DmdbTime(str);
            }
        }
        String str1 = this.getString(i);
        return new DmdbTime(str1);
    }

    public DmdbTime getTIME(String s) throws SQLException {
        int index = this._$10146(s);
        return this.getTIME(index);
    }

    public void setTIME(String parameterName, DmdbTime t2) throws SQLException {
        int parameterIndex = this._$10146(parameterName);
        this.setTIME(parameterIndex, t2);
    }

    public void setINTERVALDT(String parameterName, DmdbIntervalDT dt) throws SQLException {
        int parameterIndex = this._$10146(parameterName);
        this.setINTERVALDT(parameterIndex, dt);
    }

    public void setINTERVALYM(String parameterName, DmdbIntervalYM ym) throws SQLException {
        int parameterIndex = this._$10146(parameterName);
        this.setINTERVALYM(parameterIndex, ym);
    }

    private int _$10146(String ParamName) throws SQLException {
        int pCount = -1;
        int CountNum = 0;
        CountNum = this.dbInfo.getParameterCount();
        for (int i = 0; i < CountNum; ++i) {
            if (!this.params[i].getName().equalsIgnoreCase(ParamName)) continue;
            pCount = i;
            break;
        }
        if (pCount == -1) {
            DBError.throwSQLException(6050);
        }
        return pCount + 1;
    }

    public String getPrintMsg() {
        return this.printMsg;
    }

    void resetState() throws SQLException {
        super.resetState();
        this.wasNullFlag = false;
    }

    public synchronized void close() throws SQLException {
        super.close();
        this.wasNullFlag = false;
    }
}

