/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.driver.DmdbParameter;
import dm.jdbc.driver.DmdbResultSet;
import java.util.Calendar;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;

public class DmdbCachedResultSet {
    private static int _$11294 = 60;
    private static int _$11295 = 30000;
    private static int _$11296 = 300000;
    private static ConcurrentHashMap _$11297 = null;
    private static ScanThread _$11299;

    public static void setCachedTime(int i) {
        _$11294 = i;
    }

    private static int _$11301() {
        return _$11294;
    }

    private static boolean _$11310() {
        return _$11297.size() > _$11295;
    }

    public static void putResultSet(String sql, DmdbParameter[] params, DmdbResultSet rs) {
        CachedResultSet crs = null;
        if (sql == null || params != null && params.length > 16) {
            return;
        }
        if (DmdbCachedResultSet._$11310()) {
            DmdbCachedResultSet._$11303();
        }
        if (DmdbCachedResultSet._$11310()) {
            return;
        }
        try {
            String innerSql = sql;
            if (params != null) {
                for (int i = 0; i < params.length; ++i) {
                    byte[] inVal = params[i].getInValue();
                    innerSql = inVal == null ? innerSql + " NULL " : innerSql + new String(inVal);
                }
            }
            if ((crs = (CachedResultSet)_$11297.get(innerSql)) == null) {
                crs = new CachedResultSet(rs, innerSql);
                _$11297.put(innerSql, crs);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public static DmdbResultSet getResutlSet(String sql, DmdbParameter[] params) {
        DmdbResultSet rs = null;
        CachedResultSet crs = null;
        if (DmdbConnection.maxCachedResultSet == 0 || sql == null) {
            return null;
        }
        try {
            String innerSql = sql;
            if (params != null) {
                for (int i = 0; i < params.length; ++i) {
                    byte[] inVal = params[i].getInValue();
                    innerSql = inVal == null ? innerSql + " NULL " : innerSql + new String(inVal);
                }
            }
            if ((crs = (CachedResultSet)_$11297.get(innerSql)) != null) {
                crs.beginTime = Calendar.getInstance().getTimeInMillis();
                rs = crs.getResultSet();
                return (DmdbResultSet)rs.clone();
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static void _$11303() {
        Iterator iterator = _$11297.values().iterator();
        while (iterator.hasNext()) {
            CachedResultSet crs = (CachedResultSet)iterator.next();
            if (!crs.isExpired()) continue;
            _$11297.remove(crs.sql);
        }
    }

    static {
        if (DmdbConnection.maxCachedResultSet > 0) {
            DmdbCachedResultSet.setCachedTime(DmdbConnection.maxCachedResultSet);
            _$11295 = DmdbConnection.maxCachedResultSet * 500;
            if (_$11295 > _$11296) {
                _$11295 = _$11296;
            }
        }
        _$11297 = new ConcurrentHashMap(_$11295, _$11295, 100);
        _$11299 = new ScanThread();
        _$11299.start();
    }

    private static class CachedResultSet {
        String sql;
        long beginTime;
        DmdbResultSet rs;

        public CachedResultSet(DmdbResultSet rs, String sql) {
            this.rs = rs;
            this.sql = new String(sql);
            this.beginTime = Calendar.getInstance().getTimeInMillis();
        }

        public boolean isExpired() {
            long interval = Calendar.getInstance().getTimeInMillis() - this.beginTime;
            return interval > (long)(DmdbCachedResultSet._$11301() * 1000);
        }

        public DmdbResultSet getResultSet() {
            return this.rs;
        }
    }

    private static class ScanThread
    extends Thread {
        public void run() {
            while (true) {
                try {
                    Thread.sleep(DmdbCachedResultSet._$11301() * 1000);
                }
                catch (InterruptedException interruptedexception) {
                    interruptedexception.printStackTrace();
                }
                DmdbCachedResultSet._$11303();
            }
        }

        public ScanThread() {
            super("Spool Thread");
            this.setDaemon(true);
            this.setPriority(5);
        }
    }
}

