/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.dbaccess.AuthInfo;
import dm.jdbc.dbaccess.Const;
import dm.jdbc.dbaccess.DBError;
import dm.jdbc.dbaccess.DbAccess;
import dm.jdbc.dbaccess.DmMsg;
import dm.jdbc.dbaccess.ssl.MakeSSLSocket;
import dm.jdbc.driver.DmdbColumn;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.driver.DmdbInfo;
import dm.jdbc.driver.DmdbParameter;
import dm.jdbc.driver.DmdbResultSet;
import dm.jdbc.driver.DmdbResultSetCache;
import dm.jdbc.driver.DmdbStatement;
import dm.jdbc.driver.DmdbSynchronizeTrx;
import dm.jdbc.driver.DmdbType;
import dm.jdbc.util.Convertion;
import dm.jdbc.util.StringUtil;
import dm.jdbc.xa.DmdbXAResource;
import dm.jdbc.xa.DmdbXid;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.Vector;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;

public class DmdbCSI {
    private DmdbConnection _$712 = null;
    private DbAccess _$272 = null;
    private boolean _$1050 = false;
    private String _$1051;
    private DmMsg _$1052 = null;
    private int _$1053 = 0;

    DmdbCSI(DmdbConnection conn, String user, String passwd, String catalog) throws IOException, SQLException {
        String connectedUser = user;
        AuthInfo clientAuthInfo = null;
        this._$1050 = true;
        this._$712 = conn;
        this._$1052 = new DmMsg();
        int i = 0;
        int num = this._$712.getHosts().size();
        while (i < num) {
            try {
                String server = (String)this._$712.getHosts().get(i);
                this._$272 = new DbAccess(server, this._$712.getPortNumber(), this._$712.getVarLenFlag());
                this._$272.getSocket().setSoTimeout(this._$712.getSocketTimeout());
                this._$1065();
                if (user.length() > 2 && user.startsWith("///")) {
                    clientAuthInfo = this._$272.getAuthInfo(2);
                    if (null == clientAuthInfo) {
                        DBError.throwSQLException(6001);
                    }
                    connectedUser = "///" + clientAuthInfo.getUserName();
                }
                this._$1051 = this.login(connectedUser, passwd, catalog, clientAuthInfo);
                break;
            }
            catch (SQLException sqlEx) {
                if (this._$272 != null) {
                    this._$272.close();
                }
                this._$272 = null;
                this._$1050 = true;
                if (i < num - 1) {
                    ++i;
                    continue;
                }
                throw sqlEx;
            }
            catch (IOException e) {
                if (i < num - 1) {
                    ++i;
                    continue;
                }
                throw e;
            }
        }
        this._$712.setNetworkPacketSize(this._$272.getNetPacketSize());
        this._$1050 = false;
    }

    private void _$1065() throws IOException, SQLException {
        int i;
        int sqlcode;
        DmMsg recvMsg = null;
        int cipherType = -1;
        byte[] serverPubKey = null;
        String cryptoName = null;
        if (this._$712.getAutoCommit() && this._$712.getCmdAutoCommitFlag() == 120) {
            this._$1052.setCmd(2248);
        } else {
            this._$1052.setCmd(200);
        }
        int offset = 64;
        this._$1052.setInt(0, offset);
        int tmpLen = "6.0.2.62".getBytes().length;
        this._$1052.setInt(tmpLen, offset += 4);
        this._$1052.setString("6.0.2.62", offset += 4);
        byte[] clientPubKey = this._$272.getClientPubKey();
        this._$1052.setBytes(clientPubKey, 0, offset += tmpLen, 64);
        this._$1052.setLength(offset += 64);
        try {
            this._$272.send(this._$1052);
            recvMsg = this._$272.readPacket();
        }
        catch (IOException ioex) {
            DBError.throwSQLException(6001);
        }
        if (!recvMsg.checkCRC()) {
            DBError.throwSQLException(6002);
        }
        if ((sqlcode = recvMsg.getSQLCODE()) < 0) {
            String errInfo = recvMsg.getErrorInfo(this._$712.getServerEncoding());
            DBError.throwSQLException(errInfo, sqlcode);
        }
        int msgLen = this._$1052.getLength() + 64;
        offset = 64;
        offset += recvMsg.getInt(offset);
        offset += 4;
        offset += recvMsg.getInt(offset);
        offset += 4;
        offset += recvMsg.getInt(offset);
        offset += 4;
        offset += recvMsg.getInt(offset);
        tmpLen = recvMsg.getInt(offset += 4);
        if (tmpLen >= 256) {
            tmpLen = 255;
        }
        offset += 4;
        int neg_ret = recvMsg.getInt(offset += tmpLen);
        this._$1053 = recvMsg.getInt(offset += 4);
        tmpLen = recvMsg.getInt(offset += 4);
        this._$1051 = recvMsg.getString(offset += 4, tmpLen);
        offset += tmpLen;
        long valFromSvr = 0L;
        long valLocal = 0L;
        String str = "";
        String tmpStr = "";
        for (i = 0; i < tmpLen; ++i) {
            if (this._$1051.charAt(i) == '.') {
                if (tmpStr.length() == 1) {
                    tmpStr = "0" + tmpStr;
                }
                str = str + tmpStr;
                tmpStr = "";
                continue;
            }
            tmpStr = tmpStr + this._$1051.charAt(i);
        }
        if (tmpStr.length() == 1) {
            tmpStr = "0" + tmpStr;
        }
        str = str + tmpStr;
        valFromSvr = new Long(str);
        str = "";
        tmpStr = "";
        tmpLen = "6.0.2.30".length();
        for (i = 0; i < tmpLen; ++i) {
            if ("6.0.2.30".charAt(i) == '.') {
                if (tmpStr.length() == 1) {
                    tmpStr = "0" + tmpStr;
                }
                str = str + tmpStr;
                tmpStr = "";
                continue;
            }
            tmpStr = tmpStr + "6.0.2.30".charAt(i);
        }
        if (tmpStr.length() == 1) {
            tmpStr = "0" + tmpStr;
        }
        if (valFromSvr < (valLocal = new Long(str = str + tmpStr).longValue())) {
            DBError.throwSQLException(Const.res.getString("error.version.server"));
        }
        if (1 == neg_ret) {
            cipherType = recvMsg.getInt(offset);
            serverPubKey = recvMsg.getBytes(offset += 4, 64);
            tmpLen = recvMsg.getInt(offset += 64);
            offset += 4;
            if (tmpLen > 0) {
                cryptoName = recvMsg.getString(offset, tmpLen);
            }
            offset += tmpLen;
            tmpLen = recvMsg.getInt(offset);
            offset += 4;
            offset += tmpLen;
        }
        if (offset < msgLen) {
            if (recvMsg.getInt(offset) == 1) {
                this._$712.setServerEncoding("UTF-8");
            } else {
                String encoding = System.getProperty("file.encoding");
                if (encoding.toUpperCase().startsWith("UTF")) {
                    this._$712.setServerEncoding("GB2312");
                }
            }
        }
        if (2 == neg_ret) {
            this._$1111();
            this._$712.setNetworkEncypted(true);
        } else if (1 == neg_ret) {
            this._$272.set_msg_encrypt_type((short)4096);
            this._$272.setMsgCipherType(cipherType);
            this._$272.genMsgCiphers(serverPubKey);
            this._$712.setNetworkEncypted(true);
        } else {
            this._$712.setNetworkEncypted(false);
        }
    }

    private void _$1111() throws IOException, SQLException {
        MakeSSLSocket ssl = new MakeSSLSocket();
        ssl.convert(this._$272, this._$712.getProperties());
    }

    public final synchronized String login(String user, String password, String catalog, AuthInfo clientAuthInfo) throws SQLException {
        byte flag;
        int sqlcode;
        DmMsg recvMsg = null;
        this._$1052.setCmd(1);
        this._$1052.setExecDirect(false);
        int offset = 64;
        this._$1052.setInt(0, offset);
        int iso_level = this._$712.trans_level == 2 ? 1 : (this._$712.trans_level == 1 ? 0 : (this._$712.trans_level == 4 ? 2 : (this._$712.trans_level == 8 ? 3 : -1)));
        this._$1052.setInt(iso_level, offset += 4);
        byte[] buf = Convertion.getBytes(user, this._$712.getServerEncoding());
        this._$1052.setInt(buf.length, offset += 4);
        this._$1052.setBytes(buf, 0, offset += 4, buf.length);
        int tmpLen = password.getBytes().length;
        this._$1052.setInt(tmpLen, offset += buf.length);
        this._$1052.setString(password, offset += 4);
        buf = Convertion.getBytes(catalog, this._$712.getServerEncoding());
        this._$1052.setInt(buf.length, offset += tmpLen);
        this._$1052.setBytes(buf, 0, offset += 4, buf.length);
        this._$1052.setInt(0, offset += buf.length);
        this._$1052.setInt(0, offset += 4);
        int language = this._$712.getLanguage();
        this._$1052.setInt(language, offset += 4);
        offset += 4;
        if (null != clientAuthInfo) {
            this._$1052.setInt(clientAuthInfo.getOut_buf_size(), offset);
            this._$1052.setBytes(clientAuthInfo.getOut_buf(), 0, offset += 4, clientAuthInfo.getOut_buf_size());
            offset += clientAuthInfo.getOut_buf_size();
        }
        this._$1052.setByte(120, offset);
        this._$1052.setByte(105, ++offset);
        this._$1052.setByte(83, ++offset);
        this._$1052.setByte(1, ++offset);
        this._$1052.setByte(49, ++offset);
        this._$1052.setLength(++offset);
        try {
            this._$272.send(this._$1052);
            recvMsg = this._$272.readPacket();
        }
        catch (IOException ioex) {
            DBError.throwSQLException(6001);
        }
        if (!recvMsg.checkCRC()) {
            DBError.throwSQLException(6002);
        }
        if ((sqlcode = recvMsg.getSQLCODE()) < 0) {
            String errInfo = recvMsg.getErrorInfo(this._$712.getServerEncoding());
            DBError.throwSQLException(errInfo, sqlcode);
        } else if (sqlcode == 505 || sqlcode == 506) {
            if (!this._$712.getCanConnStandby()) {
                DBError.throwSQLException(Const.res.getString("error.connectStandBy"));
            } else {
                SQLWarning warning = new SQLWarning(Const.res.getString("warn.connectStandby"));
                this._$712.addWarnings(warning);
            }
        }
        int msgLen = this._$1052.getLength() + 64;
        offset = 64;
        offset += recvMsg.getInt(offset);
        offset += 4;
        offset += recvMsg.getInt(offset);
        offset += 4;
        offset += recvMsg.getInt(offset);
        offset += 4;
        offset += recvMsg.getInt(offset);
        tmpLen = recvMsg.getInt(offset += 4);
        offset += 4;
        if (tmpLen >= 256) {
            tmpLen = 255;
        }
        this._$712.maxRowSize = (short)recvMsg.getInt(offset += tmpLen);
        offset += 4;
        this._$712.ddl_auto_commit = recvMsg.getInt(offset += 4);
        this._$712.identifier_case = recvMsg.getInt(offset += 4);
        this._$712.trans_level = recvMsg.getInt(offset += 4);
        switch (this._$712.trans_level) {
            case 0: {
                this._$712.trans_level = 2;
                break;
            }
            case 1: {
                this._$712.trans_level = 2;
                break;
            }
            case 2: {
                this._$712.trans_level = 4;
                break;
            }
            case 3: {
                this._$712.trans_level = 8;
                break;
            }
            default: {
                this._$712.trans_level = 0;
            }
        }
        tmpLen = recvMsg.getInt(offset += 4);
        String currentDB = recvMsg.getString(offset += 4, tmpLen, this._$712.getServerEncoding());
        if (catalog != null && !catalog.trim().equals("") && !catalog.equalsIgnoreCase(currentDB)) {
            DBError.throwSQLException(6025);
        }
        this._$712.setDBName(recvMsg.getString(offset, tmpLen));
        this._$712.setCaseSensitive(recvMsg.getInt(offset += tmpLen) == 1);
        if (recvMsg.getInt(offset += 4) == 1) {
            this._$712.setServerEncoding("UTF-8");
        } else {
            String encoding = System.getProperty("file.encoding");
            if (encoding.toUpperCase().startsWith("UTF")) {
                this._$712.setServerEncoding("GB2312");
            }
        }
        this._$712.setFailedAttempt(recvMsg.getInt(offset += 4));
        tmpLen = recvMsg.getInt(offset += 4);
        String lastLoginIP = recvMsg.getString(offset += 4, tmpLen);
        offset += tmpLen;
        this._$712.setLastLoginIP(lastLoginIP);
        tmpLen = recvMsg.getInt(offset);
        String lastLoginTime = recvMsg.getString(offset += 4, tmpLen);
        this._$712.setLastLoginTime(lastLoginTime);
        int warningType = recvMsg.getInt(offset += tmpLen);
        this._$712.setLoginWarningID(warningType);
        int remainder = recvMsg.getInt(offset += 4);
        this._$712.setGraceTimeRemainder(remainder);
        offset += 4;
        offset += 4;
        offset += 4;
        if ((offset += 4) < msgLen) {
            this._$712.setBackslashEsc(recvMsg.getInt(offset));
            offset += 4;
        }
        if (offset < msgLen) {
            flag = this._$1052.getByte(offset);
            ++offset;
            if (flag == 103) {
                this._$712.setCmdAutoCommitFlag((byte)120);
            }
        }
        if (offset < msgLen) {
            flag = this._$1052.getByte(offset);
            ++offset;
            if (flag == 69) {
                this._$712.setVarLenFlag((byte)105);
            }
        }
        if (offset < msgLen) {
            flag = this._$1052.getByte(offset);
            ++offset;
            if (flag == 72) {
                this._$712.setNewStructFlag((byte)72);
            }
        }
        return this._$1051;
    }

    protected final void changeDB(String database) throws SQLException {
        if (database == null || database.trim().length() == 0) {
            DBError.throwSQLException(6011);
        }
        String dbName = StringUtil.getEscObjName(database);
        DmdbStatement stmt = (DmdbStatement)this._$712.createStatement();
        stmt.execute("set current database \"" + dbName + "\"");
        stmt.close();
    }

    public final String getDmServerVersion() {
        return this._$1051;
    }

    public final synchronized int allocStmtHandle() throws SQLException {
        int sqlcode;
        DmMsg recvMsg = null;
        if (this._$712.getAutoCommit() && this._$712.getCmdAutoCommitFlag() == 120) {
            this._$1052.setCmd(2051);
        } else {
            this._$1052.setCmd(3);
        }
        this._$1052.setLength(0);
        try {
            this._$272.send(this._$1052);
            recvMsg = this._$272.readPacket();
        }
        catch (IOException ioex) {
            DBError.throwSQLException(6001);
        }
        if (!recvMsg.checkCRC()) {
            DBError.throwSQLException(6002);
        }
        if ((sqlcode = recvMsg.getSQLCODE()) < 0) {
            String errInfo = recvMsg.getErrorInfo(this._$712.getServerEncoding());
            DBError.throwSQLException(errInfo, sqlcode);
        }
        return recvMsg.getStmtId();
    }

    private final synchronized DmMsg _$1189(DmdbStatement stmt, long curPos) throws SQLException {
        int sqlcode;
        DmMsg recvMsg = null;
        this._$1052.setStmtId(stmt.handle);
        if (this._$712.getAutoCommit() && this._$712.getCmdAutoCommitFlag() == 120) {
            this._$1052.setCmd(2054);
        } else {
            this._$1052.setCmd(6);
        }
        this._$1052.setLength(0);
        this._$1052.setRowCount(0L);
        this._$1052.setCurPos(curPos);
        try {
            this._$272.send(this._$1052);
            recvMsg = this._$272.readPacket();
        }
        catch (IOException ioex) {
            DBError.throwSQLException(6001);
        }
        if (!recvMsg.checkCRC()) {
            DBError.throwSQLException(6002);
        }
        if ((sqlcode = recvMsg.getSQLCODE()) < 0) {
            String errInfo = recvMsg.getErrorInfo(this._$712.getServerEncoding());
            DBError.throwSQLException(errInfo, sqlcode);
        }
        return recvMsg;
    }

    public final synchronized void closeHandle(DmdbStatement stmt) throws SQLException {
        int sqlcode;
        DmMsg recvMsg = null;
        if (this._$712 == null || this._$712.closed) {
            return;
        }
        if (this._$712.getAutoCommit() && this._$712.getCmdAutoCommitFlag() == 120) {
            this._$1052.setCmd(2065);
        } else {
            this._$1052.setCmd(17);
        }
        this._$1052.setLength(0);
        this._$1052.setStmtId(stmt.handle);
        try {
            this._$272.send(this._$1052);
            recvMsg = this._$272.readPacket();
        }
        catch (IOException ioex) {
            DBError.throwSQLException(6001);
        }
        if (!recvMsg.checkCRC()) {
            DBError.throwSQLException(6002);
        }
        if ((sqlcode = recvMsg.getSQLCODE()) < 0) {
            String errInfo = recvMsg.getErrorInfo(this._$712.getServerEncoding());
            DBError.throwSQLException(errInfo, sqlcode);
        }
    }

    public final synchronized void freeHandle(DmdbStatement stmt) throws SQLException {
        int sqlcode;
        DmMsg recvMsg = null;
        if (this._$712 == null || this._$712.closed) {
            return;
        }
        if (this._$712.getAutoCommit() && this._$712.getCmdAutoCommitFlag() == 120) {
            this._$1052.setCmd(2052);
        } else {
            this._$1052.setCmd(4);
        }
        this._$1052.setLength(0);
        this._$1052.setStmtId(stmt.handle);
        try {
            this._$272.send(this._$1052);
            recvMsg = this._$272.readPacket();
        }
        catch (IOException ioex) {
            DBError.throwSQLException(6001);
        }
        if (!recvMsg.checkCRC()) {
            DBError.throwSQLException(6002);
        }
        if ((sqlcode = recvMsg.getSQLCODE()) < 0) {
            String errInfo = recvMsg.getErrorInfo(this._$712.getServerEncoding());
            DBError.throwSQLException(errInfo, sqlcode);
        }
    }

    public final synchronized DmdbInfo prepareSQL(DmdbStatement stmt, String sql, boolean direct, int checkFlag) throws SQLException {
        short colNum;
        short paraNum;
        long rowNum;
        int refHandle;
        int sqlcode;
        DmMsg recvMsg = null;
        byte[] buf = Convertion.getBytes(sql, this._$712.getServerEncoding());
        int len = buf.length + 1;
        this._$1052.setStmtId(stmt.handle);
        if (this._$712.getAutoCommit() && this._$712.getCmdAutoCommitFlag() == 120) {
            this._$1052.setCmd(2094);
        } else {
            this._$1052.setCmd(46);
        }
        this._$1052.setLength(len);
        this._$1052.setExecDirect(direct);
        this._$1052.setSQLCODE(checkFlag);
        this._$1052.setStringWithNTS(buf, 64);
        try {
            this._$272.send(this._$1052);
            recvMsg = this._$272.readPacket();
        }
        catch (IOException ioex) {
            DBError.throwSQLException(6001);
        }
        if (!recvMsg.checkCRC()) {
            DBError.throwSQLException(6002);
        }
        if ((sqlcode = recvMsg.getSQLCODE()) < 0) {
            String errInfo = recvMsg.getErrorInfo(this._$712.getServerEncoding());
            DBError.throwSQLException(errInfo, sqlcode);
        }
        DmdbInfo des = new DmdbInfo();
        if (sqlcode > 0) {
            des.setSQLCode(sqlcode);
        }
        if ((refHandle = recvMsg.getStmtId()) != stmt.handle && (long)refHandle > 10000000L) {
            des.setRefHandle(refHandle);
        }
        short retCmd = recvMsg.getCmd();
        des.setRetStmtType(retCmd);
        if (retCmd == 201 || retCmd == 200) {
            stmt.cursorUpdateRow = this._$712.getCurpos(refHandle);
            if (sqlcode == 107) {
                recvMsg = this._$1189(stmt, stmt.cursorUpdateRow);
            }
        } else if (retCmd == 150) {
            short isoLevel = recvMsg.getColumnCount();
            stmt.connection.trans_level = isoLevel == 1 ? 2 : (isoLevel == 0 ? 1 : (isoLevel == 2 ? 4 : (isoLevel == 3 ? 8 : 0)));
            return des;
        }
        if (sqlcode > 0 && (sqlcode == 201 || sqlcode == 200 || sqlcode == -3404)) {
            sqlcode = 0;
            rowNum = 0L;
            paraNum = 0;
            colNum = 0;
        } else {
            rowNum = recvMsg.getRowCount();
            rowNum = rowNum > 0L ? rowNum : 0L;
            paraNum = recvMsg.getParamCount();
            paraNum = paraNum > 0 ? paraNum : (short)0;
            colNum = recvMsg.getColumnCount();
            colNum = colNum > 0 ? colNum : (short)0;
        }
        des.setRowCount(rowNum);
        byte[] rowid = recvMsg.getCurPos();
        des.setRowId(rowid);
        int offset = 64;
        offset = this._$1234(recvMsg, offset, paraNum, des);
        offset = this._$1235(recvMsg, offset, colNum, des);
        if (direct && (retCmd == 160 || retCmd == 162)) {
            this._$1238(stmt, recvMsg, rowNum, des.getColumnsInfo());
        }
        return des;
    }

    private final void _$1238(DmdbStatement stmt, DmMsg msg, long rowNum, DmdbColumn[] colsInfo) throws SQLException {
        int fetched_rows = msg.getFetchedRow();
        if (fetched_rows > 0) {
            int msgLen = msg.getLength();
            int off = msg.getResultSetOffSet();
            int len = msgLen + 64 - off;
            if (stmt.rsCache == null) {
                stmt.rsCache = new DmdbResultSetCache(stmt, colsInfo);
            } else {
                stmt.rsCache.setCols(colsInfo);
            }
            stmt.rsCache.fillBuffer2(msg.getBuffer(), off, len, fetched_rows);
            if (this._$712.getNewStructFlag() == 72) {
                stmt.rsCache.setType(msg.getStmtId());
            }
        }
    }

    public final boolean isClosed() {
        return this._$1050;
    }

    public final synchronized void close() {
        if (this._$1050) {
            return;
        }
        if (this._$272 != null) {
            this._$272.close();
        }
        this._$272 = null;
        this._$712 = null;
        this._$1050 = true;
        this._$1052 = null;
    }

    protected final void finalize() {
        this.close();
    }

    public final synchronized void commitWork(int holdability) throws SQLException {
        int sqlcode;
        DmMsg recvMsg = null;
        this._$1052.setCmd(8);
        this._$1052.setLength(0);
        try {
            this._$272.send(this._$1052);
            recvMsg = this._$272.readPacket();
        }
        catch (IOException ioex) {
            DBError.throwSQLException(6001);
        }
        if (!recvMsg.checkCRC()) {
            DBError.throwSQLException(6002);
        }
        if ((sqlcode = recvMsg.getSQLCODE()) < 0) {
            String errInfo = recvMsg.getErrorInfo(this._$712.getServerEncoding());
            DBError.throwSQLException(errInfo, sqlcode);
        } else if (holdability == 2) {
            this._$712.close_all_resultSet();
        }
    }

    public final synchronized void rollbackWork(int holdability) throws SQLException {
        int sqlcode;
        DmMsg recvMsg = null;
        this._$1052.setCmd(9);
        this._$1052.setLength(0);
        try {
            this._$272.send(this._$1052);
            recvMsg = this._$272.readPacket();
        }
        catch (IOException ioex) {
            DBError.throwSQLException(6001);
        }
        if (!recvMsg.checkCRC()) {
            DBError.throwSQLException(6002);
        }
        if ((sqlcode = recvMsg.getSQLCODE()) < 0) {
            String errInfo = recvMsg.getErrorInfo(this._$712.getServerEncoding());
            DBError.throwSQLException(errInfo, sqlcode);
        } else if (holdability == 2) {
            this._$712.close_all_resultSet();
        }
    }

    private boolean _$1260(DmdbStatement stmt, DmdbParameter[] inParas, DmdbInfo des, boolean flag) throws SQLException {
        int paramTotal = inParas.length;
        DmdbParameter inPara = null;
        boolean ret = false;
        this._$1052.setStmtId(stmt.handle);
        if (this._$712.getAutoCommit() && this._$712.getCmdAutoCommitFlag() == 120) {
            this._$1052.setCmd(2054);
        } else {
            this._$1052.setCmd(6);
        }
        this._$1052.setRowCount(1L);
        this._$1052.setParamNum(des.getParameterCount());
        this._$1052.setCurPos(stmt.cursorUpdateRow);
        int offset = 64;
        for (int i = 0; i < paramTotal; ++i) {
            byte[] bs;
            String str;
            inPara = inParas[i];
            if (inPara.getInOutType() == 1) continue;
            int type = inPara.getCType();
            int offset2 = offset + 16;
            if (type != 12 && type != 19) {
                offset2 += inPara.getInValue().length;
            }
            if (offset2 >= this._$1052.getBufLength()) {
                byte[] buf = new byte[offset2 + 32768];
                System.arraycopy(this._$1052.getBuffer(), 0, buf, 0, this._$1052.getBufLength());
                this._$1052.setBuffer(buf);
            }
            boolean inDataNull = inPara.getIsInDataNull();
            if (type == 53) {
                this._$1052.setInt(2, offset);
            } else {
                this._$1052.setInt(type, offset);
            }
            int prec = type != 53 ? inPara.getPrecision() : inPara.getInValue().length;
            this._$1052.setInt(prec, offset += 4);
            int scale = type != 53 ? inPara.getScale() : ((str = new String(bs = inPara.getInValue())).indexOf(".") == -1 ? 0 : inPara.getInValue().length - str.indexOf("."));
            this._$1052.setInt(scale, offset += 4);
            int dataLen = inDataNull ? -2 : (type == 12 || type == 19 ? (stmt.getPutLobData() != 1 ? 0 : inPara.value.getStreamLen() + 5) : inPara.getInValue().length);
            this._$1052.setParamDataLength(dataLen, offset += 4);
            offset += 4;
            if (inDataNull) continue;
            if ((type == 12 || type == 19) && stmt.getPutLobData() != 1) {
                if (flag) continue;
                ret = true;
                this._$1296(stmt.handle, false, i);
                this._$1297(stmt.handle, i, inPara);
                continue;
            }
            if (type == 12 || type == 19) {
                byte[] tmp = new byte[inPara.value.getStreamLen()];
                inPara.getBytes(tmp, 0, 0, tmp.length);
                byte[] lob = this.createLobHead(tmp);
                this._$1052.setParamData(offset, lob);
            } else {
                this._$1052.setParamData(offset, inPara.getInValue());
            }
            offset += dataLen;
        }
        this._$1052.setLength(offset - 64);
        return ret;
    }

    private boolean _$1302(DmdbStatement stmt, ArrayList inParas, DmdbInfo des, boolean flag) throws SQLException {
        DmdbParameter[] param = null;
        DmdbParameter inPara = null;
        boolean ret = false;
        int inParasSize = inParas.size();
        this._$1052.setStmtId(stmt.handle);
        if (this._$712.getAutoCommit() && this._$712.getCmdAutoCommitFlag() == 120) {
            this._$1052.setCmd(2054);
        } else {
            this._$1052.setCmd(6);
        }
        this._$1052.setRowCount(inParasSize);
        this._$1052.setParamNum(des.getParameterCount());
        this._$1052.setCurPos(stmt.cursorUpdateRow);
        int offset = 64;
        for (int k = 0; k < inParasSize; ++k) {
            param = (DmdbParameter[])inParas.get(k);
            int paramTotal = param.length;
            for (int i = 0; i < paramTotal; ++i) {
                byte[] bs;
                String str;
                inPara = param[i];
                if (inPara.getInOutType() == 1) continue;
                int type = inPara.getCType();
                int offset2 = offset + 16;
                offset2 = type != 12 && type != 19 ? (offset2 += inPara.getInValue().length) : (offset2 += inPara.getInValue().length + 5);
                if (offset2 >= this._$1052.getBufLength()) {
                    byte[] buf = new byte[offset2 + 32768];
                    System.arraycopy(this._$1052.getBuffer(), 0, buf, 0, this._$1052.getBufLength());
                    this._$1052.setBuffer(buf);
                }
                boolean inDataNull = inPara.getIsInDataNull();
                if (type == 53) {
                    this._$1052.setInt(2, offset);
                } else {
                    this._$1052.setInt(type, offset);
                }
                int prec = type != 53 ? inPara.getPrecision() : inPara.getInValue().length;
                this._$1052.setInt(prec, offset += 4);
                int scale = type != 53 ? inPara.getScale() : ((str = new String(bs = inPara.getInValue())).indexOf(".") == -1 ? 0 : inPara.getInValue().length - str.indexOf("."));
                this._$1052.setInt(scale, offset += 4);
                int dataLen = inDataNull ? -2 : (type == 12 || type == 19 ? inPara.getInValue().length + 5 : inPara.getInValue().length);
                this._$1052.setParamDataLength(dataLen, offset += 4);
                offset += 4;
                if (inDataNull) continue;
                if (type == 12 || type == 19) {
                    byte[] lob = this.createLobHead(inPara.getInValue());
                    this._$1052.setParamData(offset, lob);
                    offset += dataLen;
                    continue;
                }
                this._$1052.setParamData(offset, inPara.getInValue());
                offset += dataLen;
            }
        }
        this._$1052.setLength(offset - 64);
        return ret;
    }

    public final synchronized DmdbInfo executePrepared(DmdbStatement stmt, DmdbParameter[] inParas, DmdbInfo des) throws SQLException {
        DmMsg recv = null;
        boolean flag = false;
        flag = this._$1260(stmt, inParas, des, false);
        if (flag) {
            this._$1260(stmt, inParas, des, true);
        }
        try {
            this._$272.send(this._$1052);
            recv = this._$272.readPacket();
        }
        catch (IOException ioex) {
            DBError.throwSQLException(6001);
        }
        stmt.setPutLobData(1);
        return this._$1308(stmt, recv, des, false);
    }

    public final synchronized int[] executePreparedBatch(DmdbStatement stmt, ArrayList inParas, DmdbInfo des) throws SQLException {
        DmMsg recv = null;
        this._$1302(stmt, inParas, des, true);
        try {
            this._$272.send(this._$1052);
            recv = this._$272.readPacket();
        }
        catch (IOException ioex) {
            DBError.throwSQLException(6001);
        }
        return this._$1310(recv);
    }

    public final synchronized DmdbInfo getMoreResult(DmdbStatement stmt, DmdbInfo des) throws SQLException {
        DmMsg recv = null;
        this._$1052.setStmtId(stmt.handle);
        if (this._$712.getAutoCommit() && this._$712.getCmdAutoCommitFlag() == 120) {
            this._$1052.setCmd(2092);
        } else {
            this._$1052.setCmd(44);
        }
        this._$1052.setLength(0);
        try {
            this._$272.send(this._$1052);
            recv = this._$272.readPacket();
        }
        catch (IOException ioex) {
            DBError.throwSQLException(6001);
        }
        return this._$1308(stmt, recv, des, true);
    }

    private DmdbInfo _$1308(DmdbStatement stmt, DmMsg recv, DmdbInfo des, boolean flag) throws SQLException {
        int printMsgOff;
        short colNum;
        short paraNum;
        long rowNum;
        int sqlcode;
        if (!recv.checkCRC()) {
            DBError.throwSQLException(6002);
        }
        if ((sqlcode = recv.getSQLCODE()) < 0) {
            String errInfo = recv.getErrorInfo(this._$712.getServerEncoding());
            DBError.throwSQLException(errInfo, sqlcode);
        }
        if (sqlcode > 0 && (sqlcode == 201 || sqlcode == 200 || sqlcode == -3404)) {
            sqlcode = 0;
            rowNum = 0L;
            paraNum = 0;
            colNum = 0;
        } else {
            rowNum = recv.getRowCount();
            rowNum = rowNum > 0L ? rowNum : 0L;
            paraNum = recv.getParamCount();
            paraNum = paraNum > 0 ? paraNum : (short)0;
            colNum = recv.getColumnCount();
            colNum = colNum > 0 ? colNum : (short)0;
        }
        byte[] rowid = recv.getCurPos();
        des.setRowId(rowid);
        if (!flag && (printMsgOff = recv.getOffsetOfPrintMsg()) > 0) {
            int printMsgLen = recv.getInt(printMsgOff);
            String val = recv.getString(printMsgOff + 4, printMsgLen, this._$712.getServerEncoding());
            des.setPrintMsg(val);
        }
        des.setRowCount(rowNum);
        short retCmd = recv.getCmd();
        if (retCmd == 150) {
            short isoLevel = recv.getColumnCount();
            stmt.connection.trans_level = isoLevel == 1 ? 2 : (isoLevel == 0 ? 1 : (isoLevel == 2 ? 4 : (isoLevel == 3 ? 8 : 0)));
            return des;
        }
        int offset = 64;
        if (!flag && des.getOutParamCount() > 0) {
            int outParamNum = recv.getParamCount();
            if (outParamNum != des.getOutParamCount()) {
                DBError.throwSQLException(6001);
            }
            int[] foot = new int[outParamNum];
            int allParamCount = des.getParameterCount();
            int j = 0;
            for (int i = 0; i < allParamCount; ++i) {
                short type = des.getParamsInfo()[i].getInOutType();
                if (type == 0) continue;
                foot[j] = i;
                ++j;
            }
            DmdbParameter[] allParams = des.getParamsInfo();
            byte[] value = null;
            for (int i = 0; i < outParamNum; ++i) {
                boolean isOutNull = false;
                short outParamValueLen = recv.getShort(offset);
                offset += 2;
                if (outParamValueLen == -2) {
                    outParamValueLen = 0;
                    isOutNull = true;
                }
                value = recv.getBytes(offset, outParamValueLen);
                allParams[foot[i]].clearOutParam();
                allParams[foot[i]].setOutValue(value);
                allParams[foot[i]].setOutDataBound(true);
                if (isOutNull) {
                    allParams[foot[i]].setOutNull();
                }
                offset += outParamValueLen;
            }
        }
        this._$1235(recv, offset, colNum, des);
        if ((retCmd == 160 || retCmd == 162 && colNum > 0) && sqlcode != 111) {
            this._$1238(stmt, recv, rowNum, des.getColumnsInfo());
        } else {
            des.setHasResultSet(false);
            if (sqlcode == 111) {
                des.setRowCount(-1L);
            }
        }
        return des;
    }

    private final synchronized void _$1296(int handle, boolean direct, int paramIndex) throws SQLException {
        int sqlcode;
        DmMsg blobMsg = new DmMsg();
        blobMsg.setStmtId(handle);
        if (this._$712.getAutoCommit() && this._$712.getCmdAutoCommitFlag() == 120) {
            blobMsg.setCmd(2064);
        } else {
            blobMsg.setCmd(16);
        }
        blobMsg.setLength(2);
        blobMsg.setExecDirect(direct);
        blobMsg.setShort(paramIndex, 64);
        DmMsg recvMsg = null;
        try {
            this._$272.send(blobMsg);
            recvMsg = this._$272.readPacket();
        }
        catch (IOException ioex) {
            DBError.throwSQLException(6001);
        }
        if (!recvMsg.checkCRC()) {
            DBError.throwSQLException(6002);
        }
        if ((sqlcode = recvMsg.getSQLCODE()) < 0) {
            String errInfo = recvMsg.getErrorInfo(this._$712.getServerEncoding());
            DBError.throwSQLException(errInfo, sqlcode);
        }
    }

    private final synchronized void _$1297(int handle, int paramIndex, DmdbParameter inPara) throws SQLException {
        int maxLen = 32000;
        int off = 0;
        DmMsg blobMsg = new DmMsg();
        int msgOff = 76;
        if (inPara.getCType() == 19) {
            maxLen = 8000;
        }
        int len = inPara.getBytes(blobMsg.getBuffer(), msgOff, off, maxLen);
        while (len > 0) {
            if (len < maxLen) {
                this._$1343(handle, blobMsg, paramIndex, len, (byte)1);
                return;
            }
            this._$1343(handle, blobMsg, paramIndex, len, (byte)0);
            len = inPara.getBytes(blobMsg.getBuffer(), msgOff, off += maxLen, maxLen);
        }
        this._$1343(handle, blobMsg, paramIndex, len, (byte)1);
    }

    private final void _$1343(int handle, DmMsg blobMsg, int paramIndex, int len, byte isOver) throws SQLException {
        int sqlcode;
        DmMsg recvMsg = null;
        int msgLen = 0;
        msgLen = 76 + len;
        blobMsg.setStmtId(handle);
        if (this._$712.getAutoCommit() && this._$712.getCmdAutoCommitFlag() == 120) {
            blobMsg.setCmd(2062);
        } else {
            blobMsg.setCmd(14);
        }
        blobMsg.setLength(msgLen - 64);
        blobMsg.setShort(paramIndex, 64);
        blobMsg.setByte(isOver, 66);
        blobMsg.setInt(len + 5, 67);
        blobMsg.setByte(1, 71);
        blobMsg.setInt(len, 72);
        try {
            this._$272.send(blobMsg);
            recvMsg = this._$272.readPacket();
        }
        catch (IOException ioex) {
            DBError.throwSQLException(6001);
        }
        if (!recvMsg.checkCRC()) {
            DBError.throwSQLException(6002);
        }
        if ((sqlcode = recvMsg.getSQLCODE()) < 0) {
            String errInfo = recvMsg.getErrorInfo(this._$712.getServerEncoding());
            DBError.throwSQLException(errInfo, sqlcode);
        }
    }

    public final synchronized byte[] getBlobData(int handle, boolean direct, byte[] dbid_bid, int startPos, int toGetLenInBytes) throws SQLException {
        int count;
        int copyLen;
        Vector<byte[]> vec = new Vector<byte[]>(10);
        boolean isOver = false;
        DmMsg recvMsg = null;
        int msgLen = 88;
        byte[] aBlockData = null;
        for (count = 0; !isOver && count < toGetLenInBytes; count += copyLen) {
            int sqlcode;
            this._$1052.setStmtId(handle);
            if (this._$712.getAutoCommit() && this._$712.getCmdAutoCommitFlag() == 120) {
                this._$1052.setCmd(2063);
            } else {
                this._$1052.setCmd(15);
            }
            this._$1052.setLength(msgLen - 64);
            this._$1052.setExecDirect(direct);
            this._$1052.setBytes(dbid_bid, 0, 64, 16);
            this._$1052.setInt(toGetLenInBytes - count, 80);
            this._$1052.setInt(startPos + count, 84);
            try {
                this._$272.send(this._$1052);
                recvMsg = this._$272.readPacket();
            }
            catch (IOException ioex) {
                DBError.throwSQLException(6001);
            }
            if (!recvMsg.checkCRC()) {
                DBError.throwSQLException(6002);
            }
            if ((sqlcode = recvMsg.getSQLCODE()) < 0) {
                String errInfo = recvMsg.getErrorInfo(this._$712.getServerEncoding());
                DBError.throwSQLException(errInfo, sqlcode);
            }
            isOver = recvMsg.getByte(64) == 1;
            int aBlockLen = recvMsg.getInt(65);
            copyLen = count + aBlockLen > toGetLenInBytes ? toGetLenInBytes - count : aBlockLen;
            aBlockData = recvMsg.getBytes(69, copyLen);
            vec.add(aBlockData);
        }
        byte[] retData = new byte[count];
        int offset = 0;
        for (int i = 0; i < vec.size(); ++i) {
            aBlockData = (byte[])vec.get(i);
            System.arraycopy(aBlockData, 0, retData, offset, aBlockData.length);
            offset += aBlockData.length;
        }
        return retData;
    }

    public final synchronized int fetch(DmdbStatement stmt, long curPos, boolean fetchAll, DmdbResultSet resultSet) throws SQLException {
        int sqlcode = 0;
        DmMsg recvMsg = null;
        int bufLen = 32768;
        int totalLen = 0;
        byte[] buf = null;
        byte[] buf2 = null;
        DmdbResultSet rs = stmt.currentRs;
        int fetchNum = 0;
        totalLen = 0;
        int offset = 0;
        try {
            do {
                if (this._$712.getAutoCommit() && this._$712.getCmdAutoCommitFlag() == 120) {
                    this._$1052.setCmd(2055);
                } else {
                    this._$1052.setCmd(7);
                }
                this._$1052.setStmtId(stmt.handle);
                this._$1052.setRowCount(Long.MAX_VALUE);
                this._$1052.setCurPos(curPos);
                this._$1052.setLength(0);
                this._$272.send(this._$1052);
                recvMsg = this._$272.readPacket();
                if (!recvMsg.checkCRC()) {
                    DBError.throwSQLException(6002);
                }
                if ((sqlcode = recvMsg.getSQLCODE()) == -3336) {
                    if (rs != null) {
                        rs.rowCount = recvMsg.getRowCount();
                    } else {
                        resultSet.rowCount = recvMsg.getRowCount();
                    }
                } else {
                    if (sqlcode < 0) {
                        String errInfo = recvMsg.getErrorInfo(this._$712.getServerEncoding());
                        DBError.throwSQLException(errInfo, sqlcode);
                    }
                    if (buf == null) {
                        buf = new byte[bufLen];
                    }
                    if (totalLen + recvMsg.getLength() > bufLen) {
                        buf2 = new byte[totalLen + 65536];
                        System.arraycopy(buf, 0, buf2, 0, buf.length);
                        buf = buf2;
                    }
                    System.arraycopy(recvMsg.getBuffer(), 64, buf, offset, recvMsg.getLength());
                    offset += recvMsg.getLength();
                    totalLen += recvMsg.getLength();
                    fetchNum = (int)((long)fetchNum + recvMsg.getRowCount());
                    curPos += recvMsg.getRowCount();
                    if (rs == null && recvMsg.getRowCount() != Long.MAX_VALUE) {
                        resultSet.rowCount = fetchNum;
                    }
                    if (sqlcode != 100) continue;
                    if (rs != null && rs.rowCount == Long.MAX_VALUE) {
                        rs.rowCount = curPos;
                    }
                }
                break;
            } while (fetchAll);
        }
        catch (IOException ioex) {
            DBError.throwSQLException(6001);
        }
        stmt.rsCache.fillBuffer(buf, totalLen, fetchNum);
        if (this._$712.getNewStructFlag() == 72) {
            stmt.rsCache.setType(this._$1052.getStmtId());
        }
        return sqlcode;
    }

    final synchronized void setCursorName(DmdbStatement stmt, String cursorName) throws SQLException {
        int sqlcode;
        if (cursorName == null) {
            DBError.throwSQLException(6036);
        }
        byte[] buf = Convertion.getBytes(cursorName, this._$712.getServerEncoding());
        int len = buf.length + 1;
        this._$1052.setStmtId(stmt.handle);
        if (this._$712.getAutoCommit() && this._$712.getCmdAutoCommitFlag() == 120) {
            this._$1052.setCmd(2075);
        } else {
            this._$1052.setCmd(27);
        }
        this._$1052.setLength(len);
        this._$1052.setExecDirect(true);
        this._$1052.setStringWithNTS(buf, 64);
        DmMsg recvMsg = null;
        try {
            this._$272.send(this._$1052);
            recvMsg = this._$272.readPacket();
        }
        catch (IOException ioex) {
            DBError.throwSQLException(6001);
        }
        if (!recvMsg.checkCRC()) {
            DBError.throwSQLException(6002);
        }
        if ((sqlcode = recvMsg.getSQLCODE()) < 0) {
            String errInfo = recvMsg.getErrorInfo(this._$712.getServerEncoding());
            DBError.throwSQLException(errInfo, sqlcode);
        }
    }

    private final synchronized String _$1380(DmdbStatement stmt, String sqlToExplain) throws SQLException {
        if (sqlToExplain == null || sqlToExplain.trim().length() == 0) {
            DBError.throwSQLException(6003);
        }
        sqlToExplain = "EXPLAIN " + sqlToExplain;
        byte[] buf = Convertion.getBytes(sqlToExplain, this._$712.getServerEncoding());
        int len = buf.length + 1;
        if (this._$712.getAutoCommit() && this._$712.getCmdAutoCommitFlag() == 120) {
            this._$1052.setCmd(2053);
        } else {
            this._$1052.setCmd(5);
        }
        this._$1052.setStmtId(stmt.handle);
        this._$1052.setLength(len);
        this._$1052.setExecDirect(true);
        this._$1052.setStringWithNTS(buf, 64);
        DmMsg recvMsg = null;
        try {
            this._$272.send(this._$1052);
            recvMsg = this._$272.readPacket();
        }
        catch (IOException ioex) {
            DBError.throwSQLException(6001);
        }
        if (!recvMsg.checkCRC()) {
            DBError.throwSQLException(6002);
        }
        String explainInfo = recvMsg.getErrorInfo(this._$712.getServerEncoding());
        int sqlcode = recvMsg.getSQLCODE();
        if (sqlcode < 0) {
            DBError.throwSQLException(explainInfo, sqlcode);
        }
        return explainInfo;
    }

    public final synchronized String getExplainInfo(String sqlToExplain) throws SQLException {
        String explainInfo = null;
        DmdbStatement stmt = (DmdbStatement)this._$712.createStatement();
        try {
            explainInfo = this._$1380(stmt, sqlToExplain);
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            stmt.close();
        }
        return explainInfo;
    }

    public final synchronized int blob_text_truncate(int handle, long curPos, short dbid, int tabid, int rowid_high, int rowid_low, short colid, int length, int cmd) throws SQLException {
        int sqlcode;
        int offset = 64;
        this._$1052.setStmtId(handle);
        this._$1052.setCurPos(curPos);
        if (this._$712.getAutoCommit() && this._$712.getCmdAutoCommitFlag() == 120) {
            this._$1052.setCmd(cmd | 0x800);
        } else {
            this._$1052.setCmd(cmd);
        }
        this._$1052.setLength(20);
        this._$1052.setShort(dbid, offset);
        this._$1052.setInt(tabid, offset += 2);
        this._$1052.setInt(rowid_high, offset += 4);
        this._$1052.setInt(rowid_low, offset += 4);
        this._$1052.setShort(colid, offset += 4);
        this._$1052.setInt(length, offset += 2);
        DmMsg recv = null;
        try {
            this._$272.send(this._$1052);
            recv = this._$272.readPacket();
        }
        catch (IOException ioex) {
            DBError.throwSQLException(6001);
        }
        if (!recv.checkCRC()) {
            DBError.throwSQLException(6002);
        }
        if ((sqlcode = recv.getSQLCODE()) < 0) {
            String errInfo = recv.getErrorInfo(this._$712.getServerEncoding());
            DBError.throwSQLException(errInfo, sqlcode);
        }
        return recv.getInt(64);
    }

    public final synchronized int lob_get_len(int handle, long curPos, short dbid, int tabid, int rowid_high, int rowid_low, short colid, int cmd) throws SQLException {
        int sqlcode;
        int offset = 64;
        DmMsg lobMsg = new DmMsg();
        lobMsg.setStmtId(handle);
        lobMsg.setCurPos(curPos);
        if (this._$712.getAutoCommit() && this._$712.getCmdAutoCommitFlag() == 120) {
            lobMsg.setCmd(cmd | 0x800);
        } else {
            lobMsg.setCmd(cmd);
        }
        lobMsg.setLength(16);
        lobMsg.setShort(dbid, offset);
        lobMsg.setInt(tabid, offset += 2);
        lobMsg.setInt(rowid_high, offset += 4);
        lobMsg.setInt(rowid_low, offset += 4);
        lobMsg.setShort(colid, offset += 4);
        DmMsg recv = null;
        try {
            this._$272.send(lobMsg);
            recv = this._$272.readPacket();
        }
        catch (IOException ioex) {
            DBError.throwSQLException(6001);
        }
        if (!recv.checkCRC()) {
            DBError.throwSQLException(6002);
        }
        if ((sqlcode = recv.getSQLCODE()) < 0) {
            String errInfo = recv.getErrorInfo(this._$712.getServerEncoding());
            DBError.throwSQLException(errInfo, sqlcode);
        }
        return recv.getInt(64);
    }

    public final synchronized byte[] blob_get_bytes(int handle, long curPos, short dbid, int tabid, int rowid_high, int rowid_low, short colid, int start_pos, int length) throws SQLException {
        int sqlcode;
        byte[] value = null;
        int len = 0;
        int offset = 64;
        DmMsg blobMsg = new DmMsg();
        blobMsg.setStmtId(handle);
        blobMsg.setCurPos(curPos);
        if (this._$712.getAutoCommit() && this._$712.getCmdAutoCommitFlag() == 120) {
            blobMsg.setCmd(2107);
        } else {
            blobMsg.setCmd(59);
        }
        blobMsg.setLength(24);
        blobMsg.setShort(dbid, offset);
        blobMsg.setInt(tabid, offset += 2);
        blobMsg.setInt(rowid_high, offset += 4);
        blobMsg.setInt(rowid_low, offset += 4);
        blobMsg.setShort(colid, offset += 4);
        blobMsg.setInt(start_pos, offset += 2);
        blobMsg.setInt(length, offset += 4);
        DmMsg recv = null;
        try {
            this._$272.send(blobMsg);
            recv = this._$272.readPacket();
        }
        catch (IOException ioex) {
            DBError.throwSQLException(6001);
        }
        if (!recv.checkCRC()) {
            DBError.throwSQLException(6002);
        }
        if ((sqlcode = recv.getSQLCODE()) < 0) {
            String errInfo = recv.getErrorInfo(this._$712.getServerEncoding());
            DBError.throwSQLException(errInfo, sqlcode);
        }
        if ((len = recv.getInt(64)) <= 0) {
            return null;
        }
        value = new byte[len];
        System.arraycopy(recv.getBuffer(), 68, value, 0, len);
        return value;
    }

    public final synchronized int blob_set_bytes(int handle, long curPos, short dbid, int tabid, int rowid_high, int rowid_low, short colid, int start_pos, byte[] buf, int off, int len) throws SQLException {
        int sqlcode;
        int offset = 64;
        this._$1052.setStmtId(handle);
        this._$1052.setCurPos(curPos);
        if (this._$712.getAutoCommit() && this._$712.getCmdAutoCommitFlag() == 120) {
            this._$1052.setCmd(2100);
        } else {
            this._$1052.setCmd(52);
        }
        this._$1052.setLength(24 + len);
        this._$1052.setShort(dbid, offset);
        this._$1052.setInt(tabid, offset += 2);
        this._$1052.setInt(rowid_high, offset += 4);
        this._$1052.setInt(rowid_low, offset += 4);
        this._$1052.setShort(colid, offset += 4);
        this._$1052.setInt(start_pos, offset += 2);
        this._$1052.setInt(len, offset += 4);
        this._$1052.setBytes(buf, off, offset += 4, len);
        DmMsg recv = null;
        try {
            this._$272.send(this._$1052);
            recv = this._$272.readPacket();
        }
        catch (IOException ioex) {
            DBError.throwSQLException(6001);
        }
        if (!recv.checkCRC()) {
            DBError.throwSQLException(6002);
        }
        if ((sqlcode = recv.getSQLCODE()) < 0) {
            String errInfo = recv.getErrorInfo(this._$712.getServerEncoding());
            DBError.throwSQLException(errInfo, sqlcode);
        }
        return recv.getInt(64);
    }

    public final synchronized int text_set_string(int handle, long curPos, short dbid, int tabid, int rowid_high, int rowid_low, short colid, int start_pos, byte[] buf, int off, int len, byte[] byteLen, byte[] flag) throws SQLException {
        int sqlcode;
        int offset = 64;
        this._$1052.setStmtId(handle);
        this._$1052.setCurPos(curPos);
        if (this._$712.getAutoCommit() && this._$712.getCmdAutoCommitFlag() == 120) {
            this._$1052.setCmd(2103);
        } else {
            this._$1052.setCmd(55);
        }
        this._$1052.setLength(24 + len);
        this._$1052.setShort(dbid, offset);
        this._$1052.setInt(tabid, offset += 2);
        this._$1052.setInt(rowid_high, offset += 4);
        this._$1052.setInt(rowid_low, offset += 4);
        this._$1052.setShort(colid, offset += 4);
        this._$1052.setInt(start_pos, offset += 2);
        this._$1052.setInt(len, offset += 4);
        this._$1052.setBytes(buf, off, offset += 4, len);
        DmMsg recv = null;
        try {
            this._$272.send(this._$1052);
            recv = this._$272.readPacket();
        }
        catch (IOException ioex) {
            DBError.throwSQLException(6001);
        }
        if (!recv.checkCRC()) {
            DBError.throwSQLException(6002);
        }
        if ((sqlcode = recv.getSQLCODE()) < 0) {
            String errInfo = recv.getErrorInfo(this._$712.getServerEncoding());
            DBError.throwSQLException(errInfo, sqlcode);
        }
        System.arraycopy(recv.getBytes(64, 4), 0, byteLen, 0, 4);
        System.arraycopy(recv.getBytes(72, 4), 0, flag, 0, 4);
        return recv.getInt(68);
    }

    public final synchronized String text_get_subString(int handle, long curPos, short dbid, int tabid, int rowid_high, int rowid_low, short colid, int start_pos, int byte_pos, int length, byte[] byte_off) throws SQLException {
        int sqlcode;
        int byteLen = 0;
        int charLen = 0;
        int offset = 64;
        DmMsg clobMsg = new DmMsg();
        String str = null;
        clobMsg.setStmtId(handle);
        clobMsg.setCurPos(curPos);
        if (this._$712.getAutoCommit() && this._$712.getCmdAutoCommitFlag() == 120) {
            clobMsg.setCmd(2102);
        } else {
            clobMsg.setCmd(54);
        }
        clobMsg.setLength(28);
        clobMsg.setShort(dbid, offset);
        clobMsg.setInt(tabid, offset += 2);
        clobMsg.setInt(rowid_high, offset += 4);
        clobMsg.setInt(rowid_low, offset += 4);
        clobMsg.setShort(colid, offset += 4);
        clobMsg.setInt(start_pos, offset += 2);
        clobMsg.setInt(byte_pos, offset += 4);
        clobMsg.setInt(length, offset += 4);
        DmMsg recv = null;
        try {
            this._$272.send(clobMsg);
            recv = this._$272.readPacket();
        }
        catch (IOException ioex) {
            DBError.throwSQLException(6001);
        }
        if (!recv.checkCRC()) {
            DBError.throwSQLException(6002);
        }
        if ((sqlcode = recv.getSQLCODE()) < 0) {
            String errInfo = recv.getErrorInfo(this._$712.getServerEncoding());
            DBError.throwSQLException(errInfo, sqlcode);
        }
        offset = 64;
        byteLen = recv.getInt(offset);
        charLen = recv.getInt(offset += 4);
        byte[] byteOffset = recv.getBytes(offset += 4, 4);
        offset += 4;
        if (charLen <= 0) {
            return null;
        }
        System.arraycopy(byteOffset, 0, byte_off, 0, 4);
        str = recv.getString(offset, byteLen, this._$712.getServerEncoding());
        return str;
    }

    public final void alarmRecvRequest() throws Exception {
        if (this._$712.getAutoCommit() && this._$712.getCmdAutoCommitFlag() == 120) {
            this._$1052.setCmd(2070);
        } else {
            this._$1052.setCmd(22);
        }
        this._$1052.setLength(0);
        this._$272.send(this._$1052);
        this._$272.readPacket();
    }

    public final int receiveAlarm() throws Exception {
        DmMsg recvMsg = this._$272.readPacket();
        return recvMsg.getInt(22);
    }

    public final void addAlarm(int[] alarms) throws Exception {
        if (this._$712.getAutoCommit() && this._$712.getCmdAutoCommitFlag() == 120) {
            this._$1052.setCmd(2071);
        } else {
            this._$1052.setCmd(23);
        }
        this._$1052.setLength(alarms.length * 4);
        for (int i = 0; i < alarms.length; ++i) {
            this._$1052.setInt(alarms[i], 64 + i * 4);
        }
        this._$272.send(this._$1052);
    }

    public final void deleteAlarm(int alarm) throws Exception {
        if (this._$712.getAutoCommit() && this._$712.getCmdAutoCommitFlag() == 120) {
            this._$1052.setCmd(2072);
        } else {
            this._$1052.setCmd(24);
        }
        this._$1052.setLength(4);
        this._$1052.setInt(alarm, 64);
        this._$272.send(this._$1052);
    }

    private final int _$1234(DmMsg recv, int offset, int paraNum, DmdbInfo des) {
        if (paraNum > 0) {
            byte[] buf = recv.getBuffer();
            DmdbParameter[] paramsInfo = new DmdbParameter[paraNum];
            for (int i = 0; i < paraNum; ++i) {
                paramsInfo[i] = new DmdbParameter(this._$712);
                short ioType = recv.getParamType(offset);
                int dataType = recv.getdType(offset);
                int typePrec = recv.getPrec(offset);
                int typeScale = recv.getScale(offset);
                boolean nullable = recv.getNullable(offset);
                short nameLen = recv.getNameLen(offset);
                short typeNameLen = recv.getTypeNameLen(offset);
                short tableLen = recv.getTableLen(offset);
                short schemaLen = recv.getSchemaLen(offset);
                short catalogLen = recv.getCatalogLen(offset);
                offset += 34;
                try {
                    paramsInfo[i].setName2(buf, offset, nameLen);
                    paramsInfo[i].setTypeName(buf, offset += nameLen, typeNameLen);
                    paramsInfo[i].setTable(buf, offset += typeNameLen, tableLen);
                    paramsInfo[i].setSchema(buf, offset += tableLen, schemaLen);
                    paramsInfo[i].setCatalog(buf, offset += schemaLen, catalogLen);
                    offset += catalogLen;
                    if (dataType != 53) {
                        paramsInfo[i].setCType(dataType);
                    } else {
                        paramsInfo[i].setCType(2);
                    }
                    paramsInfo[i].setJdbcSqlType(DmdbType.CTypeToJdbcType(dataType, paramsInfo[i]));
                }
                catch (Exception ex) {
                    System.out.println(ex.toString());
                }
                if (dataType == 53 && typePrec == 0) {
                    paramsInfo[i].setPrecision(8188);
                } else {
                    paramsInfo[i].setPrecision(typePrec);
                }
                paramsInfo[i].setJdbcPrecision(DmdbType.CPrecToJdbcPrec(paramsInfo[i].getJdbcSqlType(), typePrec));
                paramsInfo[i].setScale(typeScale);
                paramsInfo[i].setNullable(nullable);
                paramsInfo[i].setInOutType(ioType);
            }
            des.setParamsInfo(paramsInfo);
        }
        return offset;
    }

    private final int _$1235(DmMsg recv, int offset, int colNum, DmdbInfo des) {
        if (colNum > 0) {
            boolean isLob = false;
            byte[] buf = recv.getBuffer();
            DmdbColumn[] columnsInfo = new DmdbColumn[colNum];
            for (int i = 0; i < colNum; ++i) {
                columnsInfo[i] = new DmdbColumn(this._$712);
                int dataType = recv.getdType(offset);
                int typePrec = recv.getPrec(offset);
                int typeScale = recv.getScale(offset);
                boolean nullable = recv.getNullable(offset);
                short itemFlag = recv.getItemFlag(offset);
                short nameLen = recv.getNameLen(offset);
                short typeNameLen = recv.getTypeNameLen(offset);
                short tableLen = recv.getTableLen(offset);
                short schemaLen = recv.getSchemaLen(offset);
                short catalogLen = recv.getCatalogLen(offset);
                offset += 34;
                if ((itemFlag & 1) == 1) {
                    columnsInfo[i].setIdentity(true);
                }
                if ((itemFlag & 2) == 2) {
                    columnsInfo[i].setIsLob(true);
                    isLob = true;
                } else {
                    isLob = false;
                }
                columnsInfo[i].setName2(buf, offset, nameLen);
                columnsInfo[i].setTypeName(buf, offset += nameLen, typeNameLen);
                columnsInfo[i].setTable(buf, offset += typeNameLen, tableLen);
                columnsInfo[i].setSchema(buf, offset += tableLen, schemaLen);
                columnsInfo[i].setCatalog(buf, offset += schemaLen, catalogLen);
                offset += catalogLen;
                columnsInfo[i].setCType(dataType);
                int jdbcType = DmdbType.CTypeToJdbcType(dataType, columnsInfo[i]);
                columnsInfo[i].setJdbcSqlType(jdbcType);
                columnsInfo[i].setPrecision(typePrec);
                columnsInfo[i].setJdbcPrecision(DmdbType.CPrecToJdbcPrec(jdbcType, typePrec));
                columnsInfo[i].setScale(typeScale);
                columnsInfo[i].setNullable(nullable);
                if (!isLob) continue;
                columnsInfo[i].setDbID(recv.getShort(offset));
                columnsInfo[i].setSchemaID(recv.getInt(offset += 2));
                columnsInfo[i].setTableID(recv.getInt(offset += 4));
                columnsInfo[i].setColID(recv.getShort(offset += 4));
                short len = recv.getShort(offset += 2);
                columnsInfo[i].setBaseCatalog(recv.getString(offset += 2, len, this._$712.getServerEncoding()));
                offset += len;
                len = recv.getShort(offset);
                columnsInfo[i].setBaseSchema(recv.getString(offset += 2, len, this._$712.getServerEncoding()));
                offset += len;
                len = recv.getShort(offset);
                columnsInfo[i].setBaseTable(recv.getString(offset += 2, len, this._$712.getServerEncoding()));
                offset += len;
                len = recv.getShort(offset);
                columnsInfo[i].setBaseColumn(recv.getString(offset += 2, len, this._$712.getServerEncoding()));
                offset += len;
            }
            des.setUpdatable(recv.getByte(offset) != 0);
            ++offset;
            des.setColumnsInfo(columnsInfo);
            des.setHasResultSet(true);
        }
        return offset;
    }

    public final synchronized boolean isServerActive() {
        DmMsg recvMsg = null;
        this._$1052.setCmd(0);
        this._$1052.setLength(0);
        try {
            this._$272.send(this._$1052);
            recvMsg = this._$272.readPacket();
        }
        catch (IOException ioex) {
            return false;
        }
        return recvMsg.checkCRC() && recvMsg.getSQLCODE() == 0;
    }

    public final synchronized boolean isTrxActive() throws SQLException {
        int trxActive;
        int sqlcode;
        DmMsg recvMsg = null;
        this._$1052.setCmd(106);
        this._$1052.setLength(0);
        try {
            this._$272.send(this._$1052);
            recvMsg = this._$272.readPacket();
        }
        catch (IOException ioex) {
            DBError.throwSQLException(6001);
        }
        if (!recvMsg.checkCRC()) {
            DBError.throwSQLException(6002);
        }
        if ((sqlcode = recvMsg.getSQLCODE()) < 0) {
            String errInfo = recvMsg.getErrorInfo(this._$712.getServerEncoding());
            DBError.throwSQLException(errInfo, sqlcode);
        }
        return (trxActive = recvMsg.getInt(64)) > 0;
    }

    protected int getGlobalServerSeries() {
        return this._$1053;
    }

    public DbAccess getDbAccess() {
        return this._$272;
    }

    public final synchronized int xa_process(int xa_type, Xid xid, int flag) throws Exception {
        int sqlcode;
        int i;
        DmMsg recvMsg = null;
        this._$1052.setCmd(60);
        int offset = 64;
        this._$1052.setInt(xa_type, offset);
        this._$1052.setInt(xid.getFormatId(), offset += 4);
        this._$1052.setInt(xid.getGlobalTransactionId().length, offset += 4);
        this._$1052.setInt(xid.getBranchQualifier().length, offset += 4);
        offset += 4;
        byte[] tmp = new byte[128];
        for (i = 0; i < xid.getGlobalTransactionId().length; ++i) {
            tmp[i] = xid.getGlobalTransactionId()[i];
        }
        for (i = 0; i < xid.getBranchQualifier().length; ++i) {
            tmp[64 + i] = xid.getBranchQualifier()[i];
        }
        this._$1052.setBytes(tmp, 0, offset, tmp.length);
        this._$1052.setInt(flag, offset += tmp.length);
        this._$1052.setLength(offset += 4);
        try {
            this._$272.send(this._$1052);
            recvMsg = this._$272.readPacket();
        }
        catch (IOException ioex) {
            DBError.throwSQLException(6001);
        }
        if (!recvMsg.checkCRC()) {
            DBError.throwSQLException(6002);
        }
        if ((sqlcode = recvMsg.getSQLCODE()) < 0) {
            throw new XAException(sqlcode + 3850);
        }
        if (sqlcode >= 304 && sqlcode <= 400) {
            throw new XAException(sqlcode - 300);
        }
        if (sqlcode == 303) {
            return 3;
        }
        return sqlcode;
    }

    public final synchronized Xid[] xa_recover(DmdbXAResource xaResource, int flag) throws Exception {
        int sqlcode;
        DmMsg recvMsg = null;
        this._$1052.setCmd(60);
        int offset = 64;
        this._$1052.setInt(6, offset);
        this._$1052.setInt(255, offset += 4);
        this._$1052.setInt(255, offset += 4);
        this._$1052.setInt(255, offset += 4);
        offset += 4;
        byte[] tmp = new byte[128];
        for (int i = 0; i < tmp.length; ++i) {
            tmp[i] = 15;
        }
        this._$1052.setBytes(tmp, 0, offset, tmp.length);
        this._$1052.setInt(flag, offset += tmp.length);
        this._$1052.setLength(offset += 4);
        try {
            this._$272.send(this._$1052);
            recvMsg = this._$272.readPacket();
        }
        catch (IOException ioex) {
            DBError.throwSQLException(6001);
        }
        if (!recvMsg.checkCRC()) {
            DBError.throwSQLException(6002);
        }
        if ((sqlcode = recvMsg.getSQLCODE()) < 0) {
            throw new XAException(sqlcode + 3850);
        }
        if (sqlcode >= 304 && sqlcode <= 400) {
            throw new XAException(sqlcode - 300);
        }
        offset = 64;
        offset += recvMsg.getInt(offset);
        offset += 4;
        offset += recvMsg.getInt(offset);
        offset += 4;
        offset += recvMsg.getInt(offset);
        offset += 4;
        offset += recvMsg.getInt(offset);
        int tmpLen = recvMsg.getInt(offset += 4);
        offset += 4;
        byte ifEnd = recvMsg.getByte(offset += tmpLen);
        ++offset;
        if (ifEnd == 1) {
            xaResource.recoverd = true;
        }
        int rownum = (int)recvMsg.getRowCount();
        Xid[] xids = new Xid[rownum];
        for (int i = 0; i < rownum; ++i) {
            int formatId = recvMsg.getInt(offset);
            int gtrid_length = recvMsg.getInt(offset += 4);
            int bqual_length = recvMsg.getInt(offset += 4);
            byte[] gTranId = recvMsg.getBytes(offset += 4, gtrid_length);
            byte[] bQual = recvMsg.getBytes(offset += 64, bqual_length);
            offset += 64;
            DmdbXid xid = new DmdbXid(formatId, gTranId, bQual);
            xids[i] = xid;
        }
        return xids;
    }

    public final synchronized DmdbSynchronizeTrx[] getSyncTrx() throws SQLException {
        int sqlcode;
        DmMsg recvMsg = null;
        this._$1052.setCmd(108);
        this._$1052.setLength(0);
        try {
            this._$272.send(this._$1052);
            recvMsg = this._$272.readPacket();
        }
        catch (IOException ioex) {
            DBError.throwSQLException(6001);
        }
        if (!recvMsg.checkCRC()) {
            DBError.throwSQLException(6002);
        }
        if ((sqlcode = recvMsg.getSQLCODE()) < 0) {
            String errInfo = recvMsg.getErrorInfo(this._$712.getServerEncoding());
            DBError.throwSQLException(errInfo, sqlcode);
        }
        int num = (int)recvMsg.getRowCount();
        DmdbSynchronizeTrx[] trxes = new DmdbSynchronizeTrx[num];
        int offset = 64;
        for (int i = 0; i < num; ++i) {
            DmdbSynchronizeTrx trx;
            int mDbMagic = recvMsg.getInt(offset);
            int mTrxid = recvMsg.getInt(offset += 4);
            int dbMagic = recvMsg.getInt(offset += 4);
            int trxid = recvMsg.getInt(offset += 4);
            int state = recvMsg.getInt(offset += 4);
            offset += 4;
            trxes[i] = trx = new DmdbSynchronizeTrx(mDbMagic, mTrxid, dbMagic, trxid, state);
        }
        return trxes;
    }

    public final synchronized void heurCommitSyncTrx(int dbMagic, int trxid) throws SQLException {
        int sqlcode;
        DmMsg recvMsg = null;
        this._$1052.setCmd(109);
        int offset = 64;
        this._$1052.setInt(dbMagic, offset);
        this._$1052.setInt(trxid, offset += 4);
        this._$1052.setLength(offset += 4);
        try {
            this._$272.send(this._$1052);
            recvMsg = this._$272.readPacket();
        }
        catch (IOException ioex) {
            DBError.throwSQLException(6001);
        }
        if (!recvMsg.checkCRC()) {
            DBError.throwSQLException(6002);
        }
        if ((sqlcode = recvMsg.getSQLCODE()) < 0) {
            String errInfo = recvMsg.getErrorInfo(this._$712.getServerEncoding());
            DBError.throwSQLException(errInfo, sqlcode);
        }
    }

    public final synchronized void heurRollbackSyncTrx(int dbMagic, int trxid) throws SQLException {
        int sqlcode;
        DmMsg recvMsg = null;
        this._$1052.setCmd(110);
        int offset = 64;
        this._$1052.setInt(dbMagic, offset);
        this._$1052.setInt(trxid, offset += 4);
        this._$1052.setLength(offset += 4);
        try {
            this._$272.send(this._$1052);
            recvMsg = this._$272.readPacket();
        }
        catch (IOException ioex) {
            DBError.throwSQLException(6001);
        }
        if (!recvMsg.checkCRC()) {
            DBError.throwSQLException(6002);
        }
        if ((sqlcode = recvMsg.getSQLCODE()) < 0) {
            String errInfo = recvMsg.getErrorInfo(this._$712.getServerEncoding());
            DBError.throwSQLException(errInfo, sqlcode);
        }
    }

    public final synchronized void resetPooledConnection(int transLevel, String database, int language, boolean autoCommit) throws SQLException {
        int sqlcode;
        DmMsg recvMsg = null;
        this._$1052.setCmd(50);
        int offset = 64;
        this._$1052.setInt(transLevel, offset);
        int tmpLen = database.getBytes().length;
        this._$1052.setInt(tmpLen, offset += 4);
        this._$1052.setExecDirect(false);
        this._$1052.setString(database, offset += 4);
        this._$1052.setInt(language, offset += tmpLen);
        offset += 4;
        if (autoCommit) {
            this._$1052.setInt(1, offset);
        } else {
            this._$1052.setInt(0, offset);
        }
        this._$1052.setLength(offset += 4);
        try {
            this._$272.send(this._$1052);
            recvMsg = this._$272.readPacket();
        }
        catch (IOException ioex) {
            DBError.throwSQLException(6001);
        }
        if (!recvMsg.checkCRC()) {
            DBError.throwSQLException(6002);
        }
        if ((sqlcode = recvMsg.getSQLCODE()) < 0) {
            String errInfo = recvMsg.getErrorInfo(this._$712.getServerEncoding());
            DBError.throwSQLException(errInfo, sqlcode);
        }
    }

    private int[] _$1310(DmMsg recv) throws SQLException {
        int sqlcode;
        int[] rowCounts = null;
        if (!recv.checkCRC()) {
            DBError.throwSQLException(6002);
        }
        if ((sqlcode = recv.getSQLCODE()) < 0) {
            String errInfo = recv.getErrorInfo(this._$712.getServerEncoding());
            DBError.throwSQLException(errInfo, sqlcode);
        }
        int offset = 64;
        for (int i = 0; i < 5; ++i) {
            int len = recv.getInt(offset);
            offset += 4;
            offset += len;
        }
        int msgLen = recv.getLength();
        if (offset < msgLen + 64) {
            int counts = recv.getInt(offset);
            offset += 4;
            rowCounts = new int[counts];
            for (int i = 0; i < counts; ++i) {
                rowCounts[i] = (int)recv.getLong(offset);
                offset += 8;
            }
        }
        return rowCounts;
    }

    byte[] createLobHead(byte[] value) {
        byte[] lobValue = new byte[value.length + 5];
        lobValue[0] = 1;
        Convertion.setInt(lobValue, 1, value.length);
        System.arraycopy(value, 0, lobValue, 5, value.length);
        return lobValue;
    }

    public final synchronized long getRowCount(DmdbStatement stmt) throws SQLException {
        int sqlcode;
        DmMsg recvMsg = null;
        this._$1052.setStmtId(stmt.handle);
        this._$1052.setCmd(28);
        this._$1052.setLength(0);
        try {
            this._$272.send(this._$1052);
            recvMsg = this._$272.readPacket();
        }
        catch (IOException ioex) {
            DBError.throwSQLException(6001);
        }
        if (!recvMsg.checkCRC()) {
            DBError.throwSQLException(6002);
        }
        if ((sqlcode = recvMsg.getSQLCODE()) < 0) {
            String errInfo = recvMsg.getErrorInfo(this._$712.getServerEncoding());
            DBError.throwSQLException(errInfo, sqlcode);
        }
        return recvMsg.getRowCount();
    }
}

