/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.dbaccess.DBError;
import dm.jdbc.driver.DmdbCallableStatement;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.driver.DmdbInputStream;
import dm.jdbc.driver.DmdbLob;
import dm.jdbc.driver.DmdbOutputStream;
import dm.jdbc.driver.DmdbReader;
import dm.jdbc.driver.DmdbStatement;
import dm.jdbc.util.Comparison;
import dm.jdbc.util.Convertion;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.sql.Blob;
import java.sql.SQLException;

public class DmdbBlob
extends DmdbLob
implements Blob {
    public DmdbBlob(DmdbStatement statement, int colIndex, long curPos) throws SQLException {
        super(statement, colIndex, curPos);
    }

    protected DmdbBlob(DmdbCallableStatement cstmt, int colIndex, byte[] value) throws SQLException {
        super(cstmt, colIndex, value);
    }

    protected DmdbBlob(byte[] bs) throws SQLException {
        super(bs);
    }

    public long length() throws SQLException {
        if (this.statement != null) {
            if (this.statement.lob_mode == 2) {
                long len = this.value.length - 5;
                if (len < 0L) {
                    DBError.throwSQLException(6057);
                }
                return len;
            }
        } else if (DmdbConnection.lob_mode == 2) {
            long len = this.value.length - 5;
            if (len < 0L) {
                DBError.throwSQLException(6057);
            }
            return len;
        }
        if (this.fromRowSetFlag || !this.statement.dbInfo.getUpdatable() || this.statement.dbInfo.getUpdatable() && !this.isUpdated) {
            return this.getLobLen();
        }
        long len = this.statement.m_csi.lob_get_len(this.statement.handle, this.curPos, this.dbid, this.tabid, this.rowid_high, this.rowid_low, this.colid, 58);
        if (len < 0L) {
            DBError.throwSQLException(6057);
        }
        return len;
    }

    public byte[] getBytes(long pos, int length) throws SQLException {
        if (pos <= 0L || length < 0) {
            DBError.throwSQLException(6057);
        }
        byte[] tmpBuf = null;
        byte[] buf = new byte[length];
        if (this.statement != null) {
            if (this.statement.lob_mode == 2) {
                if (pos > (long)(this.value.length - 5)) {
                    return null;
                }
                if ((long)(this.value.length - 5) - pos + 1L < (long)length) {
                    buf = new byte[(int)((long)(this.value.length - 5) - pos + 1L)];
                }
                System.arraycopy(this.value, (int)pos - 1 + 5, buf, 0, buf.length);
                return buf;
            }
        } else if (DmdbConnection.lob_mode == 2) {
            if (pos > (long)(this.value.length - 5)) {
                return null;
            }
            if ((long)(this.value.length - 5) - pos + 1L < (long)length) {
                buf = new byte[(int)((long)(this.value.length - 5) - pos + 1L)];
            }
            System.arraycopy(this.value, (int)pos - 1 + 5, buf, 0, buf.length);
            return buf;
        }
        if (this.isValueInRow() && (this.fromRowSetFlag || !this.statement.dbInfo.getUpdatable() || this.statement.dbInfo.getUpdatable() && !this.isUpdated)) {
            byte[] val = this.getValueInRow();
            if (pos > (long)val.length) {
                return null;
            }
            if ((long)val.length - pos + 1L < (long)length) {
                buf = new byte[(int)((long)val.length - pos + 1L)];
            }
            System.arraycopy(val, (int)pos - 1, buf, 0, buf.length);
            return buf;
        }
        if (this.fromRowSetFlag) {
            return null;
        }
        int len = length > 16000 ? 16000 : length;
        int position = (int)pos;
        int bytesGet = 0;
        while ((tmpBuf = !this.statement.dbInfo.getUpdatable() ? this.statement.m_csi.blob_get_bytes(this.statement.handle, -1L, this.dbid, this.tabid, this.rowid_high, this.rowid_low, this.colid, position, len) : this.statement.m_csi.blob_get_bytes(this.statement.handle, this.curPos, this.dbid, this.tabid, this.rowid_high, this.rowid_low, this.colid, position, len)) != null) {
            System.arraycopy(tmpBuf, 0, buf, bytesGet, tmpBuf.length);
            position += tmpBuf.length;
            len = length - (bytesGet += tmpBuf.length);
            if (len <= 0) break;
            if (len <= 16000) continue;
            len = 16000;
        }
        if (bytesGet == length) {
            return buf;
        }
        byte[] tmpVal = new byte[bytesGet];
        System.arraycopy(buf, 0, tmpVal, 0, bytesGet);
        return tmpVal;
    }

    public InputStream getBinaryStream() throws SQLException {
        return new DmdbInputStream(this, this.fromRowSetFlag, null);
    }

    public long position(byte[] pattern, long start) throws SQLException {
        int length;
        if (this.fromRowSetFlag || start < 1L) {
            DBError.throwSQLException(6057);
        }
        if ((long)pattern.length > (long)(length = (int)this.length()) - start + 1L) {
            return -1L;
        }
        byte[] bs = this.getBytes(start, length);
        long ret = Comparison.getIndexOfByteArray(pattern, bs);
        if (ret >= 0L) {
            ++ret;
        }
        return ret;
    }

    public long position(Blob pattern, long start) throws SQLException {
        if (this.fromRowSetFlag || pattern == null) {
            return -1L;
        }
        if (start < 1L) {
            DBError.throwSQLException(6057);
        }
        int length = (int)this.length();
        if (pattern.length() > (long)length - start + 1L) {
            return -1L;
        }
        byte[] bytes = pattern.getBytes(1L, (int)pattern.length());
        return this.position(bytes, start);
    }

    public int setBytes(long pos, byte[] bytes) throws SQLException {
        return this.setBytes(pos, bytes, 0, bytes.length);
    }

    public int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
        if (pos <= 0L || len < 0 || offset < 0) {
            DBError.throwSQLException(6057);
        }
        if (!this.fromRowSetFlag && !this.statement.dbInfo.getUpdatable()) {
            DBError.throwSQLException(6029);
        }
        if (offset < 0) {
            throw new IndexOutOfBoundsException(new Integer(offset).toString());
        }
        if (len < 0) {
            throw new IndexOutOfBoundsException(new Integer(len).toString());
        }
        if (offset + len > bytes.length) {
            throw new IndexOutOfBoundsException(new Integer(offset + len).toString());
        }
        if (this.statement != null) {
            if (this.statement.lob_mode == 2) {
                System.arraycopy(bytes, offset, this.value, (int)pos - 1 + 5, len);
                return len;
            }
        } else if (DmdbConnection.lob_mode == 2) {
            System.arraycopy(bytes, offset, this.value, (int)pos - 1 + 5, len);
            return len;
        }
        if (!this.fromRowSetFlag && !this.statement.dbInfo.getUpdatable()) {
            DBError.throwSQLException(6029);
        }
        if (this.fromRowSetFlag) {
            if ((long)len + pos - 1L > 1024L) {
                DBError.throwSQLException(6057);
            }
            byte[] bs = new byte[(int)pos + len - 1 + 5];
            byte[] tmpbs = Convertion.IntToByteArray((int)pos + len - 1);
            bs[0] = 1;
            System.arraycopy(tmpbs, 0, bs, 1, 4);
            System.arraycopy(bytes, offset, bs, 5 + (int)pos - 1, len);
            this.value = bs;
            this.statement = null;
            return len;
        }
        int position = (int)pos;
        int off = offset;
        int length = len > 16000 ? 16000 : len;
        int count = len / 16000 + 1;
        int ret = 0;
        for (int i = 0; i < count; ++i) {
            int tmp = this.statement.m_csi.blob_set_bytes(this.statement.handle, this.curPos, this.dbid, this.tabid, this.rowid_high, this.rowid_low, this.colid, position, bytes, off, length);
            if (tmp <= 0) {
                return ret;
            }
            ret += tmp;
            position += length;
            off += length;
            length = i == count - 2 ? len - (i + 1) * 16000 : 16000;
        }
        this.isUpdated = true;
        return ret;
    }

    public OutputStream setBinaryStream(long pos) throws SQLException {
        if (this.statement != null && this.statement.connection.getComOra() && pos == 0L) {
            pos = 1L;
        }
        if (pos <= 0L) {
            DBError.throwSQLException(6057);
        }
        return new DmdbOutputStream(this, pos);
    }

    public void truncate(long len) throws SQLException {
        if (len < 0L) {
            DBError.throwSQLException(6057);
        }
        if (this.statement != null) {
            if (this.statement.lob_mode == 2) {
                byte[] tmp = new byte[(int)len + 5];
                System.arraycopy(this.value, 0, tmp, 0, (int)len + 5);
                this.value = tmp;
                this.isUpdated = true;
                return;
            }
        } else if (DmdbConnection.lob_mode == 2) {
            byte[] tmp = new byte[(int)len + 5];
            System.arraycopy(this.value, 0, tmp, 0, (int)len + 5);
            this.value = tmp;
            this.isUpdated = true;
            return;
        }
        if (this.fromRowSetFlag || !this.statement.dbInfo.getUpdatable()) {
            DBError.throwSQLException(6029);
        }
        this.statement.m_csi.blob_text_truncate(this.statement.handle, this.curPos, this.dbid, this.tabid, this.rowid_high, this.rowid_low, this.colid, (int)len, 56);
        this.isUpdated = true;
    }

    public Reader getCharacterStream() throws SQLException {
        return new DmdbReader(this);
    }
}

