/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.byacc.Parser;
import dm.jdbc.dbaccess.Const;
import dm.jdbc.driver.DmdbConnection;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

public class DmDriver
implements Driver {
    public static Parser parser = new Parser();
    private final ResourceBundle _$306 = Const.res;

    public Connection connect(String url, Properties info) throws SQLException {
        Properties props = null;
        props = this.parseURL(url, info);
        if (props == null) {
            return null;
        }
        String host = props.getProperty("host", "localhost");
        String port = props.getProperty("port", String.valueOf(12345));
        String database = props.getProperty("dbName", "");
        String user = props.getProperty("user", "SYSDBA");
        String passwd = props.getProperty("password", "");
        DmdbConnection conn = new DmdbConnection(url, host, port, user, passwd, database, props);
        return conn;
    }

    public boolean acceptsURL(String url) throws SQLException {
        return this.parseURL(url, null) != null;
    }

    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        info = this.parseURL(url, info);
        DriverPropertyInfo hostProp = new DriverPropertyInfo("HOST", info.getProperty("HOST"));
        hostProp.required = true;
        hostProp.description = this._$306.getString("description.host");
        DriverPropertyInfo portProp = new DriverPropertyInfo("PORT", info.getProperty("PORT", String.valueOf(12345)));
        portProp.required = false;
        portProp.description = this._$306.getString("desciption.port");
        DriverPropertyInfo dbProp = new DriverPropertyInfo("DBNAME", info.getProperty("DBNAME"));
        dbProp.required = false;
        dbProp.description = this._$306.getString("desciption.dbname");
        DriverPropertyInfo encodingProp = new DriverPropertyInfo("ENCODING", info.getProperty("ENCODING"));
        encodingProp.required = false;
        encodingProp.description = this._$306.getString("desciption.encoding");
        DriverPropertyInfo userProp = new DriverPropertyInfo("user", info.getProperty("user"));
        userProp.required = true;
        userProp.description = this._$306.getString("desciption.user");
        DriverPropertyInfo passwordProp = new DriverPropertyInfo("password", info.getProperty("password"));
        passwordProp.required = true;
        passwordProp.description = this._$306.getString("desciption.pwd");
        DriverPropertyInfo autoReconnect = new DriverPropertyInfo("autoReconnect", info.getProperty("autoReconnect", "false"));
        autoReconnect.required = false;
        autoReconnect.choices = new String[]{"true", "false"};
        autoReconnect.description = this._$306.getString("desciption.Reconnect.auto");
        DriverPropertyInfo maxReconnects = new DriverPropertyInfo("maxReconnects", info.getProperty("maxReconnects", "3"));
        maxReconnects.required = false;
        maxReconnects.description = this._$306.getString("desciption.Reconnect.max");
        DriverPropertyInfo initialTimeout = new DriverPropertyInfo("initialTimeout", info.getProperty("initialTimeout", "2"));
        initialTimeout.required = false;
        initialTimeout.description = this._$306.getString("desciption.time.reconnect");
        DriverPropertyInfo socketTimeout = new DriverPropertyInfo("socketTimeout", info.getProperty("socketTimeout", "0"));
        socketTimeout.required = false;
        socketTimeout.description = this._$306.getString("desciption.time.socket");
        DriverPropertyInfo connectTimeout = new DriverPropertyInfo("connectTimeout", info.getProperty("connectTimeout", "0"));
        connectTimeout.required = false;
        connectTimeout.description = this._$306.getString("desciption.time.connect");
        DriverPropertyInfo secondsBeforeRetryMaster = new DriverPropertyInfo("secondsBeforeRetryMaster", info.getProperty("secondsBeforeRetryMaster", "30"));
        secondsBeforeRetryMaster.required = false;
        secondsBeforeRetryMaster.description = this._$306.getString("desciption.time.ReconnectSpace");
        DriverPropertyInfo continueBatchOnError = new DriverPropertyInfo("continueBatchOnError", info.getProperty("continueBatchOnError", "true"));
        continueBatchOnError.required = false;
        continueBatchOnError.description = this._$306.getString("desciption.execute.continue");
        DriverPropertyInfo escapeProcess = new DriverPropertyInfo("escapeProcess", info.getProperty("escapeProcess", "true"));
        escapeProcess.required = false;
        escapeProcess.description = this._$306.getString("desciption.esscape.process");
        DriverPropertyInfo autoCommit = new DriverPropertyInfo("autoCommit", info.getProperty("autoCommit", "true"));
        autoCommit.required = false;
        autoCommit.description = this._$306.getString("desciption.commit.auto");
        DriverPropertyInfo maxRows = new DriverPropertyInfo("MaxRows", info.getProperty("MaxRows", "0"));
        maxRows.required = false;
        maxRows.description = this._$306.getString("desciption.rows.max");
        DriverPropertyInfo RowPrefetch = new DriverPropertyInfo("RowPrefetch", info.getProperty("RowPrefetch", "10"));
        RowPrefetch.required = false;
        RowPrefetch.description = this._$306.getString("desciption.fetch.rowNum");
        DriverPropertyInfo SSLFactory = new DriverPropertyInfo("SSLFactory", info.getProperty("SSLFactory", "default"));
        SSLFactory.required = false;
        SSLFactory.description = "SSLFactory\u7684\u7c7b\u540d\u79f0";
        DriverPropertyInfo SSLFactoryArgs = new DriverPropertyInfo("SSLFactoryArgs", info.getProperty("SSLFactoryArgs", "default"));
        SSLFactoryArgs.required = false;
        SSLFactoryArgs.description = "SSLFactory\u7684\u53c2\u6570\u5217\u8868";
        DriverPropertyInfo LobMode = new DriverPropertyInfo("LobMode", info.getProperty("LobMode", "1"));
        LobMode.required = false;
        LobMode.description = this._$306.getString("desciption.lob.mode");
        DriverPropertyInfo StmtPoolSize = new DriverPropertyInfo("StmtPoolSize", info.getProperty("StmtPoolSize", "0"));
        StmtPoolSize.required = false;
        StmtPoolSize.description = this._$306.getString("desciption.stmtPool.size");
        DriverPropertyInfo ignoreCase = new DriverPropertyInfo("ignoreCase", info.getProperty("ignoreCase", "false"));
        ignoreCase.required = false;
        ignoreCase.description = this._$306.getString("ignore column name case");
        DriverPropertyInfo comOra = new DriverPropertyInfo("comOra", info.getProperty("comOra", "false"));
        ignoreCase.required = false;
        ignoreCase.description = this._$306.getString("compatible with oracle");
        DriverPropertyInfo canConnStandby = new DriverPropertyInfo("canConnStandby", info.getProperty("canConnStandby", "false"));
        ignoreCase.required = false;
        ignoreCase.description = this._$306.getString("if can connect to stand by server");
        DriverPropertyInfo infoLevel = new DriverPropertyInfo("infoLevel", info.getProperty("infoLevel", "1"));
        ignoreCase.required = false;
        ignoreCase.description = this._$306.getString("if not throw statement exception");
        DriverPropertyInfo alwayseAllowCommit = new DriverPropertyInfo("alwayseAllowCommit", info.getProperty("alwayseAllowCommit", "true"));
        ignoreCase.required = false;
        ignoreCase.description = this._$306.getString("Allow commit even if autocommit is true");
        DriverPropertyInfo batchType = new DriverPropertyInfo("batchType", info.getProperty("batchType", "1"));
        ignoreCase.required = false;
        ignoreCase.description = this._$306.getString("");
        DriverPropertyInfo maxCachedPstmtSize = new DriverPropertyInfo("maxCachedPstmtSize", info.getProperty("maxCachedPstmtSize", "0"));
        ignoreCase.required = false;
        ignoreCase.description = this._$306.getString("");
        DriverPropertyInfo[] dpi = new DriverPropertyInfo[]{hostProp, portProp, dbProp, encodingProp, userProp, passwordProp, autoReconnect, maxReconnects, initialTimeout, socketTimeout, connectTimeout, secondsBeforeRetryMaster, escapeProcess, continueBatchOnError, maxRows, autoCommit, RowPrefetch, SSLFactory, SSLFactoryArgs, LobMode, StmtPoolSize, ignoreCase, comOra, canConnStandby, infoLevel, alwayseAllowCommit, batchType, maxCachedPstmtSize};
        return dpi;
    }

    public int getMajorVersion() {
        return 3;
    }

    public int getMinorVersion() {
        return 0;
    }

    public boolean jdbcCompliant() {
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Properties parseURL(String url, Properties defaults) {
        StringTokenizer st;
        Properties urlProps = new Properties(defaults);
        if (url == null) {
            return null;
        }
        int index = url.indexOf("?");
        if (index != -1) {
            String paramString = url.substring(index + 1, url.length());
            url = url.substring(0, index);
            StringTokenizer queryParams = new StringTokenizer(paramString, "&");
            while (queryParams.hasMoreTokens()) {
                StringTokenizer vp = new StringTokenizer(queryParams.nextToken(), "=");
                String param = "";
                if (vp.hasMoreTokens()) {
                    param = vp.nextToken();
                }
                String value = "";
                if (vp.hasMoreTokens()) {
                    value = vp.nextToken();
                }
                if (value.length() <= 0 || param.length() <= 0) continue;
                ((Hashtable)urlProps).put(param.trim(), value.trim());
            }
        }
        if (!(st = new StringTokenizer(url, ":/", true)).hasMoreTokens()) return null;
        String protocol = st.nextToken();
        if (protocol == null) return null;
        if (!protocol.equalsIgnoreCase("jdbc")) {
            return null;
        }
        if (!st.hasMoreTokens()) return null;
        String colon = st.nextToken();
        if (colon == null) return null;
        if (!colon.equals(":")) {
            return null;
        }
        if (!st.hasMoreTokens()) return null;
        String subProto = st.nextToken();
        if (subProto == null) return null;
        if (!subProto.equalsIgnoreCase("dm")) {
            return null;
        }
        if (!st.hasMoreTokens()) return null;
        colon = st.nextToken();
        if (colon == null) return null;
        if (!colon.equals(":")) {
            return null;
        }
        if (!st.hasMoreTokens()) return null;
        String slash = st.nextToken();
        String slash2 = "";
        if (st.hasMoreTokens()) {
            slash2 = st.nextToken();
        }
        if (slash == null || slash2 == null) return null;
        if (!slash.equals("/") || !slash2.equals("/")) {
            return null;
        }
        if (!st.hasMoreTokens()) return urlProps;
        String token = st.nextToken();
        if (token == null) return null;
        if (!token.equals(":") && !token.equals("/")) {
            ((Hashtable)urlProps).put("host", token.trim());
            if (st.hasMoreTokens()) {
                token = st.nextToken();
            } else {
                ((Hashtable)urlProps).put("port", "12345");
                return urlProps;
            }
        }
        if (token.equals(":") && st.hasMoreTokens()) {
            token = st.nextToken();
            ((Hashtable)urlProps).put("port", token.trim());
            if (st.hasMoreTokens()) {
                token = st.nextToken();
            }
        }
        if (token.equals("/")) {
            if (st.hasMoreTokens()) {
                token = st.nextToken();
                ((Hashtable)urlProps).put("dbName", token.trim());
                if (!st.hasMoreTokens()) return urlProps;
                return null;
            }
            ((Hashtable)urlProps).put("dbName", "");
            return urlProps;
        }
        if (!st.hasMoreTokens()) return urlProps;
        return null;
    }

    static {
        try {
            DriverManager.registerDriver(new DmDriver());
            parser.parser_init();
            parser.initParser();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

