/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.dbaccess;

import dm.jdbc.dbaccess.Const;
import dm.jdbc.dbaccess.SocketFactory;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.Socket;
import java.net.SocketException;
import java.util.ResourceBundle;

public class StandardSocketFactory
implements SocketFactory {
    protected Socket rawSocket = null;
    protected String host = null;
    protected int port = 0;
    protected int connectTimeout = 0;
    private final ResourceBundle _$306 = Const.res;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$net$Socket;

    public Socket afterHandshake() throws SocketException, IOException {
        return this.rawSocket;
    }

    public Socket beforeHandshake() throws SocketException, IOException {
        return this.rawSocket;
    }

    public Socket connect(String hostStr, String portStr, int timeout) throws SocketException, IOException {
        this.host = hostStr;
        if (portStr != null) {
            this.port = Integer.parseInt(portStr);
        }
        boolean hasConnectTimeoutMethod = false;
        Method connectWithTimeoutMethod = null;
        try {
            Class<?> socketAddressClass = Class.forName("java.net.SocketAddress");
            connectWithTimeoutMethod = (class$java$net$Socket == null ? (class$java$net$Socket = StandardSocketFactory.class$("java.net.Socket")) : class$java$net$Socket).getMethod("connect", socketAddressClass, Integer.TYPE);
            hasConnectTimeoutMethod = true;
        }
        catch (NoClassDefFoundError noClassDefFound) {
            hasConnectTimeoutMethod = false;
        }
        catch (NoSuchMethodException noSuchMethodEx) {
            hasConnectTimeoutMethod = false;
        }
        catch (Throwable catchAll) {
            hasConnectTimeoutMethod = false;
        }
        this.connectTimeout = timeout;
        if (this.host != null) {
            if (!hasConnectTimeoutMethod || this.connectTimeout == 0) {
                this.rawSocket = new Socket(this.host, this.port);
            } else {
                try {
                    Class<?> inetSocketAddressClass = Class.forName("java.net.InetSocketAddress");
                    Constructor<?> addrConstructor = inetSocketAddressClass.getConstructor(class$java$lang$String == null ? (class$java$lang$String = StandardSocketFactory.class$("java.lang.String")) : class$java$lang$String, Integer.TYPE);
                    Object sockAddr = addrConstructor.newInstance(this.host, new Integer(this.port));
                    this.rawSocket = new Socket();
                    connectWithTimeoutMethod.invoke((Object)this.rawSocket, sockAddr, new Integer(this.connectTimeout));
                }
                catch (Throwable t2) {
                    throw new SocketException(t2.toString());
                }
            }
            try {
                this.rawSocket.setTcpNoDelay(true);
            }
            catch (Exception ex) {
                // empty catch block
            }
            return this.rawSocket;
        }
        throw new SocketException(this._$306.getString("error.socket.create"));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

