/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.dbaccess;

import dm.jdbc.dbaccess.SymmCipherDesc;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import javax.crypto.Cipher;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public final class MsgSecurity {
    private static final byte[] _$12619 = new byte[]{32, 33, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 32};
    private static final String _$12620 = "C009D877BAF5FAF416B7F778E6115DCB90D65217DCC2F08A9DFCB5A192C593EBAB02929266B8DBFC2021039FDBD4B7FDE2B996E00008F57AE6EFB4ED3F17B6D3";
    private static final String _$12621 = "5";
    private static DHParameterSpec _$12622 = null;
    private static KeyPairGenerator _$12623 = null;
    private static BigInteger _$5274 = null;
    private static BigInteger _$9309 = null;

    private static IvParameterSpec _$9332(int ivLength) {
        if (-1 == ivLength) {
            return new IvParameterSpec(new byte[0]);
        }
        byte[] iv = new byte[ivLength];
        System.arraycopy(_$12619, 0, iv, 0, ivLength);
        IvParameterSpec algParams = new IvParameterSpec(iv);
        return algParams;
    }

    private static BigInteger _$12627(byte[] bnBytesSrc) {
        byte[] bnBytesTo = null;
        if (null == bnBytesSrc) {
            return null;
        }
        if (0 == bnBytesSrc[0]) {
            return new BigInteger(bnBytesSrc);
        }
        int validBytesCount = bnBytesSrc.length + 1;
        bnBytesTo = new byte[validBytesCount];
        bnBytesTo[0] = 0;
        System.arraycopy(bnBytesSrc, 0, bnBytesTo, 1, validBytesCount - 1);
        return new BigInteger(bnBytesTo);
    }

    protected static byte[] bn2Bytes(BigInteger bn) {
        byte[] bnBytesSrc = null;
        byte[] bnBytesTemp = null;
        byte[] bnBytesTo = null;
        int validBytesCount = 0;
        if (null == bn) {
            return null;
        }
        bnBytesSrc = bn.toByteArray();
        if (0 != bnBytesSrc[0]) {
            bnBytesTemp = bnBytesSrc;
            validBytesCount = bnBytesTemp.length;
        } else {
            validBytesCount = bnBytesSrc.length - 1;
            bnBytesTemp = new byte[validBytesCount];
            System.arraycopy(bnBytesSrc, 1, bnBytesTemp, 0, validBytesCount);
        }
        if (64 > validBytesCount) {
            int i = 0;
            bnBytesTo = new byte[64];
            for (i = 0; i < 64 - validBytesCount; ++i) {
                bnBytesTo[i] = 0;
            }
            System.arraycopy(bnBytesTemp, 0, bnBytesTo, i, validBytesCount);
        } else {
            bnBytesTo = bnBytesTemp;
        }
        return bnBytesTo;
    }

    protected static KeyPair newClientKeyPair() {
        if (null == _$12623) {
            _$5274 = new BigInteger(_$12620, 16);
            _$9309 = new BigInteger(_$12621, 16);
            _$12622 = new DHParameterSpec(_$5274, _$9309, 512);
            try {
                _$12623 = KeyPairGenerator.getInstance("DH");
                _$12623.initialize(_$12622);
            }
            catch (NoSuchAlgorithmException e) {
                _$12623 = null;
            }
            catch (InvalidAlgorithmParameterException e) {
                _$12623 = null;
            }
        }
        if (null == _$12623) {
            return null;
        }
        KeyPair clientKeyPair = _$12623.generateKeyPair();
        return clientKeyPair;
    }

    protected static byte[] computeSessionKey(PrivateKey clientPrivKey, byte[] serverPubKey) {
        BigInteger serverKeyX = MsgSecurity._$12627(serverPubKey);
        BigInteger clientPrivKeyX = ((DHPrivateKey)clientPrivKey).getX();
        BigInteger sessinoKeyBN = serverKeyX.modPow(clientPrivKeyX, _$5274);
        return MsgSecurity.bn2Bytes(sessinoKeyBN);
    }

    protected static Cipher newCipher(int cipherMode, SymmCipherDesc cipherDesc, byte[] sessionKey) throws Exception {
        Cipher encrypt_cipher = null;
        encrypt_cipher = Cipher.getInstance(cipherDesc.getAlgorithmFullName());
        SecretKeySpec keySpec = new SecretKeySpec(sessionKey, cipherDesc.getAlgorithmName());
        if (1 == cipherDesc.getWork_mode() || 4096 == cipherDesc.getAlgorithmType()) {
            encrypt_cipher.init(cipherMode, keySpec);
        } else {
            encrypt_cipher.init(cipherMode, (Key)keySpec, MsgSecurity._$9332(cipherDesc.getIvLength()));
        }
        return encrypt_cipher;
    }
}

