/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.dbaccess;

import dm.jdbc.util.Convertion;

public class DmMsg {
    byte[] buffer = null;
    byte[] varBuffer = new byte[32768];

    public DmMsg() {
        this.buffer = this.varBuffer;
    }

    public void setBuffer(byte[] buf) {
        if (buf == null) {
            return;
        }
        if (buf.length > 32768) {
            this.varBuffer = buf;
        } else {
            this.varBuffer = new byte[32768];
            System.arraycopy(buf, 0, this.varBuffer, 0, buf.length);
        }
        this.buffer = this.varBuffer;
    }

    public void setBuffer(int size) {
        if (size > 32768) {
            this.varBuffer = new byte[size];
            System.arraycopy(this.buffer, 0, this.varBuffer, 0, this.buffer.length);
        } else {
            this.varBuffer = new byte[32768];
        }
        this.buffer = this.varBuffer;
    }

    public final int getBufLength() {
        return this.buffer.length;
    }

    private final long _$333(int size, int offset) {
        long n = 0L;
        int p = offset + size;
        for (int i = 0; i < size; ++i) {
            long b = 0xFF & this.buffer[--p];
            n = b | n << 8;
        }
        return n;
    }

    public final byte getByte(int offset) {
        return this.buffer[offset];
    }

    public final short getShort(int offset) {
        int b = 0xFF & this.buffer[offset];
        int n = 0xFF & this.buffer[++offset];
        n = b | n << 8;
        return (short)(0xFFFF & n);
    }

    public final int getInt(int offset) {
        int size = 4;
        int p = offset + size;
        long n = 0xFF & this.buffer[--p];
        long b = 0xFF & this.buffer[--p];
        n = b | n << 8;
        b = 0xFF & this.buffer[--p];
        n = b | n << 8;
        b = 0xFF & this.buffer[--p];
        n = b | n << 8;
        return (int)(0xFFFFFFFFFFFFFFFFL & n);
    }

    public final long getLong(int offset) {
        long l = this._$333(8, offset);
        return l;
    }

    public final String getString(int offset, int bytelen) {
        return Convertion.getString(this.buffer, offset, bytelen);
    }

    public final String getString(int offset, int byteLen, String charsetName) {
        return Convertion.getString(this.buffer, offset, byteLen, charsetName);
    }

    public final void setString(String str, int offset) {
        Convertion.setString(this.buffer, str, offset);
    }

    public final void setStringWithNTS(byte[] buf, int offset) {
        this.buffer = Convertion.setStringWithNTS(this.buffer, offset, buf);
    }

    public final byte[] getBytes(int offset, int len) {
        return Convertion.getBytes(this.buffer, offset, len);
    }

    public final byte[] getBytes(int offset, int len, String charsetName, String destCharsetName) {
        return Convertion.getBytes(this.buffer, offset, len, charsetName, destCharsetName);
    }

    private final void _$484(long val, int size, int offset) {
        int p = offset;
        while (size-- > 0) {
            this.buffer[p++] = (byte)(val & 0xFFL);
            val >>= 8;
        }
    }

    public final byte[] longToBytes(long val) {
        byte[] bs = new byte[8];
        int i = 0;
        int size = bs.length;
        while (size-- > 0) {
            bs[i++] = (byte)(val & 0xFFL);
            val >>= 8;
        }
        return bs;
    }

    public final void setByte(int val, int offset) {
        this.buffer[offset] = (byte)(val & 0xFF);
    }

    public final void setBytes(byte[] src, int src_offset, int offset, int len) {
        System.arraycopy(src, src_offset, this.buffer, offset, len);
    }

    public final void setShort(int val, int offset) {
        this.buffer[offset] = (byte)(val & 0xFF);
        this.buffer[++offset] = (byte)((val >>= 8) & 0xFF);
    }

    public final void setInt(int val, int offset) {
        this.buffer[offset++] = (byte)(val & 0xFF);
        this.buffer[offset++] = (byte)((val >>= 8) & 0xFF);
        this.buffer[offset++] = (byte)((val >>= 8) & 0xFF);
        this.buffer[offset++] = (byte)((val >>= 8) & 0xFF);
        val >>= 8;
    }

    public final void setLong(long val, int offset) {
        this._$484(val, 8, offset);
    }

    public final void setStmtId(int id) {
        this.setInt(id, 0);
    }

    public final int getStmtId() {
        return this.getInt(0);
    }

    public final void setCmd(int cmd) {
        this.setShort(cmd, 4);
        for (int i = 0; i < 25; ++i) {
            this.buffer[39 + i] = 0;
        }
    }

    public final short getCmd() {
        short cmd = (short)(this.getShort(4) & 0xFFF);
        cmd = (short)(cmd & 0xFFFFF7FF);
        return cmd;
    }

    public final void setLength(int length) {
        this.setInt(length, 6);
    }

    public final int getLength() {
        return this.getInt(6);
    }

    public final short getColumnCount() {
        return this.getShort(10);
    }

    public final short getParamCount() {
        return this.getShort(12);
    }

    public final long getRowCount() {
        return this.getLong(14);
    }

    public final void setRowCount(long count) {
        this.setLong(count, 14);
    }

    public final void setLoginFlag(int flag) {
        this.setInt(flag, 322);
    }

    public final void setExecDirect(boolean b) {
        this.setInt(b ? 1 : 0, 26);
    }

    public final int getOffsetOfPrintMsg() {
        return this.getInt(26);
    }

    public final byte[] getCurPos() {
        return Convertion.getBytes(this.buffer, 30, 8);
    }

    public final int getFetchedRow() {
        return this.getInt(30);
    }

    public final int getResultSetOffSet() {
        return this.getShort(34);
    }

    public final short getFetchOver() {
        return this.getShort(36);
    }

    public final void setCurPos(long pos) {
        this.setLong(pos, 30);
    }

    public final void setCRC(byte crc) {
        this.setByte(crc, 38);
    }

    public final int getMsgBodyLen() {
        return this.getInt(64);
    }

    public final int getSQLCODE() {
        return this.getInt(22);
    }

    public final void setSQLCODE(int sqlcode) {
        this.setInt(sqlcode, 22);
    }

    public final byte getCRC() {
        return this.getByte(38);
    }

    public final byte calculateCRC() {
        byte crc = this.buffer[0];
        int times = 38;
        byte single = this.buffer[1];
        for (int i = 1; i < times; i = (int)((byte)(i + 1))) {
            single = this.buffer[i];
            crc = (byte)(crc ^ single);
        }
        return crc;
    }

    public final boolean checkCRC() {
        byte calc;
        byte recv = this.getCRC();
        return recv == (calc = this.calculateCRC());
    }

    public final String getErrorMsg(String serverEncoding) {
        int len = this.getMsgBodyLen();
        int offset = 64;
        int catalogLen = this.getInt(offset);
        int schemaLen = this.getInt(offset += 4 + catalogLen);
        int tableLen = this.getInt(offset += 4 + schemaLen);
        int columnLen = this.getInt(offset += 4 + tableLen);
        int errorLen = this.getInt(offset += 4 + columnLen);
        int truncLen = Math.min(Math.min(len, errorLen), 512);
        return Convertion.getString(this.buffer, offset + 4, truncLen, serverEncoding);
    }

    public boolean getUnname(int offset) {
        return this.getInt(offset + 18) != 0;
    }

    public short getParamType(int offset) {
        return this.getShort(offset + 22);
    }

    public boolean getNullable(int offset) {
        return this.getInt(offset + 12) != 0;
    }

    public short getItemFlag(int offset) {
        return this.getShort(offset + 16);
    }

    public int getFixSize(int offset) {
        return this.getInt(offset + 34);
    }

    public short getNameLen(int offset) {
        return this.getShort(offset + 24);
    }

    public short getTypeNameLen(int offset) {
        return this.getShort(offset + 26);
    }

    public short getTableLen(int offset) {
        return this.getShort(offset + 28);
    }

    public short getSchemaLen(int offset) {
        return this.getShort(offset + 30);
    }

    public short getCatalogLen(int offset) {
        return this.getShort(offset + 32);
    }

    public int getdType(int offset) {
        return this.getInt(offset + 0);
    }

    public int getPrec(int offset) {
        return this.getInt(offset + 4);
    }

    public int getScale(int offset) {
        return this.getInt(offset + 8);
    }

    public void setParamDataLength(int len, int offset) {
        this.setInt(len, offset);
    }

    public void setParamData(int offset, byte[] data) {
        this.setBytes(data, 0, offset, data.length);
    }

    public void setParamNum(int num) {
        this.setShort(num, 12);
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    public String getErrorInfo(String charsetName) {
        int offset = 64;
        int len = this.getInt(offset);
        offset += 4;
        offset += len;
        len = this.getInt(offset);
        offset += 4;
        offset += len;
        len = this.getInt(offset);
        offset += 4;
        offset += len;
        len = this.getInt(offset);
        offset += 4;
        offset += len;
        len = this.getInt(offset);
        return Convertion.getString(this.buffer, offset += 4, len, charsetName);
    }

    public short getEncryptType() {
        return (short)(this.getShort(4) & 0xFFFFF000);
    }

    public void setEncryptType(short type) {
        this.setShort((short)(this.getShort(4) | type), 4);
    }
}

