/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.dbaccess;

import dm.jdbc.dbaccess.Auth;
import dm.jdbc.dbaccess.AuthInfo;
import dm.jdbc.dbaccess.DBError;
import dm.jdbc.dbaccess.DmMsg;
import dm.jdbc.dbaccess.MsgSecurity;
import dm.jdbc.dbaccess.SymmCipherDesc;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyPair;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import javax.crypto.Cipher;
import javax.crypto.interfaces.DHPublicKey;
import org.ietf.jgss.GSSException;

public class DbAccess {
    private OutputStream _$8932 = null;
    private InputStream _$8933 = null;
    private Socket _$8934 = null;
    DmMsg msg = null;
    private int _$8935 = 12345;
    private String _$6912 = null;
    private int _$8936 = 8192;
    private short _$8937 = 0;
    private KeyPair _$8938 = null;
    private int _$8939 = -1;
    private Cipher _$8940 = null;
    private Cipher _$8941 = null;
    private boolean _$8942 = true;
    private byte _$7078;

    public DbAccess(String host, String port, byte flag) throws IOException {
        if (port != null) {
            this._$8935 = Integer.parseInt(port);
        }
        this._$6912 = host;
        this._$7078 = flag;
        this.changeSocket(new Socket(this._$6912, this._$8935));
    }

    public void changeSocket(Socket socket) throws IOException {
        this._$8934 = socket;
        this._$8934.setTcpNoDelay(true);
        this._$8934.setKeepAlive(true);
        this._$8933 = new BufferedInputStream(this._$8934.getInputStream(), this._$8936);
        this._$8932 = new BufferedOutputStream(this._$8934.getOutputStream(), this._$8936);
    }

    public final Socket getSocket() {
        return this._$8934;
    }

    public final String getHostName() {
        return this._$6912;
    }

    public final int getPortNumber() {
        return this._$8935;
    }

    public final void close() {
        try {
            if (this._$8933 != null) {
                this._$8933.close();
                this._$8933 = null;
            }
        }
        catch (Exception Ex) {
            this._$8933 = null;
        }
        try {
            if (this._$8932 != null) {
                this._$8932.close();
                this._$8932 = null;
            }
        }
        catch (Exception Ex) {
            this._$8932 = null;
        }
        try {
            if (this._$8934 != null) {
                this._$8934.close();
                this._$8934 = null;
            }
        }
        catch (Exception Ex) {
            this._$8934 = null;
        }
        this.msg = null;
    }

    protected void finalize() {
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] _$8946(byte[] byteSource, int length) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(length);
        byte[] cipher_content = null;
        byte[] plain_content = null;
        if (64 >= length) {
            return new byte[0];
        }
        try {
            baos.write(byteSource, 0, 64);
            cipher_content = new byte[length - 64];
            System.arraycopy(byteSource, 64, cipher_content, 0, length - 64);
            plain_content = this.symmetricDecrypto(cipher_content, length - 64);
            baos.write(plain_content);
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        finally {
            try {
                baos.close();
            }
            catch (IOException ioex) {
                System.out.println(ioex.getMessage());
            }
        }
        return new byte[0];
    }

    public byte[] symmetricDecrypto(byte[] byteSource, int length) {
        byte[] digest = new byte[16];
        byte[] plain_text = null;
        if (this._$8942) {
            System.arraycopy(byteSource, length - 16, digest, 0, 16);
        }
        try {
            if (this._$8942) {
                plain_text = this._$8941.doFinal(byteSource, 0, length - 16);
                if (!this._$8957(4352, plain_text, digest)) {
                    throw new Exception();
                }
            } else {
                plain_text = this._$8941.doFinal(byteSource, 0, length);
            }
            return plain_text;
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            return new byte[0];
        }
    }

    public final DmMsg readPacket() throws IOException {
        int ret_len = this._$8959(this._$8933, this.msg.getBuffer(), 0, 32768);
        int msgLen = this.msg.getLength();
        if ((msgLen += 64) > this.msg.getBufLength()) {
            this.msg.setBuffer(msgLen);
        }
        if (ret_len < msgLen && ret_len != -1) {
            this._$8960(this._$8933, this.msg.getBuffer(), ret_len, msgLen - ret_len);
        }
        if (4096 == this.msg.getEncryptType() && msgLen > 64) {
            byte[] decrypt_buffer = this._$8946(this.msg.getBuffer(), msgLen);
            int decrypt_buffer_length = decrypt_buffer.length - 64;
            this.msg.setBuffer(decrypt_buffer);
            this.msg.setLength(decrypt_buffer_length);
            this.msg.setCRC(this.msg.calculateCRC());
        }
        return this.msg;
    }

    private final int _$8960(InputStream in, byte[] b, int off, int len) throws IOException {
        int n;
        int count;
        if (len < 0) {
            throw new IndexOutOfBoundsException();
        }
        for (n = 0; n < len; n += count) {
            count = in.read(b, off + n, len - n);
            if (count >= 0) continue;
            throw new EOFException();
        }
        return n;
    }

    private final int _$8959(InputStream in, byte[] b, int off, int len) throws IOException {
        if (len < 0) {
            throw new IndexOutOfBoundsException();
        }
        int count = in.read(b, off, len);
        return count;
    }

    private byte[] _$8966(byte[] byteSource, int length) {
        int msg_body_len = length - 64;
        byte[] plain_content = null;
        byte[] cipher_content = null;
        byte[] cipher_msg = null;
        if (0 >= msg_body_len) {
            return new byte[0];
        }
        try {
            plain_content = new byte[msg_body_len];
            System.arraycopy(byteSource, 64, plain_content, 0, msg_body_len);
            cipher_content = this._$8969(plain_content, msg_body_len);
            cipher_msg = new byte[64 + cipher_content.length];
            System.arraycopy(byteSource, 0, cipher_msg, 0, 64);
            System.arraycopy(cipher_content, 0, cipher_msg, 64, cipher_content.length);
            return cipher_msg;
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            return new byte[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] _$8969(byte[] byteSource, int length) {
        ByteArrayOutputStream baos = null;
        baos = this._$8942 ? new ByteArrayOutputStream(length + 8 + 16) : new ByteArrayOutputStream(length + 8);
        try {
            baos.write(this._$8940.doFinal(byteSource, 0, length));
            if (this._$8942) {
                baos.write(this._$8970(4352, byteSource));
            }
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        finally {
            try {
                baos.close();
            }
            catch (IOException ioex) {
                System.out.println(ioex.getMessage());
            }
        }
        return new byte[0];
    }

    public final void send(DmMsg msgIn) throws IOException {
        this.msg = msgIn;
        int msgLen = this.msg.getLength() + 64;
        if (4096 == this._$8937 && msgLen > 64) {
            this.msg.setEncryptType((short)4096);
            byte[] encrypt_buffer = this._$8966(this.msg.getBuffer(), msgLen);
            int encrypt_buffer_length = encrypt_buffer.length - 64;
            this.msg.setBuffer(encrypt_buffer);
            this.msg.setLength(encrypt_buffer_length);
            msgLen = encrypt_buffer_length + 64;
        }
        this.msg.setCRC(this.msg.calculateCRC());
        if (msgLen < 512 && this._$7078 != 105) {
            if (4096 == this._$8937) {
                for (int i = msgLen; i < 512; ++i) {
                    this.msg.buffer[i] = 0;
                }
            }
            msgLen = 512;
        }
        this._$8932.write(this.msg.getBuffer(), 0, msgLen);
        this._$8932.flush();
    }

    public final void set_msg_encrypt_type(short new_type) {
        this._$8937 = new_type;
    }

    public final short get_msg_encrypt_type() {
        return this._$8937;
    }

    public final int getNetPacketSize() {
        return this._$8936;
    }

    public final void setNetPacketSize(int netPacketSize) {
        this._$8936 = netPacketSize;
    }

    private final byte[] _$8970(int algorithm, byte[] msg_text) throws IOException {
        MessageDigest md = null;
        byte[] msg_digest = null;
        switch (algorithm) {
            case 4352: {
                try {
                    md = MessageDigest.getInstance("MD5");
                    break;
                }
                catch (NoSuchAlgorithmException e) {
                    throw new IOException();
                }
            }
        }
        if (null == md) {
            return null;
        }
        md.reset();
        md.update(msg_text);
        msg_digest = md.digest();
        return msg_digest;
    }

    private final boolean _$8957(int algorithm, byte[] msg_text, byte[] digest) throws IOException {
        byte[] msg_digest = null;
        msg_digest = this._$8970(algorithm, msg_text);
        if (digest.length != msg_digest.length) {
            return false;
        }
        for (int i = 0; i < digest.length; ++i) {
            if (digest[i] == msg_digest[i]) continue;
            return false;
        }
        return true;
    }

    public final byte[] getClientPubKey() {
        if (null == this._$8938) {
            this._$8938 = MsgSecurity.newClientKeyPair();
        }
        return MsgSecurity.bn2Bytes(((DHPublicKey)this._$8938.getPublic()).getY());
    }

    private final byte[] _$8989(byte[] serverPubKey) {
        byte[] sessionKey = null;
        sessionKey = MsgSecurity.computeSessionKey(this._$8938.getPrivate(), serverPubKey);
        return sessionKey;
    }

    public final void genMsgCiphers(byte[] serverPubKey) throws SQLException {
        byte[] tempSessionKey = null;
        byte[] sessionKey = null;
        SymmCipherDesc cipherDesc = null;
        if (-1 == this._$8939) {
            return;
        }
        tempSessionKey = this._$8989(serverPubKey);
        cipherDesc = new SymmCipherDesc(this._$8939);
        int keySize = cipherDesc.getKeyLength();
        if (256 == cipherDesc.getAlgorithmType()) {
            keySize += 8;
        }
        sessionKey = new byte[keySize];
        System.arraycopy(tempSessionKey, 0, sessionKey, 0, keySize);
        if (256 == cipherDesc.getAlgorithmType()) {
            System.arraycopy(tempSessionKey, 0, sessionKey, keySize - 8, 8);
        }
        try {
            this._$8940 = MsgSecurity.newCipher(1, cipherDesc, sessionKey);
            this._$8941 = MsgSecurity.newCipher(2, cipherDesc, sessionKey);
        }
        catch (Exception e) {
            this._$8940 = null;
            this._$8941 = null;
            DBError.throwSQLException(6061);
        }
    }

    public void setMsgCipherType(int msgCipherType) {
        this._$8939 = msgCipherType;
    }

    public AuthInfo getAuthInfo(int authType) throws SQLException {
        Auth auth = null;
        AuthInfo tempAuthInfo = null;
        try {
            auth = new Auth(this._$8934.getInetAddress().getCanonicalHostName(), authType);
        }
        catch (UnknownHostException e1) {
            DBError.throwSQLException(6063);
        }
        try {
            tempAuthInfo = auth.getAuthInfo();
        }
        catch (GSSException e) {
            DBError.throwSQLException(6062);
        }
        return tempAuthInfo;
    }
}

