/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.parser;

import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.Translation;
import org.eclipse.birt.report.model.parser.DataItemState;
import org.eclipse.birt.report.model.parser.DerivedDataSetState;
import org.eclipse.birt.report.model.parser.DesignParseState;
import org.eclipse.birt.report.model.parser.DesignParserException;
import org.eclipse.birt.report.model.parser.EncryptedPropertyState;
import org.eclipse.birt.report.model.parser.ExpressionState;
import org.eclipse.birt.report.model.parser.ExtendedItemState;
import org.eclipse.birt.report.model.parser.FreeFormState;
import org.eclipse.birt.report.model.parser.GraphicMasterPageState;
import org.eclipse.birt.report.model.parser.GridItemState;
import org.eclipse.birt.report.model.parser.ImageState;
import org.eclipse.birt.report.model.parser.JointDataSetState;
import org.eclipse.birt.report.model.parser.LabelState;
import org.eclipse.birt.report.model.parser.LineItemState;
import org.eclipse.birt.report.model.parser.ListItemState;
import org.eclipse.birt.report.model.parser.ModuleParserHandler;
import org.eclipse.birt.report.model.parser.OdaCubeState;
import org.eclipse.birt.report.model.parser.OdaDataSetState;
import org.eclipse.birt.report.model.parser.OdaDataSourceState;
import org.eclipse.birt.report.model.parser.ParseStateFactory;
import org.eclipse.birt.report.model.parser.ParserSchemaConstants;
import org.eclipse.birt.report.model.parser.PropertyState;
import org.eclipse.birt.report.model.parser.RectangleState;
import org.eclipse.birt.report.model.parser.ScriptDataSetState;
import org.eclipse.birt.report.model.parser.ScriptDataSourceState;
import org.eclipse.birt.report.model.parser.SimpleMasterPageState;
import org.eclipse.birt.report.model.parser.SlotState;
import org.eclipse.birt.report.model.parser.TableItemState;
import org.eclipse.birt.report.model.parser.TabularCubeState;
import org.eclipse.birt.report.model.parser.TemplateDataSetState;
import org.eclipse.birt.report.model.parser.TextDataItemState;
import org.eclipse.birt.report.model.parser.TextItemState;
import org.eclipse.birt.report.model.parser.TextPropertyState;
import org.eclipse.birt.report.model.parser.XmlPropertyState;
import org.eclipse.birt.report.model.util.AbstractParseState;
import org.eclipse.birt.report.model.util.AnyElementState;
import org.eclipse.birt.report.model.util.VersionUtil;
import org.eclipse.birt.report.model.util.XMLParserException;
import org.eclipse.birt.report.model.util.XMLParserHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public abstract class ModuleState
extends DesignParseState {
    protected Module module = null;

    public ModuleState(ModuleParserHandler theHandler) {
        super(theHandler);
        this.module = theHandler.getModule();
    }

    public DesignElement getElement() {
        return this.module;
    }

    public void parseAttrs(Attributes attrs) throws XMLParserException {
        String version = attrs.getValue("version");
        this.module.getVersionManager().setVersion(version);
        if (!StringUtil.isBlank(version)) {
            int result;
            try {
                this.handler.versionNumber = VersionUtil.parseVersion(version);
                result = 3022200 < this.handler.versionNumber ? -1 : (3022200 == this.handler.versionNumber ? 0 : 1);
            }
            catch (NumberFormatException numberFormatException) {
                DesignParserException e = new DesignParserException(new String[]{version}, "Error.DesignParserException.INVALID_VERSION");
                throw new XMLParserException((Exception)((Object)e));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                DesignParserException e = new DesignParserException(new String[]{version}, "Error.DesignParserException.INVALID_VERSION");
                throw new XMLParserException((Exception)((Object)e));
            }
            if (result < 0) {
                DesignParserException e = new DesignParserException(new String[]{version}, "Error.DesignParserException.UNSUPPORTED_VERSION");
                throw new XMLParserException((Exception)((Object)e));
            }
            if (result == 0) {
                this.handler.isCurrentVersion = true;
            }
        }
        this.initElementID(attrs, this.module);
        this.addElementID(this.module, this.module);
        super.parseAttrs(attrs);
    }

    public AbstractParseState startElement(String tagName) {
        if (this.handler.isReadOnlyModuleProperties) {
            int tagValue = tagName.toLowerCase().hashCode();
            if (ParserSchemaConstants.PROPERTY_TAG == tagValue) {
                return new PropertyState(this.handler, this.getElement());
            }
            if (ParserSchemaConstants.EXPRESSION_TAG == tagValue) {
                return new ExpressionState(this.handler, this.getElement());
            }
            if (ParserSchemaConstants.XML_PROPERTY_TAG == tagValue) {
                return new XmlPropertyState(this.handler, this.getElement());
            }
            if (ParserSchemaConstants.METHOD_TAG == tagValue) {
                return new PropertyState(this.handler, this.getElement());
            }
            if (ParserSchemaConstants.TEXT_PROPERTY_TAG == tagValue) {
                return new TextPropertyState(this.handler, this.getElement());
            }
            if (ParserSchemaConstants.HTML_PROPERTY_TAG == tagValue) {
                return new TextPropertyState(this.handler, this.getElement());
            }
            if (ParserSchemaConstants.ENCRYPTED_PROPERTY_TAG == tagValue) {
                return new EncryptedPropertyState(this.handler, this.getElement());
            }
            return new AnyElementState(this.handler);
        }
        return super.startElement(tagName);
    }

    static class ComponentsState
    extends SlotState {
        protected ComponentsState(ModuleParserHandler handler, DesignElement container, int slot) {
            super(handler, container, slot);
        }

        public AbstractParseState startElement(String tagName) {
            int tagValue = tagName.toLowerCase().hashCode();
            if (ParserSchemaConstants.BROWSER_CONTROL_TAG == tagValue) {
                return new AnyElementState(this.handler);
            }
            if (ParserSchemaConstants.FREE_FORM_TAG == tagValue) {
                return new FreeFormState(this.handler, this.container, this.slotID);
            }
            if (ParserSchemaConstants.DATA_TAG == tagValue) {
                return new DataItemState(this.handler, this.container, this.slotID);
            }
            if (ParserSchemaConstants.EXTENDED_ITEM_TAG == tagValue) {
                return new ExtendedItemState(this.handler, this.container, this.slotID);
            }
            if (ParserSchemaConstants.GRID_TAG == tagValue) {
                return new GridItemState(this.handler, this.container, this.slotID);
            }
            if (ParserSchemaConstants.IMAGE_TAG == tagValue) {
                return new ImageState(this.handler, this.container, this.slotID);
            }
            if (ParserSchemaConstants.INCLUDE_TAG == tagValue) {
                return new AnyElementState(this.handler);
            }
            if (ParserSchemaConstants.LABEL_TAG == tagValue) {
                return new LabelState(this.handler, this.container, this.slotID);
            }
            if (ParserSchemaConstants.TEXT_TAG == tagValue) {
                return new TextItemState(this.handler, this.container, this.slotID);
            }
            if (ParserSchemaConstants.LINE_TAG == tagValue) {
                return new LineItemState(this.handler, this.container, this.slotID);
            }
            if (ParserSchemaConstants.LIST_TAG == tagValue) {
                return new ListItemState(this.handler, this.container, this.slotID);
            }
            if (ParserSchemaConstants.RECTANGLE_TAG == tagValue) {
                return new RectangleState(this.handler, this.container, this.slotID);
            }
            if (ParserSchemaConstants.TABLE_TAG == tagValue) {
                return new TableItemState(this.handler, this.container, this.slotID);
            }
            if (ParserSchemaConstants.TEXT_TAG == tagValue) {
                return new TextItemState(this.handler, this.container, this.slotID);
            }
            if (ParserSchemaConstants.TOC_TAG == tagValue) {
                return new AnyElementState(this.handler);
            }
            if (ParserSchemaConstants.MULTI_LINE_DATA_TAG == tagValue || ParserSchemaConstants.TEXT_DATA_TAG == tagValue) {
                return new TextDataItemState(this.handler, this.container, this.slotID);
            }
            return super.startElement(tagName);
        }
    }

    public static class CubesState
    extends SlotState {
        public CubesState(ModuleParserHandler handler, DesignElement container, int slot) {
            super(handler, container, slot);
        }

        public AbstractParseState startElement(String tagName) {
            if (tagName.equalsIgnoreCase("tabular-cube")) {
                return new TabularCubeState(this.handler, this.container, this.slotID);
            }
            if (tagName.equalsIgnoreCase("oda-cube")) {
                return new OdaCubeState(this.handler, this.container, this.slotID);
            }
            int tagValue = tagName.toLowerCase().hashCode();
            AbstractParseState state = ParseStateFactory.getInstance().createCubeState(tagValue, this.handler, this.handler.module, this.slotID);
            if (state != null) {
                return state;
            }
            return super.startElement(tagName);
        }
    }

    public static class DataSetsState
    extends SlotState {
        public DataSetsState(ModuleParserHandler handler, DesignElement container, int slot) {
            super(handler, container, slot);
        }

        public AbstractParseState startElement(String tagName) {
            int tagValue = tagName.toLowerCase().hashCode();
            if (ParserSchemaConstants.SCRIPT_DATA_SET_TAG == tagValue) {
                return new ScriptDataSetState(this.handler, (DesignElement)this.handler.module, this.slotID);
            }
            if (ParserSchemaConstants.ODA_DATA_SET_TAG == tagValue || ParserSchemaConstants.EXTENDED_DATA_SET_TAG == tagValue) {
                return new OdaDataSetState(this.handler, (DesignElement)this.handler.module, this.slotID);
            }
            if (ParserSchemaConstants.TEMPLATE_DATA_SET_TAG == tagValue) {
                return new TemplateDataSetState(this.handler, this.handler.module, this.slotID);
            }
            if (ParserSchemaConstants.JOINT_DATA_SET_TAG == tagValue) {
                return new JointDataSetState(this.handler, this.handler.module, this.slotID);
            }
            if (ParserSchemaConstants.DERIVED_DATA_SET_TAG == tagValue) {
                return new DerivedDataSetState(this.handler, this.handler.module, this.slotID);
            }
            AbstractParseState state = ParseStateFactory.getInstance().createDataSetState(tagValue, this.handler, this.handler.module, this.slotID);
            if (state != null) {
                return state;
            }
            return super.startElement(tagName);
        }
    }

    public static class DataSourcesState
    extends SlotState {
        public DataSourcesState(ModuleParserHandler handler, DesignElement container, int slot) {
            super(handler, container, slot);
        }

        public AbstractParseState startElement(String tagName) {
            int tagValue = tagName.toLowerCase().hashCode();
            if (ParserSchemaConstants.SCRIPT_DATA_SOURCE_TAG == tagValue) {
                return new ScriptDataSourceState(this.handler, this.slotID);
            }
            if (ParserSchemaConstants.ODA_DATA_SOURCE_TAG == tagValue || ParserSchemaConstants.EXTENDED_DATA_SOURCE_TAG == tagValue) {
                return new OdaDataSourceState(this.handler, this.slotID);
            }
            AbstractParseState state = ParseStateFactory.getInstance().createDataSourceState(tagValue, this.handler, this.handler.module, this.slotID);
            if (state != null) {
                return state;
            }
            return super.startElement(tagName);
        }
    }

    class InnerParseState
    extends AbstractParseState {
        InnerParseState() {
        }

        public XMLParserHandler getHandler() {
            return ModuleState.this.handler;
        }
    }

    static class PageSetupState
    extends SlotState {
        protected PageSetupState(ModuleParserHandler handler, DesignElement container, int slot) {
            super(handler, container, slot);
        }

        public AbstractParseState startElement(String tagName) {
            int tagValue = tagName.toLowerCase().hashCode();
            if (ParserSchemaConstants.GRAPHIC_MASTER_PAGE_TAG == tagValue) {
                return new GraphicMasterPageState(this.handler);
            }
            if (ParserSchemaConstants.SIMPLE_MASTER_PAGE_TAG == tagValue) {
                return new SimpleMasterPageState(this.handler);
            }
            if (ParserSchemaConstants.PAGE_SEQUENCE_TAG == tagValue) {
                return new AnyElementState(this.handler);
            }
            return super.startElement(tagName);
        }
    }

    class ResourceState
    extends InnerParseState {
        private String key = null;

        ResourceState() {
        }

        public void parseAttrs(Attributes attrs) throws XMLParserException {
            this.key = attrs.getValue("key");
            if (StringUtil.isEmpty(this.key)) {
                ModuleState.this.handler.getErrorHandler().semanticError((Exception)((Object)new DesignParserException("Error.DesignParserException.MESSAGE_KEY_REQUIRED")));
                return;
            }
            super.parseAttrs(attrs);
        }

        public AbstractParseState startElement(String tagName) {
            if ("translation".equalsIgnoreCase(tagName)) {
                return new TranslationState(this.key);
            }
            return super.startElement(tagName);
        }
    }

    class TranslationState
    extends InnerParseState {
        private String resourceKey = null;
        private String locale = null;

        TranslationState(String key) {
            this.resourceKey = key;
        }

        public void parseAttrs(Attributes attrs) throws XMLParserException {
            this.locale = attrs.getValue("locale");
            this.locale = StringUtil.trimString(this.locale);
            if (ModuleState.this.module.findTranslation(this.resourceKey, this.locale) != null) {
                ModuleState.this.handler.getErrorHandler().semanticError((Exception)((Object)new DesignParserException("Error.DesignParserException.DUPLICATE_TRANSLATION_LOCALE")));
                return;
            }
            super.parseAttrs(attrs);
        }

        public void end() throws SAXException {
            ModuleState.this.module.addTranslation(new Translation(this.resourceKey, this.locale, this.text.toString()));
            super.end();
        }
    }

    class TranslationsState
    extends InnerParseState {
        TranslationsState() {
        }

        public AbstractParseState startElement(String tagName) {
            if ("resource".equalsIgnoreCase(tagName)) {
                return new ResourceState();
            }
            return super.startElement(tagName);
        }
    }
}

