/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.extension.oda;

import java.util.List;
import org.eclipse.birt.report.model.api.filterExtension.IODAFilterExprProvider;
import org.eclipse.birt.report.model.api.filterExtension.interfaces.IFilterExprDefinition;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.extension.oda.IODAProviderFactory;
import org.eclipse.birt.report.model.extension.oda.ODAProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ODAProviderFactory
implements IODAProviderFactory,
IODAFilterExprProvider {
    private static IODAProviderFactory baseFactory = null;
    private static ODAProviderFactory instance = null;
    private static IODAFilterExprProvider filterProvider = null;

    public static ODAProviderFactory getInstance() {
        if (instance == null) {
            instance = new ODAProviderFactory();
        }
        return instance;
    }

    @Override
    public ODAProvider createODAProvider(DesignElement element, String extensionID) {
        if (baseFactory != null) {
            return baseFactory.createODAProvider(element, extensionID);
        }
        return null;
    }

    @Override
    public IFilterExprDefinition createFilterExprDefinition() {
        if (baseFactory != null) {
            return baseFactory.createFilterExprDefinition();
        }
        return null;
    }

    @Override
    public IFilterExprDefinition createFilterExprDefinition(String birtFilterExpr) {
        if (baseFactory != null) {
            return baseFactory.createFilterExprDefinition(birtFilterExpr);
        }
        return null;
    }

    public static synchronized void initeTheFactory(IODAProviderFactory base) {
        if (baseFactory != null) {
            return;
        }
        baseFactory = base;
    }

    public static synchronized void initFilterExprFactory(IODAFilterExprProvider filterProvider) {
        if (ODAProviderFactory.filterProvider != null) {
            return;
        }
        ODAProviderFactory.filterProvider = filterProvider;
    }

    public static void releaseInstance() {
        baseFactory = null;
        instance = null;
    }

    @Override
    public List<IFilterExprDefinition> getMappedFilterExprDefinitions(String odaDatasetExtensionId, String odaDataSourceExtensionId) {
        return filterProvider.getMappedFilterExprDefinitions(odaDatasetExtensionId, odaDataSourceExtensionId);
    }

    @Override
    public boolean supportOdaExtensionFilters() {
        return filterProvider.supportOdaExtensionFilters();
    }

    @Override
    public boolean supportODAFilterPushDown(String dataSourceExtId, String dataSetExtId) {
        return filterProvider.supportODAFilterPushDown(dataSourceExtId, dataSetExtId);
    }
}

