/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.elements.olap;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.report.model.api.command.ExtendsException;
import org.eclipse.birt.report.model.api.metadata.IElementDefn;
import org.eclipse.birt.report.model.api.metadata.IElementPropertyDefn;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.ContainerContext;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.NameSpace;
import org.eclipse.birt.report.model.core.namespace.DimensionNameHelper;
import org.eclipse.birt.report.model.elements.olap.Cube;
import org.eclipse.birt.report.model.elements.olap.Dimension;
import org.eclipse.birt.report.model.elements.olap.Level;
import org.eclipse.birt.report.model.elements.olap.TabularCube;
import org.eclipse.birt.report.model.extension.ExtensibilityProvider;
import org.eclipse.birt.report.model.metadata.ElementDefn;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.ExtensionElementDefn;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.util.ElementFactoryUtil;
import org.eclipse.birt.report.model.util.ModelUtil;

public abstract class DynamicLinkProvider
extends ExtensibilityProvider {
    private static final int CAPACITY = 6;
    private static final int DIMENSION_SPACE_ID = 0;
    private static final int NON_DIMENSION_SPACE_ID = 1;
    protected LayoutInfor infor = null;

    public DynamicLinkProvider(DesignElement element) {
        super(element);
        this.cachedExtDefn = null;
    }

    protected abstract DesignElement getTargetElement(Module var1);

    protected abstract boolean isValidTarget(DesignElement var1);

    public final void checkExtends(DesignElement parent) throws ExtendsException {
    }

    public final ExtensionElementDefn getExtDefn() {
        return this.cachedExtDefn;
    }

    public final Object getLayoutProperty(Module module, ElementPropertyDefn prop) {
        return this.infor == null ? null : this.infor.layoutProps.get(prop.getName());
    }

    public final void setLayoutProperty(ElementPropertyDefn prop, Object value) {
        if (this.infor == null) {
            this.infor = new LayoutInfor();
        }
        this.infor.layoutProps.put(prop.getName(), value);
    }

    public final void updateLayout(Module module) {
        DesignElement target;
        this.infor = null;
        if (this.element instanceof Dimension) {
            ((Dimension)this.element).nameHelper = new DimensionNameHelper((Dimension)this.element);
        }
        if ((target = this.getTargetElement(module)) != null && this.isValidTarget(target)) {
            this.infor = new LayoutInfor();
            this.duplicateStructure(target, this.element, module);
        }
    }

    protected boolean duplicateStructure(DesignElement source, DesignElement target, Module targetModule) {
        ElementDefn defn = (ElementDefn)source.getDefn();
        List<IElementPropertyDefn> properties = defn.getContents();
        int i = 0;
        while (i < properties.size()) {
            IElementPropertyDefn propDefn = properties.get(i);
            this.duplicateStructure(new ContainerContext(source, propDefn.getName()), new ContainerContext(target, propDefn.getName()), targetModule);
            ++i;
        }
        if (target instanceof TabularCube) {
            TabularCube targetCube = (TabularCube)target;
            Cube sourceCube = (Cube)source;
            Module sourceRoot = sourceCube.getRoot();
            DesignElement group = source.getReferenceProperty(sourceRoot, "defaultMeasureGroup");
            if (group != null) {
                int index = group.getIndex(sourceCube.getRoot());
                assert (index > -1);
                targetCube.setDefaultMeasureGroup(index);
            }
        } else if (target instanceof Dimension) {
            Dimension targetDimension = (Dimension)target;
            Dimension sourceDimension = (Dimension)source;
            ModelUtil.duplicateDefaultHierarchy(targetDimension, sourceDimension);
        }
        return true;
    }

    private void duplicateStructure(ContainerContext sourceInfor, ContainerContext targetInfor, Module targetModule) {
        targetInfor.clearContents();
        int j = 0;
        while (j < sourceInfor.getContentCount(null)) {
            DesignElement sourceContent = sourceInfor.getContent(null, j);
            DesignElement targetContent = ElementFactoryUtil.newElement(sourceContent.getElementName(), sourceContent.getName());
            if (targetContent != null) {
                long id = sourceContent.getID();
                assert (id > 0L);
                targetContent.setID(sourceContent.getID());
                targetContent.setBaseId(sourceContent.getID());
                targetInfor.add(targetModule, targetContent);
                this.addLocalNames(targetContent);
                this.duplicateStructure(sourceContent, targetContent, targetModule);
            }
            ++j;
        }
    }

    protected final void addLocalNames(DesignElement targetContent) {
        if (targetContent instanceof Dimension) {
            this.infor.localNameSpaces[0].insert(targetContent);
        } else if (targetContent instanceof Level) {
            Dimension container = (Dimension)targetContent.getContainer().getContainer();
            assert (container != null);
            container.getNameHelper().getNameSpace(0).insert(targetContent);
        } else {
            this.infor.localNameSpaces[1].insert(targetContent);
        }
    }

    public final DesignElement findLocalElement(String name, IElementDefn type) {
        if (StringUtil.isBlank(name) || type == null || this.infor == null) {
            return null;
        }
        MetaDataDictionary dd = MetaDataDictionary.getInstance();
        if (type.isKindOf(dd.getElement("Dimension"))) {
            return this.infor.localNameSpaces[0].getElement(name);
        }
        DesignElement element = this.infor.localNameSpaces[1].getElement(name);
        if (element != null && element.getDefn().isKindOf(type)) {
            return element;
        }
        return null;
    }

    public class LayoutInfor {
        public Map<String, Object> layoutProps = new HashMap<String, Object>(6);
        public NameSpace[] localNameSpaces = new NameSpace[2];

        public LayoutInfor() {
            this.localNameSpaces[0] = new NameSpace();
            this.localNameSpaces[1] = new NameSpace();
        }
    }
}

