/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.elements;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.core.ContainerSlot;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.StyledElement;
import org.eclipse.birt.report.model.elements.ElementVisitor;
import org.eclipse.birt.report.model.elements.TableGroup;
import org.eclipse.birt.report.model.elements.TableItem;
import org.eclipse.birt.report.model.elements.TableRow;
import org.eclipse.birt.report.model.elements.interfaces.ICellModel;
import org.eclipse.birt.report.model.elements.strategy.CellPropSearchStrategy;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Cell
extends StyledElement
implements ICellModel {
    public Cell() {
        this.initSlots();
        this.cachedPropStrategy = CellPropSearchStrategy.getInstance();
    }

    @Override
    public ContainerSlot getSlot(int slot) {
        assert (slot == 0);
        return this.slots[0];
    }

    @Override
    public void apply(ElementVisitor visitor) {
        visitor.visitCell(this);
    }

    @Override
    public String getElementName() {
        return "Cell";
    }

    @Override
    public DesignElementHandle getHandle(Module module) {
        return this.handle(module);
    }

    public CellHandle handle(Module module) {
        if (this.handle == null) {
            this.handle = new CellHandle(module, this);
        }
        return (CellHandle)this.handle;
    }

    public int getColSpan(Module module) {
        return this.getIntProperty(module, "colSpan");
    }

    public int getRowSpan(Module module) {
        return this.getIntProperty(module, "rowSpan");
    }

    public int getColumn(Module module) {
        return this.getIntProperty(module, "column");
    }

    @Override
    public List<String> getElementSelectors() {
        TableRow row = (TableRow)this.getContainer();
        if (row == null) {
            return Collections.emptyList();
        }
        DesignElement rowContainer = row.getContainer();
        if (rowContainer == null) {
            return Collections.emptyList();
        }
        String cellSelector = null;
        if (rowContainer instanceof TableItem) {
            cellSelector = "table-" + rowContainer.getDefn().getSlot(row.getContainerInfo().getSlotID()).getName() + "-cell";
        } else if (rowContainer instanceof TableGroup) {
            cellSelector = "table-group-" + rowContainer.getDefn().getSlot(row.getContainerInfo().getSlotID()).getName() + "-cell";
        }
        if (cellSelector != null) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(cellSelector);
            return list;
        }
        return Collections.emptyList();
    }

    @Override
    public Object getProperty(Module module, ElementPropertyDefn prop) {
        if ("textAlign".equalsIgnoreCase(prop.getName())) {
            Object value = this.cachedPropStrategy.getPropertyExceptRomDefault(module, this, prop);
            if (value == null) {
                DesignElement row = this.getContainer();
                if (row instanceof TableRow && row.getContainer() instanceof TableItem && row.getContainerInfo().getSlotID() == 0) {
                    return "center";
                }
                return prop.getDefault();
            }
            return value;
        }
        return super.getProperty(module, prop);
    }
}

