/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import java.util.List;
import org.eclipse.birt.report.model.activity.ActivityStack;
import org.eclipse.birt.report.model.api.AbstractThemeHandle;
import org.eclipse.birt.report.model.api.SharedStyleHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.css.CssStyleSheetHandle;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.interfaces.IReportItemThemeModel;
import org.eclipse.birt.report.model.util.CommandLabelFactory;
import org.eclipse.birt.report.model.util.StyleUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportItemThemeHandle
extends AbstractThemeHandle
implements IReportItemThemeModel {
    public ReportItemThemeHandle(Module module, DesignElement element) {
        super(module, element);
    }

    public String getType() {
        return this.getStringProperty("type");
    }

    public void setType(String type) throws SemanticException {
        this.setStringProperty("type", type);
    }

    public void importCssStyles(CssStyleSheetHandle stylesheet, List<SharedStyleHandle> selectedStyles) throws SemanticException {
        ActivityStack stack = this.module.getActivityStack();
        stack.startTrans(CommandLabelFactory.getCommandLabel("Message.ImportCSSStyles"));
        int i = 0;
        while (i < selectedStyles.size()) {
            SharedStyleHandle style = selectedStyles.get(i);
            try {
                SharedStyleHandle newStyle = StyleUtil.TransferCssStyleToSharedStyle(this.module, style);
                if (newStyle != null) {
                    this.getStyles().add(newStyle);
                }
            }
            catch (SemanticException e) {
                stack.rollback();
                throw e;
            }
            ++i;
        }
        stack.commit();
    }
}

