/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.FactoryPropertyHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.SimpleValueHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.ContentException;
import org.eclipse.birt.report.model.api.core.IDesignElement;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.metadata.IElementDefn;
import org.eclipse.birt.report.model.api.metadata.IElementPropertyDefn;
import org.eclipse.birt.report.model.api.metadata.IPropertyDefn;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.command.ComplexPropertyCommand;
import org.eclipse.birt.report.model.command.ContentCommand;
import org.eclipse.birt.report.model.command.EncryptionCommand;
import org.eclipse.birt.report.model.command.PropertyCommand;
import org.eclipse.birt.report.model.core.ContainerContext;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.StructureContext;
import org.eclipse.birt.report.model.metadata.ElementDefn;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.util.PropertyHandleHelper;

public class PropertyHandle
extends SimpleValueHandle {
    protected ElementPropertyDefn propDefn;

    public PropertyHandle(DesignElementHandle element, String propName) {
        super(element);
        this.propDefn = element.getElement().getPropertyDefn(propName);
    }

    public PropertyHandle(DesignElementHandle element, ElementPropertyDefn prop) {
        super(element);
        this.propDefn = prop;
    }

    public IElementPropertyDefn getPropertyDefn() {
        return this.propDefn;
    }

    public IPropertyDefn getDefn() {
        return this.propDefn;
    }

    protected Object getRawValue() {
        return this.elementHandle.getElement().getProperty(this.getModule(), this.propDefn);
    }

    public void setValue(Object value) throws SemanticException {
        PropertyCommand cmd = new PropertyCommand(this.getModule(), this.getElement());
        cmd.setProperty(this.propDefn, value);
    }

    public StructureContext getContext() {
        return new StructureContext(this.getElement(), this.propDefn, null);
    }

    public boolean isSet() {
        FactoryPropertyHandle handle = new FactoryPropertyHandle(this.elementHandle, this.propDefn);
        return handle.isSet();
    }

    public boolean isLocal() {
        Object value = this.getElement().getLocalProperty(this.getModule(), this.propDefn);
        return value != null;
    }

    public boolean equals(Object propertyHandle) {
        if (!(propertyHandle instanceof PropertyHandle)) {
            return false;
        }
        DesignElement element = ((PropertyHandle)propertyHandle).getElement();
        IPropertyDefn propDefn = ((PropertyHandle)propertyHandle).getDefn();
        return element == this.getElement() && this.equalsPropertyDefn(propDefn);
    }

    private boolean equalsPropertyDefn(IPropertyDefn defn) {
        if (defn == null) {
            return false;
        }
        return this.propDefn.getName().equals(defn.getName()) && this.propDefn.getTypeCode() == defn.getTypeCode();
    }

    public List getReferenceableElementList() {
        if (this.propDefn.getTypeCode() != 15 && this.propDefn.getSubTypeCode() != 15) {
            return Collections.EMPTY_LIST;
        }
        ArrayList list = new ArrayList();
        ElementDefn elementDefn = (ElementDefn)this.propDefn.getTargetElementType();
        assert (elementDefn != null);
        ModuleHandle moduleHandle = (ModuleHandle)this.getModule().getHandle(this.getModule());
        if ("DataSet".equals(elementDefn.getName())) {
            return moduleHandle.getVisibleDataSets();
        }
        if (this.getElementHandle() instanceof ReportItemHandle && "dataBindingRef".equalsIgnoreCase(this.propDefn.getName())) {
            return ((ReportItemHandle)this.getElementHandle()).getNamedDataBindingReferenceList();
        }
        if ("DataSource".equals(elementDefn.getName())) {
            return moduleHandle.getVisibleDataSources();
        }
        if ("Style".equals(elementDefn.getName())) {
            return ((ReportDesignHandle)moduleHandle).getAllStyles();
        }
        if ("Theme".equals(elementDefn.getName())) {
            return moduleHandle.getVisibleThemes(1);
        }
        if ("Cube".equals(elementDefn.getName())) {
            return moduleHandle.getVisibleCubes();
        }
        if ("ReportItemTheme".equals(elementDefn.getName())) {
            String matchedType = MetaDataDictionary.getInstance().getThemeType(this.elementHandle.getDefn());
            if (matchedType == null) {
                return list;
            }
            return moduleHandle.getVisibleReportItemThemes(1, matchedType);
        }
        return list;
    }

    public boolean isReadOnly() {
        boolean isReadOnly = false;
        Module root = this.getElementHandle().getModule();
        assert (root != null);
        if (root.isReadOnly()) {
            isReadOnly = true;
        } else {
            switch (this.propDefn.getValueType()) {
                case 0: 
                case 2: 
                case 4: {
                    IElementDefn elementDefn = this.getElementHandle().getDefn();
                    if (!elementDefn.isPropertyReadOnly(this.propDefn.getName())) break;
                    isReadOnly = true;
                    break;
                }
                case 3: {
                    if (!this.propDefn.isReadOnly()) break;
                    isReadOnly = true;
                }
            }
        }
        if (isReadOnly) {
            return true;
        }
        return PropertyHandleHelper.getInstance().isReadOnlyInContext(this);
    }

    public boolean isVisible() {
        boolean isVisible = true;
        switch (this.propDefn.getValueType()) {
            case 0: 
            case 2: 
            case 4: {
                IElementDefn elementDefn = this.getElementHandle().getDefn();
                if (elementDefn.isPropertyVisible(this.propDefn.getName())) break;
                isVisible = false;
                break;
            }
            case 3: {
                if (this.propDefn.isVisible()) break;
                isVisible = false;
                break;
            }
            case 1: {
                if (this.propDefn.isVisible()) break;
                isVisible = false;
            }
        }
        if (!isVisible) {
            return false;
        }
        return PropertyHandleHelper.getInstance().isVisibleInContext(this);
    }

    public void removeItem(int posn) throws PropertyValueException {
        block3: {
            try {
                ComplexPropertyCommand cmd = new ComplexPropertyCommand(this.getModule(), this.getElement());
                cmd.removeItem(this.getContext(), posn);
            }
            catch (PropertyValueException e) {
                throw e;
            }
            catch (SemanticException semanticException) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError();
            }
        }
    }

    public void addItem(Object item) throws SemanticException {
        if (item == null) {
            return;
        }
        if (item instanceof IStructure) {
            super.addItem((IStructure)item);
            return;
        }
        ComplexPropertyCommand cmd = new ComplexPropertyCommand(this.getModule(), this.getElement());
        cmd.addItem(this.getContext(), item);
    }

    public void add(DesignElementHandle content) throws SemanticException {
        if (content == null) {
            return;
        }
        ContentCommand cmd = new ContentCommand(this.getModule(), new ContainerContext(this.getElement(), this.propDefn.getName()));
        cmd.add(content.getElement());
    }

    public void add(DesignElementHandle content, int newPos) throws SemanticException {
        if (content == null) {
            return;
        }
        ContentCommand cmd = new ContentCommand(this.getModule(), new ContainerContext(this.getElement(), this.propDefn.getName()));
        cmd.add(content.getElement(), newPos);
    }

    public List paste(DesignElementHandle content) throws SemanticException {
        if (content == null) {
            return Collections.EMPTY_LIST;
        }
        this.add(content);
        return this.getElementHandle().checkPostPasteErrors(content.getElement());
    }

    public List paste(IDesignElement content) throws SemanticException {
        if (content == null) {
            return Collections.EMPTY_LIST;
        }
        this.add(content.getHandle(this.getModule()));
        return this.getElementHandle().checkPostPasteErrors((DesignElement)content);
    }

    public List paste(DesignElementHandle content, int newPos) throws SemanticException {
        if (content == null) {
            return Collections.EMPTY_LIST;
        }
        this.add(content, newPos);
        return Collections.EMPTY_LIST;
    }

    public List paste(IDesignElement content, int newPos) throws SemanticException {
        if (content == null) {
            return Collections.EMPTY_LIST;
        }
        this.add(content.getHandle(this.getModule()), newPos);
        return this.getElementHandle().checkPostPasteErrors((DesignElement)content);
    }

    public ArrayList getListValue() {
        if (this.propDefn.isElementType()) {
            Object value = this.getValue();
            if (value == null) {
                return new ArrayList();
            }
            if (value instanceof DesignElementHandle) {
                ArrayList<Object> result = new ArrayList<Object>();
                result.add(value);
                return result;
            }
            if (value instanceof ArrayList) {
                ArrayList retValue = new ArrayList();
                retValue.addAll((ArrayList)value);
                return retValue;
            }
        }
        return super.getListValue();
    }

    public List getContents() {
        if (this.propDefn.isElementType()) {
            return this.getListValue();
        }
        return Collections.EMPTY_LIST;
    }

    public int getContentCount() {
        return this.getContents().size();
    }

    public void shift(DesignElementHandle content, int toPosn) throws ContentException {
        if (content == null) {
            return;
        }
        ContentCommand cmd = new ContentCommand(this.getModule(), new ContainerContext(this.getElement(), this.propDefn.getName()));
        cmd.movePosition(content.getElement(), toPosn);
    }

    public void move(DesignElementHandle content, DesignElementHandle newContainer, String propName) throws ContentException {
        if (content == null || newContainer == null) {
            return;
        }
        ContentCommand cmd = new ContentCommand(this.getModule(), new ContainerContext(this.getElement(), this.propDefn.getName()));
        cmd.move(content.getElement(), new ContainerContext(newContainer.getElement(), propName));
    }

    public void move(DesignElementHandle content, DesignElementHandle newContainer, String propName, int newPos) throws ContentException {
        if (content == null || newContainer == null) {
            return;
        }
        ContentCommand cmd = new ContentCommand(this.getModule(), new ContainerContext(this.getElement(), this.propDefn.getName()));
        cmd.move(content.getElement(), new ContainerContext(newContainer.getElement(), propName), newPos);
    }

    public void dropAndClear(DesignElementHandle content) throws SemanticException {
        if (content == null) {
            return;
        }
        ContentCommand cmd = new ContentCommand(this.getModule(), new ContainerContext(this.getElement(), this.propDefn.getName()), false, false);
        cmd.remove(content.getElement());
    }

    public void drop(DesignElementHandle content) throws SemanticException {
        if (content == null) {
            return;
        }
        ContentCommand cmd = new ContentCommand(this.getModule(), new ContainerContext(this.getElement(), this.propDefn.getName()), false, true);
        cmd.remove(content.getElement());
    }

    public void dropAndClear(int posn) throws SemanticException {
        if (this.propDefn.getTypeCode() == 23) {
            DesignElementHandle content = (DesignElementHandle)this.get(posn);
            this.dropAndClear(content);
        } else {
            this.removeItem(posn);
        }
    }

    public void drop(int posn) throws SemanticException {
        if (this.propDefn.isElementType()) {
            DesignElementHandle content = (DesignElementHandle)this.get(posn);
            this.drop(content);
        } else {
            this.removeItem(posn);
        }
    }

    public boolean canContain(String type) {
        return this.getElementHandle().canContain(this.propDefn.getName(), type);
    }

    public boolean canContain(DesignElementHandle content) {
        return this.getElementHandle().canContain(this.propDefn.getName(), content);
    }

    public DesignElementHandle getContent(int posn) {
        Object value = this.get(posn);
        if (value instanceof DesignElementHandle) {
            return (DesignElementHandle)value;
        }
        return null;
    }

    public void setEncryption(String encryptionID) throws SemanticException {
        EncryptionCommand cmd = new EncryptionCommand(this.getModule(), this.getElement());
        cmd.setEncryption(this.propDefn, encryptionID);
    }
}

