/*
 * Decompiled with CFR 0.152.
 */
package com.jxd.weChat.proxy;

import com.jxd.weChat.entity.IWeChatEntity;
import com.jxd.weChat.entity.TokenEntity;
import com.jxd.weChat.entity.impl.WeChatTextEntity;
import com.jxd.weChat.util.MyX509TrustManager;
import com.jxd.weChat.util.WeChatGlobal;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.URL;
import java.security.SecureRandom;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;

public class WeChatProxy {
    private static Map<String, HashMap<String, String>> tokenMap = new HashMap<String, HashMap<String, String>>();
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final int expiresIn = 5400;

    public static Map<String, String> sendMessage(IWeChatEntity weChatEntity) {
        TokenEntity tokenEntity = WeChatGlobal.getTokenEntity();
        Map<String, String> result = WeChatProxy.sendMessage(weChatEntity, tokenEntity);
        return result;
    }

    public static Map<String, String> sendMessage(IWeChatEntity weChatEntity, TokenEntity tokenEntity) {
        Map<String, String> result;
        block10: {
            WeChatTextEntity wechatTextEntity;
            String[] subUser;
            String[] subContent;
            block12: {
                block11: {
                    block9: {
                        result = new HashMap<String, String>();
                        if (weChatEntity.getTouser().length() == 0 && weChatEntity.getToparty().length() == 0) {
                            result.put("result", "fail");
                            result.put("reason", "\u6ca1\u6709\u83b7\u53d6\u5230\u63a8\u9001\u7528\u6237\u6216\u90e8\u95e8\uff01");
                            return result;
                        }
                        if (StringUtils.isEmpty((String)weChatEntity.getAgentid())) {
                            result.put("result", "fail");
                            result.put("reason", "\u6ca1\u6709\u83b7\u53d6\u5230\u63a8\u9001\u4f7f\u7528\u7684\u5fae\u4fe1\u5e94\u7528\uff01");
                            return result;
                        }
                        if (StringUtils.isEmpty((String)tokenEntity.getCorpid()) || StringUtils.isEmpty((String)tokenEntity.getCorpsecret())) {
                            result.put("result", "fail");
                            result.put("reason", "\u6ca1\u6709\u83b7\u53d6\u5230\u4f01\u4e1aID\u6216\u7ba1\u7406\u7ec4\u51ed\u8bc1\u5bc6\u94a5\uff01");
                            return result;
                        }
                        int[] messageFlag = weChatEntity.getMessageFlag();
                        subContent = null;
                        subUser = null;
                        if (weChatEntity.getMsgtype().equals("text") && messageFlag[1] > 1) {
                            wechatTextEntity = (WeChatTextEntity)weChatEntity;
                            subContent = wechatTextEntity.getText().get("content").split("\\|\\|\\|\\|");
                        }
                        if (weChatEntity.getTouser().length() > 0 && messageFlag[0] > 1) {
                            subUser = weChatEntity.getTouser().split("\\|\\|");
                        }
                        if (subContent != null || subUser != null) break block9;
                        result = WeChatProxy.actualSendMessage(weChatEntity, tokenEntity);
                        break block10;
                    }
                    if (subContent == null || subUser != null) break block11;
                    wechatTextEntity = (WeChatTextEntity)weChatEntity;
                    int i = 0;
                    while (i < subContent.length) {
                        wechatTextEntity.setText(subContent[i]);
                        result = WeChatProxy.actualSendMessage(wechatTextEntity, tokenEntity);
                        ++i;
                    }
                    break block10;
                }
                if (subContent != null || subUser == null) break block12;
                int j = 0;
                while (j < subUser.length) {
                    String[] userArr = subUser[j].split("\\|");
                    weChatEntity.setUser(Arrays.asList(userArr));
                    result = WeChatProxy.actualSendMessage(weChatEntity, tokenEntity);
                    ++j;
                }
                break block10;
            }
            if (subContent == null || subUser == null) break block10;
            wechatTextEntity = (WeChatTextEntity)weChatEntity;
            int i = 0;
            while (i < subContent.length) {
                wechatTextEntity.setText(subContent[i]);
                int j = 0;
                while (j < subUser.length) {
                    String[] userArr = subUser[j].split("\\|");
                    wechatTextEntity.setUser(Arrays.asList(userArr));
                    result = WeChatProxy.actualSendMessage(wechatTextEntity, tokenEntity);
                    ++j;
                }
                ++i;
            }
        }
        return result;
    }

    private static Map<String, String> actualSendMessage(IWeChatEntity weChatEntity, TokenEntity tokenEntity) {
        HashMap<String, String> result = new HashMap<String, String>();
        String token = WeChatProxy.getToken(tokenEntity);
        if (token == null) {
            result.put("result", "fail");
            result.put("reason", "\u6ca1\u6709\u751f\u6210\u5fae\u4fe1\u53d1\u9001\u51ed\u8bc1\uff01");
            return result;
        }
        String url = "https://qyapi.weixin.qq.com/cgi-bin/message/send?access_token=ACCESS_TOKEN".replaceAll("ACCESS_TOKEN", token);
        JSONObject jsonResult = WeChatProxy.httpRequest(url, "POST", JSONObject.fromObject((Object)weChatEntity).toString());
        int res = Integer.parseInt(jsonResult.getString("errcode"));
        if (res == 0) {
            result.put("result", "success");
            result.put("reason", "ok");
        } else {
            result.put("result", "fail");
            result.put("reason", String.valueOf(res) + ";" + jsonResult.getString("errmsg"));
        }
        return result;
    }

    public static String getToken(TokenEntity tokenEntity) {
        String requestUrl;
        JSONObject jsonObject;
        String token = null;
        if (tokenMap.containsKey(String.valueOf(tokenEntity.getCorpid()) + tokenEntity.getCorpsecret())) {
            long tokenRiseTime = 0L;
            try {
                tokenRiseTime = sdf.parse(tokenMap.get(String.valueOf(tokenEntity.getCorpid()) + tokenEntity.getCorpsecret()).get("riseTime")).getTime();
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            if ((new Date().getTime() - tokenRiseTime) / 1000L < 5400L) {
                token = tokenMap.get(String.valueOf(tokenEntity.getCorpid()) + tokenEntity.getCorpsecret()).get("token");
            } else {
                tokenMap.remove(String.valueOf(tokenEntity.getCorpid()) + tokenEntity.getCorpsecret());
            }
        }
        if (token == null && (jsonObject = WeChatProxy.httpRequest(requestUrl = "https://qyapi.weixin.qq.com/cgi-bin/gettoken?corpid=ID&corpsecret=SECRECT".replace("ID", tokenEntity.getCorpid()).replace("SECRECT", tokenEntity.getCorpsecret()), "GET", null)) != null) {
            try {
                token = jsonObject.getString("access_token");
                HashMap<String, String> subMap = new HashMap<String, String>();
                subMap.put("token", token);
                subMap.put("riseTime", sdf.format(new Date()));
                tokenMap.put(String.valueOf(tokenEntity.getCorpid()) + tokenEntity.getCorpsecret(), subMap);
            }
            catch (JSONException e) {
                token = null;
            }
        }
        return token;
    }

    public static JSONObject getHttpRequest(String requestUrl, String requestMethod, String outputStr) {
        return WeChatProxy.httpRequest(requestUrl, requestMethod, outputStr);
    }

    private static JSONObject httpRequest(String requestUrl, String requestMethod, String outputStr) {
        JSONObject jsonObject = null;
        StringBuffer buffer = new StringBuffer();
        try {
            TrustManager[] tm = new TrustManager[]{new MyX509TrustManager()};
            SSLContext sslContext = SSLContext.getInstance("SSL", "SunJSSE");
            sslContext.init(null, tm, new SecureRandom());
            SSLSocketFactory ssf = sslContext.getSocketFactory();
            URL url = new URL(requestUrl);
            HttpsURLConnection httpUrlConn = (HttpsURLConnection)url.openConnection();
            httpUrlConn.setSSLSocketFactory(ssf);
            httpUrlConn.setDoOutput(true);
            httpUrlConn.setDoInput(true);
            httpUrlConn.setUseCaches(false);
            httpUrlConn.setRequestMethod(requestMethod);
            if ("GET".equalsIgnoreCase(requestMethod)) {
                httpUrlConn.connect();
            }
            if (outputStr != null) {
                OutputStream outputStream = httpUrlConn.getOutputStream();
                outputStream.write(outputStr.getBytes("UTF-8"));
                outputStream.close();
            }
            InputStream inputStream = httpUrlConn.getInputStream();
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "utf-8");
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            String str = null;
            while ((str = bufferedReader.readLine()) != null) {
                buffer.append(str);
            }
            bufferedReader.close();
            inputStreamReader.close();
            inputStream.close();
            inputStream = null;
            httpUrlConn.disconnect();
            String jsonMsg = buffer.toString().trim();
            jsonObject = JSONObject.fromObject((Object)jsonMsg);
        }
        catch (ConnectException connectException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return jsonObject;
    }
}

