/*
 * Decompiled with CFR 0.152.
 */
package com.jxd.weChat.entity.impl;

import com.jxd.weChat.entity.IWeChatEntity;
import com.jxd.weChat.entity.impl.WeChatNewsContent;
import com.jxd.weChat.util.WeChatGlobal;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WeChatNewsEntity
extends IWeChatEntity {
    private Map<String, List<HashMap<String, String>>> news;

    public WeChatNewsEntity() {
        this.msgtype = "news";
    }

    public Map<String, List<HashMap<String, String>>> getNews() {
        return this.news;
    }

    public void setNews(WeChatNewsContent content) {
        List<HashMap<String, String>> contentMap;
        HashMap<String, String> subContent = new HashMap<String, String>();
        subContent.put("title", content.getTitle());
        subContent.put("description", content.getDescription());
        subContent.put("url", content.getUrl());
        if (content.getPicurl() != null && content.getPicurl().length() > 0) {
            subContent.put("picurl", String.valueOf(WeChatGlobal.getProperty("DOMAIN")) + content.getPicurl());
        }
        if (content.getUrl() != null && content.getUrl().length() > 0) {
            if (!content.isVerify()) {
                subContent.put("url", String.valueOf(WeChatGlobal.getProperty("DOMAIN")) + content.getUrl());
            } else {
                String redirectUrl = String.valueOf(WeChatGlobal.getProperty("DOMAIN")) + content.getUrl();
                try {
                    redirectUrl = URLEncoder.encode(redirectUrl, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
                String corpid = WeChatGlobal.getProperty("corpid");
                String weChaturl = "https://open.weixin.qq.com/connect/oauth2/authorize?appid=" + corpid + "&redirect_uri=" + redirectUrl + "&response_type=code&scope=snsapi_base&state=wechatverify#wechat_redirect";
                subContent.put("url", weChaturl);
            }
        }
        if (this.news == null) {
            this.news = new HashMap<String, List<HashMap<String, String>>>();
            contentMap = new ArrayList<HashMap<String, String>>();
            contentMap.add(subContent);
            this.news.put("articles", contentMap);
        } else {
            contentMap = this.news.get("articles");
            contentMap.add(subContent);
        }
    }

    public void setNews(List<WeChatNewsContent> newsContent) {
        List<HashMap<String, String>> contentMap;
        if (this.news == null) {
            this.news = new HashMap<String, List<HashMap<String, String>>>();
            contentMap = new ArrayList<HashMap<String, String>>();
            this.news.put("articles", contentMap);
        } else {
            contentMap = this.news.get("articles");
        }
        for (WeChatNewsContent content : newsContent) {
            HashMap<String, String> subContent = new HashMap<String, String>();
            subContent.put("title", content.getTitle());
            subContent.put("description", content.getDescription());
            subContent.put("url", content.getUrl());
            if (content.getPicurl() != null && content.getPicurl().length() > 0) {
                subContent.put("picurl", String.valueOf(WeChatGlobal.getProperty("DOMAIN")) + content.getPicurl());
            }
            if (content.getUrl() != null && content.getUrl().length() > 0) {
                if (!content.isVerify()) {
                    subContent.put("url", String.valueOf(WeChatGlobal.getProperty("DOMAIN")) + content.getUrl());
                } else {
                    String redirectUrl = String.valueOf(WeChatGlobal.getProperty("DOMAIN")) + content.getUrl();
                    try {
                        redirectUrl = URLEncoder.encode(redirectUrl, "UTF-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                    String corpid = WeChatGlobal.getProperty("corpid");
                    String weChaturl = "https://open.weixin.qq.com/connect/oauth2/authorize?appid=" + corpid + "&redirect_uri=" + redirectUrl + "&response_type=code&scope=snsapi_base&state=wechatverify#wechat_redirect";
                    subContent.put("url", weChaturl);
                }
            }
            contentMap.add(subContent);
        }
    }
}

