/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.workflow.service;

import com.sdjxd.pms.platform.base.BaseClass;
import com.sdjxd.pms.platform.base.DataModify;
import com.sdjxd.pms.platform.organize.User;
import com.sdjxd.pms.platform.tool.DateTool;
import com.sdjxd.pms.platform.tool.Guid;
import com.sdjxd.pms.platform.webapp.BeanFactory;
import com.sdjxd.pms.platform.workflow.dao.WaitDoDao;
import com.sdjxd.pms.platform.workflow.ext.IWaitDoExt;

public class WaitDo
extends BaseClass {
    private static final long serialVersionUID = 1L;
    protected static WaitDoDao dao = null;
    private static IWaitDoExt waitDoExtImpl = (IWaitDoExt)BeanFactory.getClass("IWaitDoExt");
    private String id;
    private String operId;
    private String operName;
    private String operUrl;
    private String sender;
    private int receiverType;
    private String receiver;
    private String resLimit;
    private String operContent;
    private String sendTime;
    private String openType;
    private DataModify modify;
    private String moduleId;
    private String oper1;
    private String oper2;
    private String oper3;
    public static final int ACTOR_USER = 0;
    public static final int ACTOR_ROLE = 1;
    public static final int ACTOR_DEPT = 2;
    public static final int ACTOR_COM = 3;
    public static final int ACTOR_ALL = 4;

    static {
        dao = WaitDoDao.createInstance();
    }

    protected WaitDo() {
    }

    public static WaitDo create(String operId, String operName, String operUrl, String sender, int receiverType, String receiver, String resLimit, String operContent, String openType) throws Exception {
        WaitDo pending = new WaitDo();
        pending.id = Guid.create();
        pending.operId = operId;
        pending.operName = operName;
        pending.operUrl = operUrl;
        pending.sender = sender;
        pending.receiverType = receiverType;
        pending.receiver = receiver;
        pending.resLimit = resLimit;
        pending.setOperContent(operContent);
        pending.sendTime = DateTool.getNow();
        pending.modify = DataModify.NEW;
        pending.setOpenType(openType);
        return pending;
    }

    public void save() throws Exception {
        if (waitDoExtImpl != null) {
            waitDoExtImpl.beforeSave(this);
        }
        dao.saveWaitDo(this);
        if (waitDoExtImpl != null) {
            waitDoExtImpl.afterSave(this);
        }
    }

    public static WaitDo delete(String operId) throws Exception {
        WaitDo pending = new WaitDo();
        pending.operId = operId;
        pending.modify = DataModify.DELETE;
        return pending;
    }

    public static WaitDo delete(String operId, String userId) throws Exception {
        WaitDo pending = new WaitDo();
        pending.operId = operId;
        pending.receiver = userId;
        pending.modify = DataModify.DELETE;
        return pending;
    }

    public static WaitDo deleteOther(String operId, String userId) throws Exception {
        WaitDo pending = new WaitDo();
        pending.operId = operId;
        pending.receiver = userId;
        pending.modify = DataModify.DELETEOTHER;
        return pending;
    }

    public static int countWaitDo() throws Exception {
        User user = User.getCurrentUser();
        if (user != null) {
            return dao.countWaitDo(User.getCurrentUser().getId());
        }
        return 0;
    }

    public void delete() throws Exception {
        this.modify = DataModify.DELETE;
    }

    public String getId() {
        return this.id;
    }

    public String getOperContent() {
        return this.operContent;
    }

    public String getOperId() {
        return this.operId;
    }

    public String getOperName() {
        return this.operName;
    }

    public String getOperUrl() {
        return this.operUrl;
    }

    public String getReceiver() {
        return this.receiver;
    }

    public int getReceiverType() {
        return this.receiverType;
    }

    public String getResLimit() {
        return this.resLimit;
    }

    public String getSender() {
        return this.sender;
    }

    public String getSendTime() {
        return this.sendTime;
    }

    public DataModify getModify() {
        return this.modify;
    }

    public void setOperContent(String operContent) {
        this.operContent = operContent == null ? "" : operContent;
    }

    public String getOpenType() {
        return this.openType;
    }

    public void setOpenType(String openType) {
        this.openType = openType;
    }

    public String getModuleId() {
        return this.moduleId;
    }

    public void setModuleId(String moduleId) {
        this.moduleId = moduleId;
    }

    public String getOper1() {
        return this.oper1;
    }

    public void setOper1(String oper1) {
        this.oper1 = oper1;
    }

    public String getOper2() {
        return this.oper2;
    }

    public void setOper2(String oper2) {
        this.oper2 = oper2;
    }

    public String getOper3() {
        return this.oper3;
    }

    public void setOper3(String oper3) {
        this.oper3 = oper3;
    }
}

