/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.workflow.service;

import com.sdjxd.pms.platform.base.BaseClass;
import com.sdjxd.pms.platform.base.Context;
import com.sdjxd.pms.platform.base.Global;
import com.sdjxd.pms.platform.tool.BeanTool;
import com.sdjxd.pms.platform.workflow.model.FlowCellBean;
import com.sdjxd.pms.platform.workflow.model.FlowTransBean;
import com.sdjxd.pms.platform.workflow.service.FlowCondition;
import com.sdjxd.pms.platform.workflow.service.FlowInstance;
import com.sdjxd.pms.platform.workflow.service.FlowNode;
import com.sdjxd.pms.platform.workflow.service.FlowNodeInstance;
import java.util.ArrayList;
import java.util.List;

public class FlowTrans
extends BaseClass {
    private static final long serialVersionUID = 1L;
    private int id;
    private int type;
    private static final int TYPE_NORMAL = 0;
    private static final int TYPE_UNTREAD = 1;
    private FlowNode from;
    private int fromNodeId;
    private FlowNode to;
    private int toNodeId;
    private FlowCondition condition;
    private boolean canUntread;

    public void load(FlowTransBean model) {
        this.id = model.getId();
        this.type = model.getType();
        this.canUntread = model.isCanUntread();
        this.fromNodeId = model.getFrom();
        this.toNodeId = model.getTo();
    }

    public boolean isEnabled(FlowInstance instance) {
        if (this.condition == null) {
            return true;
        }
        return this.condition.isEnabled(instance);
    }

    public String draw(FlowCellBean cell, FlowInstance flowInstance) throws Exception {
        String isHideConditionText;
        if (cell == null) {
            return null;
        }
        if (flowInstance == null) {
            return this.draw(cell);
        }
        StringBuffer output = new StringBuffer();
        int x1 = cell.getX1();
        int y1 = cell.getY1();
        int x2 = cell.getX2();
        int y2 = cell.getY2();
        int x3 = cell.getX3();
        int y3 = cell.getY3();
        List toNodeInstances = flowInstance.getNodeInstance(this.to);
        int toNodeLen = toNodeInstances.size();
        boolean passed = false;
        int i = 0;
        while (i < toNodeLen) {
            FlowNodeInstance toInstance = (FlowNodeInstance)toNodeInstances.get(i);
            passed = toInstance.isPreNode(this.from);
            if (passed) break;
            ++i;
        }
        List fromNodeInstances = flowInstance.getNodeInstance(this.from);
        int fromNodeLen = fromNodeInstances.size();
        boolean untread = false;
        int i2 = 0;
        while (i2 < fromNodeLen) {
            FlowNodeInstance fromInstance = (FlowNodeInstance)fromNodeInstances.get(i2);
            untread = fromInstance.isPreNode(this.to);
            if (untread) break;
            ++i2;
        }
        String wayPoint = cell.getWayPoint();
        String transStatus = "#5555dd";
        if (this.type == 1 && passed || this.type == 0 && untread) {
            transStatus = "red";
        } else if (this.type == 0 && passed) {
            transStatus = "green";
        } else if (this.type == 1 && !passed && Global.getContext() instanceof Context) {
            String isShowUntreadLine = Global.getContext().getParameter("isShowUntreadLine");
            if ("true".equals(isShowUntreadLine)) {
                transStatus = "#5555dd";
            } else {
                return "";
            }
        }
        ArrayList<int[]> allPoints = new ArrayList<int[]>();
        ArrayList<int[]> linePoints = new ArrayList<int[]>();
        allPoints.add(new int[]{x1, y1});
        linePoints.add(new int[]{x1, y1});
        if (wayPoint != null && wayPoint.length() != 0) {
            String[] wayPoints = wayPoint.split("@");
            int i3 = 0;
            while (i3 < wayPoints.length) {
                String[] point = wayPoints[i3].split(",");
                allPoints.add(new int[]{Integer.parseInt(point[0]), Integer.parseInt(point[1])});
                linePoints.add(new int[]{Integer.parseInt(point[0]), Integer.parseInt(point[1])});
                ++i3;
            }
        }
        allPoints.add(new int[]{x2, y2});
        linePoints.add(new int[]{x3, y3});
        output.append("<script>LineByDiv(").append(BeanTool.toJson(linePoints)).append(",").append(BeanTool.toJson(transStatus)).append(",2").append(",'end');</script>");
        String conditionName = this.getName();
        if (conditionName != null && conditionName.length() != 0 && !"1".equals(isHideConditionText = Global.getContext().getParameter("h_hideConditionText"))) {
            int countY;
            int countX;
            int count = allPoints.size();
            if (count % 2 == 0) {
                countX = (((int[])allPoints.get(count / 2 - 1))[0] + ((int[])allPoints.get(count / 2))[0]) / 2;
                countY = (((int[])allPoints.get(count / 2 - 1))[1] + ((int[])allPoints.get(count / 2))[1]) / 2;
            } else {
                countX = ((int[])allPoints.get(count / 2))[0];
                countY = ((int[])allPoints.get(count / 2))[1];
            }
            output.append("<div nowrap  style='font-size:12px;position:absolute;left:");
            output.append(countX - conditionName.getBytes().length * 3);
            output.append("px;top:").append(countY - 12).append("px'>");
            output.append(conditionName);
            output.append("</div>");
        }
        return output.toString();
    }

    public String draw(FlowCellBean cell) throws Exception {
        if (cell == null) {
            return null;
        }
        StringBuffer output = new StringBuffer();
        int x1 = cell.getX1();
        int y1 = cell.getY1();
        int x2 = cell.getX2();
        int y2 = cell.getY2();
        int x3 = cell.getX3();
        int y3 = cell.getY3();
        boolean passed = false;
        boolean untread = false;
        String wayPoint = cell.getWayPoint();
        String transStatus = "#5555dd";
        if (this.type == 1 || untread) {
            transStatus = "red";
        } else if (passed) {
            transStatus = "green";
        }
        ArrayList<int[]> allPoints = new ArrayList<int[]>();
        ArrayList<int[]> linePoints = new ArrayList<int[]>();
        allPoints.add(new int[]{x1, y1});
        linePoints.add(new int[]{x1, y1});
        if (wayPoint != null && wayPoint.length() != 0) {
            String[] wayPoints = wayPoint.split("@");
            int i = 0;
            while (i < wayPoints.length) {
                String[] point = wayPoints[i].split(",");
                allPoints.add(new int[]{Integer.parseInt(point[0]), Integer.parseInt(point[1])});
                linePoints.add(new int[]{Integer.parseInt(point[0]), Integer.parseInt(point[1])});
                ++i;
            }
        }
        allPoints.add(new int[]{x2, y2});
        linePoints.add(new int[]{x3, y3});
        output.append("<script>LineByDiv(").append(BeanTool.toJson(linePoints)).append(",").append(BeanTool.toJson(transStatus)).append(",2").append(",'end');</script>");
        String conditionName = this.getName();
        if (conditionName != null && conditionName.length() != 0) {
            int countY;
            int countX;
            int count = allPoints.size();
            if (count % 2 == 0) {
                countX = (((int[])allPoints.get(count / 2 - 1))[0] + ((int[])allPoints.get(count / 2))[0]) / 2;
                countY = (((int[])allPoints.get(count / 2 - 1))[1] + ((int[])allPoints.get(count / 2))[1]) / 2;
            } else {
                countX = ((int[])allPoints.get(count / 2))[0];
                countY = ((int[])allPoints.get(count / 2))[1];
            }
            output.append("<div nowrap  style='font-size:12px;position:absolute;left:");
            output.append(countX - conditionName.getBytes().length * 3);
            output.append(";top:").append(countY - 12).append("'>");
            output.append(conditionName);
            output.append("</div>");
        }
        return output.toString();
    }

    public void setCondition(FlowCondition condition) {
        this.condition = condition;
    }

    public FlowNode getFrom() {
        return this.from;
    }

    public void setFrom(FlowNode from) {
        if (from != null) {
            this.from = from;
        }
    }

    public FlowNode getTo() {
        return this.to;
    }

    public void setTo(FlowNode to) {
        if (to != null) {
            this.to = to;
        }
    }

    public FlowNode submit(FlowInstance flowInstance) throws Exception {
        if (this.isEnabled(flowInstance)) {
            return this.to;
        }
        return null;
    }

    public String getName() {
        if (this.condition != null) {
            return this.condition.getName();
        }
        return null;
    }

    public int getId() {
        return this.id;
    }

    public String toJson() {
        return String.valueOf(this.toNodeId);
    }

    public boolean isUntread() {
        return this.type == 1;
    }

    public boolean isCanUntread() {
        return this.canUntread;
    }
}

