/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.workflow.service;

import com.sdjxd.pms.platform.base.BaseClass;
import com.sdjxd.pms.platform.base.DataModify;
import com.sdjxd.pms.platform.workflow.dao.FlowInstanceDao;
import com.sdjxd.pms.platform.workflow.model.FlowReceiverBean;
import java.util.Date;

public class FlowReceiver
extends BaseClass {
    private static final long serialVersionUID = 1L;
    protected static FlowInstanceDao dao = FlowInstanceDao.createInstance();
    private String FlowInstanceId;
    private int nodeInstanceId;
    private String operatorId;
    private String operatorName;
    private Date beginTime;
    private Date endTime;
    private int type;
    public static int TYPE_NORMAL = 0;
    public static int TYPE_AGENT = 1;
    public static int TYPE_DELEGATE = 2;
    public static int TYPE_HELP = 3;
    private DataModify dataModify;
    private FlowReceiverBean model;

    public FlowReceiver() {
    }

    public FlowReceiver(FlowReceiverBean model) {
        this();
        this.load(model);
    }

    public void load(FlowReceiverBean model) {
        this.model = model;
        this.FlowInstanceId = model.getFlowInstanceId();
        this.beginTime = model.getBeginTime();
        this.endTime = model.getEndTime();
        this.nodeInstanceId = model.getNodeInstanceId();
        this.operatorId = model.getOperatorId();
        this.operatorName = model.getOperatorName();
        this.type = model.getType();
        this.dataModify = DataModify.SAVED;
    }

    public static FlowReceiver create(FlowReceiverBean model) {
        FlowReceiver operator = new FlowReceiver(model);
        operator.dataModify = DataModify.NEW;
        return operator;
    }

    public String getOperatorId() {
        return this.operatorId;
    }

    public void save(boolean sumbiting) throws Exception {
        if (!this.dataModify.is(DataModify.SAVED)) {
            this.model.setFlowInstanceId(this.FlowInstanceId);
            this.model.setBeginTime(this.beginTime);
            if (sumbiting) {
                this.model.setEndTime(this.endTime);
            }
            this.model.setNodeInstanceId(this.nodeInstanceId);
            this.model.setOperatorId(this.operatorId);
            this.model.setOperatorName(this.operatorName);
            this.model.setType(this.type);
            dao.saveNodeInstanceReceiver(this.model, this.dataModify);
        }
        this.dataModify = DataModify.SAVED;
    }

    public void delete() {
        this.dataModify = DataModify.DELETE;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
        if (this.dataModify.equals(DataModify.SAVED)) {
            this.dataModify = DataModify.MODIFY;
        }
    }

    public Date getBeginTime() {
        return this.beginTime;
    }

    public void setBeginTime(Date beginTime) {
        this.beginTime = beginTime;
        if (this.dataModify.equals(DataModify.SAVED)) {
            this.dataModify = DataModify.MODIFY;
        }
    }

    public String getOperatorName() {
        return this.operatorName;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public int getType() {
        return this.type;
    }
}

