/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.workflow.service;

import com.sdjxd.pms.platform.base.BaseClass;
import com.sdjxd.pms.platform.tool.BeanTool;
import com.sdjxd.pms.platform.workflow.model.FlowParameterBean;
import com.sdjxd.pms.platform.workflow.service.FlowInstance;

public class FlowParameter
extends BaseClass {
    private static final long serialVersionUID = 1L;
    private int id;
    private String name;
    private int type;
    public static final int TYPE_STRING = 0;
    public static final int TYPE_INT = 1;
    public static final int TYPE_DOUBLE = 2;
    public static final int TYPE_BOOL = 3;
    public static final int TYPE_OBJ = 4;
    public static final int TYPE_ARRAY = 5;
    private Object value;
    private String formVariable;
    private int formVariableId;
    private int formId;
    private int varType;
    private int formParamId;
    private int paramFormId;

    public void load(FlowParameterBean model) {
        this.id = model.getId();
        this.name = model.getName();
        this.type = model.getType();
        this.value = model.getValue();
        this.formVariable = model.getFormVariable();
        this.formVariableId = model.getFormVariableId();
        this.formId = model.getFormId();
        this.varType = model.getVarType();
        this.formParamId = model.getFormParamId();
        this.paramFormId = model.getParamFormId();
    }

    public Object convert(Object parameterValue) throws Exception {
        Object value = null;
        try {
            switch (this.type) {
                case 0: {
                    if (parameterValue != null) {
                        value = parameterValue.toString();
                    }
                    break;
                }
                case 1: {
                    if (parameterValue != null) {
                        value = new Integer(parameterValue.toString());
                        break;
                    }
                    value = new Integer(0);
                    break;
                }
                case 2: {
                    if (parameterValue != null) {
                        value = new Double(parameterValue.toString());
                        break;
                    }
                    value = new Double(0.0);
                    break;
                }
                case 3: {
                    if (parameterValue != null) {
                        value = new Boolean(parameterValue.toString());
                        break;
                    }
                    value = new Boolean(false);
                    break;
                }
                case 5: {
                    if (parameterValue != null) {
                        if (parameterValue instanceof String) {
                            value = BeanTool.parse(parameterValue.toString());
                            break;
                        }
                        if (parameterValue.getClass().isArray()) {
                            value = parameterValue;
                        }
                    }
                    break;
                }
                default: {
                    value = parameterValue;
                    break;
                }
            }
        }
        catch (Exception exp) {
            throw new Exception("\u53c2\u6570\u503c\u7684\u7c7b\u578b\u4e0e\u53c2\u6570\u5b9a\u4e49\u4e0d\u76f8\u7b26\uff01\u53c2\u6570\u7c7b\u578b\u5e94\u4e3a\uff1a" + this.type);
        }
        return value;
    }

    public int getId() {
        return this.id;
    }

    public String getFormVariable() {
        return this.formVariable;
    }

    public String getName() {
        return this.name;
    }

    public Object getValue() {
        return this.value;
    }

    public Object getValue(FlowInstance flowInstance) throws Exception {
        return this.convert(flowInstance.getParameter(this.name));
    }

    public int getFormVariableId() {
        return this.formVariableId;
    }

    public int getFormId() {
        return this.formId;
    }

    public int getVarType() {
        return this.varType;
    }

    public int getFormParamId() {
        return this.formParamId;
    }

    public int getParamFormId() {
        return this.paramFormId;
    }

    public static final class defaultParameter {
        public static final String NAME = "NAME";
        public static final String STARTTIME = "STARTTIME";
        public static final String ENDTIME = "ENDTIME";
        public static final String STARTUSER = "STARTUSER";
        public static final String CURRENTFORMINSTANCEID = "CURRENTFORMINSTANCEID";
        public static final String CURRENTNODEID = "CURRENTNODEID";
    }
}

