/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.workflow.service;

import com.sdjxd.pms.platform.base.BaseClass;
import com.sdjxd.pms.platform.base.DataModify;
import com.sdjxd.pms.platform.tool.StringTool;
import com.sdjxd.pms.platform.workflow.dao.FlowInstanceDao;
import com.sdjxd.pms.platform.workflow.model.FlowParamInstanceBean;
import com.sdjxd.pms.platform.workflow.service.FlowNodeInstance;
import java.util.Map;
import org.apache.log4j.Logger;

public class FlowParamInstance
extends BaseClass {
    private static final long serialVersionUID = 1L;
    static Logger log = Logger.getLogger(FlowNodeInstance.class);
    protected static FlowInstanceDao dao = FlowInstanceDao.createInstance();
    private String flowInstanceId;
    private String paramName;
    private String paramValue;
    private DataModify dataModify;

    public void load(FlowParamInstanceBean model) {
        this.flowInstanceId = model.getFlowInstanceId();
        this.paramName = model.getParamName();
        this.paramValue = model.getParamValue();
        this.dataModify = DataModify.SAVED;
    }

    public static FlowParamInstance create(String flowInstanceId, String paramName, Object paramValue) {
        FlowParamInstance paramInstance = new FlowParamInstance();
        FlowParamInstanceBean model = new FlowParamInstanceBean();
        model.setFlowInstanceId(flowInstanceId);
        model.setParamName(paramName);
        paramInstance.load(model);
        paramInstance.dataModify = DataModify.NEW;
        paramInstance.setParamValue(paramValue);
        return paramInstance;
    }

    public String getFlowInstanceId() {
        return this.flowInstanceId;
    }

    public String getParamName() {
        return this.paramName;
    }

    public Object getParamValue() {
        return this.paramValue;
    }

    public String replace(String str) {
        if (str != null) {
            if (this.paramValue != null) {
                return StringTool.replace(str, "[flow.param." + this.paramName + "]", this.paramValue);
            }
            return StringTool.replace(str, "[flow.param." + this.paramName + "]", "");
        }
        return "";
    }

    public static String replace(String str, Map params) {
        String ostr = str;
        for (Map.Entry entry : params.entrySet()) {
            FlowParamInstance flowParamInstance = (FlowParamInstance)entry.getValue();
            ostr = flowParamInstance.replace(ostr);
        }
        return ostr;
    }

    public void setParamValue(Object paramValue) {
        this.paramValue = paramValue == null ? null : (String)paramValue;
        if (this.dataModify.is(DataModify.SAVED)) {
            this.dataModify = DataModify.MODIFY;
        }
    }

    public void save() throws Exception {
        if (!this.dataModify.is(DataModify.SAVED)) {
            FlowParamInstanceBean model = new FlowParamInstanceBean();
            model.setFlowInstanceId(this.flowInstanceId);
            model.setParamName(this.paramName);
            model.setParamValue(this.paramValue);
            dao.saveParamInstance(model, this.dataModify);
        }
        this.dataModify = DataModify.SAVED;
    }
}

