/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.workflow.service;

import com.sdjxd.pms.platform.base.BaseClass;
import com.sdjxd.pms.platform.base.BaseObject;
import com.sdjxd.pms.platform.base.Global;
import com.sdjxd.pms.platform.data.DbOper;
import com.sdjxd.pms.platform.data.DbSession;
import com.sdjxd.pms.platform.organize.Organize;
import com.sdjxd.pms.platform.organize.Role;
import com.sdjxd.pms.platform.organize.User;
import com.sdjxd.pms.platform.workflow.model.FlowOperatorBean;
import com.sdjxd.pms.platform.workflow.model.FlowReceiverBean;
import com.sdjxd.pms.platform.workflow.service.FlowNodeInstance;
import com.sdjxd.pms.platform.workflow.service.FlowOperator;
import com.sdjxd.pms.platform.workflow.service.FlowReceiver;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class FlowOperatorManager
extends BaseClass {
    private static final long serialVersionUID = 1L;
    private Map receivers;
    private HashMap<String, FlowOperator> operators;
    private String flowInstanceId;
    private int nodeInstanceId;
    private FlowNodeInstance flowNodeInstance;

    public FlowOperatorManager(FlowNodeInstance flowNodeInstance) {
        this.flowInstanceId = flowNodeInstance.getFlowInstanceId();
        this.nodeInstanceId = flowNodeInstance.getNodeInstanceId();
        this.operators = new HashMap();
        this.receivers = new HashMap();
        this.flowNodeInstance = flowNodeInstance;
    }

    private void addReceiver(FlowReceiver operator) {
        Object object;
        if (operator != null && (object = this.receivers.get(operator.getOperatorId())) == null) {
            this.receivers.put(operator.getOperatorId(), operator);
        }
    }

    public void addOperator(FlowOperator operator) {
        FlowOperator object;
        if (operator != null && (object = this.operators.get(operator.getOperatorId())) == null) {
            this.operators.put(operator.getOperatorId(), operator);
        }
    }

    public void loadReceiver(List list) {
        if (list != null) {
            int i = 0;
            while (i < list.size()) {
                FlowReceiver operator = new FlowReceiver();
                operator.load((FlowReceiverBean)list.get(i));
                this.addReceiver(operator);
                ++i;
            }
        }
    }

    public void loadOperator(List list) {
        if (list != null) {
            int i = 0;
            while (i < list.size()) {
                FlowOperator operator = new FlowOperator();
                operator.load((FlowOperatorBean)list.get(i));
                this.addOperator(operator);
                ++i;
            }
        }
    }

    public void execTask() throws Exception {
        FlowOperator operator = this.getCurrentOperator();
        if (operator != null) {
            operator.setBeginTime(this.flowNodeInstance.getBeginTime());
        }
    }

    public void addReceiver(BaseObject receiver, int type) throws Exception {
        FlowReceiverBean model = new FlowReceiverBean();
        model.setFlowInstanceId(this.flowInstanceId);
        model.setNodeInstanceId(this.nodeInstanceId);
        model.setOperatorId(receiver.getId());
        model.setOperatorName(receiver.getName());
        model.setType(type);
        FlowReceiver operator = FlowReceiver.create(model);
        this.addReceiver(operator);
    }

    public FlowOperator addOperator(BaseObject operator) {
        FlowOperatorBean model = new FlowOperatorBean();
        model.setFlowInstanceId(this.flowInstanceId);
        model.setNodeInstanceId(this.nodeInstanceId);
        model.setOperatorId(operator.getId());
        model.setOperatorName(operator.getName());
        FlowOperator fo = FlowOperator.create(model);
        this.addOperator(fo);
        return fo;
    }

    public void delegateReceiver(String receiver) throws Exception {
        FlowReceiver operator = (FlowReceiver)this.receivers.get(receiver);
        if (operator != null && operator.getType() == FlowReceiver.TYPE_NORMAL) {
            operator.delete();
        }
    }

    public void callbackReceiver(String receiver) throws Exception {
        FlowReceiver operator = (FlowReceiver)this.receivers.get(receiver);
        if (operator != null && operator.getType() == FlowReceiver.TYPE_DELEGATE) {
            operator.delete();
        }
    }

    public void addReceiver(FlowOperator operator) {
        FlowReceiverBean model = new FlowReceiverBean();
        model.setFlowInstanceId(this.flowInstanceId);
        model.setNodeInstanceId(this.nodeInstanceId);
        model.setOperatorId(operator.getOperatorId());
        model.setOperatorName(operator.getOperatorName());
        model.setType(0);
        FlowReceiver newOperator = FlowReceiver.create(model);
        this.addReceiver(newOperator);
    }

    public void save(boolean sumbiting) throws Exception {
        DbSession session = DbOper.openDb("defaultds");
        try {
            try {
                for (Map.Entry entry : this.receivers.entrySet()) {
                    FlowReceiver receiver = (FlowReceiver)entry.getValue();
                    receiver.save(sumbiting);
                }
                for (Map.Entry<Object, Object> entry : this.operators.entrySet()) {
                    FlowOperator operator = (FlowOperator)entry.getValue();
                    operator.save(sumbiting);
                }
                DbOper.commitDb(session);
            }
            catch (Exception exp) {
                DbOper.rollbackDb(session);
                throw exp;
            }
        }
        finally {
            DbOper.closeDb(session);
        }
    }

    public FlowOperator getCurrentOperator() {
        FlowReceiver operator = null;
        FlowOperator currentOperator = null;
        User currentUser = User.getCurrentUser();
        boolean checkLimit = false;
        if (currentUser != null) {
            String currentUserId = currentUser.getId();
            Iterator it = this.receivers.entrySet().iterator();
            while (!checkLimit && it.hasNext()) {
                Map.Entry entry = it.next();
                operator = (FlowReceiver)entry.getValue();
                if (operator == null || operator.getEndTime() != null) continue;
                switch (operator.getType()) {
                    case 2: {
                        if (!Organize.isMember(operator.getOperatorId(), currentUserId)) break;
                        checkLimit = true;
                        break;
                    }
                    case 1: {
                        if (!Role.isMember(operator.getOperatorId(), currentUserId)) break;
                        checkLimit = true;
                        break;
                    }
                    case 0: {
                        if (!User.isCurrent(operator.getOperatorId())) break;
                        checkLimit = true;
                    }
                }
            }
            if (checkLimit) {
                if (this.operators.containsKey(currentUserId)) {
                    currentOperator = this.operators.get(currentUserId);
                    if (currentOperator != null && currentOperator.getEndTime() != null) {
                        currentOperator = null;
                    }
                } else {
                    currentOperator = this.addOperator(currentUser);
                }
            }
        }
        return currentOperator;
    }

    public void callBackOperator() {
        for (Map.Entry<String, FlowOperator> entry : this.operators.entrySet()) {
            FlowOperator operator = entry.getValue();
            if (!User.isCurrent(operator.getOperatorId())) continue;
            operator.setEndTime(null);
            break;
        }
    }

    public int count() {
        return this.operators.size();
    }

    public int countReceiver() {
        return this.receivers.size();
    }

    public int complet() {
        int count = 0;
        for (Map.Entry<String, FlowOperator> entry : this.operators.entrySet()) {
            FlowOperator model = entry.getValue();
            if (model.getEndTime() == null) continue;
            ++count;
        }
        return count;
    }

    public HashMap<String, FlowOperator> getOperators() {
        HashMap<String, FlowOperator> operators = new HashMap<String, FlowOperator>();
        for (Map.Entry<String, FlowOperator> entry : this.operators.entrySet()) {
            FlowOperator operator = entry.getValue();
            if (operator == null || operator.getBeginTime() == null || operator.getEndTime() == null) continue;
            operators.put(operator.getOperatorId(), operator);
        }
        return operators;
    }

    public String getReceiversNameString() {
        StringBuffer operators = new StringBuffer();
        for (Map.Entry entry : this.receivers.entrySet()) {
            FlowReceiver operator = (FlowReceiver)entry.getValue();
            if (operator == null) continue;
            operators.append(",").append(operator.getOperatorName());
        }
        if (operators.length() > 0) {
            return operators.substring(1);
        }
        return "";
    }

    public String getOperatorsNameString() {
        StringBuffer operators = new StringBuffer();
        for (Map.Entry<String, FlowOperator> entry : this.operators.entrySet()) {
            FlowOperator operator = entry.getValue();
            if (operator == null) continue;
            operators.append(",").append(operator.getOperatorName());
        }
        if (operators.length() > 0) {
            return operators.substring(1);
        }
        return "";
    }

    public String getOperatorEndNameString() {
        StringBuffer operators = new StringBuffer();
        for (Map.Entry<String, FlowOperator> entry : this.operators.entrySet()) {
            FlowOperator operator = entry.getValue();
            if (operator == null || operator.getBeginTime() == null || operator.getEndTime() == null) continue;
            operators.append(",").append(operator.getOperatorName());
        }
        if (operators.length() > 0) {
            return operators.substring(1);
        }
        return "";
    }

    public Map getReceivers() {
        return this.receivers;
    }

    public boolean checkLimit(String currentUserId) {
        FlowReceiver operator = null;
        boolean checkLimit = false;
        Iterator it = this.receivers.entrySet().iterator();
        while (!checkLimit && it.hasNext()) {
            Map.Entry entry = it.next();
            operator = (FlowReceiver)entry.getValue();
            if (operator == null || operator.getEndTime() != null) continue;
            switch (operator.getType()) {
                case 2: {
                    if (!Organize.isMember(operator.getOperatorId(), currentUserId)) break;
                    checkLimit = true;
                    break;
                }
                case 1: {
                    if (!Role.isMember(operator.getOperatorId(), currentUserId)) break;
                    checkLimit = true;
                    break;
                }
                case 0: {
                    if (!User.isCurrent(operator.getOperatorId())) break;
                    checkLimit = true;
                }
            }
        }
        return checkLimit;
    }

    public boolean hasSubmitPermission(String currentUserId) {
        String timerUserId;
        boolean hasPermission = this.checkLimit(currentUserId);
        if (!hasPermission && Global.getContext() == null && currentUserId.equals(timerUserId = Global.getConfig("timeruser"))) {
            hasPermission = true;
        }
        return hasPermission;
    }

    public boolean hasCallBackPermission(String currentUserId) {
        String timerUserId;
        boolean hasPermission = this.checkLimit(currentUserId);
        if (!hasPermission && Global.getContext() == null && currentUserId.equals(timerUserId = Global.getConfig("timeruser"))) {
            hasPermission = true;
        }
        return hasPermission;
    }

    public boolean hasEnd2RunPermission() {
        User currUser = User.getCurrentUser();
        boolean hasPermission = this.checkLimit(currUser.getId());
        return hasPermission;
    }
}

