/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.workflow.service;

import com.sdjxd.pms.platform.base.BaseObject;
import com.sdjxd.pms.platform.base.DataModify;
import com.sdjxd.pms.platform.data.DbOper;
import com.sdjxd.pms.platform.data.DbSession;
import com.sdjxd.pms.platform.form.service.Form;
import com.sdjxd.pms.platform.form.service.FormInstance;
import com.sdjxd.pms.platform.organize.Organize;
import com.sdjxd.pms.platform.organize.Role;
import com.sdjxd.pms.platform.organize.User;
import com.sdjxd.pms.platform.organize.model.UserBean;
import com.sdjxd.pms.platform.tool.BeanTool;
import com.sdjxd.pms.platform.tool.DateTool;
import com.sdjxd.pms.platform.tool.StringTool;
import com.sdjxd.pms.platform.workflow.bo.FlowWeChartBo;
import com.sdjxd.pms.platform.workflow.dao.FlowInstanceDao;
import com.sdjxd.pms.platform.workflow.model.FlowNodeInstanceBean;
import com.sdjxd.pms.platform.workflow.service.CounterSign;
import com.sdjxd.pms.platform.workflow.service.Flow;
import com.sdjxd.pms.platform.workflow.service.FlowDelegate;
import com.sdjxd.pms.platform.workflow.service.FlowForm;
import com.sdjxd.pms.platform.workflow.service.FlowFormInstance;
import com.sdjxd.pms.platform.workflow.service.FlowInstance;
import com.sdjxd.pms.platform.workflow.service.FlowInstanceSession;
import com.sdjxd.pms.platform.workflow.service.FlowNode;
import com.sdjxd.pms.platform.workflow.service.FlowNodeChild;
import com.sdjxd.pms.platform.workflow.service.FlowNodeEnd;
import com.sdjxd.pms.platform.workflow.service.FlowOperator;
import com.sdjxd.pms.platform.workflow.service.FlowOperatorManager;
import com.sdjxd.pms.platform.workflow.service.FlowReceiver;
import com.sdjxd.pms.platform.workflow.service.FlowWaitDo;
import com.sdjxd.pms.platform.workflow.service.HaveDo;
import com.sdjxd.pms.platform.workflow.service.WaitDo;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class FlowNodeInstance
extends BaseObject {
    private static final long serialVersionUID = 1L;
    static Logger log = Logger.getLogger(FlowNodeInstance.class);
    protected static FlowInstanceDao dao = FlowInstanceDao.createInstance();
    private int nodeInstanceId;
    private DataModify dataModify;
    private int runStatus;
    private int runStatusNoteStart;
    private int runStatusNoteStop;
    public static final int RUNSTATUSNODE_START_AUTO = 1;
    public static final int RUNSTATUSNODE_START_NORMAL = 2;
    public static final int RUNSTATUSNODE_START_UNTREAD = 3;
    public static final int RUNSTATUSNODE_START_CALLBACK = 4;
    public static final int RUNSTATUSNODE_STOP_AUTO = 5;
    public static final int RUNSTATUSNODE_STOP_NORMAL = 6;
    public static final int RUNSTATUSNODE_STOP_UNTREAD = 7;
    public static final int RUNSTATUSNODE_STOP_CALLBACK = 8;
    public static final int RUNSTATUSNODE_TERMINATE_NORMAL = 9;
    public static final int RUNSTATUSNODE_TERMINATE_UNTREAD = 10;
    public static final int RUNSTATUSNODE_TERMINATE_CALLBACK = 11;
    private int takeStatus;
    private Date beginTime;
    private Date endTime;
    private User createUser;
    private String flowInstanceId;
    private String flowId;
    private String flowName;
    private int flowNodeId;
    private String flowNodeName;
    private String statusName;
    private String statusId;
    private int[] preNodeInstanceIds;
    private List<Integer> nextNodeInstanceIds = new ArrayList<Integer>();
    private int vPreNodeInstanceId = -1;
    private int vNextNodeInstanceId = -1;
    private Date createTime;
    private Date overTime;
    private String openerId;
    private String openerName;
    private Date openerTime;
    private List waitDos = new ArrayList();
    private List haveDos = new ArrayList();
    private List flowWeChatDos;
    private List counterSigns = new ArrayList();
    private String untreadReason;
    private StringBuffer notes;
    private FlowOperatorManager operatorManager;
    private FlowNode templet;
    private FlowInstance owner;
    private FlowNodeInstanceBean model;
    private String isAutoDeal;
    private static final String BEFORE_CREATE = "beforestart";
    private static final String AFTER_CREATE = "afterstart";
    private static final String BEFORE_COMPLETE = "beforecomplete";
    private static final String AFTER_COMPLETE = "aftercomplete";
    private static final String AFTER_HAND = "afterhand";
    private static final String AFTER_RESUME = "afterresume";
    private List eventHandles = new ArrayList();
    private String showImage = "";
    private String tooltip = "";
    private boolean isCallBack = false;
    private TreeMap nodeEventInPicture = null;

    public boolean isCallBack() {
        return this.isCallBack;
    }

    public void setCallBack(boolean isCallBack) {
        this.isCallBack = isCallBack;
    }

    public FlowNodeInstance() {
        this.flowWeChatDos = new ArrayList();
    }

    public void load(FlowNodeInstanceBean model) throws Exception {
        if (model != null) {
            this.model = model;
            FlowNode templet = Flow.getFlow(model.getFlowId()).getNodeById(model.getFlowNodeId());
            if (templet == null) {
                throw new Exception("\u6d41\u7a0b\u6a21\u677f\u5df2\u88ab\u4fee\u6539\u6216\u8005\u5220\u9664\uff01");
            }
            this.setTemplet(templet);
            this.nodeInstanceId = model.getNodeInstanceId();
            this.runStatus = model.getRunStatus();
            this.runStatusNoteStart = model.getRunStatusNoteStart();
            this.runStatusNoteStop = model.getRunStatusNoteStop();
            this.takeStatus = model.getTakeStatus();
            this.beginTime = model.getBeginTime();
            this.overTime = model.getOverTime();
            this.endTime = model.getEndTime();
            this.createUser = User.getUser(model.getCreateUserId());
            this.flowInstanceId = model.getFlowInstanceId();
            this.flowId = model.getFlowId();
            this.flowName = model.getFlowName();
            this.flowNodeId = model.getFlowNodeId();
            this.flowNodeName = model.getFlowNodeName();
            this.createTime = model.getCreateTime();
            this.preNodeInstanceIds = model.getPreNodeInstanceIds();
            this.nextNodeInstanceIds = model.getNextNodeInstanceIds();
            this.vPreNodeInstanceId = model.getvPreNodeInstanceId();
            this.vNextNodeInstanceId = model.getvNextNodeInstanceId();
            this.statusName = model.getStatusName();
            this.statusId = this.templet.getStatusId();
            this.notes = new StringBuffer(model.getNotes());
            this.isAutoDeal = model.getIsAutoDeal();
            this.dataModify = DataModify.SAVED;
            this.operatorManager = new FlowOperatorManager(this);
        }
    }

    public static FlowNodeInstance create(FlowInstance flowInstance, FlowNode flowNode) throws Exception {
        FlowNodeInstance flowNodeInstance = new FlowNodeInstance();
        flowNodeInstance.model = new FlowNodeInstanceBean();
        flowNodeInstance.flowId = flowInstance.getFlowId();
        flowNodeInstance.flowName = flowInstance.getFlowName();
        flowNodeInstance.flowNodeId = flowNode.getId();
        flowNodeInstance.flowNodeName = flowNode.getName();
        flowNodeInstance.createTime = new Date();
        flowNodeInstance.statusName = flowNode.getStatusName();
        flowNodeInstance.nodeInstanceId = flowInstance.getFlowNodeInstanceSize();
        flowNodeInstance.dataModify = DataModify.NEW;
        flowNodeInstance.runStatus = 5;
        flowNodeInstance.takeStatus = 0;
        flowNodeInstance.setTemplet(flowNode);
        flowNodeInstance.owner = flowInstance;
        flowNodeInstance.statusId = flowNode.getStatusId();
        User user = User.getCurrentUser();
        flowNodeInstance.createUser = user != null ? user : new User();
        flowNodeInstance.flowInstanceId = flowInstance.getId();
        flowNodeInstance.preNodeInstanceIds = new int[0];
        flowNodeInstance.operatorManager = new FlowOperatorManager(flowNodeInstance);
        flowInstance.addFlowNodeInstance(flowNodeInstance);
        return flowNodeInstance;
    }

    public static void loadFlowNodeInstance(FlowInstance flowInstance) throws Exception {
        List list = dao.getFlowNodeInstance(flowInstance.getId());
        Map receiverMap = dao.getFlowReceiver(flowInstance.getId());
        Map operatorMap = dao.getFlowOperator(flowInstance.getId());
        int i = 0;
        while (i < list.size()) {
            List listOperator;
            FlowNodeInstanceBean model = (FlowNodeInstanceBean)list.get(i);
            FlowNodeInstance fni = new FlowNodeInstance();
            fni.load(model);
            fni.owner = flowInstance;
            fni.operatorManager = new FlowOperatorManager(fni);
            List listReceiver = (List)receiverMap.get(String.valueOf(model.getNodeInstanceId()));
            if (listReceiver != null && listReceiver.size() > 0) {
                fni.operatorManager.loadReceiver(listReceiver);
            }
            if ((listOperator = (List)operatorMap.get(String.valueOf(model.getNodeInstanceId()))) != null && listOperator.size() > 0) {
                fni.operatorManager.loadOperator(listOperator);
            }
            flowInstance.addFlowNodeInstance(fni);
            ++i;
        }
    }

    private void modify() {
        if (!this.dataModify.is(DataModify.NEW)) {
            this.dataModify = DataModify.MODIFY;
        }
    }

    public void startUpUntread() throws Exception {
        this.takeStatus = 4;
        this.startUp();
    }

    public void startUp() throws Exception {
        Map receiver = this.operatorManager.getReceivers();
        FlowInstance flowInstance = this.owner;
        if (!(!"7.2".equals(flowInstance.getVersion()) || this.templet instanceof FlowNodeEnd || this.templet instanceof FlowNodeChild || receiver != null && !receiver.isEmpty() || this.templet.isNoReciverDeal())) {
            throw new Exception("\u4e0b\u4e00\u8282\u70b9\u6ca1\u6709\u5904\u7406\u4eba");
        }
        this.eventHandles.add(BEFORE_CREATE);
        if (flowInstance.getRunStatus() == 0 && 5 == this.runStatus) {
            Map map = this.templet.getParameterValues();
            if (map != null && map.size() > 0) {
                for (Map.Entry entry : map.entrySet()) {
                    flowInstance.setParameter((String)entry.getKey(), entry.getValue());
                }
            }
            this.owner.setParameter("CURRENTNODEID", String.valueOf(this.nodeInstanceId));
            this.runStatus = 0;
            this.beginTime = DateTool.parseDate(DateTool.getNow());
            this.overTime = this.templet.getOverTime(flowInstance, this.beginTime);
            this.modify();
        }
        this.eventHandles.add(AFTER_CREATE);
    }

    public void complet() throws Exception {
        if (this.runStatus != 1) {
            this.eventHandles.add(BEFORE_COMPLETE);
            this.endTime = new Date();
            this.runStatus = 1;
            this.modify();
            this.addWaitDo(WaitDo.delete(this.getWaitDoId()));
            this.addFlowWeChatDo(FlowWeChartBo.delete(this.getFlowWeChartBo()));
            this.eventHandles.add(AFTER_COMPLETE);
        }
    }

    public void untread() throws Exception {
        this.modify();
        this.runStatus = 4;
        this.eventHandles.add("afteruntread");
    }

    public boolean callback() throws Exception {
        User user;
        this.endTime = null;
        this.runStatus = 0;
        this.takeStatus = 6;
        this.operatorManager.callBackOperator();
        this.addHaveDo(HaveDo.delete(this.getWaitDoId()));
        if (this.templet != null && this.templet.isPending() && (user = User.getCurrentUser()) != null) {
            this.addWaitDo(FlowWaitDo.create(this.templet, this.owner, this, 0, user.getId()));
        }
        this.eventHandles.add("aftercallback");
        this.modify();
        this.addNotes(DateTool.getNow());
        this.addNotes("\u88ab");
        if (User.getCurrentUser() != null) {
            this.addNotes(User.getCurrentUser().getName());
        }
        this.addNotes("\u64a4\u56de");
        this.addNotes("  ");
        return true;
    }

    public boolean checkLimit() throws Exception {
        if (this.owner.getRunStatus() != 0) {
            return false;
        }
        if (this.runStatus != 0) {
            return false;
        }
        if (this.templet instanceof FlowNodeEnd) {
            return true;
        }
        if (this.templet instanceof FlowNodeChild) {
            return false;
        }
        if (User.getCurrentUser() == null) {
            return true;
        }
        return this.operatorManager.getCurrentOperator() != null;
    }

    public TreeMap getFormLimit(int flowFormId) {
        return this.templet.getVariableLimit(flowFormId);
    }

    public boolean isInstance(FlowNode flowNode) {
        return false;
    }

    public String getWaitDoId() {
        return String.valueOf(this.flowInstanceId) + String.valueOf(this.nodeInstanceId);
    }

    public String getHaveDoId() {
        return String.valueOf(this.flowInstanceId) + String.valueOf(this.nodeInstanceId);
    }

    public Map<String, String> getFlowWeChartBo() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("flowInstanceId", this.flowInstanceId);
        map.put("nodeInstanceId", String.valueOf(this.nodeInstanceId));
        return map;
    }

    public Date getBeginTime() {
        return this.beginTime;
    }

    public int getvPreNodeInstanceId() {
        return this.vPreNodeInstanceId;
    }

    public void setvPreNodeInstanceId(int vPreNodeInstanceId) {
        this.modify();
        this.vPreNodeInstanceId = vPreNodeInstanceId;
    }

    public int getvNextNodeInstanceId() {
        return this.vNextNodeInstanceId;
    }

    public void setvNextNodeInstanceId(int vNextNodeInstanceId) {
        this.modify();
        this.vNextNodeInstanceId = vNextNodeInstanceId;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public int operatorCount() {
        return this.operatorManager.count();
    }

    public int receiverCount() {
        return this.operatorManager.countReceiver();
    }

    public int completCount() {
        return this.operatorManager.complet();
    }

    public int getNodeInstanceId() {
        return this.nodeInstanceId;
    }

    public User getCreateUser() {
        return this.createUser;
    }

    public String getCreateUserId() {
        if (this.createUser != null) {
            return this.createUser.getId();
        }
        return null;
    }

    public String getCreateUserName() {
        if (this.createUser != null) {
            return this.createUser.getName();
        }
        return null;
    }

    public void addOperator(FlowOperator model) {
        if (model != null) {
            this.operatorManager.addOperator(model);
        }
    }

    public boolean getIsAutoDeal() {
        return "1".equals(this.isAutoDeal);
    }

    public void setIsAutoDeal(String isAutoDeal) {
        this.isAutoDeal = isAutoDeal;
    }

    public void exec() throws Exception {
        if (this.templet.exec(this)) {
            this.operatorManager.execTask();
        }
    }

    public void addReceiver(BaseObject receiver, boolean isPending, int type) throws Exception {
        this.operatorManager.addReceiver(receiver, type);
        if (isPending) {
            this.addWaitDo(FlowWaitDo.create(this.templet, this.owner, this, type, receiver.getId()));
            if (!this.isCallBack()) {
                this.addFlowWeChatDo(FlowWeChartBo.createFlowWeChart(this.templet, this.owner, this, type, receiver.getId()));
            }
        }
    }

    public void save() throws Exception {
        DbSession session = DbOper.openDb("defaultds");
        try {
            try {
                int i;
                if (!this.dataModify.is(DataModify.SAVED)) {
                    this.eventHandles.add("beforesave");
                    this.fire("beforesave");
                    this.model.setBeginTime(this.beginTime);
                    this.model.setOverTime(this.overTime);
                    this.model.setCreateTime(this.createTime);
                    this.model.setCreateUserId(this.getCreateUserId());
                    this.model.setCreateUserName(this.getCreateUserName());
                    if (this.owner.isSubmiting() || this.owner.isUntreading() || this.owner.isCallbacking()) {
                        this.model.setEndTime(this.endTime);
                    }
                    this.model.setFlowId(this.flowId);
                    this.model.setFlowInstanceId(this.flowInstanceId);
                    this.model.setFlowName(this.flowName);
                    this.model.setFlowNodeId(this.flowNodeId);
                    this.model.setFlowNodeName(this.flowNodeName);
                    this.model.setNodeInstanceId(this.nodeInstanceId);
                    this.model.setOpenerId(this.openerId);
                    this.model.setOpenerName(this.openerName);
                    this.model.setOpenerTime(this.openerTime);
                    this.model.setPreNodeInstanceIds(this.preNodeInstanceIds);
                    this.model.setNextNodeInstanceIds(this.nextNodeInstanceIds);
                    this.model.setvPreNodeInstanceId(this.vPreNodeInstanceId);
                    this.model.setvNextNodeInstanceId(this.vNextNodeInstanceId);
                    this.model.setRunStatus(this.runStatus);
                    this.model.setRunStatusNoteStart(this.runStatusNoteStart);
                    this.model.setRunStatusNoteStop(this.runStatusNoteStop);
                    this.model.setTakeStatus(this.takeStatus);
                    this.model.setNotes(this.getNotes());
                    this.model.setStatusName(this.statusName);
                    this.model.setIsAutoDeal(this.isAutoDeal);
                    dao.saveNodeInstance(this.model, this.dataModify);
                    if (DataModify.NEW.is(this.dataModify) && this.untreadReason != null) {
                        dao.saveUntread(this.model, this.untreadReason);
                    }
                    this.eventHandles.add("aftersave");
                    int eventLen = this.eventHandles.size();
                    i = 0;
                    while (i < eventLen) {
                        String eventName = (String)this.eventHandles.get(i);
                        if (!"beforesave".equals(eventName)) {
                            this.fire(eventName);
                        }
                        ++i;
                    }
                    if (this.eventHandles.contains(AFTER_CREATE)) {
                        this.templet.sendMsg(this.flowInstanceId, this.nodeInstanceId, "\u542f\u52a8\u540e");
                    }
                    if (this.eventHandles.contains("aftercallback")) {
                        this.templet.sendMsg(this.flowInstanceId, this.nodeInstanceId, "\u64a4\u56de\u540e");
                    }
                    if (this.eventHandles.contains("afteruntread")) {
                        this.templet.sendMsg(this.flowInstanceId, this.nodeInstanceId, "\u9000\u56de\u540e");
                    }
                    if (this.eventHandles.contains(AFTER_COMPLETE)) {
                        this.templet.sendMsg(this.flowInstanceId, this.nodeInstanceId, "\u5b8c\u6210\u540e");
                    }
                    this.eventHandles.clear();
                }
                this.operatorManager.save(this.owner.isSubmiting() || this.owner.isUntreading() || this.owner.isCallbacking());
                i = 0;
                while (i < this.waitDos.size()) {
                    WaitDo waitDo = (WaitDo)this.waitDos.get(i);
                    if (waitDo != null) {
                        if (waitDo instanceof FlowWaitDo) {
                            waitDo = ((FlowWaitDo)waitDo).getWaitDo();
                        }
                        if (DataModify.NEW.is(waitDo.getModify()) && "\u672a\u547d\u540d".equals(waitDo.getOperContent())) {
                            waitDo.setOperContent((String)this.owner.getParameter("NAME"));
                        }
                        waitDo.save();
                    }
                    ++i;
                }
                int i2 = 0;
                while (i2 < this.haveDos.size()) {
                    HaveDo haveDo = (HaveDo)this.haveDos.get(i2);
                    if (haveDo != null) {
                        haveDo.save();
                    }
                    ++i2;
                }
                int i3 = 0;
                while (i3 < this.flowWeChatDos.size()) {
                    FlowWeChartBo flowWeChartBo = (FlowWeChartBo)this.flowWeChatDos.get(i3);
                    if (flowWeChartBo != null) {
                        try {
                            flowWeChartBo.save();
                        }
                        catch (Exception e) {
                            log.error((Object)("\u6d41\u7a0b\u53d1\u9001\u5fae\u4fe1\u5931\u8d25,\u9519\u8bef\u4e3a:" + e.getMessage()));
                            e.printStackTrace();
                            break;
                        }
                    }
                    ++i3;
                }
                int i4 = 0;
                while (i4 < this.counterSigns.size()) {
                    CounterSign counterSign = (CounterSign)this.counterSigns.get(i4);
                    if (counterSign != null) {
                        counterSign.save();
                    }
                    ++i4;
                }
                DbOper.commitDb(session);
                this.waitDos.clear();
                this.haveDos.clear();
                this.flowWeChatDos.clear();
                this.counterSigns.clear();
            }
            catch (Exception exp) {
                DbOper.rollbackDb(session);
                throw exp;
            }
        }
        finally {
            DbOper.closeDb(session);
        }
        this.dataModify = DataModify.SAVED;
    }

    public DataModify getDataModify() {
        return this.dataModify;
    }

    public int getRunStatus() {
        return this.runStatus;
    }

    public int getRunStatusNoteStart() {
        return this.runStatusNoteStart;
    }

    public void setRunStatusNoteStart(int runStatusNoteStart) {
        this.runStatusNoteStart = runStatusNoteStart;
    }

    public int getRunStatusNoteStop() {
        return this.runStatusNoteStop;
    }

    public void setRunStatusNoteStop(int runStatusNoteStop) {
        this.runStatusNoteStop = runStatusNoteStop;
    }

    public int getTakeStatus() {
        return this.takeStatus;
    }

    public int getDefaultForm() {
        return this.templet.getDefaultForm();
    }

    public int getFormId(String formInstanceId) {
        return this.owner.getFormId(formInstanceId);
    }

    public String getFlowInstanceId() {
        return this.flowInstanceId;
    }

    public String getStatusName() {
        return this.statusName;
    }

    public String toJson() {
        StringBuffer script = new StringBuffer(1024);
        script.append("{");
        script.append("flowInstanceId:'").append(this.getFlowInstanceId()).append("'");
        script.append(",id:").append(this.nodeInstanceId);
        script.append(",flowNodeId:").append(this.flowNodeId);
        script.append(",takeStatus:").append(this.takeStatus);
        script.append("}");
        return script.toString();
    }

    public int[] getPreNodeInstanceIds() {
        return this.preNodeInstanceIds;
    }

    public int[] getPreNodeInstanceIds72() {
        FlowNodeInstance vPerNodeInstance = this.owner.getFlowNodeInstance(this.vPreNodeInstanceId);
        if (vPerNodeInstance == null) {
            return this.getPreNodeInstanceIds();
        }
        return vPerNodeInstance.getPreNodeInstanceIds72();
    }

    public List<Integer> getNextNodeInstanceIds72() {
        ArrayList<Integer> nextNodes = new ArrayList<Integer>();
        FlowNodeInstance vNextNodeInstance = null;
        if (this.vNextNodeInstanceId != 0) {
            vNextNodeInstance = this.owner.getFlowNodeInstance(this.vNextNodeInstanceId);
        }
        List<Integer> nextNodesTemp = vNextNodeInstance == null ? this.getNextNodeInstanceIds() : vNextNodeInstance.getNextNodeInstanceIds72();
        for (int i : nextNodesTemp) {
            FlowNodeInstance nextNodeIns = this.owner.getFlowNodeInstance(i);
            if (nextNodeIns == null) continue;
            while (nextNodeIns != null && nextNodeIns.vNextNodeInstanceId != -1) {
                nextNodeIns = this.owner.getFlowNodeInstance(nextNodeIns.vNextNodeInstanceId);
            }
            if (nextNodeIns == null) continue;
            nextNodes.add(nextNodeIns.getNodeInstanceId());
        }
        return nextNodes;
    }

    public List<Integer> getNextNodeInstanceIds() {
        return this.nextNodeInstanceIds;
    }

    public void addPreNodeInstanceId(int preNodeInstanceId) {
        if (this.owner.getFlowNodeInstance(preNodeInstanceId) != null) {
            int len = this.preNodeInstanceIds.length;
            int[] preNodeInstanceIds = new int[len + 1];
            int i = 0;
            while (i < len) {
                preNodeInstanceIds[i] = this.preNodeInstanceIds[i];
                ++i;
            }
            preNodeInstanceIds[len] = preNodeInstanceId;
            this.preNodeInstanceIds = preNodeInstanceIds;
            this.modify();
        }
    }

    public void addNextNodeInstanceId(int nextNodeInstanceId) {
        if (this.owner.getFlowNodeInstance(nextNodeInstanceId) != null) {
            this.nextNodeInstanceIds.add(nextNodeInstanceId);
            this.modify();
        }
    }

    public int getFlowNodeId() {
        return this.flowNodeId;
    }

    public boolean isPreNode(FlowNode flowNode) {
        int len = this.preNodeInstanceIds.length;
        int i = 0;
        while (i < len) {
            FlowNodeInstance nodeInstance = this.owner.getFlowNodeInstance(this.preNodeInstanceIds[i]);
            if (flowNode.isInstance(nodeInstance)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isPreInstance(int preNodeInstanceId) {
        int len = this.preNodeInstanceIds.length;
        int i = 0;
        while (i < len) {
            if (this.preNodeInstanceIds[i] == preNodeInstanceId) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void setTooltip(String tooltip) {
        this.tooltip = tooltip;
    }

    public String getTooltip() throws Exception {
        if (StringTool.isEmpty(this.tooltip)) {
            StringBuffer output = new StringBuffer();
            output.append("\n\u5f00\u59cb\u65f6\u95f4\uff1a").append(DateTool.formatDateTime(this.beginTime)).append("<br/>");
            output.append("\n\u7ed3\u675f\u65f6\u95f4\uff1a").append(DateTool.formatDateTime(this.endTime)).append("<br/>");
            if (this.notes != null && !StringTool.isEmpty(this.notes.toString())) {
                List<Map<String, String>> delegateList = FlowDelegate.getDelegateInfo(this.flowInstanceId, this.nodeInstanceId);
                String delegateInfo = "";
                int i = 0;
                while (i < delegateList.size()) {
                    if (!StringTool.isEmpty(delegateList.get(i).get("info"))) {
                        delegateInfo = String.valueOf(delegateInfo) + delegateList.get(i).get("info") + ",";
                    }
                    ++i;
                }
                if (!StringTool.isEmpty(delegateInfo)) {
                    delegateInfo = delegateInfo.substring(0, delegateInfo.length() - 1);
                    output.append("\n\u59d4     \u6258\uff1a");
                    output.append(delegateInfo).append("<br/>");
                }
            }
            output.append("\n\u63a5 \u6536 \u4eba\uff1a");
            output.append(this.operatorManager.getReceiversNameString());
            if (this.dataModify.is(DataModify.SAVED)) {
                output.append("<br/>\n\u5904 \u7406 \u4eba\uff1a");
                output.append(this.operatorManager.getOperatorEndNameString());
            }
            this.tooltip = output.toString();
        }
        return this.tooltip;
    }

    public FlowOperatorManager getOperatorManager() {
        return this.operatorManager;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void copyOperator(FlowNodeInstance preNodeInstance, boolean isPending, String reson, Object[] selectedReceiveIds) throws Exception {
        block13: {
            block12: {
                operId = this.getWaitDoId();
                operName = this.flowName;
                session = new FlowInstanceSession(this.owner, this.nodeInstanceId, -1, -1, null, false);
                operUrl = session.getPageUrl();
                currentUser = User.getCurrentUser();
                sender = currentUser != null ? currentUser.getId() : "";
                operContent = (String)this.owner.getParameter("NAME");
                it = preNodeInstance.operatorManager.getOperators().entrySet().iterator();
                if (selectedReceiveIds == null || selectedReceiveIds.length <= 0) break block12;
                index = 0;
                while (index < selectedReceiveIds.length) {
                    type = 0;
                    if (selectedReceiveIds[index] instanceof String) {
                        user /* !! */  = User.getUser((String)selectedReceiveIds[index]);
                    } else if (selectedReceiveIds[index] instanceof BaseObject) {
                        user /* !! */  = (BaseObject)selectedReceiveIds[index];
                        if (selectedReceiveIds[index] instanceof User) {
                            type = 0;
                        } else if (selectedReceiveIds[index] instanceof Organize) {
                            type = 2;
                        } else if (selectedReceiveIds[index] instanceof Role) {
                            type = 1;
                        }
                    } else {
                        user /* !! */  = User.getUser((String)selectedReceiveIds[index]);
                    }
                    this.addReceiver(user /* !! */ , isPending, type);
                    ++index;
                }
                break block13;
            }
            if (!isPending) ** GOTO lbl45
            while (it.hasNext()) {
                entry = it.next();
                receiver = entry.getValue();
                this.operatorManager.addReceiver(receiver);
                this.addWaitDo(FlowWaitDo.create(this.templet, this.owner, this, receiver.getType(), entry.getKey().toString()));
                this.addFlowWeChatDo(FlowWeChartBo.createFlowWeChart(this.templet, this.owner, this, receiver.getType(), entry.getKey().toString()));
            }
            break block13;
lbl-1000:
            // 1 sources

            {
                entry = it.next();
                receiver = entry.getValue();
                this.operatorManager.addReceiver(receiver);
lbl45:
                // 2 sources

                ** while (it.hasNext())
            }
        }
    }

    public static final String[] getEventMethod(String className) throws Exception {
        List list = BeanTool.searchMethod(Class.forName(className), null, new Class[]{FlowNodeInstance.class, Object.class}, 8);
        String[] methodNames = new String[list.size()];
        Iterator it = list.iterator();
        int i = 0;
        while (it.hasNext()) {
            methodNames[i] = ((Method)it.next()).getName();
            ++i;
        }
        return methodNames;
    }

    public String getFlowNodeName() {
        return this.flowNodeName;
    }

    private void setTemplet(FlowNode templet) {
        this.templet = templet;
        templet.registerEvent(this);
    }

    public void terminate() throws Exception {
        if (this.runStatus != 2 && this.runStatus != 1 && this.runStatus != 4) {
            this.eventHandles.add("beforeterminate");
            this.runStatus = 2;
            this.modify();
            this.addWaitDo(WaitDo.delete(this.getWaitDoId()));
            this.addFlowWeChatDo(FlowWeChartBo.delete(this.getFlowWeChartBo()));
            this.eventHandles.add("afterterminate");
        }
    }

    public void delete() throws Exception {
        this.eventHandles.add("beforedelete");
        this.addWaitDo(WaitDo.delete(this.getWaitDoId()));
        this.addHaveDo(HaveDo.delete(this.getHaveDoId()));
        this.addFlowWeChatDo(FlowWeChartBo.delete(this.getFlowWeChartBo()));
        this.eventHandles.add("afterdelete");
    }

    public void delegate(HashMap delegateMap) throws Exception {
        if (delegateMap != null && !delegateMap.isEmpty()) {
            TreeMap map;
            User user;
            boolean isPending = this.templet.isPending();
            HashMap<String, User> users = new HashMap<String, User>();
            ArrayList<String> depts = new ArrayList<String>();
            ArrayList<String> roles = new ArrayList<String>();
            for (Map.Entry entry : delegateMap.entrySet()) {
                String delegateToId = (String)entry.getKey();
                int delegateToType = Integer.parseInt((String)entry.getValue());
                switch (delegateToType) {
                    case 0: {
                        user = User.getUser(delegateToId);
                        users.put(delegateToId, user);
                        this.addReceiver(user, isPending, 0);
                        break;
                    }
                    case 1: {
                        roles.add(delegateToId);
                        break;
                    }
                    case 2: {
                        depts.add(delegateToId);
                    }
                }
            }
            if (depts.size() > 0) {
                map = User.getUserByDept(depts.toArray(new String[depts.size()]), null);
                for (String delegateToId : map.keySet()) {
                    if (users.containsKey(delegateToId)) continue;
                    user = new User();
                    user.init((UserBean)map.get(delegateToId));
                    users.put(delegateToId, user);
                    this.addReceiver(user, isPending, 0);
                }
            }
            if (roles.size() > 0) {
                map = User.getUserByRole(roles.toArray(new String[roles.size()]), null);
                for (String delegateToId : map.keySet()) {
                    if (users.containsKey(delegateToId)) continue;
                    user = new User();
                    user.init((UserBean)map.get(delegateToId));
                    users.put(delegateToId, user);
                    this.addReceiver(user, isPending, 0);
                }
            }
            String curUserId = User.getCurrentUser().getId();
            this.operatorManager.delegateReceiver(curUserId);
            this.waitDos.add(WaitDo.delete(this.getWaitDoId(), curUserId));
            HashMap<String, String> weChartMap = new HashMap<String, String>();
            weChartMap.put("flowInstanceId", this.getFlowInstanceId());
            weChartMap.put("nodeInstanceId", String.valueOf(this.getNodeInstanceId()));
            this.flowWeChatDos.add(FlowWeChartBo.delete(weChartMap, curUserId));
        }
    }

    public String getStatusId() {
        return this.statusId;
    }

    public void addWaitDo(WaitDo waitDo) {
        this.waitDos.add(waitDo);
    }

    public void addHaveDo(HaveDo haveDo) {
        this.haveDos.add(haveDo);
    }

    public void addFlowWeChatDo(FlowWeChartBo flowWeChartBo) {
        if (flowWeChartBo != null) {
            this.flowWeChatDos.add(flowWeChartBo);
        }
    }

    public void addCounterSigns(CounterSign counterSign) {
        this.counterSigns.add(counterSign);
    }

    public static void checkTimeLimit(String id, String name) throws Exception {
        List list = dao.getTimeLimit();
        for (FlowNodeInstanceBean nodeInstanceBean : list) {
            try {
                Flow flow = Flow.getFlow(nodeInstanceBean.getFlowId());
                FlowNode node = flow.getNodeById(nodeInstanceBean.getFlowNodeId());
                node.checkTimeLimit(nodeInstanceBean.getFlowInstanceId(), nodeInstanceBean.getNodeInstanceId(), nodeInstanceBean.getCreateTime());
            }
            catch (Exception exp) {
                log.error((Object)("\u6d41\u7a0b\u5b9e\u4f8b\u6570\u636e\u6709\u9519\u8bef:" + nodeInstanceBean.getFlowInstanceId()));
                exp.printStackTrace();
            }
        }
    }

    public String getUntreadReason() {
        return this.untreadReason;
    }

    public void setUntreadReason(String untreadReason) {
        this.untreadReason = untreadReason;
    }

    public Date getOverTime() {
        return this.overTime;
    }

    public String getNotes() {
        if (this.notes != null) {
            return this.notes.toString();
        }
        return "";
    }

    public void addNotes(String notes) {
        if (!StringTool.isEmpty(notes)) {
            this.modify();
            if (this.notes != null) {
                this.notes.append(notes);
            } else {
                this.notes = new StringBuffer(notes);
            }
        }
    }

    public void clearNotes() {
        this.notes = null;
    }

    public Map getDefaultFormIndex() throws Exception {
        List formInstances;
        TreeMap defaultFormIndex = null;
        FlowInstance flowInstance = this.owner;
        Flow flow = flowInstance.getTemplet();
        FlowNode flowNode = this.templet;
        int defaultFormId = flowNode.getDefaultForm();
        FlowForm flowForm = flow.getForm(defaultFormId);
        String patternId = flowForm.getFormPatternId();
        Form formPattern = Form.getPattern(patternId);
        FlowFormInstance flowFormInstance = flowInstance.getForm(defaultFormId);
        if (flowFormInstance != null && (formInstances = flowFormInstance.getFormInstances()) != null && formInstances.size() > 0) {
            String formInstanceId = (String)formInstances.get(0);
            FormInstance formInstance = FormInstance.load(formInstanceId, formPattern);
            defaultFormIndex = formInstance.getIndex();
        }
        return defaultFormIndex;
    }

    public String getShowImage() {
        return this.showImage;
    }

    public void setShowImage(String showImage) {
        this.showImage = showImage;
    }

    public void addNodeEventInPicture(String eventName, String eventFuction) {
        if (this.nodeEventInPicture == null) {
            this.nodeEventInPicture = new TreeMap();
        }
        this.nodeEventInPicture.put(eventName, eventFuction);
    }

    public TreeMap getNodeEventInPicture() {
        return this.nodeEventInPicture;
    }

    public void addReceiver72(BaseObject receiver, int type) throws Exception {
        this.operatorManager.addReceiver(receiver, type);
    }

    public void startUp72(int runStatusNodeStart) throws Exception {
        this.startUp();
        this.setRunStatusNoteStart(runStatusNodeStart);
    }

    public void startTask72() throws Exception {
        Map receivers = this.operatorManager.getReceivers();
        for (Map.Entry oo : receivers.entrySet()) {
            FlowReceiver receiver = (FlowReceiver)oo.getValue();
            this.addWaitDo(FlowWaitDo.create(this.templet, this.owner, this, receiver.getType(), receiver.getOperatorId()));
            this.addFlowWeChatDo(FlowWeChartBo.createFlowWeChart(this.templet, this.owner, this, receiver.getType(), receiver.getOperatorId()));
        }
    }

    public void complet72(int runStatusNodeStop) throws Exception {
        this.complet();
        this.setRunStatusNoteStop(runStatusNodeStop);
    }

    public void terminate72(int runStatusNodeStop) throws Exception {
        this.terminate();
        this.setRunStatusNoteStop(runStatusNodeStop);
    }

    public void addCallBackMessage() throws Exception {
        this.eventHandles.add("aftercallback");
    }

    public boolean canUntread() {
        if (this.templet.getAllowUntread() == 1) {
            return true;
        }
        return true;
    }

    public boolean isMulti() {
        return this.templet.isMulti();
    }

    public void copyReceiver(FlowNodeInstance preNodeInstance) throws Exception {
        ArrayList<String> haveDoOper = new ArrayList<String>();
        if (this.templet.isMulti()) {
            Iterator<Map.Entry<String, FlowOperator>> itOper = preNodeInstance.operatorManager.getOperators().entrySet().iterator();
            String operId = this.getWaitDoId();
            while (itOper.hasNext()) {
                Map.Entry<String, FlowOperator> entry = itOper.next();
                FlowOperator operator = entry.getValue();
                if (operator.getEndTime() == null || operator.getOperatorId().equals(User.getCurrentUser().getId())) continue;
                String operatorId = operator.getOperatorId();
                String operName = this.owner.getFlowName();
                FlowInstanceSession session = new FlowInstanceSession(this.owner, this.getNodeInstanceId(), -1, -1, null, false);
                String operUrl = session.getPageUrl();
                String operContent = (String)this.owner.getParameter("NAME");
                Date operEnd = operator.getEndTime();
                Date operStart = operator.getBeginTime();
                HaveDo haveDo = HaveDo.create(operId, operName, operUrl, operatorId, operContent, operStart, operEnd, this.templet.getOpenType());
                this.addHaveDo(haveDo);
                User user = User.getUser(operatorId);
                FlowOperator o = this.operatorManager.addOperator(user);
                o.setBeginTime(operStart);
                o.setEndTime(operEnd);
                haveDoOper.add(operatorId);
            }
        }
        FlowOperatorManager pom = preNodeInstance.getOperatorManager();
        Iterator it = pom.getReceivers().entrySet().iterator();
        User user = User.getCurrentUser();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            FlowReceiver receiver = (FlowReceiver)entry.getValue();
            BaseObject bo = null;
            bo = receiver.getType() == 0 ? User.getUser(receiver.getOperatorId()) : (receiver.getType() == 2 ? Organize.getOrganize(receiver.getOperatorId()) : (receiver.getType() == 1 ? Role.getRole(receiver.getOperatorId()) : null));
            if (receiver.getOperatorId().equals(user.getId()) || !haveDoOper.contains(receiver.getOperatorId())) {
                this.addReceiver(bo, true, receiver.getType());
                continue;
            }
            this.addReceiver(bo, false, receiver.getType());
        }
    }

    public void copyInfo(FlowNodeInstance preNodeInstance) throws Exception {
        ArrayList<String> haveDoOper = new ArrayList<String>();
        Iterator<Map.Entry<String, FlowOperator>> itOper = preNodeInstance.operatorManager.getOperators().entrySet().iterator();
        String operId = this.getWaitDoId();
        while (itOper.hasNext()) {
            Map.Entry<String, FlowOperator> entry = itOper.next();
            FlowOperator operator = entry.getValue();
            if (operator.getEndTime() == null || operator.getOperatorId().equals(User.getCurrentUser().getId())) continue;
            String operatorId = operator.getOperatorId();
            String operName = this.owner.getFlowName();
            FlowInstanceSession session = new FlowInstanceSession(this.owner, this.getNodeInstanceId(), -1, -1, null, false);
            String operUrl = session.getPageUrl();
            String operContent = (String)this.owner.getParameter("NAME");
            Date operEnd = operator.getEndTime();
            Date operStart = operator.getBeginTime();
            HaveDo haveDo = HaveDo.create(operId, operName, operUrl, operatorId, operContent, operStart, operEnd, this.templet.getOpenType());
            this.addHaveDo(haveDo);
            User user = User.getUser(operatorId);
            FlowOperator o = this.operatorManager.addOperator(user);
            o.setBeginTime(operStart);
            o.setEndTime(operEnd);
            haveDoOper.add(operatorId);
        }
        FlowOperatorManager pom = preNodeInstance.getOperatorManager();
        Iterator it = pom.getReceivers().entrySet().iterator();
        User user = User.getCurrentUser();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            FlowReceiver receiver = (FlowReceiver)entry.getValue();
            BaseObject bo = null;
            bo = receiver.getType() == 0 ? User.getUser(receiver.getOperatorId()) : (receiver.getType() == 2 ? Organize.getOrganize(receiver.getOperatorId()) : (receiver.getType() == 1 ? Role.getRole(receiver.getOperatorId()) : null));
            if (receiver.getOperatorId().equals(user.getId()) || !haveDoOper.contains(receiver.getOperatorId())) {
                this.addReceiver(bo, true, receiver.getType());
                continue;
            }
            this.addReceiver(bo, false, receiver.getType());
        }
        if (this.isMulti()) {
            List counterSigns = CounterSign.copy(this.owner.getId(), preNodeInstance.getNodeInstanceId(), this.getNodeInstanceId());
            int i = 0;
            while (i < counterSigns.size()) {
                this.addCounterSigns((CounterSign)counterSigns.get(i));
                ++i;
            }
        }
    }

    public boolean isNoReciver() {
        FlowOperatorManager operatorM = this.getOperatorManager();
        Map reciverMap = operatorM.getReceivers();
        return reciverMap == null || reciverMap.size() == 0;
    }

    public void saveOperatorManager() {
        try {
            this.operatorManager.save(this.owner.isSubmiting() || this.owner.isUntreading() || this.owner.isCallbacking());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void startCallback(int runStatusNodeStart) throws Exception {
        this.takeStatus = 6;
        this.startUp72(runStatusNodeStart);
    }
}

