/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.workflow.service;

import com.sdjxd.pms.platform.workflow.model.FlowNodeChildBean;
import com.sdjxd.pms.platform.workflow.service.Flow;
import com.sdjxd.pms.platform.workflow.service.FlowInstance;
import com.sdjxd.pms.platform.workflow.service.FlowNode;
import com.sdjxd.pms.platform.workflow.service.FlowNodeInstance;
import com.sdjxd.pms.platform.workflow.service.FlowOperator;
import com.sdjxd.pms.platform.workflow.service.FlowParameter;
import java.lang.reflect.Array;
import java.util.List;

public class FlowNodeChild
extends FlowNode {
    private static final long serialVersionUID = 1L;
    private int invokeType;
    private String childFlowVersionId;
    private int beMulChild;
    private int iteratorId;
    private int iteratorVar;

    public FlowNodeChild() {
        this.IMGNAME_CURRENT = "child_run.png";
        this.IMGNAME_COMPLET = "child_over.png";
        this.IMGNAME_UNSTART = "child_wait.png";
    }

    public void loadChildFlow(FlowNodeChildBean model) {
        this.invokeType = model.getInvokeType();
        this.childFlowVersionId = model.getChildFlow();
        this.beMulChild = model.getBeMulChild();
        this.iteratorId = model.getIteratorId();
        this.iteratorVar = model.getIteratorVar();
    }

    @Override
    public void createOperator(FlowInstance flowInstance, int nodeInstanceId, Object[] selectedReceiveIds) throws Exception {
    }

    @Override
    public Object start(FlowInstance flowInstance, int nodeInstanceId, Object[] selectedReceiveIds) throws Exception {
        if (Boolean.TRUE.equals(super.start(flowInstance, nodeInstanceId, selectedReceiveIds))) {
            FlowNodeInstance nodeInstance = flowInstance.getLastNodeInstance(this);
            Flow childFlow = Flow.getFlowVersion(this.childFlowVersionId);
            if (this.iteratorVar == -1) {
                FlowInstance childFlowInstance = FlowInstance.create(childFlow);
                String childFlowInstanceId = childFlowInstance.getId();
                flowInstance.addNodeChildInstance(childFlowInstanceId, nodeInstance.getNodeInstanceId());
            } else {
                Object array = flowInstance.getParameterValue(this.iteratorVar);
                int len = Array.getLength(array);
                FlowParameter parameter = childFlow.getParameter(this.iteratorId);
                if (parameter != null) {
                    String childIteratorName = parameter.getName();
                    int i = 0;
                    while (i < len) {
                        FlowInstance childFlowInstance = FlowInstance.create(childFlow);
                        String childFlowInstanceId = childFlowInstance.getId();
                        childFlowInstance.setParameter(childIteratorName, Array.get(array, i));
                        flowInstance.addNodeChildInstance(childFlowInstanceId, nodeInstance.getNodeInstanceId());
                        ++i;
                    }
                } else {
                    int i = 0;
                    while (i < len) {
                        FlowInstance childFlowInstance = FlowInstance.create(childFlow);
                        String childFlowInstanceId = childFlowInstance.getId();
                        flowInstance.addNodeChildInstance(childFlowInstanceId, nodeInstance.getNodeInstanceId());
                        ++i;
                    }
                }
            }
            if (this.invokeType == 1) {
                nodeInstance.exec();
                return this.submitToNext(flowInstance, nodeInstance.getNodeInstanceId(), null, false);
            }
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    public Object start72(FlowInstance flowInstance, int preNodeInstanceId, Object[] selectedReceiveIds) throws Exception {
        return this.start(flowInstance, preNodeInstanceId, selectedReceiveIds);
    }

    @Override
    public boolean submitTask(FlowInstance flowInstance, int nodeInstanceId, FlowOperator operator) throws Exception {
        return true;
    }

    @Override
    public boolean execTask(FlowNodeInstance nodeInstance) throws Exception {
        return true;
    }

    public void startTask(FlowInstance flowInstance, int nodeInstanceId, List flowActors, String[] selectedReceiveIds) throws Exception {
    }

    @Override
    public boolean checkLimit(FlowInstance flowInstance, int nodeInstanceId) throws Exception {
        return false;
    }
}

