/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.workflow.service;

import com.sdjxd.pms.platform.base.BaseClass;
import com.sdjxd.pms.platform.base.BaseObject;
import com.sdjxd.pms.platform.base.Global;
import com.sdjxd.pms.platform.form.model.TreeNodeBean;
import com.sdjxd.pms.platform.message.Message;
import com.sdjxd.pms.platform.organize.Organize;
import com.sdjxd.pms.platform.organize.Role;
import com.sdjxd.pms.platform.organize.User;
import com.sdjxd.pms.platform.tool.BeanTool;
import com.sdjxd.pms.platform.tool.DateTool;
import com.sdjxd.pms.platform.tool.StringTool;
import com.sdjxd.pms.platform.workflow.bo.FlowWeChartBo;
import com.sdjxd.pms.platform.workflow.dao.FlowInstanceDao;
import com.sdjxd.pms.platform.workflow.model.FlowCellBean;
import com.sdjxd.pms.platform.workflow.model.FlowNodeBean;
import com.sdjxd.pms.platform.workflow.model.FlowSendMsgActorBean;
import com.sdjxd.pms.platform.workflow.model.RemindConfig;
import com.sdjxd.pms.platform.workflow.model.WaitDoConfig;
import com.sdjxd.pms.platform.workflow.service.CounterSign;
import com.sdjxd.pms.platform.workflow.service.Flow;
import com.sdjxd.pms.platform.workflow.service.FlowActor;
import com.sdjxd.pms.platform.workflow.service.FlowActorList;
import com.sdjxd.pms.platform.workflow.service.FlowEvent;
import com.sdjxd.pms.platform.workflow.service.FlowFormInstance;
import com.sdjxd.pms.platform.workflow.service.FlowInstance;
import com.sdjxd.pms.platform.workflow.service.FlowInstanceSession;
import com.sdjxd.pms.platform.workflow.service.FlowNodeInstance;
import com.sdjxd.pms.platform.workflow.service.FlowOperator;
import com.sdjxd.pms.platform.workflow.service.FlowOperatorManager;
import com.sdjxd.pms.platform.workflow.service.FlowOverTime;
import com.sdjxd.pms.platform.workflow.service.FlowSendMsgActor;
import com.sdjxd.pms.platform.workflow.service.FlowTrans;
import com.sdjxd.pms.platform.workflow.service.FormVariableLimit;
import com.sdjxd.pms.platform.workflow.service.HaveDo;
import com.sdjxd.pms.platform.workflow.service.WaitDo;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public abstract class FlowNode
extends BaseClass {
    private static Logger log = Logger.getLogger(FlowNode.class);
    public static String icon = String.valueOf(Global.getName()) + "/pms/platform/image/folder2.gif";
    protected String IMGNAME_CURRENT = "node_run.gif";
    protected String IMGNAME_COMPLET = "node_over.png";
    protected String IMGNAME_UNSTART = "node_wait.png";
    protected int id;
    protected String name;
    protected String flowId;
    private int type;
    private int allowUntread;
    public static final int ALLOWUNTREAD_NO = 0;
    public static final int ALLOWUNTREAD_YES = 1;
    private String statusId;
    private String statusName;
    private List createForms;
    protected int coverge;
    protected int embranch;
    protected static int EMBRANCH_ALL = 0;
    protected static int EMBRANCH_SINGLE = 1;
    protected static int EMBRANCH_SINGLE_SELECT = 3;
    protected static int EMBRANCH_MULTI = 2;
    protected static int EMBRANCH_MULTI_SELECT = 4;
    protected static int CONVERGE_ALL = 0;
    protected static int CONVERGE_SINGLE = 1;
    protected static int CONVERGE_MULTI = 2;
    private int defaultForm;
    private List allowForms;
    protected int freeType;
    protected static final int FREE_DISABLE = 0;
    protected static final int FREE_NEXT = 1;
    protected static final int FREE_WHOLE = 2;
    protected static final int FREE_LIST = 3;
    protected int[] freeData;
    private TreeMap formVariableLimit;
    private List flowEvents;
    private Map parameterValues;
    protected Map preTrans;
    private Map nextTrans;
    private Map untreadTrans;
    protected List flowActors;
    private boolean multi;
    protected boolean pending;
    protected String openType;
    private boolean orderExec;
    private int completeRole;
    private int completeData;
    private int limitType;
    private int timeSlice;
    private String overTimeClass;
    private HashMap sendMsgActors;
    private static int ROLE_WHOLE = 0;
    private static int ROLE_QUANTITY = 1;
    private static int ROLE_PERCENT = 2;
    private WaitDoConfig waitDoConfig;
    private RemindConfig remindConfig;
    private static String[] classNames = new String[]{"", "FlowNodePerson", "", "FlowNodeEnd", "FlowNodeStart", "", "", "", "", "FlowNodeAuto", "FlowNodeChild"};
    protected String limitGroups;
    private int autoDeal;
    private int noReciver;

    public WaitDoConfig getWaitDoConfig() {
        return this.waitDoConfig;
    }

    public void setWaitDoConfig(WaitDoConfig waitDoConfig) {
        this.waitDoConfig = waitDoConfig;
    }

    public RemindConfig getRemindConfig() {
        return this.remindConfig;
    }

    public void setRemindConfig(RemindConfig remindConfig) {
        this.remindConfig = remindConfig;
    }

    public int getAutoDeal() {
        return this.autoDeal;
    }

    public void setAutoDeal(int autoDeal) {
        this.autoDeal = autoDeal;
    }

    public boolean isNoReciverDeal() {
        return this.noReciver == 1;
    }

    public int getNoReciver() {
        return this.noReciver;
    }

    public void setNoReciver(int noReciver) {
        this.noReciver = noReciver;
    }

    public String getLimitGroups() {
        return this.limitGroups;
    }

    public static FlowNode createInstance(FlowNodeBean model) throws Exception {
        FlowNode node = null;
        String classPath = FlowNode.class.getPackage().getName();
        int type = model.getType();
        if (type >= classNames.length) {
            throw new Exception("\u6d41\u7a0b\u8282\u70b9\u2014\u2014\u6ca1\u6709\u627e\u5230\u8282\u70b9\u7c7b\u578b\u5bf9\u5e94\u7684\u5904\u7406\u7c7b\uff1atype=" + type);
        }
        classPath = String.valueOf(classPath) + "." + classNames[type];
        node = (FlowNode)BeanTool.getInstance(classPath);
        return node;
    }

    public void addVariableLimit(FormVariableLimit fvl) {
        if (fvl != null) {
            TreeMap map;
            String flowFormId = String.valueOf(fvl.getFlowFormId());
            if (this.formVariableLimit.containsKey(flowFormId)) {
                map = (TreeMap)this.formVariableLimit.get(flowFormId);
            } else {
                map = new TreeMap();
                this.formVariableLimit.put(flowFormId, map);
            }
            map.put(fvl.getPath(), String.valueOf(fvl.getLimit()));
        }
    }

    public TreeMap getVariableLimit(int flowFormId) {
        if (StringTool.isEmpty(this.limitGroups) || this.limitGroups.equals("[]")) {
            return (TreeMap)this.formVariableLimit.get(String.valueOf(flowFormId));
        }
        return this.getVariableLimitByLimitGroups(flowFormId);
    }

    protected TreeMap getVariableLimitByLimitGroups(int flowFormId) {
        try {
            String formPatternId = Flow.getFlow(this.flowId).getForm(flowFormId).getFormPatternId();
            String userId = User.getCurrentUser().getId();
            return (TreeMap)BeanTool.invokeMethod("com.sdjxd.hussar.core.workflow72.service.support.WorkFlowServices", "getFlowFormVariableLimitFor71", (Object[])new String[]{formPatternId, userId, this.limitGroups});
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)("\u8bfb\u53d6\u6d41\u7a0b\u4fe1\u606f\u5931\u8d25\uff01\u9519\u8bef\u4e3a\uff1a" + e.getMessage()));
            return null;
        }
    }

    public void load(FlowNodeBean model) throws Exception {
        Map waitDoMap;
        this.id = model.getFlowNodeId();
        this.name = model.getFlowNodeName();
        this.flowId = model.getFlowId();
        this.type = model.getNodeType();
        this.statusId = model.getStatusId();
        this.statusName = model.getStatusName();
        this.coverge = model.getConverge();
        this.embranch = model.getEmbranch();
        this.defaultForm = model.getDefaultForm();
        this.allowForms = model.getAllowForm();
        this.freeType = model.getFreeType();
        this.freeData = model.getFreeData();
        this.formVariableLimit = new TreeMap();
        this.parameterValues = new HashMap();
        this.preTrans = new HashMap();
        this.nextTrans = new HashMap();
        this.untreadTrans = new HashMap();
        this.flowActors = new ArrayList();
        this.flowEvents = new ArrayList();
        this.createForms = new ArrayList();
        this.pending = model.isPending();
        this.openType = model.getOpenType();
        this.multi = model.isMulti();
        this.orderExec = model.isOrderExec();
        this.completeData = model.getCompleteData();
        this.completeRole = model.getCompleteRole();
        this.limitType = model.getLimitType();
        this.timeSlice = model.getTimeSlice();
        this.overTimeClass = model.getOverTimeClass();
        this.limitGroups = model.getLimitGroups();
        this.allowUntread = model.getAllowUntread();
        this.autoDeal = model.getAutoDeal();
        this.noReciver = model.getNoReciver();
        String weChat = model.getWeChart();
        Map weChartMap = (Map)BeanTool.parse(weChat);
        if (weChartMap != null && (waitDoMap = (Map)weChartMap.get("waitDo")) != null && (Integer)waitDoMap.get("isValid") == 1) {
            String appId = (String)weChartMap.get("appId");
            WaitDoConfig waitDoConfig = new WaitDoConfig();
            waitDoConfig.setAppId(appId);
            waitDoConfig.setContent((String)waitDoMap.get("Content"));
            waitDoConfig.setImglink((String)waitDoMap.get("Imagelink"));
            waitDoConfig.setSqlLimit((String)waitDoMap.get("sqlLimit"));
            waitDoConfig.setTitle((String)waitDoMap.get("title"));
            waitDoConfig.setUrl((String)waitDoMap.get("urllink"));
            waitDoConfig.setButon((HashMap)waitDoMap.get("butons"));
            waitDoConfig.setIsValid((Integer)waitDoMap.get("isValid"));
            this.waitDoConfig = waitDoConfig;
        }
        this.loadSendMsgActor(model.getSendMsg());
    }

    public boolean isWaitDo(WaitDoConfig waitDoConfig) {
        boolean isWaitDo = false;
        if (waitDoConfig != null) {
            isWaitDo = true;
        }
        return isWaitDo;
    }

    public static boolean isRemind(RemindConfig remindConfig) {
        boolean isRemind = false;
        if (remindConfig != null) {
            isRemind = true;
        }
        return isRemind;
    }

    public String draw(FlowCellBean cell, FlowInstance flowInstance) throws Exception {
        if (cell == null) {
            return null;
        }
        if (flowInstance == null) {
            return this.draw(cell);
        }
        StringBuffer output = new StringBuffer();
        output.append("<img data-title='");
        List nodeInstances = flowInstance.getNodeInstance(this);
        FlowNodeInstance curNodeInstance = null;
        if (nodeInstances.size() > 0) {
            curNodeInstance = (FlowNodeInstance)nodeInstances.get(0);
        }
        output.append(this.getTooltip(flowInstance));
        int runStatus = this.getRunStatus(flowInstance);
        output.append("' src='");
        if (curNodeInstance != null && !curNodeInstance.getShowImage().equals("")) {
            output.append(curNodeInstance.getShowImage());
        } else {
            output.append(Flow.WF_IMGPATH);
            if (runStatus == 5) {
                output.append(this.IMGNAME_UNSTART);
            } else if (runStatus == 0) {
                output.append(this.IMGNAME_CURRENT);
            } else {
                output.append(this.IMGNAME_COMPLET);
            }
        }
        output.append("'");
        if (curNodeInstance != null) {
            TreeMap eventMap = curNodeInstance.getNodeEventInPicture();
            if (eventMap != null && eventMap.size() > 0) {
                if (!eventMap.containsKey("ondblclick")) {
                    output.append(" ondblclick=\"com.sdjxd.pms.platform.workflow.FlowInstance.open('").append(flowInstance.getId()).append("',").append(curNodeInstance.getNodeInstanceId()).append(",'',-1,'").append(this.openType).append("',-1)\"");
                }
                for (Map.Entry entry : eventMap.entrySet()) {
                    String eventName = (String)entry.getKey();
                    String eventFunction = (String)entry.getValue();
                    output.append(" " + eventName);
                    output.append("=\"");
                    output.append(eventFunction);
                    output.append("\"");
                }
            } else {
                output.append(" ondblclick=\"com.sdjxd.pms.platform.workflow.FlowInstance.open('").append(flowInstance.getId()).append("',").append(curNodeInstance.getNodeInstanceId()).append(",'',-1,'").append(this.openType).append("',-1)\"");
            }
        }
        int x1 = cell.getX1();
        int y1 = cell.getY1();
        output.append(" style='cursor:hand;position:absolute;z-index:100;left:").append(x1);
        output.append("px;top:").append(y1);
        output.append("px;width:").append(cell.getX2() - x1);
        output.append("px;height:").append(cell.getY2() - y1);
        output.append("px;rotation:0");
        output.append("'>");
        output.append("</img>");
        if (this.name != null && this.name.length() != 0) {
            output.append("<div nowrap  style='font-size:12px;position:absolute;left:");
            output.append(x1 + 20 - this.name.getBytes().length * 3);
            output.append("px;top:").append(40 + y1).append("px'>");
            output.append(this.name);
            output.append("</div>");
        }
        return output.toString();
    }

    public String getTooltip(FlowInstance flowInstance) throws Exception {
        StringBuffer output = new StringBuffer();
        List nodeInstances = flowInstance.getNodeInstance(this);
        if (nodeInstances.size() > 0) {
            int i = 0;
            while (i < nodeInstances.size()) {
                FlowNodeInstance nodeInstance = (FlowNodeInstance)nodeInstances.get(i);
                if (nodeInstance != null) {
                    output.append(nodeInstance.getTooltip());
                    break;
                }
                ++i;
            }
        }
        return output.toString();
    }

    public int getRunStatus(FlowInstance flowInstance) throws Exception {
        int runStatus = 5;
        List nodeInstances = flowInstance.getNodeInstance(this);
        if (nodeInstances.size() > 0) {
            int i = 0;
            while (i < nodeInstances.size()) {
                FlowNodeInstance nodeInstance = (FlowNodeInstance)nodeInstances.get(i);
                if (nodeInstance != null) {
                    runStatus = nodeInstance.getRunStatus();
                    break;
                }
                ++i;
            }
        }
        return runStatus;
    }

    public String draw(FlowCellBean cell) throws Exception {
        if (cell == null) {
            return null;
        }
        StringBuffer output = new StringBuffer();
        output.append("<img title='");
        output.append("' src='");
        output.append(Flow.WF_IMGPATH);
        output.append(this.IMGNAME_COMPLET);
        output.append("'");
        int x1 = cell.getX1();
        int y1 = cell.getY1();
        output.append(" style='cursor:hand;position:absolute;z-index:100;left:").append(x1);
        output.append(";top:").append(y1);
        output.append(";width:").append(cell.getX2() - x1);
        output.append(";height:").append(cell.getY2() - y1);
        output.append(";rotation:0");
        output.append("'>");
        output.append("</img>");
        if (this.name != null && this.name.length() != 0) {
            output.append("<div nowrap  style='font-size:12px;position:absolute;left:");
            output.append(x1 + 20 - this.name.getBytes().length * 3);
            output.append(";top:").append(40 + y1).append("'>");
            output.append(this.name);
            output.append("</div>");
        }
        return output.toString();
    }

    public int getId() {
        return this.id;
    }

    public int getAllowUntread() {
        return this.allowUntread;
    }

    public void addPreTrans(FlowTrans flowTrans) throws Exception {
        if (this.preTrans == null) {
            this.preTrans = new HashMap();
        }
        if (flowTrans != null) {
            this.preTrans.put(String.valueOf(flowTrans.getId()), flowTrans);
        }
    }

    public void addNextTrans(FlowTrans flowTrans) throws Exception {
        if (this.nextTrans == null) {
            this.nextTrans = new HashMap();
        }
        if (flowTrans != null) {
            this.nextTrans.put(String.valueOf(flowTrans.getId()), flowTrans);
        }
    }

    public void addUntreadTrans(FlowTrans flowTrans) throws Exception {
        if (this.untreadTrans == null) {
            this.untreadTrans = new HashMap();
        }
        if (flowTrans != null) {
            this.untreadTrans.put(String.valueOf(flowTrans.getId()), flowTrans);
        }
    }

    public boolean submit(FlowInstance flowInstance, int nodeInstanceId, FlowOperator operator) throws Exception {
        if (this.submitTask(flowInstance, nodeInstanceId, operator)) {
            FlowNodeInstance nodeInstance = flowInstance.getFlowNodeInstance(nodeInstanceId);
            nodeInstance.complet72(6);
            return true;
        }
        return false;
    }

    public Object submitToNext(FlowInstance flowInstance, int nodeInstanceId, HashMap toNodes, boolean isFreeSubmit) throws Exception {
        FlowNodeInstance flowNodeInstance = flowInstance.getFlowNodeInstance(nodeInstanceId);
        FlowOperatorManager operatorManager = flowNodeInstance.getOperatorManager();
        if (this.submit(flowInstance, nodeInstanceId, operatorManager.getCurrentOperator())) {
            flowNodeInstance.addNotes("\u63d0\u4ea4  ");
            if (toNodes != null && !toNodes.isEmpty()) {
                ArrayList treeNodes = new ArrayList();
                Iterator it = toNodes.entrySet().iterator();
                Flow flow = flowInstance.getTemplet();
                while (it.hasNext()) {
                    Map.Entry entry = it.next();
                    int flowNodeId = Integer.parseInt((String)entry.getKey());
                    Object submitData = entry.getValue();
                    FlowNode node = flow.getNodeById(flowNodeId);
                    Object result = node.start(flowInstance, nodeInstanceId, (Object[])submitData);
                    if (!(result instanceof List)) continue;
                    treeNodes.addAll((List)result);
                }
                if (!treeNodes.isEmpty()) {
                    throw new Exception("\u7a0b\u5e8f\u6682\u4e0d\u652f\u6301\u5b50\u6d41\u7a0b\u8282\u70b9\u540e\u7684\u8282\u70b9\u4e3a\u81ea\u7531\u6d41\u6216\u6307\u6d3e\u53c2\u4e0e\u8005\uff01");
                }
                return Boolean.TRUE;
            }
            HashMap nodes = new HashMap();
            ArrayList treeNodes = this.getNextNodes(flowInstance, nodeInstanceId, nodes, isFreeSubmit);
            if (nodes.size() > 0) {
                if (treeNodes == null) {
                    treeNodes = new ArrayList();
                    Iterator it = nodes.entrySet().iterator();
                    Flow flow = flowInstance.getTemplet();
                    while (it.hasNext()) {
                        Map.Entry entry = it.next();
                        int flowNodeId = Integer.parseInt((String)entry.getKey());
                        FlowNode node = flow.getNodeById(flowNodeId);
                        Object result = node.start(flowInstance, nodeInstanceId, null);
                        if (!(result instanceof List)) continue;
                        treeNodes.addAll((List)result);
                    }
                    if (!treeNodes.isEmpty()) {
                        throw new Exception("\u7a0b\u5e8f\u6682\u4e0d\u652f\u6301\u5b50\u6d41\u7a0b\u8282\u70b9\u540e\u7684\u8282\u70b9\u4e3a\u81ea\u7531\u6d41\u6216\u6307\u6d3e\u53c2\u4e0e\u8005\uff01");
                    }
                    return Boolean.TRUE;
                }
                return treeNodes;
            }
            throw new Exception("\u65e0\u53ef\u7528\u8282\u70b9\uff0c\u65e0\u6cd5\u63d0\u4ea4\uff01");
        }
        return Boolean.TRUE;
    }

    public Object untreadToNext(FlowInstance flowInstance, int nodeInstanceId, HashMap toNodes, String reson) throws Exception {
        FlowNodeInstance flowNodeInstance = flowInstance.getFlowNodeInstance(nodeInstanceId);
        FlowOperatorManager operatorManager = flowNodeInstance.getOperatorManager();
        FlowOperator operator = operatorManager.getCurrentOperator();
        Date operEnd = new Date();
        if (operator != null) {
            operator.setEndTime(operEnd);
        }
        flowNodeInstance.complet();
        flowNodeInstance.addNotes("\u9000\u56de\uff1a");
        flowNodeInstance.addNotes(reson);
        flowNodeInstance.addNotes("  ");
        if (toNodes != null && !toNodes.isEmpty()) {
            ArrayList treeNodes = new ArrayList();
            Iterator it = toNodes.entrySet().iterator();
            Flow flow = flowInstance.getTemplet();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                int flowNodeId = Integer.parseInt((String)entry.getKey());
                Object[] selectUserIds = (Object[])entry.getValue();
                FlowNode node = flow.getNodeById(flowNodeId);
                Object result = node.startForUntread(flowInstance, nodeInstanceId, reson, selectUserIds);
                if (!(result instanceof List)) continue;
                treeNodes.addAll((List)result);
            }
            if (!treeNodes.isEmpty()) {
                throw new Exception("\u7a0b\u5e8f\u6682\u4e0d\u652f\u6301\u5b50\u6d41\u7a0b\u8282\u70b9\u540e\u7684\u8282\u70b9\u4e3a\u81ea\u7531\u6d41\u6216\u6307\u6d3e\u53c2\u4e0e\u8005\uff01");
            }
            return Boolean.TRUE;
        }
        HashMap nodes = new HashMap();
        ArrayList treeNodes = this.getUntreadNodes(flowInstance, nodeInstanceId, nodes);
        if (treeNodes == null) {
            treeNodes = new ArrayList();
            Iterator it = nodes.entrySet().iterator();
            Flow flow = flowInstance.getTemplet();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                int flowNodeId = Integer.parseInt((String)entry.getKey());
                FlowNode node = flow.getNodeById(flowNodeId);
                Object result = node.startForUntread(flowInstance, nodeInstanceId, reson, null);
                if (!(result instanceof List)) continue;
                treeNodes.addAll((List)result);
            }
            if (!treeNodes.isEmpty()) {
                throw new Exception("\u7a0b\u5e8f\u6682\u4e0d\u652f\u6301\u5b50\u6d41\u7a0b\u8282\u70b9\u540e\u7684\u8282\u70b9\u4e3a\u81ea\u7531\u6d41\u6216\u6307\u6d3e\u53c2\u4e0e\u8005\uff01");
            }
            return Boolean.TRUE;
        }
        return treeNodes;
    }

    public List getNextNodesNoUser(FlowInstance flowInstance, int nodeInstanceId, Map nodes, boolean isFreeSubmit) throws Exception {
        String nodeId;
        FlowNode node;
        Map.Entry entry;
        if (this.nextTrans == null || this.nextTrans.size() <= 0) {
            throw new Exception("\u5f53\u524d\u8282\u70b9\u6ca1\u6709\u540e\u7eed\u8282\u70b9\uff01");
        }
        if (this.freeType == 0 && isFreeSubmit) {
            throw new Exception("\u5f53\u524d\u8282\u70b9\u5e76\u975e\u81ea\u7531\u6d41\u8282\u70b9\uff0c\u8bf7\u7528\u666e\u901a\u63d0\u4ea4\u65b9\u5f0f\u63d0\u4ea4\u5de5\u4f5c\uff01");
        }
        boolean needSelectNode = false;
        boolean needSelectActor = false;
        boolean isFree = isFreeSubmit && this.freeType != 0;
        Flow flow = flowInstance.getTemplet();
        Iterator it = this.nextTrans.entrySet().iterator();
        block0 : switch (this.freeType * (isFreeSubmit ? 1 : 0)) {
            case 0: {
                FlowTrans trans;
                if (this.embranch == EMBRANCH_ALL) {
                    while (it.hasNext()) {
                        entry = it.next();
                        trans = (FlowTrans)entry.getValue();
                        if (!trans.isEnabled(flowInstance)) {
                            throw new Exception("\u6d41\u7a0b\u5b9e\u4f8b\u65e0\u6cd5\u63d0\u4ea4\uff1a" + trans.getName());
                        }
                        node = trans.getTo();
                        nodeId = String.valueOf(node.getId());
                        nodes.put(nodeId, node);
                    }
                } else if (this.embranch == EMBRANCH_MULTI) {
                    while (it.hasNext()) {
                        entry = it.next();
                        trans = (FlowTrans)entry.getValue();
                        if (!trans.isEnabled(flowInstance)) continue;
                        node = trans.getTo();
                        nodeId = String.valueOf(node.getId());
                        nodes.put(nodeId, node);
                    }
                } else if (this.embranch == EMBRANCH_MULTI_SELECT) {
                    while (it.hasNext()) {
                        entry = it.next();
                        trans = (FlowTrans)entry.getValue();
                        if (!trans.isEnabled(flowInstance)) continue;
                        node = trans.getTo();
                        nodeId = String.valueOf(node.getId());
                        nodes.put(nodeId, node);
                    }
                } else if (this.embranch == EMBRANCH_SINGLE) {
                    while (it.hasNext()) {
                        entry = it.next();
                        trans = (FlowTrans)entry.getValue();
                        if (!trans.isEnabled(flowInstance)) continue;
                        node = trans.getTo();
                        nodeId = String.valueOf(node.getId());
                        nodes.put(nodeId, node);
                        break block0;
                    }
                } else {
                    if (this.embranch != EMBRANCH_SINGLE_SELECT) break;
                    while (it.hasNext()) {
                        entry = it.next();
                        trans = (FlowTrans)entry.getValue();
                        if (!trans.isEnabled(flowInstance)) continue;
                        node = trans.getTo();
                        nodeId = String.valueOf(node.getId());
                        nodes.put(nodeId, node);
                    }
                }
                break;
            }
            case 1: {
                this.getAllToNode(nodes);
                break;
            }
            case 2: {
                nodes.putAll(flow.getNodes());
                break;
            }
            case 3: {
                int i = 0;
                while (i < this.freeData.length) {
                    nodeId = String.valueOf(this.freeData[i]);
                    nodes.put(nodeId, flow.getNodeById(this.freeData[i]));
                    ++i;
                }
                break;
            }
        }
        if ((isFree || this.embranch == EMBRANCH_SINGLE_SELECT || this.embranch == EMBRANCH_MULTI_SELECT) && nodes.size() > 1) {
            needSelectNode = true;
        }
        ArrayList<TreeNodeBean> flowNodes = new ArrayList<TreeNodeBean>();
        it = nodes.entrySet().iterator();
        int nodeIndex = 0;
        while (it.hasNext()) {
            entry = it.next();
            node = (FlowNode)entry.getValue();
            List actors = node.getFlowActors();
            int i = 0;
            while (i < actors.size()) {
                if (actors.get(i) instanceof FlowActorList) {
                    needSelectActor = ((FlowActorList)actors.get(i)).isMoreSelect();
                }
                ++i;
            }
            nodeId = String.valueOf(node.getId());
            TreeNodeBean treeNode = new TreeNodeBean();
            treeNode.setTableId("FlowNode");
            treeNode.setText(node.getName());
            treeNode.setObjectId(nodeId);
            treeNode.setId(nodeId);
            treeNode.setExpanded(true);
            treeNode.setIconSrc(icon);
            treeNode.setGetData(true);
            treeNode.setChecked(!needSelectNode);
            treeNode.setDisabled(!needSelectNode);
            flowNodes.add(treeNode);
            ++nodeIndex;
        }
        if (needSelectNode || needSelectActor) {
            return flowNodes;
        }
        return null;
    }

    public List getNextNodesWithUser(FlowInstance flowInstance, int nodeInstanceId, Map nodes, boolean isFreeSubmit) throws Exception {
        boolean needSelectNode = false;
        boolean needSelectActor = false;
        boolean isFree = isFreeSubmit && this.freeType != 0;
        Iterator it = this.nextTrans.entrySet().iterator();
        if ((isFree || this.embranch == EMBRANCH_SINGLE_SELECT || this.embranch == EMBRANCH_MULTI_SELECT) && nodes.size() > 1) {
            needSelectNode = true;
        }
        ArrayList<TreeNodeBean> flowNodes = new ArrayList<TreeNodeBean>();
        TreeMap<String, BaseObject> orderUsers = new TreeMap<String, BaseObject>();
        it = nodes.entrySet().iterator();
        int nodeIndex = 0;
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            FlowNode node = (FlowNode)entry.getValue();
            String nodeId = String.valueOf(node.getId());
            Map users = node.getSelectActors(flowInstance, -1);
            TreeNodeBean treeNode = new TreeNodeBean();
            treeNode.setTableId("FlowNode");
            treeNode.setText(node.getName());
            treeNode.setObjectId(nodeId);
            treeNode.setId(nodeId);
            treeNode.setExpanded(true);
            treeNode.setIconSrc(icon);
            treeNode.setGetData(true);
            treeNode.setChecked(!needSelectNode);
            treeNode.setDisabled(!needSelectNode);
            if (users != null) {
                BaseObject user;
                orderUsers.clear();
                for (Map.Entry usersEntry : users.entrySet()) {
                    user = (BaseObject)usersEntry.getValue();
                    orderUsers.put(String.valueOf(StringTool.leftPad(String.valueOf(user.getShowOrder()), 10, '0')) + user.getId(), user);
                }
                needSelectActor = true;
                TreeNodeBean[] userNodes = new TreeNodeBean[users.size()];
                Iterator tempIt = orderUsers.keySet().iterator();
                int i = 0;
                while (tempIt.hasNext()) {
                    user = (BaseObject)orderUsers.get(tempIt.next());
                    String userId = user.getId();
                    TreeNodeBean userNode = new TreeNodeBean();
                    userNode.setText(user.getName());
                    userNode.setObjectId(userId);
                    userNode.attachField.put("SHOWORDER", String.valueOf(user.getShowOrder()));
                    if (user instanceof User) {
                        User userObj = (User)user;
                        userNode.setTableId("User");
                        userNode.setIconSrc(User.icon);
                        userNode.attachField.put("DEPTID", userObj.getDeptId());
                        userNode.attachField.put("DEPTNAME", userObj.getDeptName());
                        userNode.attachField.put("COMPID", userObj.getCompId());
                        userNode.attachField.put("COMPNAME", userObj.getCompName());
                        userNode.attachField.put("CODE", userObj.getCode());
                        userNode.attachField.put("ROLES", userObj.getRoles());
                    } else if (user instanceof Organize) {
                        userNode.setTableId("Organize");
                        userNode.setIconSrc(Organize.icon);
                    } else if (user instanceof Role) {
                        userNode.setTableId("Role");
                        userNode.setIconSrc(Role.icon);
                    }
                    userNode.setId(String.valueOf(nodeId) + userId);
                    userNode.setParentId(nodeId);
                    userNode.setParentObjectId(nodeId);
                    userNode.setExpanded(false);
                    userNode.setGetData(true);
                    userNodes[i++] = userNode;
                }
                treeNode.setChilds(userNodes);
            }
            flowNodes.add(treeNode);
            ++nodeIndex;
        }
        if (needSelectNode || needSelectActor) {
            return flowNodes;
        }
        return null;
    }

    public List getNextNodes(FlowInstance flowInstance, int nodeInstanceId, Map nodes, boolean isFreeSubmit) throws Exception {
        String nodeId;
        FlowNode node;
        Map.Entry entry;
        if (this.nextTrans == null || this.nextTrans.size() <= 0) {
            throw new Exception("\u5f53\u524d\u8282\u70b9\u6ca1\u6709\u540e\u7eed\u8282\u70b9\uff01");
        }
        if (this.freeType == 0 && isFreeSubmit) {
            throw new Exception("\u5f53\u524d\u8282\u70b9\u5e76\u975e\u81ea\u7531\u6d41\u8282\u70b9\uff0c\u8bf7\u7528\u666e\u901a\u63d0\u4ea4\u65b9\u5f0f\u63d0\u4ea4\u5de5\u4f5c\uff01");
        }
        boolean needSelectNode = false;
        boolean needSelectActor = false;
        boolean isFree = isFreeSubmit && this.freeType != 0;
        Flow flow = flowInstance.getTemplet();
        Iterator it = this.nextTrans.entrySet().iterator();
        block0 : switch (this.freeType * (isFreeSubmit ? 1 : 0)) {
            case 0: {
                FlowTrans trans;
                if (this.embranch == EMBRANCH_ALL) {
                    while (it.hasNext()) {
                        entry = it.next();
                        trans = (FlowTrans)entry.getValue();
                        if (!trans.isEnabled(flowInstance)) {
                            throw new Exception("\u6d41\u7a0b\u5b9e\u4f8b\u65e0\u6cd5\u63d0\u4ea4\uff1a" + trans.getName());
                        }
                        node = trans.getTo();
                        nodeId = String.valueOf(node.getId());
                        nodes.put(nodeId, node);
                    }
                } else if (this.embranch == EMBRANCH_MULTI) {
                    while (it.hasNext()) {
                        entry = it.next();
                        trans = (FlowTrans)entry.getValue();
                        if (!trans.isEnabled(flowInstance)) continue;
                        node = trans.getTo();
                        nodeId = String.valueOf(node.getId());
                        nodes.put(nodeId, node);
                    }
                } else if (this.embranch == EMBRANCH_MULTI_SELECT) {
                    while (it.hasNext()) {
                        entry = it.next();
                        trans = (FlowTrans)entry.getValue();
                        if (!trans.isEnabled(flowInstance)) continue;
                        node = trans.getTo();
                        nodeId = String.valueOf(node.getId());
                        nodes.put(nodeId, node);
                    }
                } else if (this.embranch == EMBRANCH_SINGLE) {
                    while (it.hasNext()) {
                        entry = it.next();
                        trans = (FlowTrans)entry.getValue();
                        if (!trans.isEnabled(flowInstance)) continue;
                        node = trans.getTo();
                        nodeId = String.valueOf(node.getId());
                        nodes.put(nodeId, node);
                        break block0;
                    }
                } else {
                    if (this.embranch != EMBRANCH_SINGLE_SELECT) break;
                    while (it.hasNext()) {
                        entry = it.next();
                        trans = (FlowTrans)entry.getValue();
                        if (!trans.isEnabled(flowInstance)) continue;
                        node = trans.getTo();
                        nodeId = String.valueOf(node.getId());
                        nodes.put(nodeId, node);
                    }
                }
                break;
            }
            case 1: {
                this.getAllToNode(nodes);
                break;
            }
            case 2: {
                nodes.putAll(flow.getNodes());
                break;
            }
            case 3: {
                int i = 0;
                while (i < this.freeData.length) {
                    nodeId = String.valueOf(this.freeData[i]);
                    nodes.put(nodeId, flow.getNodeById(this.freeData[i]));
                    ++i;
                }
                break;
            }
        }
        if ((isFree || this.embranch == EMBRANCH_SINGLE_SELECT || this.embranch == EMBRANCH_MULTI_SELECT) && nodes.size() > 1) {
            needSelectNode = true;
        }
        ArrayList<TreeNodeBean> flowNodes = new ArrayList<TreeNodeBean>();
        TreeMap<String, BaseObject> orderUsers = new TreeMap<String, BaseObject>();
        it = nodes.entrySet().iterator();
        int nodeIndex = 0;
        while (it.hasNext()) {
            entry = it.next();
            node = (FlowNode)entry.getValue();
            nodeId = String.valueOf(node.getId());
            Map users = node.getSelectActors(flowInstance, -1);
            TreeNodeBean treeNode = new TreeNodeBean();
            treeNode.setTableId("FlowNode");
            treeNode.setText(node.getName());
            treeNode.setObjectId(nodeId);
            treeNode.setId(nodeId);
            treeNode.setExpanded(true);
            treeNode.setIconSrc(icon);
            treeNode.setGetData(true);
            treeNode.setChecked(!needSelectNode);
            treeNode.setDisabled(!needSelectNode);
            if (users != null) {
                BaseObject user;
                orderUsers.clear();
                for (Map.Entry usersEntry : users.entrySet()) {
                    user = (BaseObject)usersEntry.getValue();
                    orderUsers.put(String.valueOf(StringTool.leftPad(String.valueOf(user.getShowOrder()), 10, '0')) + user.getId(), user);
                }
                needSelectActor = true;
                TreeNodeBean[] userNodes = new TreeNodeBean[users.size()];
                Iterator tempIt = orderUsers.keySet().iterator();
                int i = 0;
                while (tempIt.hasNext()) {
                    user = (BaseObject)orderUsers.get(tempIt.next());
                    String userId = user.getId();
                    TreeNodeBean userNode = new TreeNodeBean();
                    userNode.setText(user.getDisplayName());
                    userNode.setObjectId(userId);
                    userNode.attachField.put("SHOWORDER", String.valueOf(user.getShowOrder()));
                    if (user instanceof User) {
                        User userObj = (User)user;
                        userNode.setTableId("User");
                        userNode.setIconSrc(User.icon);
                        userNode.attachField.put("DEPTID", userObj.getDeptId());
                        userNode.attachField.put("DEPTNAME", userObj.getDeptName());
                        userNode.attachField.put("COMPID", userObj.getCompId());
                        userNode.attachField.put("COMPNAME", userObj.getCompName());
                        userNode.attachField.put("CODE", userObj.getCode());
                        userNode.attachField.put("ROLES", userObj.getRoles());
                    } else if (user instanceof Organize) {
                        userNode.setTableId("Organize");
                        userNode.setIconSrc(Organize.icon);
                    } else if (user instanceof Role) {
                        userNode.setTableId("Role");
                        userNode.setIconSrc(Role.icon);
                    }
                    userNode.setId(String.valueOf(nodeId) + userId);
                    userNode.setParentId(nodeId);
                    userNode.setParentObjectId(nodeId);
                    userNode.setExpanded(false);
                    userNode.setGetData(true);
                    userNodes[i++] = userNode;
                }
                treeNode.setChilds(userNodes);
            }
            flowNodes.add(treeNode);
            ++nodeIndex;
        }
        if (needSelectNode || needSelectActor) {
            return flowNodes;
        }
        return null;
    }

    public Object start(FlowInstance flowInstance, int preNodeInstanceId, Object[] selectedReceiveIds) throws Exception {
        int[] preNodeInstanceIds;
        Iterator it = this.preTrans.entrySet().iterator();
        FlowNodeInstance nodeInstance = flowInstance.getUnStartInstance(this);
        boolean hasComplet = true;
        if (this.coverge == CONVERGE_ALL) {
            if (nodeInstance == null) {
                nodeInstance = FlowNodeInstance.create(flowInstance, this);
            }
            nodeInstance.addPreNodeInstanceId(preNodeInstanceId);
            preNodeInstanceIds = nodeInstance.getPreNodeInstanceIds();
            int len = preNodeInstanceIds.length;
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                FlowTrans trans = (FlowTrans)entry.getValue();
                hasComplet = false;
                int i = 0;
                while (i < len) {
                    FlowNodeInstance preNodeInstance = flowInstance.getFlowNodeInstance(preNodeInstanceIds[i]);
                    if (trans.getFrom().isInstance(preNodeInstance)) {
                        hasComplet = true;
                        break;
                    }
                    ++i;
                }
                if (hasComplet) {
                    continue;
                }
                break;
            }
        } else if (this.coverge == CONVERGE_MULTI) {
            if (nodeInstance == null) {
                nodeInstance = FlowNodeInstance.create(flowInstance, this);
            }
            nodeInstance.addPreNodeInstanceId(preNodeInstanceId);
            preNodeInstanceIds = nodeInstance.getPreNodeInstanceIds();
            int len = preNodeInstanceIds.length;
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                FlowTrans trans = (FlowTrans)entry.getValue();
                if (!trans.isEnabled(flowInstance)) continue;
                hasComplet = false;
                int i = 0;
                while (i < len) {
                    FlowNodeInstance preNodeInstance = flowInstance.getFlowNodeInstance(preNodeInstanceIds[i]);
                    if (trans.getFrom().isInstance(preNodeInstance)) {
                        hasComplet = true;
                        break;
                    }
                    ++i;
                }
                if (hasComplet) {
                    continue;
                }
                break;
            }
        } else if (this.coverge == CONVERGE_SINGLE) {
            nodeInstance = FlowNodeInstance.create(flowInstance, this);
            nodeInstance.addPreNodeInstanceId(preNodeInstanceId);
            hasComplet = true;
        }
        int nodeInstanceId = nodeInstance.getNodeInstanceId();
        if (hasComplet) {
            nodeInstance.startUp();
            this.createOperator(flowInstance, nodeInstanceId, selectedReceiveIds);
        }
        return hasComplet ? Boolean.TRUE : Boolean.FALSE;
    }

    public void createOperator(FlowInstance flowInstance, int nodeInstanceId, Object[] selectedReceiveIds) throws Exception {
        FlowNodeInstance nodeInstance = flowInstance.getFlowNodeInstance(nodeInstanceId);
        this.startTask(flowInstance, nodeInstance.getNodeInstanceId(), this.flowActors, selectedReceiveIds);
    }

    public Map getReceivers(FlowInstance flowInstance, int nodeInstanceId) {
        HashMap list = new HashMap(128);
        for (FlowActor actor : this.flowActors) {
            Map agentActors = actor.getActors(flowInstance, nodeInstanceId, this.id);
            list.putAll(agentActors);
        }
        return list;
    }

    public boolean exec(FlowNodeInstance flowNodeInstance) throws Exception {
        return this.execTask(flowNodeInstance);
    }

    public List getUntreadNodes(FlowInstance flowInstance, int nodeInstanceId, Map nodes) throws Exception {
        Iterator it = null;
        FlowNodeInstance nodeInstance = flowInstance.getFlowNodeInstance(nodeInstanceId);
        FlowNodeInstance preNodeInstance = null;
        boolean canUntread = this.getUntreadInstance(flowInstance, nodeInstance, nodes);
        if (!canUntread) {
            throw new Exception("\u6ca1\u6709\u627e\u5230\u8981\u9000\u56de\u7684\u8282\u70b9\uff01");
        }
        boolean needSelectActor = false;
        boolean needSelectNode = nodes.size() > 1;
        ArrayList<TreeNodeBean> flowNodes = new ArrayList<TreeNodeBean>();
        TreeMap<String, BaseObject> orderUsers = new TreeMap<String, BaseObject>();
        it = nodes.entrySet().iterator();
        int nodeIndex = 0;
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            preNodeInstance = (FlowNodeInstance)entry.getValue();
            FlowNode node = flowInstance.getTemplet().getNodeById(Integer.parseInt((String)entry.getKey()));
            String nodeId = String.valueOf(node.getId());
            Map users = node.getReceivers(flowInstance, preNodeInstance.getNodeInstanceId());
            TreeNodeBean treeNode = new TreeNodeBean();
            treeNode.setTableId("FlowNode");
            treeNode.setText(node.getName());
            treeNode.setObjectId(nodeId);
            treeNode.setId(nodeId);
            treeNode.setExpanded(true);
            treeNode.setIconSrc(icon);
            treeNode.setGetData(true);
            treeNode.setChecked(!needSelectNode);
            treeNode.setDisabled(!needSelectNode);
            if (users != null) {
                boolean userHasDel = false;
                List untreadToNodeInstances = flowInstance.getNodeInstance(node);
                for (FlowNodeInstance untreadToNodeInstance : untreadToNodeInstances) {
                    if (untreadToNodeInstance.getFlowNodeId() == node.getId()) {
                        HashMap<String, FlowOperator> operators = untreadToNodeInstance.getOperatorManager().getOperators();
                        Iterator operatorsIt = operators.keySet().iterator();
                        block2: while (!userHasDel && operatorsIt.hasNext()) {
                            userHasDel = true;
                            String oldUserId = (String)operatorsIt.next();
                            List actors = node.getFlowActors();
                            int i = 0;
                            while (i < actors.size()) {
                                if (actors.get(i) instanceof FlowActorList) {
                                    if (((FlowActorList)actors.get(i)).getFinalActors(flowInstance, nodeInstanceId, node.getId()).containsKey(oldUserId)) {
                                        userHasDel = false;
                                        continue block2;
                                    }
                                } else if (users.containsKey(oldUserId)) {
                                    userHasDel = false;
                                    continue block2;
                                }
                                ++i;
                            }
                        }
                    }
                    if (userHasDel) break;
                }
                if (userHasDel) {
                    BaseObject user;
                    orderUsers.clear();
                    for (Map.Entry usersEntry : users.entrySet()) {
                        user = (BaseObject)usersEntry.getValue();
                        orderUsers.put(String.valueOf(StringTool.leftPad(String.valueOf(user.getShowOrder()), 10, '0')) + user.getId(), user);
                    }
                    needSelectActor = true;
                    TreeNodeBean[] userNodes = new TreeNodeBean[users.size()];
                    Iterator tempIt = orderUsers.keySet().iterator();
                    int i = 0;
                    while (tempIt.hasNext()) {
                        user = (BaseObject)orderUsers.get(tempIt.next());
                        String userId = user.getId();
                        TreeNodeBean userNode = new TreeNodeBean();
                        userNode.setText(user.getName());
                        userNode.setObjectId(userId);
                        userNode.attachField.put("SHOWORDER", String.valueOf(user.getShowOrder()));
                        if (user instanceof User) {
                            User userObj = (User)user;
                            userNode.setTableId("User");
                            userNode.setIconSrc(User.icon);
                            userNode.attachField.put("DEPTID", userObj.getDeptId());
                            userNode.attachField.put("DEPTNAME", userObj.getDeptName());
                            userNode.attachField.put("COMPID", userObj.getCompId());
                            userNode.attachField.put("COMPNAME", userObj.getCompName());
                            userNode.attachField.put("CODE", userObj.getCode());
                            userNode.attachField.put("ROLES", userObj.getRoles());
                        } else if (user instanceof Organize) {
                            userNode.setTableId("Organize");
                            userNode.setIconSrc(Organize.icon);
                        } else if (user instanceof Role) {
                            userNode.setTableId("Role");
                            userNode.setIconSrc(Role.icon);
                        }
                        userNode.setId(String.valueOf(nodeId) + userId);
                        userNode.setParentId(nodeId);
                        userNode.setParentObjectId(nodeId);
                        userNode.setExpanded(false);
                        userNode.setGetData(true);
                        userNodes[i++] = userNode;
                    }
                    treeNode.setChilds(userNodes);
                } else {
                    needSelectActor = false;
                }
            }
            flowNodes.add(treeNode);
            ++nodeIndex;
        }
        if (needSelectNode || needSelectActor) {
            return flowNodes;
        }
        return null;
    }

    private boolean getUntreadInstance(FlowInstance flowInstance, FlowNodeInstance nodeInstance, Map nodes) {
        boolean canUntread = false;
        int[] preNodeInstanceIds = nodeInstance.getPreNodeInstanceIds();
        if (preNodeInstanceIds != null && preNodeInstanceIds.length > 0) {
            int i = 0;
            while (i < preNodeInstanceIds.length) {
                FlowNodeInstance preNodeInstance = flowInstance.getFlowNodeInstance(preNodeInstanceIds[i]);
                if (preNodeInstance != null) {
                    boolean tempCanUntread = this.canUntreadTo(preNodeInstance, nodes);
                    boolean pCanUntread = this.getUntreadInstance(flowInstance, preNodeInstance, nodes);
                    canUntread = canUntread || tempCanUntread || pCanUntread;
                }
                ++i;
            }
        }
        return canUntread;
    }

    private boolean canUntreadTo(FlowNodeInstance nodeInstance, Map nodes) {
        FlowNode node;
        FlowTrans trans;
        boolean canUntread = false;
        if (this.preTrans != null && this.preTrans.size() > 0) {
            for (Map.Entry entry : this.preTrans.entrySet()) {
                trans = (FlowTrans)entry.getValue();
                if (!trans.isCanUntread() || (node = trans.getFrom()) == null || nodeInstance.getFlowNodeId() != node.getId()) continue;
                canUntread = true;
                String nodeId = String.valueOf(node.getId());
                if (!nodes.containsKey(nodeId)) {
                    nodes.put(nodeId, nodeInstance);
                }
                return canUntread;
            }
        }
        if (this.untreadTrans != null && this.untreadTrans.size() > 0) {
            for (Map.Entry entry : this.untreadTrans.entrySet()) {
                trans = (FlowTrans)entry.getValue();
                node = trans.getTo();
                if (node == null || nodeInstance.getFlowNodeId() != node.getId()) continue;
                canUntread = true;
                String nodeId = String.valueOf(node.getId());
                if (!nodes.containsKey(nodeId)) {
                    nodes.put(nodeId, nodeInstance);
                }
                return canUntread;
            }
        }
        return canUntread;
    }

    public Object startForUntread(FlowInstance flowInstance, int preNodeInstanceId, String reson, Object[] selectedReceiveIds) throws Exception {
        FlowNodeInstance nodeInstance = flowInstance.getUnStartInstance(this);
        if (nodeInstance == null) {
            nodeInstance = FlowNodeInstance.create(flowInstance, this);
        }
        String flowInstanceId = flowInstance.getId();
        int nodeInstanceId = nodeInstance.getNodeInstanceId();
        nodeInstance.addPreNodeInstanceId(preNodeInstanceId);
        nodeInstance.setUntreadReason(reson);
        List nodes = flowInstance.getNodeInstance(this);
        for (FlowNodeInstance preNodeInstance : nodes) {
            if (nodeInstance.equals(preNodeInstance)) continue;
            preNodeInstance.untread();
            preNodeInstance.addNotes("\u88ab");
            if (User.getCurrentUser() != null) {
                preNodeInstance.addNotes(User.getCurrentUser().getName());
            }
            preNodeInstance.addNotes("\u9000\u56de\uff1a");
            preNodeInstance.addNotes(reson);
            preNodeInstance.addNotes("  ");
            nodeInstance.copyOperator(preNodeInstance, true, reson, selectedReceiveIds);
            List counterSigns = CounterSign.copy(flowInstanceId, preNodeInstance.getNodeInstanceId(), nodeInstanceId);
            int i = 0;
            while (i < counterSigns.size()) {
                nodeInstance.addCounterSigns((CounterSign)counterSigns.get(i));
                ++i;
            }
            break block0;
        }
        nodeInstance.startUpUntread();
        return Boolean.TRUE;
    }

    public boolean callback(FlowInstance flowInstance, int nodeInstanceId) throws Exception {
        return false;
    }

    public boolean checkLimit(FlowInstance flowInstance, int nodeInstanceId) throws Exception {
        return false;
    }

    public void addFlowActor(FlowActor flowActor) {
        if (this.flowActors == null) {
            this.flowActors = new ArrayList();
        }
        if (!this.flowActors.contains(flowActor)) {
            this.flowActors.add(flowActor);
        }
    }

    public void addFlowEvent(FlowEvent flowEvent) {
        if (this.flowEvents == null) {
            this.flowEvents = new ArrayList();
        }
        if (!this.flowEvents.contains(flowEvent)) {
            this.flowEvents.add(flowEvent);
        }
    }

    public void addParameterValue(String parameterName, Object parameterValue) {
        if (this.parameterValues == null) {
            this.parameterValues = new HashMap();
        }
        this.parameterValues.put(parameterName, parameterValue);
    }

    public void setPreTrans(Map preTrans) {
        this.preTrans = preTrans;
    }

    public int getDefaultForm() {
        if (this.defaultForm >= 0) {
            return this.defaultForm;
        }
        if (this.allowForms != null && this.allowForms.size() > 0) {
            return Integer.parseInt((String)this.allowForms.get(0));
        }
        return -1;
    }

    public boolean isAllowForm(int formId) {
        if (this.allowForms != null) {
            int len = this.allowForms.size();
            int i = 0;
            while (i < len) {
                String allowFormId = (String)this.allowForms.get(i);
                if (allowFormId != null && allowFormId.equals(String.valueOf(formId))) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public boolean isCreateForm(int formId) {
        if (this.createForms != null) {
            int len = this.createForms.size();
            int i = 0;
            while (i < len) {
                String allowFormId = (String)this.createForms.get(i);
                if (allowFormId != null && allowFormId.equals(String.valueOf(formId))) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public boolean isInstance(FlowNodeInstance nodeInstance) {
        return this.id == nodeInstance.getFlowNodeId();
    }

    public String getName() {
        return this.name;
    }

    public String getStatusName() {
        return this.statusName;
    }

    public int getFreeType() {
        return this.freeType;
    }

    public String toJson() {
        StringBuffer script = new StringBuffer(1024);
        script.append("new com.sdjxd.pms.platform.workflow.FlowNode({");
        script.append("id:'").append(this.id).append("'");
        script.append(",name:'").append(this.name).append("'");
        script.append(",createForms:").append(BeanTool.toJson(this.createForms));
        script.append(",allowForms:").append(BeanTool.toJson(this.allowForms));
        script.append(",freeType:").append(this.freeType);
        script.append(",embranch:").append(this.embranch);
        script.append(",freeData:").append(BeanTool.toJson(this.freeData));
        script.append(",flowActors:").append(BeanTool.toJson(this.flowActors));
        script.append(",to:").append(BeanTool.toJson(this.nextTrans));
        script.append("})");
        return script.toString();
    }

    public static List getActors(String flowInstanceId, int nodeInstanceId, int flowNodeId) throws Exception {
        FlowInstance flowInstance = FlowInstance.loadFromDb(flowInstanceId);
        if (flowInstance != null) {
            Flow flow = flowInstance.getTemplet();
            FlowNode node = flow.getNodeById(flowNodeId);
            Map users = null;
            for (FlowActor actor : node.flowActors) {
                users = actor.getActors(flowInstance, nodeInstanceId, node.id);
            }
            String nodeId = String.valueOf(flowNodeId);
            ArrayList<TreeNodeBean> flowNodes = new ArrayList<TreeNodeBean>();
            TreeNodeBean treeNode = new TreeNodeBean();
            treeNode.setTableId("FlowNode");
            treeNode.setText(node.getName());
            treeNode.setObjectId(nodeId);
            treeNode.setId(nodeId);
            treeNode.setExpanded(true);
            treeNode.setIconSrc(icon);
            treeNode.setGetData(true);
            treeNode.setChecked(true);
            treeNode.setDisabled(true);
            if (users != null) {
                int len = users.size();
                TreeNodeBean[] userNodes = new TreeNodeBean[len];
                Iterator it = users.entrySet().iterator();
                int i = 0;
                while (it.hasNext()) {
                    TreeNodeBean userNode = new TreeNodeBean();
                    Map.Entry entry = it.next();
                    BaseObject user = (BaseObject)entry.getValue();
                    String userId = user.getId();
                    userNode.setText(user.getName());
                    userNode.setObjectId(userId);
                    userNode.setId(String.valueOf(nodeId) + userId);
                    userNode.setParentId(nodeId);
                    userNode.setParentObjectId(nodeId);
                    userNode.setExpanded(false);
                    userNode.setGetData(true);
                    if (user instanceof User) {
                        userNode.setTableId("User");
                        userNode.setIconSrc(User.icon);
                    } else if (user instanceof Organize) {
                        userNode.setTableId("Organize");
                        userNode.setIconSrc(Organize.icon);
                    } else if (user instanceof Role) {
                        userNode.setTableId("Role");
                        userNode.setIconSrc(Role.icon);
                    }
                    userNodes[i++] = userNode;
                }
                treeNode.setChilds(userNodes);
            }
            flowNodes.add(treeNode);
            return flowNodes;
        }
        throw new Exception("\u6d41\u7a0b\u5b9e\u4f8b\u7f16\u7801\u9519\u8bef\uff01");
    }

    public Map getSelectActors(FlowInstance flowInstance, int nodeInstanceId) {
        for (FlowActor actor : this.flowActors) {
            if (!(actor instanceof FlowActorList) || !((FlowActorList)actor).isMoreSelect()) continue;
            return actor.getActors(flowInstance, nodeInstanceId, this.id);
        }
        return null;
    }

    public void getAllToNode(Map nodes) {
        for (Map.Entry entry : this.nextTrans.entrySet()) {
            FlowTrans trans = (FlowTrans)entry.getValue();
            FlowNode toNode = trans.getTo();
            if (toNode == null || nodes.containsValue(toNode)) continue;
            nodes.put(String.valueOf(toNode.getId()), toNode);
            toNode.getAllToNode(nodes);
        }
    }

    public Map getParameterValues() {
        return this.parameterValues;
    }

    public boolean execTask(FlowNodeInstance nodeInstance) throws Exception {
        boolean isExec = false;
        User user = User.getCurrentUser();
        if (user == null) {
            throw new Exception("\u60a8\u8fd8\u6ca1\u6709\u767b\u5f55\u6216\u8005\u767b\u5f55\u8d85\u65f6,\u8bf7\u91cd\u65b0\u767b\u5f55\uff01");
        }
        String userId = user.getId();
        if (!this.multi) {
            String operId = nodeInstance.getWaitDoId();
            isExec = true;
        } else {
            isExec = this.orderExec ? true : true;
        }
        return isExec;
    }

    public void startTask(FlowInstance flowInstance, int nodeInstanceId, List flowActors, Object[] selectedReceiveIds) throws Exception {
        String flowInstanceId = flowInstance.getId();
        FlowNodeInstance nodeInstance = flowInstance.getFlowNodeInstance(nodeInstanceId);
        int type = 0;
        for (FlowActor actor : flowActors) {
            CounterSign counterSign;
            BaseObject user;
            if (actor instanceof FlowActorList && selectedReceiveIds != null) {
                FlowActorList actorList = (FlowActorList)actor;
                int receiverIdsLen = selectedReceiveIds.length;
                if (receiverIdsLen <= 0) {
                    throw new Exception("\u60a8\u5fc5\u987b\u9009\u62e9\u6d41\u7a0b\u5b9e\u4f8b\u7684\u63a5\u6536\u4eba\u5458\uff01");
                }
                if (actorList.isSingleOperator() && receiverIdsLen > 1) {
                    throw new Exception("\u63a5\u6536\u4eba\u53ea\u80fd\u67091\u4e2a\uff01");
                }
                int index = 0;
                while (index < receiverIdsLen) {
                    type = 0;
                    if (selectedReceiveIds[index] instanceof String) {
                        user = User.getUser((String)selectedReceiveIds[index]);
                    } else if (selectedReceiveIds[index] instanceof BaseObject) {
                        user = (BaseObject)selectedReceiveIds[index];
                        if (selectedReceiveIds[index] instanceof User) {
                            type = 0;
                        } else if (selectedReceiveIds[index] instanceof Organize) {
                            type = 2;
                        } else if (selectedReceiveIds[index] instanceof Role) {
                            type = 1;
                        }
                    } else {
                        user = User.getUser((String)selectedReceiveIds[index]);
                    }
                    nodeInstance.addReceiver(user, this.pending, type);
                    if (this.multi) {
                        counterSign = CounterSign.create(flowInstanceId, nodeInstanceId, flowInstance.getFlowId(), flowInstance.getFlowName(), nodeInstance.getFlowNodeId(), nodeInstance.getFlowNodeName(), user.getId(), type);
                        nodeInstance.addCounterSigns(counterSign);
                    }
                    ++index;
                }
                continue;
            }
            Map agentActors = actor.getActors(flowInstance, nodeInstanceId, this.id);
            if (agentActors.size() <= 0) {
                throw new Exception("\u6d41\u7a0b\u5b9e\u4f8b\u6ca1\u6709\u63a5\u6536\u4eba\u5458\uff01");
            }
            for (Map.Entry entry : agentActors.entrySet()) {
                user = (BaseObject)entry.getValue();
                String userId = user.getId();
                type = user instanceof User ? 0 : (user instanceof Organize ? 2 : (user instanceof Role ? 1 : 0));
                nodeInstance.addReceiver(user, this.pending, type);
                if (!this.multi) continue;
                counterSign = CounterSign.create(flowInstanceId, nodeInstanceId, flowInstance.getFlowId(), flowInstance.getFlowName(), nodeInstance.getFlowNodeId(), nodeInstance.getFlowNodeName(), userId, type);
                nodeInstance.addCounterSigns(counterSign);
            }
        }
    }

    public boolean submitTask(FlowInstance flowInstance, int nodeInstanceId, FlowOperator operator) throws Exception {
        boolean complet = false;
        String userId = null;
        User user = User.getCurrentUser();
        if (user != null) {
            userId = user.getId();
        }
        FlowNodeInstance nodeInstance = flowInstance.getFlowNodeInstance(nodeInstanceId);
        Date operEnd = new Date();
        if (operator != null) {
            operator.setEndTime(operEnd);
        }
        if (this.pending && userId != null) {
            String operId = nodeInstance.getWaitDoId();
            HashMap<String, String> map = new HashMap<String, String>();
            if (this.multi) {
                nodeInstance.addWaitDo(WaitDo.delete(operId, userId));
                map.put("flowInstanceId", nodeInstance.getFlowInstanceId());
                map.put("nodeInstanceId", String.valueOf(nodeInstanceId));
                nodeInstance.addFlowWeChatDo(FlowWeChartBo.delete(map, userId));
            } else {
                nodeInstance.addWaitDo(WaitDo.delete(operId, userId));
                map.put("flowInstanceId", nodeInstance.getFlowInstanceId());
                map.put("nodeInstanceId", String.valueOf(nodeInstanceId));
                nodeInstance.addFlowWeChatDo(FlowWeChartBo.delete(map, userId));
            }
            String operName = flowInstance.getFlowName();
            FlowInstanceSession session = new FlowInstanceSession(flowInstance, nodeInstance.getNodeInstanceId(), -1, -1, null, false);
            String operUrl = session.getPageUrl();
            String operContent = (String)flowInstance.getParameter("NAME");
            if (operator != null) {
                Date operStart = operator.getBeginTime();
                nodeInstance.addHaveDo(HaveDo.create(operId, operName, operUrl, userId, operContent, operStart, operEnd, this.openType));
            }
        }
        if (!this.multi) {
            complet = true;
        } else {
            int count = nodeInstance.receiverCount();
            int completCount = nodeInstance.completCount();
            if (this.completeRole == ROLE_WHOLE) {
                complet = completCount >= count;
            } else if (this.completeRole == ROLE_QUANTITY) {
                complet = completCount >= this.completeData;
            } else if (this.completeRole == ROLE_PERCENT) {
                complet = completCount * 100 >= this.completeData * count;
            }
        }
        return complet;
    }

    public void registerEvent(FlowNodeInstance flowNodeInstance) {
        for (FlowEvent event : this.flowEvents) {
            event.registerEvent(flowNodeInstance);
        }
    }

    public void addCreateForm(int formId) {
        this.createForms.add(String.valueOf(formId));
    }

    public String getStatusId() {
        return this.statusId;
    }

    public boolean isPending() {
        return this.pending;
    }

    public List getAllowForms() {
        return this.allowForms;
    }

    public void checkTimeLimit(String flowInstanceId, int nodeInstanceId, Date createTime) throws Exception {
        Date now = Calendar.getInstance().getTime();
        long min = DateTool.diffSecond(now, createTime);
        boolean delay = false;
        switch (this.limitType) {
            case 1: {
                delay = min / 60L >= (long)this.timeSlice;
                break;
            }
            case 2: {
                FlowInstanceDao dao = FlowInstanceDao.createInstance();
                String paramValue = dao.getFlowParamInstance(this.flowId, flowInstanceId, this.timeSlice);
                if (StringTool.isEmpty(paramValue)) {
                    delay = true;
                    break;
                }
                delay = min / 60L >= (long)Integer.parseInt(paramValue);
                break;
            }
            default: {
                delay = false;
            }
        }
        if (delay) {
            FlowOverTime overTime = FlowOverTime.createInstance(this.overTimeClass);
            overTime.load(flowInstanceId, nodeInstanceId);
            overTime.run();
        }
    }

    public Date getOverTime(FlowInstance flowInstance, Date createTime) throws Exception {
        Calendar createCal = Calendar.getInstance();
        createCal.setTime(createTime);
        int min = 0;
        Date delayCal = null;
        switch (this.limitType) {
            case 1: {
                min = this.timeSlice * 60;
                delayCal = DateTool.addSeconds(createCal, min).getTime();
                break;
            }
            case 2: {
                String paramValue = (String)flowInstance.getParameterValue(this.timeSlice);
                min = StringTool.isEmpty(paramValue) ? 0 : Integer.parseInt(paramValue) * 60;
                delayCal = DateTool.addSeconds(createCal, min).getTime();
                break;
            }
            default: {
                min = 0;
            }
        }
        return delayCal;
    }

    public String getOpenType() {
        return this.openType;
    }

    public ArrayList getPreNode() {
        ArrayList<FlowNode> nodes = new ArrayList<FlowNode>();
        for (Map.Entry entry : this.preTrans.entrySet()) {
            FlowTrans trans = (FlowTrans)entry.getValue();
            nodes.add(trans.getFrom());
        }
        return nodes;
    }

    public List getCreateForms() {
        return this.createForms;
    }

    private void loadSendMsgActor(List list) throws Exception {
        this.sendMsgActors = new HashMap();
        int i = 0;
        while (i < list.size()) {
            List<FlowSendMsgActor> actors;
            FlowSendMsgActorBean model = (FlowSendMsgActorBean)list.get(i);
            FlowSendMsgActor fa = FlowSendMsgActor.createInstance(model);
            String action = model.getAction();
            if (this.sendMsgActors.containsKey(action)) {
                actors = (List)this.sendMsgActors.get(action);
            } else {
                actors = new ArrayList();
                this.sendMsgActors.put(action, actors);
            }
            actors.add(fa);
            ++i;
        }
    }

    public void sendMsg(String flowInstanceId, int nodeInstanceId, String action) throws Exception {
        FlowInstance flowInstance = FlowInstance.load(flowInstanceId);
        List list = (List)this.sendMsgActors.get(action);
        if (list != null) {
            ArrayList<String> users = new ArrayList<String>();
            String msg = "\u6d41\u7a0b\u5b9e\u4f8b\u901a\u77e5";
            int i = 0;
            while (i < list.size()) {
                FlowSendMsgActor fa = (FlowSendMsgActor)list.get(i);
                Map actors = fa.getOriginalActors(flowInstance, nodeInstanceId);
                for (String userId : actors.keySet()) {
                    if (StringTool.isEmpty(userId) || users.contains(userId)) continue;
                    users.add(userId);
                }
                msg = fa.getMsg();
                ++i;
            }
            int flowFormId = this.getDefaultForm();
            String formInstanceId = null;
            FlowFormInstance flowFormInstance = flowInstance.getForm(flowFormId);
            if (flowFormInstance != null) {
                formInstanceId = flowFormInstance.getInstanceId();
            }
            String operUrl = FlowInstanceSession.getFormUrl(flowInstance, nodeInstanceId, flowFormId, formInstanceId, false);
            String operId = String.valueOf(flowInstanceId) + String.valueOf(nodeInstanceId);
            String[] userIds = new String[users.size()];
            users.toArray(userIds);
            Message.saveUserMessage(userIds, flowInstance.replace(msg, nodeInstanceId), operUrl, operId);
        }
    }

    public List getFlowActors() {
        return this.flowActors;
    }

    public int getEmbranch() {
        return this.embranch;
    }

    public boolean submitToNext72(FlowInstance flowInstance, int nodeInstanceId, Map toNodes, boolean isFreeSubmit) throws Exception {
        FlowNodeInstance flowNodeInstance;
        FlowOperatorManager operatorManager;
        List runingNodes = flowInstance.getRunStatusNodeInstanceNew();
        FlowNodeInstance nodeInstance = flowInstance.getFlowNodeInstance(nodeInstanceId);
        if (runingNodes.size() == 1 && !isFreeSubmit) {
            Flow flow = flowInstance.getTemplet();
            Iterator it = toNodes.entrySet().iterator();
            boolean canStart = false;
            ArrayList<String> canStartNode = new ArrayList<String>();
            log.info((Object)("\u6d41\u7a0b\u63d0\u4ea4\u5f02\u5e38\u5224\u65ad\uff1a\u8981\u63d0\u4ea4\u5230\u7684\u8282\u70b9" + toNodes.toString()));
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                int flowNodeId = Integer.parseInt((String)entry.getKey());
                FlowNode node = flow.getNodeById(flowNodeId);
                boolean result = node.canStart72(flowInstance, nodeInstanceId);
                if (!result) continue;
                canStart = true;
                canStartNode.add(String.valueOf(flowNodeId));
            }
            if (!canStart) {
                throw new Exception("\u6d41\u7a0b\u63d0\u4ea4\u5931\u8d25\uff01\u65e0\u6cd5\u542f\u52a8\u540e\u7eed\u8282\u70b9\uff0c\u5426\u5219\u4f1a\u9020\u6210\u6d41\u7a0b\u5047\u6b7b\uff01");
            }
            boolean canEnd = flowInstance.checkEnd(canStartNode);
            if (!canEnd) {
                throw new Exception("\u6d41\u7a0b\u63d0\u4ea4\u5931\u8d25\uff01\u63d0\u4ea4\u5c06\u5bfc\u81f4\u6d41\u7a0b\u65e0\u6cd5\u7ed3\u675f\uff01");
            }
        }
        if (this.submit(flowInstance, nodeInstanceId, (operatorManager = (flowNodeInstance = flowInstance.getFlowNodeInstance(nodeInstanceId)).getOperatorManager()).getCurrentOperator())) {
            if (toNodes == null || toNodes.isEmpty()) {
                throw new Exception("\u65e0\u6cd5\u83b7\u53d6\u8981\u63d0\u4ea4\u7684\u8282\u70b9\uff01");
            }
            Iterator it = toNodes.entrySet().iterator();
            Flow flow = flowInstance.getTemplet();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                int flowNodeId = Integer.parseInt((String)entry.getKey());
                Object submitData = entry.getValue();
                FlowNode node = flow.getNodeById(flowNodeId);
                if (submitData instanceof Object[]) {
                    if (!isFreeSubmit) {
                        node.start72(flowInstance, nodeInstanceId, (Object[])submitData);
                        continue;
                    }
                    node.start72ForUFlow(flowInstance, nodeInstanceId, (Object[])submitData);
                    continue;
                }
                if (!isFreeSubmit) {
                    node.start72(flowInstance, nodeInstanceId, null);
                    continue;
                }
                node.start72ForUFlow(flowInstance, nodeInstanceId, null);
            }
        }
        return true;
    }

    public boolean canStart72(FlowInstance flowInstance, int preNodeInstanceId) {
        FlowNodeInstance preNodeInstance = flowInstance.getFlowNodeInstance(preNodeInstanceId);
        FlowNodeInstance nodeInstance = flowInstance.getUnStartInstance(this);
        Iterator it = this.preTrans.entrySet().iterator();
        if (this.coverge == CONVERGE_MULTI) {
            log.info((Object)"\u591a\u8def\u805a\u5408");
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                FlowTrans trans = (FlowTrans)entry.getValue();
                if (!trans.isEnabled(flowInstance) || trans.getFrom().isInstance(preNodeInstance)) continue;
                if (nodeInstance == null) {
                    log.info((Object)(String.valueOf(trans.getFrom().getId()) + "->" + trans.getTo().getId() + "\u4e0d\u6210\u7acb"));
                    return false;
                }
                int[] preIds = nodeInstance.getPreNodeInstanceIds();
                boolean hasInstance = false;
                int i = 0;
                while (i < preIds.length) {
                    FlowNodeInstance temPreNodeInstance = flowInstance.getFlowNodeInstance(preIds[i]);
                    if (trans.getFrom().isInstance(temPreNodeInstance)) {
                        hasInstance = true;
                        break;
                    }
                    ++i;
                }
                if (hasInstance) continue;
                log.info((Object)(String.valueOf(trans.getFrom().getId()) + "->" + trans.getTo().getId() + "\u4e0d\u6210\u7acb"));
                return false;
            }
        } else if (this.coverge == CONVERGE_ALL) {
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                FlowTrans trans = (FlowTrans)entry.getValue();
                if (trans.getFrom().isInstance(preNodeInstance)) continue;
                if (nodeInstance == null) {
                    log.info((Object)(String.valueOf(trans.getFrom().getId()) + "->" + trans.getTo().getId() + "\u4e0d\u6210\u7acb\uff01"));
                    return false;
                }
                int[] preIds = nodeInstance.getPreNodeInstanceIds();
                boolean hasInstance = false;
                int i = 0;
                while (i < preIds.length) {
                    FlowNodeInstance temPreNodeInstance = flowInstance.getFlowNodeInstance(preIds[i]);
                    if (trans.getFrom().isInstance(temPreNodeInstance)) {
                        hasInstance = true;
                        break;
                    }
                    ++i;
                }
                if (hasInstance) continue;
                log.info((Object)(String.valueOf(trans.getFrom().getId()) + "->" + trans.getTo().getId() + "\u4e0d\u6210\u7acb\uff01"));
                return false;
            }
        }
        log.info((Object)(String.valueOf(preNodeInstance.getFlowNodeId()) + "->" + this.id + " \u53ef\u4ee5\u542f\u52a8"));
        return true;
    }

    public boolean checkCanStartWithPath(FlowInstance flowInstance, List<String> runingNodeIds, List<String> path) throws Exception {
        if (path.contains(String.valueOf(this.id))) {
            return false;
        }
        path.add(String.valueOf(this.id));
        if (runingNodeIds.contains(String.valueOf(this.id))) {
            return true;
        }
        Iterator it = this.preTrans.entrySet().iterator();
        boolean canStart = false;
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            FlowTrans trans = (FlowTrans)entry.getValue();
            if (!trans.getFrom().checkCanStartWithPath(flowInstance, runingNodeIds, path)) continue;
            canStart = true;
            break;
        }
        if (!canStart) {
            path.remove(String.valueOf(this.id));
        }
        return canStart;
    }

    public Object start72(FlowInstance flowInstance, int preNodeInstanceId, Object[] selectedReceiveIds) throws Exception {
        int[] preNodeInstanceIds;
        Iterator it = this.preTrans.entrySet().iterator();
        FlowNodeInstance nodeInstance = flowInstance.getUnStartInstance(this);
        FlowNodeInstance preNodeInstance = flowInstance.getFlowNodeInstance(preNodeInstanceId);
        boolean hasComplet = true;
        if (this.coverge == CONVERGE_ALL) {
            if (nodeInstance == null) {
                nodeInstance = FlowNodeInstance.create(flowInstance, this);
            }
            nodeInstance.addPreNodeInstanceId(preNodeInstanceId);
            preNodeInstance.addNextNodeInstanceId(nodeInstance.getNodeInstanceId());
            preNodeInstanceIds = nodeInstance.getPreNodeInstanceIds();
            int len = preNodeInstanceIds.length;
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                FlowTrans trans = (FlowTrans)entry.getValue();
                hasComplet = false;
                int i = 0;
                while (i < len) {
                    preNodeInstance = flowInstance.getFlowNodeInstance(preNodeInstanceIds[i]);
                    if (trans.getFrom().isInstance(preNodeInstance)) {
                        hasComplet = true;
                        break;
                    }
                    ++i;
                }
                if (hasComplet) {
                    continue;
                }
                break;
            }
        } else if (this.coverge == CONVERGE_MULTI) {
            if (nodeInstance == null) {
                nodeInstance = FlowNodeInstance.create(flowInstance, this);
            }
            nodeInstance.addPreNodeInstanceId(preNodeInstanceId);
            preNodeInstance.addNextNodeInstanceId(nodeInstance.getNodeInstanceId());
            preNodeInstanceIds = nodeInstance.getPreNodeInstanceIds();
            int len = preNodeInstanceIds.length;
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                FlowTrans trans = (FlowTrans)entry.getValue();
                if (!trans.isEnabled(flowInstance)) continue;
                hasComplet = false;
                int i = 0;
                while (i < len) {
                    preNodeInstance = flowInstance.getFlowNodeInstance(preNodeInstanceIds[i]);
                    if (trans.getFrom().isInstance(preNodeInstance)) {
                        hasComplet = true;
                        break;
                    }
                    ++i;
                }
                if (hasComplet) {
                    continue;
                }
                break;
            }
        } else if (this.coverge == CONVERGE_SINGLE) {
            nodeInstance = FlowNodeInstance.create(flowInstance, this);
            nodeInstance.addPreNodeInstanceId(preNodeInstanceId);
            preNodeInstance.addNextNodeInstanceId(nodeInstance.getNodeInstanceId());
            hasComplet = true;
        }
        int nodeInstanceId = nodeInstance.getNodeInstanceId();
        this.addReceiver72(flowInstance, nodeInstanceId, selectedReceiveIds);
        if (hasComplet) {
            nodeInstance.startUp72(2);
            this.startTask72(flowInstance, nodeInstanceId);
        }
        return hasComplet ? Boolean.TRUE : Boolean.FALSE;
    }

    public Object start72ForUFlow(FlowInstance flowInstance, int preNodeInstanceId, Object[] selectedReceiveIds) throws Exception {
        FlowNodeInstance preNodeInstance = flowInstance.getFlowNodeInstance(preNodeInstanceId);
        FlowNodeInstance nodeInstance = flowInstance.getUnStartInstance(this);
        if (nodeInstance == null) {
            nodeInstance = FlowNodeInstance.create(flowInstance, this);
        }
        int nodeInstanceId = nodeInstance.getNodeInstanceId();
        nodeInstance.addPreNodeInstanceId(preNodeInstanceId);
        preNodeInstance.addNextNodeInstanceId(nodeInstanceId);
        this.addReceiver72(flowInstance, nodeInstanceId, selectedReceiveIds);
        nodeInstance.startUp72(2);
        this.startTask72(flowInstance, nodeInstanceId);
        return Boolean.TRUE;
    }

    public void addReceiver72(FlowInstance flowInstance, int nodeInstanceId, Object[] selectedReceiveIds) throws Exception {
        String flowInstanceId = flowInstance.getId();
        FlowNodeInstance nodeInstance = flowInstance.getFlowNodeInstance(nodeInstanceId);
        int type = 0;
        for (FlowActor actor : this.flowActors) {
            CounterSign counterSign;
            BaseObject user;
            if (actor instanceof FlowActorList && selectedReceiveIds != null) {
                FlowActorList actorList = (FlowActorList)actor;
                int receiverIdsLen = selectedReceiveIds.length;
                if (receiverIdsLen <= 0) {
                    throw new Exception("\u60a8\u5fc5\u987b\u9009\u62e9\u6d41\u7a0b\u5b9e\u4f8b\u7684\u63a5\u6536\u4eba\u5458\uff01");
                }
                if (actorList.isSingleOperator() && receiverIdsLen > 1) {
                    throw new Exception("\u63a5\u6536\u4eba\u53ea\u80fd\u67091\u4e2a\uff01");
                }
                int index = 0;
                while (index < receiverIdsLen) {
                    type = 0;
                    if (selectedReceiveIds[index] instanceof String) {
                        user = User.getUser((String)selectedReceiveIds[index]);
                    } else if (selectedReceiveIds[index] instanceof BaseObject) {
                        user = (BaseObject)selectedReceiveIds[index];
                        if (selectedReceiveIds[index] instanceof User) {
                            type = 0;
                        } else if (selectedReceiveIds[index] instanceof Organize) {
                            type = 2;
                        } else if (selectedReceiveIds[index] instanceof Role) {
                            type = 1;
                        }
                    } else {
                        user = User.getUser((String)selectedReceiveIds[index]);
                    }
                    nodeInstance.addReceiver72(user, type);
                    if (this.multi) {
                        counterSign = CounterSign.create(flowInstanceId, nodeInstanceId, flowInstance.getFlowId(), flowInstance.getFlowName(), nodeInstance.getFlowNodeId(), nodeInstance.getFlowNodeName(), user.getId(), type);
                        nodeInstance.addCounterSigns(counterSign);
                    }
                    ++index;
                }
                continue;
            }
            Map agentActors = actor.getActors(flowInstance, nodeInstanceId, this.id);
            if (!this.isNoReciverDeal() && agentActors.size() <= 0) {
                throw new Exception("\u6d41\u7a0b\u5b9e\u4f8b\u6ca1\u6709\u63a5\u6536\u4eba\u5458\uff01");
            }
            for (Map.Entry entry : agentActors.entrySet()) {
                user = (BaseObject)entry.getValue();
                String userId = user.getId();
                type = user instanceof User ? 0 : (user instanceof Organize ? 2 : (user instanceof Role ? 1 : 0));
                nodeInstance.addReceiver72(user, type);
                if (!this.multi) continue;
                counterSign = CounterSign.create(flowInstanceId, nodeInstanceId, flowInstance.getFlowId(), flowInstance.getFlowName(), nodeInstance.getFlowNodeId(), nodeInstance.getFlowNodeName(), userId, type);
                nodeInstance.addCounterSigns(counterSign);
            }
        }
    }

    public void startTask72(FlowInstance flowInstance, int nodeInstanceId) throws Exception {
        if (this.pending) {
            FlowNodeInstance nodeInstance = flowInstance.getFlowNodeInstance(nodeInstanceId);
            nodeInstance.startTask72();
        }
    }

    public Object untreadToNext72(FlowInstance flowInstance, FlowNodeInstance nodeInstance, Map toNodes, String reson) throws Exception {
        Object result = null;
        HashMap<String, FlowNodeInstance> nextNodeInstancesHasUntread = new HashMap<String, FlowNodeInstance>();
        HashMap<String, FlowNodeInstance> nextNodeInstances = new HashMap<String, FlowNodeInstance>();
        for (Map.Entry entry : toNodes.entrySet()) {
            String nodeId_nodeInstanceId = (String)entry.getKey();
            Object obj = entry.getValue();
            if (obj instanceof FlowNodeInstance) {
                flowInstance.getNextNodeInstances((FlowNodeInstance)obj, nextNodeInstancesHasUntread, nextNodeInstances);
                continue;
            }
            String[] idArr = nodeId_nodeInstanceId.split(",");
            if (idArr.length == 2) {
                FlowNodeInstance nodeIns = flowInstance.getFlowNodeInstance(Integer.valueOf(idArr[1]));
                flowInstance.getNextNodeInstances(nodeIns, nextNodeInstancesHasUntread, nextNodeInstances);
                continue;
            }
            throw new Exception("\u9000\u56de\u5f02\u5e38\uff0c\u65e0\u6cd5\u83b7\u53d6\u8981\u9000\u56de\u7684\u6d41\u7a0b\u8282\u70b9\u5b9e\u4f8b\uff01");
        }
        for (Map.Entry entry : toNodes.entrySet()) {
            String nodeId_nodeInstanceId = (String)entry.getKey();
            Object obj = entry.getValue();
            if (obj instanceof FlowNodeInstance) {
                if (!nextNodeInstances.containsKey(((FlowNodeInstance)obj).getId())) continue;
                throw new Exception("\u9000\u56de\u5f02\u5e38\uff0c\u8981\u9000\u56de\u7684\u8282\u70b9\u4e2d\u4e00\u4e2a\u662f\u53e6\u4e00\u4e2a\u7684\u524d\u9a71\u8282\u70b9\uff01");
            }
            String[] idArr = nodeId_nodeInstanceId.split(",");
            if (idArr.length == 2) {
                if (!nextNodeInstances.containsKey(idArr[1])) continue;
                throw new Exception("\u9000\u56de\u5f02\u5e38\uff0c\u8981\u9000\u56de\u7684\u8282\u70b9\u4e2d\u4e00\u4e2a\u662f\u53e6\u4e00\u4e2a\u7684\u524d\u9a71\u8282\u70b9\uff01");
            }
            throw new Exception("\u9000\u56de\u5f02\u5e38\uff0c\u65e0\u6cd5\u83b7\u53d6\u8981\u9000\u56de\u7684\u6d41\u7a0b\u8282\u70b9\u5b9e\u4f8b\uff01");
        }
        for (Map.Entry entry : nextNodeInstances.entrySet()) {
            FlowNodeInstance nodeIns = (FlowNodeInstance)entry.getValue();
            if (nodeIns.getRunStatus() == 0) {
                FlowOperatorManager operatorManager = nodeIns.getOperatorManager();
                FlowOperator operator = operatorManager.getCurrentOperator();
                Date operEnd = new Date();
                if (operator != null) {
                    operator.setEndTime(operEnd);
                }
                if (nodeInstance.getId() == nodeIns.getId()) {
                    nodeIns.complet72(7);
                } else {
                    nodeIns.terminate72(10);
                }
                nodeIns.addNotes("\u9000\u56de\uff1a");
                nodeIns.addNotes(reson);
                nodeIns.addNotes("  ");
            }
            if (nodeIns.getRunStatus() == 5) {
                nodeIns.terminate72(10);
            }
            this.dealForUntread(flowInstance, nodeIns, nextNodeInstancesHasUntread);
        }
        if (toNodes != null && !toNodes.isEmpty()) {
            Flow flow = flowInstance.getTemplet();
            for (Map.Entry entry : toNodes.entrySet()) {
                String nodeId_nodeInstanceId = (String)entry.getKey();
                Object obj = entry.getValue();
                if (obj instanceof FlowNodeInstance) {
                    FlowNode node = flow.getNodeById(Integer.valueOf(nodeId_nodeInstanceId));
                    result = node.startForUntread72(flowInstance, nodeInstance.getNodeInstanceId(), (FlowNodeInstance)obj, reson, null);
                    continue;
                }
                String[] idArr = nodeId_nodeInstanceId.split(",");
                if (idArr.length != 2) continue;
                FlowNode node = flow.getNodeById(Integer.valueOf(idArr[0]));
                FlowNodeInstance vPreNodeInstance = flowInstance.getFlowNodeInstance(Integer.valueOf(idArr[1]));
                result = node.startForUntread72(flowInstance, nodeInstance.getNodeInstanceId(), vPreNodeInstance, reson, (Object[])obj);
            }
        }
        return result;
    }

    public List getUntreadNodes72(FlowInstance flowInstance, FlowNodeInstance nodeInstance, Map nodes) throws Exception {
        int[] preNodeInsIds;
        int[] nArray = preNodeInsIds = nodeInstance.getPreNodeInstanceIds72();
        int n = preNodeInsIds.length;
        int n2 = 0;
        while (n2 < n) {
            int preNodeInsId = nArray[n2];
            FlowNodeInstance preNodeIns = flowInstance.getFlowNodeInstance(preNodeInsId);
            if (this.canUntread(flowInstance, preNodeIns)) {
                String preNodeId = String.valueOf(preNodeIns.getFlowNodeId());
                nodes.put(preNodeId, preNodeIns);
            }
            ++n2;
        }
        if (this.untreadTrans != null && this.untreadTrans.size() > 0) {
            ArrayList untreadNode = new ArrayList();
            for (Map.Entry entry : this.untreadTrans.entrySet()) {
                FlowTrans trans = (FlowTrans)entry.getValue();
                FlowNode node = trans.getTo();
                FlowNodeInstance nodeIns = flowInstance.getLastNodeInstance(node);
                if (nodeIns == null || !flowInstance.isPreNodeIns(nodeIns.getNodeInstanceId(), nodeInstance.getNodeInstanceId()) || !this.canUntread(flowInstance, nodeIns)) continue;
                String nodeId = String.valueOf(nodeIns.getFlowNodeId());
                nodes.put(nodeId, nodeIns);
            }
        }
        if (nodes == null || nodes.isEmpty()) {
            throw new Exception("\u6ca1\u6709\u627e\u5230\u8981\u9000\u56de\u7684\u8282\u70b9\uff01");
        }
        boolean needSelectActor = false;
        boolean needSelectNode = nodes.size() > 1;
        ArrayList<TreeNodeBean> flowNodes = new ArrayList<TreeNodeBean>();
        TreeMap<String, BaseObject> orderUsers = new TreeMap<String, BaseObject>();
        Iterator it = nodes.entrySet().iterator();
        int nodeIndex = 0;
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            FlowNodeInstance preNodeInstance = (FlowNodeInstance)entry.getValue();
            FlowNode node = flowInstance.getTemplet().getNodeById(Integer.parseInt((String)entry.getKey()));
            String nodeId = String.valueOf(String.valueOf(node.getId())) + "," + preNodeInstance.getNodeInstanceId();
            Map users = node.getReceivers(flowInstance, preNodeInstance.getNodeInstanceId());
            TreeNodeBean treeNode = new TreeNodeBean();
            treeNode.setTableId("FlowNode");
            treeNode.setText(node.getName());
            treeNode.setObjectId(nodeId);
            treeNode.setId(nodeId);
            treeNode.setExpanded(true);
            treeNode.setIconSrc(icon);
            treeNode.setGetData(true);
            treeNode.setChecked(!needSelectNode);
            treeNode.setDisabled(!needSelectNode);
            if (users != null) {
                boolean userHasDel = false;
                List untreadToNodeInstances = flowInstance.getNodeInstance(node);
                for (FlowNodeInstance untreadToNodeInstance : untreadToNodeInstances) {
                    if (untreadToNodeInstance.getFlowNodeId() == node.getId()) {
                        HashMap<String, FlowOperator> operators = untreadToNodeInstance.getOperatorManager().getOperators();
                        Iterator operatorsIt = operators.keySet().iterator();
                        block4: while (!userHasDel && operatorsIt.hasNext()) {
                            userHasDel = true;
                            String oldUserId = (String)operatorsIt.next();
                            List actors = node.getFlowActors();
                            int i = 0;
                            while (i < actors.size()) {
                                if (actors.get(i) instanceof FlowActorList) {
                                    Map finalUser = ((FlowActorList)actors.get(i)).getFinalActors(flowInstance, nodeInstance.getNodeInstanceId(), node.getId());
                                    if (finalUser.containsKey(oldUserId)) {
                                        userHasDel = false;
                                        continue block4;
                                    }
                                    if (finalUser.size() == 0 && node.isNoReciverDeal()) {
                                        userHasDel = false;
                                        continue block4;
                                    }
                                } else if (users.containsKey(oldUserId)) {
                                    userHasDel = false;
                                    continue block4;
                                }
                                ++i;
                            }
                        }
                    }
                    if (userHasDel) break;
                }
                if (userHasDel) {
                    BaseObject user;
                    orderUsers.clear();
                    for (Map.Entry usersEntry : users.entrySet()) {
                        user = (BaseObject)usersEntry.getValue();
                        orderUsers.put(String.valueOf(StringTool.leftPad(String.valueOf(user.getShowOrder()), 10, '0')) + user.getId(), user);
                    }
                    needSelectActor = true;
                    TreeNodeBean[] userNodes = new TreeNodeBean[users.size()];
                    Iterator tempIt = orderUsers.keySet().iterator();
                    int i = 0;
                    while (tempIt.hasNext()) {
                        user = (BaseObject)orderUsers.get(tempIt.next());
                        String userId = user.getId();
                        TreeNodeBean userNode = new TreeNodeBean();
                        userNode.setText(user.getName());
                        userNode.setObjectId(userId);
                        userNode.attachField.put("SHOWORDER", String.valueOf(user.getShowOrder()));
                        if (user instanceof User) {
                            User userObj = (User)user;
                            userNode.setTableId("User");
                            userNode.setIconSrc(User.icon);
                            userNode.attachField.put("DEPTID", userObj.getDeptId());
                            userNode.attachField.put("DEPTNAME", userObj.getDeptName());
                            userNode.attachField.put("COMPID", userObj.getCompId());
                            userNode.attachField.put("COMPNAME", userObj.getCompName());
                            userNode.attachField.put("CODE", userObj.getCode());
                            userNode.attachField.put("ROLES", userObj.getRoles());
                        } else if (user instanceof Organize) {
                            userNode.setTableId("Organize");
                            userNode.setIconSrc(Organize.icon);
                        } else if (user instanceof Role) {
                            userNode.setTableId("Role");
                            userNode.setIconSrc(Role.icon);
                        }
                        userNode.setId(String.valueOf(nodeId) + userId);
                        userNode.setParentId(nodeId);
                        userNode.setParentObjectId(nodeId);
                        userNode.setExpanded(false);
                        userNode.setGetData(true);
                        userNodes[i++] = userNode;
                    }
                    treeNode.setChilds(userNodes);
                } else {
                    needSelectActor = false;
                }
            }
            flowNodes.add(treeNode);
            ++nodeIndex;
        }
        if (needSelectNode || needSelectActor) {
            return flowNodes;
        }
        return null;
    }

    public List getUntreadNodes72ByAuto(FlowInstance flowInstance, FlowNodeInstance nodeInstance, Map nodes) throws Exception {
        int[] preNodeInsIds;
        int[] nArray = preNodeInsIds = nodeInstance.getPreNodeInstanceIds72();
        int n = preNodeInsIds.length;
        int n2 = 0;
        while (n2 < n) {
            int preNodeInsId = nArray[n2];
            FlowNodeInstance preNodeIns = flowInstance.getFlowNodeInstance(preNodeInsId);
            if (this.canUntread(flowInstance, preNodeIns)) {
                String preNodeId = String.valueOf(preNodeIns.getFlowNodeId());
                nodes.put(preNodeId, preNodeIns);
            }
            ++n2;
        }
        if (nodes == null || nodes.isEmpty()) {
            throw new Exception("\u6ca1\u6709\u627e\u5230\u8981\u9000\u56de\u7684\u8282\u70b9\uff01");
        }
        boolean needSelectActor = false;
        boolean needSelectNode = nodes.size() > 1;
        ArrayList<TreeNodeBean> flowNodes = new ArrayList<TreeNodeBean>();
        TreeMap<String, BaseObject> orderUsers = new TreeMap<String, BaseObject>();
        Iterator it = nodes.entrySet().iterator();
        int nodeIndex = 0;
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            FlowNodeInstance preNodeInstance = (FlowNodeInstance)entry.getValue();
            FlowNode node = flowInstance.getTemplet().getNodeById(Integer.parseInt((String)entry.getKey()));
            String nodeId = String.valueOf(String.valueOf(node.getId())) + "," + preNodeInstance.getNodeInstanceId();
            Map users = node.getReceivers(flowInstance, preNodeInstance.getNodeInstanceId());
            TreeNodeBean treeNode = new TreeNodeBean();
            treeNode.setTableId("FlowNode");
            treeNode.setText(node.getName());
            treeNode.setObjectId(nodeId);
            treeNode.setId(nodeId);
            treeNode.setExpanded(true);
            treeNode.setIconSrc(icon);
            treeNode.setGetData(true);
            treeNode.setChecked(!needSelectNode);
            treeNode.setDisabled(!needSelectNode);
            if (users != null) {
                boolean userHasDel = false;
                List untreadToNodeInstances = flowInstance.getNodeInstance(node);
                for (FlowNodeInstance untreadToNodeInstance : untreadToNodeInstances) {
                    if (untreadToNodeInstance.getFlowNodeId() == node.getId()) {
                        HashMap<String, FlowOperator> operators = untreadToNodeInstance.getOperatorManager().getOperators();
                        Iterator operatorsIt = operators.keySet().iterator();
                        block3: while (!userHasDel && operatorsIt.hasNext()) {
                            userHasDel = true;
                            String oldUserId = (String)operatorsIt.next();
                            List actors = node.getFlowActors();
                            int i = 0;
                            while (i < actors.size()) {
                                if (actors.get(i) instanceof FlowActorList) {
                                    Map finalUser = ((FlowActorList)actors.get(i)).getFinalActors(flowInstance, nodeInstance.getNodeInstanceId(), node.getId());
                                    if (finalUser.containsKey(oldUserId)) {
                                        userHasDel = false;
                                        continue block3;
                                    }
                                    if (finalUser.size() == 0 && node.isNoReciverDeal()) {
                                        userHasDel = false;
                                        continue block3;
                                    }
                                } else if (users.containsKey(oldUserId)) {
                                    userHasDel = false;
                                    continue block3;
                                }
                                ++i;
                            }
                        }
                    }
                    if (userHasDel) break;
                }
                if (userHasDel) {
                    BaseObject user;
                    orderUsers.clear();
                    for (Map.Entry usersEntry : users.entrySet()) {
                        user = (BaseObject)usersEntry.getValue();
                        orderUsers.put(String.valueOf(StringTool.leftPad(String.valueOf(user.getShowOrder()), 10, '0')) + user.getId(), user);
                    }
                    needSelectActor = true;
                    TreeNodeBean[] userNodes = new TreeNodeBean[users.size()];
                    Iterator tempIt = orderUsers.keySet().iterator();
                    int i = 0;
                    while (tempIt.hasNext()) {
                        user = (BaseObject)orderUsers.get(tempIt.next());
                        String userId = user.getId();
                        TreeNodeBean userNode = new TreeNodeBean();
                        userNode.setText(user.getName());
                        userNode.setObjectId(userId);
                        userNode.attachField.put("SHOWORDER", String.valueOf(user.getShowOrder()));
                        if (user instanceof User) {
                            User userObj = (User)user;
                            userNode.setTableId("User");
                            userNode.setIconSrc(User.icon);
                            userNode.attachField.put("DEPTID", userObj.getDeptId());
                            userNode.attachField.put("DEPTNAME", userObj.getDeptName());
                            userNode.attachField.put("COMPID", userObj.getCompId());
                            userNode.attachField.put("COMPNAME", userObj.getCompName());
                            userNode.attachField.put("CODE", userObj.getCode());
                            userNode.attachField.put("ROLES", userObj.getRoles());
                        } else if (user instanceof Organize) {
                            userNode.setTableId("Organize");
                            userNode.setIconSrc(Organize.icon);
                        } else if (user instanceof Role) {
                            userNode.setTableId("Role");
                            userNode.setIconSrc(Role.icon);
                        }
                        userNode.setId(String.valueOf(nodeId) + userId);
                        userNode.setParentId(nodeId);
                        userNode.setParentObjectId(nodeId);
                        userNode.setExpanded(false);
                        userNode.setGetData(true);
                        userNodes[i++] = userNode;
                    }
                    treeNode.setChilds(userNodes);
                } else {
                    needSelectActor = false;
                }
            }
            flowNodes.add(treeNode);
            ++nodeIndex;
        }
        if (needSelectNode) {
            log.info((Object)"\u6d41\u7a0b\u5728\u6267\u884c\u81ea\u52a8\u9000\u56de\u65f6\uff0c\u9700\u8981\u9009\u62e9\u8282\u70b9\u5bfc\u81f4\u81ea\u52a8\u9000\u56de\u5931\u8d25\u3002");
        }
        if (needSelectActor) {
            log.info((Object)"\u6d41\u7a0b\u5728\u6267\u884c\u81ea\u52a8\u9000\u56de\u65f6\uff0c\u9700\u8981\u9009\u62e9\u4eba\u5458\u5bfc\u81f4\u81ea\u52a8\u9000\u56de\u5931\u8d25\u3002");
        }
        if (needSelectNode || needSelectActor) {
            return flowNodes;
        }
        return null;
    }

    private boolean canUntread(FlowInstance flowInstance, FlowNodeInstance nodeInstance) {
        if (nodeInstance.getRunStatus() == 0) {
            return true;
        }
        boolean canUntread = nodeInstance.canUntread();
        if (!canUntread) {
            return false;
        }
        List<Integer> nextNodeInstances = nodeInstance.getNextNodeInstanceIds();
        for (int i : nextNodeInstances) {
            FlowNodeInstance nextNodeInstance = flowInstance.getFlowNodeInstance(i);
            boolean bl = canUntread = canUntread && this.canUntread(flowInstance, nextNodeInstance);
            if (!canUntread) break;
        }
        return canUntread;
    }

    protected void dealForUntread(FlowInstance flowInstance, FlowNodeInstance flowNodeInstance, Map<String, FlowNodeInstance> nextNodeInstances) throws Exception {
        ArrayList<Integer> needCreate = new ArrayList<Integer>();
        int[] preIds = flowNodeInstance.getPreNodeInstanceIds72();
        Flow flow = flowInstance.getTemplet();
        FlowNode node = flow.getNodeById(flowNodeInstance.getFlowNodeId());
        int[] nArray = preIds;
        int n = preIds.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            if (!nextNodeInstances.containsKey(String.valueOf(i))) {
                needCreate.add(i);
            }
            ++n2;
        }
        if (needCreate.size() > 0) {
            FlowNodeInstance vNextNodeInstance = FlowNodeInstance.create(flowInstance, node);
            vNextNodeInstance.setRunStatusNoteStart(3);
            Iterator iterator = needCreate.iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                vNextNodeInstance.addPreNodeInstanceId(i);
            }
            flowNodeInstance.setvNextNodeInstanceId(vNextNodeInstance.getNodeInstanceId());
        }
        flowNodeInstance.addCallBackMessage();
    }

    public Object startForUntread72(FlowInstance flowInstance, int preNodeInstanceId, FlowNodeInstance vPreNodeInstance, String reson, Object[] selectedReceiveIds) throws Exception {
        FlowNodeInstance preFlowNodeInstance = flowInstance.getFlowNodeInstance(preNodeInstanceId);
        FlowNodeInstance nodeInstance = flowInstance.getUnStartInstance(this);
        if (nodeInstance == null) {
            nodeInstance = FlowNodeInstance.create(flowInstance, this);
        }
        String flowInstanceId = flowInstance.getId();
        int nodeInstanceId = nodeInstance.getNodeInstanceId();
        nodeInstance.addPreNodeInstanceId(preNodeInstanceId);
        nodeInstance.setRunStatusNoteStart(3);
        nodeInstance.setvPreNodeInstanceId(vPreNodeInstance.getNodeInstanceId());
        vPreNodeInstance.setvNextNodeInstanceId(nodeInstance.getNodeInstanceId());
        nodeInstance.setUntreadReason(reson);
        vPreNodeInstance.untread();
        vPreNodeInstance.addNotes("\u88ab");
        if (User.getCurrentUser() != null) {
            vPreNodeInstance.addNotes(User.getCurrentUser().getName());
        }
        vPreNodeInstance.addNotes("\u9000\u56de\uff1a");
        vPreNodeInstance.addNotes(reson);
        vPreNodeInstance.addNotes("  ");
        nodeInstance.copyOperator(vPreNodeInstance, true, reson, selectedReceiveIds);
        if (this.multi) {
            List counterSigns = CounterSign.copy(flowInstanceId, vPreNodeInstance.getNodeInstanceId(), nodeInstanceId);
            int i = 0;
            while (i < counterSigns.size()) {
                nodeInstance.addCounterSigns((CounterSign)counterSigns.get(i));
                ++i;
            }
        }
        nodeInstance.startUpUntread();
        return Boolean.TRUE;
    }

    public boolean startForCallBack72(FlowInstance flowInstance, FlowNodeInstance vPerNodeIns) throws Exception {
        FlowNodeInstance nodeInstance = flowInstance.getUnStartInstance(this);
        if (nodeInstance == null) {
            nodeInstance = FlowNodeInstance.create(flowInstance, this);
        }
        nodeInstance.setCallBack(true);
        nodeInstance.setvPreNodeInstanceId(vPerNodeIns.getNodeInstanceId());
        vPerNodeIns.setvNextNodeInstanceId(nodeInstance.getNodeInstanceId());
        vPerNodeIns.addNotes("\u88ab");
        if (User.getCurrentUser() != null) {
            vPerNodeIns.addNotes(User.getCurrentUser().getName());
        }
        vPerNodeIns.addNotes("\u64a4\u56de\uff01    ");
        nodeInstance.copyReceiver(vPerNodeIns);
        if (this.multi) {
            List counterSigns = CounterSign.copy(flowInstance.getId(), vPerNodeIns.getNodeInstanceId(), nodeInstance.getNodeInstanceId());
            int i = 0;
            while (i < counterSigns.size()) {
                nodeInstance.addCounterSigns((CounterSign)counterSigns.get(i));
                ++i;
            }
        }
        nodeInstance.startCallback(4);
        return true;
    }

    public boolean isMulti() {
        return this.multi;
    }

    public boolean startForEnd2Run(FlowInstance flowInstance, FlowNodeInstance vPerNodeIns) throws Exception {
        User curruser = User.getCurrentUser();
        if (curruser == null) {
            throw new Exception("\u65e0\u6cd5\u83b7\u53d6\u5f53\u524d\u7528\u6237\u4fe1\u606f\uff01");
        }
        if (!vPerNodeIns.getOperatorManager().getOperators().containsKey(curruser.getId())) {
            throw new Exception("\u5f53\u524d\u7528\u6237\u4e0d\u662f\u8be5\u8282\u70b9\u7684\u5904\u7406\u4eba\uff0c\u6ca1\u6709\u8be5\u8282\u70b9\u7684\u590d\u6d3b\u6743\u9650\uff01");
        }
        if (!this.getReceivers(flowInstance, vPerNodeIns.getNodeInstanceId()).containsKey(curruser.getId())) {
            throw new Exception("\u5f53\u524d\u7528\u6237\u5df2\u6ca1\u6709\u8be5\u8282\u70b9\u7684\u5904\u7406\u6743\u9650\uff0c\u65e0\u6cd5\u6267\u884c\u590d\u6d3b\u64cd\u4f5c\uff01");
        }
        FlowNodeInstance nodeIns = flowInstance.getUnStartInstance(this);
        if (nodeIns == null) {
            nodeIns = FlowNodeInstance.create(flowInstance, this);
        }
        nodeIns.setvPreNodeInstanceId(vPerNodeIns.getNodeInstanceId());
        vPerNodeIns.setvNextNodeInstanceId(nodeIns.getNodeInstanceId());
        vPerNodeIns.addNotes("\u88ab");
        vPerNodeIns.addNotes(curruser.getName());
        vPerNodeIns.addNotes("\u590d\u6d3b\uff01    ");
        nodeIns.copyInfo(vPerNodeIns);
        nodeIns.startUp72(4);
        return true;
    }

    public Map getNextTrans() {
        return this.nextTrans;
    }

    public int getNodeType() {
        return this.type;
    }

    public static void setIcon(String appRoot) {
        icon = String.valueOf(appRoot) + "/pms/platform/image/folder2.gif";
    }
}

