/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.workflow.service;

import com.sdjxd.pms.platform.base.BaseClass;
import com.sdjxd.pms.platform.base.DataModify;
import com.sdjxd.pms.platform.cache.Cache;
import com.sdjxd.pms.platform.platWebServices.service.InvokeAplicate;
import com.sdjxd.pms.platform.tool.DateTool;
import com.sdjxd.pms.platform.tool.Guid;
import com.sdjxd.pms.platform.workflow.dao.FlowDao;
import com.sdjxd.pms.platform.workflow.dao.FlowInstanceDao;
import com.sdjxd.pms.platform.workflow.model.FlowInterFaceBean;
import com.sdjxd.pms.platform.workflow.model.FlowInterFaceInstanceBean;
import com.sdjxd.pms.platform.workflow.service.FlowInstance;
import com.sdjxd.pms.platform.workflow.service.FlowTimer;
import org.apache.log4j.Logger;

public class FlowInterFace
extends BaseClass {
    private static final long serialVersionUID = 1L;
    protected static FlowInstanceDao dao;
    protected static FlowDao flowDao;
    protected FlowInterFaceBean m_Model;
    public static Cache cache;
    private static Logger log;
    private static String METHODNAME;

    static {
        METHODNAME = "com.sdjxd.pms.platform.workflow.service.FlowInterFace.interFaceTimer";
        log = Logger.getLogger(FlowInstance.class);
        dao = FlowInstanceDao.createInstance();
        flowDao = FlowDao.createInstance();
        cache = Cache.getCache("com.sdjxd.pms.platform.workflow.service.FlowInterFace", 100);
    }

    public static FlowInterFace getInstance(FlowInterFaceBean model) {
        FlowInterFace flowInterFace = new FlowInterFace();
        flowInterFace.load(model);
        return flowInterFace;
    }

    public void load(FlowInterFaceBean model) {
        this.m_Model = model;
    }

    public void invoke(FlowInstance flowInstance, int nodeInstanceId) throws Exception {
        String[][] param = this.m_Model.getInterfaceParam();
        String[][] flowParam = this.m_Model.getFlowInterfaceParam();
        if (param == null) {
            param = new String[0][0];
        }
        if (flowParam == null) {
            flowParam = new String[0][0];
        }
        if (param.length == flowParam.length) {
            String[] paramName = new String[param.length];
            String[] paramType = new String[param.length];
            Object[] paramValue = new Object[param.length];
            int i = 0;
            while (i < param.length) {
                paramName[i] = param[i][0];
                paramType[i] = param[i][1];
                paramValue[i] = FlowInterFaceBean.PARAM_CONST == Integer.parseInt(flowParam[i][1]) ? flowParam[i][2] : String.valueOf(flowInstance.getParameterValue(Integer.parseInt(flowParam[i][2])));
                ++i;
            }
            FlowInterFaceInstanceBean instance = FlowInterFace.createInvoke(flowInstance.getId(), nodeInstanceId, this.m_Model.getInterfaceId());
            instance.setParamName(paramName);
            instance.setParamType(paramType);
            instance.setParamValue(paramValue);
            Object[] methodParam = new Object[]{this.m_Model, instance};
            if (!FlowTimer.addFlowTimerMethod(METHODNAME, methodParam, 1, 1, 1)) {
                throw new Exception("\u8c03\u7528\u5916\u90e8\u63a5\u53e3\u5931\u8d25\uff01");
            }
        }
    }

    public static void invokeReturn(FlowInterFaceInstanceBean instance, boolean isSuccess, Object returnValue) {
        instance.setReturnValue(returnValue);
        instance.setCompletTime(DateTool.getNow());
        if (isSuccess) {
            instance.setCallStatus(3);
        } else {
            instance.setCallStatus(4);
        }
        if (!DataModify.NEW.is(instance.getDataModify())) {
            instance.setDataModify(DataModify.MODIFY);
        }
    }

    public static void saveInvoke(FlowInterFaceInstanceBean instance) throws Exception {
        dao.saveInterFaceInstance(instance, instance.getDataModify());
        instance.setDataModify(DataModify.SAVED);
    }

    public boolean isWait() {
        return this.m_Model.isWait();
    }

    public static final String getCallStatusName(int callStatus) {
        String name = null;
        switch (callStatus) {
            case 0: {
                name = "\u7b49\u5f85\u8c03\u7528";
                break;
            }
            case 1: {
                name = "\u6b63\u5728\u8c03\u7528";
                break;
            }
            case 2: {
                name = "\u7b49\u5f85\u8fd4\u56de";
                break;
            }
            case 3: {
                name = "\u8c03\u7528\u6210\u529f";
                break;
            }
            case 4: {
                name = "\u8c03\u7528\u5931\u8d25";
            }
        }
        return name;
    }

    public static FlowInterFaceInstanceBean createInvoke(String flowInstanceId, int nodeInstanceId, String interfaceId) throws Exception {
        FlowInterFaceInstanceBean instance = new FlowInterFaceInstanceBean();
        instance.setInstanceId(Guid.create());
        instance.setFlowInstanceId(flowInstanceId);
        instance.setCallNum(1);
        instance.setCallStatus(0);
        instance.setCallTime(DateTool.getNow());
        instance.setNodeInstanceId(nodeInstanceId);
        instance.setDataModify(DataModify.NEW);
        instance.setInterfaceId(interfaceId);
        return instance;
    }

    public static Object invoke(int interfaceType, String interfacePath, String interfaceMethod, String[] paramName, String[] paramType, Object[] paramValue, int timeout) throws Exception {
        Object returnValue = null;
        switch (interfaceType) {
            case 1: {
                returnValue = InvokeAplicate.invokeNetWebServices(interfacePath, interfaceMethod, paramName, paramType, paramValue, timeout);
                break;
            }
            case 2: {
                String[] strParamValue = new String[paramValue.length];
                int i = 0;
                while (i < strParamValue.length) {
                    strParamValue[i] = (String)paramValue[i];
                    ++i;
                }
                returnValue = InvokeAplicate.invokeExeAplicate(interfacePath, strParamValue);
                break;
            }
            case 3: {
                String[] strParamValue = new String[paramValue.length];
                int i = 0;
                while (i < strParamValue.length) {
                    strParamValue[i] = (String)paramValue[i];
                    ++i;
                }
                returnValue = InvokeAplicate.invokeBatAplicate(interfacePath, strParamValue);
                break;
            }
        }
        return returnValue;
    }

    public static void interFaceTimer(FlowInterFaceBean interfacePattern, FlowInterFaceInstanceBean interfaceInstance) throws Exception {
        Object returnValue = null;
        int callStatus = interfaceInstance.getCallStatus();
        try {
            if (callStatus == 0) {
                interfaceInstance.setCallStatus(1);
                returnValue = FlowInterFace.invoke(interfacePattern.getInterfaceType(), interfacePattern.getInterfacePath(), interfacePattern.getInterfaceMethod(), interfaceInstance.getParamName(), interfaceInstance.getParamType(), interfaceInstance.getParamValue(), interfacePattern.getTimeout());
            }
        }
        catch (Exception exp) {
            FlowInterFace.invokeReturn(interfaceInstance, false, null);
            FlowInterFace.saveInvoke(interfaceInstance);
            int callNum = interfaceInstance.getCallNum();
            if (callNum >= interfacePattern.getFailureCallTimes() || interfacePattern.getFailureType() == 0) {
                if (interfacePattern.isWait()) {
                    String flowInstanceId = interfaceInstance.getFlowInstanceId();
                    FlowInstance.submit(flowInstanceId, interfaceInstance.getNodeInstanceId(), null, false);
                }
            } else if (interfacePattern.getFailureType() == 1) {
                String flowInstanceId = interfaceInstance.getFlowInstanceId();
                FlowInterFaceInstanceBean newInstance = FlowInterFace.createInvoke(flowInstanceId, interfaceInstance.getNodeInstanceId(), interfacePattern.getInterfaceId());
                newInstance.setCallNum(++callNum);
                newInstance.setParamName(interfaceInstance.getParamName());
                newInstance.setParamType(interfaceInstance.getParamType());
                newInstance.setParamValue(interfaceInstance.getParamValue());
                Object[] param = new Object[]{interfacePattern, newInstance};
                int cycle = interfacePattern.getFailureCallSpace();
                FlowTimer.addFlowTimerMethod(METHODNAME, param, cycle, cycle, 1);
            }
            return;
        }
        String flowInstanceId = interfaceInstance.getFlowInstanceId();
        if (1 == interfacePattern.getReturnType()) {
            FlowInterFace.invokeReturn(interfaceInstance, true, returnValue);
            FlowInterFace.saveInvoke(interfaceInstance);
            if (interfacePattern.isWait()) {
                FlowInstance.submit(flowInstanceId, interfaceInstance.getNodeInstanceId(), null, false);
            }
        } else {
            interfaceInstance.setCallStatus(2);
            FlowInterFace.saveInvoke(interfaceInstance);
            interfaceInstance.setCallStatus(0);
            if (2 == interfacePattern.getReturnType()) {
                String callbackId = interfacePattern.getCallbackId();
                FlowInterFaceBean interFaceCallBack = flowDao.getInterFace(callbackId);
                interFaceCallBack.setCallbackId(null);
                interFaceCallBack.setReturnType(1);
                interFaceCallBack.setWait(interfacePattern.isWait());
                interFaceCallBack.setFailureType(0);
                interFaceCallBack.setTimeout(interfacePattern.getTimeout());
                interfaceInstance.setParamValue(new Object[]{returnValue});
                Object[] param = new Object[]{interFaceCallBack, interfaceInstance};
                FlowTimer.addFlowTimerMethod(METHODNAME, param, 1, 1, 1);
            } else if (3 == interfacePattern.getReturnType()) {
                cache.put(returnValue, new Object[]{interfacePattern, interfaceInstance});
            }
        }
    }
}

