/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.workflow.service;

import com.sdjxd.pms.platform.base.BaseClass;
import com.sdjxd.pms.platform.base.Global;
import com.sdjxd.pms.platform.organize.User;
import com.sdjxd.pms.platform.tool.Guid;
import com.sdjxd.pms.platform.workflow.service.Flow;
import com.sdjxd.pms.platform.workflow.service.FlowFormInstance;
import com.sdjxd.pms.platform.workflow.service.FlowInstance;
import com.sdjxd.pms.platform.workflow.service.FlowNode;
import com.sdjxd.pms.platform.workflow.service.FlowNodeInstance;

public class FlowInstanceSession
extends BaseClass {
    private static final long serialVersionUID = 1L;
    private String flowId;
    private FlowInstance flowInstance;
    private int nodeInstanceId;
    private int formId;
    private String formInstanceId;
    private String pageUrl = null;
    private String sessionKey;
    private boolean isCreateForm;

    public FlowInstanceSession() {
    }

    public static FlowInstanceSession getSession(String key) {
        if (Global.getContext() != null) {
            return (FlowInstanceSession)Global.getContext().getSession(key);
        }
        return null;
    }

    public String getPageUrl() throws Exception {
        return this.getPageUrl(false);
    }

    public String getPageUrl(boolean withSession) throws Exception {
        if (this.pageUrl == null) {
            this.pageUrl = this.flowInstance.getFormUrl(this.nodeInstanceId, this.formId, this.formInstanceId, this.isCreateForm);
        }
        if (withSession) {
            return this.pageUrl.replaceAll("\\[flow.session.key\\]", this.sessionKey);
        }
        return this.pageUrl.replaceAll("\\[flow.session.key\\]", "");
    }

    public static String getFormUrl(FlowInstance flowInstance, int nodeInstanceId, int formId, String formInstanceId, boolean isCreateForm) throws Exception {
        String pageUrl = flowInstance.getFormUrl(nodeInstanceId, formId, formInstanceId, isCreateForm);
        pageUrl = pageUrl.replaceAll("\\[flow.session.key\\]", "");
        return pageUrl;
    }

    public FlowInstanceSession(FlowInstance flowInstance, int nodeInstanceId, int flowNodeId, int flowFormId, String formInstanceId, boolean isCreateForm) throws Exception {
        this();
        this.create(flowInstance, nodeInstanceId, flowNodeId, flowFormId, formInstanceId, isCreateForm);
    }

    public FlowInstanceSession(String flowId, String flowInstanceId, int nodeInstanceId, int flowNodeId, int flowFormId, String formInstanceId, boolean isCreateAttach, boolean isCreateForm) throws Exception {
        this();
        FlowInstance flowInstance = null;
        User user = User.getCurrentUser();
        if (user == null) {
            throw new Exception("\u60a8\u8fd8\u6ca1\u6709\u767b\u9646\u6216\u8005\u767b\u9646\u8d85\u65f6,\u8bf7\u91cd\u65b0\u767b\u9646!");
        }
        if (flowInstanceId != null && flowInstanceId.length() != 0) {
            flowInstance = isCreateAttach ? FlowInstance.loadFromCache(flowInstanceId) : FlowInstance.loadFromDb(flowInstanceId);
            if (flowInstance == null) {
                throw new Exception("\u6d41\u7a0b\u5b9e\u4f8b\u53ef\u80fd\u5df2\u88ab\u5220\u9664\uff01");
            }
        } else if (flowId != null && flowId.length() != 0) {
            flowInstance = Flow.createInstance(flowId);
        } else {
            throw new Exception("\u53c2\u6570\u4f20\u9012\u9519\u8bef\uff01\u627e\u4e0d\u5230\u6307\u5b9a\u7684\u6d41\u7a0b\u5b9e\u4f8b\uff01");
        }
        this.create(flowInstance, nodeInstanceId, flowNodeId, flowFormId, formInstanceId, isCreateForm);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void create(FlowInstance flowInstance, int nodeInstanceId, int flowNodeId, int flowFormId, String formInstanceId, boolean isCreateForm) throws Exception {
        int currentFormId;
        int currentNodeInstanceId;
        this.sessionKey = Guid.create();
        if (Global.getContext() != null) {
            Global.getContext().setSession(this.sessionKey, this);
        }
        String currentFormInstanceId = "";
        int currentFlowNodeId = flowNodeId;
        boolean currentCreateForm = isCreateForm;
        FlowNodeInstance nodeInstance = null;
        User user = User.getCurrentUser();
        if (nodeInstanceId >= 0) {
            currentNodeInstanceId = nodeInstanceId;
            nodeInstance = flowInstance.getFlowNodeInstance(currentNodeInstanceId);
            if (nodeInstance == null) throw new Exception("\u9519\u8bef\u7684\u6d41\u7a0b\u8282\u70b9\u5b9e\u4f8b\u7f16\u7801\uff01");
            currentFlowNodeId = nodeInstance.getFlowNodeId();
        } else if (flowNodeId >= 0) {
            nodeInstance = flowInstance.getLastNodeInstance(flowNodeId);
            if (nodeInstance == null) throw new Exception("\u9519\u8bef\u7684\u6d41\u7a0b\u8282\u70b9\u7f16\u7801\uff01");
            currentNodeInstanceId = nodeInstance.getNodeInstanceId();
            currentFlowNodeId = nodeInstance.getFlowNodeId();
        } else {
            nodeInstance = flowInstance.getLastNodeInstance();
            if (nodeInstance == null) throw new Exception("\u8be5\u6d41\u7a0b\u4e0d\u5b58\u5728\u4efb\u4f55\u8282\u70b9\u5b9e\u4f8b\uff01");
            currentNodeInstanceId = nodeInstance.getNodeInstanceId();
            currentFlowNodeId = nodeInstance.getFlowNodeId();
        }
        if (nodeInstance == null) {
            throw new Exception("\u5f53\u524d\u6d41\u7a0b\u5b9e\u4f8b\u4e0d\u53ef\u7f16\u8f91\uff01");
        }
        if (currentCreateForm) {
            currentFormId = flowFormId >= 0 ? flowFormId : nodeInstance.getDefaultForm();
            if (currentFormId < 0) {
                throw new Exception("\u8bf7\u4e3a\u6d41\u7a0b\u7ef4\u62a4\u5bf9\u5e94\u8868\u5355\uff01");
            }
            currentFormInstanceId = null;
        } else {
            FlowFormInstance flowFormInstance = null;
            if (formInstanceId != null && formInstanceId.length() != 0 && !FlowInstance.formInstanceIdIsKey(formInstanceId)) {
                currentFormInstanceId = formInstanceId;
                if (flowFormId >= 0) {
                    currentFormId = flowFormId;
                } else {
                    flowFormInstance = flowInstance.getForm(formInstanceId);
                    if (flowFormInstance != null) {
                        currentFormId = flowFormInstance.getFlowFormId();
                    } else {
                        flowInstance.addDefaultFormInstance(currentNodeInstanceId, formInstanceId);
                        currentFormId = nodeInstance.getDefaultForm();
                    }
                }
            } else if (flowFormId >= 0) {
                currentFormId = flowFormId;
                if (FlowInstance.formInstanceIdIsKey(formInstanceId)) {
                    currentFormInstanceId = flowInstance.getFormInstanceIdByKeyWord(formInstanceId);
                } else {
                    flowFormInstance = flowInstance.getForm(currentFormId);
                    if (flowFormInstance != null) {
                        currentFormInstanceId = flowFormInstance.getInstanceId();
                    } else {
                        FlowNode flowNode = flowInstance.getTemplet().getNodeById(currentFlowNodeId);
                        currentCreateForm = flowNode.isCreateForm(currentFormId);
                    }
                }
            } else {
                currentFormId = nodeInstance.getDefaultForm();
                if (currentFormId >= 0) {
                    if (FlowInstance.formInstanceIdIsKey(formInstanceId)) {
                        currentFormInstanceId = flowInstance.getFormInstanceIdByKeyWord(formInstanceId);
                    } else {
                        flowFormInstance = flowInstance.getForm(currentFormId);
                        if (flowFormInstance != null) {
                            currentFormInstanceId = flowFormInstance.getInstanceId();
                        } else {
                            currentCreateForm = true;
                        }
                    }
                }
            }
        }
        this.setFlowInstance(flowInstance);
        this.setNodeInstanceId(currentNodeInstanceId);
        this.setFormId(currentFormId);
        this.setFormInstanceId(currentFormInstanceId);
        this.setCreateForm(currentCreateForm);
    }

    public FlowInstance getFlowInstance() {
        return this.flowInstance;
    }

    public void setFlowInstance(FlowInstance flowInstance) {
        this.flowInstance = flowInstance;
    }

    public int getFormId() {
        return this.formId;
    }

    public void setFormId(int formId) {
        this.formId = formId;
    }

    public void setCreateForm(boolean isCreateForm) {
        this.isCreateForm = isCreateForm;
    }

    public String getFormInstanceId() {
        return this.formInstanceId;
    }

    public void setFormInstanceId(String formInstanceId) {
        this.formInstanceId = formInstanceId;
    }

    public int getNodeInstanceId() {
        return this.nodeInstanceId;
    }

    public void setNodeInstanceId(int nodeInstanceId) {
        this.nodeInstanceId = nodeInstanceId;
    }

    public String getFlowId() {
        return this.flowId;
    }

    public void setFlowId(String flowId) {
        this.flowId = flowId;
    }

    public boolean isCreateForm() {
        return this.isCreateForm;
    }
}

