/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.workflow.service;

import com.sdjxd.hussar.core.utils.HussarString;
import com.sdjxd.hussar.core.workflow72.bo.IFlowInstance;
import com.sdjxd.pms.platform.base.BaseObject;
import com.sdjxd.pms.platform.base.DataModify;
import com.sdjxd.pms.platform.base.DataStatus;
import com.sdjxd.pms.platform.base.Global;
import com.sdjxd.pms.platform.base.PlatformLogger;
import com.sdjxd.pms.platform.data.DbOper;
import com.sdjxd.pms.platform.data.DbSession;
import com.sdjxd.pms.platform.form.model.TreeNodeBean;
import com.sdjxd.pms.platform.form.service.cell.Tree;
import com.sdjxd.pms.platform.organize.User;
import com.sdjxd.pms.platform.tool.BeanTool;
import com.sdjxd.pms.platform.tool.DateTool;
import com.sdjxd.pms.platform.tool.Guid;
import com.sdjxd.pms.platform.tool.StringTool;
import com.sdjxd.pms.platform.workflow.dao.FlowInstanceDao;
import com.sdjxd.pms.platform.workflow.model.FlowChildInstanceBean;
import com.sdjxd.pms.platform.workflow.model.FlowFormInstanceBean;
import com.sdjxd.pms.platform.workflow.model.FlowInstanceBean;
import com.sdjxd.pms.platform.workflow.model.FlowInterFaceInstanceBean;
import com.sdjxd.pms.platform.workflow.model.FlowParamInstanceBean;
import com.sdjxd.pms.platform.workflow.service.CounterSign;
import com.sdjxd.pms.platform.workflow.service.Flow;
import com.sdjxd.pms.platform.workflow.service.FlowChildInstance;
import com.sdjxd.pms.platform.workflow.service.FlowDelegate;
import com.sdjxd.pms.platform.workflow.service.FlowFormInstance;
import com.sdjxd.pms.platform.workflow.service.FlowNode;
import com.sdjxd.pms.platform.workflow.service.FlowNodeInstance;
import com.sdjxd.pms.platform.workflow.service.FlowOperator;
import com.sdjxd.pms.platform.workflow.service.FlowOperatorManager;
import com.sdjxd.pms.platform.workflow.service.FlowParamInstance;
import com.sdjxd.pms.platform.workflow.service.FlowParameter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.sql.RowSet;
import org.apache.log4j.Logger;

public class FlowInstance
extends BaseObject
implements IFlowInstance {
    public static final Map<String, String> syncMap = Collections.synchronizedMap(new HashMap());
    private static final long serialVersionUID = 1L;
    protected static FlowInstanceDao dao;
    private static Logger log;
    public static String WF_IMGPATH;
    public static final String SESSION_KEY;
    public static final int MAX_NODEINSTANCE_NUM;
    private Flow templet;
    private String flowId;
    private String flowName;
    private Date createDate;
    private Date endDate;
    private User createUser;
    private String version;
    private User opener;
    private String openerId;
    private Calendar lastopentime;
    private static int MAX_OPENTIME;
    private boolean readOnly = false;
    private int runStatus;
    public static final int RUNSTATUS_CURRENT = 0;
    public static final int RUNSTATUS_COMPLET = 1;
    public static final int RUNSTATUS_TERMINATE = 2;
    public static final int RUNSTATUS_HANG = 3;
    public static final int RUNSTATUS_UNTREAD = 4;
    public static final int RUNSTATUS_UNSTART = 5;
    public static final int RUNSTATUS_CALLBACK = 6;
    private DataModify dataModify;
    protected List nodeInstances;
    private Map paramInstance;
    protected Map formInstance;
    private List nodeChildInstance;
    private Map interFaceInstances;
    public static final String BEFORE_CREATE = "beforecreate";
    public static final String AFTER_CREATE = "aftercreate";
    public static final String BEFORE_START = "beforestart";
    public static final String AFTER_START = "afterstart";
    public static final String BEFORE_COMPLETE = "beforecomplete";
    public static final String AFTER_COMPLETE = "aftercomplete";
    public static final String BEFORE_HANG = "beforehang";
    public static final String AFTER_HANG = "afterhang";
    public static final String BEFORE_RESUME = "beforeresume";
    public static final String AFTER_RESUME = "afterresume";
    public static final String AFTER_OVERTIME = "afterterminate";
    public static final String BEFORE_TERMINATE = "beforeterminate";
    public static final String AFTER_TERMINATE = "afterterminate";
    public static final String BEFORE_DELETE = "beforedelete";
    public static final String AFTER_DELETE = "afterdelete";
    public static final String BEFORE_SAVE = "beforesave";
    public static final String AFTER_SAVE = "aftersave";
    public static final String AFTER_CALLBACK = "aftercallback";
    public static final String AFTER_UNTREAD = "afteruntread";
    public static final String BEFORE_SUBMIT = "beforesubmit";
    public static final int USERTYPE_USER = 0;
    public static final int USERTYPE_ROLE = 1;
    public static final int USERTYPE_ORG = 2;
    private boolean submiting = false;
    private boolean untreading = false;
    private boolean callbacking = false;
    private static ThreadLocal currentContext;

    static {
        log = Logger.getLogger(FlowInstance.class);
        WF_IMGPATH = String.valueOf(Global.getName()) + "/pms/platform/image/flow/";
        dao = FlowInstanceDao.createInstance();
        FlowInstanceDao.clearFlowOperInfo();
        SESSION_KEY = "FLOWINSTANCE";
        MAX_NODEINSTANCE_NUM = 30;
        try {
            MAX_OPENTIME = Integer.parseInt(Global.getConfig("MAX_FORM_OPENTIME")) * 60 * 1000;
        }
        catch (Exception exp) {
            MAX_OPENTIME = 36000000;
        }
        currentContext = new ThreadLocal();
    }

    protected FlowInstance() {
    }

    public FlowInstance(Flow flow) {
        this.nodeInstances = new ArrayList();
        this.paramInstance = new HashMap();
        this.formInstance = new HashMap();
        this.interFaceInstances = new HashMap();
        this.templet = flow;
        this.flowName = flow.getFlowName();
        this.flowId = flow.getId();
        this.nodeChildInstance = new ArrayList();
        flow.registerEvent(this);
    }

    public static FlowInstance create(Flow flow) throws Exception {
        FlowInstance flowInstance = new FlowInstance(flow);
        flowInstance.id = Guid.create();
        flowInstance.dataModify = DataModify.NEW;
        flowInstance.dataStatus = DataStatus.NORMAL;
        flowInstance.runStatus = 0;
        flowInstance.saveToCache();
        flowInstance.createDate = DateTool.parseDate(DateTool.getNow());
        flowInstance.endDate = null;
        flowInstance.version = "7.2";
        flowInstance.opener = User.getCurrentUser();
        flowInstance.openerId = User.getCurrentUser().getId();
        flowInstance.lastopentime = DateTool.getCalendar(new Date());
        Map map = flow.getParameters();
        for (Map.Entry entry : map.entrySet()) {
            FlowParameter fp = (FlowParameter)entry.getValue();
            flowInstance.paramInstance.put(fp.getName(), FlowParamInstance.create(flowInstance.id, fp.getName(), fp.getValue()));
        }
        flowInstance.setParameter("NAME", "\u672a\u547d\u540d");
        flowInstance.setParameter("STARTTIME", DateTool.formatDateTime(flowInstance.createDate));
        flowInstance.setParameter("ENDTIME", "");
        User user = User.getCurrentUser();
        if (user != null) {
            flowInstance.createUser = user;
            flowInstance.setParameter("STARTUSER", user.getId());
        } else {
            flowInstance.createUser = new User();
        }
        flow.getStartNode().start(flowInstance, -1, null);
        flowInstance.fire(AFTER_START);
        PlatformLogger.log(flowInstance.getFlowId(), flowInstance.getId(), "\u6d41\u7a0b\u5b9e\u4f8b", 1);
        return flowInstance;
    }

    public static FlowInstance load(String flowInstanceId) throws Exception {
        FlowInstance instance = FlowInstance.loadFromCache(flowInstanceId);
        if (instance == null) {
            instance = FlowInstance.loadFromDb(flowInstanceId);
        }
        return instance;
    }

    public static FlowInstance loadFromCache(String flowInstanceId) {
        FlowInstance instance = null;
        if (Global.getContext() != null) {
            String key = String.valueOf(SESSION_KEY) + flowInstanceId;
            instance = (FlowInstance)Global.getContext().getSession(key);
        } else {
            HashMap map = (HashMap)currentContext.get();
            if (map != null) {
                instance = (FlowInstance)map.get(flowInstanceId);
            }
        }
        return instance;
    }

    public static FlowInstance loadFromDb(String flowInstanceId) throws Exception {
        FlowInstanceBean model = dao.getFlowInstance(flowInstanceId);
        return FlowInstance.loadFromDb(model);
    }

    public static FlowInstance loadFromDbNotUpdateCache(String flowInstanceId) throws Exception {
        FlowInstanceBean model = dao.getFlowInstance(flowInstanceId);
        return FlowInstance.loadFromDbNotUpdateCache(model);
    }

    public static FlowInstance loadFromDbNotUpdateCache(FlowInstanceBean model) throws Exception {
        int i;
        Flow flow = Flow.getFlow(model.getFlowId());
        if (flow == null) {
            return null;
        }
        FlowInstance flowInstance = new FlowInstance(flow);
        flowInstance.createDate = model.getCreateDate();
        flowInstance.createUser = User.getUser(model.getCreateUserId());
        flowInstance.dataStatus = model.getDataStatus();
        flowInstance.endDate = model.getEndDate();
        flowInstance.flowId = model.getFlowId();
        flowInstance.flowName = model.getFlowName();
        flowInstance.id = model.getId();
        flowInstance.name = model.getName();
        flowInstance.runStatus = model.getRunStatus();
        flowInstance.opener = User.getUser(model.getOpenerId());
        flowInstance.openerId = model.getOpenerId();
        flowInstance.lastopentime = DateTool.parseCal(model.getLastopentime());
        if (!StringTool.isEmpty(model.getVersion())) {
            flowInstance.version = model.getVersion();
        }
        flowInstance.dataModify = DataModify.SAVED;
        FlowNodeInstance.loadFlowNodeInstance(flowInstance);
        List list = dao.getFlowFormInstance(model.getId());
        if (list != null && list.size() > 0) {
            i = 0;
            while (i < list.size()) {
                FlowFormInstanceBean ffiModel = (FlowFormInstanceBean)list.get(i);
                FlowFormInstance ffi = (FlowFormInstance)flowInstance.formInstance.get(String.valueOf(ffiModel.getFlowFormId()));
                if (ffi == null) {
                    ffi = new FlowFormInstance();
                    ffi.load(ffiModel);
                    flowInstance.formInstance.put(String.valueOf(ffiModel.getFlowFormId()), ffi);
                } else {
                    ffi.loadAddFormInstance(ffiModel.getFormInstanceId());
                }
                ++i;
            }
        }
        if ((list = dao.getFlowParamInstance(model.getId())) != null && list.size() > 0) {
            i = 0;
            while (i < list.size()) {
                FlowParamInstance fpi = new FlowParamInstance();
                FlowParamInstanceBean fpiModel = (FlowParamInstanceBean)list.get(i);
                fpi.load(fpiModel);
                flowInstance.paramInstance.put(fpiModel.getParamName(), fpi);
                ++i;
            }
        }
        list = dao.getChildInstance(model.getId());
        i = 0;
        while (i < list.size()) {
            FlowChildInstanceBean fncimodel = (FlowChildInstanceBean)list.get(i);
            FlowChildInstance fncInstance = new FlowChildInstance();
            fncInstance.load(fncimodel);
            flowInstance.nodeChildInstance.add(fncInstance);
            ++i;
        }
        list = dao.getInterFaceInstance(model.getId());
        int i2 = 0;
        while (i2 < list.size()) {
            FlowInterFaceInstanceBean interFaceInstance = (FlowInterFaceInstanceBean)list.get(i2);
            int nodeInstanceId = interFaceInstance.getNodeInstanceId();
            ArrayList<FlowInterFaceInstanceBean> interFaceInstances = (ArrayList<FlowInterFaceInstanceBean>)flowInstance.interFaceInstances.get(String.valueOf(nodeInstanceId));
            if (interFaceInstances == null) {
                interFaceInstances = new ArrayList<FlowInterFaceInstanceBean>();
                flowInstance.interFaceInstances.put(String.valueOf(nodeInstanceId), interFaceInstances);
            }
            interFaceInstances.add(interFaceInstance);
            ++i2;
        }
        return flowInstance;
    }

    public static FlowInstance loadFromDbByForm(String formInstanceId) throws Exception {
        FlowInstanceBean model = dao.getFlowInstanceByForm(formInstanceId);
        return FlowInstance.loadFromDb(model);
    }

    public static FlowInstance loadFromDb(FlowInstanceBean model) throws Exception {
        FlowInstance flowInstance = FlowInstance.loadFromDbNotUpdateCache(model);
        if (flowInstance != null) {
            flowInstance.saveToCache();
        }
        return flowInstance;
    }

    public static boolean save(String flowInstanceId, Map formVariable, Map formVariableValue, Map formVariableText, int flowFormId) throws Exception {
        FlowInstance flowInstance = FlowInstance.load(flowInstanceId);
        return flowInstance.save(formVariable, formVariableValue, formVariableText, flowFormId, new HashMap());
    }

    public static boolean save(String flowInstanceId, Map formVariable, Map formVariableValue, Map formVariableText, int flowFormId, Map formParam) throws Exception {
        FlowInstance flowInstance = FlowInstance.load(flowInstanceId);
        return flowInstance.save(formVariable, formVariableValue, formVariableText, flowFormId, formParam);
    }

    public boolean save(Map formVariable, Map formVariableValue, Map formVariableText, int flowFormId) throws Exception {
        this.setFormVariable(formVariable, formVariableValue, formVariableText, flowFormId, new HashMap());
        return this.save();
    }

    public boolean save(Map formVariable, Map formVariableValue, Map formVariableText, int flowFormId, Map formParam) throws Exception {
        this.setFormVariable(formVariable, formVariableValue, formVariableText, flowFormId, formParam);
        if (this.getDataModify().is(DataModify.NEW)) {
            return this.save();
        }
        return this.saveFlowInfo();
    }

    private boolean saveFlowInfo() {
        try {
            FlowNodeInstance nodeInstance;
            for (Map.Entry entry : this.paramInstance.entrySet()) {
                FlowParamInstance paramInstance = (FlowParamInstance)entry.getValue();
                paramInstance.save();
            }
            for (Map.Entry entry : this.formInstance.entrySet()) {
                FlowFormInstance formInstance = (FlowFormInstance)entry.getValue();
                formInstance.save();
            }
            int nodeInstanceId = -1;
            if (!StringTool.isEmpty(Global.getContext().getParameterNoQuotes("n"))) {
                nodeInstanceId = Integer.parseInt(Global.getContext().getParameterNoQuotes("n"));
            } else if (!StringTool.isEmpty(Global.getContext().getParameterNoQuotes("h_flowNodeInstanceId"))) {
                nodeInstanceId = Integer.parseInt(Global.getContext().getParameterNoQuotes("h_flowNodeInstanceId"));
            }
            if (nodeInstanceId >= 0 && (nodeInstance = this.getFlowNodeInstance(nodeInstanceId)) != null) {
                nodeInstance.saveOperatorManager();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static boolean save(String flowInstanceId, int flowFormId, Map formVariable) throws Exception {
        FlowInstance flowInstance = FlowInstance.load(flowInstanceId);
        return flowInstance.save(formVariable, null, null, flowFormId, null);
    }

    public boolean save() throws Exception {
        if (!this.canOpen()) {
            throw new Exception("\u6d41\u7a0b\u5df2\u88ab\u3010" + this.opener.getName() + "\u3011\u6253\u5f00\uff0c\u65e0\u6cd5\u6267\u884c\u5f53\u524d\u64cd\u4f5c\uff01");
        }
        boolean success = false;
        DbSession session = DbOper.openDb("defaultds");
        try {
            try {
                FlowInstanceBean model = new FlowInstanceBean();
                model.setCreateDate(this.createDate);
                model.setCreateUserId(this.createUser.getId());
                model.setCreateUserName(this.createUser.getName());
                model.setDataStatus(this.dataStatus);
                model.setEndDate(this.endDate);
                model.setFlowId(this.flowId);
                model.setFlowName(this.flowName);
                model.setId(this.id);
                model.setName(this.name);
                model.setRunStatus(this.runStatus);
                if (!StringTool.isEmpty(this.version)) {
                    model.setVersion(this.version);
                }
                if (this.opener != null) {
                    model.setOpener(this.opener.getName());
                }
                if (this.getOpenerId() != null) {
                    model.setOpenerId(this.getOpenerId());
                }
                if (this.getLastopentime() != null) {
                    model.setLastopentime(DateTool.formatDateTime(this.getLastopentime().getTime()));
                }
                if (!DataModify.SAVED.is(this.dataModify)) {
                    dao.saveInstance(model, this.dataModify);
                }
                for (FlowNodeInstance nodeInstance : this.nodeInstances) {
                    if (nodeInstance == null) continue;
                    nodeInstance.save();
                }
                for (Map.Entry entry : this.paramInstance.entrySet()) {
                    FlowParamInstance paramInstance = (FlowParamInstance)entry.getValue();
                    paramInstance.save();
                }
                for (Map.Entry entry : this.formInstance.entrySet()) {
                    FlowFormInstance formInstance = (FlowFormInstance)entry.getValue();
                    formInstance.save();
                }
                if (this.nodeChildInstance != null && this.nodeChildInstance.size() > 0) {
                    int i = 0;
                    while (i < this.nodeChildInstance.size()) {
                        FlowChildInstance flowNodeChildInstance = (FlowChildInstance)this.nodeChildInstance.get(i);
                        if (flowNodeChildInstance != null) {
                            flowNodeChildInstance.save();
                        }
                        ++i;
                    }
                }
                this.fire(AFTER_SAVE);
                DbOper.commitDb(session);
                if (!DataModify.DELETE.is(this.dataModify)) {
                    PlatformLogger.log(this.flowId, this.id, "\u6d41\u7a0b\u5b9e\u4f8b", 2);
                }
                success = true;
            }
            catch (Exception exp) {
                DbOper.rollbackDb(session);
                success = false;
                throw exp;
            }
        }
        finally {
            DbOper.closeDb(session);
        }
        this.dataModify = DataModify.SAVED;
        return success;
    }

    public void saveToCache() {
        String key = String.valueOf(SESSION_KEY) + this.id;
        if (Global.getContext() != null) {
            Global.getContext().setSession(key, this);
        } else {
            HashMap<String, FlowInstance> map = (HashMap<String, FlowInstance>)currentContext.get();
            if (map == null) {
                map = new HashMap<String, FlowInstance>();
            }
            map.put(this.id, this);
            currentContext.set(map);
        }
    }

    public void clearCache() {
        String key = String.valueOf(SESSION_KEY) + this.id;
        if (Global.getContext() != null) {
            Global.getContext().removeSession(key);
        } else {
            Map map = (Map)currentContext.get();
            if (map != null) {
                map.remove(this.id);
                currentContext.set(map);
            }
        }
    }

    public static boolean delete(String[] flowInstanceIds) {
        try {
            String flowInstanceId = "";
            int i = 0;
            while (i < flowInstanceIds.length) {
                flowInstanceId = flowInstanceIds[i];
                FlowInstance flowInstance = FlowInstance.load(flowInstanceId);
                flowInstance.delete();
                flowInstance.save();
                PlatformLogger.log(flowInstance.getFlowId(), flowInstanceId, "\u6d41\u7a0b\u5b9e\u4f8b", 3);
                ++i;
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean delete(String flowInstanceId) {
        try {
            FlowInstance flowInstance = FlowInstance.load(flowInstanceId);
            flowInstance.delete();
            flowInstance.save();
            PlatformLogger.log(flowInstance.getFlowId(), flowInstanceId, "\u6d41\u7a0b\u5b9e\u4f8b", 3);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean deleteByForm(String formInstanceId) {
        try {
            FlowInstance flowInstance = FlowInstance.loadFromDbByForm(formInstanceId);
            flowInstance.delete();
            flowInstance.save();
            PlatformLogger.log(flowInstance.getFlowId(), flowInstance.getId(), "\u6d41\u7a0b\u5b9e\u4f8b", 3);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void delete() throws Exception {
        this.fire(BEFORE_DELETE);
        this.dataStatus = DataStatus.DELETE;
        this.modify();
        for (FlowNodeInstance nodeInstance : this.nodeInstances) {
            nodeInstance.delete();
        }
        this.deleteFlowForm();
        this.fire(AFTER_DELETE);
    }

    public void deleteFlowForm() {
        try {
            ArrayList<String> list = new ArrayList<String>();
            String formSql1 = "select FORMINSTANCEID from JXD7_WF_FORMINSTANCE where flowinstanceid='" + this.id + "'";
            RowSet formrs = DbOper.executeQuery(formSql1);
            while (formrs.next()) {
                String forminstanceid = formrs.getString("FORMINSTANCEID");
                String formSql2 = "select p.tablename from jxd7_pm_index i,jxd7_pm_pattern p where i.sheetid='" + forminstanceid + "' and i.patternid=p.patternid";
                RowSet tablers = DbOper.executeQuery(formSql2);
                while (tablers.next()) {
                    String tablename = tablers.getString("TABLENAME");
                    if ("".equals(tablename)) continue;
                    String delformSql = "delete from " + tablename + " where sheetid = '" + forminstanceid + "'";
                    list.add(delformSql);
                }
            }
            DbOper.executeNonQuery(list);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void modify() {
        if (!this.dataModify.is(DataModify.NEW)) {
            this.dataModify = DataModify.MODIFY;
        }
    }

    public static boolean hang(String flowInstanceId) {
        try {
            FlowInstance flowInstance = FlowInstance.load(flowInstanceId);
            flowInstance.hang();
            flowInstance.save();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void hang() throws Exception {
        if (this.runStatus != 0) {
            throw new Exception("\u672c\u6d41\u7a0b\u5904\u4e8e\u975e\u8fd0\u884c\u72b6\u6001\uff0c\u4e0d\u53ef\u6302\u8d77!");
        }
        this.fire(BEFORE_HANG);
        dao.insertHandInfo(this.id, this.getLastRunStatusInstance().getNodeInstanceId());
        this.runStatus = 3;
        this.modify();
        this.fire(AFTER_HANG);
    }

    public static boolean resume(String flowInstanceId) {
        try {
            FlowInstance flowInstance = FlowInstance.load(flowInstanceId);
            flowInstance.resume();
            flowInstance.save();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void resume() throws Exception {
        if (this.runStatus != 3) {
            throw new Exception("\u672c\u6d41\u7a0b\u5904\u4e8e\u975e\u6302\u8d77\u72b6\u6001\uff0c\u4e0d\u53ef\u4ee5\u6062\u590d\uff01");
        }
        this.fire(BEFORE_RESUME);
        dao.updateHandInfo(this.id, this.getLastRunStatusInstance().getNodeInstanceId());
        this.runStatus = 0;
        this.modify();
        this.fire(AFTER_RESUME);
    }

    public static boolean terminate(String flowInstanceId) {
        try {
            FlowInstance flowInstance = FlowInstance.load(flowInstanceId);
            flowInstance.terminate();
            flowInstance.save();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void terminate() throws Exception {
        if (this.runStatus != 2 && this.runStatus != 1) {
            this.fire(BEFORE_TERMINATE);
            this.runStatus = 2;
            this.modify();
            for (FlowNodeInstance nodeInstance : this.nodeInstances) {
                nodeInstance.terminate();
            }
            this.fire("afterterminate");
        }
    }

    public FlowParameter getParameter(int paramId) {
        return this.templet.getParameter(paramId);
    }

    public Object getParameterValue(int paramId) throws Exception {
        FlowParameter parameter = this.templet.getParameter(paramId);
        return parameter.convert(this.getParameter(parameter.getName()));
    }

    public Object getParameter(String parameterName) {
        FlowParamInstance paramInstance = (FlowParamInstance)this.paramInstance.get(parameterName);
        Object value = null;
        if (paramInstance != null && (value = paramInstance.getParamValue()) instanceof String) {
            value = this.replace((String)value);
        }
        return value;
    }

    public void setParameter(String parameterName, Object value) throws Exception {
        FlowParamInstance paramInstance = (FlowParamInstance)this.paramInstance.get(parameterName);
        if (paramInstance != null) {
            paramInstance.setParamValue(value);
        } else {
            paramInstance = FlowParamInstance.create(this.id, parameterName, value);
            this.paramInstance.put(parameterName, paramInstance);
        }
        if ("NAME".equals(parameterName) && value != null && !value.equals(this.name)) {
            this.name = (String)paramInstance.getParamValue();
            this.modify();
        }
    }

    public void setFormVariable(Map formVariable, Map formVariableValue, Map formVariableText, int flowFormId) throws Exception {
        this.setFormVariable(formVariable, formVariableValue, formVariableText, flowFormId, new HashMap());
    }

    public void setFormVariable(Map formVariable, Map formVariableValue, Map formVariableText, int flowFormId, Map formParam) throws Exception {
        if (formVariable == null) {
            return;
        }
        Map parameters = this.templet.getParameters();
        for (Map.Entry tempEntry : parameters.entrySet()) {
            FlowParameter fp = (FlowParameter)tempEntry.getValue();
            if (fp == null) continue;
            int fpFlowFormId = fp.getFormId();
            if (fpFlowFormId >= 0 && (flowFormId < 0 || flowFormId == fpFlowFormId)) {
                Object paramValue;
                String paramName = fp.getName();
                int varType = fp.getVarType();
                if (varType == 1 && formVariableValue != null) {
                    paramValue = formVariableValue.get(fp.getFormVariable());
                    if (paramValue == null) continue;
                    this.setParameter(paramName, paramValue);
                    continue;
                }
                if (varType == 2 && formVariableText != null) {
                    paramValue = formVariableText.get(fp.getFormVariable());
                    if (paramValue == null) continue;
                    this.setParameter(paramName, paramValue);
                    continue;
                }
                paramValue = formVariable.get(fp.getFormVariable());
                if (paramValue == null) continue;
                this.setParameter(paramName, paramValue);
                continue;
            }
            if (fp.getParamFormId() == -1) continue;
            this.setParameter(fp.getName(), formParam.get(String.valueOf(fp.getFormParamId())));
        }
    }

    public User getCreateUser() {
        return this.createUser;
    }

    public String getCreateUserId() {
        if (this.createUser != null) {
            return this.createUser.getId();
        }
        return null;
    }

    public void addFlowNodeInstance(FlowNodeInstance flowNodeInstance) {
        if (flowNodeInstance != null) {
            int nodeInstanceId = flowNodeInstance.getNodeInstanceId();
            int count = this.getFlowNodeInstanceSize();
            while (nodeInstanceId > count) {
                this.nodeInstances.add(null);
                ++count;
            }
            if (nodeInstanceId == count) {
                this.nodeInstances.add(flowNodeInstance);
            } else {
                this.nodeInstances.set(nodeInstanceId, flowNodeInstance);
            }
        }
    }

    public int getFlowNodeInstanceSize() {
        if (this.nodeInstances != null) {
            return this.nodeInstances.size();
        }
        return 0;
    }

    public FlowNodeInstance getFlowNodeInstance(int nodeInstanceId) {
        if (nodeInstanceId >= 0 && nodeInstanceId < this.nodeInstances.size()) {
            return (FlowNodeInstance)this.nodeInstances.get(nodeInstanceId);
        }
        return null;
    }

    public String getFlowName() {
        return this.flowName;
    }

    public FlowNodeInstance getLastRunStatusInstance() {
        int i = this.nodeInstances.size() - 1;
        while (i >= 0) {
            FlowNodeInstance nodeInstance = (FlowNodeInstance)this.nodeInstances.get(i);
            if (nodeInstance != null && nodeInstance.getRunStatus() == 0) {
                return nodeInstance;
            }
            --i;
        }
        return null;
    }

    public FlowNodeInstance getLastNodeInstance() {
        FlowNodeInstance lastNodeInstance = null;
        int len = this.nodeInstances.size();
        int i = len - 1;
        while (i >= 0) {
            FlowNodeInstance nodeInstance = (FlowNodeInstance)this.nodeInstances.get(i);
            if (nodeInstance != null) {
                int lastStatus = nodeInstance.getRunStatus();
                if (lastNodeInstance == null) {
                    lastNodeInstance = nodeInstance;
                } else if (lastStatus == 0) {
                    lastNodeInstance = nodeInstance;
                }
            }
            --i;
        }
        return lastNodeInstance;
    }

    public FlowNodeInstance getLastNodeInstance(FlowNode node) {
        FlowNodeInstance nodeInstance = null;
        int i = this.nodeInstances.size() - 1;
        while (i >= 0) {
            nodeInstance = (FlowNodeInstance)this.nodeInstances.get(i);
            if (nodeInstance != null && node.isInstance(nodeInstance)) {
                return nodeInstance;
            }
            --i;
        }
        return null;
    }

    public FlowNodeInstance getLastNodeInstance(int flowNodeId) {
        FlowNodeInstance nodeInstance = null;
        int i = this.nodeInstances.size() - 1;
        while (i >= 0) {
            nodeInstance = (FlowNodeInstance)this.nodeInstances.get(i);
            if (nodeInstance != null && nodeInstance.getFlowNodeId() == flowNodeId) {
                return nodeInstance;
            }
            --i;
        }
        return null;
    }

    public String getDefaultFormUrl(int nodeInstanceId) throws Exception {
        FlowNodeInstance nodeInstance = this.getFlowNodeInstance(nodeInstanceId);
        if (nodeInstance == null) {
            throw new Exception("\u53c2\u6570\u9519\u8bef\uff01\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u6d41\u7a0b\u8282\u70b9\u5b9e\u4f8b");
        }
        int formId = nodeInstance.getDefaultForm();
        return this.getFormUrl(formId, nodeInstanceId, false);
    }

    public String getFormUrl(int formId, int nodeInstanceId, boolean isCreateAttach) throws Exception {
        FlowNodeInstance nodeInstance = this.getFlowNodeInstance(nodeInstanceId);
        if (nodeInstance == null) {
            throw new Exception("\u53c2\u6570\u9519\u8bef\uff01\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u6d41\u7a0b\u8282\u70b9\u5b9e\u4f8b");
        }
        FlowFormInstance flowFormInstance = (FlowFormInstance)this.formInstance.get(Integer.toString(formId));
        if (flowFormInstance != null && !isCreateAttach) {
            return this.getFormUrl(flowFormInstance, nodeInstanceId);
        }
        String url = this.templet.getFormUrl(this, nodeInstanceId, formId);
        return this.replace(url);
    }

    public String getFormUrl(FlowFormInstance flowFormInstance, int nodeInstanceId) throws Exception {
        if (flowFormInstance != null) {
            String url = this.templet.getFormUrl(this, nodeInstanceId, flowFormInstance);
            return this.replace(url);
        }
        return null;
    }

    public String getFormUrl(FlowFormInstance flowFormInstance, int nodeInstanceId, String formInstanceId) throws Exception {
        if (flowFormInstance != null) {
            String url = this.templet.getFormUrl(this, nodeInstanceId, flowFormInstance, formInstanceId);
            return this.replace(url);
        }
        return null;
    }

    public String getFormUrl(int formId) throws Exception {
        FlowNodeInstance nodeInstance = this.getLastRunStatusInstance();
        if (nodeInstance == null) {
            throw new Exception("\u53c2\u6570\u9519\u8bef\uff01\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u6d41\u7a0b\u8282\u70b9\u5b9e\u4f8b");
        }
        return this.getFormUrl(formId, nodeInstance.getNodeInstanceId(), false);
    }

    public String getFormUrl(int nodeInstanceId, int formId, String formInstanceId, boolean isCreateForm) throws Exception {
        int currentFormId = formId < 0 ? this.getFlowNodeInstance(nodeInstanceId).getDefaultForm() : formId;
        String url = this.templet.getFormUrl(currentFormId);
        url = url.replaceAll("\\[flow.id\\]", String.valueOf(this.flowId));
        url = url.replaceAll("\\[flow.instance.id\\]", String.valueOf(this.id));
        FlowNodeInstance nodeInstance = this.getFlowNodeInstance(nodeInstanceId);
        url = url.replaceAll("\\[flow.node.id\\]", String.valueOf(nodeInstance.getFlowNodeId()));
        url = url.replaceAll("\\[flow.node.name\\]", String.valueOf(nodeInstance.getFlowNodeName()));
        url = url.replaceAll("\\[flow.node.instance.id\\]", String.valueOf(nodeInstanceId));
        url = url.replaceAll("\\[flow.form.id\\]", String.valueOf(currentFormId));
        url = url.replaceAll("\\[flow.form.instance.id\\]", StringTool.isEmpty(formInstanceId) ? "" : formInstanceId);
        url = url.replaceAll("\\[flow.form.create\\]", isCreateForm ? "1" : "0");
        return this.replace(url);
    }

    public String replace(String sstr) {
        String ostr = sstr;
        HashMap<String, String> replace = new HashMap<String, String>();
        if (this.getCreateUserId() != null) {
            replace.put("[flow.creater.id]", this.getCreateUserId());
        }
        if (this.createUser != null) {
            replace.put("[flow.creater.deptId]", this.createUser.getDeptId());
        }
        ostr = StringTool.replace(ostr, replace);
        ostr = StringTool.replaceKeyWord(ostr);
        return FlowParamInstance.replace(ostr, this.paramInstance);
    }

    public String replace(String sstr, int nodeInstanceId) {
        String ostr = sstr;
        FlowNodeInstance nodeInstance = this.getFlowNodeInstance(nodeInstanceId);
        String sendUserId = nodeInstance.getCreateUserId();
        User sendUser = nodeInstance.getCreateUser();
        HashMap<String, String> replace = new HashMap<String, String>();
        replace.put("[flow.creater.id]", this.getCreateUserId());
        replace.put("[flow.creater.deptId]", this.createUser.getDeptId());
        replace.put("[flow.sender.id]", sendUserId);
        replace.put("[flow.sender.deptId]", sendUser.getDeptId());
        ostr = StringTool.replace(ostr, replace);
        ostr = StringTool.replaceKeyWord(ostr);
        return FlowParamInstance.replace(ostr, this.paramInstance);
    }

    public int getRunStatus() {
        return this.runStatus;
    }

    public DataModify getDataModify() {
        return this.dataModify;
    }

    public String getFlowId() {
        return this.flowId;
    }

    public String draw() throws Exception {
        return this.templet.draw(this);
    }

    public void addDefaultFormInstance(int nodeInstanceId, String formInstanceId) throws Exception {
        FlowNodeInstance nodeInstance = this.getFlowNodeInstance(nodeInstanceId);
        int formId = nodeInstance.getDefaultForm();
        this.addFormInstance(formId, formInstanceId, nodeInstanceId);
        this.setParameter("CURRENTFORMINSTANCEID", formInstanceId);
    }

    public void addFormInstance(int formId, String formInstanceId, int nodeInstanceId) {
        int flowNodeId;
        FlowNode flowNode;
        FlowNodeInstance nodeInstance = this.getFlowNodeInstance(nodeInstanceId);
        if (nodeInstance != null && (flowNode = this.templet.getNodeById(flowNodeId = nodeInstance.getFlowNodeId())).isAllowForm(formId)) {
            FlowFormInstance flowFormInstance = (FlowFormInstance)this.formInstance.get(String.valueOf(formId));
            if (flowFormInstance == null) {
                flowFormInstance = FlowFormInstance.create(this.id, formId, formInstanceId);
                this.formInstance.put(String.valueOf(formId), flowFormInstance);
            } else {
                flowFormInstance.addInstance(formInstanceId);
            }
        }
    }

    public void addFormInstance(int formId, String formInstanceId) {
        FlowFormInstance flowFormInstance = (FlowFormInstance)this.formInstance.get(String.valueOf(formId));
        if (flowFormInstance == null) {
            flowFormInstance = FlowFormInstance.create(this.id, formId, formInstanceId);
            this.formInstance.put(String.valueOf(formId), flowFormInstance);
        } else {
            flowFormInstance.addInstance(formInstanceId);
        }
    }

    public int getFormId(String formInstanceId) {
        FlowFormInstance flowFormInstance = this.getForm(formInstanceId);
        if (flowFormInstance != null) {
            return flowFormInstance.getFlowFormId();
        }
        return -1;
    }

    public FlowFormInstance getForm(String formInstanceId) {
        for (Map.Entry entry : this.formInstance.entrySet()) {
            FlowFormInstance flowFormInstance = (FlowFormInstance)entry.getValue();
            if (flowFormInstance == null || !flowFormInstance.contains(formInstanceId)) continue;
            flowFormInstance.setCurFormInstanceId(formInstanceId);
            return flowFormInstance;
        }
        return null;
    }

    public FlowFormInstance getForm(int formId) {
        return (FlowFormInstance)this.formInstance.get(String.valueOf(formId));
    }

    public Flow getTemplet() {
        return this.templet;
    }

    public List getNodeInstance(FlowNode flowNode) {
        ArrayList<FlowNodeInstance> list = new ArrayList<FlowNodeInstance>();
        int i = this.nodeInstances.size() - 1;
        while (i >= 0) {
            FlowNodeInstance nodeInstance = (FlowNodeInstance)this.nodeInstances.get(i);
            if (nodeInstance != null && flowNode.isInstance(nodeInstance)) {
                list.add(nodeInstance);
            }
            --i;
        }
        return list;
    }

    public FlowNodeInstance getUnStartInstance(FlowNode flowNode) {
        int i = this.nodeInstances.size() - 1;
        while (i >= 0) {
            FlowNodeInstance nodeInstance = (FlowNodeInstance)this.nodeInstances.get(i);
            if (nodeInstance != null && flowNode.isInstance(nodeInstance) && (5 == nodeInstance.getRunStatus() || nodeInstance.getRunStatus() == 0)) {
                return nodeInstance;
            }
            --i;
        }
        return null;
    }

    public static int doc2Run(String flowInstanceId) throws Exception {
        return dao.doc2Run(flowInstanceId);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object submit(String flowInstanceId, int nodeInstanceId, HashMap toNodes, boolean isFreeSubmit) throws Exception {
        Object result = null;
        boolean flag = true;
        if (syncMap.get(flowInstanceId) != null) {
            flag = false;
            throw new Exception("\u6d41\u7a0b\u6b63\u5728\u5904\u7406\u4e2d\uff0c\u8bf7\u7a0d\u540e");
        }
        syncMap.put(flowInstanceId, "");
        try {
            FlowInstance flowInstance = FlowInstance.loadFromDb(flowInstanceId);
            if (flowInstance == null) throw new Exception("\u6d41\u7a0b\u5b9e\u4f8b\u7f16\u7801\u9519\u8bef\uff01");
            if ("7.2".equals(flowInstance.getVersion())) {
                Object object = flowInstance.submit72(nodeInstanceId, toNodes, isFreeSubmit);
                return object;
            }
            try {
                if (flowInstance.runStatus == 3) {
                    throw new Exception("\u6d41\u7a0b\u5b9e\u4f8b\u5df2\u6302\u8d77\uff0c\u65e0\u6cd5\u63d0\u4ea4\uff01");
                }
                flowInstance.submiting = true;
                Flow flow = flowInstance.getTemplet();
                FlowNodeInstance nodeInstance = flowInstance.getFlowNodeInstance(nodeInstanceId);
                if (nodeInstance.getRunStatus() == 0) {
                    int flowNodeId = nodeInstance.getFlowNodeId();
                    FlowNode node = flow.getNodeById(flowNodeId);
                    try {
                        result = node.submitToNext(flowInstance, nodeInstance.getNodeInstanceId(), toNodes, isFreeSubmit);
                        if (!(result instanceof Boolean)) return result;
                        flowInstance.save();
                        return result;
                    }
                    finally {
                        flowInstance.submiting = false;
                        flowInstance.clearCache();
                    }
                }
                flowInstance.submiting = false;
                throw new Exception("\u6d41\u7a0b\u5b9e\u4f8b\u5df2\u63d0\u4ea4\uff01");
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
        }
        finally {
            if (flag) {
                syncMap.remove(flowInstanceId);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object submit(String flowInstanceId, HashMap toNodes, boolean isFreeSubmit) throws Exception {
        Object result = null;
        boolean flag = true;
        if (syncMap.get(flowInstanceId) != null) {
            flag = false;
            throw new Exception("\u6d41\u7a0b\u6b63\u5728\u5904\u7406\u4e2d\uff0c\u8bf7\u7a0d\u540e");
        }
        syncMap.put(flowInstanceId, "");
        try {
            FlowInstance flowInstance = FlowInstance.loadFromDb(flowInstanceId);
            if (flowInstance == null) throw new Exception("\u6d41\u7a0b\u5b9e\u4f8b\u7f16\u7801\u9519\u8bef\uff01");
            if (flowInstance.runStatus == 3) {
                throw new Exception("\u6d41\u7a0b\u5b9e\u4f8b\u5df2\u6302\u8d77\uff0c\u65e0\u6cd5\u63d0\u4ea4\uff01");
            }
            FlowNodeInstance nodeInstance = flowInstance.getLastRunStatusInstance();
            int nodeInstanceId = nodeInstance.getNodeInstanceId();
            if ("7.2".equals(flowInstance.getVersion())) {
                Object object = flowInstance.submit72(nodeInstanceId, toNodes, isFreeSubmit);
                return object;
            }
            try {
                flowInstance.submiting = true;
                Flow flow = flowInstance.getTemplet();
                if (nodeInstance.getRunStatus() == 0) {
                    int flowNodeId = nodeInstance.getFlowNodeId();
                    FlowNode node = flow.getNodeById(flowNodeId);
                    try {
                        result = node.submitToNext(flowInstance, nodeInstance.getNodeInstanceId(), toNodes, isFreeSubmit);
                        if (!(result instanceof Boolean)) return result;
                        flowInstance.save();
                        return result;
                    }
                    finally {
                        flowInstance.submiting = false;
                        flowInstance.clearCache();
                    }
                }
                flowInstance.submiting = false;
                throw new Exception("\u6d41\u7a0b\u5b9e\u4f8b\u5df2\u63d0\u4ea4\uff01");
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
        }
        finally {
            if (flag) {
                syncMap.remove(flowInstanceId);
            }
        }
    }

    public static Object submitByApp(String flowInstanceId, int nodeInstanceId, HashMap toNodes, boolean isFreeSubmit, String appId) throws Exception {
        Object map = FlowInstance.submit(flowInstanceId, nodeInstanceId, toNodes, isFreeSubmit);
        if (map instanceof ArrayList) {
            ArrayList treeNodes = (ArrayList)map;
            int i = 0;
            while (i < treeNodes.size()) {
                TreeNodeBean flowNode = (TreeNodeBean)treeNodes.get(i);
                TreeNodeBean[] userNodes = flowNode.getChilds();
                String userIdInSql = "";
                if (userNodes != null && userNodes.length > 0) {
                    String[] userIds = new String[userNodes.length];
                    HashMap<String, String> replaceMap = new HashMap<String, String>();
                    int j = 0;
                    while (j < userNodes.length) {
                        String nodeId = userNodes[j].getObjectId();
                        String nodeText = userNodes[j].getText();
                        userIds[j] = nodeId;
                        replaceMap.put(nodeId, nodeText);
                        ++j;
                    }
                    userIdInSql = DbOper.toInSql(userIds);
                    Global.getContext().setRequest("h_flowuser", userIdInSql);
                    TreeNodeBean[] rootNodes = Tree.getRootNodeArray(appId, true);
                    FlowInstance.replaceText(rootNodes, replaceMap);
                    int j2 = 0;
                    while (j2 < rootNodes.length) {
                        rootNodes[j2].setParentObjectId(flowNode.getObjectId());
                        rootNodes[j2].setParentId(flowNode.getObjectId());
                        ++j2;
                    }
                    flowNode.setChilds(rootNodes);
                }
                ++i;
            }
            return treeNodes;
        }
        return map;
    }

    private static void replaceText(TreeNodeBean[] rootNodes, Map<String, String> replaceMap) {
        if (replaceMap == null || rootNodes == null || rootNodes.length == 0) {
            return;
        }
        int i = 0;
        int len = rootNodes.length;
        while (i < len) {
            TreeNodeBean[] childs;
            TreeNodeBean node = rootNodes[i];
            if (node != null) {
                String objId = node.getObjectId();
                String objText = node.getText();
                String replaceText = replaceMap.get(objId);
                if (objText != null && replaceText != null && !objText.equals(replaceText)) {
                    node.setText(replaceText);
                }
            }
            if ((childs = node.getChilds()) != null) {
                FlowInstance.replaceText(childs, replaceMap);
            }
            ++i;
        }
    }

    public static Object start(String flowInstanceId, int nodeInstanceId, HashMap toNodes) throws Exception {
        ArrayList treeNodes = new ArrayList();
        FlowInstance flowInstance = FlowInstance.load(flowInstanceId);
        if (flowInstance == null || toNodes == null) {
            throw new Exception("\u6d41\u7a0b\u5b9e\u4f8b\u7f16\u7801\u9519\u8bef\uff01");
        }
        Flow templet = flowInstance.getTemplet();
        for (Map.Entry entry : toNodes.entrySet()) {
            int flowNodeId = Integer.parseInt((String)entry.getKey());
            FlowNode node = templet.getNodeById(flowNodeId);
            if (node == null) {
                throw new Exception("\u8981\u63d0\u4ea4\u7684\u6d41\u7a0b\u8282\u70b9\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u662f\u5426\u6b63\u786e\uff01");
            }
            Object result = node.start(flowInstance, nodeInstanceId, (String[])entry.getValue());
            if (!(result instanceof List)) continue;
            treeNodes.addAll((List)result);
        }
        if (treeNodes.isEmpty()) {
            flowInstance.save();
            return Boolean.TRUE;
        }
        return treeNodes;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void complet() throws Exception {
        this.fire(BEFORE_COMPLETE);
        this.endDate = new Date();
        this.runStatus = 1;
        this.modify();
        for (FlowNodeInstance nodeInstance : this.nodeInstances) {
            nodeInstance.terminate();
        }
        String returString = dao.isAllChildCompl(this.id);
        if (returString.length() != 0) {
            FlowInstance parentFlowInstance = FlowInstance.load(returString.substring(0, returString.indexOf("|")));
            FlowNodeInstance parentFlowNodeInstance = parentFlowInstance.getFlowNodeInstance(Integer.parseInt(returString.substring(returString.indexOf("|") + 1)));
            parentFlowNodeInstance.exec();
            if ("7.2".equals(parentFlowInstance.getVersion())) {
                FlowNode node = parentFlowInstance.getTemplet().getNodeById(parentFlowNodeInstance.getFlowNodeId());
                HashMap tonode = new HashMap();
                List result = node.getNextNodes(parentFlowInstance, Integer.parseInt(returString.substring(returString.indexOf("|") + 1)), tonode, false);
                if (result != null) throw new Exception("\u7a0b\u5e8f\u6682\u4e0d\u652f\u6301\u5b50\u6d41\u7a0b\u8282\u70b9\u540e\u7684\u8282\u70b9\u4e3a\u81ea\u7531\u6d41\u6216\u6307\u6d3e\u53c2\u4e0e\u8005\uff01");
                parentFlowInstance.getTemplet().getNodeById(parentFlowNodeInstance.getFlowNodeId()).submitToNext72(parentFlowInstance, parentFlowNodeInstance.getNodeInstanceId(), tonode, false);
            } else {
                parentFlowInstance.getTemplet().getNodeById(parentFlowNodeInstance.getFlowNodeId()).submitToNext(parentFlowInstance, parentFlowNodeInstance.getNodeInstanceId(), null, false);
            }
            parentFlowInstance.modify();
            parentFlowInstance.save();
        }
        this.fire(AFTER_COMPLETE);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object untread(String flowInstanceId, int nodeInstanceId, HashMap toNodes, String reson) throws Exception {
        Object result = null;
        boolean flag = true;
        if (syncMap.get(flowInstanceId) != null) {
            flag = false;
            throw new Exception("\u6d41\u7a0b\u6b63\u5728\u5904\u7406\u4e2d\uff0c\u8bf7\u7a0d\u540e");
        }
        syncMap.put(flowInstanceId, "");
        try {
            FlowInstance flowInstance = FlowInstance.loadFromDb(flowInstanceId);
            if (flowInstance == null) throw new Exception("\u6d41\u7a0b\u5b9e\u4f8b\u7f16\u7801\u9519\u8bef\uff01");
            if ("7.2".equals(flowInstance.getVersion())) {
                Object object = flowInstance.untread72(nodeInstanceId, toNodes, reson);
                return object;
            }
            try {
                flowInstance.untreading = true;
                Flow flow = flowInstance.getTemplet();
                FlowNodeInstance nodeInstance = flowInstance.getFlowNodeInstance(nodeInstanceId);
                int flowNodeId = nodeInstance.getFlowNodeId();
                FlowNode node = flow.getNodeById(flowNodeId);
                try {
                    result = node.untreadToNext(flowInstance, nodeInstance.getNodeInstanceId(), toNodes, reson == null ? "" : reson);
                    if (!(result instanceof Boolean)) return result;
                    flowInstance.save();
                    return result;
                }
                finally {
                    flowInstance.untreading = false;
                    flowInstance.clearCache();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
        }
        finally {
            if (flag) {
                syncMap.remove(flowInstanceId);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object untread(String flowInstanceId, HashMap toNodes, String reson) throws Exception {
        Object result = null;
        boolean flag = true;
        if (syncMap.get(flowInstanceId) != null) {
            flag = false;
            throw new Exception("\u6d41\u7a0b\u6b63\u5728\u5904\u7406\u4e2d\uff0c\u8bf7\u7a0d\u540e");
        }
        syncMap.put(flowInstanceId, "");
        try {
            FlowInstance flowInstance = FlowInstance.loadFromDb(flowInstanceId);
            if (flowInstance == null) throw new Exception("\u6d41\u7a0b\u5b9e\u4f8b\u7f16\u7801\u9519\u8bef\uff01");
            flowInstance.untreading = true;
            Flow flow = flowInstance.getTemplet();
            FlowNodeInstance nodeInstance = flowInstance.getLastRunStatusInstance();
            int nodeInstanceId = nodeInstance.getNodeInstanceId();
            int flowNodeId = nodeInstance.getFlowNodeId();
            FlowNode node = flow.getNodeById(flowNodeId);
            if ("7.2".equals(flowInstance.getVersion())) {
                Object object = flowInstance.untread72(nodeInstanceId, toNodes, reson);
                return object;
            }
            try {
                try {
                    result = node.untreadToNext(flowInstance, nodeInstanceId, toNodes, reson == null ? "" : reson);
                    if (!(result instanceof Boolean)) return result;
                    flowInstance.save();
                    return result;
                }
                finally {
                    flowInstance.untreading = false;
                    flowInstance.clearCache();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
        }
        finally {
            if (flag) {
                syncMap.remove(flowInstanceId);
            }
        }
    }

    public static Object startForUntread(String flowInstanceId, int nodeInstanceId, HashMap toNodes, String reson) throws Exception {
        ArrayList treeNodes = new ArrayList();
        FlowInstance flowInstance = FlowInstance.load(flowInstanceId);
        if (flowInstance == null || toNodes == null) {
            throw new Exception("\u6d41\u7a0b\u5b9e\u4f8b\u7f16\u7801\u9519\u8bef\uff01");
        }
        Flow templet = flowInstance.getTemplet();
        for (Map.Entry entry : toNodes.entrySet()) {
            int flowNodeId = Integer.parseInt((String)entry.getKey());
            FlowNode node = templet.getNodeById(flowNodeId);
            if (node == null) {
                throw new Exception("\u8981\u9000\u56de\u7684\u6d41\u7a0b\u8282\u70b9\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u662f\u5426\u6b63\u786e\uff01");
            }
            Object[] selectUserIds = (String[])entry.getValue();
            Object result = node.startForUntread(flowInstance, nodeInstanceId, reson, selectUserIds);
            if (!(result instanceof List)) continue;
            treeNodes.addAll((List)result);
        }
        if (treeNodes.isEmpty()) {
            flowInstance.save();
            return Boolean.TRUE;
        }
        return treeNodes;
    }

    /*
     * Unable to fully structure code
     */
    public static boolean callbackFromCurrent(String flowInstanceId, int fromNodeInstanceId) throws Exception {
        block21: {
            flag = true;
            try {
                if (FlowInstance.syncMap.get(flowInstanceId) != null) {
                    flag = false;
                    throw new Exception("\u6d41\u7a0b\u6b63\u5728\u5904\u7406\u4e2d\uff0c\u8bf7\u7a0d\u540e");
                }
                FlowInstance.syncMap.put(flowInstanceId, "");
                user = User.getCurrentUser();
                if (user == null) {
                    throw new Exception("\u60a8\u8fd8\u6ca1\u6709\u767b\u5f55\u6216\u8005\u767b\u5f55\u8d85\u65f6,\u8bf7\u91cd\u65b0\u767b\u5f55\uff01");
                }
                callBackTimes = 0;
                flowInstance = FlowInstance.loadFromDb(flowInstanceId);
                if (flowInstance == null) ** GOTO lbl48
                if (!"7.2".equals(flowInstance.getVersion())) ** GOTO lbl21
                result = flowInstance.callBack72(null);
                if (result instanceof Boolean) {
                    var12_9 = (Boolean)result;
                    return var12_9;
                }
                try {
                    throw new Exception("\u6d41\u7a0b\u64a4\u56de\u5f02\u5e38\uff0c\u65b0\u7248\u672c\u6d41\u7a0b\u4f7f\u7528\u65e7\u7248\u672c\u64a4\u56de\u65f6\uff1a\u9700\u8981\u9009\u62e9\u64a4\u56de\u8282\u70b9\uff01");
lbl21:
                    // 1 sources

                    flowInstance.callbacking = true;
                    fromNodeInstance = flowInstance.getFlowNodeInstance(fromNodeInstanceId);
                    try {
                        preNodeInstanceIds = fromNodeInstance.getPreNodeInstanceIds();
                        i = 0;
                        while (i < preNodeInstanceIds.length) {
                            if (fromNodeInstance.isPreInstance(preNodeInstanceIds[i])) {
                                if (flowInstance.callbackToCurrent(preNodeInstanceIds[i])) {
                                    ++callBackTimes;
                                }
                            }
                            ++i;
                        }
                        if (callBackTimes > 0) {
                            flowInstance.save();
                            break block21;
                        }
                        throw new Exception("\u60a8\u4e0d\u662f\u5f53\u524d\u6d41\u7a0b\u5b9e\u4f8b\u524d\u4e00\u4e2a\u72b6\u6001\u7684\u5904\u7406\u4eba\uff0c\u60a8\u6ca1\u6709\u6743\u9650\u64a4\u56de\uff01");
                    }
                    finally {
                        flowInstance.callbacking = false;
                        flowInstance.clearCache();
                    }
lbl48:
                    // 1 sources

                    throw new Exception("\u6d41\u7a0b\u5b9e\u4f8b\u7f16\u7801\u9519\u8bef\uff01");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw e;
                }
            }
            finally {
                if (flag) {
                    FlowInstance.syncMap.remove(flowInstanceId);
                }
            }
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public static boolean callbackToCurrent(String flowInstanceId, int toNodeInstanceId) throws Exception {
        block15: {
            flag = true;
            try {
                if (FlowInstance.syncMap.get(flowInstanceId) != null) {
                    flag = false;
                    throw new Exception("\u6d41\u7a0b\u6b63\u5728\u5904\u7406\u4e2d\uff0c\u8bf7\u7a0d\u540e");
                }
                FlowInstance.syncMap.put(flowInstanceId, "");
                user = User.getCurrentUser();
                if (user == null) {
                    throw new Exception("\u8bf7\u5148\u767b\u5f55\uff01");
                }
                flowInstance = FlowInstance.loadFromDb(flowInstanceId);
                if (flowInstance == null) ** GOTO lbl34
                if (!"7.2".equals(flowInstance.getVersion())) ** GOTO lbl20
                result = flowInstance.callBack72(null);
                if (result instanceof Boolean) {
                    var8_8 = (Boolean)result;
                    return var8_8;
                }
                try {
                    throw new Exception("\u6d41\u7a0b\u64a4\u56de\u5f02\u5e38\uff0c\u65b0\u7248\u672c\u6d41\u7a0b\u4f7f\u7528\u65e7\u7248\u672c\u64a4\u56de\u65f6\uff1a\u9700\u8981\u9009\u62e9\u64a4\u56de\u8282\u70b9\uff01");
lbl20:
                    // 1 sources

                    flowInstance.callbacking = true;
                    try {
                        flowInstance.callbackToCurrent(toNodeInstanceId);
                        flowInstance.save();
                        break block15;
                    }
                    finally {
                        flowInstance.callbacking = false;
                        flowInstance.clearCache();
                    }
lbl34:
                    // 1 sources

                    throw new Exception("\u6d41\u7a0b\u5b9e\u4f8b\u7f16\u7801\u9519\u8bef\uff01");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw e;
                }
            }
            finally {
                if (flag) {
                    FlowInstance.syncMap.remove(flowInstanceId);
                }
            }
        }
        return true;
    }

    private boolean callbackToCurrent(int toNodeInstanceId) throws Exception {
        block11: {
            if ("7.2".equals(this.getVersion())) {
                Object result = this.callBack72(null);
                if (result instanceof Boolean) {
                    return (Boolean)result;
                }
                throw new Exception("\u6d41\u7a0b\u64a4\u56de\u5f02\u5e38\uff0c\u65b0\u7248\u672c\u6d41\u7a0b\u4f7f\u7528\u65e7\u7248\u672c\u64a4\u56de\u65f6\uff1a\u9700\u8981\u9009\u62e9\u64a4\u56de\u8282\u70b9\uff01");
            }
            int realCallBackTimes = 0;
            ArrayList<FlowNodeInstance> callBackNodeInstances = new ArrayList<FlowNodeInstance>();
            FlowNodeInstance toNodeInstance = this.getFlowNodeInstance(toNodeInstanceId);
            if (toNodeInstance.getOperatorManager().getOperators().containsKey(User.getCurrentUser().getId())) {
                List nodeInstances = this.getRunStatusNodeInstance();
                int i = 0;
                while (i < nodeInstances.size()) {
                    FlowNodeInstance fromNodeInstance = (FlowNodeInstance)nodeInstances.get(i);
                    if (fromNodeInstance.isPreInstance(toNodeInstanceId)) {
                        if (fromNodeInstance.getRunStatus() == 0 && fromNodeInstance.getOperatorManager().getOperatorsNameString().equals("")) {
                            callBackNodeInstances.add(fromNodeInstance);
                            ++realCallBackTimes;
                        } else {
                            throw new Exception("\u6d41\u7a0b\u5df2\u88ab\u5904\u7406\uff0c\u4e0d\u53ef\u64a4\u56de\uff01");
                        }
                    }
                    ++i;
                }
            }
            if (realCallBackTimes > 0) {
                Iterator it = callBackNodeInstances.iterator();
                while (it.hasNext()) {
                    ((FlowNodeInstance)it.next()).terminate();
                }
                toNodeInstance.callback();
                break block11;
            }
            throw new Exception("\u60a8\u4e0d\u662f\u5f53\u524d\u6d41\u7a0b\u5b9e\u4f8b\u524d\u4e00\u4e2a\u72b6\u6001\u7684\u5904\u7406\u4eba\uff0c\u60a8\u6ca1\u6709\u6743\u9650\u64a4\u56de\uff01");
        }
        return true;
    }

    public static boolean canCallback(String flowInstanceId, int fromNodeInstanceId) {
        boolean canCallBack = false;
        try {
            canCallBack = FlowInstance.canCallbackFromCurrent(flowInstanceId, fromNodeInstanceId);
        }
        catch (Exception exp) {
            canCallBack = false;
        }
        if (!canCallBack) {
            try {
                canCallBack = FlowInstance.canCallbackToCurrent(flowInstanceId, fromNodeInstanceId);
            }
            catch (Exception exp) {
                canCallBack = false;
            }
        }
        return canCallBack;
    }

    public static boolean canCallbackFromCurrent(String flowInstanceId, int fromNodeInstanceId) throws Exception {
        boolean canCallBack = false;
        User user = User.getCurrentUser();
        if (user == null) {
            throw new Exception("\u60a8\u8fd8\u6ca1\u6709\u767b\u5f55\u6216\u8005\u767b\u5f55\u8d85\u65f6,\u8bf7\u91cd\u65b0\u767b\u5f55\uff01");
        }
        FlowInstance flowInstance = FlowInstance.loadFromDb(flowInstanceId);
        if (flowInstance != null) {
            if (flowInstance.getRunStatus() == 0) {
                flowInstance.callbacking = true;
                FlowNodeInstance fromNodeInstance = flowInstance.getFlowNodeInstance(fromNodeInstanceId);
                try {
                    int[] preNodeInstanceIds = fromNodeInstance.getPreNodeInstanceIds();
                    int i = 0;
                    while (i < preNodeInstanceIds.length) {
                        block13: {
                            if (fromNodeInstance.isPreInstance(preNodeInstanceIds[i])) {
                                canCallBack = flowInstance.canCallbackToCurrent(preNodeInstanceIds[i]);
                                if (!canCallBack) break block13;
                                break;
                            }
                        }
                        ++i;
                    }
                }
                finally {
                    flowInstance.callbacking = false;
                    flowInstance.clearCache();
                }
            }
        } else {
            throw new Exception("\u6d41\u7a0b\u5b9e\u4f8b\u7f16\u7801\u9519\u8bef\uff01");
        }
        return canCallBack;
    }

    public static boolean canCallbackToCurrent(String flowInstanceId, int toNodeInstanceId) throws Exception {
        boolean canCallBack = false;
        User user = User.getCurrentUser();
        if (user == null) {
            throw new Exception("\u8bf7\u5148\u767b\u5f55\uff01");
        }
        FlowInstance flowInstance = FlowInstance.loadFromDb(flowInstanceId);
        if (flowInstance != null) {
            if (flowInstance.getRunStatus() == 0) {
                flowInstance.callbacking = true;
                canCallBack = flowInstance.canCallbackToCurrent(toNodeInstanceId);
            }
        } else {
            throw new Exception("\u6d41\u7a0b\u5b9e\u4f8b\u7f16\u7801\u9519\u8bef\uff01");
        }
        return canCallBack;
    }

    private boolean canCallbackToCurrent(int toNodeInstanceId) throws Exception {
        boolean canCallBack;
        block5: {
            canCallBack = false;
            FlowNodeInstance toNodeInstance = this.getFlowNodeInstance(toNodeInstanceId);
            if (!toNodeInstance.getOperatorManager().getOperators().containsKey(User.getCurrentUser().getId())) break block5;
            List nodeInstances = this.getRunStatusNodeInstance();
            int i = 0;
            while (i < nodeInstances.size()) {
                FlowNodeInstance fromNodeInstance = (FlowNodeInstance)nodeInstances.get(i);
                if (fromNodeInstance.isPreInstance(toNodeInstanceId)) {
                    if (fromNodeInstance.getRunStatus() == 0 && fromNodeInstance.getOperatorManager().getOperatorsNameString().equals("")) {
                        canCallBack = true;
                        break;
                    }
                    canCallBack = false;
                }
                ++i;
            }
        }
        return canCallBack;
    }

    private static boolean callback(FlowInstance flowInstance, int fromNodeInstanceId, int toNodeInstanceId) throws Exception {
        FlowNodeInstance fromNodeInstance = flowInstance.getFlowNodeInstance(fromNodeInstanceId);
        FlowNodeInstance toNodeInstance = flowInstance.getFlowNodeInstance(toNodeInstanceId);
        User user = User.getCurrentUser();
        if (user == null) {
            throw new Exception("\u60a8\u8fd8\u6ca1\u6709\u767b\u5f55\u6216\u8005\u767b\u5f55\u8d85\u65f6,\u8bf7\u91cd\u65b0\u767b\u5f55\uff01");
        }
        if (toNodeInstance.getOperatorManager().getOperators().containsKey(user.getId()) && fromNodeInstance.isPreInstance(toNodeInstanceId) && fromNodeInstance.getRunStatus() == 0 && fromNodeInstance.getOperatorManager().getOperators().isEmpty()) {
            fromNodeInstance.terminate();
            toNodeInstance.callback();
            flowInstance.save();
            return true;
        }
        return false;
    }

    public String toJson(int nodeInstanceId) {
        StringBuffer script = new StringBuffer(1024);
        if ("7.2".equals(this.version)) {
            script.append("new com.sdjxd.pms.platform.workflow.FlowInstance72({");
            script.append("id:'").append(this.id).append("'");
            script.append(",dataModify:'").append(this.dataModify).append("'");
            script.append(",templet:").append(this.templet.toJson());
            script.append(",currentNodeInstance:").append(this.getFlowNodeInstance(nodeInstanceId).toJson());
            script.append(",version:").append(this.version);
            script.append(",readOnly:").append(this.readOnly);
            script.append(",runStatus:").append(this.runStatus);
            script.append("});");
        } else {
            script.append("new com.sdjxd.pms.platform.workflow.FlowInstance({");
            script.append("id:'").append(this.id).append("'");
            script.append(",dataModify:'").append(this.dataModify).append("'");
            script.append(",templet:").append(this.templet.toJson());
            script.append(",currentNodeInstance:").append(this.getFlowNodeInstance(nodeInstanceId).toJson());
            script.append(",runStatus:").append(this.runStatus);
            script.append("});");
        }
        return script.toString();
    }

    public String toWholeJson(int nodeInstanceId) {
        StringBuffer script = new StringBuffer(1024);
        script.append("window.defaultFlowInstance=").append(this.toJson(nodeInstanceId));
        return script.toString();
    }

    public void exec(FlowNodeInstance nodeInstance) throws Exception {
        if (nodeInstance.checkLimit()) {
            nodeInstance.exec();
        } else {
            log.info((Object)"\u60a8\u6ca1\u6709\u5f53\u524d\u6d41\u7a0b\u8282\u70b9\u4e0b\u7684\u6743\u9650\uff01");
        }
    }

    public void exec(int nodeInstanceId) throws Exception {
        FlowNodeInstance nodeInstance = this.getFlowNodeInstance(nodeInstanceId);
        this.exec(nodeInstance);
    }

    public boolean checkLimit(int nodeInstanceId) throws Exception {
        FlowNodeInstance nodeInstance = this.getFlowNodeInstance(nodeInstanceId);
        if (nodeInstance != null) {
            return nodeInstance.checkLimit();
        }
        return false;
    }

    public TreeMap getFormLimit(int flowFormId, int nodeInstanceId) {
        FlowNodeInstance nodeInstance = this.getFlowNodeInstance(nodeInstanceId);
        if (nodeInstance != null) {
            return nodeInstance.getFormLimit(flowFormId);
        }
        return null;
    }

    public TreeMap getFormWithoutLimit(int flowFormId) {
        FlowNode endNode = this.templet.getEndNode();
        if (endNode != null) {
            return endNode.getVariableLimit(flowFormId);
        }
        return null;
    }

    public static final String[] getEventMethod(String className) throws Exception {
        List list = BeanTool.searchMethod(Class.forName(className), null, new Class[]{FlowInstance.class, Object.class}, 8);
        String[] methodNames = new String[list.size()];
        Iterator it = list.iterator();
        int i = 0;
        while (it.hasNext()) {
            methodNames[i] = ((Method)it.next()).getName();
            ++i;
        }
        return methodNames;
    }

    public void addNodeChildInstance(String nodeChildInstanceId, int nodeId) {
        if (this.nodeChildInstance == null) {
            this.nodeChildInstance = new ArrayList();
        }
        if (nodeChildInstanceId != null && nodeId >= 0) {
            FlowChildInstanceBean model = new FlowChildInstanceBean();
            model.setFlowInstanceId(this.id);
            model.setFlowNodeId(nodeId);
            model.setChildInstanceId(nodeChildInstanceId);
            FlowChildInstance fNodeChildInstance = FlowChildInstance.create(model);
            if (fNodeChildInstance != null) {
                this.nodeChildInstance.add(fNodeChildInstance);
            }
        }
    }

    public static Map getAllRunStatusNodeInstance(String flowInstanceId) throws Exception {
        HashMap<String, TreeNodeBean[]> map = new HashMap<String, TreeNodeBean[]>();
        FlowInstance flowInstance = FlowInstance.load(flowInstanceId);
        ArrayList<TreeNodeBean> nodes = new ArrayList<TreeNodeBean>();
        int i = flowInstance.nodeInstances.size() - 1;
        while (i >= 0) {
            FlowNodeInstance nodeInstance = (FlowNodeInstance)flowInstance.nodeInstances.get(i);
            if (nodeInstance != null && nodeInstance.checkLimit()) {
                TreeNodeBean treeNodeBean = new TreeNodeBean();
                treeNodeBean.setId(String.valueOf(nodeInstance.getNodeInstanceId()));
                treeNodeBean.setText(nodeInstance.getFlowNodeName());
                nodes.add(treeNodeBean);
            }
            --i;
        }
        TreeNodeBean[] treeNode = new TreeNodeBean[nodes.size()];
        int i2 = 0;
        while (i2 < treeNode.length) {
            treeNode[i2] = (TreeNodeBean)nodes.get(i2);
            ++i2;
        }
        map.put("nodes", treeNode);
        return map;
    }

    public List getRunStatusNodeInstance() throws Exception {
        ArrayList<FlowNodeInstance> nodeInstances = new ArrayList<FlowNodeInstance>();
        int i = this.nodeInstances.size() - 1;
        while (i >= 0) {
            FlowNodeInstance nodeInstance = (FlowNodeInstance)this.nodeInstances.get(i);
            if (nodeInstance != null) {
                nodeInstances.add(nodeInstance);
            }
            --i;
        }
        return nodeInstances;
    }

    public String getStatusName(int nodeInstanceId) {
        FlowNodeInstance nodeInstance = this.getFlowNodeInstance(nodeInstanceId);
        if (nodeInstance != null) {
            return nodeInstance.getStatusName();
        }
        return null;
    }

    public String getStatusId(int nodeInstanceId) {
        FlowNodeInstance nodeInstance = this.getFlowNodeInstance(nodeInstanceId);
        if (nodeInstance != null) {
            return nodeInstance.getStatusId();
        }
        return null;
    }

    public boolean isSubmiting() {
        return this.submiting;
    }

    public static void delegate(String flowInstanceId, int nodeInstanceId, HashMap delegateMap, String reason) throws Exception {
        String userid = User.getCurrentUser().getId();
        FlowInstance flowInstance = FlowInstance.load(flowInstanceId);
        if (flowInstance != null) {
            Map[] delegateUsers = (Map[])delegateMap.get("datas");
            HashMap userType = new HashMap(delegateUsers.length);
            int i = 0;
            while (i < delegateUsers.length) {
                String newUserid = (String)delegateUsers[i].get("objectId");
                if (!userid.equals(newUserid)) {
                    userType.put(delegateUsers[i].get("objectId"), Integer.toString(FlowInstance.getUserType((String)delegateUsers[i].get("tableId"))));
                }
                ++i;
            }
            if (userType != null && userType.size() > 0) {
                DbSession session = DbOper.openDb("defaultds");
                try {
                    try {
                        FlowDelegate.create(flowInstanceId, nodeInstanceId, userType, reason);
                        FlowNodeInstance flowNodeInstance = flowInstance.getFlowNodeInstance(nodeInstanceId);
                        flowNodeInstance.delegate(userType);
                        if (User.getCurrentUser() != null) {
                            flowNodeInstance.addNotes(User.getCurrentUser().getName());
                        }
                        flowNodeInstance.addNotes("\u8bbe\u7f6e\u4ee3\u529e\uff1a");
                        flowNodeInstance.addNotes(reason);
                        flowNodeInstance.addNotes("  ");
                        flowInstance.save();
                        DbOper.commitDb(session);
                    }
                    catch (Exception exp) {
                        DbOper.rollbackDb(session);
                        throw exp;
                    }
                }
                finally {
                    DbOper.closeDb(session);
                }
            }
        }
    }

    public static int getUserType(String tableId) {
        if ("1D70D743-1A92-4104-AA5D-1B1F1EA3641F".equals(tableId)) {
            return 0;
        }
        if ("A5179E9A-7319-47DA-BC68-6A1CEB35B320".equals(tableId)) {
            return 0;
        }
        if ("50E54B1B-6511-4CC4-8E82-BA10A6F2BC37".equals(tableId)) {
            return 1;
        }
        if ("F3D67A4E-A1D5-4EC5-9E15-103F8B1D80E8".equals(tableId)) {
            return 2;
        }
        return -1;
    }

    public static String getOperatorsNameString(String flowInstanceId, int nodeInstanceId) throws Exception {
        FlowOperatorManager manager;
        FlowInstance flowInstance = FlowInstance.load(flowInstanceId);
        FlowNodeInstance nodeInstance = flowInstance.getFlowNodeInstance(nodeInstanceId);
        if (nodeInstance != null && (manager = nodeInstance.getOperatorManager()) != null) {
            return manager.getOperatorsNameString();
        }
        return "";
    }

    public static String getOperatorEndNameString(String flowInstanceId, int nodeInstanceId) throws Exception {
        FlowOperatorManager manager;
        FlowInstance flowInstance = FlowInstance.load(flowInstanceId);
        FlowNodeInstance nodeInstance = flowInstance.getFlowNodeInstance(nodeInstanceId);
        if (nodeInstance != null && (manager = nodeInstance.getOperatorManager()) != null) {
            return manager.getOperatorEndNameString();
        }
        return "";
    }

    public List getInterFaceInstances(int nodeInstanceId) {
        ArrayList list = (ArrayList)this.interFaceInstances.get(String.valueOf(nodeInstanceId));
        if (list == null) {
            list = new ArrayList();
            this.interFaceInstances.put(String.valueOf(nodeInstanceId), list);
        }
        return list;
    }

    public static boolean counterSign(String counterSignId, String counterSignUser, String counterSignContent) throws Exception {
        boolean isSuccess = false;
        CounterSign counterSign = CounterSign.submitCounterSign(counterSignId, counterSignUser, new Date(), counterSignContent);
        counterSign.save();
        isSuccess = true;
        return isSuccess;
    }

    public static boolean checkCounterSign(String counterSignId) throws Exception {
        boolean isSuccess = false;
        isSuccess = CounterSign.check(counterSignId, User.getCurrentUser().getId());
        return isSuccess;
    }

    public static Map getUntreadReason(String flowInstanceId, String nodeInstanceId) {
        return dao.getUntreadReason(flowInstanceId, nodeInstanceId);
    }

    public List getUntreadReason() {
        return dao.getUntreadReason(this.getId());
    }

    public List getCallback() {
        ArrayList list = new ArrayList();
        String flowInstanceId = this.getId();
        int i = this.nodeInstances.size() - 1;
        while (i >= 0) {
            int callbackTimes;
            FlowNodeInstance nodeInstance = (FlowNodeInstance)this.nodeInstances.get(i);
            if (nodeInstance != null && (callbackTimes = nodeInstance.getNotes().split("\u64a4\u56de").length) > 1) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("FLOWINSTANCEID", flowInstanceId);
                map.put("NODEINSTANCEID", String.valueOf(nodeInstance.getNodeInstanceId()));
                map.put("FLOWNODEID", String.valueOf(nodeInstance.getFlowNodeId()));
                map.put("TIMES", String.valueOf(callbackTimes));
                list.add(map);
            }
            --i;
        }
        return list;
    }

    public int getCallbackTimes(int flowNodeId) {
        List list = this.getCallback();
        int callbackTimes = 0;
        int i = 0;
        while (i < list.size()) {
            HashMap map = (HashMap)list.get(i);
            if (Integer.parseInt(map.get("FLOWNODEID").toString()) == flowNodeId) {
                callbackTimes += Integer.parseInt(map.get("TIMES").toString());
            }
            ++i;
        }
        return callbackTimes;
    }

    public String getFormInstanceIdByKeyWord(String keyWord) {
        String key;
        FlowFormInstance flowFormInstance;
        String formInstanceId = "";
        formInstanceId = !FlowInstance.formInstanceIdIsKey(keyWord) ? "" : ((flowFormInstance = this.getForm(Integer.parseInt(key = StringTool.match(keyWord, "flow\\.form\\.(\\d)\\.id")))) != null ? flowFormInstance.getInstanceId() : "");
        return formInstanceId;
    }

    public static boolean formInstanceIdIsKey(String keyWord) {
        String key;
        boolean isKey = false;
        isKey = StringTool.isEmpty(keyWord) ? false : !StringTool.isEmpty(key = StringTool.match(keyWord, "flow\\.form\\.(\\d)\\.id"));
        return isKey;
    }

    public static boolean r_forcereplevy2Node(String flowInstanceId, int flowNodeId) throws Exception {
        FlowNodeInstance nodeInstance;
        boolean success = false;
        FlowInstance flowInstance = FlowInstance.loadFromDb(flowInstanceId);
        if (flowInstance != null && (nodeInstance = flowInstance.getLastNodeInstance(flowNodeId)) != null) {
            return FlowInstance.r_forcereplevy2NodeInstance(flowInstance, nodeInstance.getNodeInstanceId());
        }
        return success;
    }

    private static boolean r_forcereplevy2NodeInstance(FlowInstance flowInstance, int nodeInstanceId) throws Exception {
        boolean success = false;
        if (flowInstance != null) {
            flowInstance.callbacking = true;
            FlowNodeInstance flowNodeInstance = flowInstance.getFlowNodeInstance(nodeInstanceId);
            List flowNodeInstances = flowInstance.getRunStatusNodeInstanceNew();
            int i = 0;
            while (i < flowNodeInstances.size()) {
                FlowNodeInstance runNodeInstance = (FlowNodeInstance)flowNodeInstances.get(i);
                runNodeInstance.terminate();
                ++i;
            }
            flowNodeInstance.callback();
            flowInstance.save();
            flowInstance.callbacking = false;
        }
        return success;
    }

    public List getRunStatusNodeInstanceNew() throws Exception {
        ArrayList<FlowNodeInstance> nodeInstances = new ArrayList<FlowNodeInstance>();
        int i = this.nodeInstances.size() - 1;
        while (i >= 0) {
            FlowNodeInstance nodeInstance = (FlowNodeInstance)this.nodeInstances.get(i);
            if (nodeInstance != null && nodeInstance.getRunStatus() == 0) {
                nodeInstances.add(nodeInstance);
            }
            --i;
        }
        return nodeInstances;
    }

    public boolean isCallbacking() {
        return this.callbacking;
    }

    public boolean isUntreading() {
        return this.untreading;
    }

    public static void autoSubmit(String flowInstanceId, int toFlowNodeId, String[] receivers) throws Exception {
        FlowInstance flowInstance = FlowInstance.load(flowInstanceId);
        FlowNodeInstance nodeInstance = flowInstance.getLastRunStatusInstance();
        int nodeInstanceId = nodeInstance.getNodeInstanceId();
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        map.put(String.valueOf(toFlowNodeId), receivers);
        FlowInstance.submit(flowInstanceId, nodeInstanceId, map, false);
    }

    public static boolean submitNoLimit(String flowInstanceId) throws Exception {
        FlowInstance flowInstance = FlowInstance.load(flowInstanceId);
        FlowNodeInstance nodeInstance = flowInstance.getLastNodeInstance();
        if (nodeInstance != null) {
            int nodeInstanceId = nodeInstance.getNodeInstanceId();
            HashMap<String, Map[]> delegateMap = new HashMap<String, Map[]>();
            HashMap<String, String> user = new HashMap<String, String>();
            User currentUser = User.getCurrentUser();
            user.put("objectId", currentUser.getId());
            user.put("text", currentUser.getName());
            user.put("tableId", "1D70D743-1A92-4104-AA5D-1B1F1EA3641F");
            delegateMap.put("datas", new Map[]{user});
            FlowInstance.delegate(flowInstanceId, nodeInstanceId, delegateMap, "\u7279\u6b8a\u4ee3\u529e");
            Flow flow = flowInstance.getTemplet();
            FlowNode flowNode = flow.getNodeById(nodeInstance.getFlowNodeId());
            HashMap nodes = new HashMap();
            flowNode.getNextNodesNoUser(flowInstance, nodeInstanceId, nodes, false);
            HashMap toNodes = new HashMap();
            for (Map.Entry entry : nodes.entrySet()) {
                toNodes.put(entry.getKey(), new String[]{currentUser.getId()});
            }
            FlowInstance.submit(flowInstanceId, nodeInstanceId, toNodes, false);
        }
        return true;
    }

    @Override
    public IFlowInstance loadFromDb72(String flowInstanceId) throws Exception {
        return FlowInstance.loadFromDb(flowInstanceId);
    }

    @Override
    public boolean save72(String flowInstanceId, int flowFormId, Map formVariable) throws Exception {
        return FlowInstance.save(flowInstanceId, flowFormId, formVariable);
    }

    @Override
    public Object submit72(int nodeInstanceId, HashMap toNodes, boolean isFreeSubmit) throws Exception {
        Object result = null;
        try {
            if (this.runStatus == 3) {
                throw new Exception("\u6d41\u7a0b\u5df2\u6302\u8d77\uff0c\u65e0\u6cd5\u63d0\u4ea4");
            }
            if (!this.canOpen()) {
                throw new Exception("\u6d41\u7a0b\u5df2\u88ab\u3010" + this.opener.getName() + "\u3011\u6253\u5f00\uff0c\u65e0\u6cd5\u6267\u884c\u5f53\u524d\u64cd\u4f5c\uff01");
            }
            this.submiting = true;
            FlowNodeInstance nodeInstance = this.getFlowNodeInstance(nodeInstanceId);
            if (nodeInstance.getRunStatus() != 0) {
                throw new Exception("\u6d41\u7a0b\u5b9e\u4f8b\u5df2\u63d0\u4ea4\uff01");
            }
            Flow flow = this.getTemplet();
            FlowNode node = flow.getNodeById(nodeInstance.getFlowNodeId());
            FlowOperatorManager operatorManager = nodeInstance.getOperatorManager();
            User user = User.getCurrentUser();
            if (user == null) {
                throw new Exception("\u65e0\u6cd5\u83b7\u53d6\u5f53\u524d\u767b\u5f55\u7528\u6237\uff01");
            }
            boolean hasPermission = operatorManager.hasSubmitPermission(user.getId());
            if (!hasPermission) {
                throw new Exception("\u5f53\u524d\u7528\u6237\u6ca1\u6709\u64cd\u4f5c\u6743\u9650\uff01");
            }
            this.fire(BEFORE_SUBMIT);
            HashMap nodes = new HashMap();
            if (toNodes != null) {
                log.info((Object)"\u6d41\u7a0b\u63d0\u4ea4\uff1a\u5df2\u6307\u5b9a\u63d0\u4ea4\u4eba");
                result = node.submitToNext72(this, nodeInstanceId, toNodes, isFreeSubmit);
            } else {
                log.info((Object)"\u6d41\u7a0b\u63d0\u4ea4\uff1a\u672a\u6307\u5b9a\u63d0\u4ea4\u4eba");
                result = node.getNextNodes(this, nodeInstanceId, nodes, isFreeSubmit);
                if (result == null) {
                    log.info((Object)"\u6d41\u7a0b\u63d0\u4ea4\uff1a\u65e0\u9700\u9009\u62e9\u8282\u70b9");
                    result = node.submitToNext72(this, nodeInstanceId, nodes, isFreeSubmit);
                } else {
                    log.info((Object)"\u6d41\u7a0b\u63d0\u4ea4\uff1a\u9700\u9009\u62e9\u8282\u70b9");
                }
            }
            if (result instanceof Boolean) {
                result = this.autoDealFlow(nodeInstance, isFreeSubmit, result);
                this.save();
            }
            this.submiting = false;
        }
        finally {
            this.clearCache();
            User.setCurrentUser(null);
        }
        return result;
    }

    protected Object autoDealFlow(FlowNodeInstance nodeInstance, boolean isFreeSubmit, Object result) throws Exception {
        List<Integer> nodeInstanceIds = nodeInstance.getNextNodeInstanceIds72();
        if (nodeInstanceIds != null && nodeInstanceIds.size() > 0) {
            for (int instanceId : nodeInstanceIds) {
                FlowOperatorManager operatorManager;
                Map operators;
                List nextResult;
                HashMap nodes;
                FlowNodeInstance nextNodeInstance = this.getFlowNodeInstance(instanceId);
                if (nextNodeInstance.getRunStatus() != 0) continue;
                Flow flow = this.getTemplet();
                FlowNode nextNode = flow.getNodeById(nextNodeInstance.getFlowNodeId());
                if (nextNode.isNoReciverDeal() && nextNodeInstance.isNoReciver()) {
                    nodes = new HashMap();
                    nextResult = nextNode.getNextNodes(this, nextNodeInstance.getNodeInstanceId(), nodes, isFreeSubmit);
                    if (nextResult != null) continue;
                    User user = User.getCurrentUser();
                    nextNodeInstance.addReceiver72(user, 0);
                    result = nextNode.submitToNext72(this, nextNodeInstance.getNodeInstanceId(), nodes, isFreeSubmit);
                    nextNodeInstance.setIsAutoDeal("1");
                    result = this.autoDealFlow(nextNodeInstance, isFreeSubmit, result);
                    continue;
                }
                if (nextNode.getAutoDeal() != 1) continue;
                nodes = new HashMap();
                nextResult = nextNode.getNextNodes(this, nextNodeInstance.getNodeInstanceId(), nodes, isFreeSubmit);
                if (nextResult != null || (operators = (operatorManager = nextNodeInstance.getOperatorManager()).getReceivers()) == null) continue;
                String userId = User.getCurrentUser().getId();
                boolean hasPermission = operatorManager.hasSubmitPermission(userId);
                if (hasPermission) {
                    result = nextNode.submitToNext72(this, nextNodeInstance.getNodeInstanceId(), nodes, isFreeSubmit);
                    nextNodeInstance.setIsAutoDeal("1");
                    result = this.autoDealFlow(nextNodeInstance, isFreeSubmit, result);
                    continue;
                }
                String hasPermitUserId = this.checkPermit(nextNodeInstance, operatorManager, 0);
                if (HussarString.isEmpty((String)hasPermitUserId)) continue;
                result = nextNode.submitToNext72(this, nextNodeInstance.getNodeInstanceId(), nodes, isFreeSubmit);
                User.setCurrentUser(null);
                nextNodeInstance.setIsAutoDeal("1");
                result = this.autoDealFlow(nextNodeInstance, isFreeSubmit, result);
            }
        }
        return result;
    }

    protected String checkPermit(FlowNodeInstance nodeInstance, FlowOperatorManager operatorManager, int type) throws Exception {
        String dealUserId = "";
        List<Integer> nodeInstanceIds = new ArrayList<Integer>();
        if (type == 0) {
            nodeInstanceIds = this.getAllPreInstanceIds(nodeInstance, nodeInstanceIds);
        } else if (type == 1) {
            nodeInstanceIds = this.getAllNexInstanceIds(nodeInstance, nodeInstanceIds);
        }
        if (nodeInstanceIds != null && nodeInstanceIds.size() > 0) {
            for (int nodeInstanceId : nodeInstanceIds) {
                FlowNodeInstance preNodeInstance = this.getFlowNodeInstance(nodeInstanceId);
                HashMap<String, FlowOperator> operatorMap = preNodeInstance.getOperatorManager().getOperators();
                for (Map.Entry<String, FlowOperator> entry : operatorMap.entrySet()) {
                    FlowOperator operator = entry.getValue();
                    String userId = operator.getOperatorId();
                    User.setCurrentUser(userId);
                    Boolean hasPermit = operatorManager.hasSubmitPermission(userId);
                    if (hasPermit.booleanValue()) {
                        return userId;
                    }
                    User.setCurrentUser(null);
                }
            }
        }
        return dealUserId;
    }

    protected List<Integer> getAllPreInstanceIds(FlowNodeInstance nodeInstance, List<Integer> instanceIdsList) {
        int[] nodeInstanceIds = nodeInstance.getPreNodeInstanceIds72();
        if (nodeInstanceIds != null && nodeInstanceIds.length > 0) {
            instanceIdsList = this.union(instanceIdsList, nodeInstanceIds);
            int[] nArray = nodeInstanceIds;
            int n = nodeInstanceIds.length;
            int n2 = 0;
            while (n2 < n) {
                int nodeInstanceId = nArray[n2];
                FlowNodeInstance preNodeInstance = this.getFlowNodeInstance(nodeInstanceId);
                instanceIdsList = this.getAllPreInstanceIds(preNodeInstance, instanceIdsList);
                ++n2;
            }
        }
        return instanceIdsList;
    }

    protected List<Integer> getAllNexInstanceIds(FlowNodeInstance nodeInstance, List<Integer> instanceIdsList) {
        int[] nodeInstanceIds = nodeInstance.getPreNodeInstanceIds();
        ArrayList<Integer> unreadNodeInstanceIds = new ArrayList<Integer>();
        if (nodeInstanceIds != null && nodeInstanceIds.length > 0) {
            int[] nArray = nodeInstanceIds;
            int n = nodeInstanceIds.length;
            int n2 = 0;
            while (n2 < n) {
                int nodeInstanceId = nArray[n2];
                FlowNodeInstance preNodeInstance = this.getFlowNodeInstance(nodeInstanceId);
                if (preNodeInstance.getRunStatusNoteStop() != 6) {
                    unreadNodeInstanceIds.add(nodeInstanceId);
                    instanceIdsList = this.getAllNexInstanceIds(preNodeInstance, unreadNodeInstanceIds);
                }
                ++n2;
            }
            instanceIdsList = this.unionList(instanceIdsList, unreadNodeInstanceIds);
        }
        return instanceIdsList;
    }

    private List<Integer> union(List<Integer> list, int[] array) {
        HashSet<Integer> set = new HashSet<Integer>();
        for (int i : list) {
            set.add(i);
        }
        int[] nArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            int i;
            i = nArray[n2];
            set.add(i);
            ++n2;
        }
        return new ArrayList<Integer>(set);
    }

    private List<Integer> unionList(List<Integer> list, List<Integer> array) {
        HashSet<Integer> set = new HashSet<Integer>();
        for (int i : list) {
            set.add(i);
        }
        for (int i : array) {
            set.add(i);
        }
        return new ArrayList<Integer>(set);
    }

    protected boolean checkEnd(List<String> runingNodeIds) throws Exception {
        if (this.runStatus != 0) {
            log.info((Object)"\u6d41\u7a0b\u672a\u5904\u4e8e\u8fd0\u884c\u72b6\u6001\uff0c\u65e0\u6cd5\u5224\u65ad\u6d41\u7a0b\u53ef\u5426\u7ed3\u675f\uff01");
            return false;
        }
        if (runingNodeIds.size() == 0) {
            log.info((Object)"\u6d41\u7a0b\u4e2d\u6ca1\u6709\u6d3b\u52a8\u7684\u8282\u70b9\uff0c\u65e0\u6cd5\u7ed3\u675f\uff01");
            return false;
        }
        for (String nodeId : runingNodeIds) {
            int flowNodeId = Integer.parseInt(nodeId);
            FlowNode node = this.templet.getNodeById(flowNodeId);
            if (node.getFreeType() == 0) continue;
            return true;
        }
        FlowNode endNode = this.templet.getEndNode();
        ArrayList<String> path = new ArrayList<String>();
        return endNode.checkCanStartWithPath(this, runingNodeIds, path);
    }

    @Override
    public Object untread72(int nodeInstanceId, HashMap toNodes, String reson) throws Exception {
        Object result = null;
        boolean isAuto = true;
        try {
            if (this.runStatus == 3) {
                throw new Exception("\u6d41\u7a0b\u5df2\u6302\u8d77\uff0c\u65e0\u6cd5\u9000\u56de");
            }
            if (!this.canOpen()) {
                throw new Exception("\u6d41\u7a0b\u5df2\u88ab\u3010" + this.opener.getName() + "\u3011\u6253\u5f00\uff0c\u65e0\u6cd5\u6267\u884c\u5f53\u524d\u64cd\u4f5c\uff01");
            }
            FlowNodeInstance nodeInstance = this.getFlowNodeInstance(nodeInstanceId);
            if (nodeInstance.getRunStatus() != 0) {
                throw new Exception("\u5f53\u524d\u6d41\u7a0b\u8282\u70b9\u672a\u5904\u4e8e\u8fd0\u884c\u72b6\u6001\uff0c\u6d41\u7a0b\u65e0\u6cd5\u9000\u56de\uff01");
            }
            this.untreading = true;
            FlowOperatorManager operatorManager = nodeInstance.getOperatorManager();
            User user = User.getCurrentUser();
            if (user == null) {
                throw new Exception("\u65e0\u6cd5\u83b7\u53d6\u5f53\u524d\u767b\u5f55\u7528\u6237\uff01");
            }
            boolean hasPermission = operatorManager.hasSubmitPermission(user.getId());
            if (!hasPermission) {
                throw new Exception("\u5f53\u524d\u7528\u6237\u6ca1\u6709\u64cd\u4f5c\u6743\u9650\uff01");
            }
            Flow flow = this.getTemplet();
            FlowNode node = flow.getNodeById(nodeInstance.getFlowNodeId());
            HashMap nodes = new HashMap();
            if (toNodes != null) {
                isAuto = false;
                result = node.untreadToNext72(this, nodeInstance, toNodes, reson);
            } else {
                result = node.getUntreadNodes72(this, nodeInstance, nodes);
                if (result == null) {
                    result = node.untreadToNext72(this, nodeInstance, nodes, reson);
                }
            }
            if (result instanceof Boolean && ((Boolean)result).booleanValue()) {
                if (nodes != null && nodes.size() == 0) {
                    nodes = toNodes;
                }
                this.autoUntreadFlowNew(nodes);
                this.save();
            }
            this.untreading = false;
        }
        finally {
            this.clearCache();
            User.setCurrentUser(null);
        }
        return result;
    }

    protected Object autoUntreadFlow(Object result, Map<String, FlowNodeInstance> nodes) throws Exception {
        if (nodes != null && nodes.size() == 1) {
            for (Map.Entry<String, FlowNodeInstance> entry : nodes.entrySet()) {
                FlowOperatorManager operatorManager;
                Map operators;
                HashMap<String, FlowNodeInstance> nextNodes;
                List nextResult;
                Flow flow;
                FlowNode nextNode;
                FlowNodeInstance nodeInstance = entry.getValue();
                int nodeInstanceId = nodeInstance.getvNextNodeInstanceId();
                FlowNodeInstance nextNodeInstance = this.getFlowNodeInstance(nodeInstanceId);
                if (nextNodeInstance.getRunStatus() != 0 || (nextNode = (flow = this.getTemplet()).getNodeById(nextNodeInstance.getFlowNodeId())).getAutoDeal() != 1 && !nextNode.isNoReciverDeal() || (nextResult = nextNode.getUntreadNodes72(this, nextNodeInstance, nextNodes = new HashMap<String, FlowNodeInstance>())) != null || (operators = (operatorManager = nextNodeInstance.getOperatorManager()).getReceivers()) == null || operators.size() != 1) continue;
                String userId = User.getCurrentUser().getId();
                boolean hasPermission = operatorManager.hasSubmitPermission(userId);
                if (hasPermission) {
                    result = nextNode.untreadToNext72(this, nextNodeInstance, nextNodes, "");
                    result = this.autoUntreadFlow(result, nextNodes);
                    continue;
                }
                String hasPermitUserId = this.checkPermit(nextNodeInstance, operatorManager, 1);
                if (HussarString.isEmpty((String)hasPermitUserId)) continue;
                result = nextNode.untreadToNext72(this, nextNodeInstance, nextNodes, "");
                User.setCurrentUser(null);
                result = this.autoUntreadFlow(result, nextNodes);
            }
        }
        return result;
    }

    private void autoUntreadFlowNew(Map<String, FlowNodeInstance> preNodeMap) throws Exception {
        if (preNodeMap != null && preNodeMap.size() > 0) {
            for (Map.Entry<String, FlowNodeInstance> entry : preNodeMap.entrySet()) {
                Iterator<Map.Entry<String, FlowOperator>> it;
                String nodeId_nodeInstanceId = entry.getKey();
                FlowNodeInstance obj = entry.getValue();
                FlowNodeInstance nodeIns = null;
                FlowNodeInstance vNodeInstance = null;
                if (obj instanceof FlowNodeInstance) {
                    nodeIns = obj;
                } else {
                    String[] idArr = nodeId_nodeInstanceId.split(",");
                    if (idArr.length == 2) {
                        nodeIns = this.getFlowNodeInstance(Integer.valueOf(idArr[1]));
                    }
                }
                if (nodeIns == null) continue;
                boolean isAuto = nodeIns.getIsAutoDeal();
                int[] preIds = nodeIns.getPreNodeInstanceIds72();
                if (!isAuto || preIds.length != 1) continue;
                Flow flow = this.getTemplet();
                FlowNode node = flow.getNodeById(nodeIns.getFlowNodeId());
                int vNodeId = nodeIns.getvNextNodeInstanceId();
                vNodeInstance = this.getFlowNodeInstance(vNodeId);
                HashMap<String, FlowOperator> operatorMap = nodeIns.getOperatorManager().getOperators();
                if (operatorMap.size() != 1 || !(it = operatorMap.entrySet().iterator()).hasNext()) continue;
                Map.Entry<String, FlowOperator> entry1 = it.next();
                FlowOperator operator = entry1.getValue();
                String userId = operator.getOperatorId();
                User user = User.getUser(userId);
                FlowOperator o = vNodeInstance.getOperatorManager().addOperator(user);
                User.setCurrentUser(userId);
                HashMap<String, FlowNodeInstance> toNodeMap = new HashMap<String, FlowNodeInstance>();
                try {
                    try {
                        Object unTreadResult;
                        List toNodeResult = node.getUntreadNodes72ByAuto(this, vNodeInstance, toNodeMap);
                        if (toNodeResult != null || !((unTreadResult = node.untreadToNext72(this, vNodeInstance, toNodeMap, "")) instanceof Boolean) || !((Boolean)unTreadResult).booleanValue()) continue;
                        this.autoUntreadFlowNew(toNodeMap);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        throw e;
                    }
                }
                finally {
                    User.setCurrentUser(null);
                }
            }
        }
    }

    public boolean isPreNodeIns(int preNodeInstance, int nextNodeInstance) {
        int[] nodeInsIds;
        boolean result = false;
        FlowNodeInstance tempNodeIns = this.getFlowNodeInstance(nextNodeInstance);
        int[] nArray = nodeInsIds = tempNodeIns.getPreNodeInstanceIds72();
        int n = nodeInsIds.length;
        int n2 = 0;
        while (n2 < n) {
            int nodeInsId = nArray[n2];
            if (preNodeInstance == nodeInsId) {
                return true;
            }
            result = result || this.isPreNodeIns(preNodeInstance, nodeInsId);
            ++n2;
        }
        return result;
    }

    @Override
    public Object callBack72(Map toNodeMap) throws Exception {
        Object result = null;
        this.callbacking = true;
        try {
            if (this.runStatus == 3) {
                throw new Exception("\u6d41\u7a0b\u5df2\u6302\u8d77\uff0c\u65e0\u6cd5\u64a4\u56de");
            }
            if (this.runStatus != 0) {
                throw new Exception("\u6d41\u7a0b\u5b9e\u4f8b\u5df2\u63d0\u4ea4\uff01");
            }
            if (!this.canOpen()) {
                throw new Exception("\u6d41\u7a0b\u5df2\u88ab\u3010" + this.opener.getName() + "\u3011\u6253\u5f00\uff0c\u65e0\u6cd5\u6267\u884c\u5f53\u524d\u64cd\u4f5c\uff01");
            }
            if (toNodeMap != null) {
                result = this.callBackToNext72(toNodeMap);
            } else {
                toNodeMap = new HashMap();
                result = this.getCallBackNodes(toNodeMap);
                if (result == null) {
                    result = this.callBackToNext72(toNodeMap);
                }
            }
            if (result instanceof Boolean && ((Boolean)result).booleanValue()) {
                this.autoCallBackFlow(toNodeMap);
                this.save();
            }
            this.callbacking = false;
        }
        finally {
            this.clearCache();
        }
        return result;
    }

    private void autoCallBackFlow(Map preNodeMap) throws Exception {
        if (preNodeMap != null && preNodeMap.size() > 0) {
            for (Map.Entry entry : preNodeMap.entrySet()) {
                boolean callBackResult;
                String nodeId_nodeInstanceId = (String)entry.getKey();
                Object obj = entry.getValue();
                FlowNodeInstance nodeIns = null;
                if (obj instanceof FlowNodeInstance) {
                    nodeIns = (FlowNodeInstance)obj;
                } else {
                    String[] idArr = nodeId_nodeInstanceId.split(",");
                    if (idArr.length == 2) {
                        nodeIns = this.getFlowNodeInstance(Integer.valueOf(idArr[1]));
                    }
                }
                if (nodeIns == null) continue;
                boolean isAuto = nodeIns.getIsAutoDeal();
                int[] preIds = nodeIns.getPreNodeInstanceIds72();
                if (!isAuto || preIds.length != 1) continue;
                int vNodeId = nodeIns.getvNextNodeInstanceId();
                Map toNodeMap = new HashMap();
                if ((toNodeMap = this.getCallBackNodesByFlowNodeId(toNodeMap, vNodeId)).size() != 1 || !(callBackResult = this.callBackToNext72(toNodeMap))) continue;
                this.autoCallBackFlow(toNodeMap);
            }
        }
    }

    private Map getCallBackNodesByFlowNodeId(Map toNodeMap, int flowNodeId) throws Exception {
        User user = User.getCurrentUser();
        if (user == null) {
            throw new Exception("\u65e0\u6cd5\u83b7\u53d6\u5f53\u524d\u7528\u6237\uff01");
        }
        ArrayList<FlowNodeInstance> list = new ArrayList<FlowNodeInstance>();
        int i = 0;
        while (i < this.nodeInstances.size()) {
            FlowNodeInstance nodeInstance = (FlowNodeInstance)this.nodeInstances.get(i);
            if ("".equals(nodeInstance.getOperatorManager().getOperatorsNameString()) && (nodeInstance.getRunStatus() == 0 || nodeInstance.getRunStatus() == 5) && nodeInstance.getRunStatusNoteStart() != 3) {
                list.add(nodeInstance);
            }
            ++i;
        }
        if (list.size() == 0) {
            throw new Exception("\u5f53\u524d\u6d41\u7a0b\u6ca1\u6709\u672a\u5904\u7406\u7684\u6d3b\u52a8\u8282\u70b9\uff0c\u4e0d\u80fd\u6267\u884c\u64a4\u56de\u64cd\u4f5c\uff01");
        }
        FlowNodeInstance currentRunNode = this.getFlowNodeInstance(flowNodeId);
        int[] ids = currentRunNode.getPreNodeInstanceIds72();
        if (ids.length == 1) {
            FlowNodeInstance toNodeInstance;
            FlowNodeInstance preNodeIns = toNodeInstance = this.getFlowNodeInstance(ids[0]);
            while (preNodeIns.getIsAutoDeal()) {
                int[] preNodeIds = preNodeIns.getPreNodeInstanceIds72();
                if (preNodeIds.length == 1) {
                    preNodeIns = this.getFlowNodeInstance(preNodeIds[0]);
                    continue;
                }
                preNodeIns = null;
                break;
            }
            if (preNodeIns != null) {
                List<Integer> nextIds = preNodeIns.getNextNodeInstanceIds72();
                boolean canCallBack = true;
                for (int nextId : nextIds) {
                    FlowNodeInstance nextNodeInstance = this.getFlowNodeInstance(nextId);
                    while (nextNodeInstance.getIsAutoDeal()) {
                        List<Integer> nextNodeIds = nextNodeInstance.getNextNodeInstanceIds72();
                        if (nextNodeIds.size() == 1) {
                            nextNodeInstance = this.getFlowNodeInstance(nextNodeIds.get(0));
                            continue;
                        }
                        nextNodeInstance = null;
                        break;
                    }
                    if (list.contains(nextNodeInstance) && nextNodeInstance != null) continue;
                    canCallBack = false;
                    break;
                }
                if (canCallBack && preNodeIns.getOperatorManager().getOperators().containsKey(user.getId())) {
                    String key = String.valueOf(toNodeInstance.getNodeInstanceId());
                    toNodeMap.put(key, toNodeInstance);
                }
            }
        }
        if (toNodeMap.size() == 0) {
            throw new Exception("\u6ca1\u6709\u6ee1\u8db3\u6761\u4ef6\u7684\u8282\u70b9\u53ef\u4ee5\u64a4\u56de\uff01");
        }
        return toNodeMap;
    }

    /*
     * WARNING - void declaration
     */
    protected List getCallBackNodes(Map toNodeMap) throws Exception {
        void var4_5;
        User user = User.getCurrentUser();
        if (user == null) {
            throw new Exception("\u65e0\u6cd5\u83b7\u53d6\u5f53\u524d\u7528\u6237\uff01");
        }
        ArrayList<Object> list = new ArrayList<Object>();
        boolean bl = false;
        while (var4_5 < this.nodeInstances.size()) {
            FlowNodeInstance nodeInstance = (FlowNodeInstance)this.nodeInstances.get((int)var4_5);
            if ("".equals(nodeInstance.getOperatorManager().getOperatorsNameString()) && (nodeInstance.getRunStatus() == 0 || nodeInstance.getRunStatus() == 5) && nodeInstance.getRunStatusNoteStart() != 3) {
                list.add(nodeInstance);
            }
            ++var4_5;
        }
        if (list.size() == 0) {
            throw new Exception("\u5f53\u524d\u6d41\u7a0b\u6ca1\u6709\u672a\u5904\u7406\u7684\u6d3b\u52a8\u8282\u70b9\uff0c\u4e0d\u80fd\u6267\u884c\u64a4\u56de\u64cd\u4f5c\uff01");
        }
        for (FlowNodeInstance flowNodeInstance : list) {
            int[] ids;
            int[] nArray = ids = flowNodeInstance.getPreNodeInstanceIds72();
            int n = ids.length;
            int n2 = 0;
            while (n2 < n) {
                FlowNodeInstance toNodeInstance;
                int id = nArray[n2];
                FlowNodeInstance preNodeInstance = toNodeInstance = this.getFlowNodeInstance(id);
                while (preNodeInstance.getIsAutoDeal()) {
                    int[] preArr = preNodeInstance.getPreNodeInstanceIds72();
                    if (preArr.length == 1) {
                        preNodeInstance = this.getFlowNodeInstance(preArr[0]);
                        continue;
                    }
                    preNodeInstance = null;
                    break;
                }
                if (preNodeInstance != null) {
                    List<Integer> nextIds = preNodeInstance.getNextNodeInstanceIds72();
                    boolean canCallBack = true;
                    for (int nextId : nextIds) {
                        FlowNodeInstance nextNodeInstance = this.getFlowNodeInstance(nextId);
                        while (nextNodeInstance.getIsAutoDeal()) {
                            List<Integer> next = nextNodeInstance.getNextNodeInstanceIds72();
                            if (next.size() == 1) {
                                nextNodeInstance = this.getFlowNodeInstance(next.get(0));
                                continue;
                            }
                            nextNodeInstance = null;
                            break;
                        }
                        if (list.contains(nextNodeInstance) && nextNodeInstance != null) continue;
                        canCallBack = false;
                        break;
                    }
                    if (canCallBack && preNodeInstance.getOperatorManager().getOperators().containsKey(user.getId())) {
                        String key = String.valueOf(toNodeInstance.getNodeInstanceId());
                        toNodeMap.put(key, toNodeInstance);
                    }
                }
                ++n2;
            }
        }
        if (toNodeMap.size() == 0) {
            throw new Exception("\u6ca1\u6709\u6ee1\u8db3\u6761\u4ef6\u7684\u8282\u70b9\u53ef\u4ee5\u64a4\u56de\uff01");
        }
        if (toNodeMap.size() > 1) {
            ArrayList<TreeNodeBean> arrayList = new ArrayList<TreeNodeBean>();
            for (Map.Entry entry : toNodeMap.entrySet()) {
                FlowNodeInstance toNode = (FlowNodeInstance)entry.getValue();
                int nodeInsId = toNode.getNodeInstanceId();
                TreeNodeBean treeNode = new TreeNodeBean();
                treeNode.setTableId("FlowNode");
                treeNode.setText(toNode.getFlowNodeName());
                String keyId = String.valueOf(String.valueOf(toNode.getFlowNodeId())) + "," + String.valueOf(nodeInsId);
                treeNode.setObjectId(keyId);
                treeNode.setId(keyId);
                treeNode.setIconSrc(FlowNode.icon);
                treeNode.setGetData(true);
                arrayList.add(treeNode);
            }
            return arrayList;
        }
        return null;
    }

    private boolean callBackToNext72(Map toNodeMap) throws Exception {
        Flow flow = this.getTemplet();
        HashMap<String, FlowNodeInstance> nextNodeInstancesHasUntread = new HashMap<String, FlowNodeInstance>();
        HashMap<String, FlowNodeInstance> nextNodeInstances = new HashMap<String, FlowNodeInstance>();
        for (Map.Entry entry : toNodeMap.entrySet()) {
            String nodeId_nodeInstanceId = (String)entry.getKey();
            Object obj = entry.getValue();
            if (obj instanceof FlowNodeInstance) {
                FlowNodeInstance nodeIns = (FlowNodeInstance)obj;
                this.getNextNodeInstances(nodeIns, nextNodeInstancesHasUntread, nextNodeInstances);
                continue;
            }
            String[] idArr = nodeId_nodeInstanceId.split(",");
            if (idArr.length == 2) {
                FlowNodeInstance nodeIns = this.getFlowNodeInstance(Integer.valueOf(idArr[1]));
                this.getNextNodeInstances(nodeIns, nextNodeInstancesHasUntread, nextNodeInstances);
                continue;
            }
            throw new Exception("\u64a4\u56de\u5f02\u5e38\uff0c\u53c2\u6570\u6709\u8bef\uff01");
        }
        for (Map.Entry entry : toNodeMap.entrySet()) {
            String nodeId_nodeInstanceId = (String)entry.getKey();
            Object obj = entry.getValue();
            if (obj instanceof FlowNodeInstance) {
                if (!nextNodeInstances.containsKey(((FlowNodeInstance)obj).getId())) continue;
                throw new Exception("\u64a4\u56de\u5f02\u5e38\uff0c\u8981\u9000\u56de\u7684\u8282\u70b9\u4e2d\u4e00\u4e2a\u662f\u53e6\u4e00\u4e2a\u7684\u524d\u9a71\u8282\u70b9\uff01");
            }
            String[] idArr = nodeId_nodeInstanceId.split(",");
            if (idArr.length == 2) {
                if (!nextNodeInstances.containsKey(idArr[1])) continue;
                throw new Exception("\u64a4\u56de\u5f02\u5e38\uff0c\u8981\u9000\u56de\u7684\u8282\u70b9\u4e2d\u4e00\u4e2a\u662f\u53e6\u4e00\u4e2a\u7684\u524d\u9a71\u8282\u70b9\uff01");
            }
            throw new Exception("\u64a4\u56de\u5f02\u5e38\uff0c\u65e0\u6cd5\u83b7\u53d6\u8981\u9000\u56de\u7684\u6d41\u7a0b\u8282\u70b9\u5b9e\u4f8b\uff01");
        }
        for (Map.Entry entry : nextNodeInstances.entrySet()) {
            FlowNodeInstance nextIns = (FlowNodeInstance)entry.getValue();
            if (nextIns.getRunStatus() == 0 || nextIns.getRunStatus() == 5) {
                nextIns.terminate72(11);
            }
            int[] preInsIds = nextIns.getPreNodeInstanceIds72();
            ArrayList<Integer> needCreat = new ArrayList<Integer>();
            Object object = preInsIds;
            int n = preInsIds.length;
            int n2 = 0;
            while (n2 < n) {
                int i = object[n2];
                if (!nextNodeInstancesHasUntread.containsKey(String.valueOf(i))) {
                    needCreat.add(i);
                }
                ++n2;
            }
            if (needCreat.size() <= 0) continue;
            FlowNode node = flow.getNodeById(nextIns.getFlowNodeId());
            FlowNodeInstance vnodeIns = FlowNodeInstance.create(this, node);
            vnodeIns.setRunStatusNoteStart(4);
            nextIns.setvNextNodeInstanceId(vnodeIns.getNodeInstanceId());
            object = needCreat.iterator();
            while (object.hasNext()) {
                int preInsId = (Integer)object.next();
                vnodeIns.addPreNodeInstanceId(preInsId);
            }
        }
        for (Map.Entry entry : toNodeMap.entrySet()) {
            String nodeId_nodeInstanceId = (String)entry.getKey();
            Object obj = entry.getValue();
            if (obj instanceof FlowNodeInstance) {
                boolean hasPermission;
                FlowNodeInstance nodeIns = (FlowNodeInstance)obj;
                User user = User.getCurrentUser();
                if (user == null) {
                    throw new Exception("\u65e0\u6cd5\u83b7\u53d6\u5f53\u524d\u767b\u5f55\u7528\u6237\uff01");
                }
                FlowOperatorManager operatorManager = nodeIns.getOperatorManager();
                if (!nodeIns.getIsAutoDeal() && !(hasPermission = operatorManager.hasCallBackPermission(user.getId()))) {
                    throw new Exception("\u5f53\u524d\u7528\u6237\u6ca1\u6709\u64a4\u56de\u6743\u9650\uff01");
                }
                FlowNode node = flow.getNodeById(nodeIns.getFlowNodeId());
                node.startForCallBack72(this, nodeIns);
                continue;
            }
            String[] idArr = nodeId_nodeInstanceId.split(",");
            if (idArr.length == 2) {
                boolean hasPermission;
                FlowNodeInstance nodeIns = this.getFlowNodeInstance(Integer.valueOf(idArr[1]));
                User user = User.getCurrentUser();
                if (user == null) {
                    throw new Exception("\u65e0\u6cd5\u83b7\u53d6\u5f53\u524d\u767b\u5f55\u7528\u6237\uff01");
                }
                FlowOperatorManager operatorManager = nodeIns.getOperatorManager();
                if (!nodeIns.getIsAutoDeal() && !(hasPermission = operatorManager.hasCallBackPermission(user.getId()))) {
                    throw new Exception("\u5f53\u524d\u7528\u6237\u6ca1\u6709\u64a4\u56de\u6743\u9650\uff01");
                }
                FlowNode node = flow.getNodeById(nodeIns.getFlowNodeId());
                node.startForCallBack72(this, nodeIns);
                continue;
            }
            throw new Exception("\u9000\u56de\u5f02\u5e38\uff0c\u53c2\u6570\u6709\u8bef\uff01");
        }
        return true;
    }

    @Override
    public Object end2run72(Map toNodeMap) throws Exception {
        if (!"7.2".equalsIgnoreCase(this.getVersion())) {
            return FlowInstance.doc2Run(this.getId());
        }
        Object result = null;
        this.callbacking = true;
        try {
            if (this.runStatus != 1) {
                throw new Exception("\u6d41\u7a0b\u672a\u5904\u4e8e\u5f52\u6863\u72b6\u6001\uff0c\u65e0\u6cd5\u6267\u884c\u8be5\u64cd\u4f5c\uff01");
            }
            if (toNodeMap != null) {
                result = this.doEnd2Run(toNodeMap);
            } else {
                toNodeMap = new HashMap();
                result = this.getEnd2RunNode(toNodeMap);
                if (result == null) {
                    result = this.doEnd2Run(toNodeMap);
                }
            }
            if (result instanceof Boolean) {
                this.save();
            }
            this.callbacking = false;
        }
        finally {
            this.clearCache();
        }
        return result;
    }

    private List getEnd2RunNode(Map toNodeMap) throws Exception {
        int[] preNodeArr;
        User currUser = User.getCurrentUser();
        if (currUser == null) {
            throw new Exception("\u65e0\u6cd5\u83b7\u53d6\u5f53\u524d\u7528\u6237\uff01");
        }
        FlowNode endNode = this.getTemplet().getEndNode();
        FlowNodeInstance endNodeIns = this.getLastNodeInstance(endNode);
        if (endNodeIns == null) {
            throw new Exception("\u65e0\u6cd5\u83b7\u53d6\u5f53\u524d\u6d41\u7a0b\u7684\u7ed3\u675f\u8282\u70b9\uff01");
        }
        int[] nArray = preNodeArr = endNodeIns.getPreNodeInstanceIds72();
        int n = preNodeArr.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            FlowNodeInstance preNodeIns = this.getFlowNodeInstance(i);
            if (preNodeIns != null && preNodeIns.getOperatorManager().getOperators().containsKey(currUser.getId())) {
                String key = String.valueOf(preNodeIns.getNodeInstanceId());
                toNodeMap.put(key, preNodeIns);
            }
            ++n2;
        }
        if (toNodeMap.size() == 0) {
            throw new Exception("\u5f53\u524d\u7528\u6237\u6ca1\u6709\u590d\u6d3b\u6743\u9650\uff01\u65e0\u6cd5\u83b7\u53d6\u53ef\u590d\u6d3b\u7684\u8282\u70b9\uff01");
        }
        if (toNodeMap.size() == 1) {
            return null;
        }
        ArrayList<TreeNodeBean> treeList = new ArrayList<TreeNodeBean>();
        for (Map.Entry entry : toNodeMap.entrySet()) {
            FlowNodeInstance toNodeIns = (FlowNodeInstance)entry.getValue();
            TreeNodeBean treeNode = new TreeNodeBean();
            treeNode.setTableId("FlowNode");
            treeNode.setText(toNodeIns.getFlowNodeName());
            String keyId = String.valueOf(String.valueOf(toNodeIns.getFlowNodeId())) + "," + String.valueOf(toNodeIns.getNodeInstanceId());
            treeNode.setObjectId(keyId);
            treeNode.setId(keyId);
            treeNode.setIconSrc(FlowNode.icon);
            treeNode.setGetData(true);
            treeList.add(treeNode);
        }
        return treeList;
    }

    private boolean doEnd2Run(Map toNodeMap) throws Exception {
        this.reRun();
        Flow flow = this.getTemplet();
        HashMap<String, FlowNodeInstance> nextNodeInstancesHasUntread = new HashMap<String, FlowNodeInstance>();
        HashMap<String, FlowNodeInstance> nextNodeInstances = new HashMap<String, FlowNodeInstance>();
        for (Map.Entry entry : toNodeMap.entrySet()) {
            String nodeId_nodeInstanceId = (String)entry.getKey();
            Object obj = entry.getValue();
            if (obj instanceof FlowNodeInstance) {
                this.getNextNodeInstances((FlowNodeInstance)obj, nextNodeInstancesHasUntread, nextNodeInstances);
                continue;
            }
            String[] idArr = nodeId_nodeInstanceId.split(",");
            if (idArr.length == 2) {
                FlowNodeInstance nodeIns = this.getFlowNodeInstance(Integer.valueOf(idArr[1]));
                this.getNextNodeInstances(nodeIns, nextNodeInstancesHasUntread, nextNodeInstances);
                continue;
            }
            throw new Exception("\u590d\u6d3b\u5f02\u5e38\uff0c\u65e0\u6cd5\u83b7\u53d6\u8981\u9000\u56de\u7684\u6d41\u7a0b\u8282\u70b9\u5b9e\u4f8b\uff01");
        }
        for (Map.Entry entry : toNodeMap.entrySet()) {
            String nodeId_nodeInstanceId = (String)entry.getKey();
            Object obj = entry.getValue();
            if (obj instanceof FlowNodeInstance) {
                if (!nextNodeInstances.containsKey(((FlowNodeInstance)obj).getId())) continue;
                throw new Exception("\u590d\u6d3b\u5f02\u5e38\uff0c\u8981\u590d\u6d3b\u7684\u8282\u70b9\u4e2d\u4e00\u4e2a\u662f\u53e6\u4e00\u4e2a\u7684\u524d\u9a71\u8282\u70b9\uff01");
            }
            String[] idArr = nodeId_nodeInstanceId.split(",");
            if (idArr.length == 2) {
                if (!nextNodeInstances.containsKey(idArr[1])) continue;
                throw new Exception("\u590d\u6d3b\u5f02\u5e38\uff0c\u8981\u590d\u6d3b\u7684\u8282\u70b9\u4e2d\u4e00\u4e2a\u662f\u53e6\u4e00\u4e2a\u7684\u524d\u9a71\u8282\u70b9\uff01");
            }
            throw new Exception("\u590d\u6d3b\u5f02\u5e38\uff0c\u65e0\u6cd5\u83b7\u53d6\u8981\u590d\u6d3b\u7684\u6d41\u7a0b\u8282\u70b9\u5b9e\u4f8b\uff01");
        }
        for (Map.Entry entry : nextNodeInstances.entrySet()) {
            FlowNodeInstance nodeIns = (FlowNodeInstance)entry.getValue();
            if (this.getTemplet().getEndNode().isInstance(nodeIns)) {
                nodeIns.addNotes("\u590d\u6d3b\uff1a");
                nodeIns.terminate72(7);
            }
            flow.getNodeById(nodeIns.getFlowNodeId()).dealForUntread(this, nodeIns, nextNodeInstancesHasUntread);
        }
        if (toNodeMap != null && !toNodeMap.isEmpty()) {
            for (Map.Entry entry : toNodeMap.entrySet()) {
                FlowNode node;
                String nodeId_nodeInstanceId = (String)entry.getKey();
                Object obj = entry.getValue();
                if (obj instanceof FlowNodeInstance) {
                    FlowNodeInstance nodeIns = (FlowNodeInstance)obj;
                    node = flow.getNodeById(nodeIns.getFlowNodeId());
                    node.startForEnd2Run(this, nodeIns);
                    continue;
                }
                String[] idArr = nodeId_nodeInstanceId.split(",");
                if (idArr.length == 2) {
                    node = flow.getNodeById(Integer.valueOf(idArr[0]));
                    FlowNodeInstance nodeIns = this.getFlowNodeInstance(Integer.valueOf(idArr[1]));
                    node.startForEnd2Run(this, nodeIns);
                    continue;
                }
                throw new Exception("\u6240\u9009\u8282\u70b9\u4f20\u5165\u53c2\u6570\u6709\u8bef\uff0c\u65e0\u6cd5\u83b7\u53d6\u8981\u590d\u6d3b\u7684\u6d41\u7a0b\u8282\u70b9\uff01");
            }
        } else {
            throw new Exception("\u65e0\u6cd5\u83b7\u53d6\u8981\u590d\u6d3b\u7684\u8282\u70b9\uff01");
        }
        return true;
    }

    public void reRun() throws Exception {
        this.fire(BEFORE_COMPLETE);
        this.endDate = null;
        this.runStatus = 0;
        this.modify();
    }

    public void getNextNodeInstances(FlowNodeInstance nodeInstance, Map<String, FlowNodeInstance> nextNodesInstancesHasUntread, Map<String, FlowNodeInstance> nextNodesInstances) {
        nextNodesInstancesHasUntread.put(String.valueOf(nodeInstance.getNodeInstanceId()), nodeInstance);
        List<Integer> ids = nodeInstance.getNextNodeInstanceIds72();
        for (int id : ids) {
            FlowNodeInstance nextNodeInstance = this.getFlowNodeInstance(id);
            if (nextNodeInstance == null) continue;
            nextNodesInstances.put(String.valueOf(id), nextNodeInstance);
            this.getNextNodeInstances(nextNodeInstance, nextNodesInstancesHasUntread, nextNodesInstances);
        }
    }

    public boolean updateOpener(boolean isOpen) {
        if (isOpen) {
            if (this.canOpen()) {
                dao.updateOpener(this, isOpen);
                this.setOpener(User.getCurrentUser());
                this.setOpenerId(User.getCurrentUser().getId());
                this.setLastopentime(DateTool.getCalendar(new Date()));
                return true;
            }
            return false;
        }
        if (this.openerId != null && this.openerId.equals(User.getCurrentUser().getId())) {
            dao.updateOpener(this, isOpen);
            this.setOpener(User.getCurrentUser());
            this.setOpenerId(User.getCurrentUser().getId());
        }
        return true;
    }

    public boolean canOpen() {
        try {
            if (this.openerId != null && this.openerId.length() != 0 && !User.isCurrent(this.openerId)) {
                Date lastOpenTime = this.lastopentime.getTime();
                Date now = new Date();
                if (now.getTime() - lastOpenTime.getTime() < (long)MAX_OPENTIME && User.userIsOnline(this.openerId)) {
                    this.setReadOnly();
                    return false;
                }
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public void close() throws Exception {
        this.updateOpener(false);
    }

    public User getOpener() {
        return this.opener;
    }

    public void setOpener(User opener) {
        this.opener = opener;
    }

    public String getOpenerId() {
        return this.openerId;
    }

    public void setOpenerId(String openerId) {
        this.openerId = openerId;
    }

    public Calendar getLastopentime() {
        return this.lastopentime;
    }

    public void setLastopentime(Calendar lastopentime) {
        this.lastopentime = lastopentime;
    }

    public void setReadOnly() {
        this.readOnly = true;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public static Map<String, String> getSyncmap() {
        return syncMap;
    }

    public static void setWF_IMGPATH(String appRoot) {
        WF_IMGPATH = String.valueOf(appRoot) + "/pms/platform/image/flow/";
    }
}

