/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.workflow.service;

import com.sdjxd.pms.platform.base.BaseClass;
import com.sdjxd.pms.platform.base.DataModify;
import com.sdjxd.pms.platform.data.DbOper;
import com.sdjxd.pms.platform.data.DbSession;
import com.sdjxd.pms.platform.workflow.dao.FlowInstanceDao;
import com.sdjxd.pms.platform.workflow.model.FlowFormInstanceBean;
import java.util.ArrayList;
import java.util.List;

public class FlowFormInstance
extends BaseClass {
    private static final long serialVersionUID = 1L;
    protected static FlowInstanceDao dao = FlowInstanceDao.createInstance();
    private String flowInstanceId;
    private int flowFormId;
    private List formInstanceId = new ArrayList();
    private DataModify dataModify;
    private String curFormInstanceId = "";

    public void load(FlowFormInstanceBean model) {
        this.flowInstanceId = model.getFlowInstanceId();
        this.flowFormId = model.getFlowFormId();
        this.formInstanceId = new ArrayList();
        this.formInstanceId.add(model.getFormInstanceId());
        this.dataModify = DataModify.SAVED;
    }

    public void loadAddFormInstance(String formInstanceId) {
        this.formInstanceId.add(formInstanceId);
    }

    public void addInstance(String formInstanceId) {
        if (formInstanceId != null && formInstanceId.length() != 0) {
            this.formInstanceId.add(formInstanceId);
            this.dataModify = DataModify.MODIFY;
        }
    }

    public static FlowFormInstance create(String flowInstanceId, int flowFormId, String formInstanceId) {
        FlowFormInstance formInstance = new FlowFormInstance();
        FlowFormInstanceBean model = new FlowFormInstanceBean();
        model.setFlowInstanceId(flowInstanceId);
        model.setFlowFormId(flowFormId);
        model.setFormInstanceId(formInstanceId);
        formInstance.load(model);
        formInstance.dataModify = DataModify.NEW;
        return formInstance;
    }

    public void save() throws Exception {
        DbSession session = DbOper.openDb("defaultds");
        try {
            try {
                if (!this.dataModify.is(DataModify.SAVED)) {
                    FlowFormInstanceBean model = new FlowFormInstanceBean();
                    model.setFlowInstanceId(this.flowInstanceId);
                    model.setFlowFormId(this.flowFormId);
                    int i = 0;
                    while (i < this.formInstanceId.size()) {
                        model.setFormInstanceId(this.formInstanceId.get(i).toString());
                        dao.saveFormInstance(model, this.dataModify);
                        ++i;
                    }
                }
                DbOper.commitDb(session);
            }
            catch (Exception exp) {
                DbOper.rollbackDb(session);
                throw exp;
            }
        }
        finally {
            DbOper.closeDb(session);
        }
        this.dataModify = DataModify.SAVED;
    }

    public int getFlowFormId() {
        return this.flowFormId;
    }

    public String getInstanceId() {
        if (this.curFormInstanceId != null && this.curFormInstanceId.length() != 0) {
            return this.curFormInstanceId;
        }
        if (this.formInstanceId.size() > 0) {
            return (String)this.formInstanceId.get(0);
        }
        return null;
    }

    public boolean contains(String formInstanceId) {
        return this.formInstanceId.contains(formInstanceId);
    }

    public void setCurFormInstanceId(String curFormInstanceId) {
        this.curFormInstanceId = curFormInstanceId;
    }

    public List getFormInstances() {
        return this.formInstanceId;
    }
}

