/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.workflow.service;

import com.sdjxd.pms.platform.base.BaseClass;
import com.sdjxd.pms.platform.tool.StringTool;
import com.sdjxd.pms.platform.workflow.dao.FlowDao;
import com.sdjxd.pms.platform.workflow.model.FlowFormBean;
import com.sdjxd.pms.platform.workflow.service.FlowFormInstance;
import com.sdjxd.pms.platform.workflow.service.FlowInstance;
import com.sdjxd.pms.platform.workflow.service.FormVariable;
import java.util.HashMap;
import java.util.Map;

public class FlowForm
extends BaseClass {
    private static final long serialVersionUID = 1L;
    protected static FlowDao dao = FlowDao.createInstance();
    private int id;
    private String name;
    private int createNodeId;
    private String formPatternId;
    private String formUrl;
    private Map formVariable;

    public void load(FlowFormBean model) {
        this.id = model.getId();
        this.name = model.getName();
        this.createNodeId = model.getCreateNodeId();
        this.formPatternId = model.getFormPatternId();
        this.formUrl = model.getFormUrl();
        this.formVariable = new HashMap();
    }

    public void addVariable(FormVariable fv) {
        if (this.formVariable == null) {
            this.formVariable = new HashMap();
        }
        if (fv != null) {
            this.formVariable.put(fv.getPath(), fv);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getFormUrl(FlowInstance flowInstance, int nodeInstanceId) {
        StringBuffer sb = new StringBuffer(256);
        if (!StringTool.isEmpty(this.formPatternId)) {
            sb.append("/createForm.do?p=");
            sb.append(this.formPatternId);
        } else if (!StringTool.isEmpty(this.formUrl)) {
            sb.append(this.formUrl);
        } else {
            sb.append("error.jsp");
        }
        if (sb.indexOf("?") > 0) {
            sb.append("&");
        } else {
            sb.append("?");
        }
        sb.append("flowInstanceId=");
        sb.append(flowInstance.getId());
        sb.append("&nodeInstanceId=");
        sb.append(nodeInstanceId);
        sb.append("&flowFormId=");
        sb.append(this.id);
        return sb.toString();
    }

    public String getFormUrl(FlowInstance flowInstance, int nodeInstanceId, FlowFormInstance flowFormInstance) {
        StringBuffer sb = new StringBuffer(256);
        if (!StringTool.isEmpty(this.formPatternId)) {
            sb.append("/form.do?p=");
            sb.append(this.formPatternId);
        } else if (!StringTool.isEmpty(this.formUrl)) {
            sb.append(this.formUrl);
        } else {
            sb.append("error.jsp");
        }
        if (sb.indexOf("?") > 0) {
            sb.append("&");
        } else {
            sb.append("?");
        }
        sb.append("s=");
        sb.append(flowFormInstance.getInstanceId());
        sb.append("&flowInstanceId=");
        sb.append(flowInstance.getId());
        sb.append("&nodeInstanceId=");
        sb.append(nodeInstanceId);
        sb.append("&flowFormId=");
        sb.append(this.id);
        return sb.toString();
    }

    public String getFormUrl(FlowInstance flowInstance, int nodeInstanceId, FlowFormInstance flowFormInstance, String formInstanceId) {
        StringBuffer sb = new StringBuffer(256);
        if (!StringTool.isEmpty(this.formPatternId)) {
            sb.append("/form.do?p=");
            sb.append(this.formPatternId);
        } else if (!StringTool.isEmpty(this.formUrl)) {
            sb.append(this.formUrl);
        } else {
            sb.append("error.jsp");
        }
        if (sb.indexOf("?") > 0) {
            sb.append("&");
        } else {
            sb.append("?");
        }
        sb.append("s=");
        sb.append(formInstanceId);
        sb.append("&flowInstanceId=");
        sb.append(flowInstance.getId());
        sb.append("&nodeInstanceId=");
        sb.append(nodeInstanceId);
        sb.append("&flowFormId=");
        sb.append(this.id);
        return sb.toString();
    }

    public String getFormUrl() {
        if (!StringTool.isEmpty(this.formUrl)) {
            return this.formUrl;
        }
        if (!StringTool.isEmpty(this.formPatternId)) {
            return "/form.do?h_formId=" + this.formPatternId + "&h_flowSession=[flow.session.key]&h_flowId=[flow.id]&h_flowInstanceId=[flow.instance.id]&h_flowNodeId=[flow.node.id]&h_flowNodeInstanceId=[flow.node.instance.id]&h_flowFormId=[flow.form.id]&h_formInstanceId=[flow.form.instance.id]&h_formcreate=[flow.form.create]";
        }
        return "error.jsp";
    }

    public String getFormPatternId() {
        return this.formPatternId;
    }

    public String toJson() {
        StringBuffer script = new StringBuffer(1024);
        script.append("{");
        script.append("id:'").append(this.id).append("'");
        script.append(",name:'").append(this.name).append("'");
        script.append(",createNodeId:").append(this.createNodeId);
        script.append(",formPatternId:'").append(this.formPatternId).append("'");
        script.append(",formUrl:'").append(this.formUrl).append("'");
        script.append("}");
        return script.toString();
    }
}

