/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.workflow.service;

import com.sdjxd.pms.platform.base.BaseClass;
import com.sdjxd.pms.platform.organize.Organize;
import com.sdjxd.pms.platform.organize.Role;
import com.sdjxd.pms.platform.organize.User;
import com.sdjxd.pms.platform.tool.BeanTool;
import com.sdjxd.pms.platform.tool.Guid;
import com.sdjxd.pms.platform.workflow.dao.DelegateDao;
import com.sdjxd.pms.platform.workflow.model.FlowDelegateBean;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FlowDelegate
extends BaseClass {
    private static final long serialVersionUID = 1L;
    protected static DelegateDao dao = DelegateDao.createInstance();
    private String delegateId;
    private String flowInstanceId;
    private int nodeInstanceId;
    private String operator;
    private int delegateType;
    private Map delegateTo;
    private String reason;
    private String backReason;

    public static void create(String flowInstanceId, int nodeInstanceId, Map delegateTo, String reason) throws Exception {
        if (FlowDelegate.isDelegate(flowInstanceId, nodeInstanceId)) {
            throw new Exception("\u4e0d\u80fd\u91cd\u590d\u521b\u5efa\u4ee3\u529e\uff01");
        }
        FlowDelegateBean model = new FlowDelegateBean();
        model.setDelegateId(Guid.create());
        model.setFlowInstanceId(flowInstanceId);
        model.setNodeInstanceId(nodeInstanceId);
        model.setOperator(User.getCurrentUser().getId());
        model.setDelegateTo(BeanTool.toJson(delegateTo));
        model.setReason(reason);
        model.setCreateTime(Calendar.getInstance().getTime());
        dao.createDelegate(model);
    }

    public static void delete(FlowDelegateBean model) {
    }

    public static void callback(FlowDelegateBean model) {
    }

    public static boolean isDelegate(String flowInstanceId, int nodeInstanceId) throws Exception {
        FlowDelegateBean model = new FlowDelegateBean();
        model.setFlowInstanceId(flowInstanceId);
        model.setNodeInstanceId(nodeInstanceId);
        model.setOperator(User.getCurrentUser().getId());
        return dao.isDelegate(model);
    }

    public static List<Map<String, String>> getDelegateInfo(String flowInstanceId, int nodeInstanceId) throws Exception {
        ArrayList<Map<String, String>> delegateList = new ArrayList<Map<String, String>>();
        List<Map<String, String>> list = dao.getDelegateInfo(flowInstanceId, nodeInstanceId);
        int i = 0;
        while (i < list.size()) {
            Map<String, String> map = list.get(i);
            String operator = map.get("operator");
            User user = User.getUser(operator);
            String operatorName = user.getName();
            String delegateto = map.get("delegateto");
            delegateto = delegateto.replace("new java.util.HashMap(", "").replace(")", "");
            String delegateToName = "";
            HashMap delegateMap = (HashMap)BeanTool.parse(delegateto);
            for (Map.Entry entry : delegateMap.entrySet()) {
                String delegateToId = (String)entry.getKey();
                int delegateToType = Integer.parseInt((String)entry.getValue());
                switch (delegateToType) {
                    case 0: {
                        delegateToName = User.getUser(delegateToId).getName();
                        break;
                    }
                    case 1: {
                        delegateToName = String.valueOf(Role.getRole(delegateToId).getName()) + "(\u89d2\u8272)";
                        break;
                    }
                    case 2: {
                        delegateToName = String.valueOf(Organize.getOrganize(delegateToId).getName()) + "(\u90e8\u95e8)";
                    }
                }
            }
            HashMap<String, String> newMap = new HashMap<String, String>();
            newMap.put("operatorName", operatorName);
            newMap.put("delegateToName", delegateToName);
            newMap.put("info", String.valueOf(operatorName) + "->" + delegateToName);
            delegateList.add(newMap);
            ++i;
        }
        return delegateList;
    }
}

