/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.workflow.service;

import com.sdjxd.pms.platform.base.BaseClass;
import com.sdjxd.pms.platform.base.DataModify;
import com.sdjxd.pms.platform.workflow.dao.FlowInstanceDao;
import com.sdjxd.pms.platform.workflow.model.FlowChildInstanceBean;
import com.sdjxd.pms.platform.workflow.service.FlowInstance;

public class FlowChildInstance
extends BaseClass {
    private static final long serialVersionUID = 1L;
    protected static FlowInstanceDao dao = FlowInstanceDao.createInstance();
    private String flowInstanceId;
    private int flowNodeId;
    private String childInstanceId;
    private DataModify dataModify;

    public static FlowChildInstance create(FlowChildInstanceBean model) {
        FlowChildInstance fncInstance = new FlowChildInstance();
        fncInstance.load(model);
        fncInstance.dataModify = DataModify.NEW;
        return fncInstance;
    }

    public void load(FlowChildInstanceBean model) {
        if (model != null) {
            this.dataModify = DataModify.SAVED;
            this.flowInstanceId = model.getFlowInstanceId();
            this.flowNodeId = model.getFlowNodeId();
            this.childInstanceId = model.getChildInstanceId();
        }
    }

    private void modify() {
        if (!this.dataModify.is(DataModify.NEW)) {
            this.dataModify = DataModify.MODIFY;
        }
    }

    public void save() throws Exception {
        if (this.dataModify.is(DataModify.NEW)) {
            FlowChildInstanceBean model = new FlowChildInstanceBean();
            model.setFlowInstanceId(this.flowInstanceId);
            model.setFlowNodeId(this.flowNodeId);
            model.setChildInstanceId(this.childInstanceId);
            dao.saveNodeChildInstance(model, this.dataModify);
            FlowInstance.load(this.childInstanceId).save();
            this.dataModify = DataModify.SAVED;
        }
    }
}

