/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.workflow.service;

import com.sdjxd.pms.platform.base.BaseClass;
import com.sdjxd.pms.platform.base.DataModify;
import com.sdjxd.pms.platform.base.Global;
import com.sdjxd.pms.platform.data.DbOper;
import com.sdjxd.pms.platform.organize.User;
import com.sdjxd.pms.platform.organize.model.UserBean;
import com.sdjxd.pms.platform.tool.Guid;
import com.sdjxd.pms.platform.tool.StringTool;
import com.sdjxd.pms.platform.workflow.dao.FlowDao;
import com.sdjxd.pms.platform.workflow.model.FlowAgentBean;
import com.sdjxd.pms.platform.workflow.service.FlowActor;
import com.sdjxd.pms.platform.workflow.service.FlowAgent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class FlowAgentManager
extends BaseClass {
    private static final long serialVersionUID = 1L;
    protected static FlowDao dao = FlowDao.createInstance();
    private String flowId;
    private List flowAgentList;

    public static FlowAgentManager getFlowAgentManager(String id) {
        if (id == null || id.length() == 0) {
            return null;
        }
        FlowAgentManager flowAgentManager = new FlowAgentManager();
        flowAgentManager.loadFromDB(id);
        return flowAgentManager;
    }

    public void loadFromDB(String id) {
        List modeList = dao.getFlowAgent(id);
        if (modeList != null) {
            if (this.flowAgentList == null) {
                this.flowAgentList = new ArrayList();
            }
            int i = 0;
            while (i < modeList.size()) {
                FlowAgentBean model = (FlowAgentBean)modeList.get(i);
                FlowAgent flowAgent = new FlowAgent();
                flowAgent.load(model);
                this.flowAgentList.add(flowAgent);
                ++i;
            }
        }
    }

    public Map setAgentToActor(int nodeId, Map actors) {
        if ("1".equals(Global.getConfig("forbiddenagent"))) {
            return actors;
        }
        HashMap map = new HashMap();
        boolean isHaveAgent = false;
        HashMap<String, String> agentMap = new HashMap<String, String>();
        HashMap<String, String> agentSourceMap = new HashMap<String, String>();
        for (Map.Entry entry : actors.entrySet()) {
            isHaveAgent = false;
            int j = 0;
            while (j < this.flowAgentList.size()) {
                FlowAgent flowAgent = (FlowAgent)this.flowAgentList.get(j);
                if ((flowAgent.getNodeId() == nodeId || flowAgent.getNodeId() == -1) && flowAgent.getAgentFrom().equals(entry.getKey().toString())) {
                    agentMap.put(flowAgent.getAgentTo(), String.valueOf(flowAgent.getAgentToType()));
                    agentSourceMap.put(flowAgent.getAgentTo(), flowAgent.getAgentFrom());
                    isHaveAgent = true;
                }
                ++j;
            }
            if (isHaveAgent) continue;
            map.put(entry.getKey(), entry.getValue());
        }
        Iterator it = agentMap.entrySet().iterator();
        ArrayList<String> users = new ArrayList<String>();
        ArrayList<String> depts = new ArrayList<String>();
        ArrayList<String> roles = new ArrayList<String>();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            int type = Integer.parseInt(entry.getValue().toString());
            switch (type) {
                case 0: {
                    users.add(entry.getKey().toString());
                    break;
                }
                case 1: {
                    roles.add(entry.getKey().toString());
                    break;
                }
                case 2: {
                    depts.add(entry.getKey().toString());
                }
            }
        }
        TreeMap treemap = new TreeMap();
        StringBuffer filterBuffer = new StringBuffer(1024);
        StringBuffer userAttachTableBuffer = new StringBuffer(256);
        boolean hasAgentUser = false;
        if (users.size() > 0) {
            hasAgentUser = true;
            filterBuffer.append(DbOper.toIn1000Sql("U.USERID", users)).append(" OR ");
        }
        if (depts.size() > 0) {
            hasAgentUser = true;
            filterBuffer.append(DbOper.toIn1000Sql("U.DEPTID", depts)).append(" OR ");
        }
        if (roles.size() > 0) {
            hasAgentUser = true;
            filterBuffer.append("EXISTS(SELECT 1 FROM [S].JXD7_XT_USERROLE R_R_ WHERE U.USERID=R_R_.USERID AND ");
            filterBuffer.append(DbOper.toIn1000Sql("R_R_.ROLEID", roles));
            filterBuffer.append(") OR ");
        }
        if (hasAgentUser) {
            if (filterBuffer.length() > 0) {
                filterBuffer.insert(0, "(");
                filterBuffer.setLength(filterBuffer.length() - 4);
                filterBuffer.append(")");
            } else {
                filterBuffer.append(" 1<>1 ");
            }
            String filter = filterBuffer.toString();
            String userAttachTable = userAttachTableBuffer.toString();
            String userAttachLimit = "";
            treemap = User.getUser(filter, userAttachTable, userAttachLimit);
            for (String userId : treemap.keySet()) {
                User sourceUser;
                User user = new User();
                user.init((UserBean)treemap.get(userId));
                String soucreId = (String)agentSourceMap.get(userId);
                if (!StringTool.isEmpty(soucreId) && (sourceUser = User.getUser(soucreId)) != null) {
                    String displayName = String.valueOf(user.getName()) + "(" + sourceUser.getName() + "\u59d4\u6258)";
                    user.setDisplayName(displayName);
                }
                map.put(userId, user);
            }
        }
        return map;
    }

    public static boolean createAgent(int fromType, String from, String to, String flows, String nodes, String startTime, String endTime, String reson, int agentType) throws Exception {
        if (from != null && to != null && to.length() > 0 && startTime != null && endTime != null && reson != null) {
            if (agentType == 1 && (flows == null || flows.length() == 0)) {
                throw new Exception("\u5fc5\u987b\u6307\u5b9a\u9700\u8981\u4ee3\u7406\u7684\u6d41\u7a0b");
            }
            String[] arrTo = to.split(",");
            int i = 0;
            while (i < arrTo.length) {
                FlowAgentBean model = new FlowAgentBean();
                model.setAgengtId(Guid.create());
                model.setAgentType(agentType);
                model.setAgentFrom(from);
                model.setAgentFromType(fromType);
                model.setAgentTo(arrTo[i]);
                model.setAgentToType(FlowActor.checkGuidOfUDR(arrTo[i]));
                model.setStartTime(startTime);
                model.setEndTime(endTime);
                model.setReson(reson);
                dao.saveFlowAgent(model, DataModify.NEW);
                if (flows.length() > 0 && nodes.length() > 0) {
                    String[] arrFlow = flows.split(",");
                    String[] arrFlowNode = nodes.split(",");
                    int j = 0;
                    while (j < arrFlow.length) {
                        dao.saveAgentFlow(model.getAgengtId(), arrFlow[j], arrFlowNode[j], DataModify.NEW);
                        ++j;
                    }
                }
                ++i;
            }
        } else {
            throw new Exception("\u5fc5\u987b\u586b\u5199\u6240\u6709\u7684\u4ee3\u7406\u4fe1\u606f\uff0c\u4e0d\u53ef\u4e3a\u7a7a");
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean modifyAgent(String agentId, String flows, String nodes, String startTime, String endTime, String reson) throws Exception {
        if (agentId == null || startTime == null || endTime == null || reson == null || nodes == null) throw new Exception("\u5fc5\u987b\u586b\u5199\u6240\u6709\u7684\u4ee3\u7406\u4fe1\u606f\uff0c\u4e0d\u53ef\u4e3a\u7a7a");
        List list = dao.loadAgentInfoById(agentId);
        if (list.size() <= 0) throw new Exception("\u627e\u4e0d\u5230\u9700\u8981\u7684\u4ee3\u7406\u4fe1\u606f\uff0c\u539f\u56e0\uff1a\u672c\u4ee3\u7406\u5df2\u88ab\u5220\u9664\u6216\u5b58\u5728\u5f02\u5e38\u6570\u636e\uff01");
        FlowAgentBean model = (FlowAgentBean)list.get(0);
        if (model.getAgentToType() == 1 && (flows == null || flows.length() == 0)) {
            throw new Exception("\u90e8\u5206\u4ee3\u7406\u5fc5\u987b\u8bbe\u7f6e\u8981\u4ee3\u7406\u7684\u6d41\u7a0b\u8282\u70b9\u6570\u636e\u4fe1\u606f");
        }
        model.setStartTime(startTime);
        model.setEndTime(endTime);
        model.setReson(reson);
        FlowAgent flowAgent = new FlowAgent();
        flowAgent.load(model);
        flowAgent.modify();
        flowAgent.save();
        dao.saveAgentFlow(agentId, "-1", "-1", DataModify.DELETE);
        if (flows == null || flows.length() <= 0) return true;
        String[] arrFlow = flows.split(",");
        String[] arrFlowNode = nodes.split(",");
        int j = 0;
        while (j < arrFlow.length) {
            dao.saveAgentFlow(model.getAgengtId(), arrFlow[j], arrFlowNode[j], DataModify.NEW);
            ++j;
        }
        return true;
    }

    public static boolean delAgent(String agentId) throws Exception {
        if (agentId != null && agentId.length() > 0) {
            dao.delFlowAgent(agentId);
        }
        return true;
    }

    public static List loadFlowAgentBean(String agentId) {
        List list = dao.loadAgentInfoById(agentId);
        return list;
    }
}

