/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.workflow.service;

import com.sdjxd.pms.platform.base.BaseClass;
import com.sdjxd.pms.platform.base.DataModify;
import com.sdjxd.pms.platform.workflow.dao.FlowDao;
import com.sdjxd.pms.platform.workflow.model.FlowAgentBean;

public class FlowAgent
extends BaseClass {
    private static final long serialVersionUID = 1L;
    protected static FlowDao dao = FlowDao.createInstance();
    private String agengtId;
    private String flowId;
    private int nodeId;
    private int agentType;
    private int agentFromType;
    private String agentFrom;
    private int agentToType;
    private String agentTo;
    private DataModify dataModify;
    private String startTime;
    private String endTime;
    private String reson;

    public void load(FlowAgentBean model) {
        if (model != null) {
            this.agengtId = model.getAgengtId();
            this.flowId = model.getFlowId();
            this.nodeId = model.getNodeId();
            this.agentType = model.getAgentType();
            this.agentFromType = model.getAgentFromType();
            this.agentFrom = model.getAgentFrom();
            this.agentToType = model.getAgentToType();
            this.agentTo = model.getAgentTo();
            this.startTime = model.getStartTime();
            this.endTime = model.getEndTime();
            this.reson = model.getReson();
            this.dataModify = DataModify.SAVED;
        }
    }

    public static FlowAgent create(FlowAgentBean model) {
        FlowAgent flowAgent = new FlowAgent();
        if (model != null) {
            flowAgent.agengtId = model.getAgengtId();
            flowAgent.flowId = model.getFlowId();
            flowAgent.nodeId = model.getNodeId();
            flowAgent.agentType = model.getAgentType();
            flowAgent.agentFromType = model.getAgentFromType();
            flowAgent.agentFrom = model.getAgentFrom();
            flowAgent.agentToType = model.getAgentToType();
            flowAgent.agentTo = model.getAgentTo();
            flowAgent.startTime = model.getStartTime();
            flowAgent.endTime = model.getEndTime();
            flowAgent.reson = model.getReson();
            flowAgent.dataModify = DataModify.NEW;
        }
        return flowAgent;
    }

    public void save() {
        if (!this.dataModify.is(DataModify.SAVED)) {
            FlowAgentBean model = new FlowAgentBean();
            model.setAgengtId(this.agengtId);
            model.setAgentFromType(this.agentFromType);
            model.setAgentFrom(this.agentFrom);
            model.setAgentToType(this.agentToType);
            model.setAgentTo(this.agentTo);
            model.setFlowId(this.flowId);
            model.setNodeId(this.nodeId);
            model.setStartTime(this.startTime);
            model.setEndTime(this.endTime);
            model.setReson(this.reson);
            dao.saveFlowAgent(model, this.dataModify);
            this.dataModify = DataModify.SAVED;
        }
    }

    public void modify() {
        if (!this.dataModify.is(DataModify.NEW)) {
            this.dataModify = DataModify.MODIFY;
        }
    }

    public String getAgentFrom() {
        return this.agentFrom;
    }

    public int getNodeId() {
        return this.nodeId;
    }

    public String getAgentTo() {
        return this.agentTo;
    }

    public int getAgentToType() {
        return this.agentToType;
    }
}

