/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.workflow.service;

import com.sdjxd.pms.platform.organize.User;
import com.sdjxd.pms.platform.workflow.model.FlowActorBean;
import com.sdjxd.pms.platform.workflow.service.FlowActor;
import com.sdjxd.pms.platform.workflow.service.FlowInstance;
import com.sdjxd.pms.platform.workflow.service.FlowNodeInstance;
import com.sdjxd.pms.platform.workflow.service.FlowOperator;
import java.util.HashMap;
import java.util.Map;
import net.sf.json.JSONArray;

public class FlowActorNodeOperator
extends FlowActor {
    private static final long serialVersionUID = 1L;
    private int[] nodes;

    @Override
    public void load(FlowActorBean model) {
        try {
            JSONArray jsoa = model.getData();
            if (jsoa != null) {
                jsoa = jsoa.getJSONArray(0);
                this.nodes = new int[jsoa.size()];
                int i = 0;
                while (i < this.nodes.length) {
                    this.nodes[i] = Integer.parseInt(jsoa.getString(i));
                    ++i;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public Map getOriginalActors(FlowInstance flowInstance, int nodeInstanceId) {
        HashMap<String, User> actors = new HashMap<String, User>();
        if (this.nodes != null && this.nodes.length > 0) {
            int i = 0;
            while (i < this.nodes.length) {
                FlowNodeInstance node = flowInstance.getLastNodeInstance(flowInstance.getTemplet().getNodeById(this.nodes[i]));
                if (node != null) {
                    HashMap<String, FlowOperator> map = node.getOperatorManager().getOperators();
                    for (Map.Entry entry : map.entrySet()) {
                        String userId = (String)entry.getKey();
                        actors.put(userId, User.getUser(userId));
                    }
                }
                ++i;
            }
        }
        return actors;
    }
}

