/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.workflow.service;

import com.sdjxd.pms.platform.base.BaseObject;
import com.sdjxd.pms.platform.data.DbOper;
import com.sdjxd.pms.platform.organize.Organize;
import com.sdjxd.pms.platform.organize.Role;
import com.sdjxd.pms.platform.organize.User;
import com.sdjxd.pms.platform.organize.model.UserBean;
import com.sdjxd.pms.platform.tool.StringTool;
import com.sdjxd.pms.platform.workflow.dao.FlowDao;
import com.sdjxd.pms.platform.workflow.model.FlowActorBean;
import com.sdjxd.pms.platform.workflow.service.FlowActor;
import com.sdjxd.pms.platform.workflow.service.FlowInstance;
import com.sdjxd.pms.platform.workflow.service.FlowNodeInstance;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import net.sf.json.JSONArray;

public class FlowActorList
extends FlowActor {
    protected static FlowDao dao = FlowDao.createInstance();
    private static final long serialVersionUID = 1L;
    public static final int RES_NONE = 0;
    public static final int RES_CREATE_DEPT = 1;
    public static final int RES_SEND_DEPT = 2;
    private boolean moreSelect;
    private boolean appointToUser = true;
    private boolean singleOperator = false;
    private String limit;
    private String attachTable;
    private Map actors;
    private String attachLimit;

    @Override
    public void load(FlowActorBean model) {
        this.actors = new HashMap();
        try {
            JSONArray jso = model.getData();
            if (jso.size() >= 3) {
                this.moreSelect = "1".equals(jso.getString(0));
                Object limitData = jso.get(1);
                String limit = limitData instanceof JSONArray ? ((JSONArray)limitData).getString(0) : (String)limitData;
                if ("1".equals(limit)) {
                    this.limit = "U.DEPTID='[flow.creater.deptId]'";
                } else if ("2".equals(limit)) {
                    this.limit = "U.DEPTID='[flow.sender.deptId]'";
                } else if ("3".equals(limit)) {
                    this.attachTable = ((JSONArray)limitData).getString(1);
                    this.attachLimit = ((JSONArray)limitData).getString(2);
                }
                JSONArray actorsData = jso.getJSONArray(2);
                int i = 0;
                while (i < actorsData.size()) {
                    JSONArray actorData = actorsData.getJSONArray(i);
                    this.actors.put(actorData.getString(0), actorData.getString(1));
                    ++i;
                }
                if (jso.size() >= 4) {
                    this.appointToUser = "0".equals(jso.getString(3));
                }
                if (jso.size() >= 5) {
                    this.singleOperator = "1".equals(jso.getString(4));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public Map getOriginalActors(FlowInstance flowInstance, int nodeInstanceId) {
        return this.getOriginalActors(flowInstance, nodeInstanceId, this.appointToUser, -1);
    }

    private Map getOriginalActors(FlowInstance flowInstance, int nodeInstanceId, boolean appointToUser, int flowNodeId) {
        HashMap<String, BaseObject> resultUsers;
        block34: {
            ArrayList depts;
            int i;
            String userAttachLimit;
            String userAttachTable;
            ArrayList<String> roleIds;
            ArrayList<String> deptIds;
            block33: {
                ArrayList<String> users = new ArrayList<String>();
                deptIds = new ArrayList<String>();
                roleIds = new ArrayList<String>();
                String limitGroupIds = null;
                if (flowNodeId != -1) {
                    limitGroupIds = flowInstance.getTemplet().getNodeById((int)flowNodeId).limitGroups;
                }
                if (!StringTool.isEmpty(limitGroupIds) && !"[]".equals(limitGroupIds)) {
                    Map<String, Integer> actors = dao.getFlowNodeActors_M(flowInstance.getFlowId(), flowNodeId);
                    if (actors != null) {
                        for (Map.Entry<String, Integer> entry : actors.entrySet()) {
                            int type = Integer.parseInt(((Object)entry.getValue()).toString());
                            switch (type) {
                                case 0: {
                                    users.add(entry.getKey().toString());
                                    break;
                                }
                                case 1: {
                                    roleIds.add(entry.getKey().toString());
                                    break;
                                }
                                case 2: {
                                    deptIds.add(entry.getKey().toString());
                                }
                            }
                        }
                    }
                } else if (this.actors != null) {
                    for (Map.Entry entry : this.actors.entrySet()) {
                        int type = Integer.parseInt(entry.getValue().toString());
                        switch (type) {
                            case 0: {
                                users.add(entry.getKey().toString());
                                break;
                            }
                            case 1: {
                                roleIds.add(entry.getKey().toString());
                                break;
                            }
                            case 2: {
                                deptIds.add(entry.getKey().toString());
                            }
                        }
                    }
                }
                resultUsers = new HashMap<String, BaseObject>();
                userAttachTable = this.getResource(flowInstance, nodeInstanceId, this.attachTable);
                userAttachLimit = this.getResource(flowInstance, nodeInstanceId, this.attachLimit);
                if (!appointToUser) break block33;
                TreeMap treemap = new TreeMap();
                StringBuffer filterBuffer = new StringBuffer(1024);
                if (users.size() > 0) {
                    filterBuffer.append(DbOper.toIn1000Sql("U.USERID", users)).append(" OR ");
                }
                if (deptIds.size() > 0) {
                    filterBuffer.append(DbOper.toIn1000Sql("U.DEPTID", deptIds)).append(" OR ");
                }
                if (roleIds.size() > 0) {
                    filterBuffer.append("EXISTS(SELECT 1 FROM [S].JXD7_XT_USERROLE R_R_ WHERE U.USERID=R_R_.USERID AND ");
                    filterBuffer.append(DbOper.toIn1000Sql("R_R_.ROLEID", roleIds));
                    filterBuffer.append(") OR ");
                }
                if (filterBuffer.length() <= 0) {
                    if (this.limit != null && this.limit.length() != 0) {
                        filterBuffer.append(this.limit);
                    } else {
                        filterBuffer.append("1==2");
                    }
                } else {
                    filterBuffer.insert(0, "(");
                    filterBuffer.setLength(filterBuffer.length() - 4);
                    filterBuffer.append(")");
                    if (this.limit != null && this.limit.length() != 0) {
                        filterBuffer.append(" AND (").append(this.limit).append(")");
                    }
                }
                String filter = null;
                filter = this.getResource(flowInstance, nodeInstanceId, filterBuffer.toString());
                treemap = User.getUser(filter, userAttachTable, userAttachLimit);
                for (String userId : treemap.keySet()) {
                    User user = new User();
                    user.init((UserBean)treemap.get(userId));
                    resultUsers.put(userId, user);
                }
                break block34;
            }
            if (roleIds.size() > 0) {
                ArrayList roles;
                try {
                    roles = Role.getRoles(roleIds, userAttachTable, userAttachLimit);
                }
                catch (Exception exp) {
                    roles = new ArrayList();
                }
                int len = roles.size();
                i = 0;
                while (i < len) {
                    Role role = (Role)roles.get(i);
                    resultUsers.put(role.getId(), role);
                    ++i;
                }
            }
            if (deptIds.size() <= 0) break block34;
            try {
                depts = Organize.getOrganizes(deptIds, userAttachTable, userAttachLimit);
            }
            catch (Exception exp) {
                depts = new ArrayList();
            }
            int len = depts.size();
            i = 0;
            while (i < len) {
                Organize organize = (Organize)depts.get(i);
                resultUsers.put(organize.getId(), organize);
                ++i;
            }
        }
        return resultUsers;
    }

    @Override
    public Map getActors(FlowInstance flowInstance, int nodeInstanceId, int newNodeId) {
        if (this.appointToUser) {
            return this.getActors(flowInstance, nodeInstanceId, this.getOriginalActors(flowInstance, nodeInstanceId, true, newNodeId), newNodeId);
        }
        return this.getOriginalActors(flowInstance, nodeInstanceId, false, newNodeId);
    }

    public Map getFinalActors(FlowInstance flowInstance, int nodeInstanceId, int newNodeId) {
        return this.getActors(flowInstance, nodeInstanceId, this.getOriginalActors(flowInstance, nodeInstanceId, true, newNodeId), newNodeId);
    }

    public boolean isMoreSelect() {
        return this.moreSelect;
    }

    private String getResource(FlowInstance flowInstance, int nodeInstanceId, String sql2) {
        String sqlFilter = sql2;
        HashMap<String, String> replace = new HashMap<String, String>();
        String createUserId = flowInstance.getCreateUserId();
        replace.put("[flow.creater.id]", createUserId);
        User createUser = flowInstance.getCreateUser();
        if (createUser != null) {
            replace.put("[flow.creater.deptId]", createUser.getDeptId());
        }
        if (nodeInstanceId == -1 && User.getCurrentUser() != null || nodeInstanceId > -1) {
            String sendUserId;
            User sendUser;
            if (nodeInstanceId == -1) {
                sendUser = User.getCurrentUser();
                sendUserId = sendUser.getId();
            } else {
                FlowNodeInstance nodeInstance = flowInstance.getFlowNodeInstance(nodeInstanceId);
                sendUserId = nodeInstance.getCreateUserId();
                sendUser = nodeInstance.getCreateUser();
            }
            replace.put("[flow.sender.deptId]", sendUser.getDeptId());
            replace.put("[flow.sender.id]", sendUserId);
        }
        sqlFilter = StringTool.replace(sqlFilter, replace);
        sqlFilter = flowInstance.replace(sqlFilter);
        sqlFilter = StringTool.replaceKeyWord(sqlFilter);
        return sqlFilter;
    }

    public Map getActors() {
        return this.actors;
    }

    public boolean isAppointToUser() {
        return this.appointToUser;
    }

    public String getAttachLimit() {
        return this.attachLimit;
    }

    public String getAttachTable() {
        return this.attachTable;
    }

    public String getLimit() {
        return this.limit;
    }

    public boolean isSingleOperator() {
        return this.singleOperator;
    }
}

