/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.workflow.service;

import com.sdjxd.pms.platform.base.BaseClass;
import com.sdjxd.pms.platform.base.Global;
import com.sdjxd.pms.platform.organize.Role;
import com.sdjxd.pms.platform.organize.User;
import com.sdjxd.pms.platform.tool.BeanTool;
import com.sdjxd.pms.platform.workflow.model.FlowActorBean;
import com.sdjxd.pms.platform.workflow.service.FlowAgentManager;
import com.sdjxd.pms.platform.workflow.service.FlowInstance;
import java.util.Map;

public abstract class FlowActor
extends BaseClass {
    private static String[] classNames = new String[]{"FlowActorList", "FlowActorCreater", "FlowActorNodeOperator", "FlowActorParam"};
    public static final int ACTOR_USER = 0;
    public static final int ACTOR_ROLE = 1;
    public static final int ACTOR_DEPT = 2;

    public static FlowActor createInstance(FlowActorBean model) throws Exception {
        String classPath = FlowActor.class.getPackage().getName();
        int type = model.getType();
        classPath = type <= 3 ? String.valueOf(classPath) + "." + classNames[type] : model.getData().getString(0);
        FlowActor actor = (FlowActor)BeanTool.getInstance(classPath);
        if (actor == null) {
            throw new Exception("\u6d41\u7a0b\u53c2\u4e0e\u8005\u2014\u2014\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u7c7b\uff1a" + classPath);
        }
        actor.load(model);
        return actor;
    }

    public void load(FlowActorBean model) {
    }

    public boolean isActor(FlowInstance flowInstance, int nodeInstanceId, int newNodeId) {
        Map userList = this.getActors(flowInstance, nodeInstanceId, newNodeId);
        if (userList != null && User.getCurrentUser() != null) {
            return userList.containsKey(User.getCurrentUser().getId());
        }
        return false;
    }

    public abstract Map getOriginalActors(FlowInstance var1, int var2);

    public Map getActors(FlowInstance flowInstance, int nodeInstanceId, int newNodeId) {
        return this.getActors(flowInstance, nodeInstanceId, this.getOriginalActors(flowInstance, nodeInstanceId), newNodeId);
    }

    protected Map getActors(FlowInstance flowInstance, int nodeInstanceId, Map originalActors, int newNodeId) {
        if ("1".equals(Global.getConfig("forbiddenagent"))) {
            return originalActors;
        }
        String flowId = flowInstance.getFlowId();
        FlowAgentManager flowAgentManager = FlowAgentManager.getFlowAgentManager(flowId);
        return flowAgentManager.setAgentToActor(newNodeId, originalActors);
    }

    public int getTypeOfActor(FlowInstance flowInstance, int nodeInstanceId, String userId) {
        Map users = this.getOriginalActors(flowInstance, nodeInstanceId);
        return this.getTypeOfActor(users, userId);
    }

    public int getTypeOfActor(Map users, String userId) {
        if (users.containsKey(userId)) {
            return 0;
        }
        return 1;
    }

    public static int checkGuidOfUDR(String guid) throws Exception {
        User user = User.getUser(guid);
        if (user.getId() != null && user.getId() != "" && user.getId().length() > 0) {
            return 0;
        }
        Role role = Role.getRole(guid);
        if (role.getId() != null && role.getId() != "") {
            return 1;
        }
        return 2;
    }
}

