/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.workflow.service;

import com.sdjxd.pms.platform.base.BaseObject;
import com.sdjxd.pms.platform.base.Global;
import com.sdjxd.pms.platform.cache.Cache;
import com.sdjxd.pms.platform.form.SheetConstants;
import com.sdjxd.pms.platform.form.model.Css;
import com.sdjxd.pms.platform.form.service.Form;
import com.sdjxd.pms.platform.tool.BeanTool;
import com.sdjxd.pms.platform.workflow.dao.FlowDao;
import com.sdjxd.pms.platform.workflow.model.FlowActorBean;
import com.sdjxd.pms.platform.workflow.model.FlowBean;
import com.sdjxd.pms.platform.workflow.model.FlowCellBean;
import com.sdjxd.pms.platform.workflow.model.FlowConditionBean;
import com.sdjxd.pms.platform.workflow.model.FlowDomBean;
import com.sdjxd.pms.platform.workflow.model.FlowEventBean;
import com.sdjxd.pms.platform.workflow.model.FlowFormBean;
import com.sdjxd.pms.platform.workflow.model.FlowInterFaceBean;
import com.sdjxd.pms.platform.workflow.model.FlowNodeBean;
import com.sdjxd.pms.platform.workflow.model.FlowNodeChildBean;
import com.sdjxd.pms.platform.workflow.model.FlowNodeParaBean;
import com.sdjxd.pms.platform.workflow.model.FlowParameterBean;
import com.sdjxd.pms.platform.workflow.model.FlowTransBean;
import com.sdjxd.pms.platform.workflow.model.FormVariableBean;
import com.sdjxd.pms.platform.workflow.model.FormVariableLimitBean;
import com.sdjxd.pms.platform.workflow.service.FlowActor;
import com.sdjxd.pms.platform.workflow.service.FlowCondition;
import com.sdjxd.pms.platform.workflow.service.FlowDom;
import com.sdjxd.pms.platform.workflow.service.FlowEvent;
import com.sdjxd.pms.platform.workflow.service.FlowForm;
import com.sdjxd.pms.platform.workflow.service.FlowFormInstance;
import com.sdjxd.pms.platform.workflow.service.FlowInstance;
import com.sdjxd.pms.platform.workflow.service.FlowNode;
import com.sdjxd.pms.platform.workflow.service.FlowNodeAuto;
import com.sdjxd.pms.platform.workflow.service.FlowNodeChild;
import com.sdjxd.pms.platform.workflow.service.FlowNodeEnd;
import com.sdjxd.pms.platform.workflow.service.FlowNodeStart;
import com.sdjxd.pms.platform.workflow.service.FlowParameter;
import com.sdjxd.pms.platform.workflow.service.FlowTrans;
import com.sdjxd.pms.platform.workflow.service.FormVariable;
import com.sdjxd.pms.platform.workflow.service.FormVariableLimit;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class Flow
extends BaseObject {
    private static final long serialVersionUID = 1L;
    private static Logger log;
    protected static FlowDao dao;
    public static String WF_IMGPATH;
    public static final int CELLTYPE_BEGGIN = 513;
    public static String flowtype;
    private String id;
    protected String flowVersion;
    protected int versionId;
    protected Date startUpTime;
    protected Date terminate;
    protected int showNum;
    protected String flowName;
    protected String moduleId;
    protected Date lastModifyTime;
    protected Map nodes = null;
    protected Map trans = null;
    protected Map forms;
    protected Map conditions;
    protected Map parameters;
    protected Map events;
    protected FlowNode startNode = null;
    protected FlowNode endNode = null;
    public static final int MAX_NODE_NUM = 100;
    public static final int MAX_FORM_NUM = 20;

    static {
        flowtype = "1";
        WF_IMGPATH = String.valueOf(Global.getName()) + "/pms/platform/image/flow/";
        log = Logger.getLogger(Flow.class);
        dao = FlowDao.createInstance();
        if (Global.version != null && Global.version.equals("1")) {
            flowtype = Global.version;
        }
    }

    private Flow() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Flow getFlow(String id) throws Exception {
        if (id == null || id.length() == 0) {
            return null;
        }
        Flow flow = (Flow)Cache.instance.get(id);
        if (flow == null) {
            Cache cache = Cache.instance;
            synchronized (cache) {
                flow = (Flow)Cache.instance.get(id);
                if (Global.isDebug() || flow == null) {
                    flow = new Flow();
                    flow.load(id);
                    Cache.instance.set(id, flow);
                }
            }
        }
        return flow;
    }

    public void load(String id) throws Exception {
        FlowBean model = dao.getFlowBean(id);
        this.id = id;
        this.flowVersion = model.getFlowVersion();
        this.lastModifyTime = model.getLastModifyTime();
        this.moduleId = model.getModuleId();
        this.showNum = model.getShowNum();
        this.startUpTime = model.getStartUpTime();
        this.terminate = model.getTerminate();
        this.versionId = model.getVersionId();
        this.flowName = model.getFlowName();
        this.loadConditions();
        this.loadNodes();
        this.loadTrans();
        this.loadActor();
        this.loadEvents();
        this.loadParameters();
        this.loadForms();
        this.loadFormVariable();
        this.loadFormVariableLimit();
        this.loadNodeParam();
        this.loadChildFlow();
        this.loadInterFace();
    }

    private void loadNodes() throws Exception {
        this.nodes = new HashMap();
        Map map = new HashMap();
        map = dao.getFlowNodes(this.id);
        for (Map.Entry tempEntry : map.entrySet()) {
            FlowNodeBean model = (FlowNodeBean)tempEntry.getValue();
            FlowNode fn = FlowNode.createInstance(model);
            fn.load(model);
            this.nodes.put(tempEntry.getKey(), fn);
            if (fn instanceof FlowNodeStart) {
                this.startNode = fn;
                continue;
            }
            if (!(fn instanceof FlowNodeEnd)) continue;
            this.endNode = fn;
        }
    }

    private void loadForms() throws Exception {
        this.forms = new HashMap();
        List list = new ArrayList();
        if (flowtype.equals("1")) {
            list = dao.getFlowForms(this.id);
        }
        int i = 0;
        while (i < list.size()) {
            FlowFormBean model = (FlowFormBean)list.get(i);
            FlowForm flowForm = new FlowForm();
            flowForm.load(model);
            this.forms.put(String.valueOf(model.getId()), flowForm);
            FlowNode createNode = this.getNodeById(model.getCreateNodeId());
            if (createNode != null) {
                createNode.addCreateForm(model.getId());
            }
            ++i;
        }
    }

    private void loadConditions() throws Exception {
        this.conditions = new HashMap();
        List list = new ArrayList();
        if (flowtype.equals("1")) {
            list = dao.getFlowConditions(this.id);
        }
        int i = 0;
        while (i < list.size()) {
            FlowConditionBean model = (FlowConditionBean)list.get(i);
            FlowCondition data = new FlowCondition();
            data.load(model);
            this.conditions.put(Integer.toString(data.getId()), data);
            ++i;
        }
    }

    private void loadParameters() throws Exception {
        this.parameters = new HashMap();
        Map map = new HashMap();
        map = dao.getFlowParameter(this.id);
        for (Map.Entry tempEntry : map.entrySet()) {
            FlowParameterBean model = (FlowParameterBean)tempEntry.getValue();
            FlowParameter fp = new FlowParameter();
            fp.load(model);
            this.parameters.put(tempEntry.getKey(), fp);
        }
    }

    private void loadEvents() throws Exception {
        FlowEvent data;
        FlowEventBean model;
        this.events = new HashMap();
        List list = new ArrayList();
        list = dao.getFlowEvents(this.id);
        boolean hasAfterFlowSave = false;
        int i = 0;
        while (i < list.size()) {
            model = (FlowEventBean)list.get(i);
            data = new FlowEvent();
            data.load(model);
            if (data.getNodeId() != -1) {
                FlowNode node = (FlowNode)this.nodes.get(String.valueOf(data.getNodeId()));
                if (node != null) {
                    node.addFlowEvent(data);
                }
            } else {
                this.events.put(data.getEventCode(), data);
                if ("aftersave".equals(data.getEventCode())) {
                    hasAfterFlowSave = true;
                }
            }
            ++i;
        }
        if (!hasAfterFlowSave) {
            model = new FlowEventBean();
            model.setNodeId(-1);
            model.setEventId(9);
            model.setActionType(0);
            model.setEventCode("aftersave");
            model.setAction("[[\"com.sdjxd.pms.development.workflow.FlowEvents.afterSave\",\"0\",\"1\"]]");
            data = new FlowEvent();
            data.load(model);
            this.events.put(data.getEventCode(), data);
        }
    }

    public void registerEvent(FlowInstance flowInstance) {
        for (Map.Entry entry : this.events.entrySet()) {
            FlowEvent event = (FlowEvent)entry.getValue();
            event.registerEvent(flowInstance);
        }
    }

    private void loadTrans() throws Exception {
        this.trans = new HashMap();
        List list = new ArrayList();
        list = dao.getFlowTrans(this.id);
        int i = 0;
        while (i < list.size()) {
            FlowNode node;
            FlowTransBean model = (FlowTransBean)list.get(i);
            FlowTrans data = new FlowTrans();
            data.load(model);
            FlowCondition condition = (FlowCondition)this.conditions.get(Integer.toString(model.getCondition()));
            if (condition != null) {
                data.setCondition(condition);
            }
            if (data.isUntread() || flowtype.equals("0")) {
                node = (FlowNode)this.nodes.get(String.valueOf(model.getFrom()));
                if (node != null) {
                    node.addUntreadTrans(data);
                    data.setFrom(node);
                }
                if ((node = (FlowNode)this.nodes.get(String.valueOf(model.getTo()))) != null) {
                    data.setTo(node);
                }
            } else {
                node = (FlowNode)this.nodes.get(String.valueOf(model.getFrom()));
                if (node != null) {
                    data.setFrom(node);
                    node.addNextTrans(data);
                }
                if ((node = (FlowNode)this.nodes.get(String.valueOf(model.getTo()))) != null) {
                    data.setTo(node);
                    node.addPreTrans(data);
                }
            }
            this.trans.put(String.valueOf(data.getId()), data);
            ++i;
        }
    }

    private void loadFormVariable() throws Exception {
        List list = dao.getFlowFormVariable(this.id);
        int i = 0;
        while (i < list.size()) {
            FormVariableBean model = (FormVariableBean)list.get(i);
            FormVariable fv = new FormVariable();
            fv.load(model);
            FlowForm form = (FlowForm)this.forms.get(String.valueOf(model.getFormId()));
            if (form != null) {
                form.addVariable(fv);
            }
            ++i;
        }
    }

    private void loadActor() throws Exception {
        List list = dao.getFlowActor(this.id);
        int i = 0;
        while (i < list.size()) {
            FlowActorBean model = (FlowActorBean)list.get(i);
            FlowActor fa = FlowActor.createInstance(model);
            FlowNode node = (FlowNode)this.nodes.get(String.valueOf(model.getNodeId()));
            if (node != null) {
                node.addFlowActor(fa);
            }
            ++i;
        }
    }

    private void loadFormVariableLimit() throws Exception {
        List list = dao.getFlowFormVariableLimit(this.id);
        int i = 0;
        while (i < list.size()) {
            FormVariableLimitBean model = (FormVariableLimitBean)list.get(i);
            FormVariableLimit fvl = new FormVariableLimit();
            fvl.load(model);
            FlowNode node = (FlowNode)this.nodes.get(String.valueOf(model.getNodeId()));
            if (node != null) {
                node.addVariableLimit(fvl);
            }
            ++i;
        }
    }

    private void loadNodeParam() throws Exception {
        List list = dao.getFlowNodeParam(this.id);
        int i = 0;
        while (i < list.size()) {
            FlowNodeParaBean model = (FlowNodeParaBean)list.get(i);
            FlowNode node = (FlowNode)this.nodes.get(String.valueOf(model.getFlowNodeId()));
            if (node != null) {
                node.addParameterValue(model.getParamName(), model.getParamValue());
            }
            ++i;
        }
    }

    private void loadChildFlow() throws Exception {
        List list = dao.getChildFlow(this.id);
        int i = 0;
        while (i < list.size()) {
            FlowNodeChildBean model = (FlowNodeChildBean)list.get(i);
            FlowNode node = (FlowNode)this.nodes.get(String.valueOf(model.getFlowNodeId()));
            if (node != null && node instanceof FlowNodeChild) {
                ((FlowNodeChild)node).loadChildFlow(model);
            }
            ++i;
        }
    }

    private void loadInterFace() throws Exception {
        List list = dao.getFlowInterFace(this.id);
        int i = 0;
        while (i < list.size()) {
            FlowInterFaceBean model = (FlowInterFaceBean)list.get(i);
            FlowNode node = (FlowNode)this.nodes.get(String.valueOf(model.getFlowNodeId()));
            if (node != null && node instanceof FlowNodeAuto) {
                ((FlowNodeAuto)node).addInterFace(model);
            }
            ++i;
        }
    }

    public static Flow getFlowVersion(String flowVersionId) throws Exception {
        String flowId = dao.getFlowVersionId(flowVersionId);
        return Flow.getFlow(flowId);
    }

    public static FlowInstance createInstance(String flowVersionId) throws Exception {
        FlowInstance flowInstance = null;
        Flow flow = Flow.getFlowVersion(flowVersionId);
        if (flow == null) {
            throw new Exception("\u672a\u627e\u5230\u53ef\u7528\u7684\u6d41\u7a0b\u6a21\u677f\uff01");
        }
        flowInstance = FlowInstance.create(flow);
        return flowInstance;
    }

    public String draw(FlowInstance flowInstance) throws Exception {
        StringBuffer html = new StringBuffer(2048);
        TreeMap cells = dao.getFlowCell(this.id);
        PrintWriter renderHtml = Global.getContext().getWriter();
        for (Map.Entry entry : cells.entrySet()) {
            FlowCellBean cell = (FlowCellBean)entry.getValue();
            switch (cell.getCellType()) {
                case 512: 
                case 513: 
                case 514: 
                case 519: 
                case 520: {
                    html.append(this.getNodeById(cell.getFlowCellid()).draw(cell, flowInstance));
                    break;
                }
                case 256: 
                case 257: {
                    html.append(this.getTrans(cell.getFlowCellid()).draw(cell, flowInstance));
                    break;
                }
                case 769: 
                case 770: 
                case 771: {
                    FlowDom flowDom = FlowDom.getInstance(this.transToDomBean(cell));
                    html.append(flowDom.getHtml());
                }
            }
        }
        return html.toString();
    }

    private FlowDomBean transToDomBean(FlowCellBean flowCellBean) {
        FlowDomBean flowDomBean = new FlowDomBean();
        flowDomBean.setLeft(flowCellBean.getX1());
        flowDomBean.setTop(flowCellBean.getY1());
        flowDomBean.setWidth(flowCellBean.getX2() - flowCellBean.getX1());
        flowDomBean.setHeight(flowCellBean.getY2() - flowCellBean.getY1());
        flowDomBean.setInnerText(flowCellBean.getCellLabel());
        flowDomBean.setLineWidth(flowCellBean.getLineWidth());
        switch (flowCellBean.getCellType()) {
            case 770: {
                flowDomBean.setDomClassName("FlowDomLabel");
                break;
            }
            case 769: {
                flowDomBean.setDomClassName("FlowDomRect");
                Css css = (Css)Form.getCss().get(flowCellBean.getBordercolor());
                if (css != null) {
                    String cssText = css.getValue("border-color");
                    if (cssText != null) {
                        flowDomBean.setBackgroundColor(cssText);
                        break;
                    }
                    flowDomBean.setBackgroundColor(SheetConstants.CELL.LINECOLOR);
                    break;
                }
                flowDomBean.setBackgroundColor(SheetConstants.CELL.LINECOLOR);
                break;
            }
            case 771: {
                flowDomBean.setDomClassName("FlowDomLine");
                Css css = (Css)Form.getCss().get(flowCellBean.getBordercolor());
                if (css != null) {
                    String cssText = css.getValue("border-color");
                    if (cssText != null) {
                        flowDomBean.setBackgroundColor(cssText);
                        break;
                    }
                    flowDomBean.setBackgroundColor(SheetConstants.CELL.LINECOLOR);
                    break;
                }
                flowDomBean.setBackgroundColor(SheetConstants.CELL.LINECOLOR);
            }
        }
        flowDomBean.addCssClassName(flowCellBean.getTextcolor());
        flowDomBean.addCssClassName(flowCellBean.getBordercolor());
        flowDomBean.addCssClassName(flowCellBean.getFont());
        return flowDomBean;
    }

    private String getImgCellMsg(FlowCellBean cell) {
        StringBuffer output = new StringBuffer();
        output.append("<img");
        output.append(" src='");
        output.append(WF_IMGPATH);
        if (cell.getCellType() == 513) {
            output.append("S.bmp");
        } else {
            output.append("E.bmp");
        }
        int x1 = cell.getX1();
        int y1 = cell.getY1();
        output.append("' style='position:absolute;z-index:100;left:").append(x1);
        output.append(";top:").append(y1);
        output.append(";width:").append(cell.getX2() - x1);
        output.append(";height:").append(cell.getY2() - y1);
        output.append(";rotation:0");
        output.append("'/>");
        return output.toString();
    }

    public String getModuleId() {
        return this.moduleId;
    }

    public final Map getParameters() {
        return this.parameters;
    }

    public final FlowParameter getParameter(String paramName) {
        return (FlowParameter)this.parameters.get(paramName);
    }

    public final FlowParameter getParameter(int paramId) {
        Iterator it = this.parameters.entrySet().iterator();
        FlowParameter parameter = null;
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            parameter = (FlowParameter)entry.getValue();
            if (parameter.getId() != paramId) continue;
            return parameter;
        }
        return parameter;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public FlowNode getStartNode() {
        return this.startNode;
    }

    public String getFormUrl(FlowInstance flowInstance, int nodeInstanceId, int formId) {
        FlowForm flowForm = (FlowForm)this.forms.get(Integer.toString(formId));
        if (flowForm != null) {
            return flowForm.getFormUrl(flowInstance, nodeInstanceId);
        }
        return null;
    }

    public String getFlowName() {
        return this.flowName;
    }

    public String getFormUrl(FlowInstance flowInstance, int nodeInstanceId, FlowFormInstance flowFormInstance) {
        int formId = flowFormInstance.getFlowFormId();
        FlowForm flowForm = (FlowForm)this.forms.get(Integer.toString(formId));
        if (flowForm != null) {
            return flowForm.getFormUrl(flowInstance, nodeInstanceId, flowFormInstance);
        }
        return null;
    }

    public String getFormUrl(FlowInstance flowInstance, int nodeInstanceId, FlowFormInstance flowFormInstance, String formInstanceId) {
        int formId = flowFormInstance.getFlowFormId();
        FlowForm flowForm = (FlowForm)this.forms.get(Integer.toString(formId));
        if (flowForm != null) {
            return flowForm.getFormUrl(flowInstance, nodeInstanceId, flowFormInstance, formInstanceId);
        }
        return null;
    }

    public String getFormUrl(int formId) {
        FlowForm flowForm = (FlowForm)this.forms.get(Integer.toString(formId));
        if (flowForm != null) {
            return flowForm.getFormUrl();
        }
        return "";
    }

    public static void afterModify(String flowId) {
        if (flowId == null || flowId.length() == 0) {
            return;
        }
        Flow flow = (Flow)Cache.instance.get(flowId);
        if (flow != null) {
            Cache.instance.set(flowId, null);
        }
    }

    public FlowNode getEndNode() {
        return this.endNode;
    }

    public FlowNode getNodeById(int flowNodeId) {
        if (this.nodes != null) {
            return (FlowNode)this.nodes.get(String.valueOf(flowNodeId));
        }
        return null;
    }

    public FlowTrans getTrans(int transId) {
        if (this.trans != null) {
            return (FlowTrans)this.trans.get(String.valueOf(transId));
        }
        return null;
    }

    public boolean runCondition(int conditionId, FlowInstance flowInstance) throws Exception {
        FlowCondition condition = (FlowCondition)this.conditions.get(Integer.toString(conditionId));
        if (condition != null) {
            return condition.isEnabled(flowInstance);
        }
        return false;
    }

    public String toJson() {
        StringBuffer script = new StringBuffer(1024);
        script.append("new com.sdjxd.pms.platform.workflow.Flow({");
        script.append("id:'").append(this.id).append("'");
        script.append(",name:'").append(this.flowName).append("'");
        script.append(",flowVersion:'").append(this.flowVersion).append("'");
        script.append(",versionId:").append(this.versionId);
        script.append(",nodes:").append(BeanTool.toJson(this.nodes));
        script.append(",forms:").append(BeanTool.toJson(this.forms));
        script.append("})");
        return script.toString();
    }

    public Map getNodes() {
        return this.nodes;
    }

    public FlowForm getForm(int formId) {
        return (FlowForm)this.forms.get(String.valueOf(formId));
    }

    public String getFlowVersion() {
        return this.flowVersion;
    }

    public int getVersionId() {
        return this.versionId;
    }

    public Map getForms() {
        return this.forms;
    }

    public static void setWF_IMGPATH(String appRoot) {
        WF_IMGPATH = String.valueOf(appRoot) + "/pms/platform/image/flow/";
    }
}

