/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.workflow.service;

import com.sdjxd.pms.platform.base.BaseClass;
import com.sdjxd.pms.platform.base.DataModify;
import com.sdjxd.pms.platform.tool.DateTool;
import com.sdjxd.pms.platform.tool.Guid;
import com.sdjxd.pms.platform.tool.StringTool;
import com.sdjxd.pms.platform.workflow.dao.FlowInstanceDao;
import java.util.Date;
import java.util.List;

public final class CounterSign
extends BaseClass {
    private static final long serialVersionUID = 1L;
    protected static FlowInstanceDao dao = null;
    private String m_flowInstanceId;
    private int m_nodeInstanceId;
    private String m_flowId;
    private String m_flowName;
    private int m_flowNodeId;
    private String m_flowNodeName;
    private String m_counterSignId;
    private String m_counterSignDept;
    private int m_counterSignType;
    private String m_counterSignUser;
    private Date m_counterSignTime;
    private Date m_createTime;
    private String m_createUserName;
    private String m_counterSignContent;
    private DataModify modify;

    static {
        dao = FlowInstanceDao.createInstance();
    }

    public static CounterSign create(String flowInstanceId, int nodeInstanceId, String flowId, String flowName, int flowNodeId, String flowNodeName, String counterSignDept, int counterSignType) {
        CounterSign counterSign = new CounterSign();
        counterSign.m_flowInstanceId = flowInstanceId;
        counterSign.m_nodeInstanceId = nodeInstanceId;
        counterSign.m_flowId = flowId;
        counterSign.m_flowName = flowName;
        counterSign.m_flowNodeId = flowNodeId;
        counterSign.m_flowNodeName = flowNodeName;
        counterSign.m_counterSignId = Guid.create();
        counterSign.m_counterSignDept = counterSignDept;
        counterSign.m_counterSignType = counterSignType;
        counterSign.m_createTime = new Date();
        counterSign.modify = DataModify.NEW;
        return counterSign;
    }

    public static CounterSign submitCounterSign(String counterSignId, String counterSignUser, Date counterSignTime, String counterSignContent) {
        CounterSign counterSign = new CounterSign();
        counterSign.m_counterSignId = counterSignId;
        counterSign.submit(counterSignUser, counterSignTime, counterSignContent);
        return counterSign;
    }

    public void submit(String counterSignUser, Date counterSignTime, String counterSignContent) {
        this.m_counterSignUser = counterSignUser;
        this.m_counterSignTime = counterSignTime;
        this.m_counterSignContent = counterSignContent;
        if (!DataModify.NEW.is(this.modify)) {
            this.modify = DataModify.MODIFY;
        }
    }

    public void save() throws Exception {
        dao.saveCounterSign(this);
    }

    public static CounterSign delete(String flowInstanceId, int flowNodeInstanceId) throws Exception {
        CounterSign counterSign = new CounterSign();
        counterSign.m_flowInstanceId = flowInstanceId;
        counterSign.m_nodeInstanceId = flowNodeInstanceId;
        counterSign.modify = DataModify.DELETE;
        return counterSign;
    }

    public static boolean check(String counterSignId, String userId) throws Exception {
        boolean success = dao.checkCounterSign(counterSignId, userId);
        return success;
    }

    public static List copy(String flowInstanceId, int oldNodeInstanceId, int newNodeInstanceId) throws Exception {
        return dao.copyCounterSign(flowInstanceId, oldNodeInstanceId, newNodeInstanceId);
    }

    public String getCounterSignTimeString() {
        return DateTool.formatDateTime(this.m_counterSignTime) == null ? "" : DateTool.formatDateTime(this.m_counterSignTime);
    }

    public Date getCreateTime() {
        return this.m_createTime;
    }

    public String getCreateTimeString() {
        return DateTool.formatDateTime(this.m_createTime) == null ? "" : DateTool.formatDateTime(this.m_createTime);
    }

    public String getCreateUserName() {
        return this.m_createUserName;
    }

    public String getFlowId() {
        return this.m_flowId;
    }

    public String getFlowInstanceId() {
        return this.m_flowInstanceId;
    }

    public String getFlowName() {
        return this.m_flowName;
    }

    public int getFlowNodeId() {
        return this.m_flowNodeId;
    }

    public String getFlowNodeName() {
        return this.m_flowNodeName;
    }

    public int getNodeInstanceId() {
        return this.m_nodeInstanceId;
    }

    public String getCounterSignContent() {
        if (StringTool.isEmpty(this.m_counterSignContent)) {
            return "";
        }
        return this.m_counterSignContent;
    }

    public String getCounterSignDept() {
        return this.m_counterSignDept;
    }

    public String getCounterSignId() {
        return this.m_counterSignId;
    }

    public Date getCounterSignTime() {
        return this.m_counterSignTime;
    }

    public String getCounterSignUser() {
        if (StringTool.isEmpty(this.m_counterSignUser)) {
            return "";
        }
        return this.m_counterSignUser;
    }

    public DataModify getModify() {
        return this.modify;
    }

    public int getCounterSignType() {
        return this.m_counterSignType;
    }
}

