/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.workflow.dao.db2;

import com.sdjxd.pms.platform.base.DataModify;
import com.sdjxd.pms.platform.data.DbOper;
import com.sdjxd.pms.platform.organize.User;
import com.sdjxd.pms.platform.tool.DateTool;
import com.sdjxd.pms.platform.tool.Guid;
import com.sdjxd.pms.platform.tool.StringTool;
import com.sdjxd.pms.platform.workflow.model.FlowInstanceBean;
import com.sdjxd.pms.platform.workflow.model.FlowNodeInstanceBean;
import com.sdjxd.pms.platform.workflow.model.FlowOperatorBean;
import com.sdjxd.pms.platform.workflow.model.FlowReceiverBean;
import com.sdjxd.pms.platform.workflow.service.CounterSign;
import com.sdjxd.pms.platform.workflow.service.FlowFormInstance;
import com.sdjxd.pms.platform.workflow.service.FlowInstance;
import com.sdjxd.pms.platform.workflow.service.FlowNodeInstance;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.sql.RowSet;
import org.apache.log4j.Logger;

public class FlowInstanceDao
extends com.sdjxd.pms.platform.workflow.dao.FlowInstanceDao {
    private static Logger daoLogger = Logger.getLogger((String)"FlowInstanceDao");

    @Override
    public boolean checkCounterSign(String counterSignId, String userId) throws Exception {
        boolean success = false;
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("SELECT 1 FROM [S].JXD7_WF_COUNTERSIGN WHERE COUNTERSIGNID='").append(counterSignId);
        sqlBuffer.append("' AND ((COUNTERSIGNTYPE=0 AND COUNTERSIGNDEPT='").append(userId).append("')");
        sqlBuffer.append(" OR (COUNTERSIGNTYPE=2 AND EXISTS(SELECT 1 FROM JXD7_XT_USER U,JXD7_XT_ORGANISE O1,JXD7_XT_ORGANISE O2 WHERE U.DEPTID=O1.ORGANISEID AND locate(O2.ORGANISELEVEL,O1.ORGANISELEVEL)>0 AND U.USERID='").append(userId).append("' AND O2.ORGANISEID=COUNTERSIGNDEPT))");
        sqlBuffer.append(" OR (COUNTERSIGNTYPE=1 AND EXISTS(SELECT 1 FROM JXD7_XT_USERROLE R WHERE R.ROLEID=COUNTERSIGNDEPT AND R.USERID='").append(userId).append("')))");
        String sql2 = sqlBuffer.toString();
        try {
            success = DbOper.executeQueryObject("defaultds", sql2) != null;
        }
        catch (SQLException exp) {
            daoLogger.error((Object)("\u68c0\u67e5\u4f1a\u7b7e\u6743\u9650\u5931\u8d25,\u9519\u8bef\u4e3a:" + exp.getMessage() + "\nsql\u4e3a\uff1a" + sql2));
            throw exp;
        }
        return success;
    }

    @Override
    public List copyCounterSign(String flowInstanceId, int oldNodeInstanceId, int newNodeInstanceId) throws Exception {
        ArrayList<CounterSign> counterSigns = new ArrayList<CounterSign>();
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("SELECT COUNTERSIGNID,FLOWID,FLOWNAME,FLOWNODEID,FLOWNODENAME,CREATETIME,COUNTERSIGNDEPT,COUNTERSIGNTYPE,COUNTERSIGNTIME,COUNTERSIGNUSER,COUNTERSIGNCONTENT,ISCOMPLET FROM [S].JXD7_WF_COUNTERSIGN WHERE FLOWINSTANCEID='").append(flowInstanceId);
        sqlBuffer.append("' AND NODEINSTANCEID=").append(oldNodeInstanceId).append("");
        String sql2 = sqlBuffer.toString();
        try {
            RowSet rs = DbOper.executeQuery("defaultds", sql2);
            while (rs.next()) {
                CounterSign counterSign = CounterSign.create(flowInstanceId, newNodeInstanceId, rs.getString("FLOWID"), rs.getString("FLOWNAME"), rs.getInt("FLOWNODEID"), rs.getString("FLOWNODENAME"), rs.getString("COUNTERSIGNDEPT"), rs.getInt("COUNTERSIGNTYPE"));
                counterSign.submit(rs.getString("COUNTERSIGNUSER"), DateTool.parseDate(rs.getString("COUNTERSIGNTIME")), rs.getString("COUNTERSIGNCONTENT"));
                counterSigns.add(counterSign);
            }
        }
        catch (SQLException exp) {
            daoLogger.error((Object)("\u590d\u5236\u4f1a\u7b7e\u4fe1\u606f\u5931\u8d25,\u9519\u8bef\u4e3a:" + exp.getMessage() + "\nsql\u4e3a\uff1a" + sql2));
            throw exp;
        }
        return counterSigns;
    }

    @Override
    public void saveNodeInstance(FlowNodeInstanceBean model, DataModify curModify) throws SQLException {
        StringBuffer sql2 = new StringBuffer(512);
        if (DataModify.NEW.is(curModify)) {
            sql2.append("INSERT INTO [S].JXD7_WF_NODEINSTANCE");
            sql2.append("(");
            sql2.append("\tFLOWINSTANCEID,");
            sql2.append("\tNODEINSTANCEID,");
            sql2.append("\tFLOWID,");
            sql2.append("\tFLOWNAME,");
            sql2.append("\tFLOWNODEID,");
            sql2.append("\tFLOWNODENAME,");
            sql2.append("\tSTATUSNAME,");
            sql2.append("\tRUNSTATUS,");
            sql2.append("\tRUNSTATUSNOTE_START,");
            sql2.append("\tRUNSTATUSNOTE_STOP,");
            sql2.append("\tTAKESTATUS,");
            sql2.append("\tBEGINTIME,");
            sql2.append("\tENDTIME,");
            sql2.append("\tPRENODEINSTANCEIDS,");
            sql2.append("\tNEXTNODEINSTANCEIDS,");
            sql2.append("\tVPRENODEINSTANCEID,");
            sql2.append("\tVNEXTNODEINSTANCEID,");
            sql2.append("\tCREATEDATE,");
            sql2.append("\tCREATEUSERID,");
            sql2.append("\tCREATEUSERNAME,");
            sql2.append("\tOPENERID,");
            sql2.append("\tOPENERNAME,");
            sql2.append("\tOVERTIME,");
            sql2.append("\tLASTOPENTIME,NOTES");
            sql2.append(")");
            sql2.append("VALUES");
            sql2.append("(");
            sql2.append(StringTool.format("'{0}',", model.getFlowInstanceId()));
            sql2.append(StringTool.format(" {0} ,", String.valueOf(model.getNodeInstanceId())));
            sql2.append(StringTool.format("'{0}',", model.getFlowId()));
            sql2.append(StringTool.format("'{0}',", model.getFlowName()));
            sql2.append(StringTool.format(" {0} ,", String.valueOf(model.getFlowNodeId())));
            sql2.append(StringTool.format("'{0}',", model.getFlowNodeName()));
            sql2.append(StringTool.format("'{0}',", model.getStatusName()));
            sql2.append(StringTool.format(" {0} ,", String.valueOf(model.getRunStatus())));
            sql2.append(StringTool.format(" {0} ,", String.valueOf(model.getRunStatusNoteStart())));
            sql2.append(StringTool.format(" {0} ,", String.valueOf(model.getRunStatusNoteStop())));
            sql2.append(StringTool.format(" {0} ,", String.valueOf(model.getTakeStatus())));
            sql2.append(StringTool.format("'{0}',", model.getBeginTimeString()));
            sql2.append(StringTool.format("'{0}',", model.getEndTimeString()));
            sql2.append(StringTool.format("'{0}',", model.getPreNodeInstanceIdsString()));
            sql2.append(StringTool.format("'{0}',", model.getNextNodeInstanceIdsString()));
            sql2.append(StringTool.format(" {0},", model.getvPreNodeInstanceId()));
            sql2.append(StringTool.format(" {0},", model.getvNextNodeInstanceId()));
            sql2.append(StringTool.format("'{0}',", model.getCreateTimeString()));
            sql2.append(StringTool.format("'{0}',", model.getCreateUserId()));
            sql2.append(StringTool.format("'{0}',", model.getCreateUserName()));
            sql2.append(StringTool.format("'{0}',", model.getOpenerId()));
            sql2.append(StringTool.format("'{0}',", model.getOpenerName()));
            sql2.append(StringTool.format("'{0}',", model.getOverTimeString()));
            sql2.append(StringTool.format("'{0}', ", model.getOpenerTimeString()));
            sql2.append(StringTool.format("'{0}'", model.getNotes()));
            sql2.append(")");
        } else {
            sql2.append("UPDATE [S].JXD7_WF_NODEINSTANCE");
            sql2.append(" SET ");
            sql2.append(StringTool.format("\tFLOWNODENAME = '{0}',", model.getFlowNodeName()));
            sql2.append(StringTool.format("\tSTATUSNAME = '{0}',", model.getStatusName()));
            sql2.append(StringTool.format("\tRUNSTATUS = {0},", String.valueOf(model.getRunStatus())));
            sql2.append(StringTool.format("\tRUNSTATUSNOTE_START = {0},", String.valueOf(model.getRunStatusNoteStart())));
            sql2.append(StringTool.format("\tRUNSTATUSNOTE_STOP = {0},", String.valueOf(model.getRunStatusNoteStop())));
            sql2.append(StringTool.format("\tTAKESTATUS = {0},", String.valueOf(model.getTakeStatus())));
            sql2.append(StringTool.format("\tBEGINTIME = '{0}',", model.getBeginTimeString()));
            sql2.append(StringTool.format("\tENDTIME = '{0}',", model.getEndTimeString()));
            sql2.append(StringTool.format("\tPRENODEINSTANCEIDS = '{0}',", model.getPreNodeInstanceIdsString()));
            sql2.append(StringTool.format("\tNEXTNODEINSTANCEIDS = '{0}',", model.getNextNodeInstanceIdsString()));
            sql2.append(StringTool.format("\tVPRENODEINSTANCEID = {0},", model.getvPreNodeInstanceId()));
            sql2.append(StringTool.format("\tVNEXTNODEINSTANCEID = {0},", model.getvNextNodeInstanceId()));
            sql2.append(StringTool.format("\tCREATEDATE = '{0}',", model.getCreateTimeString()));
            sql2.append(StringTool.format("\tCREATEUSERID = '{0}',", model.getCreateUserId()));
            sql2.append(StringTool.format("\tCREATEUSERNAME = '{0}',", model.getCreateUserName()));
            sql2.append(StringTool.format("\tOPENERID = '{0}',", model.getOpenerId()));
            sql2.append(StringTool.format("\tOPENERNAME = '{0}',", model.getOpenerName()));
            sql2.append(StringTool.format("\tOVERTIME = '{0}',", model.getOverTimeString()));
            sql2.append(StringTool.format("\tNOTES = '{0}',", model.getNotes()));
            sql2.append(StringTool.format("\tLASTOPENTIME = '{0}'", model.getOpenerTimeString()));
            sql2.append(StringTool.format(" WHERE   FLOWINSTANCEID='{0}'", model.getFlowInstanceId()));
            sql2.append(StringTool.format("    AND NODEINSTANCEID={0}", String.valueOf(model.getNodeInstanceId())));
        }
        String sqlText = sql2.toString();
        try {
            DbOper.executeNonQuery("defaultds", sqlText);
        }
        catch (SQLException e) {
            daoLogger.error((Object)("\u5c06\u8282\u70b9\u5b9e\u4f8b\u4fdd\u5b58\u5230\u6570\u636e\u5e93\u51fa\u73b0\u9519\u8bef \u9519\u8bef\u7684Sql\u8bed\u53e5\u4e3a\uff1a\n" + sql2 + "\n \u9519\u8bef\u4fe1\u606f\uff1a" + e.getMessage()));
            throw e;
        }
    }

    @Override
    public void saveNodeInstanceReceiver(FlowReceiverBean model, DataModify curDataModify) throws SQLException {
        StringBuffer sql2 = new StringBuffer();
        if (DataModify.NEW.is(curDataModify)) {
            sql2.append("INSERT INTO [S].JXD7_WF_RECEIVER");
            sql2.append("(");
            sql2.append("FLOWINSTANCEID,");
            sql2.append("NODEINSTANCEID,");
            sql2.append("OPERATOR,");
            sql2.append("OPERATORNAME,");
            sql2.append("BEGINTIME,");
            sql2.append("ENDTIME,");
            sql2.append("TYPE");
            sql2.append(")");
            sql2.append("VALUES");
            sql2.append("(");
            sql2.append(StringTool.format("'{0}',", model.getFlowInstanceId()));
            sql2.append(StringTool.format("{0},", String.valueOf(model.getNodeInstanceId())));
            sql2.append(StringTool.format("'{0}',", model.getOperatorId()));
            sql2.append(StringTool.format("'{0}',", model.getOperatorName()));
            sql2.append(StringTool.format("'{0}',", model.getBeginTimeString()));
            sql2.append(StringTool.format("'{0}', ", model.getEndTimeString()));
            sql2.append(StringTool.format(" {0} ", String.valueOf(model.getType())));
            sql2.append(")");
        } else if (DataModify.DELETE.is(curDataModify)) {
            sql2.append("DELETE FROM [S].JXD7_WF_RECEIVER");
            sql2.append(StringTool.format(" WHERE FLOWINSTANCEID='{0}'", model.getFlowInstanceId()));
            sql2.append(StringTool.format(" AND NODEINSTANCEID={0}", String.valueOf(model.getNodeInstanceId())));
            sql2.append(StringTool.format(" AND OPERATOR = '{0}'", model.getOperatorId()));
        } else {
            sql2.append("UPDATE [S].JXD7_WF_RECEIVER");
            sql2.append(" SET ");
            sql2.append(StringTool.format("\tBEGINTIME = '{0}',", model.getBeginTimeString()));
            sql2.append(StringTool.format("\tENDTIME = '{0}'", model.getEndTimeString()));
            sql2.append(StringTool.format(" WHERE FLOWINSTANCEID='{0}'", model.getFlowInstanceId()));
            sql2.append(StringTool.format(" AND NODEINSTANCEID={0}", String.valueOf(model.getNodeInstanceId())));
            sql2.append(StringTool.format(" AND OPERATOR = '{0}'", model.getOperatorId()));
        }
        String sqlText = sql2.toString();
        try {
            DbOper.executeNonQuery("defaultds", sqlText);
        }
        catch (SQLException e) {
            daoLogger.error((Object)("\u5c06\u8282\u70b9\u5b9e\u4f8b\u63a5\u6536\u4eba\u4fe1\u606f\u4fdd\u5b58\u5230\u6570\u636e\u5e93\u51fa\u73b0\u9519\u8bef \u9519\u8bef\u7684Sql\u8bed\u53e5\u4e3a\uff1a\n" + sql2 + "\n \u9519\u8bef\u4fe1\u606f\uff1a" + e.getMessage()));
            throw e;
        }
    }

    @Override
    public void saveNodeInstanceOperator(FlowOperatorBean model, DataModify curDataModify) throws SQLException {
        StringBuffer sql2 = new StringBuffer();
        if (DataModify.NEW.is(curDataModify)) {
            sql2.append("INSERT INTO [S].JXD7_WF_OPERATOR");
            sql2.append("(");
            sql2.append("FLOWINSTANCEID,");
            sql2.append("NODEINSTANCEID,");
            sql2.append("OPERATOR,");
            sql2.append("OPERATORNAME,");
            sql2.append("BEGINTIME,");
            sql2.append("ENDTIME,");
            sql2.append("TYPE");
            sql2.append(")");
            sql2.append("VALUES");
            sql2.append("(");
            sql2.append(StringTool.format("'{0}',", model.getFlowInstanceId()));
            sql2.append(StringTool.format("{0},", String.valueOf(model.getNodeInstanceId())));
            sql2.append(StringTool.format("'{0}',", model.getOperatorId()));
            sql2.append(StringTool.format("'{0}',", model.getOperatorName()));
            sql2.append(StringTool.format("'{0}',", model.getBeginTimeString()));
            sql2.append(StringTool.format("'{0}', ", model.getEndTimeString()));
            sql2.append(StringTool.format(" {0} ", String.valueOf(0)));
            sql2.append(")");
        } else if (DataModify.DELETE.is(curDataModify)) {
            sql2.append("DELETE FROM [S].JXD7_WF_OPERATOR");
            sql2.append(StringTool.format(" WHERE FLOWINSTANCEID='{0}'", model.getFlowInstanceId()));
            sql2.append(StringTool.format(" AND NODEINSTANCEID={0}", String.valueOf(model.getNodeInstanceId())));
            sql2.append(StringTool.format(" AND OPERATOR = '{0}'", model.getOperatorId()));
        } else {
            sql2.append("UPDATE [S].JXD7_WF_OPERATOR");
            sql2.append(" SET ");
            sql2.append(StringTool.format("\tBEGINTIME = '{0}',", model.getBeginTimeString()));
            sql2.append(StringTool.format("\tENDTIME = '{0}'", model.getEndTimeString()));
            sql2.append(StringTool.format(" WHERE FLOWINSTANCEID='{0}'", model.getFlowInstanceId()));
            sql2.append(StringTool.format(" AND NODEINSTANCEID={0}", String.valueOf(model.getNodeInstanceId())));
            sql2.append(StringTool.format(" AND OPERATOR = '{0}'", model.getOperatorId()));
        }
        String sqlText = sql2.toString();
        try {
            DbOper.executeNonQuery("defaultds", sqlText);
        }
        catch (SQLException e) {
            daoLogger.error((Object)("\u5c06\u8282\u70b9\u5b9e\u4f8b\u5904\u7406\u4eba\u4fe1\u606f\u4fdd\u5b58\u5230\u6570\u636e\u5e93\u51fa\u73b0\u9519\u8bef \u9519\u8bef\u7684Sql\u8bed\u53e5\u4e3a\uff1a\n" + sql2 + "\n \u9519\u8bef\u4fe1\u606f\uff1a" + e.getMessage()));
            throw e;
        }
    }

    @Override
    public int doc2Run(String flowInstanceId) throws Exception {
        int success = 1;
        FlowInstanceBean flowInstance = FlowInstanceDao.createInstance().getFlowInstance(flowInstanceId);
        if (flowInstance.getRunStatus() == 1) {
            String receiverType = "";
            String receiverId = "";
            try {
                StringBuffer recesql = new StringBuffer();
                recesql.append("SELECT OPERATOR,TYPE FROM JXD7_WF_RECEIVER WHERE ");
                recesql.append(StringTool.format("FLOWINSTANCEID='{0}'", flowInstanceId));
                recesql.append("AND NODEINSTANCEID=(SELECT MAX(NODEINSTANCEID) FROM JXD7_WF_RECEIVER WHERE flowinstanceid='");
                recesql.append(flowInstanceId).append("')");
                RowSet rs = DbOper.executeQuery(recesql.toString());
                if (rs.next()) {
                    receiverType = rs.getString("TYPE");
                    receiverId = rs.getString("OPERATOR");
                }
            }
            catch (Exception recesql) {
                // empty catch block
            }
            String[] sqls = new String[5];
            StringBuffer sql2 = new StringBuffer(512);
            sql2.append("UPDATE [S].JXD7_WF_INSTANCE");
            sql2.append(" SET ");
            sql2.append("ENDDATE='' ,");
            sql2.append(StringTool.format("RUNSTATUS={0} ", String.valueOf(0)));
            sql2.append(" WHERE ");
            sql2.append(StringTool.format("FLOWINSTANCEID='{0}'", flowInstanceId));
            sql2.append(StringTool.format(" AND RUNSTATUS={0} ", String.valueOf(1)));
            sqls[0] = sql2.toString();
            sql2.setLength(0);
            sql2.append("INSERT INTO JXD7_WF_NODEINSTANCE ");
            sql2.append("select FLOWINSTANCEID,");
            sql2.append("(SELECT MAX(NODEINSTANCEID)+1 FROM jxd7_wf_nodeinstance WHERE flowinstanceid='");
            sql2.append(flowInstanceId).append("') as NODEINSTANCEID,");
            sql2.append("FLOWID,FLOWNAME,FLOWNODEID,FLOWNODENAME,STATUSNAME,0 AS RUNSTATUS,");
            sql2.append("'").append(DateTool.getNow()).append("' as BEGINTIME,");
            sql2.append("'' as ENDTIME,");
            sql2.append("'['||(SELECT trim(char(bigint(MAX(NODEINSTANCEID)))) FROM jxd7_wf_nodeinstance WHERE flowinstanceid='");
            sql2.append(flowInstanceId).append("')||']' as PRENODEINSTANCEIDS,");
            sql2.append("'").append(DateTool.getNow()).append("' as CREATEDATE,");
            sql2.append("'").append(User.getCurrentUser().getId()).append("' AS CREATEUSERID,");
            sql2.append("'").append(User.getCurrentUser().getName()).append("' AS CREATEUSERNAME,");
            sql2.append("'' AS OPENERID,'' AS OPENERNAME,'' AS LASTOPENTIME,");
            sql2.append("TAKESTATUS,'' AS OVERTIME,'' AS NOTES ");
            sql2.append("from JXD7_WF_NODEINSTANCE WHERE ");
            sql2.append("FLOWINSTANCEID='").append(flowInstanceId).append("' ");
            sql2.append("AND NODEINSTANCEID=(SELECT MAX(NODEINSTANCEID)-1 FROM jxd7_wf_nodeinstance WHERE flowinstanceid='");
            sql2.append(flowInstanceId).append("')");
            sqls[1] = sql2.toString();
            sql2.setLength(0);
            sql2.append("INSERT INTO JXD7_WF_RECEIVER ");
            sql2.append("select FLOWINSTANCEID,");
            sql2.append("(SELECT MAX(NODEINSTANCEID) FROM JXD7_WF_NODEINSTANCE WHERE flowinstanceid='");
            sql2.append(flowInstanceId).append("') AS NODEINSTANCEID,");
            sql2.append("OPERATOR,OPERATORNAME,");
            sql2.append("'' as BEGINTIME,");
            sql2.append("'' AS ENDTIME,TYPE ");
            sql2.append(" from JXD7_WF_RECEIVER WHERE ");
            sql2.append(StringTool.format("FLOWINSTANCEID='{0}'", flowInstanceId));
            sql2.append("AND NODEINSTANCEID=(SELECT MAX(NODEINSTANCEID) FROM JXD7_WF_OPERATOR WHERE flowinstanceid='");
            sql2.append(flowInstanceId).append("')");
            sqls[2] = sql2.toString();
            sql2.setLength(0);
            sql2.append("INSERT INTO JXD7_WF_OPERATOR ");
            sql2.append("select FLOWINSTANCEID,");
            sql2.append("(SELECT MAX(NODEINSTANCEID) FROM JXD7_WF_NODEINSTANCE WHERE flowinstanceid='");
            sql2.append(flowInstanceId).append("') AS NODEINSTANCEID,");
            sql2.append("OPERATOR,OPERATORNAME,");
            sql2.append("'").append(DateTool.getNow()).append("' as BEGINTIME,");
            sql2.append("'' AS ENDTIME,TYPE ");
            sql2.append(" from JXD7_WF_OPERATOR WHERE ");
            sql2.append(StringTool.format("FLOWINSTANCEID='{0}'", flowInstanceId));
            sql2.append("AND NODEINSTANCEID=(SELECT MAX(NODEINSTANCEID) FROM JXD7_WF_RECEIVER WHERE flowinstanceid='");
            sql2.append(flowInstanceId).append("')");
            sqls[3] = sql2.toString();
            FlowInstance flowinstance = FlowInstance.load(flowInstanceId);
            FlowNodeInstance nodeinstance = flowinstance.getLastNodeInstance();
            int[] instanceids = nodeinstance.getPreNodeInstanceIds();
            FlowNodeInstance prenode = flowinstance.getFlowNodeInstance(instanceids[0]);
            int flowFormId = prenode.getDefaultForm();
            FlowFormInstance flowFormInstance = flowinstance.getForm(flowFormId);
            int nodeInstanceId = nodeinstance.getNodeInstanceId() + 1;
            String operUrl = "/flow.do?i=" + flowInstanceId;
            String operId = String.valueOf(flowinstance.getId()) + String.valueOf(nodeInstanceId);
            String operName = flowinstance.getFlowName();
            User currentUser = User.getCurrentUser();
            String sender = currentUser != null ? currentUser.getId() : "";
            StringBuffer sqlBuffer = new StringBuffer();
            sqlBuffer.append("INSERT INTO [S].JXD7_XT_WAITDO(WAITDOID,OPERID,OPERNAME,OPERURL,SENDER,RECEIVERTYPE,RECEIVER,SENDTIME)");
            sqlBuffer.append(" VALUES ('").append(Guid.create()).append("'");
            sqlBuffer.append(",'").append(operId).append("'");
            sqlBuffer.append(",'").append(operName).append("'");
            sqlBuffer.append(",'").append(operUrl).append("'");
            sqlBuffer.append(",'").append(sender).append("'");
            sqlBuffer.append(",'").append(receiverType).append("'");
            sqlBuffer.append(",'").append(receiverId).append("'");
            sqlBuffer.append(",'").append(DateTool.getNow()).append("')");
            sqls[4] = sqlBuffer.toString();
            try {
                DbOper.executeNonQuery("defaultds", sqls);
                success = 0;
            }
            catch (SQLException e) {
                daoLogger.error((Object)("\u5c06\u6d41\u7a0b\u5b9e\u4f8b\u590d\u6d3b\u51fa\u73b0\u9519\u8bef \u9519\u8bef\u7684Sql\u8bed\u53e5\u4e3a\uff1a\n" + sqls[0] + "\n " + sqls[1] + "\n " + sqls[2] + "\n " + sqls[3] + "\n " + sqls[4] + "\n \u9519\u8bef\u4fe1\u606f\uff1a" + e.getMessage()));
                throw e;
            }
        }
        success = 2;
        return success;
    }

    @Override
    public void insertHandInfo(String flowInstanceId, int flowNodeInstanceId) throws SQLException {
        String sqlText = "SELECT COUNT(*) AS HANGS FROM [S].JXD7_WF_HANG WHERE FLOWINSTANCEID='" + flowInstanceId + "' AND NODEINSTANCEID=" + flowNodeInstanceId;
        try {
            RowSet rs = DbOper.executeQuery("defaultds", sqlText);
            int handCount = 0;
            if (rs.next()) {
                handCount = rs.getInt("HANGS");
            }
            ++handCount;
            User user = User.getCurrentUser();
            String userId = "";
            if (user != null) {
                userId = user.getId();
            }
            StringBuffer sql2 = new StringBuffer();
            sql2.append("INSERT INTO [S].JXD7_WF_HANG");
            sql2.append("(");
            sql2.append("\tFLOWINSTANCEID,");
            sql2.append("\tNODEINSTANCEID,");
            sql2.append("\tHANDORDER,");
            sql2.append("\tHANGTIME,");
            sql2.append("\tRESUME,");
            sql2.append("\tHANDERID,");
            sql2.append("\tRESUMERID,");
            sql2.append("\tTIMESLICE");
            sql2.append(")");
            sql2.append("VALUES");
            sql2.append("(");
            sql2.append("\t'" + flowInstanceId + "',");
            sql2.append("\t" + flowNodeInstanceId + ",");
            sql2.append("\t" + handCount + ",");
            sql2.append("\t'" + DateTool.getNow() + "',");
            sql2.append("\t'',");
            sql2.append("\t'" + userId + "',");
            sql2.append("\t'',");
            sql2.append("\t0");
            sql2.append(")");
            sqlText = sql2.toString();
            DbOper.executeNonQuery("defaultds", sqlText);
        }
        catch (SQLException e) {
            daoLogger.error((Object)("\u5c06\u6d41\u7a0b\u7684\u6302\u8d77\u4fe1\u606f\u63d2\u5165\u5230\u6570\u636e\u5e93\u51fa\u73b0\u9519\u8bef \u9519\u8bef\u7684Sql\u8bed\u53e5\u4e3a\uff1a\n" + sqlText + "\n \u9519\u8bef\u4fe1\u606f\uff1a" + e.getMessage()));
            throw e;
        }
    }
}

