/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.workflow.dao;

import com.sdjxd.pms.platform.base.DataModify;
import com.sdjxd.pms.platform.base.DataStatus;
import com.sdjxd.pms.platform.base.dao.BaseDao;
import com.sdjxd.pms.platform.data.DbOper;
import com.sdjxd.pms.platform.organize.User;
import com.sdjxd.pms.platform.tool.BeanTool;
import com.sdjxd.pms.platform.tool.DateTool;
import com.sdjxd.pms.platform.tool.Guid;
import com.sdjxd.pms.platform.tool.StringTool;
import com.sdjxd.pms.platform.workflow.model.FlowChildInstanceBean;
import com.sdjxd.pms.platform.workflow.model.FlowFormInstanceBean;
import com.sdjxd.pms.platform.workflow.model.FlowInstanceBean;
import com.sdjxd.pms.platform.workflow.model.FlowInterFaceInstanceBean;
import com.sdjxd.pms.platform.workflow.model.FlowNodeInstanceBean;
import com.sdjxd.pms.platform.workflow.model.FlowOperatorBean;
import com.sdjxd.pms.platform.workflow.model.FlowParamInstanceBean;
import com.sdjxd.pms.platform.workflow.model.FlowReceiverBean;
import com.sdjxd.pms.platform.workflow.service.CounterSign;
import com.sdjxd.pms.platform.workflow.service.FlowFormInstance;
import com.sdjxd.pms.platform.workflow.service.FlowInstance;
import com.sdjxd.pms.platform.workflow.service.FlowNodeInstance;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.RowSet;
import org.apache.log4j.Logger;
import org.jfree.util.Log;

public class FlowInstanceDao
extends BaseDao {
    private static Logger daoLogger = Logger.getLogger((String)"FlowInstanceDao");

    public static FlowInstanceDao createInstance() {
        return (FlowInstanceDao)FlowInstanceDao.createInstance(FlowInstanceDao.class, "defaultds");
    }

    public FlowInstanceBean getFlowInstance(String flowInstanceId) throws SQLException {
        FlowInstanceBean model = new FlowInstanceBean();
        String sql2 = "SELECT FLOWID,FLOWNAME,FLOWINSTANCENAME,CREATEDATE,ENDDATE,CREATEUSER,CREATEUSERNAME,DATASTATUSID,RUNSTATUS,VERSION,OPENER,OPENERID,LASTOPENTIME FROM [S].JXD7_WF_INSTANCE WHERE FLOWINSTANCEID='" + flowInstanceId + "' AND (DATASTATUSID IS NULL OR DATASTATUSID<>'" + DataStatus.DELETE.getId() + "')";
        try {
            RowSet rs = DbOper.executeQuery("defaultds", sql2);
            while (rs.next()) {
                model.setId(flowInstanceId);
                model.setName(rs.getString("FLOWINSTANCENAME"));
                model.setFlowId(rs.getString("FLOWID"));
                model.setFlowName(rs.getString("FLOWNAME"));
                model.setCreateDate(rs.getString("CREATEDATE"));
                model.setEndDate(rs.getString("ENDDATE"));
                model.setCreateUserId(rs.getString("CREATEUSER"));
                model.setCreateUserName(rs.getString("CREATEUSERNAME"));
                model.setDataStatus(DataStatus.getInstance(rs.getInt("DATASTATUSID")));
                model.setRunStatus(rs.getInt("RUNSTATUS"));
                model.setVersion(rs.getString("VERSION"));
                model.setOpener(rs.getString("OPENER"));
                model.setOpenerId(rs.getString("OPENERID"));
                model.setLastopentime(rs.getString("LASTOPENTIME"));
            }
        }
        catch (SQLException exp) {
            daoLogger.error((Object)("\u8bfb\u53d6\u6d41\u7a0b\u5b9e\u4f8b\u9519\u8bef,\u9519\u8bef\u7684Sql\u8bed\u53e5\u4e3a\uff1a\n" + sql2 + "\n FlowInstanceDao.FlowInstanceBean\u9519\u8bef\u4fe1\u606f\uff1a" + exp.getMessage()));
            throw exp;
        }
        return model;
    }

    public FlowInstanceBean getFlowInstanceByForm(String formInstanceId) throws SQLException {
        FlowInstanceBean model = new FlowInstanceBean();
        String sql2 = "SELECT I.FLOWINSTANCEID,FLOWID,FLOWNAME,FLOWINSTANCENAME,CREATEDATE,ENDDATE,CREATEUSER,CREATEUSERNAME,DATASTATUSID,RUNSTATUS FROM [S].JXD7_WF_INSTANCE I,[S].JXD7_WF_FORMINSTANCE F WHERE I.FLOWINSTANCEID=F.FLOWINSTANCEID AND F.FORMINSTANCEID='" + formInstanceId + "'";
        try {
            RowSet rs = DbOper.executeQuery("defaultds", sql2);
            if (rs.next()) {
                model.setId(rs.getString("FLOWINSTANCEID"));
                model.setName(rs.getString("FLOWINSTANCENAME"));
                model.setFlowId(rs.getString("FLOWID"));
                model.setFlowName(rs.getString("FLOWNAME"));
                model.setCreateDate(rs.getString("CREATEDATE"));
                model.setEndDate(rs.getString("ENDDATE"));
                model.setCreateUserId(rs.getString("CREATEUSER"));
                model.setCreateUserName(rs.getString("CREATEUSERNAME"));
                model.setDataStatus(DataStatus.getInstance(rs.getInt("DATASTATUSID")));
                model.setRunStatus(rs.getInt("RUNSTATUS"));
            }
        }
        catch (SQLException exp) {
            daoLogger.error((Object)("\u8bfb\u53d6\u6d41\u7a0b\u5b9e\u4f8b\u9519\u8bef,\u9519\u8bef\u7684Sql\u8bed\u53e5\u4e3a\uff1a\n" + sql2 + "\n FlowInstanceDao.FlowInstanceBean\u9519\u8bef\u4fe1\u606f\uff1a" + exp.getMessage()));
            throw exp;
        }
        return model;
    }

    public List getFlowNodeInstance(String flowInstanceId) throws SQLException {
        ArrayList<FlowNodeInstanceBean> list = new ArrayList<FlowNodeInstanceBean>();
        String sql2 = "SELECT NODEINSTANCEID,FLOWID,FLOWNAME,FLOWNODEID,FLOWNODENAME,STATUSNAME,RUNSTATUS,TAKESTATUS,BEGINTIME,OVERTIME,ENDTIME,PRENODEINSTANCEIDS,CREATEDATE,CREATEUSERID,CREATEUSERNAME,OPENERID,OPENERNAME,LASTOPENTIME,NOTES,NEXTNODEINSTANCEIDS,VNEXTNODEINSTANCEID,VPRENODEINSTANCEID,RUNSTATUSNOTE_START,RUNSTATUSNOTE_STOP ,ISAUTODEAL FROM [S].JXD7_WF_NODEINSTANCE WHERE FLOWINSTANCEID='" + flowInstanceId + "'";
        try {
            RowSet rs = DbOper.executeQuery("defaultds", sql2);
            while (rs.next()) {
                FlowNodeInstanceBean model = new FlowNodeInstanceBean();
                model.setFlowInstanceId(flowInstanceId);
                model.setNodeInstanceId(rs.getInt("NODEINSTANCEID"));
                model.setFlowId(rs.getString("FLOWID"));
                model.setFlowName(rs.getString("FLOWNAME"));
                model.setFlowNodeId(rs.getInt("FLOWNODEID"));
                model.setFlowNodeName(rs.getString("FLOWNODENAME"));
                model.setStatusName(rs.getString("STATUSNAME"));
                model.setRunStatus(rs.getInt("RUNSTATUS"));
                model.setTakeStatus(rs.getInt("TAKESTATUS"));
                model.setBeginTime(DateTool.parseDate(rs.getString("BEGINTIME")));
                model.setOverTime(DateTool.parseDate(rs.getString("OVERTIME")));
                model.setEndTime(DateTool.parseDate(rs.getString("ENDTIME")));
                model.setPreNodeInstanceIds(rs.getString("PRENODEINSTANCEIDS"));
                model.setNextNodeInstanceIds(rs.getString("NEXTNODEINSTANCEIDS"));
                model.setvNextNodeInstanceId(rs.getInt("VNEXTNODEINSTANCEID"));
                model.setvPreNodeInstanceId(rs.getInt("VPRENODEINSTANCEID"));
                model.setRunStatusNoteStart(rs.getInt("RUNSTATUSNOTE_START"));
                model.setRunStatusNoteStop(rs.getInt("RUNSTATUSNOTE_STOP"));
                model.setCreateTime(DateTool.parseDate(rs.getString("CREATEDATE")));
                model.setCreateUserId(rs.getString("CREATEUSERID"));
                model.setCreateUserName(rs.getString("CREATEUSERNAME"));
                model.setOpenerId(rs.getString("OPENERID"));
                model.setOpenerName(rs.getString("OPENERNAME"));
                model.setOpenerTime(DateTool.parseDate(rs.getString("LASTOPENTIME")));
                model.setNotes(rs.getString("NOTES"));
                model.setIsAutoDeal(rs.getString("ISAUTODEAL"));
                list.add(model);
            }
        }
        catch (SQLException exp) {
            daoLogger.error((Object)("\u8bfb\u53d6\u6d41\u7a0b\u8282\u70b9\u5b9e\u4f8b\u9519\u8bef,\u9519\u8bef\u7684Sql\u8bed\u53e5\u4e3a\uff1a\n" + sql2 + "\n FlowInstanceDao.getFlowNodeInstance\u9519\u8bef\u4fe1\u606f\uff1a" + exp.getMessage()));
            throw exp;
        }
        return list;
    }

    public List getFlowParamInstance(String flowInstanceId) throws SQLException {
        ArrayList<FlowParamInstanceBean> list = new ArrayList<FlowParamInstanceBean>();
        String sql2 = " SELECT FLOWINSTANCEID,PARAMNAME,PARAMVALUE FROM [S].JXD7_WF_PARAMINSTANCE WHERE FLOWINSTANCEID='" + flowInstanceId + "'";
        try {
            RowSet rs = DbOper.executeQuery("defaultds", sql2);
            while (rs.next()) {
                FlowParamInstanceBean model = new FlowParamInstanceBean();
                model.setFlowInstanceId(rs.getString("FLOWINSTANCEID"));
                model.setParamName(rs.getString("PARAMNAME"));
                model.setParamValue(rs.getString("PARAMVALUE"));
                list.add(model);
            }
        }
        catch (SQLException exp) {
            daoLogger.error((Object)("\u8bfb\u53d6\u6d41\u7a0b\u53c2\u6570\u5b9e\u4f8b\u9519\u8bef,\u9519\u8bef\u7684Sql\u8bed\u53e5\u4e3a\uff1a\n" + sql2 + "\n FlowInstanceDao.getFlowNodeInstance\u9519\u8bef\u4fe1\u606f\uff1a" + exp.getMessage()));
            throw exp;
        }
        return list;
    }

    public Map getFlowReceiver(String flowInstanceId) throws SQLException {
        HashMap map = new HashMap();
        ArrayList<FlowReceiverBean> list = new ArrayList<FlowReceiverBean>();
        FlowReceiverBean model = null;
        String sql2 = "SELECT FLOWINSTANCEID,NODEINSTANCEID,OPERATOR,OPERATORNAME,BEGINTIME,ENDTIME,TYPE  FROM [S].JXD7_WF_RECEIVER WHERE FLOWINSTANCEID='" + flowInstanceId + "'" + " ORDER BY NODEINSTANCEID";
        int curNodeInstanceId = -1;
        try {
            RowSet rs = DbOper.executeQuery("defaultds", sql2);
            while (rs.next()) {
                model = new FlowReceiverBean();
                model.setFlowInstanceId(rs.getString("FLOWINSTANCEID"));
                model.setNodeInstanceId(rs.getInt("NODEINSTANCEID"));
                model.setOperatorId(rs.getString("OPERATOR"));
                model.setOperatorName(rs.getString("OPERATORNAME"));
                model.setBeginTime(DateTool.parseDate(rs.getString("BEGINTIME")));
                model.setEndTime(DateTool.parseDate(rs.getString("ENDTIME")));
                model.setType(rs.getInt("TYPE"));
                if (model.getNodeInstanceId() != curNodeInstanceId && curNodeInstanceId != -1) {
                    map.put(String.valueOf(curNodeInstanceId), list);
                    list = new ArrayList();
                }
                curNodeInstanceId = model.getNodeInstanceId();
                list.add(model);
            }
            if (model != null) {
                map.put(String.valueOf(curNodeInstanceId), list);
            }
        }
        catch (SQLException exp) {
            daoLogger.error((Object)("\u8bfb\u53d6\u6d41\u7a0b\u8282\u70b9\u5b9e\u4f8b\u63a5\u6536\u4eba\u4fe1\u606f\u9519\u8bef,\u9519\u8bef\u7684Sql\u8bed\u53e5\u4e3a\uff1a\n" + sql2 + "\n FlowInstanceDao.getFlowReceiver\u9519\u8bef\u4fe1\u606f\uff1a" + exp.getMessage()));
            throw exp;
        }
        return map;
    }

    public Map getFlowOperator(String flowInstanceId) throws SQLException {
        HashMap map = new HashMap();
        ArrayList<FlowOperatorBean> list = new ArrayList<FlowOperatorBean>();
        FlowOperatorBean model = null;
        String sql2 = "SELECT FLOWINSTANCEID,NODEINSTANCEID,OPERATOR,OPERATORNAME,BEGINTIME,ENDTIME,TYPE  FROM [S].JXD7_WF_OPERATOR WHERE FLOWINSTANCEID='" + flowInstanceId + "'" + " ORDER BY NODEINSTANCEID";
        int curNodeInstanceId = -1;
        try {
            RowSet rs = DbOper.executeQuery("defaultds", sql2);
            while (rs.next()) {
                model = new FlowOperatorBean();
                model.setFlowInstanceId(rs.getString("FLOWINSTANCEID"));
                model.setNodeInstanceId(rs.getInt("NODEINSTANCEID"));
                model.setOperatorId(rs.getString("OPERATOR"));
                model.setOperatorName(rs.getString("OPERATORNAME"));
                model.setBeginTime(DateTool.parseDate(rs.getString("BEGINTIME")));
                model.setEndTime(DateTool.parseDate(rs.getString("ENDTIME")));
                if (model.getNodeInstanceId() != curNodeInstanceId && curNodeInstanceId != -1) {
                    map.put(String.valueOf(curNodeInstanceId), list);
                    list = new ArrayList();
                }
                curNodeInstanceId = model.getNodeInstanceId();
                list.add(model);
            }
            if (model != null) {
                map.put(String.valueOf(curNodeInstanceId), list);
            }
        }
        catch (SQLException exp) {
            daoLogger.error((Object)("\u8bfb\u53d6\u6d41\u7a0b\u8282\u70b9\u5b9e\u4f8b\u5904\u7406\u4eba\u4fe1\u606f\u9519\u8bef,\u9519\u8bef\u7684Sql\u8bed\u53e5\u4e3a\uff1a\n" + sql2 + "\n FlowInstanceDao.getFlowOperator\u9519\u8bef\u4fe1\u606f\uff1a" + exp.getMessage()));
            throw exp;
        }
        return map;
    }

    public List getFlowFormInstance(String flowInstanceId) throws SQLException {
        ArrayList<FlowFormInstanceBean> list = new ArrayList<FlowFormInstanceBean>();
        String sql2 = " SELECT FLOWINSTANCEID, FLOWFORMID, FORMINSTANCEID FROM [S].JXD7_WF_FORMINSTANCE WHERE FLOWINSTANCEID='" + flowInstanceId + "'";
        try {
            RowSet rs = DbOper.executeQuery("defaultds", sql2);
            while (rs.next()) {
                FlowFormInstanceBean model = new FlowFormInstanceBean();
                model.setFlowInstanceId(flowInstanceId);
                model.setFlowFormId(rs.getInt("FLOWFORMID"));
                model.setFormInstanceId(rs.getString("FORMINSTANCEID"));
                list.add(model);
            }
        }
        catch (SQLException exp) {
            daoLogger.error((Object)("\u8bfb\u53d6\u6d41\u7a0b\u8868\u5355\u5b9e\u4f8b\u4fe1\u606f\u9519\u8bef,\u9519\u8bef\u7684Sql\u8bed\u53e5\u4e3a\uff1a\n" + sql2 + "\n FlowInstanceDao.getFlowNodeInstance\u9519\u8bef\u4fe1\u606f\uff1a" + exp.getMessage()));
            throw exp;
        }
        return list;
    }

    public List getChildInstance(String flowInstanceId) throws SQLException {
        ArrayList<FlowChildInstanceBean> list = new ArrayList<FlowChildInstanceBean>();
        String sql2 = "SELECT\tFLOWNODEID,CHILDFLOWINSTANCEID  FROM\t[S].JXD7_WF_CHILDFLOWINSTANCE  WHERE FLOWINSTANCEID='" + flowInstanceId + "'";
        try {
            RowSet rs = DbOper.executeQuery("defaultds", sql2);
            while (rs.next()) {
                FlowChildInstanceBean model = new FlowChildInstanceBean();
                model.setFlowInstanceId(flowInstanceId);
                model.setFlowNodeId(rs.getInt("FLOWNODEID"));
                model.setChildInstanceId(rs.getString("CHILDFLOWINSTANCEID"));
                list.add(model);
            }
        }
        catch (SQLException exp) {
            daoLogger.error((Object)("\u8bfb\u53d6\u6d41\u7a0b\u5b9e\u4f8b\u7684\u6240\u6709\u5b50\u6d41\u7a0b\u5b9e\u4f8b\u7684\u4fe1\u606f\u9519\u8bef,\u9519\u8bef\u7684Sql\u8bed\u53e5\u4e3a\uff1a\n" + sql2 + "\n \u9519\u8bef\u4fe1\u606f\uff1a" + exp.getMessage()));
            throw exp;
        }
        return list;
    }

    public List getInterFaceInstance(String flowInstanceId) throws SQLException {
        ArrayList<FlowInterFaceInstanceBean> list = new ArrayList<FlowInterFaceInstanceBean>();
        String sql2 = "SELECT INSTANCEID,FLOWINSTANCEID,NODEINSTANCEID,INTERFACEID,CALLNUM,CALLTIME,PARAMVALUE,COMPLETTIME,RETURNVALUE,CALLSTATUS FROM [S].JXD7_WF_INTERFACEINSTANCE WHERE FLOWINSTANCEID='" + flowInstanceId + "'";
        try {
            RowSet rs = DbOper.executeQuery("defaultds", sql2);
            while (rs.next()) {
                FlowInterFaceInstanceBean model = new FlowInterFaceInstanceBean();
                model.setInstanceId(rs.getString("INSTANCEID"));
                model.setFlowInstanceId(flowInstanceId);
                model.setNodeInstanceId(rs.getInt("NODEINSTANCEID"));
                model.setInterfaceId(rs.getString("INTERFACEID"));
                model.setCallNum(rs.getInt("CALLNUM"));
                model.setCallTime(rs.getString("CALLTIME"));
                model.setParamValue(rs.getString("PARAMVALUE"));
                model.setCompletTime(rs.getString("COMPLETTIME"));
                model.setReturnValue(rs.getString("RETURNVALUE"));
                model.setCallStatus(rs.getInt("CALLSTATUS"));
                model.setDataModify(DataModify.SAVED);
                list.add(model);
            }
        }
        catch (SQLException exp) {
            daoLogger.error((Object)("\u8bfb\u53d6\u6d41\u7a0b\u5b9e\u4f8b\u7684\u6240\u6709\u5916\u90e8\u63a5\u53e3\u8c03\u7528\u9519\u8bef,\u9519\u8bef\u7684Sql\u8bed\u53e5\u4e3a\uff1a\n" + sql2 + "\n \u9519\u8bef\u4fe1\u606f\uff1a" + exp.getMessage()));
            throw exp;
        }
        return list;
    }

    public List getInterFaceInstanceById(String instanceId) throws SQLException {
        ArrayList<FlowInterFaceInstanceBean> list = new ArrayList<FlowInterFaceInstanceBean>();
        String sql2 = "SELECT INSTANCEID,FLOWINSTANCEID,NODEINSTANCEID,INTERFACEID,CALLNUM,CALLTIME,PARAMVALUE,COMPLETTIME,RETURNVALUE,CALLSTATUS FROM [S].JXD7_WF_INTERFACEINSTANCE WHERE INSTANCEID='" + instanceId + "'";
        try {
            RowSet rs = DbOper.executeQuery("defaultds", sql2);
            while (rs.next()) {
                FlowInterFaceInstanceBean model = new FlowInterFaceInstanceBean();
                model.setInstanceId(rs.getString("INSTANCEID"));
                model.setFlowInstanceId(rs.getString("FLOWINSTANCEID"));
                model.setNodeInstanceId(rs.getInt("NODEINSTANCEID"));
                model.setInterfaceId(rs.getString("INTERFACEID"));
                model.setCallNum(rs.getInt("CALLNUM"));
                model.setCallTime(rs.getString("CALLTIME"));
                model.setParamValue(rs.getString("PARAMVALUE"));
                model.setCompletTime(rs.getString("COMPLETTIME"));
                model.setReturnValue(rs.getString("RETURNVALUE"));
                model.setCallStatus(rs.getInt("CALLSTATUS"));
                model.setDataModify(DataModify.SAVED);
                list.add(model);
            }
        }
        catch (SQLException exp) {
            daoLogger.error((Object)("\u8bfb\u53d6\u5916\u90e8\u63a5\u53e3\u8c03\u7528\u9519\u8bef,\u9519\u8bef\u7684Sql\u8bed\u53e5\u4e3a\uff1a\n" + sql2 + "\n \u9519\u8bef\u4fe1\u606f\uff1a" + exp.getMessage()));
            throw exp;
        }
        return list;
    }

    public void saveInterFaceInstance(FlowInterFaceInstanceBean model, DataModify curDataModify) throws SQLException {
        StringBuffer sql2 = new StringBuffer(512);
        if (DataModify.NEW.is(curDataModify)) {
            sql2.append("INSERT INTO [S].JXD7_WF_INTERFACEINSTANCE");
            sql2.append("(");
            sql2.append("INSTANCEID,");
            sql2.append("FLOWINSTANCEID,");
            sql2.append("NODEINSTANCEID,");
            sql2.append("INTERFACEID ,");
            sql2.append("CALLNUM,");
            sql2.append("CALLTIME,");
            sql2.append("PARAMVALUE,");
            sql2.append("COMPLETTIME,");
            sql2.append("RETURNVALUE,");
            sql2.append("CALLSTATUS");
            sql2.append(")");
            sql2.append("VALUES");
            sql2.append("(");
            sql2.append(StringTool.format("'{0}',", model.getInstanceId()));
            sql2.append(StringTool.format("'{0}',", model.getFlowInstanceId()));
            sql2.append(StringTool.format("{0},", String.valueOf(model.getNodeInstanceId())));
            sql2.append(StringTool.format("'{0}',", model.getInterfaceId()));
            sql2.append(StringTool.format("{0},", String.valueOf(model.getCallNum())));
            sql2.append(StringTool.format("'{0}',", model.getCallTime()));
            sql2.append(StringTool.format("'{0}',", BeanTool.toJson(model.getParamValue())));
            sql2.append(StringTool.format("'{0}',", model.getCompletTime()));
            sql2.append(StringTool.format("'{0}',", model.getStrReturnValue()));
            sql2.append(StringTool.format("{0}", String.valueOf(model.getCallStatus())));
            sql2.append(")");
        } else {
            sql2.append("UPDATE [S].JXD7_WF_INTERFACEINSTANCE");
            sql2.append(" SET ");
            sql2.append(StringTool.format("COMPLETTIME='{0}' ,", model.getCompletTime()));
            sql2.append(StringTool.format("RETURNVALUE='{0}' ,", model.getStrReturnValue()));
            sql2.append(StringTool.format("CALLSTATUS={0} ", String.valueOf(model.getCallStatus())));
            sql2.append(" WHERE ");
            sql2.append(StringTool.format("FLOWINSTANCEID='{0}'", model.getFlowInstanceId()));
            sql2.append(StringTool.format(" AND NODEINSTANCEID={0}", String.valueOf(model.getNodeInstanceId())));
            sql2.append(StringTool.format(" AND INTERFACEID='{0}'", model.getInterfaceId()));
            sql2.append(StringTool.format(" AND CALLNUM={0}", String.valueOf(model.getCallNum())));
        }
        String sqlText = sql2.toString();
        try {
            DbOper.executeNonQuery("defaultds", sqlText);
        }
        catch (SQLException e) {
            daoLogger.error((Object)("\u5c06\u5916\u90e8\u63a5\u53e3\u8c03\u7528\u5b9e\u4f8b\u4fdd\u5b58\u5230\u6570\u636e\u5e93\u51fa\u73b0\u9519\u8bef \u9519\u8bef\u7684Sql\u8bed\u53e5\u4e3a\uff1a\n" + sql2 + "\n \u9519\u8bef\u4fe1\u606f\uff1a" + e.getMessage()));
            throw e;
        }
    }

    public void saveInstance(FlowInstanceBean model, DataModify curDataModify) throws SQLException {
        StringBuffer sql2 = new StringBuffer(512);
        if (DataModify.NEW.is(curDataModify)) {
            sql2.append("INSERT INTO [S].JXD7_WF_INSTANCE");
            sql2.append("(");
            sql2.append("FLOWINSTANCEID,");
            sql2.append("FLOWID,");
            sql2.append("FLOWNAME ,");
            sql2.append("FLOWINSTANCENAME,");
            sql2.append("CREATEDATE,");
            sql2.append("ENDDATE,");
            sql2.append("CREATEUSER,");
            sql2.append("CREATEUSERNAME,");
            sql2.append("DATASTATUSID,");
            sql2.append("VERSION,");
            sql2.append("OPENER,");
            sql2.append("OPENERID,");
            sql2.append("LASTOPENTIME,");
            sql2.append("RUNSTATUS");
            sql2.append(")");
            sql2.append("VALUES");
            sql2.append("(");
            sql2.append(StringTool.format("'{0}',", model.getId()));
            sql2.append(StringTool.format("'{0}',", model.getFlowId()));
            sql2.append(StringTool.format("'{0}',", model.getFlowName()));
            sql2.append(StringTool.format("'{0}',", model.getName()));
            sql2.append(StringTool.format("'{0}',", model.getCreateDateString()));
            sql2.append(StringTool.format("'{0}',", model.getEndDateString()));
            sql2.append(StringTool.format("'{0}',", model.getCreateUserId()));
            sql2.append(StringTool.format("'{0}',", model.getCreateUserName()));
            sql2.append(StringTool.format("'{0}',", String.valueOf(model.getDataStatusInt())));
            sql2.append(StringTool.format("'{0}',", model.getVersion()));
            sql2.append(StringTool.format("'{0}',", model.getOpener()));
            sql2.append(StringTool.format("'{0}',", model.getOpenerId()));
            sql2.append(StringTool.format("'{0}',", model.getLastopentime()));
            sql2.append(StringTool.format(" {0} ", String.valueOf(model.getRunStatus())));
            sql2.append(")");
        } else {
            sql2.append("UPDATE [S].JXD7_WF_INSTANCE");
            sql2.append(" SET ");
            sql2.append(StringTool.format("FLOWINSTANCENAME='{0}' ,", model.getName()));
            sql2.append(StringTool.format("ENDDATE='{0}' ,", model.getEndDateString()));
            sql2.append(StringTool.format("DATASTATUSID='{0}' ,", String.valueOf(model.getDataStatusInt())));
            sql2.append(StringTool.format("RUNSTATUS='{0}',", String.valueOf(model.getRunStatus())));
            sql2.append(StringTool.format("OPENER='{0}',", String.valueOf(model.getOpener())));
            sql2.append(StringTool.format("OPENERID='{0}',", String.valueOf(model.getOpenerId())));
            sql2.append(StringTool.format("LASTOPENTIME='{0}'", String.valueOf(model.getLastopentime())));
            sql2.append(" WHERE ");
            sql2.append(StringTool.format("FLOWINSTANCEID='{0}'", model.getId()));
        }
        String sqlText = sql2.toString();
        try {
            DbOper.executeNonQuery("defaultds", sqlText);
        }
        catch (SQLException e) {
            daoLogger.error((Object)("\u5c06\u6d41\u7a0b\u5b9e\u4f8b\u4fdd\u5b58\u5230\u6570\u636e\u5e93\u51fa\u73b0\u9519\u8bef \u9519\u8bef\u7684Sql\u8bed\u53e5\u4e3a\uff1a\n" + sql2 + "\n \u9519\u8bef\u4fe1\u606f\uff1a" + e.getMessage()));
            throw e;
        }
    }

    public void saveNodeInstance(FlowNodeInstanceBean model, DataModify curModify) throws SQLException {
        StringBuffer sql2 = new StringBuffer(512);
        if (DataModify.NEW.is(curModify)) {
            sql2.append("INSERT INTO [S].JXD7_WF_NODEINSTANCE");
            sql2.append("(");
            sql2.append("\tFLOWINSTANCEID,");
            sql2.append("\tNODEINSTANCEID,");
            sql2.append("\tFLOWID,");
            sql2.append("\tFLOWNAME,");
            sql2.append("\tFLOWNODEID,");
            sql2.append("\tFLOWNODENAME,");
            sql2.append("\tSTATUSNAME,");
            sql2.append("\tRUNSTATUS,");
            sql2.append("\tRUNSTATUSNOTE_START,");
            sql2.append("\tRUNSTATUSNOTE_STOP,");
            sql2.append("\tTAKESTATUS,");
            sql2.append("\tBEGINTIME,");
            sql2.append("\tENDTIME,");
            sql2.append("\tPRENODEINSTANCEIDS,");
            sql2.append("\tNEXTNODEINSTANCEIDS,");
            sql2.append("\tVPRENODEINSTANCEID,");
            sql2.append("\tVNEXTNODEINSTANCEID,");
            sql2.append("\tCREATEDATE,");
            sql2.append("\tCREATEUSERID,");
            sql2.append("\tCREATEUSERNAME,");
            sql2.append("\tOPENERID,");
            sql2.append("\tOPENERNAME,");
            sql2.append("\tOVERTIME,");
            sql2.append("\tLASTOPENTIME,NOTES");
            sql2.append("    ,ISAUTODEAL");
            sql2.append(")");
            sql2.append("VALUES");
            sql2.append("(");
            sql2.append(StringTool.format("'{0}',", model.getFlowInstanceId()));
            sql2.append(StringTool.format(" {0} ,", String.valueOf(model.getNodeInstanceId())));
            sql2.append(StringTool.format("'{0}',", model.getFlowId()));
            sql2.append(StringTool.format("'{0}',", model.getFlowName()));
            sql2.append(StringTool.format(" {0} ,", String.valueOf(model.getFlowNodeId())));
            sql2.append(StringTool.format("'{0}',", model.getFlowNodeName()));
            sql2.append(StringTool.format("'{0}',", model.getStatusName()));
            sql2.append(StringTool.format(" {0} ,", String.valueOf(model.getRunStatus())));
            sql2.append(StringTool.format(" {0} ,", String.valueOf(model.getRunStatusNoteStart())));
            sql2.append(StringTool.format(" {0} ,", String.valueOf(model.getRunStatusNoteStop())));
            sql2.append(StringTool.format(" {0} ,", String.valueOf(model.getTakeStatus())));
            sql2.append(StringTool.format("'{0}',", model.getBeginTimeString()));
            sql2.append(StringTool.format("'{0}',", model.getEndTimeString()));
            sql2.append(StringTool.format("'{0}',", model.getPreNodeInstanceIdsString()));
            sql2.append(StringTool.format("'{0}',", model.getNextNodeInstanceIdsString()));
            sql2.append(StringTool.format("'{0}',", model.getvPreNodeInstanceId()));
            sql2.append(StringTool.format("'{0}',", model.getvNextNodeInstanceId()));
            sql2.append(StringTool.format("'{0}',", model.getCreateTimeString()));
            sql2.append(StringTool.format("'{0}',", model.getCreateUserId()));
            sql2.append(StringTool.format("'{0}',", model.getCreateUserName()));
            sql2.append(StringTool.format("'{0}',", model.getOpenerId()));
            sql2.append(StringTool.format("'{0}',", model.getOpenerName()));
            sql2.append(StringTool.format("'{0}',", model.getOverTimeString()));
            sql2.append(StringTool.format("'{0}', ", model.getOpenerTimeString()));
            sql2.append(StringTool.format("'{0}'", model.getNotes()));
            sql2.append(StringTool.format(",'{0}'", model.getIsAutoDeal()));
            sql2.append(")");
        } else {
            sql2.append("UPDATE [S].JXD7_WF_NODEINSTANCE");
            sql2.append(" SET ");
            sql2.append(StringTool.format("\tFLOWNODENAME = '{0}',", model.getFlowNodeName()));
            sql2.append(StringTool.format("\tSTATUSNAME = '{0}',", model.getStatusName()));
            sql2.append(StringTool.format("\tRUNSTATUS = '{0}',", String.valueOf(model.getRunStatus())));
            sql2.append(StringTool.format("\tRUNSTATUSNOTE_START = '{0}',", String.valueOf(model.getRunStatusNoteStart())));
            sql2.append(StringTool.format("\tRUNSTATUSNOTE_STOP = '{0}',", String.valueOf(model.getRunStatusNoteStop())));
            sql2.append(StringTool.format("\tTAKESTATUS = '{0}',", String.valueOf(model.getTakeStatus())));
            sql2.append(StringTool.format("\tBEGINTIME = '{0}',", model.getBeginTimeString()));
            sql2.append(StringTool.format("\tENDTIME = '{0}',", model.getEndTimeString()));
            sql2.append(StringTool.format("\tPRENODEINSTANCEIDS = '{0}',", model.getPreNodeInstanceIdsString()));
            sql2.append(StringTool.format("\tNEXTNODEINSTANCEIDS = '{0}',", model.getNextNodeInstanceIdsString()));
            sql2.append(StringTool.format("\tVPRENODEINSTANCEID = '{0}',", model.getvPreNodeInstanceId()));
            sql2.append(StringTool.format("\tVNEXTNODEINSTANCEID = '{0}',", model.getvNextNodeInstanceId()));
            sql2.append(StringTool.format("\tCREATEDATE = '{0}',", model.getCreateTimeString()));
            sql2.append(StringTool.format("\tCREATEUSERID = '{0}',", model.getCreateUserId()));
            sql2.append(StringTool.format("\tCREATEUSERNAME = '{0}',", model.getCreateUserName()));
            sql2.append(StringTool.format("\tOPENERID = '{0}',", model.getOpenerId()));
            sql2.append(StringTool.format("\tOPENERNAME = '{0}',", model.getOpenerName()));
            sql2.append(StringTool.format("\tOVERTIME = '{0}',", model.getOverTimeString()));
            sql2.append(StringTool.format("\tNOTES = '{0}',", model.getNotes()));
            sql2.append(StringTool.format("\tLASTOPENTIME = '{0}'", model.getOpenerTimeString()));
            sql2.append(StringTool.format(" WHERE   FLOWINSTANCEID='{0}'", model.getFlowInstanceId()));
            sql2.append(StringTool.format("    AND NODEINSTANCEID='{0}'", String.valueOf(model.getNodeInstanceId())));
        }
        String sqlText = sql2.toString();
        try {
            DbOper.executeNonQuery("defaultds", sqlText);
        }
        catch (SQLException e) {
            daoLogger.error((Object)("\u5c06\u8282\u70b9\u5b9e\u4f8b\u4fdd\u5b58\u5230\u6570\u636e\u5e93\u51fa\u73b0\u9519\u8bef \u9519\u8bef\u7684Sql\u8bed\u53e5\u4e3a\uff1a\n" + sql2 + "\n \u9519\u8bef\u4fe1\u606f\uff1a" + e.getMessage()));
            throw e;
        }
    }

    public void saveUntread(FlowNodeInstanceBean model, String reason) throws SQLException {
        StringBuffer sql2 = new StringBuffer(512);
        sql2.append("INSERT INTO [S].JXD7_WF_UNTREAD");
        sql2.append("(");
        sql2.append("\tFLOWINSTANCEID,");
        sql2.append("\tNODEINSTANCEID,");
        sql2.append("\tREASON,");
        sql2.append("\tCREATEDATE,");
        sql2.append("\tCREATEUSERID,");
        sql2.append("\tCREATEUSERNAME");
        sql2.append(")");
        sql2.append("VALUES");
        sql2.append("(");
        sql2.append(StringTool.format("'{0}',", model.getFlowInstanceId()));
        sql2.append(StringTool.format(" {0} ,", String.valueOf(model.getNodeInstanceId())));
        sql2.append(StringTool.format("'{0}',", reason));
        sql2.append(StringTool.format("'{0}',", model.getCreateTimeString()));
        sql2.append(StringTool.format("'{0}',", model.getCreateUserId()));
        sql2.append(StringTool.format("'{0}'", model.getCreateUserName()));
        sql2.append(")");
        String sqlText = sql2.toString();
        try {
            DbOper.executeNonQuery("defaultds", sqlText);
        }
        catch (SQLException e) {
            daoLogger.error((Object)("\u5c06\u8282\u70b9\u5b9e\u4f8b\u9000\u56de\u4fe1\u606f\u4fdd\u5b58\u5230\u6570\u636e\u5e93\u51fa\u73b0\u9519\u8bef \u9519\u8bef\u7684Sql\u8bed\u53e5\u4e3a\uff1a\n" + sql2 + "\n \u9519\u8bef\u4fe1\u606f\uff1a" + e.getMessage()));
            throw e;
        }
    }

    public void saveParamInstance(FlowParamInstanceBean model, DataModify curModify) throws SQLException {
        StringBuffer sql2 = new StringBuffer();
        if (DataModify.NEW.is(curModify)) {
            sql2.append("INSERT INTO [S].JXD7_WF_PARAMINSTANCE");
            sql2.append("(");
            sql2.append("\tFLOWINSTANCEID,");
            sql2.append("\tPARAMNAME,");
            sql2.append("\tPARAMVALUE");
            sql2.append(")");
            sql2.append("VALUES");
            sql2.append("(");
            sql2.append(StringTool.format("\t'{0}',", model.getFlowInstanceId()));
            sql2.append(StringTool.format("\t'{0}',", model.getParamName()));
            sql2.append(StringTool.format("\t'{0}'", model.getParamValue()));
            sql2.append(")");
        } else {
            sql2.append("UPDATE [S].JXD7_WF_PARAMINSTANCE");
            sql2.append(" SET ");
            sql2.append(StringTool.format("\tPARAMVALUE = '{0}'", model.getParamValue()));
            sql2.append(StringTool.format(" WHERE FLOWINSTANCEID='{0}'", model.getFlowInstanceId()));
            sql2.append(StringTool.format(" AND PARAMNAME = '{0}'", model.getParamName()));
        }
        String sqlText = sql2.toString();
        try {
            DbOper.executeNonQuery("defaultds", sqlText);
        }
        catch (SQLException e) {
            daoLogger.error((Object)("\u5c06\u8282\u70b9\u5b9e\u4f8b\u53c2\u6570\u4fe1\u606f\u4eba\u4fdd\u5b58\u5230\u6570\u636e\u5e93\u51fa\u73b0\u9519\u8bef \u9519\u8bef\u7684Sql\u8bed\u53e5\u4e3a\uff1a\n" + sql2 + "\n \u9519\u8bef\u4fe1\u606f\uff1a" + e.getMessage()));
            throw e;
        }
    }

    public void saveNodeInstanceReceiver(FlowReceiverBean model, DataModify curDataModify) throws SQLException {
        StringBuffer sql2 = new StringBuffer();
        if (DataModify.NEW.is(curDataModify)) {
            sql2.append("INSERT INTO [S].JXD7_WF_RECEIVER");
            sql2.append("(");
            sql2.append("FLOWINSTANCEID,");
            sql2.append("NODEINSTANCEID,");
            sql2.append("OPERATOR,");
            sql2.append("OPERATORNAME,");
            sql2.append("BEGINTIME,");
            sql2.append("ENDTIME,");
            sql2.append("TYPE");
            sql2.append(")");
            sql2.append("VALUES");
            sql2.append("(");
            sql2.append(StringTool.format("'{0}',", model.getFlowInstanceId()));
            sql2.append(StringTool.format("'{0}',", String.valueOf(model.getNodeInstanceId())));
            sql2.append(StringTool.format("'{0}',", model.getOperatorId()));
            sql2.append(StringTool.format("'{0}',", model.getOperatorName()));
            sql2.append(StringTool.format("'{0}',", model.getBeginTimeString()));
            sql2.append(StringTool.format("'{0}', ", model.getEndTimeString()));
            sql2.append(StringTool.format(" {0} ", String.valueOf(model.getType())));
            sql2.append(")");
        } else if (DataModify.DELETE.is(curDataModify)) {
            sql2.append("DELETE FROM [S].JXD7_WF_RECEIVER");
            sql2.append(StringTool.format(" WHERE FLOWINSTANCEID='{0}'", model.getFlowInstanceId()));
            sql2.append(StringTool.format(" AND NODEINSTANCEID='{0}'", String.valueOf(model.getNodeInstanceId())));
            sql2.append(StringTool.format(" AND OPERATOR = '{0}'", model.getOperatorId()));
        } else {
            sql2.append("UPDATE [S].JXD7_WF_RECEIVER");
            sql2.append(" SET ");
            sql2.append(StringTool.format("\tBEGINTIME = '{0}',", model.getBeginTimeString()));
            sql2.append(StringTool.format("\tENDTIME = '{0}'", model.getEndTimeString()));
            sql2.append(StringTool.format(" WHERE FLOWINSTANCEID='{0}'", model.getFlowInstanceId()));
            sql2.append(StringTool.format(" AND NODEINSTANCEID='{0}'", String.valueOf(model.getNodeInstanceId())));
            sql2.append(StringTool.format(" AND OPERATOR = '{0}'", model.getOperatorId()));
        }
        String sqlText = sql2.toString();
        try {
            DbOper.executeNonQuery("defaultds", sqlText);
        }
        catch (SQLException e) {
            daoLogger.error((Object)("\u5c06\u8282\u70b9\u5b9e\u4f8b\u63a5\u6536\u4eba\u4fe1\u606f\u4fdd\u5b58\u5230\u6570\u636e\u5e93\u51fa\u73b0\u9519\u8bef \u9519\u8bef\u7684Sql\u8bed\u53e5\u4e3a\uff1a\n" + sql2 + "\n \u9519\u8bef\u4fe1\u606f\uff1a" + e.getMessage()));
            throw e;
        }
    }

    public void saveNodeInstanceOperator(FlowOperatorBean model, DataModify curDataModify) throws SQLException {
        StringBuffer sql2 = new StringBuffer();
        if (DataModify.NEW.is(curDataModify)) {
            sql2.append("INSERT INTO [S].JXD7_WF_OPERATOR");
            sql2.append("(");
            sql2.append("FLOWINSTANCEID,");
            sql2.append("NODEINSTANCEID,");
            sql2.append("OPERATOR,");
            sql2.append("OPERATORNAME,");
            sql2.append("BEGINTIME,");
            sql2.append("ENDTIME,");
            sql2.append("TYPE");
            sql2.append(")");
            sql2.append("VALUES");
            sql2.append("(");
            sql2.append(StringTool.format("'{0}',", model.getFlowInstanceId()));
            sql2.append(StringTool.format("'{0}',", String.valueOf(model.getNodeInstanceId())));
            sql2.append(StringTool.format("'{0}',", model.getOperatorId()));
            sql2.append(StringTool.format("'{0}',", model.getOperatorName()));
            sql2.append(StringTool.format("'{0}',", model.getBeginTimeString()));
            sql2.append(StringTool.format("'{0}', ", model.getEndTimeString()));
            sql2.append(StringTool.format(" {0} ", String.valueOf(0)));
            sql2.append(")");
        } else if (DataModify.DELETE.is(curDataModify)) {
            sql2.append("DELETE FROM [S].JXD7_WF_OPERATOR");
            sql2.append(StringTool.format(" WHERE FLOWINSTANCEID='{0}'", model.getFlowInstanceId()));
            sql2.append(StringTool.format(" AND NODEINSTANCEID='{0}'", String.valueOf(model.getNodeInstanceId())));
            sql2.append(StringTool.format(" AND OPERATOR = '{0}'", model.getOperatorId()));
        } else {
            sql2.append("UPDATE [S].JXD7_WF_OPERATOR");
            sql2.append(" SET ");
            sql2.append(StringTool.format("\tBEGINTIME = '{0}',", model.getBeginTimeString()));
            sql2.append(StringTool.format("\tENDTIME = '{0}'", model.getEndTimeString()));
            sql2.append(StringTool.format(" WHERE FLOWINSTANCEID='{0}'", model.getFlowInstanceId()));
            sql2.append(StringTool.format(" AND NODEINSTANCEID='{0}'", String.valueOf(model.getNodeInstanceId())));
            sql2.append(StringTool.format(" AND OPERATOR = '{0}'", model.getOperatorId()));
        }
        String sqlText = sql2.toString();
        try {
            DbOper.executeNonQuery("defaultds", sqlText);
        }
        catch (SQLException e) {
            daoLogger.error((Object)("\u5c06\u8282\u70b9\u5b9e\u4f8b\u5904\u7406\u4eba\u4fe1\u606f\u4fdd\u5b58\u5230\u6570\u636e\u5e93\u51fa\u73b0\u9519\u8bef \u9519\u8bef\u7684Sql\u8bed\u53e5\u4e3a\uff1a\n" + sql2 + "\n \u9519\u8bef\u4fe1\u606f\uff1a" + e.getMessage()));
            throw e;
        }
    }

    public void saveFormInstance(FlowFormInstanceBean model, DataModify curDataModify) throws SQLException {
        StringBuffer sql2 = new StringBuffer();
        sql2.append(" INSERT INTO [S].JXD7_WF_FORMINSTANCE");
        sql2.append(" (");
        sql2.append(" \tFLOWINSTANCEID,");
        sql2.append(" \tFLOWFORMID,");
        sql2.append(" \tFORMINSTANCEID");
        sql2.append(" )");
        sql2.append(" VALUES");
        sql2.append(" (");
        sql2.append(StringTool.format(" '{0}',", model.getFlowInstanceId()));
        sql2.append(StringTool.format("  {0},", String.valueOf(model.getFlowFormId())));
        sql2.append(StringTool.format(" '{0}'", model.getFormInstanceId()));
        sql2.append(" )");
        try {
            RowSet rs = DbOper.executeQuery("defaultds", " SELECT 1 FROM [S].JXD7_WF_FORMINSTANCE WHERE FLOWINSTANCEID='" + model.getFlowInstanceId() + "' AND FLOWFORMID =" + model.getFlowFormId() + "  AND FORMINSTANCEID='" + model.getFormInstanceId() + "'");
            if (rs.next()) {
                return;
            }
            String sqlText = sql2.toString();
            DbOper.executeNonQuery("defaultds", sqlText);
        }
        catch (SQLException e) {
            daoLogger.error((Object)("\u5c06\u8282\u70b9\u5b9e\u4f8b\u4e0a\u7684\u8868\u5355\u4fe1\u606f\u4fdd\u5b58\u5230\u6570\u636e\u5e93\u51fa\u73b0\u9519\u8bef \u9519\u8bef\u7684Sql\u8bed\u53e5\u4e3a\uff1a\n" + sql2 + "\n \u9519\u8bef\u4fe1\u606f\uff1a" + e.getMessage()));
            throw e;
        }
    }

    public void insertHandInfo(String flowInstanceId, int flowNodeInstanceId) throws SQLException {
        String sqlText = "SELECT COUNT(*) AS HANGS FROM [S].JXD7_WF_HANG WHERE FLOWINSTANCEID='" + flowInstanceId + "' AND NODEINSTANCEID=" + flowNodeInstanceId;
        try {
            RowSet rs = DbOper.executeQuery("defaultds", sqlText);
            int handCount = 0;
            if (rs.next()) {
                handCount = rs.getInt("HANGS");
            }
            ++handCount;
            User user = User.getCurrentUser();
            String userId = "";
            if (user != null) {
                userId = user.getId();
            }
            StringBuffer sql2 = new StringBuffer();
            sql2.append("INSERT INTO [S].JXD7_WF_HANG");
            sql2.append("(");
            sql2.append("\tFLOWINSTANCEID,");
            sql2.append("\tNODEINSTANCEID,");
            sql2.append("\tHANDORDER,");
            sql2.append("\tHANGTIME,");
            sql2.append("\t[RESUME],");
            sql2.append("\tHANDERID,");
            sql2.append("\tRESUMERID,");
            sql2.append("\tTIMESLICE");
            sql2.append(")");
            sql2.append("VALUES");
            sql2.append("(");
            sql2.append("\t'" + flowInstanceId + "',");
            sql2.append("\t" + flowNodeInstanceId + ",");
            sql2.append("\t" + handCount + ",");
            sql2.append("\t'" + DateTool.getNow() + "',");
            sql2.append("\t'',");
            sql2.append("\t'" + userId + "',");
            sql2.append("\t'',");
            sql2.append("\t0");
            sql2.append(")");
            sqlText = sql2.toString();
            DbOper.executeNonQuery("defaultds", sqlText);
        }
        catch (SQLException e) {
            daoLogger.error((Object)("\u5c06\u6d41\u7a0b\u7684\u6302\u8d77\u4fe1\u606f\u63d2\u5165\u5230\u6570\u636e\u5e93\u51fa\u73b0\u9519\u8bef \u9519\u8bef\u7684Sql\u8bed\u53e5\u4e3a\uff1a\n" + sqlText + "\n \u9519\u8bef\u4fe1\u606f\uff1a" + e.getMessage()));
            throw e;
        }
    }

    public void updateHandInfo(String flowInstanceId, int flowNodeInstanceId) throws SQLException {
        String sqlText = "SELECT COUNT(*) AS HANGS FROM [S].JXD7_WF_HANG WHERE FLOWINSTANCEID='" + flowInstanceId + "' AND  NODEINSTANCEID=" + flowNodeInstanceId;
        try {
            User user = User.getCurrentUser();
            String userId = "";
            if (user != null) {
                userId = user.getId();
            }
            RowSet rs = DbOper.executeQuery("defaultds", sqlText);
            int handCount = 0;
            if (rs.next()) {
                handCount = rs.getInt("HANGS");
            }
            long timeSpI = 0L;
            sqlText = "SELECT HANGTIME FROM [S].JXD7_WF_HANG WHERE FLOWINSTANCEID='" + flowInstanceId + "' AND NODEINSTANCEID='" + flowNodeInstanceId + "' AND HANDORDER =" + handCount;
            rs = DbOper.executeQuery("defaultds", sqlText);
            if (rs.next()) {
                timeSpI = DateTool.parseDate(DateTool.getNow()).getTime() - DateTool.parseDate(rs.getString("HANGTIME")).getTime();
                timeSpI /= 60000L;
            }
            StringBuffer sql2 = new StringBuffer();
            sql2.append("UPDATE [S].JXD7_WF_HANG");
            sql2.append(" SET");
            sql2.append("\t[RESUME] = '" + DateTool.getNow() + "' ,");
            sql2.append("\tRESUMERID = '" + userId + "',");
            sql2.append("\tTIMESLICE = " + String.valueOf(timeSpI));
            sql2.append(" WHERE FLOWINSTANCEID='" + flowInstanceId + "'");
            sql2.append(" AND NODEINSTANCEID = " + flowNodeInstanceId);
            sql2.append(" AND HANDORDER=\t" + handCount);
            sqlText = sql2.toString();
            DbOper.executeNonQuery("defaultds", sqlText);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void saveNodeChildInstance(FlowChildInstanceBean model, DataModify curDataModify) throws SQLException {
        StringBuffer sql2 = new StringBuffer(128);
        if (!curDataModify.is(DataModify.NEW)) {
            throw new SQLException("\u5b50\u6d41\u7a0b\u5b9e\u4f8b\u5173\u8054\u8868\u4e0d\u5141\u8bb8\u66f4\u65b0\u64cd\u4f5c");
        }
        sql2.append("INSERT INTO [S].JXD7_WF_CHILDFLOWINSTANCE");
        sql2.append("(");
        sql2.append("\tFLOWINSTANCEID,");
        sql2.append("\tFLOWNODEID,");
        sql2.append("\tCHILDFLOWINSTANCEID");
        sql2.append(")");
        sql2.append("VALUES");
        sql2.append("(");
        sql2.append("\t'" + model.getFlowInstanceId() + "',");
        sql2.append("\t" + model.getFlowNodeId() + ",");
        sql2.append("\t'" + model.getChildInstanceId() + "'");
        sql2.append(")");
        String sqlText = sql2.toString();
        try {
            DbOper.executeNonQuery("defaultds", sqlText);
        }
        catch (SQLException e) {
            daoLogger.error((Object)("\u5c06\u8282\u70b9\u5b9e\u4f8b\u4e0a\u7684\u5b50\u6d41\u7a0b\u4fdd\u5b58\u5230\u6570\u636e\u5e93\u51fa\u73b0\u9519\u8bef \u9519\u8bef\u7684Sql\u8bed\u53e5\u4e3a\uff1a\n" + sql2 + "\n \u9519\u8bef\u4fe1\u606f\uff1a" + e.getMessage()));
            throw e;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String isAllChildCompl(String childInstanceId) {
        try {
            String returnStr = "";
            String sql2 = "SELECT B.FLOWINSTANCEID ,B.FLOWNODEID FROM [S].JXD7_WF_NODEINSTANCE A,[S].JXD7_WF_CHILDFLOWINSTANCE B,[S].JXD7_WF_FLOWNODE C,[S].JXD7_WF_CHILD D WHERE D.INVOKETYPE=0 AND A.FLOWID=C.FLOWID AND A.FLOWNODEID=C.FLOWNODEID AND C.FLOWID=D.FLOWID AND C.FLOWNODEID=D.FLOWNODEID AND A.FLOWINSTANCEID=B.FLOWINSTANCEID AND A.NODEINSTANCEID=B.FLOWNODEID AND B.CHILDFLOWINSTANCEID='" + childInstanceId + "'";
            RowSet rs = DbOper.executeQuery("defaultds", sql2);
            if (!rs.next()) {
                return "";
            }
            sql2 = "SELECT A.RUNSTATUS  FROM [S].JXD7_WF_INSTANCE A ,[S].JXD7_WF_CHILDFLOWINSTANCE B  WHERE A.FLOWINSTANCEID=B.CHILDFLOWINSTANCEID  AND B.FLOWNODEID=" + rs.getString(2) + " AND B.FLOWINSTANCEID='" + rs.getString(1) + "' AND B.CHILDFLOWINSTANCEID<>'" + childInstanceId + "'";
            returnStr = String.valueOf(rs.getString(1)) + "|" + rs.getString(2);
            rs = DbOper.executeQuery("defaultds", sql2);
            do {
                if (rs.next()) continue;
                return returnStr;
            } while (rs.getInt(1) == 1);
            return "";
        }
        catch (SQLException e) {
            return "";
        }
    }

    public List getTimeLimit() throws Exception {
        StringBuffer sb = new StringBuffer(512);
        sb.append("SELECT NI.FLOWINSTANCEID,NI.NODEINSTANCEID,NI.FLOWID,NI.FLOWNODEID,NI.CREATEDATE FROM [S].JXD7_WF_INSTANCE I,[S].JXD7_WF_NODEINSTANCE NI,[S].JXD7_WF_TASK N");
        sb.append(" WHERE NI.FLOWID=N.FLOWID AND NI.FLOWNODEID=N.FLOWNODEID AND N.OVERTIME<>'[\"0\",\"\",\"\"]' AND I.FLOWINSTANCEID=NI.FLOWINSTANCEID AND I.DATASTATUSID=").append(DataStatus.NORMAL.getId());
        sb.append(" AND NI.RUNSTATUS=").append(0).append(" AND I.RUNSTATUS=").append(0);
        ArrayList<FlowNodeInstanceBean> nodeInstanceList = new ArrayList<FlowNodeInstanceBean>();
        RowSet rs = DbOper.executeQuery("defaultds", sb.toString());
        while (rs.next()) {
            FlowNodeInstanceBean model = new FlowNodeInstanceBean();
            model.setFlowInstanceId(rs.getString("FLOWINSTANCEID"));
            model.setNodeInstanceId(rs.getInt("NODEINSTANCEID"));
            model.setFlowId(rs.getString("FLOWID"));
            model.setFlowNodeId(rs.getInt("FLOWNODEID"));
            model.setCreateTime(DateTool.parseDate(rs.getString("CREATEDATE")));
            nodeInstanceList.add(model);
        }
        return nodeInstanceList;
    }

    public String getFlowParamInstance(String flowId, String flowInstanceId, int paramId) throws Exception {
        String paramValue = null;
        StringBuffer sql2 = new StringBuffer(256);
        sql2.append("SELECT I.FLOWINSTANCEID,I.PARAMNAME,I.PARAMVALUE FROM [S].JXD7_WF_PARAMINSTANCE I,[S].JXD7_WF_PARAM P");
        sql2.append(" WHERE I.FLOWINSTANCEID='").append(flowInstanceId).append("'");
        sql2.append(" AND P.FLOWID='").append(flowId).append("'");
        sql2.append(" AND P.PARAMID=").append(paramId);
        sql2.append(" AND P.PARAMNAME=I.PARAMNAME");
        try {
            RowSet rs = DbOper.executeQuery("defaultds", sql2.toString());
            if (rs.next()) {
                paramValue = rs.getString("PARAMVALUE");
            }
        }
        catch (SQLException exp) {
            daoLogger.error((Object)("\u8bfb\u53d6\u6d41\u7a0b\u53c2\u6570\u5b9e\u4f8b\u9519\u8bef,\u9519\u8bef\u7684Sql\u8bed\u53e5\u4e3a\uff1a\n" + sql2 + "\n FlowInstanceDao.getFlowNodeInstance\u9519\u8bef\u4fe1\u606f\uff1a" + exp.getMessage()));
            throw exp;
        }
        return paramValue;
    }

    public void saveCounterSign(CounterSign counterSign) throws Exception {
        StringBuffer sqlBuffer = new StringBuffer();
        DataModify modify = counterSign.getModify();
        String flowInstanceId = counterSign.getFlowInstanceId();
        int nodeInstanceId = counterSign.getNodeInstanceId();
        String counterSignId = counterSign.getCounterSignId();
        if (DataModify.NEW.equals(modify)) {
            sqlBuffer.append("INSERT INTO [S].JXD7_WF_COUNTERSIGN(FLOWINSTANCEID,NODEINSTANCEID,COUNTERSIGNID,FLOWID,FLOWNAME,FLOWNODEID,FLOWNODENAME,CREATETIME,COUNTERSIGNDEPT,COUNTERSIGNTYPE,COUNTERSIGNTIME,COUNTERSIGNUSER,COUNTERSIGNCONTENT,ISCOMPLET)");
            sqlBuffer.append(" VALUES ('").append(counterSign.getFlowInstanceId()).append("'");
            sqlBuffer.append(",").append(counterSign.getNodeInstanceId());
            sqlBuffer.append(",'").append(counterSign.getCounterSignId()).append("'");
            sqlBuffer.append(",'").append(counterSign.getFlowId()).append("'");
            sqlBuffer.append(",'").append(counterSign.getFlowName()).append("'");
            sqlBuffer.append(",").append(counterSign.getFlowNodeId());
            sqlBuffer.append(",'").append(counterSign.getFlowNodeName()).append("'");
            sqlBuffer.append(",'").append(counterSign.getCreateTimeString()).append("'");
            sqlBuffer.append(",'").append(counterSign.getCounterSignDept()).append("'");
            sqlBuffer.append(",").append(counterSign.getCounterSignType());
            sqlBuffer.append(",'").append(counterSign.getCounterSignTimeString()).append("'");
            sqlBuffer.append(",'").append(counterSign.getCounterSignUser()).append("'");
            sqlBuffer.append(",'").append(counterSign.getCounterSignContent()).append("',").append(StringTool.isEmpty(counterSign.getCounterSignUser()) ? 0 : 1).append(")");
        } else if (DataModify.DELETE.equals(modify)) {
            if (!StringTool.isEmpty(counterSignId)) {
                sqlBuffer.append("DELETE FROM [S].JXD7_WF_COUNTERSIGN WHERE COUNTERSIGNID='").append(counterSignId).append("'");
            } else {
                sqlBuffer.append("DELETE FROM [S].JXD7_WF_COUNTERSIGN WHERE FLOWINSTANCEID='").append(flowInstanceId).append("' AND NODEINSTANCEID=").append(nodeInstanceId);
            }
        } else if (DataModify.MODIFY.equals(modify)) {
            sqlBuffer.append("UPDATE [S].JXD7_WF_COUNTERSIGN SET ISCOMPLET=1,COUNTERSIGNTIME='").append(counterSign.getCounterSignTimeString()).append("',COUNTERSIGNUSER='").append(counterSign.getCounterSignUser()).append("',COUNTERSIGNCONTENT='").append(counterSign.getCounterSignContent()).append("'");
            sqlBuffer.append(" WHERE COUNTERSIGNID='").append(counterSignId).append("'");
        }
        String sql2 = sqlBuffer.toString();
        try {
            DbOper.executeNonQuery("defaultds", sql2);
        }
        catch (SQLException exp) {
            daoLogger.error((Object)("\u4fdd\u5b58\u4f1a\u7b7e\u5931\u8d25,\u9519\u8bef\u4e3a:" + exp.getMessage() + "\nsql\u4e3a\uff1a" + sql2));
            throw exp;
        }
    }

    public boolean checkCounterSign(String counterSignId, String userId) throws Exception {
        boolean success = false;
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("SELECT 1 FROM [S].JXD7_WF_COUNTERSIGN WHERE COUNTERSIGNID='").append(counterSignId);
        sqlBuffer.append("' AND ((COUNTERSIGNTYPE=0 AND COUNTERSIGNDEPT='").append(userId).append("')");
        sqlBuffer.append(" OR (COUNTERSIGNTYPE=2 AND EXISTS(SELECT 1 FROM JXD7_XT_USER U,JXD7_XT_ORGANISE O1,JXD7_XT_ORGANISE O2 WHERE U.DEPTID=O1.ORGANISEID AND O1.ORGANISELEVEL LIKE O2.ORGANISELEVEL + '%' AND U.USERID='").append(userId).append("' AND O2.ORGANISEID=COUNTERSIGNDEPT))");
        sqlBuffer.append(" OR (COUNTERSIGNTYPE=1 AND EXISTS(SELECT 1 FROM JXD7_XT_USERROLE R WHERE R.ROLEID=COUNTERSIGNDEPT AND R.USERID='").append(userId).append("')))");
        String sql2 = sqlBuffer.toString();
        try {
            success = DbOper.executeQueryObject("defaultds", sql2) != null;
        }
        catch (SQLException exp) {
            daoLogger.error((Object)("\u68c0\u67e5\u4f1a\u7b7e\u6743\u9650\u5931\u8d25,\u9519\u8bef\u4e3a:" + exp.getMessage() + "\nsql\u4e3a\uff1a" + sql2));
            throw exp;
        }
        return success;
    }

    public List copyCounterSign(String flowInstanceId, int oldNodeInstanceId, int newNodeInstanceId) throws Exception {
        ArrayList<CounterSign> counterSigns = new ArrayList<CounterSign>();
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("SELECT COUNTERSIGNID,FLOWID,FLOWNAME,FLOWNODEID,FLOWNODENAME,CREATETIME,COUNTERSIGNDEPT,COUNTERSIGNTYPE,COUNTERSIGNTIME,COUNTERSIGNUSER,COUNTERSIGNCONTENT,ISCOMPLET FROM [S].JXD7_WF_COUNTERSIGN WHERE FLOWINSTANCEID='").append(flowInstanceId);
        sqlBuffer.append("' AND NODEINSTANCEID='").append(oldNodeInstanceId).append("'");
        String sql2 = sqlBuffer.toString();
        try {
            RowSet rs = DbOper.executeQuery("defaultds", sql2);
            while (rs.next()) {
                CounterSign counterSign = CounterSign.create(flowInstanceId, newNodeInstanceId, rs.getString("FLOWID"), rs.getString("FLOWNAME"), rs.getInt("FLOWNODEID"), rs.getString("FLOWNODENAME"), rs.getString("COUNTERSIGNDEPT"), rs.getInt("COUNTERSIGNTYPE"));
                counterSign.submit(rs.getString("COUNTERSIGNUSER"), DateTool.parseDate(rs.getString("COUNTERSIGNTIME")), rs.getString("COUNTERSIGNCONTENT"));
                counterSigns.add(counterSign);
            }
        }
        catch (SQLException exp) {
            daoLogger.error((Object)("\u590d\u5236\u4f1a\u7b7e\u4fe1\u606f\u5931\u8d25,\u9519\u8bef\u4e3a:" + exp.getMessage() + "\nsql\u4e3a\uff1a" + sql2));
            throw exp;
        }
        return counterSigns;
    }

    public Map getUntreadReason(String flowInstanceId, String nodeInstanceId) {
        HashMap<String, String> ret = new HashMap<String, String>();
        StringBuffer sql2 = new StringBuffer();
        sql2.append("SELECT * FROM JXD7_WF_UNTREAD WHERE FLOWINSTANCEID = '");
        sql2.append(flowInstanceId);
        sql2.append("' AND NODEINSTANCEID = '");
        sql2.append(nodeInstanceId);
        sql2.append("'");
        try {
            RowSet rs = DbOper.executeQuery("defaultds", sql2.toString());
            if (rs.next()) {
                ret.put("reason", rs.getString("reason"));
                ret.put("createUserID", rs.getString("createuserid"));
                ret.put("createUser", rs.getString("createusername"));
                ret.put("createDate", rs.getString("createdate"));
            }
        }
        catch (SQLException exp) {
            daoLogger.error((Object)(String.valueOf(exp.getMessage()) + "\nsql\u4e3a\uff1a" + sql2.toString()));
        }
        return ret;
    }

    public List getUntreadReason(String flowInstanceId) {
        ArrayList list = new ArrayList();
        StringBuffer sql2 = new StringBuffer();
        sql2.append("SELECT U.FLOWINSTANCEID,U.NODEINSTANCEID,U.REASON,U.CREATEUSERID,U.CREATEUSERNAME,U.CREATEDATE,N.FLOWNODEID FROM JXD7_WF_UNTREAD U,JXD7_WF_NODEINSTANCE N");
        sql2.append(" WHERE U.FLOWINSTANCEID='").append(flowInstanceId).append("'");
        sql2.append(" AND N.FLOWINSTANCEID='").append(flowInstanceId).append("'");
        sql2.append(" AND U.NODEINSTANCEID=N.NODEINSTANCEID");
        try {
            RowSet rs = DbOper.executeQuery("defaultds", sql2.toString());
            while (rs.next()) {
                HashMap<String, String> ret = new HashMap<String, String>();
                ret.put("FLOWINSTANCEID", flowInstanceId);
                ret.put("NODEINSTANCEID", String.valueOf(rs.getInt("NODEINSTANCEID")));
                ret.put("FLOWNODEID", String.valueOf(rs.getInt("FLOWNODEID")));
                ret.put("REASON", rs.getString("REASON"));
                ret.put("CREATEUSERID", rs.getString("CREATEUSERID"));
                ret.put("CREATEUSER", rs.getString("CREATEUSERNAME"));
                ret.put("CREATEDATE", rs.getString("CREATEDATE"));
                list.add(ret);
            }
        }
        catch (SQLException exp) {
            exp.printStackTrace();
            daoLogger.error((Object)(String.valueOf(exp.getMessage()) + "\nsql\u4e3a\uff1a" + sql2.toString()));
        }
        return list;
    }

    public int doc2Run(String flowInstanceId) throws Exception {
        int success = 1;
        FlowInstanceBean flowInstance = FlowInstanceDao.createInstance().getFlowInstance(flowInstanceId);
        if (flowInstance.getRunStatus() == 1) {
            String receiverType = "";
            String receiverId = "";
            try {
                StringBuffer recesql = new StringBuffer();
                recesql.append("SELECT OPERATOR,TYPE FROM JXD7_WF_RECEIVER WHERE ");
                recesql.append(StringTool.format("FLOWINSTANCEID='{0}'", flowInstanceId));
                recesql.append("AND NODEINSTANCEID=(SELECT MAX(NODEINSTANCEID) FROM JXD7_WF_RECEIVER WHERE flowinstanceid='");
                recesql.append(flowInstanceId).append("')");
                RowSet rs = DbOper.executeQuery(recesql.toString());
                if (rs.next()) {
                    receiverType = rs.getString("TYPE");
                    receiverId = rs.getString("OPERATOR");
                }
            }
            catch (Exception recesql) {
                // empty catch block
            }
            String[] sqls = new String[5];
            StringBuffer sql2 = new StringBuffer(512);
            sql2.append("UPDATE [S].JXD7_WF_INSTANCE");
            sql2.append(" SET ");
            sql2.append("ENDDATE='' ,");
            sql2.append(StringTool.format("RUNSTATUS={0} ", String.valueOf(0)));
            sql2.append(" WHERE ");
            sql2.append(StringTool.format("FLOWINSTANCEID='{0}'", flowInstanceId));
            sql2.append(StringTool.format(" AND RUNSTATUS={0} ", String.valueOf(1)));
            sqls[0] = sql2.toString();
            sql2.setLength(0);
            sql2.append("INSERT INTO JXD7_WF_NODEINSTANCE ");
            sql2.append("select FLOWINSTANCEID,");
            sql2.append("(SELECT MAX(NODEINSTANCEID)+1 FROM jxd7_wf_nodeinstance WHERE flowinstanceid='");
            sql2.append(flowInstanceId).append("') as NODEINSTANCEID,");
            sql2.append("FLOWID,FLOWNAME,FLOWNODEID,FLOWNODENAME,STATUSNAME,0 AS RUNSTATUS,");
            sql2.append("'").append(DateTool.getNow()).append("' as BEGINTIME,");
            sql2.append("'' as ENDTIME,");
            sql2.append("'['+(SELECT MAX(NODEINSTANCEID) FROM jxd7_wf_nodeinstance WHERE flowinstanceid='");
            sql2.append(flowInstanceId).append("')+']' as PRENODEINSTANCEIDS,");
            sql2.append("'").append(DateTool.getNow()).append("' as CREATEDATE,");
            sql2.append("'").append(User.getCurrentUser().getId()).append("' AS CREATEUSERID,");
            sql2.append("'").append(User.getCurrentUser().getName()).append("' AS CREATEUSERNAME,");
            sql2.append("'' AS OPENERID,'' AS OPENERNAME,'' AS LASTOPENTIME,");
            sql2.append("TAKESTATUS,'' AS OVERTIME,'' AS NOTES ");
            sql2.append("from JXD7_WF_NODEINSTANCE WHERE ");
            sql2.append("FLOWINSTANCEID='").append(flowInstanceId).append("' ");
            sql2.append("AND NODEINSTANCEID=(SELECT MAX(NODEINSTANCEID)-1 FROM jxd7_wf_nodeinstance WHERE flowinstanceid='");
            sql2.append(flowInstanceId).append("')");
            sqls[1] = sql2.toString();
            sql2.setLength(0);
            sql2.append("INSERT INTO JXD7_WF_OPERATOR ");
            sql2.append("select FLOWINSTANCEID,");
            sql2.append("(SELECT MAX(NODEINSTANCEID) FROM JXD7_WF_NODEINSTANCE WHERE flowinstanceid='");
            sql2.append(flowInstanceId).append("') AS NODEINSTANCEID,");
            sql2.append("OPERATOR,OPERATORNAME,");
            sql2.append("'").append(DateTool.getNow()).append("' as BEGINTIME,");
            sql2.append("'' AS ENDTIME,TYPE ");
            sql2.append(" from JXD7_WF_OPERATOR WHERE ");
            sql2.append(StringTool.format("FLOWINSTANCEID='{0}'", flowInstanceId));
            sql2.append("AND NODEINSTANCEID=(SELECT MAX(NODEINSTANCEID) FROM JXD7_WF_OPERATOR WHERE flowinstanceid='");
            sql2.append(flowInstanceId).append("')");
            sqls[2] = sql2.toString();
            sql2.setLength(0);
            sql2.append("INSERT INTO JXD7_WF_RECEIVER ");
            sql2.append("select FLOWINSTANCEID,");
            sql2.append("(SELECT MAX(NODEINSTANCEID) FROM JXD7_WF_NODEINSTANCE WHERE flowinstanceid='");
            sql2.append(flowInstanceId).append("') AS NODEINSTANCEID,");
            sql2.append("OPERATOR,OPERATORNAME,");
            sql2.append("'' as BEGINTIME,");
            sql2.append("'' AS ENDTIME,TYPE ");
            sql2.append(" from JXD7_WF_RECEIVER WHERE ");
            sql2.append(StringTool.format("FLOWINSTANCEID='{0}'", flowInstanceId));
            sql2.append("AND NODEINSTANCEID=(SELECT MAX(NODEINSTANCEID) FROM JXD7_WF_OPERATOR WHERE flowinstanceid='");
            sql2.append(flowInstanceId).append("')");
            sqls[3] = sql2.toString();
            FlowInstance flowinstance = FlowInstance.load(flowInstanceId);
            FlowNodeInstance nodeinstance = flowinstance.getLastNodeInstance();
            int[] instanceids = nodeinstance.getPreNodeInstanceIds();
            FlowNodeInstance prenode = flowinstance.getFlowNodeInstance(instanceids[0]);
            int flowFormId = prenode.getDefaultForm();
            FlowFormInstance flowFormInstance = flowinstance.getForm(flowFormId);
            int nodeInstanceId = nodeinstance.getNodeInstanceId() + 1;
            String operUrl = "/flow.do?i=" + flowInstanceId;
            String operId = String.valueOf(flowinstance.getId()) + String.valueOf(nodeInstanceId);
            String operName = flowinstance.getFlowName();
            User currentUser = User.getCurrentUser();
            String sender = currentUser != null ? currentUser.getId() : "";
            StringBuffer sqlBuffer = new StringBuffer();
            sqlBuffer.append("INSERT INTO [S].JXD7_XT_WAITDO(WAITDOID,OPERID,OPERNAME,OPERURL,SENDER,RECEIVERTYPE,RECEIVER,SENDTIME)");
            sqlBuffer.append(" VALUES ('").append(Guid.create()).append("'");
            sqlBuffer.append(",'").append(operId).append("'");
            sqlBuffer.append(",'").append(operName).append("'");
            sqlBuffer.append(",'").append(operUrl).append("'");
            sqlBuffer.append(",'").append(sender).append("'");
            sqlBuffer.append(",'").append(receiverType).append("'");
            sqlBuffer.append(",'").append(receiverId).append("'");
            sqlBuffer.append(",'").append(DateTool.getNow()).append("')");
            sqls[4] = sqlBuffer.toString();
            try {
                DbOper.executeNonQuery("defaultds", sqls);
                success = 0;
            }
            catch (SQLException e) {
                daoLogger.error((Object)("\u5c06\u6d41\u7a0b\u5b9e\u4f8b\u590d\u6d3b\u51fa\u73b0\u9519\u8bef \u9519\u8bef\u7684Sql\u8bed\u53e5\u4e3a\uff1a\n" + sqls[0] + "\n " + sqls[1] + "\n " + sqls[2] + "\n " + sqls[3] + "\n " + sqls[4] + "\n \u9519\u8bef\u4fe1\u606f\uff1a" + e.getMessage()));
                throw e;
            }
        }
        success = 2;
        return success;
    }

    public static void clearFlowOperInfo() {
        String sql2 = " update JXD7_WF_INSTANCE set opener = null ,openerid = null where opener is not null or openerid is not null";
        try {
            DbOper.executeNonQuery(sql2);
        }
        catch (SQLException e) {
            Log.info((Object)"\u6e05\u7a7a\u6d41\u7a0b\u6253\u5f00\u4fe1\u606f\u5931\u8d25\uff01");
            e.printStackTrace();
        }
    }

    public void updateOpener(FlowInstance flow, boolean isOpen) {
        StringBuilder sql2 = new StringBuilder().append(" update JXD7_WF_INSTANCE ");
        if (isOpen) {
            User currUser = User.getCurrentUser();
            String opener = currUser.getName();
            String openerId = currUser.getId();
            String openTime = DateTool.getNow();
            sql2.append(" set opener = '").append(opener).append("',openerid='").append(openerId).append("',lastOpentime='").append(openTime).append("' ");
        } else {
            sql2.append(" set opener = '' ,openerid = '' ");
        }
        sql2.append(" where FLOWINSTANCEID = '").append(flow.getId()).append("'");
        try {
            DbOper.executeNonQuery(sql2.toString());
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

