/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.workflow.dao;

import com.sdjxd.pms.platform.base.DataModify;
import com.sdjxd.pms.platform.base.DataStatus;
import com.sdjxd.pms.platform.base.dao.BaseDao;
import com.sdjxd.pms.platform.data.DbOper;
import com.sdjxd.pms.platform.tool.DateTool;
import com.sdjxd.pms.platform.workflow.model.FlowActorBean;
import com.sdjxd.pms.platform.workflow.model.FlowAgentBean;
import com.sdjxd.pms.platform.workflow.model.FlowBean;
import com.sdjxd.pms.platform.workflow.model.FlowCellBean;
import com.sdjxd.pms.platform.workflow.model.FlowConditionBean;
import com.sdjxd.pms.platform.workflow.model.FlowEventBean;
import com.sdjxd.pms.platform.workflow.model.FlowFormBean;
import com.sdjxd.pms.platform.workflow.model.FlowInterFaceBean;
import com.sdjxd.pms.platform.workflow.model.FlowInterFaceInstanceBean;
import com.sdjxd.pms.platform.workflow.model.FlowNodeBean;
import com.sdjxd.pms.platform.workflow.model.FlowNodeChildBean;
import com.sdjxd.pms.platform.workflow.model.FlowNodeParaBean;
import com.sdjxd.pms.platform.workflow.model.FlowParameterBean;
import com.sdjxd.pms.platform.workflow.model.FlowTransBean;
import com.sdjxd.pms.platform.workflow.model.FormVariableBean;
import com.sdjxd.pms.platform.workflow.model.FormVariableLimitBean;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.sql.RowSet;
import org.apache.log4j.Logger;

public class FlowDao
extends BaseDao {
    private static Logger daoLogger = Logger.getLogger(FlowDao.class);

    public static FlowDao createInstance() {
        return (FlowDao)FlowDao.createInstance(FlowDao.class, "defaultds");
    }

    public FlowBean getFlowBean(String flowId) throws SQLException {
        FlowBean model = new FlowBean();
        String sql2 = "SELECT FLOWVERSION,LASTMODIFYTIME,VERSIONID,STARTUPTIME,TERMINATE,SHOWORDER,DATASTATUSID,FLOWNAME,MODULEID FROM [S].JXD7_WF_FLOW  WHERE FLOWID='" + flowId + "'";
        try {
            RowSet rs = DbOper.executeQuery("defaultds", sql2);
            while (rs.next()) {
                model.setId(flowId);
                model.setFlowVersion(rs.getString("FLOWVERSION"));
                model.setLastModifyTime(DateTool.parseDate(rs.getString("LASTMODIFYTIME")));
                model.setVersionId(rs.getInt("VERSIONID"));
                model.setStartUpTime(DateTool.parseDate(rs.getString("STARTUPTIME")));
                model.setTerminate(DateTool.parseDate(rs.getString("TERMINATE")));
                model.setShowNum(rs.getInt("SHOWORDER"));
                model.setDataStatusId(rs.getInt("DATASTATUSID"));
                model.setFlowName(rs.getString("FLOWNAME"));
                model.setModuleId(rs.getString("MODULEID"));
            }
        }
        catch (SQLException exp) {
            daoLogger.error((Object)("\u8bfb\u53d6\u6d41\u7a0b\u9519\u8bef,\u9519\u8bef\u7684Sql\u8bed\u53e5\u4e3a\uff1a\n" + sql2 + "\n FlowDao.getFlowBean(flowId)\u9519\u8bef\u4fe1\u606f\uff1a" + exp.getMessage()));
            throw exp;
        }
        return model;
    }

    public Map getFlowParameter(String flowId) throws SQLException {
        HashMap<String, FlowParameterBean> map = new HashMap<String, FlowParameterBean>();
        String sql2 = "SELECT PARAMID,PARAMNAME,PARAMTYPE,PARAMVALUE,VARPATH,P.FORMVARID,V.FLOWFORMID,P.VARVALUETYPE, P.FORMID, P.FORMPARAMID FROM [S].JXD7_WF_PARAM P LEFT OUTER JOIN [S].JXD7_WF_FORMVAR V ON P.FORMVARID=V.VARID AND P.FLOWID=V.FLOWID WHERE P.FLOWID='" + flowId + "'";
        try {
            RowSet rs = DbOper.executeQuery("defaultds", sql2);
            while (rs.next()) {
                FlowParameterBean model = new FlowParameterBean();
                model.setId(rs.getInt("PARAMID"));
                model.setName(rs.getString("PARAMNAME"));
                model.setType(rs.getInt("PARAMTYPE"));
                model.setValue(rs.getString("PARAMVALUE"));
                model.setFormVariable(rs.getString("VARPATH"));
                model.setFormVariableId(rs.getInt("FORMVARID"));
                model.setFormId(rs.getInt("FLOWFORMID"));
                model.setVarType(rs.getInt("VARVALUETYPE"));
                model.setParamFormId(rs.getInt("FORMID"));
                model.setFormParamId(rs.getInt("FORMPARAMID"));
                map.put(rs.getString("PARAMNAME"), model);
            }
        }
        catch (SQLException exp) {
            daoLogger.error((Object)("\u5f97\u5230\u6d41\u7a0b\u7684\u6d41\u7a0b\u53c2\u6570\u7684\u8bbe\u7f6e\u4fe1\u606f,\u9519\u8bef\u7684Sql\u8bed\u53e5\u4e3a\uff1a\n" + sql2 + "\n FlowDao.getFlowParameter(flowId)\u9519\u8bef\u4fe1\u606f\uff1a" + exp.getMessage()));
            throw exp;
        }
        return map;
    }

    public List getFlowNodeParam(String flowId) throws SQLException {
        ArrayList<FlowNodeParaBean> list = new ArrayList<FlowNodeParaBean>();
        String sql2 = "SELECT N.FLOWNODEID, N.PARAMID,N.PARAMVALUE, P.PARAMNAME,P.PARAMTYPE FROM [S].JXD7_WF_NODEPARAM N,[S].JXD7_WF_PARAM P WHERE N.PARAMID=P.PARAMID AND N.FLOWID=P.FLOWID AND N.FLOWID='" + flowId + "'";
        try {
            RowSet rs = DbOper.executeQuery("defaultds", sql2);
            while (rs.next()) {
                FlowNodeParaBean model = new FlowNodeParaBean();
                model.setFlowNodeId(rs.getInt("FLOWNODEID"));
                model.setParamId(rs.getInt("PARAMID"));
                model.setParamName(rs.getString("PARAMNAME"));
                model.setParamValue(rs.getObject("PARAMVALUE"));
                model.setType(rs.getInt("PARAMTYPE"));
                list.add(model);
            }
        }
        catch (SQLException e) {
            daoLogger.error((Object)("\u5f97\u5230\u6d41\u7a0b\u7684\u6d41\u7a0b\u8282\u70b9\u53c2\u6570\u7684\u8bbe\u7f6e\u4fe1\u606f,\u9519\u8bef\u7684Sql\u8bed\u53e5\u4e3a\uff1a\n" + sql2 + "\n \u9519\u8bef\u4fe1\u606f\uff1a" + e.getMessage()));
            throw e;
        }
        return list;
    }

    public Map getFlowNodes(String flowId) throws SQLException {
        HashMap<String, FlowNodeBean> map = new HashMap<String, FlowNodeBean>();
        String sql2 = "SELECT N.FLOWNODEID,FLOWNODENAME,ALLOWFORM,CONVERGE,DEFAULTFORM,EMBRANCH,FREETYPE,FREEDATA,NODETYPE,ALLOWUNTREAD,S.STATUSID,S.STATUSNAME,ENABLED,ISPENDING,ASSITINFO,ORDEREXEC, OVERTIME ,COMPLETEROLE ,COMPLETEDATA,N.SENDMSG,N.LIMITGROUPIDS,N.AUTODEAL,N.NORECIVER,N.WECHART  FROM [S].JXD7_WF_TASK T,[S].JXD7_WF_FLOWNODE N LEFT OUTER JOIN [S].JXD7_WF_STATUS S ON N.STATUSID=S.STATUSID WHERE N.FLOWID='" + flowId + "' AND T.FLOWID='" + flowId + "' AND N.FLOWNODEID=T.FLOWNODEID";
        try {
            RowSet rs = DbOper.executeQuery("defaultds", sql2);
            while (rs.next()) {
                FlowNodeBean model = new FlowNodeBean();
                model.setFlowId(flowId);
                model.setFlowNodeId(rs.getInt("FLOWNODEID"));
                model.setFlowNodeName(rs.getString("FLOWNODENAME"));
                model.setAllowForm(rs.getString("ALLOWFORM"));
                model.setConverge(rs.getInt("CONVERGE"));
                model.setDefaultForm(rs.getInt("DEFAULTFORM"));
                model.setEmbranch(rs.getInt("EMBRANCH"));
                model.setFreeType(rs.getInt("FREETYPE"));
                model.setFreeData(rs.getString("FREEDATA"));
                model.setNodeType(rs.getInt("NODETYPE"));
                model.setStatusId(rs.getString("STATUSID"));
                model.setStatusName(rs.getString("STATUSNAME"));
                model.setMulti("1".equals(rs.getString("ENABLED")));
                model.setPending("1".equals(rs.getString("ISPENDING")));
                model.setOrderExec("1".equals(rs.getString("ORDEREXEC")));
                model.setCompleteData(rs.getInt("COMPLETEDATA"));
                model.setCompleteRole(rs.getInt("COMPLETEROLE"));
                model.setOverTime(rs.getString("OVERTIME"));
                model.setAssitinfo(rs.getString("ASSITINFO"));
                model.setSendMsg(rs.getString("SENDMSG"));
                model.setLimitGroups(rs.getString("LIMITGROUPIDS"));
                model.setAllowUntread(rs.getInt("ALLOWUNTREAD"));
                model.setAutoDeal(rs.getInt("AUTODEAL"));
                model.setNoReciver(rs.getInt("NORECIVER"));
                model.setWeChart(rs.getString("WECHART"));
                map.put(rs.getString("FLOWNODEID"), model);
            }
        }
        catch (SQLException exp) {
            daoLogger.error((Object)("\u5f97\u5230\u6d41\u7a0b\u7684\u6d41\u7a0b\u8282\u70b9\u7684\u8bbe\u7f6e\u4fe1\u606f,\u9519\u8bef\u7684Sql\u8bed\u53e5\u4e3a\uff1a\n" + sql2 + "\n FlowDao.getFlowNodes(flowId)\u9519\u8bef\u4fe1\u606f\uff1a" + exp.getMessage()));
            throw exp;
        }
        return map;
    }

    public List getFlowForms(String flowId) throws SQLException {
        ArrayList<FlowFormBean> list = new ArrayList<FlowFormBean>();
        String sql2 = "SELECT FLOWFORMID,FLOWFORMNAME,FLOWNODEID, FORMPATTERNID, FORMURL  FROM [S].JXD7_WF_FORM  WHERE FLOWID='" + flowId + "'";
        try {
            RowSet rs = DbOper.executeQuery("defaultds", sql2);
            while (rs.next()) {
                FlowFormBean model = new FlowFormBean();
                model.setId(rs.getInt("FLOWFORMID"));
                model.setCreateNodeId(rs.getInt("FLOWNODEID"));
                model.setFormPatternId(rs.getString("FORMPATTERNID"));
                model.setFormUrl(rs.getString("FORMURL"));
                model.setName(rs.getString("FLOWFORMNAME"));
                list.add(model);
            }
        }
        catch (SQLException exp) {
            daoLogger.error((Object)("\u5f97\u5230\u6d41\u7a0b\u7684\u8868\u5355\u7684\u8bbe\u7f6e\u4fe1\u606f,\u9519\u8bef\u7684Sql\u8bed\u53e5\u4e3a\uff1a\n" + sql2 + "\n FlowDao.getFlowForms(flowId)\u9519\u8bef\u4fe1\u606f\uff1a" + exp.getMessage()));
            throw exp;
        }
        return list;
    }

    public List getFlowConditions(String flowId) throws SQLException {
        ArrayList<FlowConditionBean> list = new ArrayList<FlowConditionBean>();
        String sql2 = " SELECT  CONDITIONID,CONDITIONNAME,CONDITIONTYPE,COMPARETYPE,OPERATELEFT,OPERATERIGHT  FROM [S].JXD7_WF_CONDITION WHERE FLOWID='" + flowId + "'";
        try {
            RowSet rs = DbOper.executeQuery("defaultds", sql2);
            while (rs.next()) {
                FlowConditionBean model = new FlowConditionBean();
                model.setId(rs.getInt("CONDITIONID"));
                model.setName(rs.getString("CONDITIONNAME"));
                model.setType(rs.getInt("CONDITIONTYPE"));
                model.setCompareType(rs.getInt("COMPARETYPE"));
                model.setOperandLeft(rs.getString("OPERATELEFT"));
                model.setOperandRight(rs.getString("OPERATERIGHT"));
                list.add(model);
            }
        }
        catch (SQLException exp) {
            daoLogger.error((Object)("\u5f97\u5230\u6d41\u7a0b\u7684\u6761\u4ef6\u8bbe\u7f6e\u4fe1\u606f,\u9519\u8bef\u7684Sql\u8bed\u53e5\u4e3a\uff1a\n" + sql2 + "\n FlowDao.getFlowConditions(flowId)\u9519\u8bef\u4fe1\u606f\uff1a" + exp.getMessage()));
            throw exp;
        }
        return list;
    }

    public List getFlowTrans(String flowId) throws SQLException {
        ArrayList<FlowTransBean> list = new ArrayList<FlowTransBean>();
        String sql2 = "SELECT TRANID,TRANSTYPE,FROMNODEID,TONODEID,CONDITIONID,WITHDRAW FROM [S].JXD7_WF_FLOWTRANS  WHERE FLOWID='" + flowId + "'";
        try {
            RowSet rs = DbOper.executeQuery("defaultds", sql2);
            while (rs.next()) {
                FlowTransBean model = new FlowTransBean();
                model.setId(rs.getInt("TRANID"));
                model.setType(rs.getInt("TRANSTYPE"));
                model.setFrom(rs.getInt("FROMNODEID"));
                model.setTo(rs.getInt("TONODEID"));
                model.setCondition(rs.getInt("CONDITIONID"));
                model.setCanUntread(rs.getBoolean("WITHDRAW"));
                list.add(model);
            }
        }
        catch (SQLException exp) {
            daoLogger.error((Object)("\u5f97\u5230\u6d41\u7a0b\u7684\u8f6c\u79fb\u4fe1\u606f,\u9519\u8bef\u7684Sql\u8bed\u53e5\u4e3a\uff1a\n" + sql2 + "\n FlowDao.getFlowTrans(flowId)\u9519\u8bef\u4fe1\u606f\uff1a" + exp.getMessage()));
            throw exp;
        }
        return list;
    }

    public List getFlowEvents(String flowId) throws SQLException {
        ArrayList<FlowEventBean> list = new ArrayList<FlowEventBean>();
        String sql2 = "SELECT FLOWNODEID,FE.EVENTID,XE.EVENTCODE, ACTIONTYPE, ACTIONNAME FROM [S].JXD7_WF_EVENT FE,[S].JXD7_XT_EVENT XE WHERE FLOWID='" + flowId + "' AND FE.EVENTID=XE.EVENTID";
        try {
            RowSet rs = DbOper.executeQuery("defaultds", sql2);
            while (rs.next()) {
                FlowEventBean model = new FlowEventBean();
                model.setNodeId(rs.getInt("FLOWNODEID"));
                model.setEventId(rs.getInt("EVENTID"));
                model.setActionType(rs.getInt("ACTIONTYPE"));
                model.setEventCode(rs.getString("EVENTCODE"));
                model.setAction(rs.getString("ACTIONNAME"));
                list.add(model);
            }
        }
        catch (SQLException exp) {
            daoLogger.error((Object)("\u8bfb\u53d6\u6d41\u7a0b\u52a8\u4f5c\u9519\u8bef,\u9519\u8bef\u7684Sql\u8bed\u53e5\u4e3a\uff1a\n" + sql2 + "\n getFlowEvents\u9519\u8bef\u4fe1\u606f\uff1a" + exp.getMessage()));
            throw exp;
        }
        return list;
    }

    public List getChildFlow(String flowId) throws SQLException {
        ArrayList<FlowNodeChildBean> list = new ArrayList<FlowNodeChildBean>();
        String sql2 = "SELECT FLOWNODEID,CHILDFLOWVERSIONID, BEMULCHILD, INVOKETYPE, PARAMVALUE, ITERATORID, ITERATORVAR FROM [S].JXD7_WF_CHILD WHERE FLOWID='" + flowId + "'";
        try {
            RowSet rs = DbOper.executeQuery("defaultds", sql2);
            while (rs.next()) {
                FlowNodeChildBean model = new FlowNodeChildBean();
                model.setFlowNodeId(rs.getInt("FLOWNODEID"));
                model.setChildFlow(rs.getString("CHILDFLOWVERSIONID"));
                model.setBeMulChild(rs.getInt("BEMULCHILD"));
                model.setInvokeType(rs.getInt("INVOKETYPE"));
                model.setParameterValue(rs.getString("PARAMVALUE"));
                model.setIteratorId(rs.getInt("ITERATORID"));
                model.setIteratorVar(rs.getInt("ITERATORVAR"));
                list.add(model);
            }
        }
        catch (SQLException exp) {
            daoLogger.error((Object)("\u8bfb\u53d6\u5b50\u6d41\u7a0b\u9519\u8bef,\u9519\u8bef\u7684Sql\u8bed\u53e5\u4e3a\uff1a\n" + sql2 + "\n \u9519\u8bef\u4fe1\u606f\uff1a" + exp.getMessage()));
            throw exp;
        }
        return list;
    }

    public List getFlowInterFace(String flowId) throws SQLException {
        ArrayList<FlowInterFaceBean> list = new ArrayList<FlowInterFaceBean>();
        String sql2 = "SELECT I.INTERFACEID,I.INTERFACENAME,I.INTERFACETYPE,I.INTERFACEPATH,I.INTERFACEMETHOD,I.INTERFACEPARAM,F.FLOWID,F.NODEID,F.PARAMVALUE,F.ISWAIT,F.WAITTIME,F.RETURNTYPE,F.FUNCTIONID,F.REQUESTEXCEPTION,F.REQUESTTIMEOUT FROM [S].JXD7_WF_NODEINTERFACE F,[S].JXD7_XT_INTERFACE I WHERE F.INTERFACEID=I.INTERFACEID AND FLOWID='" + flowId + "'";
        try {
            RowSet rs = DbOper.executeQuery("defaultds", sql2);
            while (rs.next()) {
                FlowInterFaceBean model = new FlowInterFaceBean();
                model.setInterfaceId(rs.getString("INTERFACEID"));
                model.setInterfaceName(rs.getString("INTERFACENAME"));
                model.setInterfaceType(rs.getInt("INTERFACETYPE"));
                model.setInterfacePath(rs.getString("INTERFACEPATH"));
                model.setInterfaceMethod(rs.getString("INTERFACEMETHOD"));
                model.setInterfaceParam(rs.getString("INTERFACEPARAM"));
                model.setFlowId(rs.getString("FLOWID"));
                model.setFlowNodeId(rs.getInt("NODEID"));
                model.setFlowInterfaceParam(rs.getString("PARAMVALUE"));
                model.setWait(rs.getInt("ISWAIT"));
                model.setWaitSeconds(rs.getInt("WAITTIME"));
                model.setReturnType(rs.getInt("RETURNTYPE"));
                model.setCallbackId(rs.getString("FUNCTIONID"));
                model.setFailure(rs.getString("REQUESTEXCEPTION"));
                model.setTimeout(rs.getInt("REQUESTTIMEOUT"));
                list.add(model);
            }
        }
        catch (SQLException exp) {
            daoLogger.error((Object)("\u8bfb\u53d6\u6d41\u7a0b\u5916\u90e8\u63a5\u53e3\u9519\u8bef,\u9519\u8bef\u7684Sql\u8bed\u53e5\u4e3a\uff1a\n" + sql2 + "\n \u9519\u8bef\u4fe1\u606f\uff1a" + exp.getMessage()));
            throw exp;
        }
        return list;
    }

    public FlowInterFaceBean getInterFace(String interfaceId) throws SQLException {
        FlowInterFaceBean model = null;
        String sql2 = "SELECT I.INTERFACEID,I.INTERFACENAME,I.INTERFACETYPE,I.INTERFACEPATH,I.INTERFACEMETHOD,I.INTERFACEPARAM FROM [S].JXD7_XT_INTERFACE I WHERE I.INTERFACEID='" + interfaceId + "'";
        try {
            RowSet rs = DbOper.executeQuery("defaultds", sql2);
            if (rs.next()) {
                model = new FlowInterFaceBean();
                model.setInterfaceId(rs.getString("INTERFACEID"));
                model.setInterfaceName(rs.getString("INTERFACENAME"));
                model.setInterfaceType(rs.getInt("INTERFACETYPE"));
                model.setInterfacePath(rs.getString("INTERFACEPATH"));
                model.setInterfaceMethod(rs.getString("INTERFACEMETHOD"));
                model.setInterfaceParam(rs.getString("INTERFACEPARAM"));
            }
        }
        catch (SQLException exp) {
            daoLogger.error((Object)("\u8bfb\u53d6\u5916\u90e8\u63a5\u53e3\u9519\u8bef,\u9519\u8bef\u7684Sql\u8bed\u53e5\u4e3a\uff1a\n" + sql2 + "\n \u9519\u8bef\u4fe1\u606f\uff1a" + exp.getMessage()));
            throw exp;
        }
        return model;
    }

    public List getFlowFormVariable(String flowId) throws SQLException {
        ArrayList<FormVariableBean> list = new ArrayList<FormVariableBean>();
        String sql2 = "SELECT VARID,VARPATH ,FLOWFORMID,VARNAME,VARTYPE  FROM [S].JXD7_WF_FORMVAR WHERE FLOWID='" + flowId + "'";
        try {
            RowSet rs = DbOper.executeQuery("defaultds", sql2);
            while (rs.next()) {
                FormVariableBean model = new FormVariableBean();
                model.setId(rs.getInt("VARID"));
                model.setPath(rs.getString("VARPATH"));
                model.setFormId(rs.getInt("FLOWFORMID"));
                model.setName(rs.getString("VARNAME"));
                model.setType(rs.getInt("VARTYPE"));
                list.add(model);
            }
        }
        catch (SQLException exp) {
            daoLogger.error((Object)("\u8bfb\u53d6\u6d41\u7a0b\u8868\u5355\u53d8\u91cf\u9519\u8bef,\u9519\u8bef\u7684Sql\u8bed\u53e5\u4e3a\uff1a\n" + sql2 + "\n FlowDao.getFlowFormVariable\u9519\u8bef\u4fe1\u606f\uff1a" + exp.getMessage()));
            throw exp;
        }
        return list;
    }

    public List getFlowFormVariableLimit(String flowId) throws SQLException {
        ArrayList<FormVariableLimitBean> list = new ArrayList<FormVariableLimitBean>();
        String sql2 = "SELECT A.VARID,B.FLOWFORMID,A.FLOWNODEID,A.LIMIT,B.VARPATH  FROM [S].JXD7_WF_FORMVARLIMIT A,[S].JXD7_WF_FORMVAR B WHERE A.VARID = B.VARID AND A.FLOWID=B.FLOWID AND A.FLOWID='" + flowId + "'";
        try {
            RowSet rs = DbOper.executeQuery("defaultds", sql2);
            while (rs.next()) {
                FormVariableLimitBean model = new FormVariableLimitBean();
                model.setId(rs.getInt("VARID"));
                model.setNodeId(rs.getInt("FLOWNODEID"));
                model.setFlowFormId(rs.getInt("FLOWFORMID"));
                model.setLimit(rs.getInt("LIMIT"));
                model.setPath(rs.getString("VARPATH"));
                list.add(model);
            }
        }
        catch (SQLException exp) {
            daoLogger.error((Object)("\u8bfb\u53d6\u6d41\u7a0b\u8868\u5355\u53d8\u91cf\u7684\u6743\u9650\u9519\u8bef,\u9519\u8bef\u7684Sql\u8bed\u53e5\u4e3a\uff1a\n" + sql2 + "\n FlowDao.getFlowFormVariableLimit\u9519\u8bef\u4fe1\u606f\uff1a" + exp.getMessage()));
            throw exp;
        }
        return list;
    }

    public List getFlowActor(String flowId) throws SQLException {
        ArrayList<FlowActorBean> list = new ArrayList<FlowActorBean>();
        String sql2 = "SELECT  FLOWNODEID,ACTORTYPE,ACTORDATA FROM [S].JXD7_WF_ACTOR WHERE FLOWID='" + flowId + "'";
        try {
            RowSet rs = DbOper.executeQuery("defaultds", sql2);
            while (rs.next()) {
                FlowActorBean model = new FlowActorBean();
                model.setNodeId(rs.getInt("FLOWNODEID"));
                model.setType(rs.getInt("ACTORTYPE"));
                model.setData(rs.getString("ACTORDATA"));
                list.add(model);
            }
        }
        catch (SQLException exp) {
            daoLogger.error((Object)("\u8bfb\u53d6\u6d41\u7a0b\u8282\u70b9\u4e0a\u63a5\u53d7\u4eba\u5458\u9519\u8bef,\u9519\u8bef\u7684Sql\u8bed\u53e5\u4e3a\uff1a\n" + sql2 + "\n FlowDao.getFlowActor\u9519\u8bef\u4fe1\u606f\uff1a" + exp.getMessage()));
            throw exp;
        }
        return list;
    }

    public String getFlowVersionId(String flowVersion) throws SQLException {
        String flowVersionId = null;
        String sql2 = "SELECT FLOWID FROM [S].JXD7_WF_FLOW WHERE FLOWVERSION='" + flowVersion + "' AND STARTUPTIME<='" + DateTool.getNow() + "' AND (TERMINATE IS NULL OR TERMINATE='' OR TERMINATE>='" + DateTool.getNow() + "') AND DATASTATUSID<>" + DataStatus.DELETE + " ORDER BY VERSIONID DESC";
        try {
            flowVersionId = (String)DbOper.executeQueryObject("defaultds", sql2);
        }
        catch (SQLException exp) {
            daoLogger.error((Object)("\u8bfb\u53d6\u6d41\u7a0b\u7248\u672c\u7f16\u7801\u5931\u8d25,\u9519\u8bef\u4e3a:\nsql\u4e3a\uff1a" + sql2));
            throw exp;
        }
        return flowVersionId;
    }

    public TreeMap getFlowCell(String flowId) throws SQLException {
        FlowCellBean flowCell = null;
        RowSet rs = null;
        TreeMap<String, FlowCellBean> flowCellMap = new TreeMap<String, FlowCellBean>();
        int flowCellId = -1;
        StringBuffer output = new StringBuffer();
        output.append("SELECT FLOWCELLID,CELLTYPE,CELLLABEL,WAYPOINT,LINEWIDTH,TEXTCOLOR,BORDERCOLOR,FONT");
        output.append(",x1,y1,x2,y2,X3,Y3 FROM ");
        output.append("[S].JXD7_WF_FLOWCELL");
        output.append(" WHERE FLOWID='").append(flowId).append("'");
        output.append(" ORDER BY FLOWCELLID");
        String sql2 = output.toString();
        try {
            rs = DbOper.executeQuery("defaultds", sql2);
            while (rs != null && rs.next()) {
                flowCell = new FlowCellBean();
                flowCellId = rs.getInt("flowCellId");
                flowCell.setFlowCellid(flowCellId);
                flowCell.setX1(rs.getInt("x1"));
                flowCell.setX2(rs.getInt("x2"));
                flowCell.setY1(rs.getInt("y1"));
                flowCell.setY2(rs.getInt("y2"));
                flowCell.setCellType(rs.getInt("cellType"));
                flowCell.setCellLabel(rs.getString("CELLLABEL"));
                flowCell.setWayPoint(rs.getString("wayPoint"));
                flowCell.setX3(rs.getInt("X3"));
                flowCell.setY3(rs.getInt("Y3"));
                flowCell.setLineWidth(rs.getInt("LINEWIDTH"));
                flowCell.setTextcolor(rs.getString("TEXTCOLOR"));
                flowCell.setBordercolor(rs.getString("BORDERCOLOR"));
                flowCell.setFont(rs.getString("FONT"));
                flowCellMap.put(String.valueOf(flowCellId), flowCell);
            }
        }
        catch (SQLException exp) {
            daoLogger.error((Object)("\u8bfb\u53d6\u6d41\u7a0b\u5143\u4ef6\u5931\u8d25,\u9519\u8bef\u4e3a:\nsql\u4e3a\uff1a" + sql2));
            throw exp;
        }
        return flowCellMap;
    }

    public List getFlowAgent(String flowId) {
        ArrayList<FlowAgentBean> list = new ArrayList<FlowAgentBean>();
        String sql2 = "SELECT A.FLOWNODEID,B.AGENTTYPE,B.AGENTFROMTYPE,B.AGENTFROM,B.AGENTTOTYPE,B.AGENTTO, B.STARTTIME,B.ENDTIME,B.REASON  FROM [S].JXD7_WF_AGENT B,[S].JXD7_WF_AGENTFLOW A WHERE B.AGENTTYPE=1 AND A.AGENTID=B.AGENTID AND STARTTIME<='" + DateTool.getNow() + "' AND ENDTIME>='" + DateTool.getNow() + "' AND A.FLOWID='" + flowId + "'" + " UNION " + "SELECT -1 AS FLOWNODEID,B.AGENTTYPE,B.AGENTFROMTYPE,B.AGENTFROM,B.AGENTTOTYPE,B.AGENTTO,B.STARTTIME,B.ENDTIME,B.REASON " + " FROM [S].JXD7_WF_AGENT B WHERE B.AGENTTYPE=0 " + " AND NOT EXISTS(SELECT 1 FROM [S].JXD7_WF_AGENTFLOW A WHERE A.AGENTID=B.AGENTID " + " AND A.FLOWID='" + flowId + "')AND STARTTIME<='" + DateTool.getNow() + "' AND ENDTIME>='" + DateTool.getNow() + "'";
        try {
            RowSet rs = DbOper.executeQuery("defaultds", sql2);
            while (rs.next()) {
                FlowAgentBean model = new FlowAgentBean();
                model.setNodeId(rs.getInt("FLOWNODEID"));
                model.setFlowId(flowId);
                model.setAgentFromType(rs.getInt("AGENTFROMTYPE"));
                model.setAgentFrom(rs.getString("AGENTFROM"));
                model.setAgentToType(rs.getInt("AGENTTOTYPE"));
                model.setAgentTo(rs.getString("AGENTTO"));
                model.setStartTime(rs.getString("STARTTIME"));
                model.setEndTime(rs.getString("ENDTIME"));
                model.setReson(rs.getString("REASON"));
                list.add(model);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return list;
    }

    public void saveFlowAgent(FlowAgentBean model, DataModify curDataModify) {
        StringBuffer sql2 = new StringBuffer(128);
        if (curDataModify.is(DataModify.NEW)) {
            sql2.append("INSERT INTO [S].JXD7_WF_AGENT");
            sql2.append("(");
            sql2.append("\tAGENTID,");
            sql2.append("\tAGENTTYPE,");
            sql2.append("\tSTARTTIME,");
            sql2.append("\tENDTIME,");
            sql2.append("\tREASON,");
            sql2.append("\tAGENTFROMTYPE,");
            sql2.append("\tAGENTFROM,");
            sql2.append("\tAGENTTOTYPE,");
            sql2.append("\tAGENTTO");
            sql2.append(")");
            sql2.append("VALUES");
            sql2.append("(");
            sql2.append("\t'" + model.getAgengtId() + "',");
            sql2.append("\t" + model.getAgentType() + ",");
            sql2.append("\t'" + model.getStartTime() + "',");
            sql2.append("\t'" + model.getEndTime() + "',");
            sql2.append("\t'" + model.getReson() + "',");
            sql2.append("\t" + model.getAgentFromType() + ",");
            sql2.append("\t'" + model.getAgentFrom() + "',");
            sql2.append("\t" + model.getAgentToType() + ",");
            sql2.append("\t'" + model.getAgentTo() + "'");
            sql2.append(")");
        } else if (curDataModify.is(DataModify.DELETE)) {
            sql2.append("DELETE FROM [S].JXD7_WF_AGENT WHERE AGENTID='" + model.getAgengtId() + "'");
        } else {
            sql2.append("UPDATE [S].JXD7_WF_AGENT");
            sql2.append(" SET");
            sql2.append("\tSTARTTIME = '" + model.getStartTime() + "',");
            sql2.append("\tENDTIME = '" + model.getEndTime() + "',");
            sql2.append("\tREASON = '" + model.getReson() + "' ");
            sql2.append(" WHERE AGENTID='" + model.getAgengtId() + "'");
        }
        try {
            DbOper.executeNonQuery("defaultds", sql2.toString());
        }
        catch (SQLException e) {
            daoLogger.error((Object)("\u8bfb\u53d6\u6307\u5b9a\u6d41\u7a0b\u4e0b\u7684\u6240\u6709\u7684\u6d41\u7a0b\u4ee3\u7406\u4fe1\u606f,\u9519\u8bef\u4e3a:\nsql\u4e3a\uff1a" + sql2));
        }
    }

    public List loadAgentInfoById(String agentId) {
        ArrayList<FlowAgentBean> list = new ArrayList<FlowAgentBean>();
        String sql2 = "SELECT A.AGENTID, A.AGENTTYPE, A.STARTTIME, A.ENDTIME, A.REASON, A.AGENTFROMTYPE,  A.AGENTFROM, (SELECT UU.USERNAME FROM [S].JXD7_XT_USER UU WHERE UU.USERID=A.AGENTFROM) AS AGENTFROMNAME,A.AGENTTOTYPE, A.AGENTTO,B.FLOWID, B.FLOWNODEID ,(SELECT F.FLOWNAME FROM JXD7_WF_FLOW F WHERE F.FLOWID=B.FLOWID)AS FLOWNAME,(SELECT N.FLOWNODENAME       FROM [S].JXD7_WF_FLOWNODE N WHERE N.FLOWID=B.FLOWID AND N.FLOWNODEID=B.FLOWNODEID) AS NODENAME,(CASE WHEN A.AGENTTOTYPE=0 THEN (SELECT U.USERNAME                                   FROM [S].JXD7_XT_USER U WHERE U.USERID=A.AGENTTO)      WHEN A.AGENTTOTYPE=1 THEN (SELECT R.SHEETNAME                                    FROM [S].JXD7_XT_ROLE R WHERE R.SHEETID=A.AGENTTO)      ELSE (SELECT D.ORGANISENAME              FROM [S].JXD7_XT_ORGANISE D WHERE D.ORGANISEID=A.AGENTID)                                    END) AS AGENTTONAME FROM [S].JXD7_WF_AGENT A  LEFT JOIN [S].JXD7_WF_AGENTFLOW B ON A.AGENTID=B.AGENTID  WHERE  A.AGENTID='" + agentId + "'";
        try {
            RowSet rs = DbOper.executeQuery("defaultds", sql2);
            while (rs.next()) {
                FlowAgentBean model = new FlowAgentBean();
                model.setAgengtId(agentId);
                model.setAgentFrom(rs.getString("AGENTFROM"));
                model.setAgentTo(rs.getString("AGENTTO"));
                model.setAgentType(rs.getInt("AGENTTYPE"));
                model.setStartTime(rs.getString("STARTTIME"));
                model.setEndTime(rs.getString("ENDTIME"));
                model.setFlowId(rs.getString("FLOWID"));
                model.setNodeId(rs.getInt("FLOWNODEID"));
                model.setReson(rs.getString("REASON"));
                model.setAgentFromName(rs.getString("AGENTFROMNAME"));
                model.setAgentToName(rs.getString("AGENTTONAME"));
                model.setFlowName(rs.getString("FLOWNAME"));
                model.setNodeName(rs.getString("NODENAME"));
                list.add(model);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return list;
    }

    public void saveAgentFlow(String AgentId, String flowId, String NodeId, DataModify curDataModify) {
        StringBuffer sql2 = new StringBuffer(128);
        if (curDataModify.is(DataModify.NEW)) {
            sql2.append("INSERT INTO [S].JXD7_WF_AGENTFLOW");
            sql2.append("(");
            sql2.append("AGENTID,");
            sql2.append("FLOWID,");
            sql2.append("FLOWNODEID");
            sql2.append(")");
            sql2.append("VALUES");
            sql2.append("(");
            sql2.append("'" + AgentId + "',");
            sql2.append("'" + flowId + "',");
            sql2.append(NodeId);
            sql2.append(")");
        } else if (curDataModify.is(DataModify.DELETE)) {
            sql2.append("DELETE FROM [S].JXD7_WF_AGENTFLOW WHERE AGENTID='" + AgentId + "'");
        }
        try {
            DbOper.executeNonQuery("defaultds", sql2.toString());
        }
        catch (SQLException e) {
            daoLogger.error((Object)("\u4fdd\u5b58\u5b8c\u5168\u4ee3\u7406\u4e2d\u7684\u4f8b\u5916\u6d41\u7a0b\u6570\u636e\u4fe1\u606f,\u9519\u8bef\u4e3a:\nsql\u4e3a\uff1a" + sql2.toString()));
        }
    }

    public void delFlowAgent(String agentId) {
        StringBuffer sql2 = new StringBuffer(128);
        sql2.append("DELETE FROM [S].JXD7_WF_AGENT WHERE AGENTID='" + agentId + "'");
        try {
            DbOper.executeNonQuery("defaultds", sql2.toString());
        }
        catch (SQLException e) {
            daoLogger.error((Object)("\u5220\u9664\u6307\u5b9a\u7684\u4ee3\u7406\u4fe1\u606f\u51fa\u9519,\u9519\u8bef\u4e3a:\nsql\u4e3a\uff1a" + sql2.toString()));
        }
        sql2.delete(0, sql2.length());
        sql2.append("DELETE FROM [S].JXD7_WF_AGENTFLOW WHERE AGENTID='" + agentId + "'");
        try {
            DbOper.executeNonQuery("defaultds", sql2.toString());
        }
        catch (SQLException e) {
            daoLogger.error((Object)("\u5220\u9664\u6307\u5b9a\u7684\u4ee3\u7406\u4e2d\u7684\u6d41\u7a0b\u4fe1\u606f\u51fa\u9519,\u9519\u8bef\u4e3a:\nsql\u4e3a\uff1a" + sql2.toString()));
        }
    }

    public void saveFlowInterFaceInstance(FlowInterFaceInstanceBean instance) {
    }

    public Map<String, Integer> getFlowNodeActors_M(String flowId, int nodeId) {
        String sql2 = this.getFlowNodeActors_MSql(flowId, nodeId);
        HashMap<String, Integer> actors = new HashMap<String, Integer>();
        try {
            RowSet FlowNodeActorrs = DbOper.executeQuery("defaultds", sql2);
            while (FlowNodeActorrs.next()) {
                String userId = FlowNodeActorrs.getString("USERID");
                String userType = FlowNodeActorrs.getString("USERTYPE");
                actors.put(userId, Integer.parseInt(userType));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            daoLogger.error((Object)("\u8bfb\u53d6\u6d41\u7a0b\u8282\u70b9\u6743\u9650\u7ec4\u4eba\u5458\u51fa\u9519\uff0c\u9519\u8bef\u4e3a:\nsql\u4e3a\uff1a" + sql2));
        }
        return actors;
    }

    protected String getFlowNodeActors_MSql(String flowId, int nodeId) {
        StringBuffer mobileFlowNodeActorSql = new StringBuffer();
        mobileFlowNodeActorSql.append("SELECT USERID,USERTYPE,FLOWNODEID FROM JXD7_QX_USERGROUP G,JXD7_WF_FLOWNODE N ").append("where N.LIMITGROUPIDS LIKE '%'+G.GROUPID+'%' AND FLOWID='").append(flowId).append("' AND FLOWNODEID='").append(nodeId).append("'");
        return mobileFlowNodeActorSql.toString();
    }
}

