/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.workflow.dao;

import com.sdjxd.pms.platform.data.DbOper;
import com.sdjxd.pms.platform.data.DbSession;
import com.sdjxd.pms.platform.organize.User;
import com.sdjxd.pms.platform.tool.DateTool;
import com.sdjxd.pms.platform.workflow.model.flowbatchsubmit.FlowInsBean;
import com.sdjxd.pms.platform.workflow.model.flowbatchsubmit.NodeInsBean;
import com.sdjxd.pms.platform.workflow.model.flowbatchsubmit.Receiver;
import com.sdjxd.pms.platform.workflow.service.Flow;
import com.sdjxd.pms.platform.workflow.service.FlowActor;
import com.sdjxd.pms.platform.workflow.service.FlowActorCreater;
import com.sdjxd.pms.platform.workflow.service.FlowActorList;
import com.sdjxd.pms.platform.workflow.service.FlowActorNodeOperator;
import com.sdjxd.pms.platform.workflow.service.FlowActorParam;
import com.sdjxd.pms.platform.workflow.service.FlowNode;
import com.sdjxd.pms.platform.workflow.service.FlowTrans;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.sql.RowSet;

public class FlowBatchSubmitDao {
    private static List<String> getFlowInsArr(List<String> flowInsIdArr) throws Exception {
        ArrayList<FlowInsBean> flowInsArr = new ArrayList<FlowInsBean>();
        String flowInsIds = DbOper.toInSql(flowInsIdArr);
        StringBuilder insSql = new StringBuilder().append("select f.flowinstanceid,").append("       f.flowid,").append("       n.flownodeid,").append("       n.nodeinstanceid,").append("       f.createuser,").append("       f.createusername").append("  from jxd7_wf_instance f").append("  left join (select flowinstanceid,").append("                    flownodeid,").append("                    flowid,").append("                    nodeinstanceid").append("               from jxd7_wf_nodeInstance t1").append("              where not exists (select 1 from jxd7_wf_nodeInstance t2 where t1.flowinstanceid = t2.flowinstanceid and t1.nodeinstanceid < t2.nodeinstanceid)) n").append("    on f.flowinstanceid = n.flowinstanceid").append(" where f.flowinstanceid in (").append(flowInsIds).append(")").append("   and f.runstatus = 0");
        RowSet insRs = DbOper.executeQuery(insSql.toString());
        while (insRs.next()) {
            String flowId = insRs.getString("flowid");
            String flowInstanceId = insRs.getString("flowinstanceid");
            int nodeId = insRs.getInt("flownodeid");
            int nodeInstanceId = insRs.getInt("nodeinstanceid");
            String createUser = insRs.getString("createuser");
            String createUserName = insRs.getString("createusername");
            Flow flow = Flow.getFlow(flowId);
            FlowInsBean flowIns = new FlowInsBean();
            flowIns.setNextNodeInstanceId(nodeInstanceId + 1);
            flowIns.setCreateUserName(createUserName);
            flowIns.setCreateUserId(createUser);
            flowIns.setFlowInstanceId(flowInstanceId);
            flowIns.setFlow(flow);
            FlowNode node = flow.getNodeById(nodeId);
            NodeInsBean nodeIns = new NodeInsBean();
            nodeIns.setNodeInstanceId(nodeInstanceId);
            nodeIns.setNode(node);
            flowIns.setCurrentNodeIns(nodeIns);
            flowInsArr.add(flowIns);
        }
        return FlowBatchSubmitDao.setNextNode(flowInsArr);
    }

    private static List<String> setNextNode(List<FlowInsBean> flowInsArr) throws Exception {
        ArrayList<String> sqlList = new ArrayList<String>();
        for (FlowInsBean flowIns : flowInsArr) {
            FlowBatchSubmitDao.setNextNodeAndUser(flowIns);
            sqlList.addAll(FlowBatchSubmitDao.getSqlList(flowIns));
        }
        return sqlList;
    }

    private static void setNextNodeAndUser(FlowInsBean flowIns) throws Exception {
        NodeInsBean curentNodeIns = flowIns.getCurrentNodeIns();
        FlowNode node = curentNodeIns.getNode();
        Map tranMap = node.getNextTrans();
        for (Map.Entry entry : tranMap.entrySet()) {
            FlowTrans tran = (FlowTrans)entry.getValue();
            FlowNode toNode = tran.getTo();
            NodeInsBean nodeIns = new NodeInsBean();
            nodeIns.setNode(toNode);
            flowIns.addNextNodesIns(nodeIns);
            List actorList = toNode.getFlowActors();
            for (FlowActor actor : actorList) {
                if (actor instanceof FlowActorList) {
                    throw new Exception("\u672a\u5b9e\u73b0\u53c2\u4e0e\u8005\u5217\u8868");
                }
                if (actor instanceof FlowActorCreater) {
                    Receiver receiver = new Receiver();
                    receiver.setId(flowIns.getCreateUserId());
                    receiver.setName(flowIns.getCreateUserName());
                    receiver.setType(0);
                    nodeIns.addReceiver(receiver);
                    continue;
                }
                if (actor instanceof FlowActorNodeOperator) {
                    throw new Exception("\u672a\u5b9e\u73b0\u8282\u70b9\u5904\u7406\u4eba");
                }
                if (actor instanceof FlowActorParam) {
                    throw new Exception("\u672a\u5b9e\u73b0\u6d41\u7a0b\u53c2\u6570");
                }
                throw new Exception("\u672a\u5b9e\u73b0\u81ea\u5b9a\u4e49\u53c2\u4e0e\u8005");
            }
        }
    }

    private static List<String> getSqlList(FlowInsBean flowIns) {
        ArrayList<String> list = new ArrayList<String>();
        User user = User.getCurrentUser();
        String userId = user.getId();
        String userName = user.getName();
        String createTime = DateTool.getNow();
        StringBuffer sb = new StringBuffer();
        sb.delete(0, sb.length());
        sb.append("update jxd7_wf_nodeinstance").append("   set runstatus           = '1',").append("       runstatusnote_stop  = '6',").append("       endtime  = '").append(createTime).append("',").append("       notes               = notes + ' \u6279\u91cf\u63d0\u4ea4',").append("       nextNodeinstanceids = '[").append(flowIns.getCurrentNodeIns().getNextNodeInsId()).append("]'").append(" where nodeinstanceid = '").append(flowIns.getCurrentNodeIns().getNodeInstanceId()).append("'").append("   and runstatus = 0").append("   and flowinstanceid = '").append(flowIns.getFlowInstanceId()).append("'");
        list.add(sb.toString());
        sb.delete(0, sb.length());
        sb.append("insert into jxd7_wf_operator (flowinstanceid,nodeinstanceid,operator,operatorname,begintime,endtime,type)values(").append("'").append(flowIns.getFlowInstanceId()).append("',").append(flowIns.getCurrentNodeIns().getNodeInstanceId()).append(",'").append(userId).append("','").append(userName).append("','").append(createTime).append("','").append(createTime).append("',0)");
        list.add(sb.toString());
        sb.delete(0, sb.length());
        sb.append("delete from jxd7_xt_waitdo").append(" where oper2 = '").append(flowIns.getFlowInstanceId()).append("'");
        list.add(sb.toString());
        List<NodeInsBean> nextNodeInsArr = flowIns.getNextNodesIns();
        for (NodeInsBean nodeIns : nextNodeInsArr) {
            sb.delete(0, sb.length());
            sb.append("insert into jxd7_wf_nodeinstance(flowinstanceid,nodeinstanceid,flowid,flowname,flownodeid,flownodename,runstatus,endtime,begintime,prenodeinstanceids,createdate,createuserid,createusername,takestatus,notes,vnextnodeinstanceid,vprenodeinstanceid,nextNodeinstanceids,runstatusnote_stop,runstatusnote_start)values( '").append(flowIns.getFlowInstanceId()).append("','").append(nodeIns.getNodeInstanceId()).append("','").append(flowIns.getFlow().getId()).append("','").append(flowIns.getFlow().getFlowName()).append("',").append(nodeIns.getNode().getId()).append(",'").append(nodeIns.getNode().getName());
            if (nodeIns.getNode().getNodeType() == 3) {
                sb.append("',1,'").append(createTime).append("','");
            } else {
                sb.append("',0,'','");
            }
            sb.append(createTime).append("',").append("'[").append(flowIns.getCurrentNodeIns().getNodeInstanceId()).append("]' ,'").append(createTime).append("','").append(userId).append("','").append(userName).append("',0,'',-1,-1,'[]',0 ,2 )");
            list.add(sb.toString());
            if (nodeIns.getNode().getNodeType() == 3) {
                sb.delete(0, sb.length());
                sb.append("update jxd7_wf_instance set runstatus = 1, enddate = '").append(createTime).append("' where flowinstanceid = '").append(flowIns.getFlowInstanceId()).append("'");
                list.add(sb.toString());
                continue;
            }
            sb.delete(0, sb.length());
            List<Receiver> receivers = nodeIns.getRecivers();
            for (Receiver receiver : receivers) {
                sb.append("insert into jxd7_wf_receiver(flowinstanceid,nodeinstanceid,operator,operatorname,type)values(").append("'").append(flowIns.getFlowInstanceId()).append("','").append(nodeIns.getNodeInstanceId()).append("','").append(receiver.getId()).append("','").append(receiver.getName()).append("','").append(receiver.getType()).append("')");
                list.add(sb.toString());
                sb.delete(0, sb.length());
                sb.append("insert into jxd7_xt_waitDo(waitdoid,operid,opername,operurl,sender,receiverType,receiver,sendtime,opercontent,opentype,moduleid,oper1,oper2,oper3) values(").append("newid(),'").append(flowIns.getFlowInstanceId()).append(nodeIns.getNodeInstanceId()).append("','").append(flowIns.getFlow().getFlowName()).append("','flow.do?i=").append(flowIns.getFlowInstanceId()).append("&n=").append(nodeIns.getNodeInstanceId()).append("&formInstanceId=&flowFormId=&flowNodeId=").append(nodeIns.getNode().getId()).append("','").append(userId).append("','").append(receiver.getType()).append("','").append(receiver.getId()).append("','").append(createTime).append("','\u6279\u91cf\u63d0\u4ea4','tab','").append(flowIns.getFlow().getModuleId()).append("','").append(flowIns.getFlow().getId()).append("','").append(flowIns.getFlowInstanceId()).append("','").append(nodeIns.getNodeInstanceId()).append("')");
                list.add(sb.toString());
            }
        }
        return list;
    }

    public static boolean batchSubmit(List<String> flowInsArr) throws SQLException {
        DbSession session = DbOper.openDb("defaultds");
        try {
            try {
                List<String> sqlList = FlowBatchSubmitDao.getFlowInsArr(flowInsArr);
                DbOper.executeNonQuery(sqlList);
            }
            catch (Exception e) {
                e.printStackTrace();
                DbOper.rollbackDb(session);
                DbOper.closeDb(session);
                return false;
            }
        }
        finally {
            DbOper.closeDb(session);
        }
        return true;
    }
}

