/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.workflow.bo;

import com.sdjxd.pms.platform.base.BaseClass;
import com.sdjxd.pms.platform.base.DataModify;
import com.sdjxd.pms.platform.organize.User;
import com.sdjxd.pms.platform.tool.DateTool;
import com.sdjxd.pms.platform.tool.Guid;
import com.sdjxd.pms.platform.tool.StringTool;
import com.sdjxd.pms.platform.workflow.bo.FlowRemindBo;
import com.sdjxd.pms.platform.workflow.bo.FlowWaitDoBo;
import com.sdjxd.pms.platform.workflow.dao.WeChartwaitDoDao;
import com.sdjxd.pms.platform.workflow.model.WaitDoConfig;
import com.sdjxd.pms.platform.workflow.service.FlowInstance;
import com.sdjxd.pms.platform.workflow.service.FlowNode;
import com.sdjxd.pms.platform.workflow.service.FlowNodeInstance;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public class FlowWeChartBo
extends BaseClass {
    private static final long serialVersionUID = 1L;
    protected static WeChartwaitDoDao dao = null;
    private FlowWaitDoBo flowWaitDoBo;
    private FlowRemindBo flwoRemindBo;

    static {
        dao = WeChartwaitDoDao.createInstance();
    }

    public static FlowWeChartBo createFlowWeChart(FlowNode flowNode, FlowInstance owner, FlowNodeInstance flowNodeInstance, int type, String receiver) throws SQLException {
        FlowWeChartBo flowWeChartBo = new FlowWeChartBo();
        String flowId = owner.getTemplet().getFlowVersion();
        String flowInstanceId = owner.getId();
        int nodeInstanceId = flowNodeInstance.getNodeInstanceId();
        WaitDoConfig waitDoConfig = flowNode.getWaitDoConfig();
        if (flowNode.isWaitDo(waitDoConfig)) {
            FlowWaitDoBo flowWaitDoBo = new FlowWaitDoBo();
            String sqlLimit = owner.replace(waitDoConfig.getSqlLimit(), nodeInstanceId);
            Map<String, String> userMap = dao.getReceiver(receiver, sqlLimit);
            if (!userMap.isEmpty()) {
                User currentUser = User.getCurrentUser();
                String senderId = "";
                String senderName = "";
                if (currentUser != null) {
                    senderId = currentUser.getId();
                    senderName = currentUser.getName();
                }
                flowWaitDoBo.setSheetid(Guid.create());
                flowWaitDoBo.setReceiver(userMap.get("userid"));
                flowWaitDoBo.setReceiverType(String.valueOf(type));
                flowWaitDoBo.setSenderId(senderId);
                flowWaitDoBo.setSenderName(senderName);
                flowWaitDoBo.setSenderTime(DateTool.getNow());
                flowWaitDoBo.setFlowId(flowId);
                flowWaitDoBo.setFlowInstanceId(flowInstanceId);
                flowWaitDoBo.setNodeInstanceId(nodeInstanceId);
                flowWaitDoBo.setAppId(waitDoConfig.getAppId());
                String title = owner.replace(waitDoConfig.getTitle(), nodeInstanceId);
                flowWaitDoBo.setTitle(title);
                String content = owner.replace(waitDoConfig.getContent(), nodeInstanceId);
                flowWaitDoBo.setContent(content);
                flowWaitDoBo.setSqlLimit(sqlLimit);
                String flowInsId = String.valueOf(flowInstanceId) + nodeInstanceId;
                HashMap<String, Integer> butonsMap = waitDoConfig.getButon();
                String url = "";
                if (!StringTool.isEmpty(waitDoConfig.getUrl())) {
                    String butonsParm = "";
                    if (butonsMap != null) {
                        butonsParm = String.valueOf(butonsParm) + "&bs=" + butonsMap.get("bs");
                        butonsParm = String.valueOf(butonsParm) + "&bu=" + butonsMap.get("bu");
                        butonsParm = String.valueOf(butonsParm) + "&bd=" + butonsMap.get("bd");
                        butonsParm = String.valueOf(butonsParm) + "&bl=" + butonsMap.get("bl");
                    }
                    url = String.valueOf(waitDoConfig.getUrl()) + "?flowInsId=" + flowInsId + butonsParm;
                }
                flowWaitDoBo.setUrl(url);
                flowWaitDoBo.setButon(waitDoConfig.getButon());
                flowWaitDoBo.setImglink(waitDoConfig.getImglink());
                flowWaitDoBo.setModify(DataModify.NEW);
            }
            flowWeChartBo.setFlowWaitDoBo(flowWaitDoBo);
            return flowWeChartBo;
        }
        return null;
    }

    public void save() throws Exception {
        if (this.getFlowWaitDoBo() != null && DataModify.NEW.equals(this.getFlowWaitDoBo().getModify())) {
            FlowWaitDoBo.sendMess(this.getFlowWaitDoBo());
        }
        if (this.getFlowWaitDoBo() != null) {
            dao.save(this.getFlowWaitDoBo());
        }
    }

    public static FlowWeChartBo delete(Map<String, String> map) throws Exception {
        FlowWeChartBo flowWeChartBo = new FlowWeChartBo();
        if (map != null) {
            FlowWaitDoBo flowWaitDoBo = new FlowWaitDoBo();
            flowWaitDoBo.setFlowInstanceId(map.get("flowInstanceId"));
            flowWaitDoBo.setNodeInstanceId(Integer.parseInt(map.get("nodeInstanceId")));
            flowWaitDoBo.setModify(DataModify.DELETE);
            flowWeChartBo.setFlowWaitDoBo(flowWaitDoBo);
            FlowRemindBo flowRemindBo = new FlowRemindBo();
            flowRemindBo.setFlowInstanceId(map.get("flowInstanceId"));
            flowRemindBo.setNodeInstanceId(Integer.parseInt(map.get("nodeInstanceId")));
            flowRemindBo.setModify(DataModify.DELETE);
            flowWeChartBo.setFlwoRemindBo(flowRemindBo);
        }
        return flowWeChartBo;
    }

    public static FlowWeChartBo delete(Map<String, String> map, String userId) throws Exception {
        FlowWeChartBo flowWeChartBo = new FlowWeChartBo();
        if (map != null) {
            FlowWaitDoBo flowWaitDoBo = new FlowWaitDoBo();
            flowWaitDoBo.setFlowInstanceId(map.get("flowInstanceId"));
            flowWaitDoBo.setNodeInstanceId(Integer.parseInt(map.get("nodeInstanceId")));
            flowWaitDoBo.setReceiver(userId);
            flowWaitDoBo.setModify(DataModify.DELETE);
            flowWeChartBo.setFlowWaitDoBo(flowWaitDoBo);
            FlowRemindBo flowRemindBo = new FlowRemindBo();
            flowRemindBo.setFlowInstanceId(map.get("flowInstanceId"));
            flowRemindBo.setNodeInstanceId(Integer.parseInt(map.get("nodeInstanceId")));
            flowRemindBo.setReceiver(userId);
            flowRemindBo.setModify(DataModify.DELETE);
            flowWeChartBo.setFlwoRemindBo(flowRemindBo);
        }
        return flowWeChartBo;
    }

    public FlowWaitDoBo getFlowWaitDoBo() {
        return this.flowWaitDoBo;
    }

    public void setFlowWaitDoBo(FlowWaitDoBo flowWaitDoBo) {
        this.flowWaitDoBo = flowWaitDoBo;
    }

    public FlowRemindBo getFlwoRemindBo() {
        return this.flwoRemindBo;
    }

    public void setFlwoRemindBo(FlowRemindBo flwoRemindBo) {
        this.flwoRemindBo = flwoRemindBo;
    }
}

