/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.webapp;

public class ServerDetector {
    public static final String GERONIMO_CLASS = "/org/apache/geronimo/system/main/Daemon.class";
    public static final String JBOSS_CLASS = "/org/jboss/Main.class";
    public static final String JETTY_CLASS = "/org/mortbay/jetty/Server.class";
    public static final String JONAS_CLASS = "/org/objectweb/jonas/server/Server.class";
    public static final String OC4J_CLASS = "/oracle/jsp/oc4jutil/Oc4jUtil.class";
    public static final String ORION_CLASS = "/com/evermind/server/ApplicationServer.class";
    public static final String PRAMATI_CLASS = "/com/pramati/Server.class";
    public static final String RESIN_CLASS = "/com/caucho/server/resin/Resin.class";
    public static final String REXIP_CLASS = "/com/tcc/Main.class";
    public static final String SUN7_CLASS = "/com/iplanet/ias/tools/cli/IasAdminMain.class";
    public static final String SUN8_CLASS = "/com/sun/enterprise/cli/framework/CLIMain.class";
    public static final String TOMCAT_CLASS = "/org/apache/catalina/startup/Bootstrap.class";
    public static final String WEBLOGIC_CLASS = "/weblogic/Server.class";
    public static final String WEBSPHERE_CLASS = "/com/ibm/websphere/product/VersionInfo.class";
    private static ServerDetector _instance = new ServerDetector();
    private String _serverId;
    private Boolean _geronimo;
    private Boolean _jBoss;
    private Boolean _jetty;
    private Boolean _jonas;
    private Boolean _oc4j;
    private Boolean _orion;
    private Boolean _pramati;
    private Boolean _resin;
    private Boolean _rexIP;
    private Boolean _sun7;
    private Boolean _sun8;
    private Boolean _tomcat;
    private Boolean _webLogic;
    private Boolean _webSphere;

    public static String getServerId() {
        ServerDetector sd = _instance;
        if (sd._serverId == null) {
            if (ServerDetector.isGeronimo()) {
                sd._serverId = "geronimo";
            } else if (ServerDetector.isJBoss()) {
                sd._serverId = "jboss";
            } else if (ServerDetector.isJOnAS()) {
                sd._serverId = "jonas";
            } else if (ServerDetector.isOC4J()) {
                sd._serverId = "oc4j";
            } else if (ServerDetector.isOrion()) {
                sd._serverId = "orion";
            } else if (ServerDetector.isResin()) {
                sd._serverId = "resin";
            } else if (ServerDetector.isWebLogic()) {
                sd._serverId = "weblogic";
            } else if (ServerDetector.isWebSphere()) {
                sd._serverId = "websphere";
            }
            if (ServerDetector.isJetty()) {
                sd._serverId = sd._serverId == null ? "jetty" : String.valueOf(sd._serverId) + "-jetty";
            } else if (ServerDetector.isTomcat()) {
                sd._serverId = sd._serverId == null ? "tomcat" : String.valueOf(sd._serverId) + "-tomcat";
            }
            if (sd._serverId == null) {
                throw new RuntimeException("Server is not supported");
            }
        }
        return sd._serverId;
    }

    public static boolean isGeronimo() {
        ServerDetector sd = _instance;
        if (sd._geronimo == null) {
            Class<?> c = sd.getClass();
            sd._geronimo = c.getResource(GERONIMO_CLASS) != null ? Boolean.TRUE : Boolean.FALSE;
        }
        return sd._geronimo;
    }

    public static boolean isJBoss() {
        ServerDetector sd = _instance;
        if (sd._jBoss == null) {
            Class<?> c = sd.getClass();
            sd._jBoss = c.getResource(JBOSS_CLASS) != null ? Boolean.TRUE : Boolean.FALSE;
        }
        return sd._jBoss;
    }

    public static boolean isJetty() {
        ServerDetector sd = _instance;
        if (sd._jetty == null) {
            Class<?> c = sd.getClass();
            sd._jetty = c.getResource(JETTY_CLASS) != null ? Boolean.TRUE : Boolean.FALSE;
        }
        return sd._jetty;
    }

    public static boolean isJOnAS() {
        ServerDetector sd = _instance;
        if (sd._jonas == null) {
            Class<?> c = sd.getClass();
            sd._jonas = c.getResource(JONAS_CLASS) != null ? Boolean.TRUE : Boolean.FALSE;
        }
        return sd._jonas;
    }

    public static boolean isOC4J() {
        ServerDetector sd = _instance;
        if (sd._oc4j == null) {
            Class<?> c = sd.getClass();
            sd._oc4j = c.getResource(OC4J_CLASS) != null ? Boolean.TRUE : Boolean.FALSE;
        }
        return sd._oc4j;
    }

    public static boolean isOrion() {
        ServerDetector sd = _instance;
        if (sd._orion == null) {
            Class<?> c = sd.getClass();
            sd._orion = c.getResource(ORION_CLASS) != null ? Boolean.TRUE : Boolean.FALSE;
        }
        return sd._orion;
    }

    public static boolean isPramati() {
        ServerDetector sd = _instance;
        if (sd._pramati == null) {
            Class<?> c = sd.getClass();
            sd._pramati = c.getResource(PRAMATI_CLASS) != null ? Boolean.TRUE : Boolean.FALSE;
        }
        return sd._pramati;
    }

    public static boolean isResin() {
        ServerDetector sd = _instance;
        if (sd._resin == null) {
            Class<?> c = sd.getClass();
            sd._resin = c.getResource(RESIN_CLASS) != null ? Boolean.TRUE : Boolean.FALSE;
        }
        return sd._resin;
    }

    public static boolean isRexIP() {
        ServerDetector sd = _instance;
        if (sd._rexIP == null) {
            Class<?> c = sd.getClass();
            sd._rexIP = c.getResource(REXIP_CLASS) != null ? Boolean.TRUE : Boolean.FALSE;
        }
        return sd._rexIP;
    }

    public static boolean isSun() {
        return ServerDetector.isSun7() || ServerDetector.isSun8();
    }

    public static boolean isSun7() {
        ServerDetector sd = _instance;
        if (sd._sun7 == null) {
            Class<?> c = sd.getClass();
            sd._sun7 = c.getResource(SUN7_CLASS) != null ? Boolean.TRUE : Boolean.FALSE;
        }
        return sd._sun7;
    }

    public static boolean isSun8() {
        ServerDetector sd = _instance;
        if (sd._sun8 == null) {
            Class<?> c = sd.getClass();
            sd._sun8 = c.getResource(SUN8_CLASS) != null ? Boolean.TRUE : Boolean.FALSE;
        }
        return sd._sun8;
    }

    public static boolean isTomcat() {
        ServerDetector sd = _instance;
        if (sd._tomcat == null) {
            Class<?> c = sd.getClass();
            sd._tomcat = c.getResource(TOMCAT_CLASS) != null ? Boolean.TRUE : Boolean.FALSE;
        }
        return sd._tomcat;
    }

    public static boolean isWebLogic() {
        ServerDetector sd = _instance;
        if (sd._webLogic == null) {
            Class<?> c = sd.getClass();
            sd._webLogic = c.getResource(WEBLOGIC_CLASS) != null ? Boolean.TRUE : Boolean.FALSE;
        }
        return sd._webLogic;
    }

    public static boolean isWebSphere() {
        ServerDetector sd = _instance;
        if (sd._webSphere == null) {
            Class<?> c = sd.getClass();
            sd._webSphere = c.getResource(WEBSPHERE_CLASS) != null ? Boolean.TRUE : Boolean.FALSE;
        }
        return sd._webSphere;
    }

    private ServerDetector() {
    }
}

