/*
 * Decompiled with CFR 0.152.
 */
package com.sdjxd.pms.platform.webapp;

import com.sdjxd.pms.platform.base.Global;
import com.sdjxd.pms.platform.data.DataSource;
import com.sdjxd.pms.platform.data.DbType;
import com.sdjxd.pms.platform.tool.BeanTool;
import java.util.Properties;
import org.apache.log4j.Logger;

public class BeanFactory {
    static Logger log = Logger.getLogger(BeanFactory.class);
    private static Properties dbProps = Global.loadProperties("beanFactory.properties");

    public static Object getSingleInstance(String className) {
        Object o = null;
        String aImplClassName = dbProps.getProperty(className);
        o = BeanTool.getSingleInstance(aImplClassName);
        return o;
    }

    public static Object getClass(String className) {
        return BeanFactory.getClass(className, null);
    }

    public static Object getClass(String className, Object[] par) {
        Object o = null;
        String aImplClassName = dbProps.getProperty(className);
        o = BeanTool.getInstance(aImplClassName, par);
        return o;
    }

    public static Object getSqlInstance(Class dao, String className, String dataSourceName) {
        String packageName = dao.getPackage().getName();
        if (packageName.endsWith(".dao")) {
            packageName = packageName.substring(0, packageName.length() - 4);
        }
        String classPath = packageName = String.valueOf(packageName) + ".sql";
        DataSource dataSource = DataSource.getDataSource(dataSourceName);
        if (dataSource != null && !DbType.SQL.equals(dataSource.getDbType())) {
            classPath = String.valueOf(classPath) + "." + dataSource.getDbType().getName();
        }
        Object sqlClass = BeanTool.isExist(classPath = String.valueOf(classPath) + "." + className) ? BeanTool.getInstance(classPath) : BeanTool.getInstance(String.valueOf(packageName) + "." + className);
        return sqlClass;
    }
}

